
-- ----------------------------
-- Table structure for xy_user_qq
-- ----------------------------
DROP TABLE IF EXISTS `xy_user_qq`;
CREATE TABLE `xy_user_qq`  (
  `id` int(0) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` int(0) NULL DEFAULT NULL COMMENT '用户ID',
  `nickname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '昵称',
  `app_openid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `pc_openid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `unionid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `gender` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '性别',
  `headimgurl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '头像',
  `city` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '城市',
  `province` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '省份',
  `create_time` int(0) NULL DEFAULT 0 COMMENT '写入时间',
  `update_time` int(0) NULL DEFAULT 0 COMMENT '最后更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uid`(`uid`) USING BTREE COMMENT '用户关联',
  UNIQUE INDEX `unionid`(`unionid`) USING BTREE,
  UNIQUE INDEX `app_openid`(`app_openid`) USING BTREE,
  UNIQUE INDEX `pc_openid`(`pc_openid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户-QQ信息' ROW_FORMAT = Dynamic;
