-- ----------------------------
-- Table structure for xy_status_alias
-- ----------------------------
DROP TABLE IF EXISTS `xy_status_alias`;
CREATE TABLE `xy_status_alias`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `alias` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `title` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `value` int(10) NULL DEFAULT 0,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `is_company` tinyint(1) NULL DEFAULT NULL,
  `status` tinyint(1) NULL DEFAULT 1,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `alias`(`alias`, `value`) USING BTREE,
  INDEX `status`(`alias`, `status`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 168 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '各类状态，分类别名' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of xy_status_alias
-- ----------------------------
INSERT INTO `xy_status_alias` VALUES (1, 'file/type', '后台设置', 0, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (2, 'file/type', '用户头像', 1, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (3, 'file/type', '后台公共上传', 2, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (4, 'file/type', '文章封面', 3, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (5, 'file/type', '文章内容', 4, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (6, 'file/type', '文章视频', 5, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (7, 'file/type', '文章文件', 6, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (8, 'company/attestation', '未认证', 0, 'info', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (9, 'company/attestation', '审核中', 1, 'primary', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (10, 'company/attestation', '未通过', 2, 'danger', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (11, 'company/attestation', '已认证', 3, 'success', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (12, 'company/nature', '国有企业', 0, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (13, 'company/nature', '集体所有制', 1, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (14, 'company/nature', '私营企业', 2, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (15, 'company/nature', '股份制企业', 3, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (16, 'company/nature', '有限合伙企业', 4, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (17, 'company/nature', '联营企业', 5, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (18, 'company/nature', '外商投资企业', 6, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (19, 'company/nature', '个人独资企业', 7, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (20, 'company/nature', '其他', 99, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (21, 'company/size_type', '20人以下', 0, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (22, 'company/size_type', '20-99人', 1, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (23, 'company/size_type', '100-499人', 2, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (24, 'company/size_type', '500-999人', 3, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (25, 'company/size_type', '1000-9999人', 4, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (26, 'company/size_type', '10000人以上', 5, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (27, 'company/corporate_welfare', '环境好', 1000, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (28, 'company/corporate_welfare', '年终奖', 1001, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (29, 'company/corporate_welfare', '双休', 1002, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (30, 'company/corporate_welfare', '五险一金', 1003, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (31, 'company/corporate_welfare', '加班费', 1004, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (32, 'company/corporate_welfare', '朝九晚五', 1005, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (33, 'company/corporate_welfare', '交通方便', 1006, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (34, 'company/corporate_welfare', '加班补助', 1007, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (35, 'company/corporate_welfare', '包食宿', 1008, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (36, 'company/corporate_welfare', '管理规范', 1009, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (37, 'company/corporate_welfare', '有提成', 1010, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (38, 'company/corporate_welfare', '全勤奖', 1011, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (39, 'company/corporate_welfare', '有年假', 1012, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (40, 'company/corporate_welfare', '专车接送', 1013, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (41, 'company/corporate_welfare', '有补助', 1014, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (42, 'company/corporate_welfare', '晋升快', 1015, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (43, 'company/corporate_welfare', '车补', 1016, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (44, 'company/corporate_welfare', '房补', 1017, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (45, 'company/corporate_welfare', '压力小', 1018, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (46, 'company/corporate_welfare', '技术培训', 1019, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (47, 'company/corporate_welfare', '旅游', 1020, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (48, 'file/type', '营业执照', 7, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (49, 'file/type', '企业LOGO', 8, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (50, 'company/nature', '事业单位', 8, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (51, 'company/finance', '未融资', 0, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (53, 'company/finance', '天使轮', 1, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (55, 'company/finance', 'A轮', 2, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (56, 'company/finance', 'A+轮', 3, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (57, 'company/finance', 'B轮', 4, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (58, 'company/finance', 'C轮', 5, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (59, 'company/finance', 'D轮及以上', 6, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (60, 'company/finance', '上市公司', 7, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (61, 'company/finance', '不需要融资', 99, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (62, 'resume/educational_background', '初中及以下', 1, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (63, 'resume/educational_background', '中专/中技', 2, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (64, 'resume/educational_background', '高中', 3, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (65, 'resume/educational_background', '大专', 4, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (66, 'resume/educational_background', '本科', 5, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (67, 'resume/educational_background', '硕士', 6, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (68, 'resume/educational_background', '博士', 7, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (69, 'resume/job_status', '离职-随时到岗', 1, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (70, 'resume/job_status', '在职-月内到岗', 2, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (71, 'resume/job_status', '在职-考虑机会', 3, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (72, 'resume/job_status', '在职-暂不考虑', 4, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (73, 'resume/nature_of_work', '全职', 1, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (74, 'resume/nature_of_work', '兼职', 2, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (75, 'resume/nature_of_work', '实习', 3, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (76, 'jobs/education_level', '学历不限', 0, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (77, 'jobs/education_level', '初中及以下', 1, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (78, 'jobs/education_level', '中专/中技', 2, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (79, 'jobs/education_level', '高中', 3, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (80, 'jobs/education_level', '大专', 4, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (81, 'jobs/education_level', '本科', 5, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (82, 'jobs/education_level', '硕士', 6, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (83, 'jobs/education_level', '博士', 7, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (84, 'jobs/exp_level', '经验不限', 0, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (85, 'jobs/exp_level', '1-3年', 1, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (86, 'jobs/exp_level', '3-5年', 3, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (87, 'jobs/exp_level', '5-10年', 5, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (88, 'jobs/exp_level', '10-15年', 10, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (89, 'jobs/exp_level1', '15-20年', 15, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (90, 'jobs/exp_level1', '20-30年', 20, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (91, 'jobs/exp_level1', '30年以上', 30, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (92, 'jobs/delivery', '待查看', 0, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (93, 'jobs/delivery', '已查看', 1, 'info', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (94, 'jobs/delivery', '不合适', 2, 'danger', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (95, 'jobs/delivery', '面试邀请', 3, 'primary', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (96, 'jobs/delivery', '等待面试', 4, 'warning', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (97, 'jobs/delivery', '发offer', 5, 'warning', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (98, 'jobs/delivery', '完成', 6, 'success', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (99, 'file/type', '广告图片', 9, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (100, 'order/type', '会员套餐', 1, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (101, 'order/type', '下载简历', 2, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (102, 'file/type', '高管头像', 10, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (103, 'file/type', '企业照片', 11, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (104, 'vip/value_added_type', '下载简历', 2, '点', 1, 1);
INSERT INTO `xy_status_alias` VALUES (105, 'vip/value_added_type', '短信增值', 3, '条', 1, 1);
INSERT INTO `xy_status_alias` VALUES (106, 'vip/value_added_type', '职位置顶', 4, '天', 1, 1);
INSERT INTO `xy_status_alias` VALUES (107, 'vip/value_added_type', '职位紧急', 5, '天', 1, 1);
INSERT INTO `xy_status_alias` VALUES (108, 'vip/value_added_type', '企业模板', 6, '套', 1, 1);
INSERT INTO `xy_status_alias` VALUES (109, 'vip/value_added_type', '职位智能刷新', 7, '天', 1, 1);
INSERT INTO `xy_status_alias` VALUES (110, 'vip/type', '开通会员', 1, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (111, 'vip/type', '下载简历服务', 2, '', 1, 1);
INSERT INTO `xy_status_alias` VALUES (112, 'vip/type', '短信增值', 3, '', 1, 1);
INSERT INTO `xy_status_alias` VALUES (113, 'vip/type', '职位置顶', 4, '', 1, 1);
INSERT INTO `xy_status_alias` VALUES (114, 'vip/type', '职位紧急', 5, '', 1, 1);
INSERT INTO `xy_status_alias` VALUES (115, 'vip/type', '企业模板', 6, '', 1, 1);
INSERT INTO `xy_status_alias` VALUES (116, 'vip/type', '职位智能刷新', 7, '', 1, 1);
INSERT INTO `xy_status_alias` VALUES (117, 'vip/value_added_type', '简历置顶', 8, '天', 0, 1);
INSERT INTO `xy_status_alias` VALUES (118, 'vip/value_added_type', '简历智能刷新', 9, '天', 0, 1);
INSERT INTO `xy_status_alias` VALUES (119, 'vip/type', '简历置顶', 8, '', 0, 1);
INSERT INTO `xy_status_alias` VALUES (120, 'vip/type', '简历智能刷新', 9, '', 0, 1);
INSERT INTO `xy_status_alias` VALUES (121, 'message/type', '后台发送', 0, 'sendSiteMsg', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (122, 'vip/type', '积分充值', 10, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (123, 'message/type', '订单支付', 1, 'orderPaySuccess', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (124, 'message/type', '及时消息', 2, 'sendClientMsg', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (125, 'vip/type', '下载简历', 11, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (126, 'feedback/type', '反馈', 1, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (127, 'feedback/type', 'BUG', 2, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (128, 'feedback/type', '投诉', 3, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (129, 'feedback/type', '建议', 4, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (130, 'feedback/type', '账号申诉', 5, '', 0, 1);
INSERT INTO `xy_status_alias` VALUES (131, 'feedback/type', '投诉简历', 6, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (132, 'feedback/type', '投诉职位', 7, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (133, 'message/type', '公众号模板推送', 3, 'sendWrchatMpTpl', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (134, 'article/status_alias', '报名中', 1, 'success', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (135, 'article/status_alias', '名单公示', 2, 'primary', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (136, 'article/status_alias', '事项通知', 3, 'danger', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (137, 'article/status_alias', '已结束', 4, 'info', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (138, 'vip/type', '预定展位', 12, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (139, 'resume/age', '20岁以下', 20, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (140, 'resume/age', '20-25岁', 25, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (141, 'resume/age', '25-35岁', 35, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (142, 'resume/age', '35-45岁', 45, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (143, 'resume/age', '45岁以上', 46, '', NULL, 1);
INSERT INTO `xy_status_alias` VALUES (144, 'crm/tag', '未跟进客户', 0, '', 1, 1);
INSERT INTO `xy_status_alias` VALUES (145, 'crm/tag', '无意向客户', 1, 'color0', 1, 1);
INSERT INTO `xy_status_alias` VALUES (146, 'crm/tag', '一般购买意向', 2, 'color1', 1, 1);
INSERT INTO `xy_status_alias` VALUES (147, 'crm/tag', '中等购买意向', 3, 'color2', 1, 1);
INSERT INTO `xy_status_alias` VALUES (148, 'crm/tag', '强烈购买意向', 4, 'color3', 1, 1);
INSERT INTO `xy_status_alias` VALUES (149, 'crm/tag', '忠实客户', 99, 'color4', 1, 1);
INSERT INTO `xy_status_alias` VALUES (150, 'crm/follow_up_status', '电话拜访-正常接通', 1, '', 1, 1);
INSERT INTO `xy_status_alias` VALUES (151, 'crm/follow_up_status', '电话拜访-未接通', 2, '', 1, 1);
INSERT INTO `xy_status_alias` VALUES (152, 'crm/follow_up_status', '网络拜访', 3, '', 1, 1);
INSERT INTO `xy_status_alias` VALUES (153, 'crm/follow_up_status', '走访-成功', 4, '', 1, 1);
INSERT INTO `xy_status_alias` VALUES (154, 'crm/follow_up_status', '走访-失败', 5, '', 1, 1);
INSERT INTO `xy_status_alias` VALUES (155, 'resume/political_affiliation', '中共党员', 1, '', 0, 1);
INSERT INTO `xy_status_alias` VALUES (156, 'resume/political_affiliation', '中共预备党员', 2, '', 0, 1);
INSERT INTO `xy_status_alias` VALUES (157, 'resume/political_affiliation', '共青团员', 3, '', 0, 1);
INSERT INTO `xy_status_alias` VALUES (158, 'resume/political_affiliation', '民革会员', 4, '', 0, 1);
INSERT INTO `xy_status_alias` VALUES (159, 'resume/political_affiliation', '民盟盟员', 5, '', 0, 1);
INSERT INTO `xy_status_alias` VALUES (160, 'resume/political_affiliation', '民建会员', 6, '', 0, 1);
INSERT INTO `xy_status_alias` VALUES (161, 'resume/political_affiliation', '民进会员', 7, '', 0, 1);
INSERT INTO `xy_status_alias` VALUES (162, 'resume/political_affiliation', '农工党党员', 8, '', 0, 1);
INSERT INTO `xy_status_alias` VALUES (163, 'resume/political_affiliation', '致公党党员', 9, '', 0, 1);
INSERT INTO `xy_status_alias` VALUES (164, 'resume/political_affiliation', '九三学社社员', 10, '', 0, 1);
INSERT INTO `xy_status_alias` VALUES (165, 'resume/political_affiliation', '台盟盟员', 11, '', 0, 1);
INSERT INTO `xy_status_alias` VALUES (166, 'resume/political_affiliation', '无党派人士', 12, '', 0, 1);
INSERT INTO `xy_status_alias` VALUES (167, 'resume/political_affiliation', '群众', 13, '', 0, 1);
