
-- ----------------------------
-- Table structure for xy_specialities
-- ----------------------------
DROP TABLE IF EXISTS `xy_specialities`;
CREATE TABLE `xy_specialities`  (
  `id` int(0) UNSIGNED NOT NULL AUTO_INCREMENT,
  `specialities` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `university` tinyint(1) NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `code`(`code`) USING BTREE,
  INDEX `specialities`(`specialities`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1449 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of xy_specialities
-- ----------------------------
INSERT INTO `xy_specialities` VALUES (1, '哲学', '10101', 1);
INSERT INTO `xy_specialities` VALUES (2, '逻辑学', '10102', 1);
INSERT INTO `xy_specialities` VALUES (3, '宗教学', '010103K', 1);
INSERT INTO `xy_specialities` VALUES (4, '伦理学', '010104T', 1);
INSERT INTO `xy_specialities` VALUES (5, '经济学', '20101', 1);
INSERT INTO `xy_specialities` VALUES (6, '经济统计学', '20102', 1);
INSERT INTO `xy_specialities` VALUES (7, '国民经济管理', '020103T', 1);
INSERT INTO `xy_specialities` VALUES (8, '资源与环境经济学', '020104T', 1);
INSERT INTO `xy_specialities` VALUES (9, '商务经济学', '020105T', 1);
INSERT INTO `xy_specialities` VALUES (10, '能源经济', '020106T', 1);
INSERT INTO `xy_specialities` VALUES (11, '劳动经济学', '020107T', 1);
INSERT INTO `xy_specialities` VALUES (12, '经济工程', '020108T', 1);
INSERT INTO `xy_specialities` VALUES (13, '数字经济', '020109T', 1);
INSERT INTO `xy_specialities` VALUES (14, '财政学', '020201K', 1);
INSERT INTO `xy_specialities` VALUES (15, '税收学', '20202', 1);
INSERT INTO `xy_specialities` VALUES (16, '金融学', '020301K', 1);
INSERT INTO `xy_specialities` VALUES (17, '金融工程', '20302', 1);
INSERT INTO `xy_specialities` VALUES (18, '保险学', '20303', 1);
INSERT INTO `xy_specialities` VALUES (19, '投资学', '20304', 1);
INSERT INTO `xy_specialities` VALUES (20, '金融数学', '020305T', 1);
INSERT INTO `xy_specialities` VALUES (21, '信用管理', '020306T', 1);
INSERT INTO `xy_specialities` VALUES (22, '经济与金融', '020307T', 1);
INSERT INTO `xy_specialities` VALUES (23, '精算学', '020308T', 1);
INSERT INTO `xy_specialities` VALUES (24, '互联网金融', '020309T', 1);
INSERT INTO `xy_specialities` VALUES (25, '金融科技', '020310T', 1);
INSERT INTO `xy_specialities` VALUES (26, '国际经济与贸易', '20401', 1);
INSERT INTO `xy_specialities` VALUES (27, '贸易经济', '20402', 1);
INSERT INTO `xy_specialities` VALUES (28, '法学', '030101K', 1);
INSERT INTO `xy_specialities` VALUES (29, '知识产权', '030102T', 1);
INSERT INTO `xy_specialities` VALUES (30, '监狱学', '030103T', 1);
INSERT INTO `xy_specialities` VALUES (31, '信用风险管理与法律防控', '030104T', 1);
INSERT INTO `xy_specialities` VALUES (32, '国际经贸规则', '030105T', 1);
INSERT INTO `xy_specialities` VALUES (33, '司法警察学', '030106TK', 1);
INSERT INTO `xy_specialities` VALUES (34, '社区矫正', '030107TK', 1);
INSERT INTO `xy_specialities` VALUES (35, '政治学与行政学', '30201', 1);
INSERT INTO `xy_specialities` VALUES (36, '国际政治', '30202', 1);
INSERT INTO `xy_specialities` VALUES (37, '外交学', '30203', 1);
INSERT INTO `xy_specialities` VALUES (38, '国际事务与国际关系', '030204T', 1);
INSERT INTO `xy_specialities` VALUES (39, '政治学、经济学与哲学', '030205T', 1);
INSERT INTO `xy_specialities` VALUES (40, '国际组织与全球治理', '030206TK', 1);
INSERT INTO `xy_specialities` VALUES (41, '社会学', '30301', 1);
INSERT INTO `xy_specialities` VALUES (42, '社会工作', '30302', 1);
INSERT INTO `xy_specialities` VALUES (43, '人类学', '030303T', 1);
INSERT INTO `xy_specialities` VALUES (44, '女性学', '030304T', 1);
INSERT INTO `xy_specialities` VALUES (45, '家政学', '030305T', 1);
INSERT INTO `xy_specialities` VALUES (46, '老年学', '030306T', 1);
INSERT INTO `xy_specialities` VALUES (47, '民族学', '30401', 1);
INSERT INTO `xy_specialities` VALUES (48, '科学社会主义', '30501', 1);
INSERT INTO `xy_specialities` VALUES (49, '中国共产党历史', '30502', 1);
INSERT INTO `xy_specialities` VALUES (50, '思想政治教育', '30503', 1);
INSERT INTO `xy_specialities` VALUES (51, '马克思主义理论', '030504T', 1);
INSERT INTO `xy_specialities` VALUES (52, '治安学', '030601K', 1);
INSERT INTO `xy_specialities` VALUES (53, '侦查学', '030602K', 1);
INSERT INTO `xy_specialities` VALUES (54, '边防管理', '030603K', 1);
INSERT INTO `xy_specialities` VALUES (55, '禁毒学', '030604TK', 1);
INSERT INTO `xy_specialities` VALUES (56, '警犬技术', '030605TK', 1);
INSERT INTO `xy_specialities` VALUES (57, '经济犯罪侦查', '030606TK', 1);
INSERT INTO `xy_specialities` VALUES (58, '边防指挥', '030607TK', 1);
INSERT INTO `xy_specialities` VALUES (59, '消防指挥', '030608TK', 1);
INSERT INTO `xy_specialities` VALUES (60, '警卫学', '030609TK', 1);
INSERT INTO `xy_specialities` VALUES (61, '公安情报学', '030610TK', 1);
INSERT INTO `xy_specialities` VALUES (62, '犯罪学', '030611TK', 1);
INSERT INTO `xy_specialities` VALUES (63, '公安管理学', '030612TK', 1);
INSERT INTO `xy_specialities` VALUES (64, '涉外警务', '030613TK', 1);
INSERT INTO `xy_specialities` VALUES (65, '国内安全保卫', '030614TK', 1);
INSERT INTO `xy_specialities` VALUES (66, '警务指挥与战术', '030615TK', 1);
INSERT INTO `xy_specialities` VALUES (67, '技术侦查学', '030616TK', 1);
INSERT INTO `xy_specialities` VALUES (68, '海警执法', '030617TK', 1);
INSERT INTO `xy_specialities` VALUES (69, '公安政治工作', '030618TK', 1);
INSERT INTO `xy_specialities` VALUES (70, '移民管理', '030619TK', 1);
INSERT INTO `xy_specialities` VALUES (71, '出入境管理', '030620TK', 1);
INSERT INTO `xy_specialities` VALUES (72, '教育学', '40101', 1);
INSERT INTO `xy_specialities` VALUES (73, '科学教育', '40102', 1);
INSERT INTO `xy_specialities` VALUES (74, '人文教育', '40103', 1);
INSERT INTO `xy_specialities` VALUES (75, '教育技术学', '40104', 1);
INSERT INTO `xy_specialities` VALUES (76, '艺术教育', '40105', 1);
INSERT INTO `xy_specialities` VALUES (77, '学前教育', '40106', 1);
INSERT INTO `xy_specialities` VALUES (78, '小学教育', '40107', 1);
INSERT INTO `xy_specialities` VALUES (79, '特殊教育', '40108', 1);
INSERT INTO `xy_specialities` VALUES (80, '华文教育', '040109T', 1);
INSERT INTO `xy_specialities` VALUES (81, '教育康复学', '040110TK', 1);
INSERT INTO `xy_specialities` VALUES (82, '卫生教育', '040111T', 1);
INSERT INTO `xy_specialities` VALUES (83, '认知科学与技术', '040112T', 1);
INSERT INTO `xy_specialities` VALUES (84, '体育教育', '40201', 1);
INSERT INTO `xy_specialities` VALUES (85, '运动训练', '040202K', 1);
INSERT INTO `xy_specialities` VALUES (86, '社会体育指导与管理', '40203', 1);
INSERT INTO `xy_specialities` VALUES (87, '武术与民族传统体育', '040204K', 1);
INSERT INTO `xy_specialities` VALUES (88, '运动人体科学', '40205', 1);
INSERT INTO `xy_specialities` VALUES (89, '运动康复', '040206T', 1);
INSERT INTO `xy_specialities` VALUES (90, '休闲体育', '040207T', 1);
INSERT INTO `xy_specialities` VALUES (91, '体能训练', '040208T', 1);
INSERT INTO `xy_specialities` VALUES (92, '冰雪运动', '040209T', 1);
INSERT INTO `xy_specialities` VALUES (93, '电子竞技运动与管理', '040210TK', 1);
INSERT INTO `xy_specialities` VALUES (94, '智能体育工程', '040211TK', 1);
INSERT INTO `xy_specialities` VALUES (95, '体育旅游', '040212TK', 1);
INSERT INTO `xy_specialities` VALUES (96, '运动能力开发', '040213T', 1);
INSERT INTO `xy_specialities` VALUES (97, '汉语言文学', '50101', 1);
INSERT INTO `xy_specialities` VALUES (98, '汉语言', '50102', 1);
INSERT INTO `xy_specialities` VALUES (99, '汉语国际教育', '50103', 1);
INSERT INTO `xy_specialities` VALUES (100, '中国少数民族语言文学', '50104', 1);
INSERT INTO `xy_specialities` VALUES (101, '古典文献学', '50105', 1);
INSERT INTO `xy_specialities` VALUES (102, '应用语言学', '050106T', 1);
INSERT INTO `xy_specialities` VALUES (103, '秘书学', '050107T', 1);
INSERT INTO `xy_specialities` VALUES (104, '中国语言与文化', '050108T', 1);
INSERT INTO `xy_specialities` VALUES (105, '手语翻译', '050109T', 1);
INSERT INTO `xy_specialities` VALUES (106, '桑戈语', '050200T', 1);
INSERT INTO `xy_specialities` VALUES (107, '英语', '50201', 1);
INSERT INTO `xy_specialities` VALUES (108, '俄语', '50202', 1);
INSERT INTO `xy_specialities` VALUES (109, '德语', '50203', 1);
INSERT INTO `xy_specialities` VALUES (110, '法语', '50204', 1);
INSERT INTO `xy_specialities` VALUES (111, '西班牙语', '50205', 1);
INSERT INTO `xy_specialities` VALUES (112, '阿拉伯语', '50206', 1);
INSERT INTO `xy_specialities` VALUES (113, '日语', '50207', 1);
INSERT INTO `xy_specialities` VALUES (114, '波斯语', '50208', 1);
INSERT INTO `xy_specialities` VALUES (115, '朝鲜语', '50209', 1);
INSERT INTO `xy_specialities` VALUES (116, '菲律宾语', '50210', 1);
INSERT INTO `xy_specialities` VALUES (117, '梵语巴利语', '50211', 1);
INSERT INTO `xy_specialities` VALUES (118, '印度尼西亚语', '50212', 1);
INSERT INTO `xy_specialities` VALUES (119, '印地语', '50213', 1);
INSERT INTO `xy_specialities` VALUES (120, '柬埔寨语', '50214', 1);
INSERT INTO `xy_specialities` VALUES (121, '老挝语', '50215', 1);
INSERT INTO `xy_specialities` VALUES (122, '缅甸语', '50216', 1);
INSERT INTO `xy_specialities` VALUES (123, '马来语', '50217', 1);
INSERT INTO `xy_specialities` VALUES (124, '蒙古语', '50218', 1);
INSERT INTO `xy_specialities` VALUES (125, '僧伽罗语', '50219', 1);
INSERT INTO `xy_specialities` VALUES (126, '泰语', '50220', 1);
INSERT INTO `xy_specialities` VALUES (127, '乌尔都语', '50221', 1);
INSERT INTO `xy_specialities` VALUES (128, '希伯来语', '50222', 1);
INSERT INTO `xy_specialities` VALUES (129, '越南语', '50223', 1);
INSERT INTO `xy_specialities` VALUES (130, '豪萨语', '50224', 1);
INSERT INTO `xy_specialities` VALUES (131, '斯瓦希里语', '50225', 1);
INSERT INTO `xy_specialities` VALUES (132, '阿尔巴尼亚语', '50226', 1);
INSERT INTO `xy_specialities` VALUES (133, '保加利亚语', '50227', 1);
INSERT INTO `xy_specialities` VALUES (134, '波兰语', '50228', 1);
INSERT INTO `xy_specialities` VALUES (135, '捷克语', '50229', 1);
INSERT INTO `xy_specialities` VALUES (136, '斯洛伐克语', '50230', 1);
INSERT INTO `xy_specialities` VALUES (137, '罗马尼亚语', '50231', 1);
INSERT INTO `xy_specialities` VALUES (138, '葡萄牙语', '50232', 1);
INSERT INTO `xy_specialities` VALUES (139, '瑞典语', '50233', 1);
INSERT INTO `xy_specialities` VALUES (140, '塞尔维亚语', '50234', 1);
INSERT INTO `xy_specialities` VALUES (141, '土耳其语', '50235', 1);
INSERT INTO `xy_specialities` VALUES (142, '希腊语', '50236', 1);
INSERT INTO `xy_specialities` VALUES (143, '匈牙利语', '50237', 1);
INSERT INTO `xy_specialities` VALUES (144, '意大利语', '50238', 1);
INSERT INTO `xy_specialities` VALUES (145, '泰米尔语', '50239', 1);
INSERT INTO `xy_specialities` VALUES (146, '普什图语', '50240', 1);
INSERT INTO `xy_specialities` VALUES (147, '世界语', '50241', 1);
INSERT INTO `xy_specialities` VALUES (148, '孟加拉语', '50242', 1);
INSERT INTO `xy_specialities` VALUES (149, '尼泊尔语', '50243', 1);
INSERT INTO `xy_specialities` VALUES (150, '克罗地亚语', '50244', 1);
INSERT INTO `xy_specialities` VALUES (151, '荷兰语', '50245', 1);
INSERT INTO `xy_specialities` VALUES (152, '芬兰语', '50246', 1);
INSERT INTO `xy_specialities` VALUES (153, '乌克兰语', '50247', 1);
INSERT INTO `xy_specialities` VALUES (154, '挪威语', '50248', 1);
INSERT INTO `xy_specialities` VALUES (155, '丹麦语', '50249', 1);
INSERT INTO `xy_specialities` VALUES (156, '冰岛语', '50250', 1);
INSERT INTO `xy_specialities` VALUES (157, '爱尔兰语', '50251', 1);
INSERT INTO `xy_specialities` VALUES (158, '拉脱维亚语', '50252', 1);
INSERT INTO `xy_specialities` VALUES (159, '立陶宛语', '50253', 1);
INSERT INTO `xy_specialities` VALUES (160, '斯洛文尼亚语', '50254', 1);
INSERT INTO `xy_specialities` VALUES (161, '爱沙尼亚语', '50255', 1);
INSERT INTO `xy_specialities` VALUES (162, '马耳他语', '50256', 1);
INSERT INTO `xy_specialities` VALUES (163, '哈萨克语', '50257', 1);
INSERT INTO `xy_specialities` VALUES (164, '乌兹别克语', '50258', 1);
INSERT INTO `xy_specialities` VALUES (165, '祖鲁语', '50259', 1);
INSERT INTO `xy_specialities` VALUES (166, '拉丁语', '50260', 1);
INSERT INTO `xy_specialities` VALUES (167, '翻译', '50261', 1);
INSERT INTO `xy_specialities` VALUES (168, '商务英语', '50262', 1);
INSERT INTO `xy_specialities` VALUES (169, '阿姆哈拉语', '050263T', 1);
INSERT INTO `xy_specialities` VALUES (170, '吉尔吉斯语', '050264T', 1);
INSERT INTO `xy_specialities` VALUES (171, '索马里语', '050265T', 1);
INSERT INTO `xy_specialities` VALUES (172, '土库曼语', '050266T', 1);
INSERT INTO `xy_specialities` VALUES (173, '加泰罗尼亚语', '050267T', 1);
INSERT INTO `xy_specialities` VALUES (174, '约鲁巴语', '050268T', 1);
INSERT INTO `xy_specialities` VALUES (175, '亚美尼亚语', '050269T', 1);
INSERT INTO `xy_specialities` VALUES (176, '马达加斯加语', '050270T', 1);
INSERT INTO `xy_specialities` VALUES (177, '格鲁吉亚语', '050271T', 1);
INSERT INTO `xy_specialities` VALUES (178, '阿塞拜疆语', '050272T', 1);
INSERT INTO `xy_specialities` VALUES (179, '阿非利卡语', '050273T', 1);
INSERT INTO `xy_specialities` VALUES (180, '马其顿语', '050274T', 1);
INSERT INTO `xy_specialities` VALUES (181, '塔吉克语', '050275T', 1);
INSERT INTO `xy_specialities` VALUES (182, '茨瓦纳语', '050276T', 1);
INSERT INTO `xy_specialities` VALUES (183, '恩德贝莱语', '050277T', 1);
INSERT INTO `xy_specialities` VALUES (184, '科摩罗语', '050278T', 1);
INSERT INTO `xy_specialities` VALUES (185, '克里奥尔语', '050279T', 1);
INSERT INTO `xy_specialities` VALUES (186, '绍纳语', '050280T', 1);
INSERT INTO `xy_specialities` VALUES (187, '提格雷尼亚语', '050281T', 1);
INSERT INTO `xy_specialities` VALUES (188, '白俄罗斯语', '050282T', 1);
INSERT INTO `xy_specialities` VALUES (189, '毛利语', '050283T', 1);
INSERT INTO `xy_specialities` VALUES (190, '汤加语', '050284T', 1);
INSERT INTO `xy_specialities` VALUES (191, '萨摩亚语', '050285T', 1);
INSERT INTO `xy_specialities` VALUES (192, '库尔德语', '050286T', 1);
INSERT INTO `xy_specialities` VALUES (193, '比斯拉马语', '050287T', 1);
INSERT INTO `xy_specialities` VALUES (194, '达里语', '050288T', 1);
INSERT INTO `xy_specialities` VALUES (195, '德顿语', '050289T', 1);
INSERT INTO `xy_specialities` VALUES (196, '迪维希语', '050290T', 1);
INSERT INTO `xy_specialities` VALUES (197, '斐济语', '050291T', 1);
INSERT INTO `xy_specialities` VALUES (198, '库克群岛毛利语', '050292T', 1);
INSERT INTO `xy_specialities` VALUES (199, '隆迪语', '050293T', 1);
INSERT INTO `xy_specialities` VALUES (200, '卢森堡语', '050294T', 1);
INSERT INTO `xy_specialities` VALUES (201, '卢旺达语', '050295T', 1);
INSERT INTO `xy_specialities` VALUES (202, '纽埃语', '050296T', 1);
INSERT INTO `xy_specialities` VALUES (203, '皮金语', '050297T', 1);
INSERT INTO `xy_specialities` VALUES (204, '切瓦语', '050298T', 1);
INSERT INTO `xy_specialities` VALUES (205, '塞苏陀语', '050299T', 1);
INSERT INTO `xy_specialities` VALUES (206, '语言学', '0502100T', 1);
INSERT INTO `xy_specialities` VALUES (207, '塔玛齐格特语', '0502101T', 1);
INSERT INTO `xy_specialities` VALUES (208, '爪哇语', '0502102T', 1);
INSERT INTO `xy_specialities` VALUES (209, '旁遮普语', '0502103T', 1);
INSERT INTO `xy_specialities` VALUES (210, '新闻学', '50301', 1);
INSERT INTO `xy_specialities` VALUES (211, '广播电视学', '50302', 1);
INSERT INTO `xy_specialities` VALUES (212, '广告学', '50303', 1);
INSERT INTO `xy_specialities` VALUES (213, '传播学', '50304', 1);
INSERT INTO `xy_specialities` VALUES (214, '编辑出版学', '50305', 1);
INSERT INTO `xy_specialities` VALUES (215, '网络与新媒体', '050306T', 1);
INSERT INTO `xy_specialities` VALUES (216, '数字出版', '050307T', 1);
INSERT INTO `xy_specialities` VALUES (217, '时尚传播', '050308T', 1);
INSERT INTO `xy_specialities` VALUES (218, '国际新闻与传播', '050309T', 1);
INSERT INTO `xy_specialities` VALUES (219, '会展', '99J001T', 1);
INSERT INTO `xy_specialities` VALUES (220, '历史学', '60101', 1);
INSERT INTO `xy_specialities` VALUES (221, '世界史', '60102', 1);
INSERT INTO `xy_specialities` VALUES (222, '考古学', '60103', 1);
INSERT INTO `xy_specialities` VALUES (223, '文物与博物馆学', '60104', 1);
INSERT INTO `xy_specialities` VALUES (224, '文物保护技术', '060105T', 1);
INSERT INTO `xy_specialities` VALUES (225, '外国语言与外国历史', '060106T', 1);
INSERT INTO `xy_specialities` VALUES (226, '文化遗产', '060107T', 1);
INSERT INTO `xy_specialities` VALUES (227, '数学与应用数学', '70101', 1);
INSERT INTO `xy_specialities` VALUES (228, '信息与计算科学', '70102', 1);
INSERT INTO `xy_specialities` VALUES (229, '数理基础科学', '070103T', 1);
INSERT INTO `xy_specialities` VALUES (230, '数据计算及应用', '070104T', 1);
INSERT INTO `xy_specialities` VALUES (231, '物理学', '70201', 1);
INSERT INTO `xy_specialities` VALUES (232, '应用物理学', '70202', 1);
INSERT INTO `xy_specialities` VALUES (233, '核物理', '70203', 1);
INSERT INTO `xy_specialities` VALUES (234, '声学', '070204T', 1);
INSERT INTO `xy_specialities` VALUES (235, '系统科学与工程', '070205T', 1);
INSERT INTO `xy_specialities` VALUES (236, '化学', '70301', 1);
INSERT INTO `xy_specialities` VALUES (237, '应用化学', '70302', 1);
INSERT INTO `xy_specialities` VALUES (238, '化学生物学', '070303T', 1);
INSERT INTO `xy_specialities` VALUES (239, '分子科学与工程', '070304T', 1);
INSERT INTO `xy_specialities` VALUES (240, '能源化学', '070305T', 1);
INSERT INTO `xy_specialities` VALUES (241, '天文学', '70401', 1);
INSERT INTO `xy_specialities` VALUES (242, '地理科学', '70501', 1);
INSERT INTO `xy_specialities` VALUES (243, '自然地理与资源环境', '70502', 1);
INSERT INTO `xy_specialities` VALUES (244, '人文地理与城乡规划', '70503', 1);
INSERT INTO `xy_specialities` VALUES (245, '地理信息科学', '70504', 1);
INSERT INTO `xy_specialities` VALUES (246, '大气科学', '70601', 1);
INSERT INTO `xy_specialities` VALUES (247, '应用气象学', '70602', 1);
INSERT INTO `xy_specialities` VALUES (248, '海洋科学', '70701', 1);
INSERT INTO `xy_specialities` VALUES (249, '海洋技术', '70702', 1);
INSERT INTO `xy_specialities` VALUES (250, '海洋资源与环境', '070703T', 1);
INSERT INTO `xy_specialities` VALUES (251, '军事海洋学', '070704T', 1);
INSERT INTO `xy_specialities` VALUES (252, '地球物理学', '70801', 1);
INSERT INTO `xy_specialities` VALUES (253, '空间科学与技术', '70802', 1);
INSERT INTO `xy_specialities` VALUES (254, '防灾减灾科学与工程', '070803T', 1);
INSERT INTO `xy_specialities` VALUES (255, '地质学', '70901', 1);
INSERT INTO `xy_specialities` VALUES (256, '地球化学', '70902', 1);
INSERT INTO `xy_specialities` VALUES (257, '地球信息科学与技术', '070903T', 1);
INSERT INTO `xy_specialities` VALUES (258, '古生物学', '070904T', 1);
INSERT INTO `xy_specialities` VALUES (259, '生物科学', '71001', 1);
INSERT INTO `xy_specialities` VALUES (260, '生物技术', '71002', 1);
INSERT INTO `xy_specialities` VALUES (261, '生物信息学', '71003', 1);
INSERT INTO `xy_specialities` VALUES (262, '生态学', '71004', 1);
INSERT INTO `xy_specialities` VALUES (263, '整合科学', '071005T', 1);
INSERT INTO `xy_specialities` VALUES (264, '神经科学', '071006T', 1);
INSERT INTO `xy_specialities` VALUES (265, '心理学', '71101', 1);
INSERT INTO `xy_specialities` VALUES (266, '应用心理学', '71102', 1);
INSERT INTO `xy_specialities` VALUES (267, '统计学', '71201', 1);
INSERT INTO `xy_specialities` VALUES (268, '应用统计学', '71202', 1);
INSERT INTO `xy_specialities` VALUES (269, '理论与应用力学', '80101', 1);
INSERT INTO `xy_specialities` VALUES (270, '工程力学', '80102', 1);
INSERT INTO `xy_specialities` VALUES (271, '机械工程', '80201', 1);
INSERT INTO `xy_specialities` VALUES (272, '机械设计制造及其自动化', '80202', 1);
INSERT INTO `xy_specialities` VALUES (273, '材料成型及控制工程', '80203', 1);
INSERT INTO `xy_specialities` VALUES (274, '机械电子工程', '80204', 1);
INSERT INTO `xy_specialities` VALUES (275, '工业设计', '80205', 1);
INSERT INTO `xy_specialities` VALUES (276, '过程装备与控制工程', '80206', 1);
INSERT INTO `xy_specialities` VALUES (277, '车辆工程', '80207', 1);
INSERT INTO `xy_specialities` VALUES (278, '汽车服务工程', '80208', 1);
INSERT INTO `xy_specialities` VALUES (279, '机械工艺技术', '080209T', 1);
INSERT INTO `xy_specialities` VALUES (280, '微机电系统工程', '080210T', 1);
INSERT INTO `xy_specialities` VALUES (281, '机电技术教育', '080211T', 1);
INSERT INTO `xy_specialities` VALUES (282, '汽车维修工程教育', '080212T', 1);
INSERT INTO `xy_specialities` VALUES (283, '智能制造工程', '080213T', 1);
INSERT INTO `xy_specialities` VALUES (284, '智能车辆工程', '080214T', 1);
INSERT INTO `xy_specialities` VALUES (285, '仿生科学与工程', '080215T', 1);
INSERT INTO `xy_specialities` VALUES (286, '新能源汽车工程', '080216T', 1);
INSERT INTO `xy_specialities` VALUES (287, '测控技术与仪器', '80301', 1);
INSERT INTO `xy_specialities` VALUES (288, '精密仪器', '080302T', 1);
INSERT INTO `xy_specialities` VALUES (289, '智能感知工程', '080303T', 1);
INSERT INTO `xy_specialities` VALUES (290, '材料科学与工程', '80401', 1);
INSERT INTO `xy_specialities` VALUES (291, '材料物理', '80402', 1);
INSERT INTO `xy_specialities` VALUES (292, '材料化学', '80403', 1);
INSERT INTO `xy_specialities` VALUES (293, '冶金工程', '80404', 1);
INSERT INTO `xy_specialities` VALUES (294, '金属材料工程', '80405', 1);
INSERT INTO `xy_specialities` VALUES (295, '无机非金属材料工程', '80406', 1);
INSERT INTO `xy_specialities` VALUES (296, '高分子材料与工程', '80407', 1);
INSERT INTO `xy_specialities` VALUES (297, '复合材料与工程', '80408', 1);
INSERT INTO `xy_specialities` VALUES (298, '粉体材料科学与工程', '080409T', 1);
INSERT INTO `xy_specialities` VALUES (299, '宝石及材料工艺学', '080410T', 1);
INSERT INTO `xy_specialities` VALUES (300, '焊接技术与工程', '080411T', 1);
INSERT INTO `xy_specialities` VALUES (301, '功能材料', '080412T', 1);
INSERT INTO `xy_specialities` VALUES (302, '纳米材料与技术', '080413T', 1);
INSERT INTO `xy_specialities` VALUES (303, '新能源材料与器件', '080414T', 1);
INSERT INTO `xy_specialities` VALUES (304, '材料设计科学与工程', '080415T', 1);
INSERT INTO `xy_specialities` VALUES (305, '复合材料成型工程', '080416T', 1);
INSERT INTO `xy_specialities` VALUES (306, '智能材料与结构', '080417T', 1);
INSERT INTO `xy_specialities` VALUES (307, '能源与动力工程', '80501', 1);
INSERT INTO `xy_specialities` VALUES (308, '能源与环境系统工程', '080502T', 1);
INSERT INTO `xy_specialities` VALUES (309, '新能源科学与工程', '080503T', 1);
INSERT INTO `xy_specialities` VALUES (310, '储能科学与工程', '080504T', 1);
INSERT INTO `xy_specialities` VALUES (311, '电气工程及其自动化', '80601', 1);
INSERT INTO `xy_specialities` VALUES (312, '智能电网信息工程', '080602T', 1);
INSERT INTO `xy_specialities` VALUES (313, '光源与照明', '080603T', 1);
INSERT INTO `xy_specialities` VALUES (314, '电气工程与智能控制', '080604T', 1);
INSERT INTO `xy_specialities` VALUES (315, '电机电器智能化', '080605T', 1);
INSERT INTO `xy_specialities` VALUES (316, '电缆工程', '080606T', 1);
INSERT INTO `xy_specialities` VALUES (317, '电子信息工程', '80701', 1);
INSERT INTO `xy_specialities` VALUES (318, '电子科学与技术', '80702', 1);
INSERT INTO `xy_specialities` VALUES (319, '通信工程', '80703', 1);
INSERT INTO `xy_specialities` VALUES (320, '微电子科学与工程', '80704', 1);
INSERT INTO `xy_specialities` VALUES (321, '光电信息科学与工程', '80705', 1);
INSERT INTO `xy_specialities` VALUES (322, '信息工程', '80706', 1);
INSERT INTO `xy_specialities` VALUES (323, '广播电视工程', '080707T', 1);
INSERT INTO `xy_specialities` VALUES (324, '水声工程', '080708T', 1);
INSERT INTO `xy_specialities` VALUES (325, '电子封装技术', '080709T', 1);
INSERT INTO `xy_specialities` VALUES (326, '集成电路设计与集成系统', '080710T', 1);
INSERT INTO `xy_specialities` VALUES (327, '医学信息工程', '080711T', 1);
INSERT INTO `xy_specialities` VALUES (328, '电磁场与无线技术', '080712T', 1);
INSERT INTO `xy_specialities` VALUES (329, '电波传播与天线', '080713T', 1);
INSERT INTO `xy_specialities` VALUES (330, '电子信息科学与技术', '080714T', 1);
INSERT INTO `xy_specialities` VALUES (331, '电信工程及管理', '080715T', 1);
INSERT INTO `xy_specialities` VALUES (332, '应用电子技术教育', '080716T', 1);
INSERT INTO `xy_specialities` VALUES (333, '人工智能', '080717T', 1);
INSERT INTO `xy_specialities` VALUES (334, '海洋信息工程', '080718T', 1);
INSERT INTO `xy_specialities` VALUES (335, '自动化', '80801', 1);
INSERT INTO `xy_specialities` VALUES (336, '轨道交通信号与控制', '080802T', 1);
INSERT INTO `xy_specialities` VALUES (337, '机器人工程', '080803T', 1);
INSERT INTO `xy_specialities` VALUES (338, '邮政工程', '080804T', 1);
INSERT INTO `xy_specialities` VALUES (339, '核电技术与控制工程', '080805T', 1);
INSERT INTO `xy_specialities` VALUES (340, '智能装备与系统', '080806T', 1);
INSERT INTO `xy_specialities` VALUES (341, '工业智能', '080807T', 1);
INSERT INTO `xy_specialities` VALUES (342, '计算机科学与技术', '80901', 1);
INSERT INTO `xy_specialities` VALUES (343, '软件工程', '80902', 1);
INSERT INTO `xy_specialities` VALUES (344, '网络工程', '80903', 1);
INSERT INTO `xy_specialities` VALUES (345, '信息安全', '080904K', 1);
INSERT INTO `xy_specialities` VALUES (346, '物联网工程', '80905', 1);
INSERT INTO `xy_specialities` VALUES (347, '数字媒体技术', '80906', 1);
INSERT INTO `xy_specialities` VALUES (348, '智能科学与技术', '080907T', 1);
INSERT INTO `xy_specialities` VALUES (349, '空间信息与数字技术', '080908T', 1);
INSERT INTO `xy_specialities` VALUES (350, '电子与计算机工程', '080909T', 1);
INSERT INTO `xy_specialities` VALUES (351, '数据科学与大数据技术', '080910T', 1);
INSERT INTO `xy_specialities` VALUES (352, '网络空间安全', '080911TK', 1);
INSERT INTO `xy_specialities` VALUES (353, '新媒体技术', '080912T', 1);
INSERT INTO `xy_specialities` VALUES (354, '电影制作', '080913T', 1);
INSERT INTO `xy_specialities` VALUES (355, '保密技术', '080914TK', 1);
INSERT INTO `xy_specialities` VALUES (356, '服务科学与工程', '080915T', 1);
INSERT INTO `xy_specialities` VALUES (357, '虚拟现实技术', '080916T', 1);
INSERT INTO `xy_specialities` VALUES (358, '区块链工程', '080917T', 1);
INSERT INTO `xy_specialities` VALUES (359, '土木工程', '81001', 1);
INSERT INTO `xy_specialities` VALUES (360, '建筑环境与能源应用工程', '81002', 1);
INSERT INTO `xy_specialities` VALUES (361, '给排水科学与工程', '81003', 1);
INSERT INTO `xy_specialities` VALUES (362, '建筑电气与智能化', '81004', 1);
INSERT INTO `xy_specialities` VALUES (363, '城市地下空间工程', '081005T', 1);
INSERT INTO `xy_specialities` VALUES (364, '道路桥梁与渡河工程', '081006T', 1);
INSERT INTO `xy_specialities` VALUES (365, '铁道工程', '081007T', 1);
INSERT INTO `xy_specialities` VALUES (366, '智能建造', '081008T', 1);
INSERT INTO `xy_specialities` VALUES (367, '土木、水利与海洋工程', '081009T', 1);
INSERT INTO `xy_specialities` VALUES (368, '土木、水利与交通工程', '081010T', 1);
INSERT INTO `xy_specialities` VALUES (369, '水利水电工程', '81101', 1);
INSERT INTO `xy_specialities` VALUES (370, '水文与水资源工程', '81102', 1);
INSERT INTO `xy_specialities` VALUES (371, '港口航道与海岸工程', '81103', 1);
INSERT INTO `xy_specialities` VALUES (372, '水务工程', '081104T', 1);
INSERT INTO `xy_specialities` VALUES (373, '水利科学与工程', '081105T', 1);
INSERT INTO `xy_specialities` VALUES (374, '测绘工程', '81201', 1);
INSERT INTO `xy_specialities` VALUES (375, '遥感科学与技术', '81202', 1);
INSERT INTO `xy_specialities` VALUES (376, '导航工程', '081203T', 1);
INSERT INTO `xy_specialities` VALUES (377, '地理国情监测', '081204T', 1);
INSERT INTO `xy_specialities` VALUES (378, '地理空间信息工程', '081205T', 1);
INSERT INTO `xy_specialities` VALUES (379, '化学工程与工艺', '81301', 1);
INSERT INTO `xy_specialities` VALUES (380, '制药工程', '81302', 1);
INSERT INTO `xy_specialities` VALUES (381, '资源循环科学与工程', '081303T', 1);
INSERT INTO `xy_specialities` VALUES (382, '能源化学工程', '081304T', 1);
INSERT INTO `xy_specialities` VALUES (383, '化学工程与工业生物工程', '081305T', 1);
INSERT INTO `xy_specialities` VALUES (384, '化工安全工程', '081306T', 1);
INSERT INTO `xy_specialities` VALUES (385, '涂料工程', '081307T', 1);
INSERT INTO `xy_specialities` VALUES (386, '精细化工', '081308T', 1);
INSERT INTO `xy_specialities` VALUES (387, '地质工程', '81401', 1);
INSERT INTO `xy_specialities` VALUES (388, '勘查技术与工程', '81402', 1);
INSERT INTO `xy_specialities` VALUES (389, '资源勘查工程', '81403', 1);
INSERT INTO `xy_specialities` VALUES (390, '地下水科学与工程', '081404T', 1);
INSERT INTO `xy_specialities` VALUES (391, '旅游地学与规划工程', '081405T', 1);
INSERT INTO `xy_specialities` VALUES (392, '采矿工程', '81501', 1);
INSERT INTO `xy_specialities` VALUES (393, '石油工程', '81502', 1);
INSERT INTO `xy_specialities` VALUES (394, '矿物加工工程', '81503', 1);
INSERT INTO `xy_specialities` VALUES (395, '油气储运工程', '81504', 1);
INSERT INTO `xy_specialities` VALUES (396, '矿物资源工程', '081505T', 1);
INSERT INTO `xy_specialities` VALUES (397, '海洋油气工程', '081506T', 1);
INSERT INTO `xy_specialities` VALUES (398, '纺织工程', '81601', 1);
INSERT INTO `xy_specialities` VALUES (399, '服装设计与工程', '81602', 1);
INSERT INTO `xy_specialities` VALUES (400, '非织造材料与工程', '081603T', 1);
INSERT INTO `xy_specialities` VALUES (401, '服装设计与工艺教育', '081604T', 1);
INSERT INTO `xy_specialities` VALUES (402, '丝绸设计与工程', '081605T', 1);
INSERT INTO `xy_specialities` VALUES (403, '轻化工程', '81701', 1);
INSERT INTO `xy_specialities` VALUES (404, '包装工程', '81702', 1);
INSERT INTO `xy_specialities` VALUES (405, '印刷工程', '81703', 1);
INSERT INTO `xy_specialities` VALUES (406, '香料香精技术与工程', '081704T', 1);
INSERT INTO `xy_specialities` VALUES (407, '化妆品技术与工程', '081705T', 1);
INSERT INTO `xy_specialities` VALUES (408, '交通运输', '81801', 1);
INSERT INTO `xy_specialities` VALUES (409, '交通工程', '81802', 1);
INSERT INTO `xy_specialities` VALUES (410, '航海技术', '081803K', 1);
INSERT INTO `xy_specialities` VALUES (411, '轮机工程', '081804K', 1);
INSERT INTO `xy_specialities` VALUES (412, '飞行技术', '081805K', 1);
INSERT INTO `xy_specialities` VALUES (413, '交通设备与控制工程', '081806T', 1);
INSERT INTO `xy_specialities` VALUES (414, '救助与打捞工程', '081807T', 1);
INSERT INTO `xy_specialities` VALUES (415, '船舶电子电气工程', '081808TK', 1);
INSERT INTO `xy_specialities` VALUES (416, '轨道交通电气与控制', '081809T', 1);
INSERT INTO `xy_specialities` VALUES (417, '邮轮工程与管理', '081810T', 1);
INSERT INTO `xy_specialities` VALUES (418, '船舶与海洋工程', '81901', 1);
INSERT INTO `xy_specialities` VALUES (419, '海洋工程与技术', '081902T', 1);
INSERT INTO `xy_specialities` VALUES (420, '海洋资源开发技术', '081903T', 1);
INSERT INTO `xy_specialities` VALUES (421, '海洋机器人', '081904T', 1);
INSERT INTO `xy_specialities` VALUES (422, '航空航天工程', '82001', 1);
INSERT INTO `xy_specialities` VALUES (423, '飞行器设计与工程', '82002', 1);
INSERT INTO `xy_specialities` VALUES (424, '飞行器制造工程', '82003', 1);
INSERT INTO `xy_specialities` VALUES (425, '飞行器动力工程', '82004', 1);
INSERT INTO `xy_specialities` VALUES (426, '飞行器环境与生命保障工程', '82005', 1);
INSERT INTO `xy_specialities` VALUES (427, '飞行器质量与可靠性', '082006T', 1);
INSERT INTO `xy_specialities` VALUES (428, '飞行器适航技术', '082007T', 1);
INSERT INTO `xy_specialities` VALUES (429, '飞行器控制与信息工程', '082008T', 1);
INSERT INTO `xy_specialities` VALUES (430, '无人驾驶航空器系统工程', '082009T', 1);
INSERT INTO `xy_specialities` VALUES (431, '武器系统与工程', '82101', 1);
INSERT INTO `xy_specialities` VALUES (432, '武器发射工程', '82102', 1);
INSERT INTO `xy_specialities` VALUES (433, '探测制导与控制技术', '82103', 1);
INSERT INTO `xy_specialities` VALUES (434, '弹药工程与爆炸技术', '82104', 1);
INSERT INTO `xy_specialities` VALUES (435, '特种能源技术与工程', '82105', 1);
INSERT INTO `xy_specialities` VALUES (436, '装甲车辆工程', '82106', 1);
INSERT INTO `xy_specialities` VALUES (437, '信息对抗技术', '82107', 1);
INSERT INTO `xy_specialities` VALUES (438, '智能无人系统技术', NULL, 1);
INSERT INTO `xy_specialities` VALUES (439, '核工程与核技术', '82201', 1);
INSERT INTO `xy_specialities` VALUES (440, '辐射防护与核安全', '82202', 1);
INSERT INTO `xy_specialities` VALUES (441, '工程物理', '82203', 1);
INSERT INTO `xy_specialities` VALUES (442, '核化工与核燃料工程', '82204', 1);
INSERT INTO `xy_specialities` VALUES (443, '农业工程', '82301', 1);
INSERT INTO `xy_specialities` VALUES (444, '农业机械化及其自动化', '82302', 1);
INSERT INTO `xy_specialities` VALUES (445, '农业电气化', '82303', 1);
INSERT INTO `xy_specialities` VALUES (446, '农业建筑环境与能源工程', '82304', 1);
INSERT INTO `xy_specialities` VALUES (447, '农业水利工程', '82305', 1);
INSERT INTO `xy_specialities` VALUES (448, '土地整治工程', '082306T', 1);
INSERT INTO `xy_specialities` VALUES (449, '农业智能装备工程', '082307T', 1);
INSERT INTO `xy_specialities` VALUES (450, '森林工程', '82401', 1);
INSERT INTO `xy_specialities` VALUES (451, '木材科学与工程', '82402', 1);
INSERT INTO `xy_specialities` VALUES (452, '林产化工', '82403', 1);
INSERT INTO `xy_specialities` VALUES (453, '家具设计与工程', '082404T', 1);
INSERT INTO `xy_specialities` VALUES (454, '环境科学与工程', '82501', 1);
INSERT INTO `xy_specialities` VALUES (455, '环境工程', '82502', 1);
INSERT INTO `xy_specialities` VALUES (456, '环境科学', '82503', 1);
INSERT INTO `xy_specialities` VALUES (457, '环境生态工程', '82504', 1);
INSERT INTO `xy_specialities` VALUES (458, '环保设备工程', '082505T', 1);
INSERT INTO `xy_specialities` VALUES (459, '资源环境科学', '082506T', 1);
INSERT INTO `xy_specialities` VALUES (460, '水质科学与技术', '082507T', 1);
INSERT INTO `xy_specialities` VALUES (461, '生物医学工程', '82601', 1);
INSERT INTO `xy_specialities` VALUES (462, '假肢矫形工程', '082602T', 1);
INSERT INTO `xy_specialities` VALUES (463, '临床工程技术', '082603T', 1);
INSERT INTO `xy_specialities` VALUES (464, '康复工程', '082604T', 1);
INSERT INTO `xy_specialities` VALUES (465, '食品科学与工程', '82701', 1);
INSERT INTO `xy_specialities` VALUES (466, '食品质量与安全', '82702', 1);
INSERT INTO `xy_specialities` VALUES (467, '粮食工程', '82703', 1);
INSERT INTO `xy_specialities` VALUES (468, '乳品工程', '82704', 1);
INSERT INTO `xy_specialities` VALUES (469, '酿酒工程', '82705', 1);
INSERT INTO `xy_specialities` VALUES (470, '葡萄与葡萄酒工程', '082706T', 1);
INSERT INTO `xy_specialities` VALUES (471, '食品营养与检验教育', '082707T', 1);
INSERT INTO `xy_specialities` VALUES (472, '烹饪与营养教育', '082708T', 1);
INSERT INTO `xy_specialities` VALUES (473, '食品安全与检测', '082709T', 1);
INSERT INTO `xy_specialities` VALUES (474, '食品营养与健康', NULL, 1);
INSERT INTO `xy_specialities` VALUES (475, '食用菌科学与工程', '082711T', 1);
INSERT INTO `xy_specialities` VALUES (476, '白酒酿造工程', NULL, 1);
INSERT INTO `xy_specialities` VALUES (477, '建筑学', '82801', 1);
INSERT INTO `xy_specialities` VALUES (478, '城乡规划', '82802', 1);
INSERT INTO `xy_specialities` VALUES (479, '风景园林', '82803', 1);
INSERT INTO `xy_specialities` VALUES (480, '历史建筑保护工程', '082804T', 1);
INSERT INTO `xy_specialities` VALUES (481, '人居环境科学与技术', '082805T', 1);
INSERT INTO `xy_specialities` VALUES (482, '城市设计', '082806T', 1);
INSERT INTO `xy_specialities` VALUES (483, '智慧建筑与建造', '082807T', 1);
INSERT INTO `xy_specialities` VALUES (484, '安全工程', '82901', 1);
INSERT INTO `xy_specialities` VALUES (485, '应急技术与管理', '082902T', 1);
INSERT INTO `xy_specialities` VALUES (486, '职业卫生工程', '082903T', 1);
INSERT INTO `xy_specialities` VALUES (487, '生物工程', '83001', 1);
INSERT INTO `xy_specialities` VALUES (488, '生物制药', '083002T', 1);
INSERT INTO `xy_specialities` VALUES (489, '合成生物学', NULL, 1);
INSERT INTO `xy_specialities` VALUES (490, '刑事科学技术', '083101K', 1);
INSERT INTO `xy_specialities` VALUES (491, '消防工程', '083102K', 1);
INSERT INTO `xy_specialities` VALUES (492, '交通管理工程', '083103TK', 1);
INSERT INTO `xy_specialities` VALUES (493, '安全防范工程', '083104TK', 1);
INSERT INTO `xy_specialities` VALUES (494, '公安视听技术', '083105TK', 1);
INSERT INTO `xy_specialities` VALUES (495, '抢险救援指挥与技术', '083106TK', 1);
INSERT INTO `xy_specialities` VALUES (496, '火灾勘查', '083107TK', 1);
INSERT INTO `xy_specialities` VALUES (497, '网络安全与执法', '083108TK', 1);
INSERT INTO `xy_specialities` VALUES (498, '核生化消防', '083109TK', 1);
INSERT INTO `xy_specialities` VALUES (499, '海警舰艇指挥与技术', '083110TK', 1);
INSERT INTO `xy_specialities` VALUES (500, '数据警务技术', '083111TK', 1);
INSERT INTO `xy_specialities` VALUES (501, '农学', '90101', 1);
INSERT INTO `xy_specialities` VALUES (502, '园艺', '90102', 1);
INSERT INTO `xy_specialities` VALUES (503, '植物保护', '90103', 1);
INSERT INTO `xy_specialities` VALUES (504, '植物科学与技术', '90104', 1);
INSERT INTO `xy_specialities` VALUES (505, '种子科学与工程', '90105', 1);
INSERT INTO `xy_specialities` VALUES (506, '设施农业科学与工程', '90106', 1);
INSERT INTO `xy_specialities` VALUES (507, '茶学', '090107T', 1);
INSERT INTO `xy_specialities` VALUES (508, '烟草', '090108T', 1);
INSERT INTO `xy_specialities` VALUES (509, '应用生物科学', '090109T', 1);
INSERT INTO `xy_specialities` VALUES (510, '农艺教育', '090110T', 1);
INSERT INTO `xy_specialities` VALUES (511, '园艺教育', '090111T', 1);
INSERT INTO `xy_specialities` VALUES (512, '智慧农业', NULL, 1);
INSERT INTO `xy_specialities` VALUES (513, '菌物科学与工程', NULL, 1);
INSERT INTO `xy_specialities` VALUES (514, '农药化肥', NULL, 1);
INSERT INTO `xy_specialities` VALUES (515, '农业资源与环境', '90201', 1);
INSERT INTO `xy_specialities` VALUES (516, '野生动物与自然保护区管理', '90202', 1);
INSERT INTO `xy_specialities` VALUES (517, '水土保持与荒漠化防治', '90203', 1);
INSERT INTO `xy_specialities` VALUES (518, '生物质科学与工程', '090204T', 1);
INSERT INTO `xy_specialities` VALUES (519, '动物科学', '90301', 1);
INSERT INTO `xy_specialities` VALUES (520, '蚕学', '090302T', 1);
INSERT INTO `xy_specialities` VALUES (521, '蜂学', '090303T', 1);
INSERT INTO `xy_specialities` VALUES (522, '经济动物学', '090304T', 1);
INSERT INTO `xy_specialities` VALUES (523, '马业科学', '090305T', 1);
INSERT INTO `xy_specialities` VALUES (524, '动物医学', '90401', 1);
INSERT INTO `xy_specialities` VALUES (525, '动物药学', '90402', 1);
INSERT INTO `xy_specialities` VALUES (526, '动植物检疫', '090403T', 1);
INSERT INTO `xy_specialities` VALUES (527, '实验动物学', '090404T', 1);
INSERT INTO `xy_specialities` VALUES (528, '中兽医学', '090405T', 1);
INSERT INTO `xy_specialities` VALUES (529, '林学', '90501', 1);
INSERT INTO `xy_specialities` VALUES (530, '园林', '90502', 1);
INSERT INTO `xy_specialities` VALUES (531, '森林保护', '90503', 1);
INSERT INTO `xy_specialities` VALUES (532, '经济林', '090504T', 1);
INSERT INTO `xy_specialities` VALUES (533, '水产养殖学', '90601', 1);
INSERT INTO `xy_specialities` VALUES (534, '海洋渔业科学与技术', '90602', 1);
INSERT INTO `xy_specialities` VALUES (535, '水族科学与技术', '090603T', 1);
INSERT INTO `xy_specialities` VALUES (536, '水生动物医学', '090604TK', 1);
INSERT INTO `xy_specialities` VALUES (537, '草业科学', '90701', 1);
INSERT INTO `xy_specialities` VALUES (538, '草坪科学与工程', '090702T', 1);
INSERT INTO `xy_specialities` VALUES (539, '基础医学', '100101K', 1);
INSERT INTO `xy_specialities` VALUES (540, '生物医学', '100102TK', 1);
INSERT INTO `xy_specialities` VALUES (541, '生物医学科学', '100103T', 1);
INSERT INTO `xy_specialities` VALUES (542, '临床医学', '100201K', 1);
INSERT INTO `xy_specialities` VALUES (543, '麻醉学', '100202TK', 1);
INSERT INTO `xy_specialities` VALUES (544, '医学影像学', '100203TK', 1);
INSERT INTO `xy_specialities` VALUES (545, '眼视光医学', '100204TK', 1);
INSERT INTO `xy_specialities` VALUES (546, '精神医学', '100205TK', 1);
INSERT INTO `xy_specialities` VALUES (547, '放射医学', '100206TK', 1);
INSERT INTO `xy_specialities` VALUES (548, '儿科学', '100207TK', 1);
INSERT INTO `xy_specialities` VALUES (549, '口腔医学', '100301K', 1);
INSERT INTO `xy_specialities` VALUES (550, '预防医学', '100401K', 1);
INSERT INTO `xy_specialities` VALUES (551, '食品卫生与营养学', '100402', 1);
INSERT INTO `xy_specialities` VALUES (552, '妇幼保健医学', '100403TK', 1);
INSERT INTO `xy_specialities` VALUES (553, '卫生监督', '100404TK', 1);
INSERT INTO `xy_specialities` VALUES (554, '全球健康学', '100405TK', 1);
INSERT INTO `xy_specialities` VALUES (555, '中医学', '100501K', 1);
INSERT INTO `xy_specialities` VALUES (556, '针灸推拿学', '100502K', 1);
INSERT INTO `xy_specialities` VALUES (557, '藏医学', '100503K', 1);
INSERT INTO `xy_specialities` VALUES (558, '蒙医学', '100504K', 1);
INSERT INTO `xy_specialities` VALUES (559, '维医学', '100505K', 1);
INSERT INTO `xy_specialities` VALUES (560, '壮医学', '100506K', 1);
INSERT INTO `xy_specialities` VALUES (561, '哈医学', '100507K', 1);
INSERT INTO `xy_specialities` VALUES (562, '傣医学', '100508TK', 1);
INSERT INTO `xy_specialities` VALUES (563, '回医学', '100509TK', 1);
INSERT INTO `xy_specialities` VALUES (564, '中医康复学', '100510TK', 1);
INSERT INTO `xy_specialities` VALUES (565, '中医养生学', '100511TK', 1);
INSERT INTO `xy_specialities` VALUES (566, '中医儿科学', '100512TK', 1);
INSERT INTO `xy_specialities` VALUES (567, '中医骨伤科学', '100513TK', 1);
INSERT INTO `xy_specialities` VALUES (568, '中西医临床医学', '100601K', 1);
INSERT INTO `xy_specialities` VALUES (569, '药学', '100701', 1);
INSERT INTO `xy_specialities` VALUES (570, '药物制剂', '100702', 1);
INSERT INTO `xy_specialities` VALUES (571, '临床药学', '100703TK', 1);
INSERT INTO `xy_specialities` VALUES (572, '药事管理', '100704T', 1);
INSERT INTO `xy_specialities` VALUES (573, '药物分析', '100705T', 1);
INSERT INTO `xy_specialities` VALUES (574, '药物化学', '100706T', 1);
INSERT INTO `xy_specialities` VALUES (575, '海洋药学', '100707T', 1);
INSERT INTO `xy_specialities` VALUES (576, '化妆品科学与技术', '100708T', 1);
INSERT INTO `xy_specialities` VALUES (577, '中药学', '100801', 1);
INSERT INTO `xy_specialities` VALUES (578, '中药资源与开发', '100802', 1);
INSERT INTO `xy_specialities` VALUES (579, '藏药学', '100803T', 1);
INSERT INTO `xy_specialities` VALUES (580, '蒙药学', '100804T', 1);
INSERT INTO `xy_specialities` VALUES (581, '中药制药', '100805T', 1);
INSERT INTO `xy_specialities` VALUES (582, '中草药栽培与鉴定', '100806T', 1);
INSERT INTO `xy_specialities` VALUES (583, '法医学', '100901K', 1);
INSERT INTO `xy_specialities` VALUES (584, '医学检验技术', '101001', 1);
INSERT INTO `xy_specialities` VALUES (585, '医学实验技术', '101002', 1);
INSERT INTO `xy_specialities` VALUES (586, '医学影像技术', '101003', 1);
INSERT INTO `xy_specialities` VALUES (587, '眼视光学', '101004', 1);
INSERT INTO `xy_specialities` VALUES (588, '康复治疗学', '101005', 1);
INSERT INTO `xy_specialities` VALUES (589, '口腔医学技术', '101006', 1);
INSERT INTO `xy_specialities` VALUES (590, '卫生检验与检疫', '101007', 1);
INSERT INTO `xy_specialities` VALUES (591, '听力与言语康复学', '101008T', 1);
INSERT INTO `xy_specialities` VALUES (592, '康复物理治疗', '101009T', 1);
INSERT INTO `xy_specialities` VALUES (593, '康复作业治疗', '101010T', 1);
INSERT INTO `xy_specialities` VALUES (594, '智能医学工程', '101011T', 1);
INSERT INTO `xy_specialities` VALUES (595, '护理学', '101101', 1);
INSERT INTO `xy_specialities` VALUES (596, '助产学', '101102T', 1);
INSERT INTO `xy_specialities` VALUES (597, '管理科学', '120101', 1);
INSERT INTO `xy_specialities` VALUES (598, '信息管理与信息系统', '120102', 1);
INSERT INTO `xy_specialities` VALUES (599, '工程管理', '120103', 1);
INSERT INTO `xy_specialities` VALUES (600, '房地产开发与管理', '120104', 1);
INSERT INTO `xy_specialities` VALUES (601, '工程造价', '120105', 1);
INSERT INTO `xy_specialities` VALUES (602, '保密管理', '120106TK', 1);
INSERT INTO `xy_specialities` VALUES (603, '邮政管理', '120107T', 1);
INSERT INTO `xy_specialities` VALUES (604, '大数据管理与应用', '120108T', 1);
INSERT INTO `xy_specialities` VALUES (605, '工程审计', '120109T', 1);
INSERT INTO `xy_specialities` VALUES (606, '计算金融', '120110T', 1);
INSERT INTO `xy_specialities` VALUES (607, '应急管理', NULL, 1);
INSERT INTO `xy_specialities` VALUES (608, '工商管理', '120201K', 1);
INSERT INTO `xy_specialities` VALUES (609, '市场营销', '120202', 1);
INSERT INTO `xy_specialities` VALUES (610, '会计学', '120203K', 1);
INSERT INTO `xy_specialities` VALUES (611, '财务管理', '120204', 1);
INSERT INTO `xy_specialities` VALUES (612, '国际商务', '120205', 1);
INSERT INTO `xy_specialities` VALUES (613, '人力资源管理', '120206', 1);
INSERT INTO `xy_specialities` VALUES (614, '审计学', '120207', 1);
INSERT INTO `xy_specialities` VALUES (615, '资产评估', '120208', 1);
INSERT INTO `xy_specialities` VALUES (616, '物业管理', '120209', 1);
INSERT INTO `xy_specialities` VALUES (617, '文化产业管理', '120210', 1);
INSERT INTO `xy_specialities` VALUES (618, '劳动关系', '120211T', 1);
INSERT INTO `xy_specialities` VALUES (619, '体育经济与管理', '120212T', 1);
INSERT INTO `xy_specialities` VALUES (620, '财务会计教育', '120213T', 1);
INSERT INTO `xy_specialities` VALUES (621, '市场营销教育', '120214T', 1);
INSERT INTO `xy_specialities` VALUES (622, '零售业管理', '120215T', 1);
INSERT INTO `xy_specialities` VALUES (623, '农林经济管理', '120301', 1);
INSERT INTO `xy_specialities` VALUES (624, '农村区域发展', '120302', 1);
INSERT INTO `xy_specialities` VALUES (625, '公共事业管理', '120401', 1);
INSERT INTO `xy_specialities` VALUES (626, '行政管理', '120402', 1);
INSERT INTO `xy_specialities` VALUES (627, '劳动与社会保障', '120403', 1);
INSERT INTO `xy_specialities` VALUES (628, '土地资源管理', '120404', 1);
INSERT INTO `xy_specialities` VALUES (629, '城市管理', '120405', 1);
INSERT INTO `xy_specialities` VALUES (630, '海关管理', '120406TK', 1);
INSERT INTO `xy_specialities` VALUES (631, '交通管理', '120407T', 1);
INSERT INTO `xy_specialities` VALUES (632, '海事管理', '120408T', 1);
INSERT INTO `xy_specialities` VALUES (633, '公共关系学', '120409T', 1);
INSERT INTO `xy_specialities` VALUES (634, '健康服务与管理', '120410T', 1);
INSERT INTO `xy_specialities` VALUES (635, '海警后勤管理', '120411TK', 1);
INSERT INTO `xy_specialities` VALUES (636, '医疗产品管理', '120412T', 1);
INSERT INTO `xy_specialities` VALUES (637, '医疗保险', NULL, 1);
INSERT INTO `xy_specialities` VALUES (638, '养老服务管理', NULL, 1);
INSERT INTO `xy_specialities` VALUES (639, '图书馆学', '120501', 1);
INSERT INTO `xy_specialities` VALUES (640, '档案学', '120502', 1);
INSERT INTO `xy_specialities` VALUES (641, '信息资源管理', '120503', 1);
INSERT INTO `xy_specialities` VALUES (642, '物流管理', '120601', 1);
INSERT INTO `xy_specialities` VALUES (643, '物流工程', '120602', 1);
INSERT INTO `xy_specialities` VALUES (644, '采购管理', '120603T', 1);
INSERT INTO `xy_specialities` VALUES (645, '供应链管理', '120604T', 1);
INSERT INTO `xy_specialities` VALUES (646, '工业工程', '120701', 1);
INSERT INTO `xy_specialities` VALUES (647, '标准化工程', '120702T', 1);
INSERT INTO `xy_specialities` VALUES (648, '质量管理工程', '120703T', 1);
INSERT INTO `xy_specialities` VALUES (649, '电子商务', '120801', 1);
INSERT INTO `xy_specialities` VALUES (650, '电子商务及法律', '120802T', 1);
INSERT INTO `xy_specialities` VALUES (651, '跨境电子商务', NULL, 1);
INSERT INTO `xy_specialities` VALUES (652, '旅游管理', '120901K', 1);
INSERT INTO `xy_specialities` VALUES (653, '酒店管理', '120902', 1);
INSERT INTO `xy_specialities` VALUES (654, '会展经济与管理', '120903', 1);
INSERT INTO `xy_specialities` VALUES (655, '旅游管理与服务教育', '120904T', 1);
INSERT INTO `xy_specialities` VALUES (656, '艺术史论', '130101', 1);
INSERT INTO `xy_specialities` VALUES (657, '艺术管理', '130102T', 1);
INSERT INTO `xy_specialities` VALUES (658, '音乐表演', '130201', 1);
INSERT INTO `xy_specialities` VALUES (659, '音乐学', '130202', 1);
INSERT INTO `xy_specialities` VALUES (660, '作曲与作曲技术理论', '130203', 1);
INSERT INTO `xy_specialities` VALUES (661, '舞蹈表演', '130204', 1);
INSERT INTO `xy_specialities` VALUES (662, '舞蹈学', '130205', 1);
INSERT INTO `xy_specialities` VALUES (663, '舞蹈编导', '130206', 1);
INSERT INTO `xy_specialities` VALUES (664, '舞蹈教育', '130207T', 1);
INSERT INTO `xy_specialities` VALUES (665, '航空服务艺术与管理', '130208TK', 1);
INSERT INTO `xy_specialities` VALUES (666, '流行音乐', '130209T', 1);
INSERT INTO `xy_specialities` VALUES (667, '音乐治疗', '130210T', 1);
INSERT INTO `xy_specialities` VALUES (668, '流行舞蹈', '130211T', 1);
INSERT INTO `xy_specialities` VALUES (669, '表演', '130301', 1);
INSERT INTO `xy_specialities` VALUES (670, '戏剧学', '130302', 1);
INSERT INTO `xy_specialities` VALUES (671, '电影学', '130303', 1);
INSERT INTO `xy_specialities` VALUES (672, '戏剧影视文学', '130304', 1);
INSERT INTO `xy_specialities` VALUES (673, '广播电视编导', '130305', 1);
INSERT INTO `xy_specialities` VALUES (674, '戏剧影视导演', '130306', 1);
INSERT INTO `xy_specialities` VALUES (675, '戏剧影视美术设计', '130307', 1);
INSERT INTO `xy_specialities` VALUES (676, '录音艺术', '130308', 1);
INSERT INTO `xy_specialities` VALUES (677, '播音与主持艺术', '130309', 1);
INSERT INTO `xy_specialities` VALUES (678, '动画', '130310', 1);
INSERT INTO `xy_specialities` VALUES (679, '影视摄影与制作', '130311T', 1);
INSERT INTO `xy_specialities` VALUES (680, '影视技术', '130312T', 1);
INSERT INTO `xy_specialities` VALUES (681, '戏剧教育', '130313T', 1);
INSERT INTO `xy_specialities` VALUES (682, '美术学', '130401', 1);
INSERT INTO `xy_specialities` VALUES (683, '绘画', '130402', 1);
INSERT INTO `xy_specialities` VALUES (684, '雕塑', '130403', 1);
INSERT INTO `xy_specialities` VALUES (685, '摄影', '130404', 1);
INSERT INTO `xy_specialities` VALUES (686, '书法学', '130405T', 1);
INSERT INTO `xy_specialities` VALUES (687, '中国画', '130406T', 1);
INSERT INTO `xy_specialities` VALUES (688, '实验艺术', '130407TK', 1);
INSERT INTO `xy_specialities` VALUES (689, '跨媒体艺术', '130408TK', 1);
INSERT INTO `xy_specialities` VALUES (690, '文物保护与修复', '130409T', 1);
INSERT INTO `xy_specialities` VALUES (691, '漫画', '130410T', 1);
INSERT INTO `xy_specialities` VALUES (692, '艺术设计学', '130501', 1);
INSERT INTO `xy_specialities` VALUES (693, '视觉传达设计', '130502', 1);
INSERT INTO `xy_specialities` VALUES (694, '环境设计', '130503', 1);
INSERT INTO `xy_specialities` VALUES (695, '产品设计', '130504', 1);
INSERT INTO `xy_specialities` VALUES (696, '服装与服饰设计', '130505', 1);
INSERT INTO `xy_specialities` VALUES (697, '公共艺术', '130506', 1);
INSERT INTO `xy_specialities` VALUES (698, '工艺美术', '130507', 1);
INSERT INTO `xy_specialities` VALUES (699, '数字媒体艺术', '130508', 1);
INSERT INTO `xy_specialities` VALUES (700, '艺术与科技', '130509T', 1);
INSERT INTO `xy_specialities` VALUES (701, '陶瓷艺术设计', '130510TK', 1);
INSERT INTO `xy_specialities` VALUES (702, '新媒体艺术', '130511T', 1);
INSERT INTO `xy_specialities` VALUES (703, '包装设计', '130512T', 1);
INSERT INTO `xy_specialities` VALUES (704, '作物生产技术', '510101', 0);
INSERT INTO `xy_specialities` VALUES (705, '种子生产与经营', '510102', 0);
INSERT INTO `xy_specialities` VALUES (706, '设施农业与装备', '510103', 0);
INSERT INTO `xy_specialities` VALUES (707, '现代农业技术', '510104', 0);
INSERT INTO `xy_specialities` VALUES (708, '休闲农业', '510105', 0);
INSERT INTO `xy_specialities` VALUES (709, '生态农业技术', '510106', 0);
INSERT INTO `xy_specialities` VALUES (710, '园艺技术', '510107', 0);
INSERT INTO `xy_specialities` VALUES (711, '植物保护与检疫技术', '510108', 0);
INSERT INTO `xy_specialities` VALUES (712, '茶树栽培与茶叶加工', '510109', 0);
INSERT INTO `xy_specialities` VALUES (713, '中草药栽培技术', '510110', 0);
INSERT INTO `xy_specialities` VALUES (714, '烟草栽培与加工', '510111', 0);
INSERT INTO `xy_specialities` VALUES (715, '棉花加工与经营管理', '510112', 0);
INSERT INTO `xy_specialities` VALUES (716, '农产品加工与质量检测', '510113', 0);
INSERT INTO `xy_specialities` VALUES (717, '绿色食品生产与检验', '510114', 0);
INSERT INTO `xy_specialities` VALUES (718, '农资营销与服务', '510115', 0);
INSERT INTO `xy_specialities` VALUES (719, '农产品流通与管理', '510116', 0);
INSERT INTO `xy_specialities` VALUES (720, '农业装备应用技术', '510117', 0);
INSERT INTO `xy_specialities` VALUES (721, '农业经济管理', '510118', 0);
INSERT INTO `xy_specialities` VALUES (722, '农村经营管理', '510119', 0);
INSERT INTO `xy_specialities` VALUES (723, '林业技术', '510201', 0);
INSERT INTO `xy_specialities` VALUES (724, '园林技术', '510202', 0);
INSERT INTO `xy_specialities` VALUES (725, '森林资源保护', '510203', 0);
INSERT INTO `xy_specialities` VALUES (726, '经济林培育与利用', '510204', 0);
INSERT INTO `xy_specialities` VALUES (727, '野生植物资源保护与利用', '510205', 0);
INSERT INTO `xy_specialities` VALUES (728, '野生动物资源保护与利用', '510206', 0);
INSERT INTO `xy_specialities` VALUES (729, '森林生态旅游', '510207', 0);
INSERT INTO `xy_specialities` VALUES (730, '森林防火指挥与通讯', '510208', 0);
INSERT INTO `xy_specialities` VALUES (731, '自然保护区建设与管理', '510209', 0);
INSERT INTO `xy_specialities` VALUES (732, '木工设备应用技术', '510210', 0);
INSERT INTO `xy_specialities` VALUES (733, '木材加工技术', '510211', 0);
INSERT INTO `xy_specialities` VALUES (734, '林业调查与信息处理', '510212', 0);
INSERT INTO `xy_specialities` VALUES (735, '林业信息技术与管理', '510213', 0);
INSERT INTO `xy_specialities` VALUES (736, '畜牧兽医', '510301', 0);
INSERT INTO `xy_specialities` VALUES (737, '动物医学', '510302', 0);
INSERT INTO `xy_specialities` VALUES (738, '动物药学', '510303', 0);
INSERT INTO `xy_specialities` VALUES (739, '动物防疫与检疫', '510304', 0);
INSERT INTO `xy_specialities` VALUES (740, '动物医学检验技术', '510305', 0);
INSERT INTO `xy_specialities` VALUES (741, '宠物养护与驯导', '510306', 0);
INSERT INTO `xy_specialities` VALUES (742, '实验动物技术', '510307', 0);
INSERT INTO `xy_specialities` VALUES (743, '饲料与动物营养', '510308', 0);
INSERT INTO `xy_specialities` VALUES (744, '特种动物养殖', '510309', 0);
INSERT INTO `xy_specialities` VALUES (745, '畜牧工程技术', '510310', 0);
INSERT INTO `xy_specialities` VALUES (746, '蚕桑技术', '510311', 0);
INSERT INTO `xy_specialities` VALUES (747, '草业技术', '510312', 0);
INSERT INTO `xy_specialities` VALUES (748, '养蜂与蜂产品加工', '510313', 0);
INSERT INTO `xy_specialities` VALUES (749, '畜牧业经济管理', '510314', 0);
INSERT INTO `xy_specialities` VALUES (750, '水产养殖技术', '510401', 0);
INSERT INTO `xy_specialities` VALUES (751, '海洋渔业技术', '510402', 0);
INSERT INTO `xy_specialities` VALUES (752, '水族科学与技术', '510403', 0);
INSERT INTO `xy_specialities` VALUES (753, '水生动物医学', '510404', 0);
INSERT INTO `xy_specialities` VALUES (754, '渔业经济管理', '510405', 0);
INSERT INTO `xy_specialities` VALUES (755, '国土资源调查与管理', '520101', 0);
INSERT INTO `xy_specialities` VALUES (756, '地质调查与矿产普查', '520102', 0);
INSERT INTO `xy_specialities` VALUES (757, '矿产地质与勘查', '520103', 0);
INSERT INTO `xy_specialities` VALUES (758, '岩矿分析与鉴定', '520104', 0);
INSERT INTO `xy_specialities` VALUES (759, '宝玉石鉴定与加工', '520105', 0);
INSERT INTO `xy_specialities` VALUES (760, '煤田地质与勘查技术', '520106', 0);
INSERT INTO `xy_specialities` VALUES (761, '工程地质勘查', '520201', 0);
INSERT INTO `xy_specialities` VALUES (762, '水文与工程地质', '520202', 0);
INSERT INTO `xy_specialities` VALUES (763, '钻探技术', '520203', 0);
INSERT INTO `xy_specialities` VALUES (764, '矿山地质', '520204', 0);
INSERT INTO `xy_specialities` VALUES (765, '地球物理勘探技术', '520205', 0);
INSERT INTO `xy_specialities` VALUES (766, '地质灾害调查与防治', '520206', 0);
INSERT INTO `xy_specialities` VALUES (767, '环境地质工程', '520207', 0);
INSERT INTO `xy_specialities` VALUES (768, '岩土工程技术', '520208', 0);
INSERT INTO `xy_specialities` VALUES (769, '工程测量技术', '520301', 0);
INSERT INTO `xy_specialities` VALUES (770, '摄影测量与遥感技术', '520302', 0);
INSERT INTO `xy_specialities` VALUES (771, '测绘工程技术', '520303', 0);
INSERT INTO `xy_specialities` VALUES (772, '测绘地理信息技术', '520304', 0);
INSERT INTO `xy_specialities` VALUES (773, '地籍测绘与土地管理', '520305', 0);
INSERT INTO `xy_specialities` VALUES (774, '矿山测量', '520306', 0);
INSERT INTO `xy_specialities` VALUES (775, '测绘与地质工程技术', '520307', 0);
INSERT INTO `xy_specialities` VALUES (776, '导航与位置服务', '520308', 0);
INSERT INTO `xy_specialities` VALUES (777, '地图制图与数字传播技术', '520309', 0);
INSERT INTO `xy_specialities` VALUES (778, '地理国情监测技术', '520310', 0);
INSERT INTO `xy_specialities` VALUES (779, '国土测绘与规划', '520311', 0);
INSERT INTO `xy_specialities` VALUES (780, '钻井技术', '520401', 0);
INSERT INTO `xy_specialities` VALUES (781, '油气开采技术', '520402', 0);
INSERT INTO `xy_specialities` VALUES (782, '油气储运技术', '520403', 0);
INSERT INTO `xy_specialities` VALUES (783, '油气地质勘探技术', '520404', 0);
INSERT INTO `xy_specialities` VALUES (784, '油田化学应用技术', '520405', 0);
INSERT INTO `xy_specialities` VALUES (785, '石油工程技术', '520406', 0);
INSERT INTO `xy_specialities` VALUES (786, '煤矿开采技术', '520501', 0);
INSERT INTO `xy_specialities` VALUES (787, '矿井建设', '520502', 0);
INSERT INTO `xy_specialities` VALUES (788, '矿山机电技术', '520503', 0);
INSERT INTO `xy_specialities` VALUES (789, '矿井通风与安全', '520504', 0);
INSERT INTO `xy_specialities` VALUES (790, '综合机械化采煤', '520505', 0);
INSERT INTO `xy_specialities` VALUES (791, '选煤技术', '520506', 0);
INSERT INTO `xy_specialities` VALUES (792, '煤炭深加工与利用', '520507', 0);
INSERT INTO `xy_specialities` VALUES (793, '煤化分析与检验', '520508', 0);
INSERT INTO `xy_specialities` VALUES (794, '煤层气采输技术', '520509', 0);
INSERT INTO `xy_specialities` VALUES (795, '矿井运输与提升', '520510', 0);
INSERT INTO `xy_specialities` VALUES (796, '金属与非金属矿开采技术', '520601', 0);
INSERT INTO `xy_specialities` VALUES (797, '矿物加工技术', '520602', 0);
INSERT INTO `xy_specialities` VALUES (798, '矿业装备维护技术', '520603', 0);
INSERT INTO `xy_specialities` VALUES (799, '大气科学技术', '520701', 0);
INSERT INTO `xy_specialities` VALUES (800, '大气探测技术', '520702', 0);
INSERT INTO `xy_specialities` VALUES (801, '应用气象技术', '520703', 0);
INSERT INTO `xy_specialities` VALUES (802, '防雷技术', '520704', 0);
INSERT INTO `xy_specialities` VALUES (803, '环境监测与控制技术', '520801', 0);
INSERT INTO `xy_specialities` VALUES (804, '农村环境保护', '520802', 0);
INSERT INTO `xy_specialities` VALUES (805, '室内环境检测与控制技术', '520803', 0);
INSERT INTO `xy_specialities` VALUES (806, '环境工程技术', '520804', 0);
INSERT INTO `xy_specialities` VALUES (807, '环境信息技术', '520805', 0);
INSERT INTO `xy_specialities` VALUES (808, '核与辐射检测防护技术', '520806', 0);
INSERT INTO `xy_specialities` VALUES (809, '环境规划与管理', '520807', 0);
INSERT INTO `xy_specialities` VALUES (810, '环境评价与咨询服务', '520808', 0);
INSERT INTO `xy_specialities` VALUES (811, '污染修复与生态工程技术', '520809', 0);
INSERT INTO `xy_specialities` VALUES (812, '清洁生产与减排技术', '520810', 0);
INSERT INTO `xy_specialities` VALUES (813, '资源综合利用与管理技术', '520811', 0);
INSERT INTO `xy_specialities` VALUES (814, '安全健康与环保', '520901', 0);
INSERT INTO `xy_specialities` VALUES (815, '化工安全技术', '520902', 0);
INSERT INTO `xy_specialities` VALUES (816, '救援技术', '520903', 0);
INSERT INTO `xy_specialities` VALUES (817, '安全技术与管理', '520904', 0);
INSERT INTO `xy_specialities` VALUES (818, '工程安全评价与监理', '520905', 0);
INSERT INTO `xy_specialities` VALUES (819, '安全生产监测监控', '520906', 0);
INSERT INTO `xy_specialities` VALUES (820, '职业卫生技术与管理', '520907', 0);
INSERT INTO `xy_specialities` VALUES (821, '发电厂及电力系统', '530101', 0);
INSERT INTO `xy_specialities` VALUES (822, '供用电技术', '530102', 0);
INSERT INTO `xy_specialities` VALUES (823, '电力系统自动化技术', '530103', 0);
INSERT INTO `xy_specialities` VALUES (824, '高压输配电线路施工运行与维护', '530104', 0);
INSERT INTO `xy_specialities` VALUES (825, '电力系统继电保护与自动化技术', '530105', 0);
INSERT INTO `xy_specialities` VALUES (826, '水电站机电设备与自动化', '530106', 0);
INSERT INTO `xy_specialities` VALUES (827, '电网监控技术', '530107', 0);
INSERT INTO `xy_specialities` VALUES (828, '电力客户服务与管理', '530108', 0);
INSERT INTO `xy_specialities` VALUES (829, '水电站与电力网', '530109', 0);
INSERT INTO `xy_specialities` VALUES (830, '电源变换技术与应用', '530110', 0);
INSERT INTO `xy_specialities` VALUES (831, '农业电气化技术', '530111', 0);
INSERT INTO `xy_specialities` VALUES (832, '分布式发电与微电网技术', '530112', 0);
INSERT INTO `xy_specialities` VALUES (833, '电厂热能动力装置', '530201', 0);
INSERT INTO `xy_specialities` VALUES (834, '城市热能应用技术', '530202', 0);
INSERT INTO `xy_specialities` VALUES (835, '核电站动力设备运行与维护', '530203', 0);
INSERT INTO `xy_specialities` VALUES (836, '火电厂集控运行', '530204', 0);
INSERT INTO `xy_specialities` VALUES (837, '电厂化学与环保技术', '530205', 0);
INSERT INTO `xy_specialities` VALUES (838, '电厂热工自动化技术', '530206', 0);
INSERT INTO `xy_specialities` VALUES (839, '风力发电工程技术', '530301', 0);
INSERT INTO `xy_specialities` VALUES (840, '风电系统运行与维护', '530302', 0);
INSERT INTO `xy_specialities` VALUES (841, '生物质能应用技术', '530303', 0);
INSERT INTO `xy_specialities` VALUES (842, '光伏发电技术与应用', '530304', 0);
INSERT INTO `xy_specialities` VALUES (843, '工业节能技术', '530305', 0);
INSERT INTO `xy_specialities` VALUES (844, '节电技术与管理', '530306', 0);
INSERT INTO `xy_specialities` VALUES (845, '太阳能光热技术与应用', '530307', 0);
INSERT INTO `xy_specialities` VALUES (846, '农村能源与环境技术', '530308', 0);
INSERT INTO `xy_specialities` VALUES (847, '黑色冶金技术', '530401', 0);
INSERT INTO `xy_specialities` VALUES (848, '轧钢工程技术', '530402', 0);
INSERT INTO `xy_specialities` VALUES (849, '钢铁冶金设备应用技术', '530403', 0);
INSERT INTO `xy_specialities` VALUES (850, '金属材料质量检测', '530404', 0);
INSERT INTO `xy_specialities` VALUES (851, '铁矿资源综合利用', '530405', 0);
INSERT INTO `xy_specialities` VALUES (852, '有色冶金技术', '530501', 0);
INSERT INTO `xy_specialities` VALUES (853, '有色冶金设备应用技术', '530502', 0);
INSERT INTO `xy_specialities` VALUES (854, '金属压力加工', '530503', 0);
INSERT INTO `xy_specialities` VALUES (855, '金属精密成型技术', '530504', 0);
INSERT INTO `xy_specialities` VALUES (856, '材料工程技术', '530601', 0);
INSERT INTO `xy_specialities` VALUES (857, '高分子材料工程技术', '530602', 0);
INSERT INTO `xy_specialities` VALUES (858, '复合材料工程技术', '530603', 0);
INSERT INTO `xy_specialities` VALUES (859, '非金属矿物材料技术', '530604', 0);
INSERT INTO `xy_specialities` VALUES (860, '光伏材料制备技术', '530605', 0);
INSERT INTO `xy_specialities` VALUES (861, '炭素加工技术', '530606', 0);
INSERT INTO `xy_specialities` VALUES (862, '硅材料制备技术', '530607', 0);
INSERT INTO `xy_specialities` VALUES (863, '橡胶工程技术', '530608', 0);
INSERT INTO `xy_specialities` VALUES (864, '建筑材料工程技术', '530701', 0);
INSERT INTO `xy_specialities` VALUES (865, '建筑材料检测技术', '530702', 0);
INSERT INTO `xy_specialities` VALUES (866, '建筑装饰材料技术', '530703', 0);
INSERT INTO `xy_specialities` VALUES (867, '建筑材料设备应用', '530704', 0);
INSERT INTO `xy_specialities` VALUES (868, '新型建筑材料技术', '530705', 0);
INSERT INTO `xy_specialities` VALUES (869, '建筑材料生产与管理', '530706', 0);
INSERT INTO `xy_specialities` VALUES (870, '建筑设计', '540101', 0);
INSERT INTO `xy_specialities` VALUES (871, '建筑装饰工程技术', '540102', 0);
INSERT INTO `xy_specialities` VALUES (872, '古建筑工程技术', '540103', 0);
INSERT INTO `xy_specialities` VALUES (873, '建筑室内设计', '540104', 0);
INSERT INTO `xy_specialities` VALUES (874, '风景园林设计', '540105', 0);
INSERT INTO `xy_specialities` VALUES (875, '园林工程技术', '540106', 0);
INSERT INTO `xy_specialities` VALUES (876, '建筑动画与模型制作', '540107', 0);
INSERT INTO `xy_specialities` VALUES (877, '城乡规划', '540201', 0);
INSERT INTO `xy_specialities` VALUES (878, '村镇建设与管理', '540202', 0);
INSERT INTO `xy_specialities` VALUES (879, '城市信息化管理', '540203', 0);
INSERT INTO `xy_specialities` VALUES (880, '建筑工程技术', '540301', 0);
INSERT INTO `xy_specialities` VALUES (881, '地下与隧道工程技术', '540302', 0);
INSERT INTO `xy_specialities` VALUES (882, '土木工程检测技术', '540303', 0);
INSERT INTO `xy_specialities` VALUES (883, '建筑钢结构工程技术', '540304', 0);
INSERT INTO `xy_specialities` VALUES (884, '建筑设备工程技术', '540401', 0);
INSERT INTO `xy_specialities` VALUES (885, '供热通风与空调工程技术', '540402', 0);
INSERT INTO `xy_specialities` VALUES (886, '建筑电气工程技术', '540403', 0);
INSERT INTO `xy_specialities` VALUES (887, '建筑智能化工程技术', '540404', 0);
INSERT INTO `xy_specialities` VALUES (888, '工业设备安装工程技术', '540405', 0);
INSERT INTO `xy_specialities` VALUES (889, '消防工程技术', '540406', 0);
INSERT INTO `xy_specialities` VALUES (890, '建设工程管理', '540501', 0);
INSERT INTO `xy_specialities` VALUES (891, '工程造价', '540502', 0);
INSERT INTO `xy_specialities` VALUES (892, '建筑经济管理', '540503', 0);
INSERT INTO `xy_specialities` VALUES (893, '建设项目信息化管理', '540504', 0);
INSERT INTO `xy_specialities` VALUES (894, '建设工程监理', '540505', 0);
INSERT INTO `xy_specialities` VALUES (895, '市政工程技术', '540601', 0);
INSERT INTO `xy_specialities` VALUES (896, '城市燃气工程技术', '540602', 0);
INSERT INTO `xy_specialities` VALUES (897, '给排水工程技术', '540603', 0);
INSERT INTO `xy_specialities` VALUES (898, '环境卫生工程技术', '540604', 0);
INSERT INTO `xy_specialities` VALUES (899, '房地产经营与管理', '540701', 0);
INSERT INTO `xy_specialities` VALUES (900, '房地产检测与估价', '540702', 0);
INSERT INTO `xy_specialities` VALUES (901, '物业管理', '540703', 0);
INSERT INTO `xy_specialities` VALUES (902, '水文与水资源工程', '550101', 0);
INSERT INTO `xy_specialities` VALUES (903, '水文测报技术', '550102', 0);
INSERT INTO `xy_specialities` VALUES (904, '水政水资源管理', '550103', 0);
INSERT INTO `xy_specialities` VALUES (905, '水利工程', '550201', 0);
INSERT INTO `xy_specialities` VALUES (906, '水利水电工程技术', '550202', 0);
INSERT INTO `xy_specialities` VALUES (907, '水利水电工程管理', '550203', 0);
INSERT INTO `xy_specialities` VALUES (908, '水利水电建筑工程', '550204', 0);
INSERT INTO `xy_specialities` VALUES (909, '机电排灌工程技术', '550205', 0);
INSERT INTO `xy_specialities` VALUES (910, '港口航道与治河工程', '550206', 0);
INSERT INTO `xy_specialities` VALUES (911, '水务管理', '550207', 0);
INSERT INTO `xy_specialities` VALUES (912, '水电站动力设备', '550301', 0);
INSERT INTO `xy_specialities` VALUES (913, '水电站电气设备', '550302', 0);
INSERT INTO `xy_specialities` VALUES (914, '水电站运行与管理', '550303', 0);
INSERT INTO `xy_specialities` VALUES (915, '水利机电设备运行与管理', '550304', 0);
INSERT INTO `xy_specialities` VALUES (916, '水土保持技术', '550401', 0);
INSERT INTO `xy_specialities` VALUES (917, '水环境监测与治理', '550402', 0);
INSERT INTO `xy_specialities` VALUES (918, '机械设计与制造', '560101', 0);
INSERT INTO `xy_specialities` VALUES (919, '机械制造与自动化', '560102', 0);
INSERT INTO `xy_specialities` VALUES (920, '数控技术', '560103', 0);
INSERT INTO `xy_specialities` VALUES (921, '精密机械技术', '560104', 0);
INSERT INTO `xy_specialities` VALUES (922, '特种加工技术', '560105', 0);
INSERT INTO `xy_specialities` VALUES (923, '材料成型与控制技术', '560106', 0);
INSERT INTO `xy_specialities` VALUES (924, '金属材料与热处理技术', '560107', 0);
INSERT INTO `xy_specialities` VALUES (925, '铸造技术', '560108', 0);
INSERT INTO `xy_specialities` VALUES (926, '锻压技术', '560109', 0);
INSERT INTO `xy_specialities` VALUES (927, '焊接技术与自动化', '560110', 0);
INSERT INTO `xy_specialities` VALUES (928, '机械产品检测检验技术', '560111', 0);
INSERT INTO `xy_specialities` VALUES (929, '理化测试与质检技术', '560112', 0);
INSERT INTO `xy_specialities` VALUES (930, '模具设计与制造', '560113', 0);
INSERT INTO `xy_specialities` VALUES (931, '电机与电器技术', '560114', 0);
INSERT INTO `xy_specialities` VALUES (932, '电线电缆制造技术', '560115', 0);
INSERT INTO `xy_specialities` VALUES (933, '内燃机制造与维修', '560116', 0);
INSERT INTO `xy_specialities` VALUES (934, '机械装备制造技术', '560117', 0);
INSERT INTO `xy_specialities` VALUES (935, '工业设计', '560118', 0);
INSERT INTO `xy_specialities` VALUES (936, '工业工程技术', '560119', 0);
INSERT INTO `xy_specialities` VALUES (937, '自动化生产设备应用', '560201', 0);
INSERT INTO `xy_specialities` VALUES (938, '机电设备安装技术', '560202', 0);
INSERT INTO `xy_specialities` VALUES (939, '机电设备维修与管理', '560203', 0);
INSERT INTO `xy_specialities` VALUES (940, '数控设备应用与维护', '560204', 0);
INSERT INTO `xy_specialities` VALUES (941, '制冷与空调技术', '560205', 0);
INSERT INTO `xy_specialities` VALUES (942, '光电制造与应用技术', '560206', 0);
INSERT INTO `xy_specialities` VALUES (943, '新能源装备技术', '560207', 0);
INSERT INTO `xy_specialities` VALUES (944, '机电一体化技术', '560301', 0);
INSERT INTO `xy_specialities` VALUES (945, '电气自动化技术', '560302', 0);
INSERT INTO `xy_specialities` VALUES (946, '工业过程自动化技术', '560303', 0);
INSERT INTO `xy_specialities` VALUES (947, '智能控制技术', '560304', 0);
INSERT INTO `xy_specialities` VALUES (948, '工业网络技术', '560305', 0);
INSERT INTO `xy_specialities` VALUES (949, '工业自动化仪表', '560306', 0);
INSERT INTO `xy_specialities` VALUES (950, '液压与气动技术', '560307', 0);
INSERT INTO `xy_specialities` VALUES (951, '电梯工程技术', '560308', 0);
INSERT INTO `xy_specialities` VALUES (952, '工业机器人技术', '560309', 0);
INSERT INTO `xy_specialities` VALUES (953, '铁道机车车辆制造与维护', '560401', 0);
INSERT INTO `xy_specialities` VALUES (954, '铁道通信信号设备制造与维护', '560402', 0);
INSERT INTO `xy_specialities` VALUES (955, '铁道施工和养路机械制造与维护', '560403', 0);
INSERT INTO `xy_specialities` VALUES (956, '船舶工程技术', '560501', 0);
INSERT INTO `xy_specialities` VALUES (957, '船舶机械工程技术', '560502', 0);
INSERT INTO `xy_specialities` VALUES (958, '船舶电气工程技术', '560503', 0);
INSERT INTO `xy_specialities` VALUES (959, '船舶舾装工程技术', '560504', 0);
INSERT INTO `xy_specialities` VALUES (960, '船舶涂装工程技术', '560505', 0);
INSERT INTO `xy_specialities` VALUES (961, '游艇设计与制造', '560506', 0);
INSERT INTO `xy_specialities` VALUES (962, '海洋工程技术', '560507', 0);
INSERT INTO `xy_specialities` VALUES (963, '船舶通信与导航', '560508', 0);
INSERT INTO `xy_specialities` VALUES (964, '船舶动力工程技术', '560509', 0);
INSERT INTO `xy_specialities` VALUES (965, '飞行器制造技术', '560601', 0);
INSERT INTO `xy_specialities` VALUES (966, '飞行器维修技术', '560602', 0);
INSERT INTO `xy_specialities` VALUES (967, '航空发动机制造技术', '560603', 0);
INSERT INTO `xy_specialities` VALUES (968, '航空发动机装试技术', '560604', 0);
INSERT INTO `xy_specialities` VALUES (969, '航空发动机维修技术', '560605', 0);
INSERT INTO `xy_specialities` VALUES (970, '飞机机载设备制造技术', '560606', 0);
INSERT INTO `xy_specialities` VALUES (971, '飞机机载设备维修技术', '560607', 0);
INSERT INTO `xy_specialities` VALUES (972, '航空电子电气技术', '560608', 0);
INSERT INTO `xy_specialities` VALUES (973, '航空材料精密成型技术', '560609', 0);
INSERT INTO `xy_specialities` VALUES (974, '无人机应用技术', '560610', 0);
INSERT INTO `xy_specialities` VALUES (975, '导弹维修', '560611', 0);
INSERT INTO `xy_specialities` VALUES (976, '汽车制造与装配技术', '560701', 0);
INSERT INTO `xy_specialities` VALUES (977, '汽车检测与维修技术', '560702', 0);
INSERT INTO `xy_specialities` VALUES (978, '汽车电子技术', '560703', 0);
INSERT INTO `xy_specialities` VALUES (979, '食品生物技术', '570101', 0);
INSERT INTO `xy_specialities` VALUES (980, '化工生物技术', '570102', 0);
INSERT INTO `xy_specialities` VALUES (981, '药品生物技术', '570103', 0);
INSERT INTO `xy_specialities` VALUES (982, '农业生物技术', '570104', 0);
INSERT INTO `xy_specialities` VALUES (983, '生物产品检验检疫', '570105', 0);
INSERT INTO `xy_specialities` VALUES (984, '应用化工技术', '570201', 0);
INSERT INTO `xy_specialities` VALUES (985, '石油炼制技术', '570202', 0);
INSERT INTO `xy_specialities` VALUES (986, '石油化工技术', '570203', 0);
INSERT INTO `xy_specialities` VALUES (987, '高分子合成技术', '570204', 0);
INSERT INTO `xy_specialities` VALUES (988, '精细化工技术', '570205', 0);
INSERT INTO `xy_specialities` VALUES (989, '海洋化工技术', '570206', 0);
INSERT INTO `xy_specialities` VALUES (990, '工业分析技术', '570207', 0);
INSERT INTO `xy_specialities` VALUES (991, '化工装备技术', '570208', 0);
INSERT INTO `xy_specialities` VALUES (992, '化工自动化技术', '570209', 0);
INSERT INTO `xy_specialities` VALUES (993, '涂装防护技术', '570210', 0);
INSERT INTO `xy_specialities` VALUES (994, '烟花爆竹技术与管理', '570211', 0);
INSERT INTO `xy_specialities` VALUES (995, '煤化工技术', '570212', 0);
INSERT INTO `xy_specialities` VALUES (996, '高分子材料加工技术', '580101', 0);
INSERT INTO `xy_specialities` VALUES (997, '制浆造纸技术', '580102', 0);
INSERT INTO `xy_specialities` VALUES (998, '香料香精工艺', '580103', 0);
INSERT INTO `xy_specialities` VALUES (999, '表面精饰工艺', '580104', 0);
INSERT INTO `xy_specialities` VALUES (1000, '家具设计与制造', '580105', 0);
INSERT INTO `xy_specialities` VALUES (1001, '化妆品技术', '580106', 0);
INSERT INTO `xy_specialities` VALUES (1002, '皮革加工技术', '580107', 0);
INSERT INTO `xy_specialities` VALUES (1003, '皮具制作与工艺', '580108', 0);
INSERT INTO `xy_specialities` VALUES (1004, '鞋类设计与工艺', '580109', 0);
INSERT INTO `xy_specialities` VALUES (1005, '乐器制造与维护', '580110', 0);
INSERT INTO `xy_specialities` VALUES (1006, '陶瓷制造工艺', '580111', 0);
INSERT INTO `xy_specialities` VALUES (1007, '包装工程技术', '580201', 0);
INSERT INTO `xy_specialities` VALUES (1008, '包装策划与设计', '580202', 0);
INSERT INTO `xy_specialities` VALUES (1009, '包装设备应用技术', '580203', 0);
INSERT INTO `xy_specialities` VALUES (1010, '食品包装技术', '580204', 0);
INSERT INTO `xy_specialities` VALUES (1011, '数字图文信息技术', '580301', 0);
INSERT INTO `xy_specialities` VALUES (1012, '印刷设备应用技术', '580302', 0);
INSERT INTO `xy_specialities` VALUES (1013, '印刷媒体设计与制作', '580303', 0);
INSERT INTO `xy_specialities` VALUES (1014, '印刷媒体技术', '580304', 0);
INSERT INTO `xy_specialities` VALUES (1015, '数字印刷技术', '580305', 0);
INSERT INTO `xy_specialities` VALUES (1016, '现代纺织技术', '580401', 0);
INSERT INTO `xy_specialities` VALUES (1017, '丝绸技术', '580402', 0);
INSERT INTO `xy_specialities` VALUES (1018, '染整技术', '580403', 0);
INSERT INTO `xy_specialities` VALUES (1019, '纺织机电技术', '580404', 0);
INSERT INTO `xy_specialities` VALUES (1020, '纺织品检验与贸易', '580405', 0);
INSERT INTO `xy_specialities` VALUES (1021, '纺织品设计', '580406', 0);
INSERT INTO `xy_specialities` VALUES (1022, '家用纺织品设计', '580407', 0);
INSERT INTO `xy_specialities` VALUES (1023, '纺织材料与应用', '580408', 0);
INSERT INTO `xy_specialities` VALUES (1024, '针织技术与针织服装', '580409', 0);
INSERT INTO `xy_specialities` VALUES (1025, '服装设计与工艺', '580410', 0);
INSERT INTO `xy_specialities` VALUES (1026, '皮革服装制作与工艺', '580411', 0);
INSERT INTO `xy_specialities` VALUES (1027, '服装陈列与展示设计', '580412', 0);
INSERT INTO `xy_specialities` VALUES (1028, '食品加工技术', '590101', 0);
INSERT INTO `xy_specialities` VALUES (1029, '酿酒技术', '590102', 0);
INSERT INTO `xy_specialities` VALUES (1030, '食品质量与安全', '590103', 0);
INSERT INTO `xy_specialities` VALUES (1031, '食品贮运与营销', '590104', 0);
INSERT INTO `xy_specialities` VALUES (1032, '食品检测技术', '590105', 0);
INSERT INTO `xy_specialities` VALUES (1033, '食品营养与卫生', '590106', 0);
INSERT INTO `xy_specialities` VALUES (1034, '食品营养与检测', '590107', 0);
INSERT INTO `xy_specialities` VALUES (1035, '中药生产与加工', '590201', 0);
INSERT INTO `xy_specialities` VALUES (1036, '药品生产技术', '590202', 0);
INSERT INTO `xy_specialities` VALUES (1037, '兽药制药技术', '590203', 0);
INSERT INTO `xy_specialities` VALUES (1038, '药品质量与安全', '590204', 0);
INSERT INTO `xy_specialities` VALUES (1039, '制药设备应用技术', '590205', 0);
INSERT INTO `xy_specialities` VALUES (1040, '药品经营与管理', '590301', 0);
INSERT INTO `xy_specialities` VALUES (1041, '药品服务与管理', '590302', 0);
INSERT INTO `xy_specialities` VALUES (1042, '保健品开发与管理', '590303', 0);
INSERT INTO `xy_specialities` VALUES (1043, '化妆品经营与管理', '590304', 0);
INSERT INTO `xy_specialities` VALUES (1044, '粮食工程技术', '590401', 0);
INSERT INTO `xy_specialities` VALUES (1045, '粮油储藏与检测技术', '590501', 0);
INSERT INTO `xy_specialities` VALUES (1046, '铁道机车', '600101', 0);
INSERT INTO `xy_specialities` VALUES (1047, '铁道车辆', '600102', 0);
INSERT INTO `xy_specialities` VALUES (1048, '铁道供电技术', '600103', 0);
INSERT INTO `xy_specialities` VALUES (1049, '铁道工程技术', '600104', 0);
INSERT INTO `xy_specialities` VALUES (1050, '铁道机械化维修技术', '600105', 0);
INSERT INTO `xy_specialities` VALUES (1051, '铁道信号自动控制', '600106', 0);
INSERT INTO `xy_specialities` VALUES (1052, '铁道通信与信息化技术', '600107', 0);
INSERT INTO `xy_specialities` VALUES (1053, '铁道交通运营管理', '600108', 0);
INSERT INTO `xy_specialities` VALUES (1054, '铁路物流管理', '600109', 0);
INSERT INTO `xy_specialities` VALUES (1055, '铁路桥梁与隧道工程技术', '600110', 0);
INSERT INTO `xy_specialities` VALUES (1056, '高速铁道工程技术', '600111', 0);
INSERT INTO `xy_specialities` VALUES (1057, '高速铁路客运乘务', '600112', 0);
INSERT INTO `xy_specialities` VALUES (1058, '动车组检修技术', '600113', 0);
INSERT INTO `xy_specialities` VALUES (1059, '智能交通技术运用', '600201', 0);
INSERT INTO `xy_specialities` VALUES (1060, '道路桥梁工程技术', '600202', 0);
INSERT INTO `xy_specialities` VALUES (1061, '道路运输与路政管理', '600203', 0);
INSERT INTO `xy_specialities` VALUES (1062, '道路养护与管理', '600204', 0);
INSERT INTO `xy_specialities` VALUES (1063, '公路机械化施工技术', '600205', 0);
INSERT INTO `xy_specialities` VALUES (1064, '工程机械运用技术', '600206', 0);
INSERT INTO `xy_specialities` VALUES (1065, '交通运营管理', '600207', 0);
INSERT INTO `xy_specialities` VALUES (1066, '交通枢纽运营管理', '600208', 0);
INSERT INTO `xy_specialities` VALUES (1067, '汽车运用与维修技术', '600209', 0);
INSERT INTO `xy_specialities` VALUES (1068, '汽车车身维修技术', '600210', 0);
INSERT INTO `xy_specialities` VALUES (1069, '汽车运用安全管理', '600211', 0);
INSERT INTO `xy_specialities` VALUES (1070, '新能源汽车运用与维修', '600212', 0);
INSERT INTO `xy_specialities` VALUES (1071, '航海技术', '600301', 0);
INSERT INTO `xy_specialities` VALUES (1072, '国际邮轮乘务管理', '600302', 0);
INSERT INTO `xy_specialities` VALUES (1073, '船舶电子电气技术', '600303', 0);
INSERT INTO `xy_specialities` VALUES (1074, '船舶检验', '600304', 0);
INSERT INTO `xy_specialities` VALUES (1075, '港口机械与自动控制', '600305', 0);
INSERT INTO `xy_specialities` VALUES (1076, '港口电气技术', '600306', 0);
INSERT INTO `xy_specialities` VALUES (1077, '港口与航道工程技术', '600307', 0);
INSERT INTO `xy_specialities` VALUES (1078, '港口与航运管理', '600308', 0);
INSERT INTO `xy_specialities` VALUES (1079, '港口物流管理', '600309', 0);
INSERT INTO `xy_specialities` VALUES (1080, '轮机工程技术', '600310', 0);
INSERT INTO `xy_specialities` VALUES (1081, '水上救捞技术', '600311', 0);
INSERT INTO `xy_specialities` VALUES (1082, '水路运输与海事管理', '600312', 0);
INSERT INTO `xy_specialities` VALUES (1083, '集装箱运输管理', '600313', 0);
INSERT INTO `xy_specialities` VALUES (1084, '民航运输', '600401', 0);
INSERT INTO `xy_specialities` VALUES (1085, '民航通信技术', '600402', 0);
INSERT INTO `xy_specialities` VALUES (1086, '定翼机驾驶技术', '600403', 0);
INSERT INTO `xy_specialities` VALUES (1087, '直升机驾驶技术', '600404', 0);
INSERT INTO `xy_specialities` VALUES (1088, '空中乘务', '600405', 0);
INSERT INTO `xy_specialities` VALUES (1089, '民航安全技术管理', '600406', 0);
INSERT INTO `xy_specialities` VALUES (1090, '民航空中安全保卫', '600407', 0);
INSERT INTO `xy_specialities` VALUES (1091, '机场运行', '600408', 0);
INSERT INTO `xy_specialities` VALUES (1092, '飞机机电设备维修', '600409', 0);
INSERT INTO `xy_specialities` VALUES (1093, '飞机电子设备维修', '600410', 0);
INSERT INTO `xy_specialities` VALUES (1094, '飞机部件修理', '600411', 0);
INSERT INTO `xy_specialities` VALUES (1095, '航空地面设备维修', '600412', 0);
INSERT INTO `xy_specialities` VALUES (1096, '机场场务技术与管理', '600413', 0);
INSERT INTO `xy_specialities` VALUES (1097, '航空油料', '600414', 0);
INSERT INTO `xy_specialities` VALUES (1098, '航空物流', '600415', 0);
INSERT INTO `xy_specialities` VALUES (1099, '通用航空器维修', '600416', 0);
INSERT INTO `xy_specialities` VALUES (1100, '通用航空航务技术', '600417', 0);
INSERT INTO `xy_specialities` VALUES (1101, '飞机结构修理', '600418', 0);
INSERT INTO `xy_specialities` VALUES (1102, '管道工程技术', '600501', 0);
INSERT INTO `xy_specialities` VALUES (1103, '管道运输管理', '600502', 0);
INSERT INTO `xy_specialities` VALUES (1104, '城市轨道交通车辆技术', '600601', 0);
INSERT INTO `xy_specialities` VALUES (1105, '城市轨道交通机电技术', '600602', 0);
INSERT INTO `xy_specialities` VALUES (1106, '城市轨道交通通信信号技术', '600603', 0);
INSERT INTO `xy_specialities` VALUES (1107, '城市轨道交通供配电技术', '600604', 0);
INSERT INTO `xy_specialities` VALUES (1108, '城市轨道交通工程技术', '600605', 0);
INSERT INTO `xy_specialities` VALUES (1109, '城市轨道交通运营管理', '600606', 0);
INSERT INTO `xy_specialities` VALUES (1110, '邮政通信管理', '600701', 0);
INSERT INTO `xy_specialities` VALUES (1111, '快递运营管理', '600702', 0);
INSERT INTO `xy_specialities` VALUES (1112, '电子信息工程技术', '610101', 0);
INSERT INTO `xy_specialities` VALUES (1113, '应用电子技术', '610102', 0);
INSERT INTO `xy_specialities` VALUES (1114, '微电子技术', '610103', 0);
INSERT INTO `xy_specialities` VALUES (1115, '智能产品开发', '610104', 0);
INSERT INTO `xy_specialities` VALUES (1116, '智能终端技术与应用', '610105', 0);
INSERT INTO `xy_specialities` VALUES (1117, '智能监控技术应用', '610106', 0);
INSERT INTO `xy_specialities` VALUES (1118, '汽车智能技术', '610107', 0);
INSERT INTO `xy_specialities` VALUES (1119, '电子产品质量检测', '610108', 0);
INSERT INTO `xy_specialities` VALUES (1120, '电子产品营销与服务', '610109', 0);
INSERT INTO `xy_specialities` VALUES (1121, '电子电路设计与工艺', '610110', 0);
INSERT INTO `xy_specialities` VALUES (1122, '电子制造技术与设备', '610111', 0);
INSERT INTO `xy_specialities` VALUES (1123, '电子测量技术与仪器', '610112', 0);
INSERT INTO `xy_specialities` VALUES (1124, '电子工艺与管理', '610113', 0);
INSERT INTO `xy_specialities` VALUES (1125, '声像工程技术', '610114', 0);
INSERT INTO `xy_specialities` VALUES (1126, '移动互联应用技术', '610115', 0);
INSERT INTO `xy_specialities` VALUES (1127, '光电技术应用', '610116', 0);
INSERT INTO `xy_specialities` VALUES (1128, '光伏工程技术', '610117', 0);
INSERT INTO `xy_specialities` VALUES (1129, '光电显示技术', '610118', 0);
INSERT INTO `xy_specialities` VALUES (1130, '物联网应用技术', '610119', 0);
INSERT INTO `xy_specialities` VALUES (1131, '计算机应用技术', '610201', 0);
INSERT INTO `xy_specialities` VALUES (1132, '计算机网络技术', '610202', 0);
INSERT INTO `xy_specialities` VALUES (1133, '计算机信息管理', '610203', 0);
INSERT INTO `xy_specialities` VALUES (1134, '计算机系统与维护', '610204', 0);
INSERT INTO `xy_specialities` VALUES (1135, '软件技术', '610205', 0);
INSERT INTO `xy_specialities` VALUES (1136, '软件与信息服务', '610206', 0);
INSERT INTO `xy_specialities` VALUES (1137, '动漫制作技术', '610207', 0);
INSERT INTO `xy_specialities` VALUES (1138, '嵌入式技术与应用', '610208', 0);
INSERT INTO `xy_specialities` VALUES (1139, '数字展示技术', '610209', 0);
INSERT INTO `xy_specialities` VALUES (1140, '数字媒体应用技术', '610210', 0);
INSERT INTO `xy_specialities` VALUES (1141, '信息安全与管理', '610211', 0);
INSERT INTO `xy_specialities` VALUES (1142, '移动应用开发', '610212', 0);
INSERT INTO `xy_specialities` VALUES (1143, '云计算技术与应用', '610213', 0);
INSERT INTO `xy_specialities` VALUES (1144, '电子商务技术', '610214', 0);
INSERT INTO `xy_specialities` VALUES (1145, '通信技术', '610301', 0);
INSERT INTO `xy_specialities` VALUES (1146, '移动通信技术', '610302', 0);
INSERT INTO `xy_specialities` VALUES (1147, '通信系统运行管理', '610303', 0);
INSERT INTO `xy_specialities` VALUES (1148, '通信工程设计与监理', '610304', 0);
INSERT INTO `xy_specialities` VALUES (1149, '电信服务与管理', '610305', 0);
INSERT INTO `xy_specialities` VALUES (1150, '光通信技术', '610306', 0);
INSERT INTO `xy_specialities` VALUES (1151, '物联网工程技术', '610307', 0);
INSERT INTO `xy_specialities` VALUES (1152, '临床医学', '620101K', 0);
INSERT INTO `xy_specialities` VALUES (1153, '口腔医学', '620102K', 0);
INSERT INTO `xy_specialities` VALUES (1154, '中医学', '620103K', 0);
INSERT INTO `xy_specialities` VALUES (1155, '中医骨伤', '620104K', 0);
INSERT INTO `xy_specialities` VALUES (1156, '针灸推拿', '620105K', 0);
INSERT INTO `xy_specialities` VALUES (1157, '蒙医学', '620106K', 0);
INSERT INTO `xy_specialities` VALUES (1158, '藏医学', '620107K', 0);
INSERT INTO `xy_specialities` VALUES (1159, '维医学', '620108K', 0);
INSERT INTO `xy_specialities` VALUES (1160, '傣医学', '620109K', 0);
INSERT INTO `xy_specialities` VALUES (1161, '哈医学', '620110K', 0);
INSERT INTO `xy_specialities` VALUES (1162, '护理', '620201', 0);
INSERT INTO `xy_specialities` VALUES (1163, '助产', '620202', 0);
INSERT INTO `xy_specialities` VALUES (1164, '药学', '620301', 0);
INSERT INTO `xy_specialities` VALUES (1165, '中药学', '620302', 0);
INSERT INTO `xy_specialities` VALUES (1166, '蒙药学', '620303', 0);
INSERT INTO `xy_specialities` VALUES (1167, '维药学', '620304', 0);
INSERT INTO `xy_specialities` VALUES (1168, '藏药学', '620305', 0);
INSERT INTO `xy_specialities` VALUES (1169, '医学检验技术', '620401', 0);
INSERT INTO `xy_specialities` VALUES (1170, '医学生物技术', '620402', 0);
INSERT INTO `xy_specialities` VALUES (1171, '医学影像技术', '620403', 0);
INSERT INTO `xy_specialities` VALUES (1172, '医学美容技术', '620404', 0);
INSERT INTO `xy_specialities` VALUES (1173, '口腔医学技术', '620405', 0);
INSERT INTO `xy_specialities` VALUES (1174, '卫生检验与检疫技术', '620406', 0);
INSERT INTO `xy_specialities` VALUES (1175, '眼视光技术', '620407', 0);
INSERT INTO `xy_specialities` VALUES (1176, '放射治疗技术', '620408', 0);
INSERT INTO `xy_specialities` VALUES (1177, '呼吸治疗技术', '620409', 0);
INSERT INTO `xy_specialities` VALUES (1178, '康复治疗技术', '620501', 0);
INSERT INTO `xy_specialities` VALUES (1179, '言语听觉康复技术', '620502', 0);
INSERT INTO `xy_specialities` VALUES (1180, '中医康复技术', '620503', 0);
INSERT INTO `xy_specialities` VALUES (1181, '预防医学', '620601K', 0);
INSERT INTO `xy_specialities` VALUES (1182, '公共卫生管理', '620602', 0);
INSERT INTO `xy_specialities` VALUES (1183, '卫生监督', '620603', 0);
INSERT INTO `xy_specialities` VALUES (1184, '卫生信息管理', '620604', 0);
INSERT INTO `xy_specialities` VALUES (1185, '人口与家庭发展服务', '620701', 0);
INSERT INTO `xy_specialities` VALUES (1186, '生殖健康服务与管理', '620702', 0);
INSERT INTO `xy_specialities` VALUES (1187, '健康管理', '620801', 0);
INSERT INTO `xy_specialities` VALUES (1188, '医学营养', '620802', 0);
INSERT INTO `xy_specialities` VALUES (1189, '中医养生保健', '620803', 0);
INSERT INTO `xy_specialities` VALUES (1190, '心理咨询', '620804', 0);
INSERT INTO `xy_specialities` VALUES (1191, '医疗设备应用技术', '620805', 0);
INSERT INTO `xy_specialities` VALUES (1192, '精密医疗器械技术', '620806', 0);
INSERT INTO `xy_specialities` VALUES (1193, '医疗器械维护与管理', '620807', 0);
INSERT INTO `xy_specialities` VALUES (1194, '康复工程技术', '620808', 0);
INSERT INTO `xy_specialities` VALUES (1195, '康复辅助器具技术', '620809', 0);
INSERT INTO `xy_specialities` VALUES (1196, '假肢与矫形器技术', '620810', 0);
INSERT INTO `xy_specialities` VALUES (1197, '老年保健与管理', '620811', 0);
INSERT INTO `xy_specialities` VALUES (1198, '财政', '630101', 0);
INSERT INTO `xy_specialities` VALUES (1199, '税务', '630102', 0);
INSERT INTO `xy_specialities` VALUES (1200, '资产评估与管理', '630103', 0);
INSERT INTO `xy_specialities` VALUES (1201, '政府采购管理', '630104', 0);
INSERT INTO `xy_specialities` VALUES (1202, '金融管理', '630201', 0);
INSERT INTO `xy_specialities` VALUES (1203, '国际金融', '630202', 0);
INSERT INTO `xy_specialities` VALUES (1204, '证券与期货', '630203', 0);
INSERT INTO `xy_specialities` VALUES (1205, '信托与租赁', '630204', 0);
INSERT INTO `xy_specialities` VALUES (1206, '保险', '630205', 0);
INSERT INTO `xy_specialities` VALUES (1207, '投资与理财', '630206', 0);
INSERT INTO `xy_specialities` VALUES (1208, '信用管理', '630207', 0);
INSERT INTO `xy_specialities` VALUES (1209, '农村金融', '630208', 0);
INSERT INTO `xy_specialities` VALUES (1210, '互联网金融', '630209', 0);
INSERT INTO `xy_specialities` VALUES (1211, '财务管理', '630301', 0);
INSERT INTO `xy_specialities` VALUES (1212, '会计', '630302', 0);
INSERT INTO `xy_specialities` VALUES (1213, '审计', '630303', 0);
INSERT INTO `xy_specialities` VALUES (1214, '会计信息管理', '630304', 0);
INSERT INTO `xy_specialities` VALUES (1215, '信息统计与分析', '630401', 0);
INSERT INTO `xy_specialities` VALUES (1216, '统计与会计核算', '630402', 0);
INSERT INTO `xy_specialities` VALUES (1217, '国际贸易实务', '630501', 0);
INSERT INTO `xy_specialities` VALUES (1218, '国际经济与贸易', '630502', 0);
INSERT INTO `xy_specialities` VALUES (1219, '国际商务', '630503', 0);
INSERT INTO `xy_specialities` VALUES (1220, '服务外包', '630504', 0);
INSERT INTO `xy_specialities` VALUES (1221, '经济信息管理', '630505', 0);
INSERT INTO `xy_specialities` VALUES (1222, '报关与国际货运', '630506', 0);
INSERT INTO `xy_specialities` VALUES (1223, '商务经纪与代理', '630507', 0);
INSERT INTO `xy_specialities` VALUES (1224, '国际文化贸易', '630508', 0);
INSERT INTO `xy_specialities` VALUES (1225, '工商企业管理', '630601', 0);
INSERT INTO `xy_specialities` VALUES (1226, '商务管理', '630602', 0);
INSERT INTO `xy_specialities` VALUES (1227, '商检技术', '630603', 0);
INSERT INTO `xy_specialities` VALUES (1228, '连锁经营管理', '630604', 0);
INSERT INTO `xy_specialities` VALUES (1229, '市场管理与服务', '630605', 0);
INSERT INTO `xy_specialities` VALUES (1230, '品牌代理经营', '630606', 0);
INSERT INTO `xy_specialities` VALUES (1231, '市场营销', '630701', 0);
INSERT INTO `xy_specialities` VALUES (1232, '汽车营销与服务', '630702', 0);
INSERT INTO `xy_specialities` VALUES (1233, '广告策划与营销', '630703', 0);
INSERT INTO `xy_specialities` VALUES (1234, '茶艺与茶叶营销', '630704', 0);
INSERT INTO `xy_specialities` VALUES (1235, '电子商务', '630801', 0);
INSERT INTO `xy_specialities` VALUES (1236, '移动商务', '630802', 0);
INSERT INTO `xy_specialities` VALUES (1237, '网络营销', '630803', 0);
INSERT INTO `xy_specialities` VALUES (1238, '物流工程技术', '630901', 0);
INSERT INTO `xy_specialities` VALUES (1239, '物流信息技术', '630902', 0);
INSERT INTO `xy_specialities` VALUES (1240, '物流管理', '630903', 0);
INSERT INTO `xy_specialities` VALUES (1241, '物流金融管理', '630904', 0);
INSERT INTO `xy_specialities` VALUES (1242, '工程物流管理', '630905', 0);
INSERT INTO `xy_specialities` VALUES (1243, '冷链物流技术与管理', '630906', 0);
INSERT INTO `xy_specialities` VALUES (1244, '采购与供应管理', '630907', 0);
INSERT INTO `xy_specialities` VALUES (1245, '旅游管理', '640101', 0);
INSERT INTO `xy_specialities` VALUES (1246, '导游', '640102', 0);
INSERT INTO `xy_specialities` VALUES (1247, '旅行社经营管理', '640103', 0);
INSERT INTO `xy_specialities` VALUES (1248, '景区开发与管理', '640104', 0);
INSERT INTO `xy_specialities` VALUES (1249, '酒店管理', '640105', 0);
INSERT INTO `xy_specialities` VALUES (1250, '休闲服务与管理', '640106', 0);
INSERT INTO `xy_specialities` VALUES (1251, '餐饮管理', '640201', 0);
INSERT INTO `xy_specialities` VALUES (1252, '烹调工艺与营养', '640202', 0);
INSERT INTO `xy_specialities` VALUES (1253, '营养配餐', '640203', 0);
INSERT INTO `xy_specialities` VALUES (1254, '中西面点工艺', '640204', 0);
INSERT INTO `xy_specialities` VALUES (1255, '西餐工艺', '640205', 0);
INSERT INTO `xy_specialities` VALUES (1256, '会展策划与管理', '640301', 0);
INSERT INTO `xy_specialities` VALUES (1257, '艺术设计', '650101', 0);
INSERT INTO `xy_specialities` VALUES (1258, '视觉传播设计与制作', '650102', 0);
INSERT INTO `xy_specialities` VALUES (1259, '广告设计与制作', '650103', 0);
INSERT INTO `xy_specialities` VALUES (1260, '数字媒体艺术设计', '650104', 0);
INSERT INTO `xy_specialities` VALUES (1261, '产品艺术设计', '650105', 0);
INSERT INTO `xy_specialities` VALUES (1262, '家具艺术设计', '650106', 0);
INSERT INTO `xy_specialities` VALUES (1263, '皮具艺术设计', '650107', 0);
INSERT INTO `xy_specialities` VALUES (1264, '服装与服饰设计', '650108', 0);
INSERT INTO `xy_specialities` VALUES (1265, '室内艺术设计', '650109', 0);
INSERT INTO `xy_specialities` VALUES (1266, '展示艺术设计', '650110', 0);
INSERT INTO `xy_specialities` VALUES (1267, '环境艺术设计', '650111', 0);
INSERT INTO `xy_specialities` VALUES (1268, '公共艺术设计', '650112', 0);
INSERT INTO `xy_specialities` VALUES (1269, '雕刻艺术设计', '650113', 0);
INSERT INTO `xy_specialities` VALUES (1270, '包装艺术设计', '650114', 0);
INSERT INTO `xy_specialities` VALUES (1271, '陶瓷设计与工艺', '650115', 0);
INSERT INTO `xy_specialities` VALUES (1272, '刺绣设计与工艺', '650116', 0);
INSERT INTO `xy_specialities` VALUES (1273, '玉器设计与工艺', '650117', 0);
INSERT INTO `xy_specialities` VALUES (1274, '首饰设计与工艺', '650118', 0);
INSERT INTO `xy_specialities` VALUES (1275, '工艺美术品设计', '650119', 0);
INSERT INTO `xy_specialities` VALUES (1276, '动漫设计', '650120', 0);
INSERT INTO `xy_specialities` VALUES (1277, '游戏设计', '650121', 0);
INSERT INTO `xy_specialities` VALUES (1278, '人物形象设计', '650122', 0);
INSERT INTO `xy_specialities` VALUES (1279, '美容美体艺术', '650123', 0);
INSERT INTO `xy_specialities` VALUES (1280, '摄影与摄像艺术', '650124', 0);
INSERT INTO `xy_specialities` VALUES (1281, '美术', '650125', 0);
INSERT INTO `xy_specialities` VALUES (1282, '表演艺术', '650201', 0);
INSERT INTO `xy_specialities` VALUES (1283, '戏剧影视表演', '650202', 0);
INSERT INTO `xy_specialities` VALUES (1284, '歌舞表演', '650203', 0);
INSERT INTO `xy_specialities` VALUES (1285, '戏曲表演', '650204', 0);
INSERT INTO `xy_specialities` VALUES (1286, '曲艺表演', '650205', 0);
INSERT INTO `xy_specialities` VALUES (1287, '音乐剧表演', '650206', 0);
INSERT INTO `xy_specialities` VALUES (1288, '舞蹈表演', '650207', 0);
INSERT INTO `xy_specialities` VALUES (1289, '国际标准舞', '650208', 0);
INSERT INTO `xy_specialities` VALUES (1290, '服装表演', '650209', 0);
INSERT INTO `xy_specialities` VALUES (1291, '模特与礼仪', '650210', 0);
INSERT INTO `xy_specialities` VALUES (1292, '现代流行音乐', '650211', 0);
INSERT INTO `xy_specialities` VALUES (1293, '作曲技术', '650212', 0);
INSERT INTO `xy_specialities` VALUES (1294, '音乐制作', '650213', 0);
INSERT INTO `xy_specialities` VALUES (1295, '钢琴伴奏', '650214', 0);
INSERT INTO `xy_specialities` VALUES (1296, '钢琴调律', '650215', 0);
INSERT INTO `xy_specialities` VALUES (1297, '舞蹈编导', '650216', 0);
INSERT INTO `xy_specialities` VALUES (1298, '戏曲导演', '650217', 0);
INSERT INTO `xy_specialities` VALUES (1299, '舞台艺术设计与制作', '650218', 0);
INSERT INTO `xy_specialities` VALUES (1300, '音乐表演', '650219', 0);
INSERT INTO `xy_specialities` VALUES (1301, '民族表演艺术', '650301', 0);
INSERT INTO `xy_specialities` VALUES (1302, '民族美术', '650302', 0);
INSERT INTO `xy_specialities` VALUES (1303, '民族服装与服饰', '650303', 0);
INSERT INTO `xy_specialities` VALUES (1304, '民族民居装饰', '650304', 0);
INSERT INTO `xy_specialities` VALUES (1305, '民族传统技艺', '650305', 0);
INSERT INTO `xy_specialities` VALUES (1306, '少数民族古籍修复', '650306', 0);
INSERT INTO `xy_specialities` VALUES (1307, '中国少数民族语言文化', '650307', 0);
INSERT INTO `xy_specialities` VALUES (1308, '文化创意与策划', '650401', 0);
INSERT INTO `xy_specialities` VALUES (1309, '文化市场经营管理', '650402', 0);
INSERT INTO `xy_specialities` VALUES (1310, '公共文化服务与管理', '650403', 0);
INSERT INTO `xy_specialities` VALUES (1311, '文物修复与保护', '650404', 0);
INSERT INTO `xy_specialities` VALUES (1312, '考古探掘技术', '650405', 0);
INSERT INTO `xy_specialities` VALUES (1313, '文物博物馆服务与管理', '650406', 0);
INSERT INTO `xy_specialities` VALUES (1314, '图书档案管理', '650407', 0);
INSERT INTO `xy_specialities` VALUES (1315, '图文信息处理', '660101', 0);
INSERT INTO `xy_specialities` VALUES (1316, '网络新闻与传播', '660102', 0);
INSERT INTO `xy_specialities` VALUES (1317, '版面编辑与校对', '660103', 0);
INSERT INTO `xy_specialities` VALUES (1318, '出版商务', '660104', 0);
INSERT INTO `xy_specialities` VALUES (1319, '出版与电脑编辑技术', '660105', 0);
INSERT INTO `xy_specialities` VALUES (1320, '出版信息管理', '660106', 0);
INSERT INTO `xy_specialities` VALUES (1321, '数字出版', '660107', 0);
INSERT INTO `xy_specialities` VALUES (1322, '数字媒体设备管理', '660108', 0);
INSERT INTO `xy_specialities` VALUES (1323, '新闻采编与制作', '660201', 0);
INSERT INTO `xy_specialities` VALUES (1324, '播音与主持', '660202', 0);
INSERT INTO `xy_specialities` VALUES (1325, '广播影视节目制作', '660203', 0);
INSERT INTO `xy_specialities` VALUES (1326, '广播电视技术', '660204', 0);
INSERT INTO `xy_specialities` VALUES (1327, '影视制片管理', '660205', 0);
INSERT INTO `xy_specialities` VALUES (1328, '影视编导', '660206', 0);
INSERT INTO `xy_specialities` VALUES (1329, '影视美术', '660207', 0);
INSERT INTO `xy_specialities` VALUES (1330, '影视多媒体技术', '660208', 0);
INSERT INTO `xy_specialities` VALUES (1331, '影视动画', '660209', 0);
INSERT INTO `xy_specialities` VALUES (1332, '影视照明技术与艺术', '660210', 0);
INSERT INTO `xy_specialities` VALUES (1333, '音像技术', '660211', 0);
INSERT INTO `xy_specialities` VALUES (1334, '录音技术与艺术', '660212', 0);
INSERT INTO `xy_specialities` VALUES (1335, '摄影摄像技术', '660213', 0);
INSERT INTO `xy_specialities` VALUES (1336, '传播与策划', '660214', 0);
INSERT INTO `xy_specialities` VALUES (1337, '媒体营销', '660215', 0);
INSERT INTO `xy_specialities` VALUES (1338, '早期教育', '670101K', 0);
INSERT INTO `xy_specialities` VALUES (1339, '学前教育', '670102K', 0);
INSERT INTO `xy_specialities` VALUES (1340, '小学教育', '670103K', 0);
INSERT INTO `xy_specialities` VALUES (1341, '语文教育', '670104K', 0);
INSERT INTO `xy_specialities` VALUES (1342, '数学教育', '670105K', 0);
INSERT INTO `xy_specialities` VALUES (1343, '英语教育', '670106K', 0);
INSERT INTO `xy_specialities` VALUES (1344, '物理教育', '670107K', 0);
INSERT INTO `xy_specialities` VALUES (1345, '化学教育', '670108K', 0);
INSERT INTO `xy_specialities` VALUES (1346, '生物教育', '670109K', 0);
INSERT INTO `xy_specialities` VALUES (1347, '历史教育', '670110K', 0);
INSERT INTO `xy_specialities` VALUES (1348, '地理教育', '670111K', 0);
INSERT INTO `xy_specialities` VALUES (1349, '音乐教育', '670112K', 0);
INSERT INTO `xy_specialities` VALUES (1350, '美术教育', '670113K', 0);
INSERT INTO `xy_specialities` VALUES (1351, '体育教育', '670114K', 0);
INSERT INTO `xy_specialities` VALUES (1352, '思想政治教育', '670115K', 0);
INSERT INTO `xy_specialities` VALUES (1353, '舞蹈教育', '670116K', 0);
INSERT INTO `xy_specialities` VALUES (1354, '艺术教育', '670117K', 0);
INSERT INTO `xy_specialities` VALUES (1355, '特殊教育', '670118K', 0);
INSERT INTO `xy_specialities` VALUES (1356, '科学教育', '670119K', 0);
INSERT INTO `xy_specialities` VALUES (1357, '现代教育技术', '670120K', 0);
INSERT INTO `xy_specialities` VALUES (1358, '心理健康教育', '670121K', 0);
INSERT INTO `xy_specialities` VALUES (1359, '汉语', '670201', 0);
INSERT INTO `xy_specialities` VALUES (1360, '商务英语', '670202', 0);
INSERT INTO `xy_specialities` VALUES (1361, '应用英语', '670203', 0);
INSERT INTO `xy_specialities` VALUES (1362, '旅游英语', '670204', 0);
INSERT INTO `xy_specialities` VALUES (1363, '商务日语', '670205', 0);
INSERT INTO `xy_specialities` VALUES (1364, '应用日语', '670206', 0);
INSERT INTO `xy_specialities` VALUES (1365, '旅游日语', '670207', 0);
INSERT INTO `xy_specialities` VALUES (1366, '应用韩语', '670208', 0);
INSERT INTO `xy_specialities` VALUES (1367, '应用俄语', '670209', 0);
INSERT INTO `xy_specialities` VALUES (1368, '应用法语', '670210', 0);
INSERT INTO `xy_specialities` VALUES (1369, '应用德语', '670211', 0);
INSERT INTO `xy_specialities` VALUES (1370, '应用西班牙语', '670212', 0);
INSERT INTO `xy_specialities` VALUES (1371, '应用越南语', '670213', 0);
INSERT INTO `xy_specialities` VALUES (1372, '应用泰语', '670214', 0);
INSERT INTO `xy_specialities` VALUES (1373, '应用阿拉伯语', '670215', 0);
INSERT INTO `xy_specialities` VALUES (1374, '应用外语', '670216', 0);
INSERT INTO `xy_specialities` VALUES (1375, '文秘', '670301', 0);
INSERT INTO `xy_specialities` VALUES (1376, '文秘速录', '670302', 0);
INSERT INTO `xy_specialities` VALUES (1377, '运动训练', '670401', 0);
INSERT INTO `xy_specialities` VALUES (1378, '运动防护', '670402', 0);
INSERT INTO `xy_specialities` VALUES (1379, '社会体育', '670403', 0);
INSERT INTO `xy_specialities` VALUES (1380, '休闲体育', '670404', 0);
INSERT INTO `xy_specialities` VALUES (1381, '高尔夫球运动与管理', '670405', 0);
INSERT INTO `xy_specialities` VALUES (1382, '民族传统体育', '670406', 0);
INSERT INTO `xy_specialities` VALUES (1383, '体育艺术表演', '670407', 0);
INSERT INTO `xy_specialities` VALUES (1384, '体育运营与管理', '670408', 0);
INSERT INTO `xy_specialities` VALUES (1385, '体育保健与康复', '670409', 0);
INSERT INTO `xy_specialities` VALUES (1386, '健身指导与管理', '670410', 0);
INSERT INTO `xy_specialities` VALUES (1387, '治安管理', '680101K', 0);
INSERT INTO `xy_specialities` VALUES (1388, '交通管理', '680102K', 0);
INSERT INTO `xy_specialities` VALUES (1389, '信息网络安全监察', '680103K', 0);
INSERT INTO `xy_specialities` VALUES (1390, '防火管理', '680104K', 0);
INSERT INTO `xy_specialities` VALUES (1391, '边防检查', '680105K', 0);
INSERT INTO `xy_specialities` VALUES (1392, '边境管理', '680106K', 0);
INSERT INTO `xy_specialities` VALUES (1393, '特警', '680107K', 0);
INSERT INTO `xy_specialities` VALUES (1394, '警察管理', '680108K', 0);
INSERT INTO `xy_specialities` VALUES (1395, '公共安全管理', '680109K', 0);
INSERT INTO `xy_specialities` VALUES (1396, '森林消防', '680110K', 0);
INSERT INTO `xy_specialities` VALUES (1397, '部队后勤管理', '680111K', 0);
INSERT INTO `xy_specialities` VALUES (1398, '部队政治工作', '680112K', 0);
INSERT INTO `xy_specialities` VALUES (1399, '警察指挥与战术', '680201K', 0);
INSERT INTO `xy_specialities` VALUES (1400, '边防指挥', '680202K', 0);
INSERT INTO `xy_specialities` VALUES (1401, '船艇指挥', '680203K', 0);
INSERT INTO `xy_specialities` VALUES (1402, '通信指挥', '680204K', 0);
INSERT INTO `xy_specialities` VALUES (1403, '消防指挥', '680205K', 0);
INSERT INTO `xy_specialities` VALUES (1404, '参谋业务', '680206K', 0);
INSERT INTO `xy_specialities` VALUES (1405, '抢险救援', '680207K', 0);
INSERT INTO `xy_specialities` VALUES (1406, '刑事科学技术', '680301K', 0);
INSERT INTO `xy_specialities` VALUES (1407, '警犬技术', '680302K', 0);
INSERT INTO `xy_specialities` VALUES (1408, '刑事侦查', '680401K', 0);
INSERT INTO `xy_specialities` VALUES (1409, '国内安全保卫', '680402K', 0);
INSERT INTO `xy_specialities` VALUES (1410, '经济犯罪侦查', '680403K', 0);
INSERT INTO `xy_specialities` VALUES (1411, '禁毒', '680404K', 0);
INSERT INTO `xy_specialities` VALUES (1412, '司法助理', '680501', 0);
INSERT INTO `xy_specialities` VALUES (1413, '法律文秘', '680502', 0);
INSERT INTO `xy_specialities` VALUES (1414, '法律事务', '680503', 0);
INSERT INTO `xy_specialities` VALUES (1415, '检察事务', '680504', 0);
INSERT INTO `xy_specialities` VALUES (1416, '刑事执行', '680601K', 0);
INSERT INTO `xy_specialities` VALUES (1417, '民事执行', '680602', 0);
INSERT INTO `xy_specialities` VALUES (1418, '行政执行', '680603K', 0);
INSERT INTO `xy_specialities` VALUES (1419, '司法警务', '680604K', 0);
INSERT INTO `xy_specialities` VALUES (1420, '社区矫正', '680605', 0);
INSERT INTO `xy_specialities` VALUES (1421, '刑事侦查技术', '680701K', 0);
INSERT INTO `xy_specialities` VALUES (1422, '安全防范技术', '680702', 0);
INSERT INTO `xy_specialities` VALUES (1423, '司法信息技术', '680703K', 0);
INSERT INTO `xy_specialities` VALUES (1424, '司法鉴定技术', '680704', 0);
INSERT INTO `xy_specialities` VALUES (1425, '司法信息安全', '680705K', 0);
INSERT INTO `xy_specialities` VALUES (1426, '罪犯心理测量与矫正技术', '680706K', 0);
INSERT INTO `xy_specialities` VALUES (1427, '戒毒矫治技术', '680707K', 0);
INSERT INTO `xy_specialities` VALUES (1428, '职务犯罪预防与控制', '680708', 0);
INSERT INTO `xy_specialities` VALUES (1429, '社会工作', '690101', 0);
INSERT INTO `xy_specialities` VALUES (1430, '社会福利事业管理', '690102', 0);
INSERT INTO `xy_specialities` VALUES (1431, '青少年工作与管理', '690103', 0);
INSERT INTO `xy_specialities` VALUES (1432, '社区管理与服务', '690104', 0);
INSERT INTO `xy_specialities` VALUES (1433, '公共关系', '690105', 0);
INSERT INTO `xy_specialities` VALUES (1434, '人民武装', '690106', 0);
INSERT INTO `xy_specialities` VALUES (1435, '民政管理', '690201', 0);
INSERT INTO `xy_specialities` VALUES (1436, '人力资源管理', '690202', 0);
INSERT INTO `xy_specialities` VALUES (1437, '劳动与社会保障', '690203', 0);
INSERT INTO `xy_specialities` VALUES (1438, '网络舆情监测', '690204', 0);
INSERT INTO `xy_specialities` VALUES (1439, '公共事务管理', '690205', 0);
INSERT INTO `xy_specialities` VALUES (1440, '行政管理', '690206', 0);
INSERT INTO `xy_specialities` VALUES (1441, '质量管理与认证', '690207', 0);
INSERT INTO `xy_specialities` VALUES (1442, '知识产权管理', '690208', 0);
INSERT INTO `xy_specialities` VALUES (1443, '老年服务与管理', '690301', 0);
INSERT INTO `xy_specialities` VALUES (1444, '家政服务与管理', '690302', 0);
INSERT INTO `xy_specialities` VALUES (1445, '婚庆服务与管理', '690303', 0);
INSERT INTO `xy_specialities` VALUES (1446, '社区康复', '690304', 0);
INSERT INTO `xy_specialities` VALUES (1447, '现代殡葬技术与管理', '690305', 0);
