
-- ----------------------------
-- Table structure for xy_sms_template
-- ----------------------------
DROP TABLE IF EXISTS `xy_sms_template`;
CREATE TABLE `xy_sms_template`  (
  `id` int(0) UNSIGNED NOT NULL AUTO_INCREMENT,
  `alias` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `content` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `status` tinyint(1) NULL DEFAULT 1,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `alias`(`alias`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 31 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '短信-推送模板' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of xy_sms_template
-- ----------------------------
INSERT INTO `xy_sms_template` VALUES (14, 'PaySuccess', '支付成功通知', '{u.nickname}恭喜您！已成功为订单：{otrade}支付，支付金额：{oprice}元。', 1);
INSERT INTO `xy_sms_template` VALUES (15, 'default_vcode', '通用验证码', '您的验证码是：{code}。该验证码在{sms_expire}后失效。', 1);
INSERT INTO `xy_sms_template` VALUES (16, 'DeliveryResume', '职位申请通知', '{u.nickname}恭喜您！有求职者申请了您发布的职位：{title}，请登录网站查看。', 1);
INSERT INTO `xy_sms_template` VALUES (17, 'JobsExamine', '职位审核结果', '{hi_text}，您发布的职位{title}，{status}审核，请登陆网站查看。', 1);
INSERT INTO `xy_sms_template` VALUES (18, 'InviteAnInterview', '邀请面试', '{u.nickname}恭喜您！{company_name}邀请您面试：{jobs_name}职位！请登录网站查看。', 1);
INSERT INTO `xy_sms_template` VALUES (19, 'login', '登陆验证码', '您的验证码是：{code}。该验证码在{sms_expire}后失效。', 1);
INSERT INTO `xy_sms_template` VALUES (20, 'register', '注册验证码', '您的验证码是：{code}。该验证码在{sms_expire}后失效。', 1);
INSERT INTO `xy_sms_template` VALUES (21, 'ComapnyVipExpire', '企业会员到期提醒', '{company_name}：您的套餐{company_vip}将于{company_vip_time}到期，请及时续费。', 1);
INSERT INTO `xy_sms_template` VALUES (22, 'MobileBinding', '手机号码绑定', '您的验证码是：{code}。该验证码在{sms_expire}后失效。', 1);
INSERT INTO `xy_sms_template` VALUES (25, 'IMMessage', '意向沟通提醒', '我对您发布的{jobs_name}职位感兴趣，希望与您进一步沟通，请登录网站查看。', 1);
INSERT INTO `xy_sms_template` VALUES (27, 'ResumeExamine', '简历审核结果', '{hi_text}，您的简历审核{status}，请登陆网站查看。', 1);
INSERT INTO `xy_sms_template` VALUES (29, 'RealNameNotice', '实名结果通知', '{hi_text}，您的{id_type}{name}审核{status}，请登陆网站查看。', 1);
INSERT INTO `xy_sms_template` VALUES (30, 'SendOffer', 'offer确认通知', '{u.nickname}恭喜您！您收到了{company_name}的offer邀请，请登陆网站查看。', 1);
INSERT INTO `xy_sms_template` VALUES (31, 'SystemWarning', '管理员待办通知', '您有新的待办工作提醒，内容为“{msg}”，请及时登录平台处理。', 1);
