
-- ----------------------------
-- Table structure for xy_score_task
-- ----------------------------
DROP TABLE IF EXISTS `xy_score_task`;
CREATE TABLE `xy_score_task`  (
  `id` int(0) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `tips` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `is_company` tinyint(1) NULL DEFAULT NULL,
  `event` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `score` int(0) NULL DEFAULT 0,
  `status` tinyint(1) NULL DEFAULT 1,
  `sort` tinyint(0) NULL DEFAULT 99,
  `repeat` tinyint(1) NULL DEFAULT 0,
  `repeat_sum` tinyint(0) NULL DEFAULT 1,
  `stock` int(0) NULL DEFAULT 0,
  `surplus_stock` int(0) NULL DEFAULT 0,
  `complete_sum` int(0) NULL DEFAULT 0,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `start_time` int(0) NULL DEFAULT NULL,
  `end_time` int(0) NULL DEFAULT NULL,
  `update_time` int(0) NULL DEFAULT NULL,
  `create_time` int(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 19 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '积分-任务' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of xy_score_task
-- ----------------------------
INSERT INTO `xy_score_task` VALUES (1, '签到任务', '每日签到领取积分', NULL, 'sign_in', 5, 1, 1, 1, 1, 0, 0, 0, '', NULL, NULL, 1616640099, 1596782105);
INSERT INTO `xy_score_task` VALUES (2, '用户注册', '', NULL, 'reg', 20, 1, 2, 0, 1, 0, 0, 0, '', NULL, NULL, 1596789101, 1596782154);
INSERT INTO `xy_score_task` VALUES (3, '绑定微信账号', '', NULL, 'bind_wx', 20, 1, 99, 0, 1, 0, 0, 0, '/user/security', NULL, NULL, 1596789191, 1596782197);
INSERT INTO `xy_score_task` VALUES (4, '绑定QQ账号', '', NULL, 'bind_qq', 20, 1, 99, 0, 1, 0, 0, 0, '/user/security', NULL, NULL, 1596789187, 1596782215);
INSERT INTO `xy_score_task` VALUES (5, '上传企业LOGO', '', 1, 'update_logo', 50, 1, 3, 0, 1, 0, 0, 0, '', NULL, NULL, 1596789129, 1596784038);
INSERT INTO `xy_score_task` VALUES (6, '刷新简历', '', 0, 'refresh_resume_today', 5, 1, 3, 1, 1, 0, 0, 0, '/user', NULL, NULL, 1596789200, 1596784100);
INSERT INTO `xy_score_task` VALUES (7, '完善企业资料', '', 1, 'company_info', 5, 1, 99, 0, 1, 0, 0, 0, '', NULL, NULL, 1596792682, 1596792682);
INSERT INTO `xy_score_task` VALUES (8, '上传营业执照并通过验证', '', 1, 'company_attestation', 5, 1, 99, 0, 1, 0, 0, 0, '', NULL, NULL, 1596792713, 1596792713);
INSERT INTO `xy_score_task` VALUES (9, '开通电子地图', '', 1, 'company_address_map', 5, 1, 99, 0, 1, 0, 0, 0, '', NULL, NULL, 1596792737, 1596792737);
INSERT INTO `xy_score_task` VALUES (10, '上传企业风采', '', 1, 'company_demeanor', 5, 1, 99, 0, 10, 0, 0, 0, '', NULL, NULL, 1596878190, 1596792761);
INSERT INTO `xy_score_task` VALUES (11, '处理3天内收到的简历', '', 1, 'handle_delivery_resume', 5, 1, 99, 0, 1, 0, 0, 0, '', NULL, NULL, 1596792809, 1596792809);
INSERT INTO `xy_score_task` VALUES (12, '及时回复求职者咨询', '', 1, 'reply_resume', 5, 1, 99, 0, 1, 0, 0, 0, '', NULL, NULL, 1596792827, 1596792827);
INSERT INTO `xy_score_task` VALUES (13, '举报简历', '', 1, 'report_resume', 1, 1, 99, 0, 1, 0, 0, 0, '', NULL, NULL, 1596792844, 1596792844);
INSERT INTO `xy_score_task` VALUES (14, '上传头像', '', 0, 'update_hredimg', 1, 1, 99, 0, 1, 0, 0, 0, '/user/security', NULL, NULL, 1596868836, 1596792997);
INSERT INTO `xy_score_task` VALUES (15, '简历完成度达到60%', '', 0, 'resume_progress_60', 1, 1, 99, 0, 1, 0, 0, 0, '/user', NULL, NULL, 1596868847, 1596793037);
INSERT INTO `xy_score_task` VALUES (16, '简历完成度达到90%', '', 0, 'resume_progress_90', 1, 1, 99, 0, 1, 0, 0, 0, '/user', NULL, NULL, 1596868851, 1596793055);
INSERT INTO `xy_score_task` VALUES (17, '每日投递简历', '', 0, 'delivery_resume_today', 1, 1, 99, 0, 1, 0, 0, 0, '/job-hunting', NULL, NULL, 1596868865, 1596793070);
INSERT INTO `xy_score_task` VALUES (18, '举报职位', '', 0, 'report_jobs', 1, 1, 99, 0, 1, 0, 0, 0, '', NULL, NULL, 1596793085, 1596793085);
