
-- ----------------------------
-- Table structure for xy_school
-- ----------------------------
DROP TABLE IF EXISTS `xy_school`;
CREATE TABLE `xy_school`  (
  `id` int(0) UNSIGNED NOT NULL AUTO_INCREMENT,
  `school_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `school_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `university` tinyint(1) NULL DEFAULT 1,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `code`(`school_code`) USING BTREE,
  INDEX `name`(`school_name`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3008 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of xy_school
-- ----------------------------
INSERT INTO `xy_school` VALUES (1, '北京大学', '4111010001', 1);
INSERT INTO `xy_school` VALUES (2, '中国人民大学', '4111010002', 1);
INSERT INTO `xy_school` VALUES (3, '清华大学', '4111010003', 1);
INSERT INTO `xy_school` VALUES (4, '北京交通大学', '4111010004', 1);
INSERT INTO `xy_school` VALUES (5, '北京工业大学', '4111010005', 1);
INSERT INTO `xy_school` VALUES (6, '北京航空航天大学', '4111010006', 1);
INSERT INTO `xy_school` VALUES (7, '北京理工大学', '4111010007', 1);
INSERT INTO `xy_school` VALUES (8, '北京科技大学', '4111010008', 1);
INSERT INTO `xy_school` VALUES (9, '北方工业大学', '4111010009', 1);
INSERT INTO `xy_school` VALUES (10, '北京化工大学', '4111010010', 1);
INSERT INTO `xy_school` VALUES (11, '北京工商大学', '4111010011', 1);
INSERT INTO `xy_school` VALUES (12, '北京服装学院', '4111010012', 1);
INSERT INTO `xy_school` VALUES (13, '北京邮电大学', '4111010013', 1);
INSERT INTO `xy_school` VALUES (14, '北京印刷学院', '4111010015', 1);
INSERT INTO `xy_school` VALUES (15, '北京建筑大学', '4111010016', 1);
INSERT INTO `xy_school` VALUES (16, '北京石油化工学院', '4111010017', 1);
INSERT INTO `xy_school` VALUES (17, '北京电子科技学院', '4111010018', 1);
INSERT INTO `xy_school` VALUES (18, '中国农业大学', '4111010019', 1);
INSERT INTO `xy_school` VALUES (19, '北京农学院', '4111010020', 1);
INSERT INTO `xy_school` VALUES (20, '北京林业大学', '4111010022', 1);
INSERT INTO `xy_school` VALUES (21, '北京协和医学院', '4111010023', 1);
INSERT INTO `xy_school` VALUES (22, '首都医科大学', '4111010025', 1);
INSERT INTO `xy_school` VALUES (23, '北京中医药大学', '4111010026', 1);
INSERT INTO `xy_school` VALUES (24, '北京师范大学', '4111010027', 1);
INSERT INTO `xy_school` VALUES (25, '首都师范大学', '4111010028', 1);
INSERT INTO `xy_school` VALUES (26, '首都体育学院', '4111010029', 1);
INSERT INTO `xy_school` VALUES (27, '北京外国语大学', '4111010030', 1);
INSERT INTO `xy_school` VALUES (28, '北京第二外国语学院', '4111010031', 1);
INSERT INTO `xy_school` VALUES (29, '北京语言大学', '4111010032', 1);
INSERT INTO `xy_school` VALUES (30, '中国传媒大学', '4111010033', 1);
INSERT INTO `xy_school` VALUES (31, '中央财经大学', '4111010034', 1);
INSERT INTO `xy_school` VALUES (32, '对外经济贸易大学', '4111010036', 1);
INSERT INTO `xy_school` VALUES (33, '北京物资学院', '4111010037', 1);
INSERT INTO `xy_school` VALUES (34, '首都经济贸易大学', '4111010038', 1);
INSERT INTO `xy_school` VALUES (35, '中国消防救援学院', '4111010039', 1);
INSERT INTO `xy_school` VALUES (36, '外交学院', '4111010040', 1);
INSERT INTO `xy_school` VALUES (37, '中国人民公安大学', '4111010041', 1);
INSERT INTO `xy_school` VALUES (38, '国际关系学院', '4111010042', 1);
INSERT INTO `xy_school` VALUES (39, '北京体育大学', '4111010043', 1);
INSERT INTO `xy_school` VALUES (40, '中央音乐学院', '4111010045', 1);
INSERT INTO `xy_school` VALUES (41, '中国音乐学院', '4111010046', 1);
INSERT INTO `xy_school` VALUES (42, '中央美术学院', '4111010047', 1);
INSERT INTO `xy_school` VALUES (43, '中央戏剧学院', '4111010048', 1);
INSERT INTO `xy_school` VALUES (44, '中国戏曲学院', '4111010049', 1);
INSERT INTO `xy_school` VALUES (45, '北京电影学院', '4111010050', 1);
INSERT INTO `xy_school` VALUES (46, '北京舞蹈学院', '4111010051', 1);
INSERT INTO `xy_school` VALUES (47, '中央民族大学', '4111010052', 1);
INSERT INTO `xy_school` VALUES (48, '中国政法大学', '4111010053', 1);
INSERT INTO `xy_school` VALUES (49, '华北电力大学', '4111010054', 1);
INSERT INTO `xy_school` VALUES (50, '中华女子学院', '4111011149', 1);
INSERT INTO `xy_school` VALUES (51, '北京信息科技大学', '4111011232', 1);
INSERT INTO `xy_school` VALUES (52, '中国矿业大学（北京）', '4111011413', 1);
INSERT INTO `xy_school` VALUES (53, '中国石油大学（北京）', '4111011414', 1);
INSERT INTO `xy_school` VALUES (54, '中国地质大学（北京）', '4111011415', 1);
INSERT INTO `xy_school` VALUES (55, '北京联合大学', '4111011417', 1);
INSERT INTO `xy_school` VALUES (56, '北京城市学院', '4111011418', 1);
INSERT INTO `xy_school` VALUES (57, '中国青年政治学院', '4111011625', 1);
INSERT INTO `xy_school` VALUES (58, '首钢工学院', '4111011831', 1);
INSERT INTO `xy_school` VALUES (59, '中国劳动关系学院', '4111012453', 1);
INSERT INTO `xy_school` VALUES (60, '首都师范大学科德学院', '4111013629', 1);
INSERT INTO `xy_school` VALUES (61, '北京工商大学嘉华学院', '4111013630', 1);
INSERT INTO `xy_school` VALUES (62, '北京邮电大学世纪学院', '4111013901', 1);
INSERT INTO `xy_school` VALUES (63, '北京工业大学耿丹学院', '4111013904', 1);
INSERT INTO `xy_school` VALUES (64, '北京警察学院', '4111014019', 1);
INSERT INTO `xy_school` VALUES (65, '北京第二外国语学院中瑞酒店管理学院', '4111014201', 1);
INSERT INTO `xy_school` VALUES (66, '中国科学院大学', '4111014430', 1);
INSERT INTO `xy_school` VALUES (67, '中国社会科学院大学', '4111014596', 1);
INSERT INTO `xy_school` VALUES (68, '北京工业职业技术学院', '4111010853', 1);
INSERT INTO `xy_school` VALUES (69, '北京信息职业技术学院', '4111010857', 1);
INSERT INTO `xy_school` VALUES (70, '北京电子科技职业学院', '4111010858', 1);
INSERT INTO `xy_school` VALUES (71, '北京京北职业技术学院', '4111011090', 1);
INSERT INTO `xy_school` VALUES (72, '北京交通职业技术学院', '4111011092', 1);
INSERT INTO `xy_school` VALUES (73, '北京青年政治学院', '4111011626', 1);
INSERT INTO `xy_school` VALUES (74, '北京农业职业学院', '4111012448', 1);
INSERT INTO `xy_school` VALUES (75, '北京政法职业学院', '4111012451', 1);
INSERT INTO `xy_school` VALUES (76, '北京财贸职业学院', '4111012561', 1);
INSERT INTO `xy_school` VALUES (77, '北京北大方正软件职业技术学院', '4111012564', 1);
INSERT INTO `xy_school` VALUES (78, '北京经贸职业学院', '4111012565', 1);
INSERT INTO `xy_school` VALUES (79, '北京经济技术职业学院', '4111012566', 1);
INSERT INTO `xy_school` VALUES (80, '北京戏曲艺术职业学院', '4111012567', 1);
INSERT INTO `xy_school` VALUES (81, '北京汇佳职业学院', '4111012568', 1);
INSERT INTO `xy_school` VALUES (82, '北京科技经营管理学院', '4111012733', 1);
INSERT INTO `xy_school` VALUES (83, '北京科技职业学院', '4111013703', 1);
INSERT INTO `xy_school` VALUES (84, '北京培黎职业学院', '4111013728', 1);
INSERT INTO `xy_school` VALUES (85, '北京经济管理职业学院', '4111014073', 1);
INSERT INTO `xy_school` VALUES (86, '北京劳动保障职业学院', '4111014075', 1);
INSERT INTO `xy_school` VALUES (87, '北京社会管理职业学院', '4111014139', 1);
INSERT INTO `xy_school` VALUES (88, '北京艺术传媒职业学院', '4111014140', 1);
INSERT INTO `xy_school` VALUES (89, '北京体育职业学院', '4111014215', 1);
INSERT INTO `xy_school` VALUES (90, '北京交通运输职业学院', '4111014279', 1);
INSERT INTO `xy_school` VALUES (91, '北京卫生职业学院', '4111014395', 1);
INSERT INTO `xy_school` VALUES (92, '北京网络职业学院', '4111014588', 1);
INSERT INTO `xy_school` VALUES (93, '南开大学', '4112010055', 1);
INSERT INTO `xy_school` VALUES (94, '天津大学', '4112010056', 1);
INSERT INTO `xy_school` VALUES (95, '天津科技大学', '4112010057', 1);
INSERT INTO `xy_school` VALUES (96, '天津工业大学', '4112010058', 1);
INSERT INTO `xy_school` VALUES (97, '中国民航大学', '4112010059', 1);
INSERT INTO `xy_school` VALUES (98, '天津理工大学', '4112010060', 1);
INSERT INTO `xy_school` VALUES (99, '天津农学院', '4112010061', 1);
INSERT INTO `xy_school` VALUES (100, '天津医科大学', '4112010062', 1);
INSERT INTO `xy_school` VALUES (101, '天津中医药大学', '4112010063', 1);
INSERT INTO `xy_school` VALUES (102, '天津师范大学', '4112010065', 1);
INSERT INTO `xy_school` VALUES (103, '天津职业技术师范大学', '4112010066', 1);
INSERT INTO `xy_school` VALUES (104, '天津外国语大学', '4112010068', 1);
INSERT INTO `xy_school` VALUES (105, '天津商业大学', '4112010069', 1);
INSERT INTO `xy_school` VALUES (106, '天津财经大学', '4112010070', 1);
INSERT INTO `xy_school` VALUES (107, '天津体育学院', '4112010071', 1);
INSERT INTO `xy_school` VALUES (108, '天津音乐学院', '4112010072', 1);
INSERT INTO `xy_school` VALUES (109, '天津美术学院', '4112010073', 1);
INSERT INTO `xy_school` VALUES (110, '天津城建大学', '4112010792', 1);
INSERT INTO `xy_school` VALUES (111, '天津天狮学院', '4112010859', 1);
INSERT INTO `xy_school` VALUES (112, '天津中德应用技术大学', '4112012105', 1);
INSERT INTO `xy_school` VALUES (113, '天津外国语大学滨海外事学院', '4112013658', 1);
INSERT INTO `xy_school` VALUES (114, '天津体育学院运动与文化艺术学院', '4112013659', 1);
INSERT INTO `xy_school` VALUES (115, '天津商业大学宝德学院', '4112013660', 1);
INSERT INTO `xy_school` VALUES (116, '天津医科大学临床医学院', '4112013661', 1);
INSERT INTO `xy_school` VALUES (117, '南开大学滨海学院', '4112013663', 1);
INSERT INTO `xy_school` VALUES (118, '天津师范大学津沽学院', '4112013896', 1);
INSERT INTO `xy_school` VALUES (119, '天津理工大学中环信息学院', '4112013897', 1);
INSERT INTO `xy_school` VALUES (120, '北京科技大学天津学院', '4112013898', 1);
INSERT INTO `xy_school` VALUES (121, '天津大学仁爱学院', '4112014038', 1);
INSERT INTO `xy_school` VALUES (122, '天津财经大学珠江学院', '4112014087', 1);
INSERT INTO `xy_school` VALUES (123, '天津市职业大学', '4112011032', 1);
INSERT INTO `xy_school` VALUES (124, '天津滨海职业学院', '4112012484', 1);
INSERT INTO `xy_school` VALUES (125, '天津工程职业技术学院', '4112012487', 1);
INSERT INTO `xy_school` VALUES (126, '天津渤海职业技术学院', '4112012719', 1);
INSERT INTO `xy_school` VALUES (127, '天津电子信息职业技术学院', '4112012720', 1);
INSERT INTO `xy_school` VALUES (128, '天津机电职业技术学院', '4112012721', 1);
INSERT INTO `xy_school` VALUES (129, '天津现代职业技术学院', '4112012722', 1);
INSERT INTO `xy_school` VALUES (130, '天津公安警官职业学院', '4112012723', 1);
INSERT INTO `xy_school` VALUES (131, '天津轻工职业技术学院', '4112012732', 1);
INSERT INTO `xy_school` VALUES (132, '天津商务职业学院', '4112012788', 1);
INSERT INTO `xy_school` VALUES (133, '天津国土资源和房屋职业学院', '4112012803', 1);
INSERT INTO `xy_school` VALUES (134, '天津医学高等专科学校', '4112012880', 1);
INSERT INTO `xy_school` VALUES (135, '天津开发区职业技术学院', '4112012881', 1);
INSERT INTO `xy_school` VALUES (136, '天津艺术职业学院', '4112012882', 1);
INSERT INTO `xy_school` VALUES (137, '天津交通职业学院', '4112012883', 1);
INSERT INTO `xy_school` VALUES (138, '天津工业职业学院', '4112013700', 1);
INSERT INTO `xy_school` VALUES (139, '天津石油职业技术学院', '4112013701', 1);
INSERT INTO `xy_school` VALUES (140, '天津城市职业学院', '4112013702', 1);
INSERT INTO `xy_school` VALUES (141, '天津铁道职业技术学院', '4112013863', 1);
INSERT INTO `xy_school` VALUES (142, '天津工艺美术职业学院', '4112013911', 1);
INSERT INTO `xy_school` VALUES (143, '天津城市建设管理职业技术学院', '4112014020', 1);
INSERT INTO `xy_school` VALUES (144, '天津生物工程职业技术学院', '4112014021', 1);
INSERT INTO `xy_school` VALUES (145, '天津海运职业学院', '4112014022', 1);
INSERT INTO `xy_school` VALUES (146, '天津广播影视职业学院', '4112014102', 1);
INSERT INTO `xy_school` VALUES (147, '天津体育职业学院', '4112014599', 1);
INSERT INTO `xy_school` VALUES (148, '天津滨海汽车工程职业学院', '4112014600', 1);
INSERT INTO `xy_school` VALUES (149, '河北大学', '4113010075', 1);
INSERT INTO `xy_school` VALUES (150, '河北工程大学', '4113010076', 1);
INSERT INTO `xy_school` VALUES (151, '河北地质大学', '4113010077', 1);
INSERT INTO `xy_school` VALUES (152, '河北工业大学', '4113010080', 1);
INSERT INTO `xy_school` VALUES (153, '华北理工大学', '4113010081', 1);
INSERT INTO `xy_school` VALUES (154, '河北科技大学', '4113010082', 1);
INSERT INTO `xy_school` VALUES (155, '河北建筑工程学院', '4113010084', 1);
INSERT INTO `xy_school` VALUES (156, '河北水利电力学院', '4113010085', 1);
INSERT INTO `xy_school` VALUES (157, '河北农业大学', '4113010086', 1);
INSERT INTO `xy_school` VALUES (158, '河北医科大学', '4113010089', 1);
INSERT INTO `xy_school` VALUES (159, '河北北方学院', '4113010092', 1);
INSERT INTO `xy_school` VALUES (160, '承德医学院', '4113010093', 1);
INSERT INTO `xy_school` VALUES (161, '河北师范大学', '4113010094', 1);
INSERT INTO `xy_school` VALUES (162, '保定学院', '4113010096', 1);
INSERT INTO `xy_school` VALUES (163, '河北民族师范学院', '4113010098', 1);
INSERT INTO `xy_school` VALUES (164, '唐山师范学院', '4113010099', 1);
INSERT INTO `xy_school` VALUES (165, '廊坊师范学院', '4113010100', 1);
INSERT INTO `xy_school` VALUES (166, '衡水学院', '4113010101', 1);
INSERT INTO `xy_school` VALUES (167, '石家庄学院', '4113010102', 1);
INSERT INTO `xy_school` VALUES (168, '邯郸学院', '4113010103', 1);
INSERT INTO `xy_school` VALUES (169, '邢台学院', '4113010104', 1);
INSERT INTO `xy_school` VALUES (170, '沧州师范学院', '4113010105', 1);
INSERT INTO `xy_school` VALUES (171, '石家庄铁道大学', '4113010107', 1);
INSERT INTO `xy_school` VALUES (172, '燕山大学', '4113010216', 1);
INSERT INTO `xy_school` VALUES (173, '河北科技师范学院', '4113010798', 1);
INSERT INTO `xy_school` VALUES (174, '唐山学院', '4113011033', 1);
INSERT INTO `xy_school` VALUES (175, '华北科技学院', '4113011104', 1);
INSERT INTO `xy_school` VALUES (176, '中国人民警察大学', '4113011105', 1);
INSERT INTO `xy_school` VALUES (177, '河北体育学院', '4113011236', 1);
INSERT INTO `xy_school` VALUES (178, '河北金融学院', '4113011420', 1);
INSERT INTO `xy_school` VALUES (179, '北华航天工业学院', '4113011629', 1);
INSERT INTO `xy_school` VALUES (180, '防灾科技学院', '4113011775', 1);
INSERT INTO `xy_school` VALUES (181, '河北经贸大学', '4113011832', 1);
INSERT INTO `xy_school` VALUES (182, '中央司法警官学院', '4113011903', 1);
INSERT INTO `xy_school` VALUES (183, '河北传媒学院', '4113012784', 1);
INSERT INTO `xy_school` VALUES (184, '河北工程技术学院', '4113012796', 1);
INSERT INTO `xy_school` VALUES (185, '河北美术学院', '4113013075', 1);
INSERT INTO `xy_school` VALUES (186, '河北科技学院', '4113013391', 1);
INSERT INTO `xy_school` VALUES (187, '河北外国语学院', '4113013402', 1);
INSERT INTO `xy_school` VALUES (188, '河北大学工商学院', '4113013404', 1);
INSERT INTO `xy_school` VALUES (189, '华北理工大学轻工学院', '4113013408', 1);
INSERT INTO `xy_school` VALUES (190, '河北科技大学理工学院', '4113013409', 1);
INSERT INTO `xy_school` VALUES (191, '河北师范大学汇华学院', '4113013411', 1);
INSERT INTO `xy_school` VALUES (192, '河北经贸大学经济管理学院', '4113013414', 1);
INSERT INTO `xy_school` VALUES (193, '河北医科大学临床学院', '4113013415', 1);
INSERT INTO `xy_school` VALUES (194, '华北电力大学科技学院', '4113013417', 1);
INSERT INTO `xy_school` VALUES (195, '河北工程大学科信学院', '4113013578', 1);
INSERT INTO `xy_school` VALUES (196, '河北工业大学城市学院', '4113013584', 1);
INSERT INTO `xy_school` VALUES (197, '燕山大学里仁学院', '4113013592', 1);
INSERT INTO `xy_school` VALUES (198, '石家庄铁道大学四方学院', '4113013593', 1);
INSERT INTO `xy_school` VALUES (199, '河北地质大学华信学院', '4113013594', 1);
INSERT INTO `xy_school` VALUES (200, '河北农业大学现代科技学院', '4113013595', 1);
INSERT INTO `xy_school` VALUES (201, '华北理工大学冀唐学院', '4113013596', 1);
INSERT INTO `xy_school` VALUES (202, '保定理工学院', '4113013891', 1);
INSERT INTO `xy_school` VALUES (203, '燕京理工学院', '4113013895', 1);
INSERT INTO `xy_school` VALUES (204, '北京中医药大学东方学院', '4113013899', 1);
INSERT INTO `xy_school` VALUES (205, '北京交通大学海滨学院', '4113014202', 1);
INSERT INTO `xy_school` VALUES (206, '河北东方学院', '4113014225', 1);
INSERT INTO `xy_school` VALUES (207, '河北中医学院', '4113014432', 1);
INSERT INTO `xy_school` VALUES (208, '张家口学院', '4113014458', 1);
INSERT INTO `xy_school` VALUES (209, '河北环境工程学院', '4213051721', 1);
INSERT INTO `xy_school` VALUES (210, '河北工业职业技术学院', '4113010873', 1);
INSERT INTO `xy_school` VALUES (211, '邯郸职业技术学院', '4113011034', 1);
INSERT INTO `xy_school` VALUES (212, '石家庄职业技术学院', '4113011238', 1);
INSERT INTO `xy_school` VALUES (213, '张家口职业技术学院', '4113011423', 1);
INSERT INTO `xy_school` VALUES (214, '承德石油高等专科学校', '4113011777', 1);
INSERT INTO `xy_school` VALUES (215, '邢台职业技术学院', '4113011821', 1);
INSERT INTO `xy_school` VALUES (216, '河北软件职业技术学院', '4113012352', 1);
INSERT INTO `xy_school` VALUES (217, '河北石油职业技术学院', '4113012367', 1);
INSERT INTO `xy_school` VALUES (218, '河北建材职业技术学院', '4113012389', 1);
INSERT INTO `xy_school` VALUES (219, '河北政法职业学院', '4113012408', 1);
INSERT INTO `xy_school` VALUES (220, '沧州职业技术学院', '4113012415', 1);
INSERT INTO `xy_school` VALUES (221, '河北能源职业技术学院', '4113012418', 1);
INSERT INTO `xy_school` VALUES (222, '石家庄铁路职业技术学院', '4113012424', 1);
INSERT INTO `xy_school` VALUES (223, '保定职业技术学院', '4113012543', 1);
INSERT INTO `xy_school` VALUES (224, '秦皇岛职业技术学院', '4113012773', 1);
INSERT INTO `xy_school` VALUES (225, '石家庄工程职业学院', '4113012782', 1);
INSERT INTO `xy_school` VALUES (226, '石家庄城市经济职业学院', '4113012783', 1);
INSERT INTO `xy_school` VALUES (227, '唐山职业技术学院', '4113012785', 1);
INSERT INTO `xy_school` VALUES (228, '衡水职业技术学院', '4113012786', 1);
INSERT INTO `xy_school` VALUES (229, '唐山工业职业技术学院', '4113012787', 1);
INSERT INTO `xy_school` VALUES (230, '邢台医学高等专科学校', '4113012884', 1);
INSERT INTO `xy_school` VALUES (231, '河北艺术职业学院', '4113012885', 1);
INSERT INTO `xy_school` VALUES (232, '河北旅游职业学院', '4113012887', 1);
INSERT INTO `xy_school` VALUES (233, '石家庄财经职业学院', '4113013070', 1);
INSERT INTO `xy_school` VALUES (234, '河北交通职业技术学院', '4113013071', 1);
INSERT INTO `xy_school` VALUES (235, '河北化工医药职业技术学院', '4113013072', 1);
INSERT INTO `xy_school` VALUES (236, '石家庄信息工程职业学院', '4113013073', 1);
INSERT INTO `xy_school` VALUES (237, '河北对外经贸职业学院', '4113013074', 1);
INSERT INTO `xy_school` VALUES (238, '保定电力职业技术学院', '4113013392', 1);
INSERT INTO `xy_school` VALUES (239, '河北机电职业技术学院', '4113013393', 1);
INSERT INTO `xy_school` VALUES (240, '渤海石油职业学院', '4113013394', 1);
INSERT INTO `xy_school` VALUES (241, '廊坊职业技术学院', '4113013395', 1);
INSERT INTO `xy_school` VALUES (242, '唐山科技职业技术学院', '4113013396', 1);
INSERT INTO `xy_school` VALUES (243, '石家庄邮电职业技术学院', '4113013397', 1);
INSERT INTO `xy_school` VALUES (244, '河北公安警察职业学院', '4113013398', 1);
INSERT INTO `xy_school` VALUES (245, '石家庄工商职业学院', '4113013399', 1);
INSERT INTO `xy_school` VALUES (246, '石家庄理工职业学院', '4113013400', 1);
INSERT INTO `xy_school` VALUES (247, '石家庄科技信息职业学院', '4113013403', 1);
INSERT INTO `xy_school` VALUES (248, '河北司法警官职业学院', '4113013690', 1);
INSERT INTO `xy_school` VALUES (249, '沧州医学高等专科学校', '4113013779', 1);
INSERT INTO `xy_school` VALUES (250, '河北女子职业技术学院', '4113013822', 1);
INSERT INTO `xy_school` VALUES (251, '石家庄医学高等专科学校', '4113014018', 1);
INSERT INTO `xy_school` VALUES (252, '石家庄经济职业学院', '4113014047', 1);
INSERT INTO `xy_school` VALUES (253, '冀中职业学院', '4113014103', 1);
INSERT INTO `xy_school` VALUES (254, '石家庄人民医学高等专科学校', '4113014158', 1);
INSERT INTO `xy_school` VALUES (255, '石家庄科技工程职业学院', '4113014185', 1);
INSERT INTO `xy_school` VALUES (256, '河北劳动关系职业学院', '4113014208', 1);
INSERT INTO `xy_school` VALUES (257, '石家庄科技职业学院', '4113014213', 1);
INSERT INTO `xy_school` VALUES (258, '泊头职业学院', '4113014259', 1);
INSERT INTO `xy_school` VALUES (259, '宣化科技职业学院', '4113014260', 1);
INSERT INTO `xy_school` VALUES (260, '廊坊燕京职业技术学院', '4113014280', 1);
INSERT INTO `xy_school` VALUES (261, '承德护理职业学院', '4113014281', 1);
INSERT INTO `xy_school` VALUES (262, '石家庄幼儿师范高等专科学校', '4113014328', 1);
INSERT INTO `xy_school` VALUES (263, '廊坊卫生职业学院', '4113014335', 1);
INSERT INTO `xy_school` VALUES (264, '河北轨道运输职业技术学院', '4113014396', 1);
INSERT INTO `xy_school` VALUES (265, '保定幼儿师范高等专科学校', '4113014460', 1);
INSERT INTO `xy_school` VALUES (266, '河北工艺美术职业学院', '4113014471', 1);
INSERT INTO `xy_school` VALUES (267, '渤海理工职业学院', '4113014472', 1);
INSERT INTO `xy_school` VALUES (268, '唐山幼儿师范高等专科学校', '4113014586', 1);
INSERT INTO `xy_school` VALUES (269, '曹妃甸职业技术学院', '4113014601', 1);
INSERT INTO `xy_school` VALUES (270, '承德应用技术职业学院', '4113014632', 1);
INSERT INTO `xy_school` VALUES (271, '邯郸幼儿师范高等专科学校', '4113014686', 1);
INSERT INTO `xy_school` VALUES (272, '邯郸科技职业学院', '4113014695', 1);
INSERT INTO `xy_school` VALUES (273, '唐山海运职业学院', '4113014696', 1);
INSERT INTO `xy_school` VALUES (274, '山西大学', '4114010108', 1);
INSERT INTO `xy_school` VALUES (275, '太原科技大学', '4114010109', 1);
INSERT INTO `xy_school` VALUES (276, '中北大学', '4114010110', 1);
INSERT INTO `xy_school` VALUES (277, '太原理工大学', '4114010112', 1);
INSERT INTO `xy_school` VALUES (278, '山西农业大学', '4114010113', 1);
INSERT INTO `xy_school` VALUES (279, '山西医科大学', '4114010114', 1);
INSERT INTO `xy_school` VALUES (280, '长治医学院', '4114010117', 1);
INSERT INTO `xy_school` VALUES (281, '山西师范大学', '4114010118', 1);
INSERT INTO `xy_school` VALUES (282, '太原师范学院', '4114010119', 1);
INSERT INTO `xy_school` VALUES (283, '山西大同大学', '4114010120', 1);
INSERT INTO `xy_school` VALUES (284, '晋中学院', '4114010121', 1);
INSERT INTO `xy_school` VALUES (285, '长治学院', '4114010122', 1);
INSERT INTO `xy_school` VALUES (286, '运城学院', '4114010123', 1);
INSERT INTO `xy_school` VALUES (287, '忻州师范学院', '4114010124', 1);
INSERT INTO `xy_school` VALUES (288, '山西财经大学', '4114010125', 1);
INSERT INTO `xy_school` VALUES (289, '山西中医药大学', '4114010809', 1);
INSERT INTO `xy_school` VALUES (290, '吕梁学院', '4114010812', 1);
INSERT INTO `xy_school` VALUES (291, '太原学院', '4114011242', 1);
INSERT INTO `xy_school` VALUES (292, '山西警察学院', '4114012111', 1);
INSERT INTO `xy_school` VALUES (293, '山西应用科技学院', '4114012779', 1);
INSERT INTO `xy_school` VALUES (294, '山西大学商务学院', '4114013533', 1);
INSERT INTO `xy_school` VALUES (295, '太原理工大学现代科技学院', '4114013534', 1);
INSERT INTO `xy_school` VALUES (296, '山西农业大学信息学院', '4114013535', 1);
INSERT INTO `xy_school` VALUES (297, '山西师范大学现代文理学院', '4114013537', 1);
INSERT INTO `xy_school` VALUES (298, '中北大学信息商务学院', '4114013538', 1);
INSERT INTO `xy_school` VALUES (299, '太原科技大学华科学院', '4114013597', 1);
INSERT INTO `xy_school` VALUES (300, '山西医科大学晋祠学院', '4114013598', 1);
INSERT INTO `xy_school` VALUES (301, '山西财经大学华商学院', '4114013608', 1);
INSERT INTO `xy_school` VALUES (302, '山西工商学院', '4114013691', 1);
INSERT INTO `xy_school` VALUES (303, '太原工业学院', '4114014101', 1);
INSERT INTO `xy_school` VALUES (304, '运城职业技术大学', '4114014226', 1);
INSERT INTO `xy_school` VALUES (305, '山西传媒学院', '4114014434', 1);
INSERT INTO `xy_school` VALUES (306, '山西工程技术学院', '4114014527', 1);
INSERT INTO `xy_school` VALUES (307, '山西能源学院', '4214051189', 1);
INSERT INTO `xy_school` VALUES (308, '山西省财政税务专科学校', '4114011630', 1);
INSERT INTO `xy_school` VALUES (309, '长治职业技术学院', '4114012388', 1);
INSERT INTO `xy_school` VALUES (310, '山西艺术职业学院', '4114012704', 1);
INSERT INTO `xy_school` VALUES (311, '晋城职业技术学院', '4114012774', 1);
INSERT INTO `xy_school` VALUES (312, '山西建筑职业技术学院', '4114012775', 1);
INSERT INTO `xy_school` VALUES (313, '山西药科职业学院', '4114012776', 1);
INSERT INTO `xy_school` VALUES (314, '山西交通职业技术学院', '4114012778', 1);
INSERT INTO `xy_school` VALUES (315, '大同煤炭职业技术学院', '4114012780', 1);
INSERT INTO `xy_school` VALUES (316, '山西机电职业技术学院', '4114012888', 1);
INSERT INTO `xy_school` VALUES (317, '山西戏剧职业学院', '4114012889', 1);
INSERT INTO `xy_school` VALUES (318, '山西财贸职业技术学院', '4114012890', 1);
INSERT INTO `xy_school` VALUES (319, '山西林业职业技术学院', '4114012891', 1);
INSERT INTO `xy_school` VALUES (320, '山西水利职业技术学院', '4114012892', 1);
INSERT INTO `xy_school` VALUES (321, '阳泉职业技术学院', '4114012893', 1);
INSERT INTO `xy_school` VALUES (322, '临汾职业技术学院', '4114013171', 1);
INSERT INTO `xy_school` VALUES (323, '山西职业技术学院', '4114013528', 1);
INSERT INTO `xy_school` VALUES (324, '山西金融职业学院', '4114013530', 1);
INSERT INTO `xy_school` VALUES (325, '太原城市职业技术学院', '4114013532', 1);
INSERT INTO `xy_school` VALUES (326, '山西信息职业技术学院', '4114013541', 1);
INSERT INTO `xy_school` VALUES (327, '山西体育职业学院', '4114013692', 1);
INSERT INTO `xy_school` VALUES (328, '山西警官职业学院', '4114013693', 1);
INSERT INTO `xy_school` VALUES (329, '山西国际商务职业学院', '4114013694', 1);
INSERT INTO `xy_school` VALUES (330, '潞安职业技术学院', '4114013695', 1);
INSERT INTO `xy_school` VALUES (331, '太原旅游职业学院', '4114013696', 1);
INSERT INTO `xy_school` VALUES (332, '山西旅游职业学院', '4114013697', 1);
INSERT INTO `xy_school` VALUES (333, '山西管理职业学院', '4114013698', 1);
INSERT INTO `xy_school` VALUES (334, '山西电力职业技术学院', '4114013745', 1);
INSERT INTO `xy_school` VALUES (335, '忻州职业技术学院', '4114013821', 1);
INSERT INTO `xy_school` VALUES (336, '山西同文职业技术学院', '4114013862', 1);
INSERT INTO `xy_school` VALUES (337, '晋中职业技术学院', '4114013913', 1);
INSERT INTO `xy_school` VALUES (338, '山西华澳商贸职业学院', '4114013914', 1);
INSERT INTO `xy_school` VALUES (339, '山西运城农业职业技术学院', '4114013934', 1);
INSERT INTO `xy_school` VALUES (340, '运城幼儿师范高等专科学校', '4114014093', 1);
INSERT INTO `xy_school` VALUES (341, '山西老区职业技术学院', '4114014105', 1);
INSERT INTO `xy_school` VALUES (342, '山西经贸职业学院', '4114014177', 1);
INSERT INTO `xy_school` VALUES (343, '朔州职业技术学院', '4114014186', 1);
INSERT INTO `xy_school` VALUES (344, '山西铁道职业技术学院', '4114014247', 1);
INSERT INTO `xy_school` VALUES (345, '晋中师范高等专科学校', '4114014270', 1);
INSERT INTO `xy_school` VALUES (346, '阳泉师范高等专科学校', '4114014271', 1);
INSERT INTO `xy_school` VALUES (347, '山西青年职业学院', '4114014336', 1);
INSERT INTO `xy_school` VALUES (348, '运城护理职业学院', '4114014397', 1);
INSERT INTO `xy_school` VALUES (349, '运城师范高等专科学校', '4114014461', 1);
INSERT INTO `xy_school` VALUES (350, '朔州师范高等专科学校', '4114014462', 1);
INSERT INTO `xy_school` VALUES (351, '吕梁职业技术学院', '4114014500', 1);
INSERT INTO `xy_school` VALUES (352, '大同师范高等专科学校', '4114014627', 1);
INSERT INTO `xy_school` VALUES (353, '太原幼儿师范高等专科学校', '4114014628', 1);
INSERT INTO `xy_school` VALUES (354, '山西工程职业学院', '4114014681', 1);
INSERT INTO `xy_school` VALUES (355, '长治幼儿师范高等专科学校', '4114014687', 1);
INSERT INTO `xy_school` VALUES (356, '山西通用航空职业技术学院', '4114014697', 1);
INSERT INTO `xy_school` VALUES (357, '朔州陶瓷职业技术学院', '4114014698', 1);
INSERT INTO `xy_school` VALUES (358, '山西卫生健康职业学院', '4214050166', 1);
INSERT INTO `xy_school` VALUES (359, '内蒙古大学', '4115010126', 1);
INSERT INTO `xy_school` VALUES (360, '内蒙古科技大学', '4115010127', 1);
INSERT INTO `xy_school` VALUES (361, '内蒙古工业大学', '4115010128', 1);
INSERT INTO `xy_school` VALUES (362, '内蒙古农业大学', '4115010129', 1);
INSERT INTO `xy_school` VALUES (363, '内蒙古医科大学', '4115010132', 1);
INSERT INTO `xy_school` VALUES (364, '内蒙古师范大学', '4115010135', 1);
INSERT INTO `xy_school` VALUES (365, '内蒙古民族大学', '4115010136', 1);
INSERT INTO `xy_school` VALUES (366, '赤峰学院', '4115010138', 1);
INSERT INTO `xy_school` VALUES (367, '内蒙古财经大学', '4115010139', 1);
INSERT INTO `xy_school` VALUES (368, '呼伦贝尔学院', '4115010819', 1);
INSERT INTO `xy_school` VALUES (369, '集宁师范学院', '4115011427', 1);
INSERT INTO `xy_school` VALUES (370, '河套学院', '4115011631', 1);
INSERT INTO `xy_school` VALUES (371, '呼和浩特民族学院', '4115011709', 1);
INSERT INTO `xy_school` VALUES (372, '内蒙古大学创业学院', '4115014199', 1);
INSERT INTO `xy_school` VALUES (373, '内蒙古鸿德文理学院', '4115014205', 1);
INSERT INTO `xy_school` VALUES (374, '内蒙古艺术学院', '4115014531', 1);
INSERT INTO `xy_school` VALUES (375, '鄂尔多斯应用技术学院', '4115014532', 1);
INSERT INTO `xy_school` VALUES (376, '内蒙古建筑职业技术学院', '4115010871', 1);
INSERT INTO `xy_school` VALUES (377, '内蒙古丰州职业学院', '4115011429', 1);
INSERT INTO `xy_school` VALUES (378, '包头职业技术学院', '4115012057', 1);
INSERT INTO `xy_school` VALUES (379, '兴安职业技术学院', '4115012443', 1);
INSERT INTO `xy_school` VALUES (380, '呼和浩特职业学院', '4115012670', 1);
INSERT INTO `xy_school` VALUES (381, '包头轻工职业技术学院', '4115012671', 1);
INSERT INTO `xy_school` VALUES (382, '内蒙古电子信息职业技术学院', '4115012673', 1);
INSERT INTO `xy_school` VALUES (383, '内蒙古机电职业技术学院', '4115012674', 1);
INSERT INTO `xy_school` VALUES (384, '内蒙古化工职业学院', '4115012675', 1);
INSERT INTO `xy_school` VALUES (385, '内蒙古商贸职业学院', '4115012676', 1);
INSERT INTO `xy_school` VALUES (386, '锡林郭勒职业学院', '4115012677', 1);
INSERT INTO `xy_school` VALUES (387, '内蒙古警察职业学院', '4115012797', 1);
INSERT INTO `xy_school` VALUES (388, '内蒙古体育职业学院', '4115012894', 1);
INSERT INTO `xy_school` VALUES (389, '乌兰察布职业学院', '4115013699', 1);
INSERT INTO `xy_school` VALUES (390, '通辽职业学院', '4115013740', 1);
INSERT INTO `xy_school` VALUES (391, '科尔沁艺术职业学院', '4115013741', 1);
INSERT INTO `xy_school` VALUES (392, '内蒙古交通职业技术学院', '4115013824', 1);
INSERT INTO `xy_school` VALUES (393, '包头钢铁职业技术学院', '4115013864', 1);
INSERT INTO `xy_school` VALUES (394, '乌海职业技术学院', '4115013915', 1);
INSERT INTO `xy_school` VALUES (395, '内蒙古科技职业学院', '4115014048', 1);
INSERT INTO `xy_school` VALUES (396, '内蒙古北方职业技术学院', '4115014049', 1);
INSERT INTO `xy_school` VALUES (397, '赤峰职业技术学院', '4115014050', 1);
INSERT INTO `xy_school` VALUES (398, '内蒙古经贸外语职业学院', '4115014051', 1);
INSERT INTO `xy_school` VALUES (399, '包头铁道职业技术学院', '4115014187', 1);
INSERT INTO `xy_school` VALUES (400, '乌兰察布医学高等专科学校', '4115014219', 1);
INSERT INTO `xy_school` VALUES (401, '鄂尔多斯职业学院', '4115014248', 1);
INSERT INTO `xy_school` VALUES (402, '内蒙古工业职业学院', '4115014282', 1);
INSERT INTO `xy_school` VALUES (403, '呼伦贝尔职业技术学院', '4115014283', 1);
INSERT INTO `xy_school` VALUES (404, '满洲里俄语职业学院', '4115014285', 1);
INSERT INTO `xy_school` VALUES (405, '内蒙古能源职业学院', '4115014337', 1);
INSERT INTO `xy_school` VALUES (406, '赤峰工业职业技术学院', '4115014338', 1);
INSERT INTO `xy_school` VALUES (407, '阿拉善职业技术学院', '4115014339', 1);
INSERT INTO `xy_school` VALUES (408, '内蒙古美术职业学院', '4115014387', 1);
INSERT INTO `xy_school` VALUES (409, '内蒙古民族幼儿师范高等专科学校', '4115014463', 1);
INSERT INTO `xy_school` VALUES (410, '鄂尔多斯生态环境职业学院', '4115014501', 1);
INSERT INTO `xy_school` VALUES (411, '扎兰屯职业学院', '4115014539', 1);
INSERT INTO `xy_school` VALUES (412, '赤峰应用技术职业学院', '4115014699', 1);
INSERT INTO `xy_school` VALUES (413, '辽宁大学', '4121010140', 1);
INSERT INTO `xy_school` VALUES (414, '大连理工大学', '4121010141', 1);
INSERT INTO `xy_school` VALUES (415, '沈阳工业大学', '4121010142', 1);
INSERT INTO `xy_school` VALUES (416, '沈阳航空航天大学', '4121010143', 1);
INSERT INTO `xy_school` VALUES (417, '沈阳理工大学', '4121010144', 1);
INSERT INTO `xy_school` VALUES (418, '东北大学', '4121010145', 1);
INSERT INTO `xy_school` VALUES (419, '辽宁科技大学', '4121010146', 1);
INSERT INTO `xy_school` VALUES (420, '辽宁工程技术大学', '4121010147', 1);
INSERT INTO `xy_school` VALUES (421, '辽宁石油化工大学', '4121010148', 1);
INSERT INTO `xy_school` VALUES (422, '沈阳化工大学', '4121010149', 1);
INSERT INTO `xy_school` VALUES (423, '大连交通大学', '4121010150', 1);
INSERT INTO `xy_school` VALUES (424, '大连海事大学', '4121010151', 1);
INSERT INTO `xy_school` VALUES (425, '大连工业大学', '4121010152', 1);
INSERT INTO `xy_school` VALUES (426, '沈阳建筑大学', '4121010153', 1);
INSERT INTO `xy_school` VALUES (427, '辽宁工业大学', '4121010154', 1);
INSERT INTO `xy_school` VALUES (428, '沈阳农业大学', '4121010157', 1);
INSERT INTO `xy_school` VALUES (429, '大连海洋大学', '4121010158', 1);
INSERT INTO `xy_school` VALUES (430, '中国医科大学', '4121010159', 1);
INSERT INTO `xy_school` VALUES (431, '锦州医科大学', '4121010160', 1);
INSERT INTO `xy_school` VALUES (432, '大连医科大学', '4121010161', 1);
INSERT INTO `xy_school` VALUES (433, '辽宁中医药大学', '4121010162', 1);
INSERT INTO `xy_school` VALUES (434, '沈阳药科大学', '4121010163', 1);
INSERT INTO `xy_school` VALUES (435, '沈阳医学院', '4121010164', 1);
INSERT INTO `xy_school` VALUES (436, '辽宁师范大学', '4121010165', 1);
INSERT INTO `xy_school` VALUES (437, '沈阳师范大学', '4121010166', 1);
INSERT INTO `xy_school` VALUES (438, '渤海大学', '4121010167', 1);
INSERT INTO `xy_school` VALUES (439, '鞍山师范学院', '4121010169', 1);
INSERT INTO `xy_school` VALUES (440, '大连外国语大学', '4121010172', 1);
INSERT INTO `xy_school` VALUES (441, '东北财经大学', '4121010173', 1);
INSERT INTO `xy_school` VALUES (442, '中国刑事警察学院', '4121010175', 1);
INSERT INTO `xy_school` VALUES (443, '沈阳体育学院', '4121010176', 1);
INSERT INTO `xy_school` VALUES (444, '沈阳音乐学院', '4121010177', 1);
INSERT INTO `xy_school` VALUES (445, '鲁迅美术学院', '4121010178', 1);
INSERT INTO `xy_school` VALUES (446, '辽宁对外经贸学院', '4121010841', 1);
INSERT INTO `xy_school` VALUES (447, '沈阳大学', '4121011035', 1);
INSERT INTO `xy_school` VALUES (448, '大连大学', '4121011258', 1);
INSERT INTO `xy_school` VALUES (449, '辽宁科技学院', '4121011430', 1);
INSERT INTO `xy_school` VALUES (450, '辽宁警察学院', '4121011432', 1);
INSERT INTO `xy_school` VALUES (451, '沈阳工程学院', '4121011632', 1);
INSERT INTO `xy_school` VALUES (452, '辽东学院', '4121011779', 1);
INSERT INTO `xy_school` VALUES (453, '大连民族大学', '4121012026', 1);
INSERT INTO `xy_school` VALUES (454, '辽宁理工职业大学', '4121012595', 1);
INSERT INTO `xy_school` VALUES (455, '大连理工大学城市学院', '4121013198', 1);
INSERT INTO `xy_school` VALUES (456, '沈阳工业大学工程学院', '4121013199', 1);
INSERT INTO `xy_school` VALUES (457, '沈阳航空航天大学北方科技学院', '4121013200', 1);
INSERT INTO `xy_school` VALUES (458, '沈阳工学院', '4121013201', 1);
INSERT INTO `xy_school` VALUES (459, '大连工业大学艺术与信息工程学院', '4121013203', 1);
INSERT INTO `xy_school` VALUES (460, '大连科技学院', '4121013207', 1);
INSERT INTO `xy_school` VALUES (461, '沈阳城市建设学院', '4121013208', 1);
INSERT INTO `xy_school` VALUES (462, '中国医科大学临床医药学院', '4121013211', 1);
INSERT INTO `xy_school` VALUES (463, '大连医科大学中山学院', '4121013212', 1);
INSERT INTO `xy_school` VALUES (464, '锦州医科大学医疗学院', '4121013213', 1);
INSERT INTO `xy_school` VALUES (465, '辽宁师范大学海华学院', '4121013215', 1);
INSERT INTO `xy_school` VALUES (466, '辽宁理工学院', '4121013217', 1);
INSERT INTO `xy_school` VALUES (467, '大连财经学院', '4121013218', 1);
INSERT INTO `xy_school` VALUES (468, '沈阳城市学院', '4121013220', 1);
INSERT INTO `xy_school` VALUES (469, '辽宁石油化工大学顺华能源学院', '4121013583', 1);
INSERT INTO `xy_school` VALUES (470, '大连艺术学院', '4121013599', 1);
INSERT INTO `xy_school` VALUES (471, '辽宁中医药大学杏林学院', '4121013609', 1);
INSERT INTO `xy_school` VALUES (472, '辽宁何氏医学院', '4121013610', 1);
INSERT INTO `xy_school` VALUES (473, '沈阳科技学院', '4121013621', 1);
INSERT INTO `xy_school` VALUES (474, '大连东软信息学院', '4121013631', 1);
INSERT INTO `xy_school` VALUES (475, '辽宁财贸学院', '4121013900', 1);
INSERT INTO `xy_school` VALUES (476, '辽宁传媒学院', '4121013957', 1);
INSERT INTO `xy_school` VALUES (477, '营口理工学院', '4121014435', 1);
INSERT INTO `xy_school` VALUES (478, '朝阳师范高等专科学校', '4121010171', 1);
INSERT INTO `xy_school` VALUES (479, '抚顺师范高等专科学校', '4121010179', 1);
INSERT INTO `xy_school` VALUES (480, '锦州师范高等专科学校', '4121010180', 1);
INSERT INTO `xy_school` VALUES (481, '营口职业技术学院', '4121010181', 1);
INSERT INTO `xy_school` VALUES (482, '铁岭师范高等专科学校', '4121010182', 1);
INSERT INTO `xy_school` VALUES (483, '大连职业技术学院', '4121010845', 1);
INSERT INTO `xy_school` VALUES (484, '辽宁农业职业技术学院', '4121010957', 1);
INSERT INTO `xy_school` VALUES (485, '抚顺职业技术学院', '4121011037', 1);
INSERT INTO `xy_school` VALUES (486, '辽阳职业技术学院', '4121011249', 1);
INSERT INTO `xy_school` VALUES (487, '阜新高等专科学校', '4121011250', 1);
INSERT INTO `xy_school` VALUES (488, '辽宁省交通高等专科学校', '4121011500', 1);
INSERT INTO `xy_school` VALUES (489, '辽宁税务高等专科学校', '4121011735', 1);
INSERT INTO `xy_school` VALUES (490, '盘锦职业技术学院', '4121012063', 1);
INSERT INTO `xy_school` VALUES (491, '沈阳航空职业技术学院', '4121012590', 1);
INSERT INTO `xy_school` VALUES (492, '辽宁体育运动职业技术学院', '4121012591', 1);
INSERT INTO `xy_school` VALUES (493, '辽宁职业学院', '4121012592', 1);
INSERT INTO `xy_school` VALUES (494, '辽宁生态工程职业学院', '4121012593', 1);
INSERT INTO `xy_school` VALUES (495, '沈阳职业技术学院', '4121012594', 1);
INSERT INTO `xy_school` VALUES (496, '大连商务职业学院', '4121012730', 1);
INSERT INTO `xy_school` VALUES (497, '辽宁金融职业学院', '4121012895', 1);
INSERT INTO `xy_school` VALUES (498, '辽宁轨道交通职业学院', '4121012896', 1);
INSERT INTO `xy_school` VALUES (499, '辽宁广告职业学院', '4121012897', 1);
INSERT INTO `xy_school` VALUES (500, '辽宁机电职业技术学院', '4121012898', 1);
INSERT INTO `xy_school` VALUES (501, '辽宁经济职业技术学院', '4121012899', 1);
INSERT INTO `xy_school` VALUES (502, '辽宁石化职业技术学院', '4121012900', 1);
INSERT INTO `xy_school` VALUES (503, '渤海船舶职业学院', '4121012931', 1);
INSERT INTO `xy_school` VALUES (504, '大连软件职业学院', '4121013958', 1);
INSERT INTO `xy_school` VALUES (505, '大连翻译职业学院', '4121013959', 1);
INSERT INTO `xy_school` VALUES (506, '辽宁商贸职业学院', '4121013960', 1);
INSERT INTO `xy_school` VALUES (507, '大连枫叶职业技术学院', '4121013961', 1);
INSERT INTO `xy_school` VALUES (508, '辽宁装备制造职业技术学院', '4121014076', 1);
INSERT INTO `xy_school` VALUES (509, '辽河石油职业技术学院', '4121014077', 1);
INSERT INTO `xy_school` VALUES (510, '辽宁地质工程职业学院', '4121014106', 1);
INSERT INTO `xy_school` VALUES (511, '辽宁铁道职业技术学院', '4121014188', 1);
INSERT INTO `xy_school` VALUES (512, '辽宁建筑职业学院', '4121014189', 1);
INSERT INTO `xy_school` VALUES (513, '大连航运职业技术学院', '4121014209', 1);
INSERT INTO `xy_school` VALUES (514, '大连装备制造职业技术学院', '4121014227', 1);
INSERT INTO `xy_school` VALUES (515, '大连汽车职业技术学院', '4121014228', 1);
INSERT INTO `xy_school` VALUES (516, '辽宁现代服务职业技术学院', '4121014240', 1);
INSERT INTO `xy_school` VALUES (517, '辽宁冶金职业技术学院', '4121014286', 1);
INSERT INTO `xy_school` VALUES (518, '辽宁工程职业学院', '4121014287', 1);
INSERT INTO `xy_school` VALUES (519, '辽宁城市建设职业技术学院', '4121014288', 1);
INSERT INTO `xy_school` VALUES (520, '辽宁医药职业学院', '4121014289', 1);
INSERT INTO `xy_school` VALUES (521, '铁岭卫生职业学院', '4121014290', 1);
INSERT INTO `xy_school` VALUES (522, '沈阳北软信息职业技术学院', '4121014385', 1);
INSERT INTO `xy_school` VALUES (523, '辽宁政法职业学院', '4121014398', 1);
INSERT INTO `xy_school` VALUES (524, '辽宁民族师范高等专科学校', '4121014464', 1);
INSERT INTO `xy_school` VALUES (525, '辽宁轻工职业学院', '4121014473', 1);
INSERT INTO `xy_school` VALUES (526, '辽宁特殊教育师范高等专科学校', '4121014526', 1);
INSERT INTO `xy_school` VALUES (527, '辽宁师范高等专科学校', '4121014662', 1);
INSERT INTO `xy_school` VALUES (528, '鞍山职业技术学院', '4121014700', 1);
INSERT INTO `xy_school` VALUES (529, '吉林大学', '4122010183', 1);
INSERT INTO `xy_school` VALUES (530, '延边大学', '4122010184', 1);
INSERT INTO `xy_school` VALUES (531, '长春理工大学', '4122010186', 1);
INSERT INTO `xy_school` VALUES (532, '东北电力大学', '4122010188', 1);
INSERT INTO `xy_school` VALUES (533, '长春工业大学', '4122010190', 1);
INSERT INTO `xy_school` VALUES (534, '吉林建筑大学', '4122010191', 1);
INSERT INTO `xy_school` VALUES (535, '吉林化工学院', '4122010192', 1);
INSERT INTO `xy_school` VALUES (536, '吉林农业大学', '4122010193', 1);
INSERT INTO `xy_school` VALUES (537, '长春中医药大学', '4122010199', 1);
INSERT INTO `xy_school` VALUES (538, '东北师范大学', '4122010200', 1);
INSERT INTO `xy_school` VALUES (539, '北华大学', '4122010201', 1);
INSERT INTO `xy_school` VALUES (540, '通化师范学院', '4122010202', 1);
INSERT INTO `xy_school` VALUES (541, '吉林师范大学', '4122010203', 1);
INSERT INTO `xy_school` VALUES (542, '吉林工程技术师范学院', '4122010204', 1);
INSERT INTO `xy_school` VALUES (543, '长春师范大学', '4122010205', 1);
INSERT INTO `xy_school` VALUES (544, '白城师范学院', '4122010206', 1);
INSERT INTO `xy_school` VALUES (545, '吉林财经大学', '4122010207', 1);
INSERT INTO `xy_school` VALUES (546, '吉林体育学院', '4122010208', 1);
INSERT INTO `xy_school` VALUES (547, '吉林艺术学院', '4122010209', 1);
INSERT INTO `xy_school` VALUES (548, '吉林外国语大学', '4122010964', 1);
INSERT INTO `xy_school` VALUES (549, '吉林工商学院', '4122011261', 1);
INSERT INTO `xy_school` VALUES (550, '长春工程学院', '4122011437', 1);
INSERT INTO `xy_school` VALUES (551, '吉林农业科技学院', '4122011439', 1);
INSERT INTO `xy_school` VALUES (552, '吉林警察学院', '4122011441', 1);
INSERT INTO `xy_school` VALUES (553, '长春大学', '4122011726', 1);
INSERT INTO `xy_school` VALUES (554, '长春光华学院', '4122013600', 1);
INSERT INTO `xy_school` VALUES (555, '长春工业大学人文信息学院', '4122013601', 1);
INSERT INTO `xy_school` VALUES (556, '长春理工大学光电信息学院', '4122013602', 1);
INSERT INTO `xy_school` VALUES (557, '长春财经学院', '4122013603', 1);
INSERT INTO `xy_school` VALUES (558, '吉林建筑科技学院', '4122013604', 1);
INSERT INTO `xy_school` VALUES (559, '长春建筑学院', '4122013605', 1);
INSERT INTO `xy_school` VALUES (560, '长春科技学院', '4122013606', 1);
INSERT INTO `xy_school` VALUES (561, '吉林动画学院', '4122013607', 1);
INSERT INTO `xy_school` VALUES (562, '吉林师范大学博达学院', '4122013622', 1);
INSERT INTO `xy_school` VALUES (563, '长春大学旅游学院', '4122013623', 1);
INSERT INTO `xy_school` VALUES (564, '东北师范大学人文学院', '4122013662', 1);
INSERT INTO `xy_school` VALUES (565, '吉林医药学院', '4122013706', 1);
INSERT INTO `xy_school` VALUES (566, '长春师范高等专科学校', '3622000335', 1);
INSERT INTO `xy_school` VALUES (567, '辽源职业技术学院', '4122010847', 1);
INSERT INTO `xy_school` VALUES (568, '四平职业大学', '4122011044', 1);
INSERT INTO `xy_school` VALUES (569, '长春汽车工业高等专科学校', '4122011436', 1);
INSERT INTO `xy_school` VALUES (570, '长春金融高等专科学校', '4122011440', 1);
INSERT INTO `xy_school` VALUES (571, '长春医学高等专科学校', '4122011823', 1);
INSERT INTO `xy_school` VALUES (572, '吉林交通职业技术学院', '4122012049', 1);
INSERT INTO `xy_school` VALUES (573, '长春东方职业学院', '4122012306', 1);
INSERT INTO `xy_school` VALUES (574, '吉林司法警官职业学院', '4122012901', 1);
INSERT INTO `xy_school` VALUES (575, '吉林电子信息职业技术学院', '4122012902', 1);
INSERT INTO `xy_school` VALUES (576, '吉林工业职业技术学院', '4122012903', 1);
INSERT INTO `xy_school` VALUES (577, '吉林工程职业学院', '4122012904', 1);
INSERT INTO `xy_school` VALUES (578, '长春职业技术学院', '4122013161', 1);
INSERT INTO `xy_school` VALUES (579, '白城医学高等专科学校', '4122013743', 1);
INSERT INTO `xy_school` VALUES (580, '长春信息技术职业学院', '4122013916', 1);
INSERT INTO `xy_school` VALUES (581, '松原职业技术学院', '4122013917', 1);
INSERT INTO `xy_school` VALUES (582, '吉林铁道职业技术学院', '4122014052', 1);
INSERT INTO `xy_school` VALUES (583, '白城职业技术学院', '4122014107', 1);
INSERT INTO `xy_school` VALUES (584, '长白山职业技术学院', '4122014190', 1);
INSERT INTO `xy_school` VALUES (585, '吉林科技职业技术学院', '4122014291', 1);
INSERT INTO `xy_school` VALUES (586, '延边职业技术学院', '4122014340', 1);
INSERT INTO `xy_school` VALUES (587, '吉林城市职业技术学院', '4122014426', 1);
INSERT INTO `xy_school` VALUES (588, '吉林职业技术学院', '4122014567', 1);
INSERT INTO `xy_school` VALUES (589, '吉林水利电力职业学院', '4122014602', 1);
INSERT INTO `xy_school` VALUES (590, '长春健康职业学院', '4122014603', 1);
INSERT INTO `xy_school` VALUES (591, '长春早期教育职业学院', '4122014701', 1);
INSERT INTO `xy_school` VALUES (592, '梅河口康美职业技术学院', '4122014702', 1);
INSERT INTO `xy_school` VALUES (593, '黑龙江大学', '4123010212', 1);
INSERT INTO `xy_school` VALUES (594, '哈尔滨工业大学', '4123010213', 1);
INSERT INTO `xy_school` VALUES (595, '哈尔滨理工大学', '4123010214', 1);
INSERT INTO `xy_school` VALUES (596, '哈尔滨工程大学', '4123010217', 1);
INSERT INTO `xy_school` VALUES (597, '黑龙江科技大学', '4123010219', 1);
INSERT INTO `xy_school` VALUES (598, '东北石油大学', '4123010220', 1);
INSERT INTO `xy_school` VALUES (599, '佳木斯大学', '4123010222', 1);
INSERT INTO `xy_school` VALUES (600, '黑龙江八一农垦大学', '4123010223', 1);
INSERT INTO `xy_school` VALUES (601, '东北农业大学', '4123010224', 1);
INSERT INTO `xy_school` VALUES (602, '东北林业大学', '4123010225', 1);
INSERT INTO `xy_school` VALUES (603, '哈尔滨医科大学', '4123010226', 1);
INSERT INTO `xy_school` VALUES (604, '黑龙江中医药大学', '4123010228', 1);
INSERT INTO `xy_school` VALUES (605, '牡丹江医学院', '4123010229', 1);
INSERT INTO `xy_school` VALUES (606, '哈尔滨师范大学', '4123010231', 1);
INSERT INTO `xy_school` VALUES (607, '齐齐哈尔大学', '4123010232', 1);
INSERT INTO `xy_school` VALUES (608, '牡丹江师范学院', '4123010233', 1);
INSERT INTO `xy_school` VALUES (609, '哈尔滨学院', '4123010234', 1);
INSERT INTO `xy_school` VALUES (610, '大庆师范学院', '4123010235', 1);
INSERT INTO `xy_school` VALUES (611, '绥化学院', '4123010236', 1);
INSERT INTO `xy_school` VALUES (612, '哈尔滨商业大学', '4123010240', 1);
INSERT INTO `xy_school` VALUES (613, '哈尔滨体育学院', '4123010242', 1);
INSERT INTO `xy_school` VALUES (614, '哈尔滨金融学院', '4123010245', 1);
INSERT INTO `xy_school` VALUES (615, '齐齐哈尔医学院', '4123011230', 1);
INSERT INTO `xy_school` VALUES (616, '黑龙江工业学院', '4123011445', 1);
INSERT INTO `xy_school` VALUES (617, '黑龙江东方学院', '4123011446', 1);
INSERT INTO `xy_school` VALUES (618, '哈尔滨信息工程学院', '4123011635', 1);
INSERT INTO `xy_school` VALUES (619, '黑龙江工程学院', '4123011802', 1);
INSERT INTO `xy_school` VALUES (620, '齐齐哈尔工程学院', '4123012729', 1);
INSERT INTO `xy_school` VALUES (621, '黑龙江外国语学院', '4123013296', 1);
INSERT INTO `xy_school` VALUES (622, '黑龙江财经学院', '4123013298', 1);
INSERT INTO `xy_school` VALUES (623, '哈尔滨石油学院', '4123013299', 1);
INSERT INTO `xy_school` VALUES (624, '黑龙江工商学院', '4123013300', 1);
INSERT INTO `xy_school` VALUES (625, '哈尔滨远东理工学院', '4123013301', 1);
INSERT INTO `xy_school` VALUES (626, '哈尔滨剑桥学院', '4123013303', 1);
INSERT INTO `xy_school` VALUES (627, '黑龙江工程学院昆仑旅游学院', '4123013304', 1);
INSERT INTO `xy_school` VALUES (628, '哈尔滨广厦学院', '4123013306', 1);
INSERT INTO `xy_school` VALUES (629, '哈尔滨华德学院', '4123013307', 1);
INSERT INTO `xy_school` VALUES (630, '黑河学院', '4123013744', 1);
INSERT INTO `xy_school` VALUES (631, '哈尔滨音乐学院', '4123014560', 1);
INSERT INTO `xy_school` VALUES (632, '齐齐哈尔高等师范专科学校', '4123010238', 1);
INSERT INTO `xy_school` VALUES (633, '伊春职业学院', '4123010872', 1);
INSERT INTO `xy_school` VALUES (634, '牡丹江大学', '4123011046', 1);
INSERT INTO `xy_school` VALUES (635, '黑龙江职业学院', '4123011449', 1);
INSERT INTO `xy_school` VALUES (636, '黑龙江建筑职业技术学院', '4123012053', 1);
INSERT INTO `xy_school` VALUES (637, '黑龙江艺术职业学院', '4123012490', 1);
INSERT INTO `xy_school` VALUES (638, '大庆职业学院', '4123012718', 1);
INSERT INTO `xy_school` VALUES (639, '黑龙江林业职业技术学院', '4123012724', 1);
INSERT INTO `xy_school` VALUES (640, '黑龙江农业职业技术学院', '4123012725', 1);
INSERT INTO `xy_school` VALUES (641, '黑龙江农业工程职业学院', '4123012726', 1);
INSERT INTO `xy_school` VALUES (642, '黑龙江农垦职业学院', '4123012727', 1);
INSERT INTO `xy_school` VALUES (643, '黑龙江司法警官职业学院', '4123012728', 1);
INSERT INTO `xy_school` VALUES (644, '鹤岗师范高等专科学校', '4123012905', 1);
INSERT INTO `xy_school` VALUES (645, '哈尔滨电力职业技术学院', '4123012906', 1);
INSERT INTO `xy_school` VALUES (646, '哈尔滨铁道职业技术学院', '4123012907', 1);
INSERT INTO `xy_school` VALUES (647, '大兴安岭职业学院', '4123012908', 1);
INSERT INTO `xy_school` VALUES (648, '黑龙江农业经济职业学院', '4123012910', 1);
INSERT INTO `xy_school` VALUES (649, '哈尔滨职业技术学院', '4123012911', 1);
INSERT INTO `xy_school` VALUES (650, '哈尔滨传媒职业学院', '4123013302', 1);
INSERT INTO `xy_school` VALUES (651, '黑龙江生物科技职业学院', '4123013447', 1);
INSERT INTO `xy_school` VALUES (652, '黑龙江商业职业学院', '4123013448', 1);
INSERT INTO `xy_school` VALUES (653, '黑龙江公安警官职业学院', '4123013449', 1);
INSERT INTO `xy_school` VALUES (654, '哈尔滨城市职业学院', '4123013451', 1);
INSERT INTO `xy_school` VALUES (655, '黑龙江农垦科技职业学院', '4123013453', 1);
INSERT INTO `xy_school` VALUES (656, '黑龙江旅游职业技术学院', '4123013729', 1);
INSERT INTO `xy_school` VALUES (657, '黑龙江三江美术职业学院', '4123013730', 1);
INSERT INTO `xy_school` VALUES (658, '黑龙江生态工程职业学院', '4123013731', 1);
INSERT INTO `xy_school` VALUES (659, '黑龙江能源职业学院', '4123013732', 1);
INSERT INTO `xy_school` VALUES (660, '七台河职业学院', '4123013918', 1);
INSERT INTO `xy_school` VALUES (661, '黑龙江民族职业学院', '4123013935', 1);
INSERT INTO `xy_school` VALUES (662, '大庆医学高等专科学校', '4123014017', 1);
INSERT INTO `xy_school` VALUES (663, '黑龙江交通职业技术学院', '4123014053', 1);
INSERT INTO `xy_school` VALUES (664, '哈尔滨应用职业技术学院', '4123014055', 1);
INSERT INTO `xy_school` VALUES (665, '黑龙江幼儿师范高等专科学校', '4123014095', 1);
INSERT INTO `xy_school` VALUES (666, '哈尔滨科学技术职业学院', '4123014108', 1);
INSERT INTO `xy_school` VALUES (667, '佳木斯职业学院', '4123014178', 1);
INSERT INTO `xy_school` VALUES (668, '黑龙江护理高等专科学校', '4123014272', 1);
INSERT INTO `xy_school` VALUES (669, '齐齐哈尔理工职业学院', '4123014400', 1);
INSERT INTO `xy_school` VALUES (670, '哈尔滨幼儿师范高等专科学校', '4123014425', 1);
INSERT INTO `xy_school` VALUES (671, '黑龙江冰雪体育职业学院', '4123014540', 1);
INSERT INTO `xy_school` VALUES (672, '哈尔滨北方航空职业技术学院', '4123014633', 1);
INSERT INTO `xy_school` VALUES (673, '复旦大学', '4131010246', 1);
INSERT INTO `xy_school` VALUES (674, '同济大学', '4131010247', 1);
INSERT INTO `xy_school` VALUES (675, '上海交通大学', '4131010248', 1);
INSERT INTO `xy_school` VALUES (676, '华东理工大学', '4131010251', 1);
INSERT INTO `xy_school` VALUES (677, '上海理工大学', '4131010252', 1);
INSERT INTO `xy_school` VALUES (678, '上海海事大学', '4131010254', 1);
INSERT INTO `xy_school` VALUES (679, '东华大学', '4131010255', 1);
INSERT INTO `xy_school` VALUES (680, '上海电力大学', '4131010256', 1);
INSERT INTO `xy_school` VALUES (681, '上海应用技术大学', '4131010259', 1);
INSERT INTO `xy_school` VALUES (682, '上海健康医学院', '4131010262', 1);
INSERT INTO `xy_school` VALUES (683, '上海海洋大学', '4131010264', 1);
INSERT INTO `xy_school` VALUES (684, '上海中医药大学', '4131010268', 1);
INSERT INTO `xy_school` VALUES (685, '华东师范大学', '4131010269', 1);
INSERT INTO `xy_school` VALUES (686, '上海师范大学', '4131010270', 1);
INSERT INTO `xy_school` VALUES (687, '上海外国语大学', '4131010271', 1);
INSERT INTO `xy_school` VALUES (688, '上海财经大学', '4131010272', 1);
INSERT INTO `xy_school` VALUES (689, '上海对外经贸大学', '4131010273', 1);
INSERT INTO `xy_school` VALUES (690, '上海海关学院', '4131010274', 1);
INSERT INTO `xy_school` VALUES (691, '华东政法大学', '4131010276', 1);
INSERT INTO `xy_school` VALUES (692, '上海体育学院', '4131010277', 1);
INSERT INTO `xy_school` VALUES (693, '上海音乐学院', '4131010278', 1);
INSERT INTO `xy_school` VALUES (694, '上海戏剧学院', '4131010279', 1);
INSERT INTO `xy_school` VALUES (695, '上海大学', '4131010280', 1);
INSERT INTO `xy_school` VALUES (696, '上海公安学院', '4131010283', 1);
INSERT INTO `xy_school` VALUES (697, '上海工程技术大学', '4131010856', 1);
INSERT INTO `xy_school` VALUES (698, '上海立信会计金融学院', '4131011047', 1);
INSERT INTO `xy_school` VALUES (699, '上海电机学院', '4131011458', 1);
INSERT INTO `xy_school` VALUES (700, '上海杉达学院', '4131011833', 1);
INSERT INTO `xy_school` VALUES (701, '上海政法学院', '4131011835', 1);
INSERT INTO `xy_school` VALUES (702, '上海第二工业大学', '4131012044', 1);
INSERT INTO `xy_school` VALUES (703, '上海商学院', '4131012050', 1);
INSERT INTO `xy_school` VALUES (704, '上海立达学院', '4131012587', 1);
INSERT INTO `xy_school` VALUES (705, '上海建桥学院', '4131012799', 1);
INSERT INTO `xy_school` VALUES (706, '上海兴伟学院', '4131012914', 1);
INSERT INTO `xy_school` VALUES (707, '上海中侨职业技术大学', '4131012915', 1);
INSERT INTO `xy_school` VALUES (708, '上海视觉艺术学院', '4131013632', 1);
INSERT INTO `xy_school` VALUES (709, '上海外国语大学贤达经济人文学院', '4131013636', 1);
INSERT INTO `xy_school` VALUES (710, '上海师范大学天华学院', '4131013893', 1);
INSERT INTO `xy_school` VALUES (711, '上海科技大学', '4131014423', 1);
INSERT INTO `xy_school` VALUES (712, '上海纽约大学', '4131016404', 1);
INSERT INTO `xy_school` VALUES (713, '上海旅游高等专科学校', '4131010275', 1);
INSERT INTO `xy_school` VALUES (714, '上海东海职业技术学院', '4131010851', 1);
INSERT INTO `xy_school` VALUES (715, '上海工商职业技术学院', '4131010852', 1);
INSERT INTO `xy_school` VALUES (716, '上海出版印刷高等专科学校', '4131011733', 1);
INSERT INTO `xy_school` VALUES (717, '上海行健职业学院', '4131012493', 1);
INSERT INTO `xy_school` VALUES (718, '上海城建职业学院', '4131012495', 1);
INSERT INTO `xy_school` VALUES (719, '上海交通职业技术学院', '4131012497', 1);
INSERT INTO `xy_school` VALUES (720, '上海海事职业技术学院', '4131012498', 1);
INSERT INTO `xy_school` VALUES (721, '上海电子信息职业技术学院', '4131012499', 1);
INSERT INTO `xy_school` VALUES (722, '上海震旦职业学院', '4131012583', 1);
INSERT INTO `xy_school` VALUES (723, '上海民远职业技术学院', '4131012584', 1);
INSERT INTO `xy_school` VALUES (724, '上海欧华职业技术学院', '4131012585', 1);
INSERT INTO `xy_school` VALUES (725, '上海思博职业技术学院', '4131012586', 1);
INSERT INTO `xy_school` VALUES (726, '上海工艺美术职业学院', '4131012588', 1);
INSERT INTO `xy_school` VALUES (727, '上海济光职业技术学院', '4131012798', 1);
INSERT INTO `xy_school` VALUES (728, '上海工商外国语职业学院', '4131012800', 1);
INSERT INTO `xy_school` VALUES (729, '上海科学技术职业学院', '4131012801', 1);
INSERT INTO `xy_school` VALUES (730, '上海农林职业技术学院', '4131012912', 1);
INSERT INTO `xy_school` VALUES (731, '上海邦德职业技术学院', '4131012913', 1);
INSERT INTO `xy_school` VALUES (732, '上海电影艺术职业学院', '4131013747', 1);
INSERT INTO `xy_school` VALUES (733, '上海中华职业技术学院', '4131013907', 1);
INSERT INTO `xy_school` VALUES (734, '上海工会管理职业学院', '4131014023', 1);
INSERT INTO `xy_school` VALUES (735, '上海民航职业技术学院', '4131014394', 1);
INSERT INTO `xy_school` VALUES (736, '南京大学', '4132010284', 1);
INSERT INTO `xy_school` VALUES (737, '苏州大学', '4132010285', 1);
INSERT INTO `xy_school` VALUES (738, '东南大学', '4132010286', 1);
INSERT INTO `xy_school` VALUES (739, '南京航空航天大学', '4132010287', 1);
INSERT INTO `xy_school` VALUES (740, '南京理工大学', '4132010288', 1);
INSERT INTO `xy_school` VALUES (741, '江苏科技大学', '4132010289', 1);
INSERT INTO `xy_school` VALUES (742, '中国矿业大学', '4132010290', 1);
INSERT INTO `xy_school` VALUES (743, '南京工业大学', '4132010291', 1);
INSERT INTO `xy_school` VALUES (744, '常州大学', '4132010292', 1);
INSERT INTO `xy_school` VALUES (745, '南京邮电大学', '4132010293', 1);
INSERT INTO `xy_school` VALUES (746, '河海大学', '4132010294', 1);
INSERT INTO `xy_school` VALUES (747, '江南大学', '4132010295', 1);
INSERT INTO `xy_school` VALUES (748, '南京林业大学', '4132010298', 1);
INSERT INTO `xy_school` VALUES (749, '江苏大学', '4132010299', 1);
INSERT INTO `xy_school` VALUES (750, '南京信息工程大学', '4132010300', 1);
INSERT INTO `xy_school` VALUES (751, '南通大学', '4132010304', 1);
INSERT INTO `xy_school` VALUES (752, '盐城工学院', '4132010305', 1);
INSERT INTO `xy_school` VALUES (753, '南京农业大学', '4132010307', 1);
INSERT INTO `xy_school` VALUES (754, '南京医科大学', '4132010312', 1);
INSERT INTO `xy_school` VALUES (755, '徐州医科大学', '4132010313', 1);
INSERT INTO `xy_school` VALUES (756, '南京中医药大学', '4132010315', 1);
INSERT INTO `xy_school` VALUES (757, '中国药科大学', '4132010316', 1);
INSERT INTO `xy_school` VALUES (758, '南京师范大学', '4132010319', 1);
INSERT INTO `xy_school` VALUES (759, '江苏师范大学', '4132010320', 1);
INSERT INTO `xy_school` VALUES (760, '淮阴师范学院', '4132010323', 1);
INSERT INTO `xy_school` VALUES (761, '盐城师范学院', '4132010324', 1);
INSERT INTO `xy_school` VALUES (762, '南京财经大学', '4132010327', 1);
INSERT INTO `xy_school` VALUES (763, '江苏警官学院', '4132010329', 1);
INSERT INTO `xy_school` VALUES (764, '南京体育学院', '4132010330', 1);
INSERT INTO `xy_school` VALUES (765, '南京艺术学院', '4132010331', 1);
INSERT INTO `xy_school` VALUES (766, '苏州科技大学', '4132010332', 1);
INSERT INTO `xy_school` VALUES (767, '常熟理工学院', '4132010333', 1);
INSERT INTO `xy_school` VALUES (768, '南京工业职业技术大学', '4132010850', 1);
INSERT INTO `xy_school` VALUES (769, '淮阴工学院', '4132011049', 1);
INSERT INTO `xy_school` VALUES (770, '常州工学院', '4132011055', 1);
INSERT INTO `xy_school` VALUES (771, '扬州大学', '4132011117', 1);
INSERT INTO `xy_school` VALUES (772, '三江学院', '4132011122', 1);
INSERT INTO `xy_school` VALUES (773, '南京工程学院', '4132011276', 1);
INSERT INTO `xy_school` VALUES (774, '南京审计大学', '4132011287', 1);
INSERT INTO `xy_school` VALUES (775, '南京晓庄学院', '4132011460', 1);
INSERT INTO `xy_school` VALUES (776, '江苏理工学院', '4132011463', 1);
INSERT INTO `xy_school` VALUES (777, '江苏海洋大学', '4132011641', 1);
INSERT INTO `xy_school` VALUES (778, '徐州工程学院', '4132011998', 1);
INSERT INTO `xy_school` VALUES (779, '南京特殊教育师范学院', '4132012048', 1);
INSERT INTO `xy_school` VALUES (780, '南通理工学院', '4132012056', 1);
INSERT INTO `xy_school` VALUES (781, '南京森林警察学院', '4132012213', 1);
INSERT INTO `xy_school` VALUES (782, '东南大学成贤学院', '4132012689', 1);
INSERT INTO `xy_school` VALUES (783, '泰州学院', '4132012917', 1);
INSERT INTO `xy_school` VALUES (784, '无锡太湖学院', '4132013571', 1);
INSERT INTO `xy_school` VALUES (785, '金陵科技学院', '4132013573', 1);
INSERT INTO `xy_school` VALUES (786, '中国矿业大学徐海学院', '4132013579', 1);
INSERT INTO `xy_school` VALUES (787, '南京大学金陵学院', '4132013646', 1);
INSERT INTO `xy_school` VALUES (788, '南京理工大学紫金学院', '4132013654', 1);
INSERT INTO `xy_school` VALUES (789, '南京航空航天大学金城学院', '4132013655', 1);
INSERT INTO `xy_school` VALUES (790, '南京传媒学院', '4132013687', 1);
INSERT INTO `xy_school` VALUES (791, '南京理工大学泰州科技学院', '4132013842', 1);
INSERT INTO `xy_school` VALUES (792, '南京师范大学泰州学院', '4132013843', 1);
INSERT INTO `xy_school` VALUES (793, '南京工业大学浦江学院', '4132013905', 1);
INSERT INTO `xy_school` VALUES (794, '南京师范大学中北学院', '4132013906', 1);
INSERT INTO `xy_school` VALUES (795, '南京医科大学康达学院', '4132013980', 1);
INSERT INTO `xy_school` VALUES (796, '南京中医药大学翰林学院', '4132013981', 1);
INSERT INTO `xy_school` VALUES (797, '南京信息工程大学滨江学院', '4132013982', 1);
INSERT INTO `xy_school` VALUES (798, '苏州大学文正学院', '4132013983', 1);
INSERT INTO `xy_school` VALUES (799, '苏州大学应用技术学院', '4132013984', 1);
INSERT INTO `xy_school` VALUES (800, '苏州科技大学天平学院', '4132013985', 1);
INSERT INTO `xy_school` VALUES (801, '江苏大学京江学院', '4132013986', 1);
INSERT INTO `xy_school` VALUES (802, '扬州大学广陵学院', '4132013987', 1);
INSERT INTO `xy_school` VALUES (803, '江苏师范大学科文学院', '4132013988', 1);
INSERT INTO `xy_school` VALUES (804, '南京邮电大学通达学院', '4132013989', 1);
INSERT INTO `xy_school` VALUES (805, '南京财经大学红山学院', '4132013990', 1);
INSERT INTO `xy_school` VALUES (806, '江苏科技大学苏州理工学院', '4132013991', 1);
INSERT INTO `xy_school` VALUES (807, '常州大学怀德学院', '4132013992', 1);
INSERT INTO `xy_school` VALUES (808, '南通大学杏林学院', '4132013993', 1);
INSERT INTO `xy_school` VALUES (809, '南京审计大学金审学院', '4132013994', 1);
INSERT INTO `xy_school` VALUES (810, '宿迁学院', '4132014160', 1);
INSERT INTO `xy_school` VALUES (811, '江苏第二师范学院', '4132014436', 1);
INSERT INTO `xy_school` VALUES (812, '西交利物浦大学', '4132016403', 1);
INSERT INTO `xy_school` VALUES (813, '昆山杜克大学', '4132016406', 1);
INSERT INTO `xy_school` VALUES (814, '盐城幼儿师范高等专科学校', '3632000466', 1);
INSERT INTO `xy_school` VALUES (815, '苏州幼儿师范高等专科学校', '3632000583', 1);
INSERT INTO `xy_school` VALUES (816, '明达职业技术学院', '4132010826', 1);
INSERT INTO `xy_school` VALUES (817, '无锡职业技术学院', '4132010848', 1);
INSERT INTO `xy_school` VALUES (818, '江苏建筑职业技术学院', '4132010849', 1);
INSERT INTO `xy_school` VALUES (819, '江苏工程职业技术学院', '4132010958', 1);
INSERT INTO `xy_school` VALUES (820, '苏州工艺美术职业技术学院', '4132010960', 1);
INSERT INTO `xy_school` VALUES (821, '连云港职业技术学院', '4132011050', 1);
INSERT INTO `xy_school` VALUES (822, '镇江市高等专科学校', '4132011051', 1);
INSERT INTO `xy_school` VALUES (823, '南通职业大学', '4132011052', 1);
INSERT INTO `xy_school` VALUES (824, '苏州职业大学', '4132011054', 1);
INSERT INTO `xy_school` VALUES (825, '沙洲职业工学院', '4132011288', 1);
INSERT INTO `xy_school` VALUES (826, '扬州市职业大学', '4132011462', 1);
INSERT INTO `xy_school` VALUES (827, '连云港师范高等专科学校', '4132011585', 1);
INSERT INTO `xy_school` VALUES (828, '江苏经贸职业技术学院', '4132012047', 1);
INSERT INTO `xy_school` VALUES (829, '九州职业技术学院', '4132012054', 1);
INSERT INTO `xy_school` VALUES (830, '硅湖职业技术学院', '4132012078', 1);
INSERT INTO `xy_school` VALUES (831, '泰州职业技术学院', '4132012106', 1);
INSERT INTO `xy_school` VALUES (832, '常州信息职业技术学院', '4132012317', 1);
INSERT INTO `xy_school` VALUES (833, '江苏联合职业技术学院', '4132012678', 1);
INSERT INTO `xy_school` VALUES (834, '江苏海事职业技术学院', '4132012679', 1);
INSERT INTO `xy_school` VALUES (835, '应天职业技术学院', '4132012680', 1);
INSERT INTO `xy_school` VALUES (836, '无锡科技职业学院', '4132012681', 1);
INSERT INTO `xy_school` VALUES (837, '江苏医药职业学院', '4132012682', 1);
INSERT INTO `xy_school` VALUES (838, '扬州环境资源职业技术学院', '4132012683', 1);
INSERT INTO `xy_school` VALUES (839, '南通科技职业学院', '4132012684', 1);
INSERT INTO `xy_school` VALUES (840, '苏州经贸职业技术学院', '4132012685', 1);
INSERT INTO `xy_school` VALUES (841, '苏州工业职业技术学院', '4132012686', 1);
INSERT INTO `xy_school` VALUES (842, '苏州托普信息职业技术学院', '4132012687', 1);
INSERT INTO `xy_school` VALUES (843, '苏州卫生职业技术学院', '4132012688', 1);
INSERT INTO `xy_school` VALUES (844, '无锡商业职业技术学院', '4132012702', 1);
INSERT INTO `xy_school` VALUES (845, '江苏航运职业技术学院', '4132012703', 1);
INSERT INTO `xy_school` VALUES (846, '南京交通职业技术学院', '4132012804', 1);
INSERT INTO `xy_school` VALUES (847, '江苏电子信息职业学院', '4132012805', 1);
INSERT INTO `xy_school` VALUES (848, '江苏农牧科技职业学院', '4132012806', 1);
INSERT INTO `xy_school` VALUES (849, '常州纺织服装职业技术学院', '4132012807', 1);
INSERT INTO `xy_school` VALUES (850, '苏州农业职业技术学院', '4132012808', 1);
INSERT INTO `xy_school` VALUES (851, '苏州工业园区职业技术学院', '4132012809', 1);
INSERT INTO `xy_school` VALUES (852, '太湖创意职业技术学院', '4132012918', 1);
INSERT INTO `xy_school` VALUES (853, '炎黄职业技术学院', '4132012919', 1);
INSERT INTO `xy_school` VALUES (854, '南京科技职业学院', '4132012920', 1);
INSERT INTO `xy_school` VALUES (855, '正德职业技术学院', '4132012921', 1);
INSERT INTO `xy_school` VALUES (856, '钟山职业技术学院', '4132012922', 1);
INSERT INTO `xy_school` VALUES (857, '无锡南洋职业技术学院', '4132012923', 1);
INSERT INTO `xy_school` VALUES (858, '江南影视艺术职业学院', '4132013017', 1);
INSERT INTO `xy_school` VALUES (859, '金肯职业技术学院', '4132013100', 1);
INSERT INTO `xy_school` VALUES (860, '常州工业职业技术学院', '4132013101', 1);
INSERT INTO `xy_school` VALUES (861, '常州工程职业技术学院', '4132013102', 1);
INSERT INTO `xy_school` VALUES (862, '江苏农林职业技术学院', '4132013103', 1);
INSERT INTO `xy_school` VALUES (863, '江苏食品药品职业技术学院', '4132013104', 1);
INSERT INTO `xy_school` VALUES (864, '建东职业技术学院', '4132013105', 1);
INSERT INTO `xy_school` VALUES (865, '南京铁道职业技术学院', '4132013106', 1);
INSERT INTO `xy_school` VALUES (866, '徐州工业职业技术学院', '4132013107', 1);
INSERT INTO `xy_school` VALUES (867, '江苏信息职业技术学院', '4132013108', 1);
INSERT INTO `xy_school` VALUES (868, '宿迁职业技术学院', '4132013110', 1);
INSERT INTO `xy_school` VALUES (869, '南京信息职业技术学院', '4132013112', 1);
INSERT INTO `xy_school` VALUES (870, '江海职业技术学院', '4132013113', 1);
INSERT INTO `xy_school` VALUES (871, '常州机电职业技术学院', '4132013114', 1);
INSERT INTO `xy_school` VALUES (872, '江阴职业技术学院', '4132013137', 1);
INSERT INTO `xy_school` VALUES (873, '无锡城市职业技术学院', '4132013748', 1);
INSERT INTO `xy_school` VALUES (874, '无锡工艺职业技术学院', '4132013749', 1);
INSERT INTO `xy_school` VALUES (875, '金山职业技术学院', '4132013750', 1);
INSERT INTO `xy_school` VALUES (876, '苏州健雄职业技术学院', '4132013751', 1);
INSERT INTO `xy_school` VALUES (877, '盐城工业职业技术学院', '4132013752', 1);
INSERT INTO `xy_school` VALUES (878, '江苏财经职业技术学院', '4132013753', 1);
INSERT INTO `xy_school` VALUES (879, '扬州工业职业技术学院', '4132013754', 1);
INSERT INTO `xy_school` VALUES (880, '苏州百年职业学院', '4132013962', 1);
INSERT INTO `xy_school` VALUES (881, '昆山登云科技职业学院', '4132013963', 1);
INSERT INTO `xy_school` VALUES (882, '南京视觉艺术职业学院', '4132013964', 1);
INSERT INTO `xy_school` VALUES (883, '江苏城市职业学院', '4132014000', 1);
INSERT INTO `xy_school` VALUES (884, '南京城市职业学院', '4132014001', 1);
INSERT INTO `xy_school` VALUES (885, '南京机电职业技术学院', '4132014056', 1);
INSERT INTO `xy_school` VALUES (886, '苏州高博软件技术职业学院', '4132014163', 1);
INSERT INTO `xy_school` VALUES (887, '南京旅游职业学院', '4132014180', 1);
INSERT INTO `xy_school` VALUES (888, '江苏卫生健康职业学院', '4132014255', 1);
INSERT INTO `xy_school` VALUES (889, '苏州信息职业技术学院', '4132014256', 1);
INSERT INTO `xy_school` VALUES (890, '宿迁泽达职业技术学院', '4132014293', 1);
INSERT INTO `xy_school` VALUES (891, '苏州工业园区服务外包职业学院', '4132014295', 1);
INSERT INTO `xy_school` VALUES (892, '徐州幼儿师范高等专科学校', '4132014329', 1);
INSERT INTO `xy_school` VALUES (893, '徐州生物工程职业技术学院', '4132014401', 1);
INSERT INTO `xy_school` VALUES (894, '江苏商贸职业学院', '4132014475', 1);
INSERT INTO `xy_school` VALUES (895, '南通师范高等专科学校', '4132014493', 1);
INSERT INTO `xy_school` VALUES (896, '扬州中瑞酒店职业学院', '4132014528', 1);
INSERT INTO `xy_school` VALUES (897, '江苏护理职业学院', '4132014541', 1);
INSERT INTO `xy_school` VALUES (898, '江苏财会职业学院', '4132014542', 1);
INSERT INTO `xy_school` VALUES (899, '江苏城乡建设职业学院', '4132014543', 1);
INSERT INTO `xy_school` VALUES (900, '江苏航空职业技术学院', '4132014568', 1);
INSERT INTO `xy_school` VALUES (901, '江苏安全技术职业学院', '4132014589', 1);
INSERT INTO `xy_school` VALUES (902, '江苏旅游职业学院', '4132014604', 1);
INSERT INTO `xy_school` VALUES (903, '浙江大学', '4133010335', 1);
INSERT INTO `xy_school` VALUES (904, '杭州电子科技大学', '4133010336', 1);
INSERT INTO `xy_school` VALUES (905, '浙江工业大学', '4133010337', 1);
INSERT INTO `xy_school` VALUES (906, '浙江理工大学', '4133010338', 1);
INSERT INTO `xy_school` VALUES (907, '浙江海洋大学', '4133010340', 1);
INSERT INTO `xy_school` VALUES (908, '浙江农林大学', '4133010341', 1);
INSERT INTO `xy_school` VALUES (909, '温州医科大学', '4133010343', 1);
INSERT INTO `xy_school` VALUES (910, '浙江中医药大学', '4133010344', 1);
INSERT INTO `xy_school` VALUES (911, '浙江师范大学', '4133010345', 1);
INSERT INTO `xy_school` VALUES (912, '杭州师范大学', '4133010346', 1);
INSERT INTO `xy_school` VALUES (913, '湖州师范学院', '4133010347', 1);
INSERT INTO `xy_school` VALUES (914, '绍兴文理学院', '4133010349', 1);
INSERT INTO `xy_school` VALUES (915, '台州学院', '4133010350', 1);
INSERT INTO `xy_school` VALUES (916, '温州大学', '4133010351', 1);
INSERT INTO `xy_school` VALUES (917, '丽水学院', '4133010352', 1);
INSERT INTO `xy_school` VALUES (918, '浙江工商大学', '4133010353', 1);
INSERT INTO `xy_school` VALUES (919, '嘉兴学院', '4133010354', 1);
INSERT INTO `xy_school` VALUES (920, '中国美术学院', '4133010355', 1);
INSERT INTO `xy_school` VALUES (921, '中国计量大学', '4133010356', 1);
INSERT INTO `xy_school` VALUES (922, '浙江万里学院', '4133010876', 1);
INSERT INTO `xy_school` VALUES (923, '浙江科技学院', '4133011057', 1);
INSERT INTO `xy_school` VALUES (924, '宁波工程学院', '4133011058', 1);
INSERT INTO `xy_school` VALUES (925, '浙江水利水电学院', '4133011481', 1);
INSERT INTO `xy_school` VALUES (926, '浙江财经大学', '4133011482', 1);
INSERT INTO `xy_school` VALUES (927, '浙江警察学院', '4133011483', 1);
INSERT INTO `xy_school` VALUES (928, '衢州学院', '4133011488', 1);
INSERT INTO `xy_school` VALUES (929, '宁波大学', '4133011646', 1);
INSERT INTO `xy_school` VALUES (930, '浙江传媒学院', '4133011647', 1);
INSERT INTO `xy_school` VALUES (931, '浙江树人学院', '4133011842', 1);
INSERT INTO `xy_school` VALUES (932, '浙江越秀外国语学院', '4133012792', 1);
INSERT INTO `xy_school` VALUES (933, '宁波财经学院', '4133013001', 1);
INSERT INTO `xy_school` VALUES (934, '浙大城市学院', '4133013021', 1);
INSERT INTO `xy_school` VALUES (935, '浙大宁波理工学院', '4133013022', 1);
INSERT INTO `xy_school` VALUES (936, '杭州医学院', '4133013023', 1);
INSERT INTO `xy_school` VALUES (937, '浙江广厦建设职业技术大学', '4133013029', 1);
INSERT INTO `xy_school` VALUES (938, '浙江工业大学之江学院', '4133013275', 1);
INSERT INTO `xy_school` VALUES (939, '浙江师范大学行知学院', '4133013276', 1);
INSERT INTO `xy_school` VALUES (940, '宁波大学科学技术学院', '4133013277', 1);
INSERT INTO `xy_school` VALUES (941, '杭州电子科技大学信息工程学院', '4133013279', 1);
INSERT INTO `xy_school` VALUES (942, '浙江理工大学科技与艺术学院', '4133013280', 1);
INSERT INTO `xy_school` VALUES (943, '浙江海洋大学东海科学技术学院', '4133013282', 1);
INSERT INTO `xy_school` VALUES (944, '浙江农林大学暨阳学院', '4133013283', 1);
INSERT INTO `xy_school` VALUES (945, '温州医科大学仁济学院', '4133013284', 1);
INSERT INTO `xy_school` VALUES (946, '浙江中医药大学滨江学院', '4133013285', 1);
INSERT INTO `xy_school` VALUES (947, '杭州师范大学钱江学院', '4133013286', 1);
INSERT INTO `xy_school` VALUES (948, '湖州师范学院求真学院', '4133013287', 1);
INSERT INTO `xy_school` VALUES (949, '绍兴文理学院元培学院', '4133013288', 1);
INSERT INTO `xy_school` VALUES (950, '温州大学瓯江学院', '4133013289', 1);
INSERT INTO `xy_school` VALUES (951, '浙江工商大学杭州商学院', '4133013290', 1);
INSERT INTO `xy_school` VALUES (952, '嘉兴学院南湖学院', '4133013291', 1);
INSERT INTO `xy_school` VALUES (953, '中国计量大学现代科技学院', '4133013292', 1);
INSERT INTO `xy_school` VALUES (954, '浙江财经大学东方学院', '4133013294', 1);
INSERT INTO `xy_school` VALUES (955, '温州商学院', '4133013637', 1);
INSERT INTO `xy_school` VALUES (956, '同济大学浙江学院', '4133014206', 1);
INSERT INTO `xy_school` VALUES (957, '上海财经大学浙江学院', '4133014207', 1);
INSERT INTO `xy_school` VALUES (958, '浙江外国语学院', '4133014275', 1);
INSERT INTO `xy_school` VALUES (959, '浙江音乐学院', '4133014535', 1);
INSERT INTO `xy_school` VALUES (960, '西湖大学', '4133014626', 1);
INSERT INTO `xy_school` VALUES (961, '宁波诺丁汉大学', '4133016301', 1);
INSERT INTO `xy_school` VALUES (962, '温州肯恩大学', '4133016405', 1);
INSERT INTO `xy_school` VALUES (963, '宁波职业技术学院', '4133010863', 1);
INSERT INTO `xy_school` VALUES (964, '温州职业技术学院', '4133010864', 1);
INSERT INTO `xy_school` VALUES (965, '浙江交通职业技术学院', '4133012036', 1);
INSERT INTO `xy_school` VALUES (966, '金华职业技术学院', '4133012061', 1);
INSERT INTO `xy_school` VALUES (967, '宁波城市职业技术学院', '4133012645', 1);
INSERT INTO `xy_school` VALUES (968, '浙江电力职业技术学院', '4133012646', 1);
INSERT INTO `xy_school` VALUES (969, '浙江同济科技职业学院', '4133012647', 1);
INSERT INTO `xy_school` VALUES (970, '浙江工商职业技术学院', '4133012789', 1);
INSERT INTO `xy_school` VALUES (971, '台州职业技术学院', '4133012790', 1);
INSERT INTO `xy_school` VALUES (972, '浙江工贸职业技术学院', '4133012791', 1);
INSERT INTO `xy_school` VALUES (973, '浙江医药高等专科学校', '4133012860', 1);
INSERT INTO `xy_school` VALUES (974, '浙江机电职业技术学院', '4133012861', 1);
INSERT INTO `xy_school` VALUES (975, '浙江建设职业技术学院', '4133012862', 1);
INSERT INTO `xy_school` VALUES (976, '浙江艺术职业学院', '4133012863', 1);
INSERT INTO `xy_school` VALUES (977, '浙江经贸职业技术学院', '4133012864', 1);
INSERT INTO `xy_school` VALUES (978, '浙江商业职业技术学院', '4133012865', 1);
INSERT INTO `xy_school` VALUES (979, '浙江经济职业技术学院', '4133012866', 1);
INSERT INTO `xy_school` VALUES (980, '浙江旅游职业学院', '4133012867', 1);
INSERT INTO `xy_school` VALUES (981, '浙江育英职业技术学院', '4133012868', 1);
INSERT INTO `xy_school` VALUES (982, '浙江警官职业学院', '4133012869', 1);
INSERT INTO `xy_school` VALUES (983, '浙江金融职业学院', '4133012870', 1);
INSERT INTO `xy_school` VALUES (984, '浙江工业职业技术学院', '4133012871', 1);
INSERT INTO `xy_school` VALUES (985, '杭州职业技术学院', '4133012872', 1);
INSERT INTO `xy_school` VALUES (986, '嘉兴职业技术学院', '4133012874', 1);
INSERT INTO `xy_school` VALUES (987, '湖州职业技术学院', '4133012875', 1);
INSERT INTO `xy_school` VALUES (988, '绍兴职业技术学院', '4133012876', 1);
INSERT INTO `xy_school` VALUES (989, '衢州职业技术学院', '4133012877', 1);
INSERT INTO `xy_school` VALUES (990, '丽水职业技术学院', '4133012878', 1);
INSERT INTO `xy_school` VALUES (991, '浙江东方职业技术学院', '4133013002', 1);
INSERT INTO `xy_school` VALUES (992, '义乌工商职业技术学院', '4133013003', 1);
INSERT INTO `xy_school` VALUES (993, '浙江纺织服装职业技术学院', '4133013025', 1);
INSERT INTO `xy_school` VALUES (994, '杭州科技职业技术学院', '4133013026', 1);
INSERT INTO `xy_school` VALUES (995, '浙江长征职业技术学院', '4133013027', 1);
INSERT INTO `xy_school` VALUES (996, '嘉兴南洋职业技术学院', '4133013028', 1);
INSERT INTO `xy_school` VALUES (997, '杭州万向职业技术学院', '4133013030', 1);
INSERT INTO `xy_school` VALUES (998, '浙江邮电职业技术学院', '4133013688', 1);
INSERT INTO `xy_school` VALUES (999, '宁波卫生职业技术学院', '4133013742', 1);
INSERT INTO `xy_school` VALUES (1000, '台州科技职业学院', '4133013746', 1);
INSERT INTO `xy_school` VALUES (1001, '浙江国际海运职业技术学院', '4133013853', 1);
INSERT INTO `xy_school` VALUES (1002, '浙江体育职业技术学院', '4133013854', 1);
INSERT INTO `xy_school` VALUES (1003, '温州科技职业学院', '4133014088', 1);
INSERT INTO `xy_school` VALUES (1004, '浙江汽车职业技术学院', '4133014089', 1);
INSERT INTO `xy_school` VALUES (1005, '浙江横店影视职业学院', '4133014090', 1);
INSERT INTO `xy_school` VALUES (1006, '浙江农业商贸职业学院', '4133014269', 1);
INSERT INTO `xy_school` VALUES (1007, '浙江特殊教育职业学院', '4133014431', 1);
INSERT INTO `xy_school` VALUES (1008, '浙江安防职业技术学院', '4133014492', 1);
INSERT INTO `xy_school` VALUES (1009, '浙江宇翔职业技术学院', '4133014703', 1);
INSERT INTO `xy_school` VALUES (1010, '浙江舟山群岛新区旅游与健康职业学院', '4133016408', 1);
INSERT INTO `xy_school` VALUES (1011, '宁波幼儿师范高等专科学校', '4233050559', 1);
INSERT INTO `xy_school` VALUES (1012, '安徽大学', '4134010357', 1);
INSERT INTO `xy_school` VALUES (1013, '中国科学技术大学', '4134010358', 1);
INSERT INTO `xy_school` VALUES (1014, '合肥工业大学', '4134010359', 1);
INSERT INTO `xy_school` VALUES (1015, '安徽工业大学', '4134010360', 1);
INSERT INTO `xy_school` VALUES (1016, '安徽理工大学', '4134010361', 1);
INSERT INTO `xy_school` VALUES (1017, '安徽工程大学', '4134010363', 1);
INSERT INTO `xy_school` VALUES (1018, '安徽农业大学', '4134010364', 1);
INSERT INTO `xy_school` VALUES (1019, '安徽医科大学', '4134010366', 1);
INSERT INTO `xy_school` VALUES (1020, '蚌埠医学院', '4134010367', 1);
INSERT INTO `xy_school` VALUES (1021, '皖南医学院', '4134010368', 1);
INSERT INTO `xy_school` VALUES (1022, '安徽中医药大学', '4134010369', 1);
INSERT INTO `xy_school` VALUES (1023, '安徽师范大学', '4134010370', 1);
INSERT INTO `xy_school` VALUES (1024, '阜阳师范大学', '4134010371', 1);
INSERT INTO `xy_school` VALUES (1025, '安庆师范大学', '4134010372', 1);
INSERT INTO `xy_school` VALUES (1026, '淮北师范大学', '4134010373', 1);
INSERT INTO `xy_school` VALUES (1027, '黄山学院', '4134010375', 1);
INSERT INTO `xy_school` VALUES (1028, '皖西学院', '4134010376', 1);
INSERT INTO `xy_school` VALUES (1029, '滁州学院', '4134010377', 1);
INSERT INTO `xy_school` VALUES (1030, '安徽财经大学', '4134010378', 1);
INSERT INTO `xy_school` VALUES (1031, '宿州学院', '4134010379', 1);
INSERT INTO `xy_school` VALUES (1032, '巢湖学院', '4134010380', 1);
INSERT INTO `xy_school` VALUES (1033, '淮南师范学院', '4134010381', 1);
INSERT INTO `xy_school` VALUES (1034, '铜陵学院', '4134010383', 1);
INSERT INTO `xy_school` VALUES (1035, '安徽建筑大学', '4134010878', 1);
INSERT INTO `xy_school` VALUES (1036, '安徽科技学院', '4134010879', 1);
INSERT INTO `xy_school` VALUES (1037, '安徽三联学院', '4134010959', 1);
INSERT INTO `xy_school` VALUES (1038, '合肥学院', '4134011059', 1);
INSERT INTO `xy_school` VALUES (1039, '蚌埠学院', '4134011305', 1);
INSERT INTO `xy_school` VALUES (1040, '池州学院', '4134011306', 1);
INSERT INTO `xy_school` VALUES (1041, '安徽新华学院', '4134012216', 1);
INSERT INTO `xy_school` VALUES (1042, '安徽文达信息工程学院', '4134012810', 1);
INSERT INTO `xy_school` VALUES (1043, '亳州学院', '4134012926', 1);
INSERT INTO `xy_school` VALUES (1044, '安徽外国语学院', '4134013065', 1);
INSERT INTO `xy_school` VALUES (1045, '蚌埠工商学院', '4134013611', 1);
INSERT INTO `xy_school` VALUES (1046, '安徽大学江淮学院', '4134013612', 1);
INSERT INTO `xy_school` VALUES (1047, '安徽信息工程学院', '4134013613', 1);
INSERT INTO `xy_school` VALUES (1048, '马鞍山学院', '4134013614', 1);
INSERT INTO `xy_school` VALUES (1049, '安徽建筑大学城市建设学院', '4134013615', 1);
INSERT INTO `xy_school` VALUES (1050, '安徽农业大学经济技术学院', '4134013616', 1);
INSERT INTO `xy_school` VALUES (1051, '安徽师范大学皖江学院', '4134013617', 1);
INSERT INTO `xy_school` VALUES (1052, '安徽医科大学临床医学院', '4134013618', 1);
INSERT INTO `xy_school` VALUES (1053, '阜阳师范大学信息工程学院', '4134013619', 1);
INSERT INTO `xy_school` VALUES (1054, '淮北师范大学信息学院', '4134013620', 1);
INSERT INTO `xy_school` VALUES (1055, '合肥师范学院', '4134014098', 1);
INSERT INTO `xy_school` VALUES (1056, '皖江工学院', '4134014203', 1);
INSERT INTO `xy_school` VALUES (1057, '安徽艺术学院', '4134014682', 1);
INSERT INTO `xy_school` VALUES (1058, '安徽职业技术学院', '4134010869', 1);
INSERT INTO `xy_school` VALUES (1059, '淮北职业技术学院', '4134010963', 1);
INSERT INTO `xy_school` VALUES (1060, '芜湖职业技术学院', '4134011061', 1);
INSERT INTO `xy_school` VALUES (1061, '淮南联合大学', '4134011308', 1);
INSERT INTO `xy_school` VALUES (1062, '安徽商贸职业技术学院', '4134012072', 1);
INSERT INTO `xy_school` VALUES (1063, '安徽水利水电职业技术学院', '4134012073', 1);
INSERT INTO `xy_school` VALUES (1064, '阜阳职业技术学院', '4134012074', 1);
INSERT INTO `xy_school` VALUES (1065, '铜陵职业技术学院', '4134012217', 1);
INSERT INTO `xy_school` VALUES (1066, '民办万博科技职业学院', '4134012218', 1);
INSERT INTO `xy_school` VALUES (1067, '安徽警官职业学院', '4134012219', 1);
INSERT INTO `xy_school` VALUES (1068, '淮南职业技术学院', '4134012220', 1);
INSERT INTO `xy_school` VALUES (1069, '安徽工业经济职业技术学院', '4134012334', 1);
INSERT INTO `xy_school` VALUES (1070, '合肥通用职业技术学院', '4134012410', 1);
INSERT INTO `xy_school` VALUES (1071, '安徽工贸职业技术学院', '4134012811', 1);
INSERT INTO `xy_school` VALUES (1072, '宿州职业技术学院', '4134012812', 1);
INSERT INTO `xy_school` VALUES (1073, '六安职业技术学院', '4134012813', 1);
INSERT INTO `xy_school` VALUES (1074, '安徽电子信息职业技术学院', '4134012814', 1);
INSERT INTO `xy_school` VALUES (1075, '民办合肥经济技术职业学院', '4134012815', 1);
INSERT INTO `xy_school` VALUES (1076, '安徽交通职业技术学院', '4134012816', 1);
INSERT INTO `xy_school` VALUES (1077, '安徽体育运动职业技术学院', '4134012817', 1);
INSERT INTO `xy_school` VALUES (1078, '安徽中医药高等专科学校', '4134012924', 1);
INSERT INTO `xy_school` VALUES (1079, '安徽医学高等专科学校', '4134012925', 1);
INSERT INTO `xy_school` VALUES (1080, '合肥职业技术学院', '4134013058', 1);
INSERT INTO `xy_school` VALUES (1081, '滁州职业技术学院', '4134013059', 1);
INSERT INTO `xy_school` VALUES (1082, '池州职业技术学院', '4134013060', 1);
INSERT INTO `xy_school` VALUES (1083, '宣城职业技术学院', '4134013061', 1);
INSERT INTO `xy_school` VALUES (1084, '安徽广播影视职业技术学院', '4134013062', 1);
INSERT INTO `xy_school` VALUES (1085, '民办合肥滨湖职业技术学院', '4134013064', 1);
INSERT INTO `xy_school` VALUES (1086, '安徽电气工程职业技术学院', '4134013336', 1);
INSERT INTO `xy_school` VALUES (1087, '安徽冶金科技职业学院', '4134013337', 1);
INSERT INTO `xy_school` VALUES (1088, '安徽城市管理职业学院', '4134013338', 1);
INSERT INTO `xy_school` VALUES (1089, '安徽机电职业技术学院', '4134013339', 1);
INSERT INTO `xy_school` VALUES (1090, '安徽工商职业学院', '4134013340', 1);
INSERT INTO `xy_school` VALUES (1091, '安徽中澳科技职业学院', '4134013341', 1);
INSERT INTO `xy_school` VALUES (1092, '阜阳科技职业学院', '4134013342', 1);
INSERT INTO `xy_school` VALUES (1093, '亳州职业技术学院', '4134013343', 1);
INSERT INTO `xy_school` VALUES (1094, '安徽国防科技职业学院', '4134013344', 1);
INSERT INTO `xy_school` VALUES (1095, '安庆职业技术学院', '4134013345', 1);
INSERT INTO `xy_school` VALUES (1096, '安徽艺术职业学院', '4134013346', 1);
INSERT INTO `xy_school` VALUES (1097, '马鞍山师范高等专科学校', '4134013760', 1);
INSERT INTO `xy_school` VALUES (1098, '安徽财贸职业学院', '4134013845', 1);
INSERT INTO `xy_school` VALUES (1099, '安徽国际商务职业学院', '4134013846', 1);
INSERT INTO `xy_school` VALUES (1100, '安徽公安职业学院', '4134013847', 1);
INSERT INTO `xy_school` VALUES (1101, '安徽林业职业技术学院', '4134013848', 1);
INSERT INTO `xy_school` VALUES (1102, '安徽审计职业学院', '4134013849', 1);
INSERT INTO `xy_school` VALUES (1103, '安徽新闻出版职业技术学院', '4134013850', 1);
INSERT INTO `xy_school` VALUES (1104, '安徽邮电职业技术学院', '4134013851', 1);
INSERT INTO `xy_school` VALUES (1105, '安徽工业职业技术学院', '4134013852', 1);
INSERT INTO `xy_school` VALUES (1106, '民办合肥财经职业学院', '4134014058', 1);
INSERT INTO `xy_school` VALUES (1107, '安庆医药高等专科学校', '4134014096', 1);
INSERT INTO `xy_school` VALUES (1108, '安徽涉外经济职业学院', '4134014132', 1);
INSERT INTO `xy_school` VALUES (1109, '安徽绿海商务职业学院', '4134014133', 1);
INSERT INTO `xy_school` VALUES (1110, '合肥共达职业技术学院', '4134014135', 1);
INSERT INTO `xy_school` VALUES (1111, '蚌埠经济技术职业学院', '4134014137', 1);
INSERT INTO `xy_school` VALUES (1112, '民办安徽旅游职业学院', '4134014165', 1);
INSERT INTO `xy_school` VALUES (1113, '徽商职业学院', '4134014191', 1);
INSERT INTO `xy_school` VALUES (1114, '马鞍山职业技术学院', '4134014192', 1);
INSERT INTO `xy_school` VALUES (1115, '安徽现代信息工程职业学院', '4134014210', 1);
INSERT INTO `xy_school` VALUES (1116, '安徽矿业职业技术学院', '4134014229', 1);
INSERT INTO `xy_school` VALUES (1117, '合肥信息技术职业学院', '4134014230', 1);
INSERT INTO `xy_school` VALUES (1118, '桐城师范高等专科学校', '4134014273', 1);
INSERT INTO `xy_school` VALUES (1119, '黄山职业技术学院', '4134014296', 1);
INSERT INTO `xy_school` VALUES (1120, '滁州城市职业学院', '4134014297', 1);
INSERT INTO `xy_school` VALUES (1121, '安徽汽车职业技术学院', '4134014298', 1);
INSERT INTO `xy_school` VALUES (1122, '皖西卫生职业学院', '4134014299', 1);
INSERT INTO `xy_school` VALUES (1123, '合肥幼儿师范高等专科学校', '4134014330', 1);
INSERT INTO `xy_school` VALUES (1124, '安徽扬子职业技术学院', '4134014342', 1);
INSERT INTO `xy_school` VALUES (1125, '安徽黄梅戏艺术职业学院', '4134014378', 1);
INSERT INTO `xy_school` VALUES (1126, '安徽粮食工程职业学院', '4134014418', 1);
INSERT INTO `xy_school` VALUES (1127, '安徽卫生健康职业学院', '4134014419', 1);
INSERT INTO `xy_school` VALUES (1128, '合肥科技职业学院', '4134014420', 1);
INSERT INTO `xy_school` VALUES (1129, '皖北卫生职业学院', '4134014502', 1);
INSERT INTO `xy_school` VALUES (1130, '阜阳幼儿师范高等专科学校', '4134014536', 1);
INSERT INTO `xy_school` VALUES (1131, '黄山健康职业学院', '4134014704', 1);
INSERT INTO `xy_school` VALUES (1132, '厦门大学', '4135010384', 1);
INSERT INTO `xy_school` VALUES (1133, '华侨大学', '4135010385', 1);
INSERT INTO `xy_school` VALUES (1134, '福州大学', '4135010386', 1);
INSERT INTO `xy_school` VALUES (1135, '福建工程学院', '4135010388', 1);
INSERT INTO `xy_school` VALUES (1136, '福建农林大学', '4135010389', 1);
INSERT INTO `xy_school` VALUES (1137, '集美大学', '4135010390', 1);
INSERT INTO `xy_school` VALUES (1138, '福建医科大学', '4135010392', 1);
INSERT INTO `xy_school` VALUES (1139, '福建中医药大学', '4135010393', 1);
INSERT INTO `xy_school` VALUES (1140, '福建师范大学', '4135010394', 1);
INSERT INTO `xy_school` VALUES (1141, '闽江学院', '4135010395', 1);
INSERT INTO `xy_school` VALUES (1142, '武夷学院', '4135010397', 1);
INSERT INTO `xy_school` VALUES (1143, '宁德师范学院', '4135010398', 1);
INSERT INTO `xy_school` VALUES (1144, '泉州师范学院', '4135010399', 1);
INSERT INTO `xy_school` VALUES (1145, '闽南师范大学', '4135010402', 1);
INSERT INTO `xy_school` VALUES (1146, '厦门理工学院', '4135011062', 1);
INSERT INTO `xy_school` VALUES (1147, '三明学院', '4135011311', 1);
INSERT INTO `xy_school` VALUES (1148, '龙岩学院', '4135011312', 1);
INSERT INTO `xy_school` VALUES (1149, '福建商学院', '4135011313', 1);
INSERT INTO `xy_school` VALUES (1150, '福建警察学院', '4135011495', 1);
INSERT INTO `xy_school` VALUES (1151, '莆田学院', '4135011498', 1);
INSERT INTO `xy_school` VALUES (1152, '仰恩大学', '4135011784', 1);
INSERT INTO `xy_school` VALUES (1153, '厦门医学院', '4135012631', 1);
INSERT INTO `xy_school` VALUES (1154, '厦门华厦学院', '4135012709', 1);
INSERT INTO `xy_school` VALUES (1155, '闽南理工学院', '4135012710', 1);
INSERT INTO `xy_school` VALUES (1156, '泉州职业技术大学', '4135012928', 1);
INSERT INTO `xy_school` VALUES (1157, '闽南科技学院', '4135012992', 1);
INSERT INTO `xy_school` VALUES (1158, '福州工商学院', '4135012993', 1);
INSERT INTO `xy_school` VALUES (1159, '厦门工学院', '4135013115', 1);
INSERT INTO `xy_school` VALUES (1160, '阳光学院', '4135013468', 1);
INSERT INTO `xy_school` VALUES (1161, '厦门大学嘉庚学院', '4135013469', 1);
INSERT INTO `xy_school` VALUES (1162, '福州大学至诚学院', '4135013470', 1);
INSERT INTO `xy_school` VALUES (1163, '集美大学诚毅学院', '4135013471', 1);
INSERT INTO `xy_school` VALUES (1164, '福建师范大学协和学院', '4135013472', 1);
INSERT INTO `xy_school` VALUES (1165, '福州外语外贸学院', '4135013762', 1);
INSERT INTO `xy_school` VALUES (1166, '福建江夏学院', '4135013763', 1);
INSERT INTO `xy_school` VALUES (1167, '泉州信息工程学院', '4135013766', 1);
INSERT INTO `xy_school` VALUES (1168, '福州理工学院', '4135013773', 1);
INSERT INTO `xy_school` VALUES (1169, '福建农林大学金山学院', '4135014046', 1);
INSERT INTO `xy_school` VALUES (1170, '福建技术师范学院', '4135014683', 1);
INSERT INTO `xy_school` VALUES (1171, '福建船政交通职业学院', '4135010866', 1);
INSERT INTO `xy_school` VALUES (1172, '漳州职业技术学院', '4135011314', 1);
INSERT INTO `xy_school` VALUES (1173, '闽西职业技术学院', '4135011315', 1);
INSERT INTO `xy_school` VALUES (1174, '黎明职业大学', '4135011317', 1);
INSERT INTO `xy_school` VALUES (1175, '福建华南女子职业学院', '4135011499', 1);
INSERT INTO `xy_school` VALUES (1176, '福州职业技术学院', '4135011502', 1);
INSERT INTO `xy_school` VALUES (1177, '福建林业职业技术学院', '4135012625', 1);
INSERT INTO `xy_school` VALUES (1178, '福建信息职业技术学院', '4135012626', 1);
INSERT INTO `xy_school` VALUES (1179, '福建水利电力职业技术学院', '4135012627', 1);
INSERT INTO `xy_school` VALUES (1180, '福建电力职业技术学院', '4135012628', 1);
INSERT INTO `xy_school` VALUES (1181, '厦门海洋职业技术学院', '4135012629', 1);
INSERT INTO `xy_school` VALUES (1182, '福建农业职业技术学院', '4135012630', 1);
INSERT INTO `xy_school` VALUES (1183, '福建卫生职业技术学院', '4135012633', 1);
INSERT INTO `xy_school` VALUES (1184, '泉州医学高等专科学校', '4135012634', 1);
INSERT INTO `xy_school` VALUES (1185, '福州英华职业学院', '4135012708', 1);
INSERT INTO `xy_school` VALUES (1186, '泉州纺织服装职业学院', '4135012711', 1);
INSERT INTO `xy_school` VALUES (1187, '泉州华光职业学院', '4135012927', 1);
INSERT INTO `xy_school` VALUES (1188, '闽北职业技术学院', '4135013764', 1);
INSERT INTO `xy_school` VALUES (1189, '福州黎明职业技术学院', '4135013765', 1);
INSERT INTO `xy_school` VALUES (1190, '厦门演艺职业学院', '4135013767', 1);
INSERT INTO `xy_school` VALUES (1191, '厦门华天涉外职业技术学院', '4135013768', 1);
INSERT INTO `xy_school` VALUES (1192, '福州科技职业技术学院', '4135013769', 1);
INSERT INTO `xy_school` VALUES (1193, '泉州经贸职业技术学院', '4135013770', 1);
INSERT INTO `xy_school` VALUES (1194, '福建对外经济贸易职业技术学院', '4135013771', 1);
INSERT INTO `xy_school` VALUES (1195, '湄洲湾职业技术学院', '4135013772', 1);
INSERT INTO `xy_school` VALUES (1196, '福建生物工程职业技术学院', '4135013969', 1);
INSERT INTO `xy_school` VALUES (1197, '福建艺术职业学院', '4135013970', 1);
INSERT INTO `xy_school` VALUES (1198, '福建幼儿师范高等专科学校', '4135013972', 1);
INSERT INTO `xy_school` VALUES (1199, '厦门城市职业学院', '4135013973', 1);
INSERT INTO `xy_school` VALUES (1200, '泉州工艺美术职业学院', '4135013975', 1);
INSERT INTO `xy_school` VALUES (1201, '三明医学科技职业学院', '4135013976', 1);
INSERT INTO `xy_school` VALUES (1202, '宁德职业技术学院', '4135013977', 1);
INSERT INTO `xy_school` VALUES (1203, '福州软件职业技术学院', '4135013978', 1);
INSERT INTO `xy_school` VALUES (1204, '厦门兴才职业技术学院', '4135013979', 1);
INSERT INTO `xy_school` VALUES (1205, '厦门软件职业技术学院', '4135014059', 1);
INSERT INTO `xy_school` VALUES (1206, '福建体育职业技术学院', '4135014060', 1);
INSERT INTO `xy_school` VALUES (1207, '漳州城市职业学院', '4135014110', 1);
INSERT INTO `xy_school` VALUES (1208, '厦门南洋职业学院', '4135014111', 1);
INSERT INTO `xy_school` VALUES (1209, '厦门东海职业技术学院', '4135014112', 1);
INSERT INTO `xy_school` VALUES (1210, '漳州科技职业学院', '4135014113', 1);
INSERT INTO `xy_school` VALUES (1211, '漳州理工职业学院', '4135014115', 1);
INSERT INTO `xy_school` VALUES (1212, '武夷山职业学院', '4135014116', 1);
INSERT INTO `xy_school` VALUES (1213, '漳州卫生职业学院', '4135014117', 1);
INSERT INTO `xy_school` VALUES (1214, '泉州海洋职业学院', '4135014231', 1);
INSERT INTO `xy_school` VALUES (1215, '泉州轻工职业学院', '4135014232', 1);
INSERT INTO `xy_school` VALUES (1216, '厦门安防科技职业学院', '4135014257', 1);
INSERT INTO `xy_school` VALUES (1217, '泉州幼儿师范高等专科学校', '4135014331', 1);
INSERT INTO `xy_school` VALUES (1218, '闽江师范高等专科学校', '4135014490', 1);
INSERT INTO `xy_school` VALUES (1219, '泉州工程职业技术学院', '4135014503', 1);
INSERT INTO `xy_school` VALUES (1220, '福州墨尔本理工职业学院', '4135016411', 1);
INSERT INTO `xy_school` VALUES (1221, '南昌大学', '4136010403', 1);
INSERT INTO `xy_school` VALUES (1222, '华东交通大学', '4136010404', 1);
INSERT INTO `xy_school` VALUES (1223, '东华理工大学', '4136010405', 1);
INSERT INTO `xy_school` VALUES (1224, '南昌航空大学', '4136010406', 1);
INSERT INTO `xy_school` VALUES (1225, '江西理工大学', '4136010407', 1);
INSERT INTO `xy_school` VALUES (1226, '景德镇陶瓷大学', '4136010408', 1);
INSERT INTO `xy_school` VALUES (1227, '江西农业大学', '4136010410', 1);
INSERT INTO `xy_school` VALUES (1228, '江西中医药大学', '4136010412', 1);
INSERT INTO `xy_school` VALUES (1229, '赣南医学院', '4136010413', 1);
INSERT INTO `xy_school` VALUES (1230, '江西师范大学', '4136010414', 1);
INSERT INTO `xy_school` VALUES (1231, '上饶师范学院', '4136010416', 1);
INSERT INTO `xy_school` VALUES (1232, '宜春学院', '4136010417', 1);
INSERT INTO `xy_school` VALUES (1233, '赣南师范大学', '4136010418', 1);
INSERT INTO `xy_school` VALUES (1234, '井冈山大学', '4136010419', 1);
INSERT INTO `xy_school` VALUES (1235, '江西财经大学', '4136010421', 1);
INSERT INTO `xy_school` VALUES (1236, '江西科技学院', '4136010846', 1);
INSERT INTO `xy_school` VALUES (1237, '景德镇学院', '4136010894', 1);
INSERT INTO `xy_school` VALUES (1238, '萍乡学院', '4136010895', 1);
INSERT INTO `xy_school` VALUES (1239, '江西科技师范大学', '4136011318', 1);
INSERT INTO `xy_school` VALUES (1240, '南昌工程学院', '4136011319', 1);
INSERT INTO `xy_school` VALUES (1241, '江西警察学院', '4136011504', 1);
INSERT INTO `xy_school` VALUES (1242, '新余学院', '4136011508', 1);
INSERT INTO `xy_school` VALUES (1243, '九江学院', '4136011843', 1);
INSERT INTO `xy_school` VALUES (1244, '江西工程学院', '4136012766', 1);
INSERT INTO `xy_school` VALUES (1245, '南昌理工学院', '4136012795', 1);
INSERT INTO `xy_school` VALUES (1246, '江西应用科技学院', '4136012938', 1);
INSERT INTO `xy_school` VALUES (1247, '江西服装学院', '4136013418', 1);
INSERT INTO `xy_school` VALUES (1248, '南昌职业大学', '4136013420', 1);
INSERT INTO `xy_school` VALUES (1249, '南昌工学院', '4136013421', 1);
INSERT INTO `xy_school` VALUES (1250, '南昌大学科学技术学院', '4136013429', 1);
INSERT INTO `xy_school` VALUES (1251, '南昌大学共青学院', '4136013430', 1);
INSERT INTO `xy_school` VALUES (1252, '华东交通大学理工学院', '4136013431', 1);
INSERT INTO `xy_school` VALUES (1253, '东华理工大学长江学院', '4136013432', 1);
INSERT INTO `xy_school` VALUES (1254, '南昌航空大学科技学院', '4136013433', 1);
INSERT INTO `xy_school` VALUES (1255, '江西理工大学应用科学学院', '4136013434', 1);
INSERT INTO `xy_school` VALUES (1256, '景德镇陶瓷大学科技艺术学院', '4136013435', 1);
INSERT INTO `xy_school` VALUES (1257, '江西农业大学南昌商学院', '4136013436', 1);
INSERT INTO `xy_school` VALUES (1258, '江西中医药大学科技学院', '4136013437', 1);
INSERT INTO `xy_school` VALUES (1259, '江西师范大学科学技术学院', '4136013438', 1);
INSERT INTO `xy_school` VALUES (1260, '赣南师范大学科技学院', '4136013439', 1);
INSERT INTO `xy_school` VALUES (1261, '江西科技师范大学理工学院', '4136013440', 1);
INSERT INTO `xy_school` VALUES (1262, '江西财经大学现代经济管理学院', '4136013441', 1);
INSERT INTO `xy_school` VALUES (1263, '豫章师范学院', '4136013774', 1);
INSERT INTO `xy_school` VALUES (1264, '江西软件职业技术大学', '4136013776', 1);
INSERT INTO `xy_school` VALUES (1265, '南昌师范学院', '4136014437', 1);
INSERT INTO `xy_school` VALUES (1266, '上饶幼儿师范高等专科学校', '3636000312', 1);
INSERT INTO `xy_school` VALUES (1267, '抚州幼儿师范高等专科学校', '3636000519', 1);
INSERT INTO `xy_school` VALUES (1268, '江西工业职业技术学院', '4136010839', 1);
INSERT INTO `xy_school` VALUES (1269, '江西医学高等专科学校', '4136010888', 1);
INSERT INTO `xy_school` VALUES (1270, '九江职业大学', '4136011505', 1);
INSERT INTO `xy_school` VALUES (1271, '九江职业技术学院', '4136011785', 1);
INSERT INTO `xy_school` VALUES (1272, '江西司法警官职业学院', '4136012929', 1);
INSERT INTO `xy_school` VALUES (1273, '江西陶瓷工艺美术职业技术学院', '4136012930', 1);
INSERT INTO `xy_school` VALUES (1274, '江西旅游商贸职业学院', '4136012932', 1);
INSERT INTO `xy_school` VALUES (1275, '江西电力职业技术学院', '4136012933', 1);
INSERT INTO `xy_school` VALUES (1276, '江西环境工程职业学院', '4136012934', 1);
INSERT INTO `xy_school` VALUES (1277, '江西艺术职业学院', '4136012936', 1);
INSERT INTO `xy_school` VALUES (1278, '鹰潭职业技术学院', '4136012937', 1);
INSERT INTO `xy_school` VALUES (1279, '江西信息应用职业技术学院', '4136012939', 1);
INSERT INTO `xy_school` VALUES (1280, '江西交通职业技术学院', '4136012940', 1);
INSERT INTO `xy_school` VALUES (1281, '江西财经职业学院', '4136012941', 1);
INSERT INTO `xy_school` VALUES (1282, '江西应用技术职业学院', '4136012942', 1);
INSERT INTO `xy_school` VALUES (1283, '江西现代职业技术学院', '4136012943', 1);
INSERT INTO `xy_school` VALUES (1284, '江西工业工程职业技术学院', '4136012944', 1);
INSERT INTO `xy_school` VALUES (1285, '江西机电职业技术学院', '4136012976', 1);
INSERT INTO `xy_school` VALUES (1286, '江西科技职业学院', '4136013419', 1);
INSERT INTO `xy_school` VALUES (1287, '江西外语外贸职业学院', '4136013422', 1);
INSERT INTO `xy_school` VALUES (1288, '江西工业贸易职业技术学院', '4136013423', 1);
INSERT INTO `xy_school` VALUES (1289, '宜春职业技术学院', '4136013424', 1);
INSERT INTO `xy_school` VALUES (1290, '江西应用工程职业学院', '4136013425', 1);
INSERT INTO `xy_school` VALUES (1291, '江西生物科技职业学院', '4136013426', 1);
INSERT INTO `xy_school` VALUES (1292, '江西建设职业技术学院', '4136013427', 1);
INSERT INTO `xy_school` VALUES (1293, '抚州职业技术学院', '4136013428', 1);
INSERT INTO `xy_school` VALUES (1294, '江西中医药高等专科学校', '4136013775', 1);
INSERT INTO `xy_school` VALUES (1295, '江西经济管理职业学院', '4136013866', 1);
INSERT INTO `xy_school` VALUES (1296, '江西制造职业技术学院', '4136013867', 1);
INSERT INTO `xy_school` VALUES (1297, '江西工程职业学院', '4136013868', 1);
INSERT INTO `xy_school` VALUES (1298, '江西青年职业学院', '4136013869', 1);
INSERT INTO `xy_school` VALUES (1299, '上饶职业技术学院', '4136013870', 1);
INSERT INTO `xy_school` VALUES (1300, '江西航空职业技术学院', '4136013871', 1);
INSERT INTO `xy_school` VALUES (1301, '江西农业工程职业学院', '4136013872', 1);
INSERT INTO `xy_school` VALUES (1302, '赣西科技职业学院', '4136013873', 1);
INSERT INTO `xy_school` VALUES (1303, '江西卫生职业学院', '4136013965', 1);
INSERT INTO `xy_school` VALUES (1304, '江西新能源科技职业学院', '4136014166', 1);
INSERT INTO `xy_school` VALUES (1305, '江西枫林涉外经贸职业学院', '4136014167', 1);
INSERT INTO `xy_school` VALUES (1306, '江西泰豪动漫职业学院', '4136014168', 1);
INSERT INTO `xy_school` VALUES (1307, '江西冶金职业技术学院', '4136014241', 1);
INSERT INTO `xy_school` VALUES (1308, '江西管理职业学院', '4136014249', 1);
INSERT INTO `xy_school` VALUES (1309, '江西传媒职业学院', '4136014250', 1);
INSERT INTO `xy_school` VALUES (1310, '江西工商职业技术学院', '4136014321', 1);
INSERT INTO `xy_school` VALUES (1311, '景德镇陶瓷职业技术学院', '4136014402', 1);
INSERT INTO `xy_school` VALUES (1312, '共青科技职业学院', '4136014403', 1);
INSERT INTO `xy_school` VALUES (1313, '赣州师范高等专科学校', '4136014465', 1);
INSERT INTO `xy_school` VALUES (1314, '江西水利职业学院', '4136014476', 1);
INSERT INTO `xy_school` VALUES (1315, '宜春幼儿师范高等专科学校', '4136014494', 1);
INSERT INTO `xy_school` VALUES (1316, '吉安职业技术学院', '4136014504', 1);
INSERT INTO `xy_school` VALUES (1317, '江西洪州职业学院', '4136014505', 1);
INSERT INTO `xy_school` VALUES (1318, '江西师范高等专科学校', '4136014537', 1);
INSERT INTO `xy_school` VALUES (1319, '南昌影视传播职业学院', '4136014544', 1);
INSERT INTO `xy_school` VALUES (1320, '赣南卫生健康职业学院', '4136014569', 1);
INSERT INTO `xy_school` VALUES (1321, '萍乡卫生职业学院', '4136014656', 1);
INSERT INTO `xy_school` VALUES (1322, '江西婺源茶业职业学院', '4136014657', 1);
INSERT INTO `xy_school` VALUES (1323, '赣州职业技术学院', '4136014665', 1);
INSERT INTO `xy_school` VALUES (1324, '南昌健康职业技术学院', '4136014705', 1);
INSERT INTO `xy_school` VALUES (1325, '九江理工职业学院', '4136014706', 1);
INSERT INTO `xy_school` VALUES (1326, '山东大学', '4137010422', 1);
INSERT INTO `xy_school` VALUES (1327, '中国海洋大学', '4137010423', 1);
INSERT INTO `xy_school` VALUES (1328, '山东科技大学', '4137010424', 1);
INSERT INTO `xy_school` VALUES (1329, '中国石油大学（华东）', '4137010425', 1);
INSERT INTO `xy_school` VALUES (1330, '青岛科技大学', '4137010426', 1);
INSERT INTO `xy_school` VALUES (1331, '济南大学', '4137010427', 1);
INSERT INTO `xy_school` VALUES (1332, '青岛理工大学', '4137010429', 1);
INSERT INTO `xy_school` VALUES (1333, '山东建筑大学', '4137010430', 1);
INSERT INTO `xy_school` VALUES (1334, '齐鲁工业大学', '4137010431', 1);
INSERT INTO `xy_school` VALUES (1335, '山东理工大学', '4137010433', 1);
INSERT INTO `xy_school` VALUES (1336, '山东农业大学', '4137010434', 1);
INSERT INTO `xy_school` VALUES (1337, '青岛农业大学', '4137010435', 1);
INSERT INTO `xy_school` VALUES (1338, '潍坊医学院', '4137010438', 1);
INSERT INTO `xy_school` VALUES (1339, '山东第一医科大学', '4137010439', 1);
INSERT INTO `xy_school` VALUES (1340, '滨州医学院', '4137010440', 1);
INSERT INTO `xy_school` VALUES (1341, '山东中医药大学', '4137010441', 1);
INSERT INTO `xy_school` VALUES (1342, '济宁医学院', '4137010443', 1);
INSERT INTO `xy_school` VALUES (1343, '山东师范大学', '4137010445', 1);
INSERT INTO `xy_school` VALUES (1344, '曲阜师范大学', '4137010446', 1);
INSERT INTO `xy_school` VALUES (1345, '聊城大学', '4137010447', 1);
INSERT INTO `xy_school` VALUES (1346, '德州学院', '4137010448', 1);
INSERT INTO `xy_school` VALUES (1347, '滨州学院', '4137010449', 1);
INSERT INTO `xy_school` VALUES (1348, '鲁东大学', '4137010451', 1);
INSERT INTO `xy_school` VALUES (1349, '临沂大学', '4137010452', 1);
INSERT INTO `xy_school` VALUES (1350, '泰山学院', '4137010453', 1);
INSERT INTO `xy_school` VALUES (1351, '济宁学院', '4137010454', 1);
INSERT INTO `xy_school` VALUES (1352, '菏泽学院', '4137010455', 1);
INSERT INTO `xy_school` VALUES (1353, '山东财经大学', '4137010456', 1);
INSERT INTO `xy_school` VALUES (1354, '山东体育学院', '4137010457', 1);
INSERT INTO `xy_school` VALUES (1355, '山东艺术学院', '4137010458', 1);
INSERT INTO `xy_school` VALUES (1356, '齐鲁医药学院', '4137010825', 1);
INSERT INTO `xy_school` VALUES (1357, '青岛滨海学院', '4137010868', 1);
INSERT INTO `xy_school` VALUES (1358, '枣庄学院', '4137010904', 1);
INSERT INTO `xy_school` VALUES (1359, '山东工艺美术学院', '4137010908', 1);
INSERT INTO `xy_school` VALUES (1360, '青岛大学', '4137011065', 1);
INSERT INTO `xy_school` VALUES (1361, '烟台大学', '4137011066', 1);
INSERT INTO `xy_school` VALUES (1362, '潍坊学院', '4137011067', 1);
INSERT INTO `xy_school` VALUES (1363, '山东警察学院', '4137011324', 1);
INSERT INTO `xy_school` VALUES (1364, '山东交通学院', '4137011510', 1);
INSERT INTO `xy_school` VALUES (1365, '山东工商学院', '4137011688', 1);
INSERT INTO `xy_school` VALUES (1366, '山东女子学院', '4137012331', 1);
INSERT INTO `xy_school` VALUES (1367, '烟台南山学院', '4137012332', 1);
INSERT INTO `xy_school` VALUES (1368, '潍坊科技学院', '4137012843', 1);
INSERT INTO `xy_school` VALUES (1369, '山东英才学院', '4137013006', 1);
INSERT INTO `xy_school` VALUES (1370, '青岛恒星科技学院', '4137013015', 1);
INSERT INTO `xy_school` VALUES (1371, '青岛黄海学院', '4137013320', 1);
INSERT INTO `xy_school` VALUES (1372, '山东现代学院', '4137013322', 1);
INSERT INTO `xy_school` VALUES (1373, '山东协和学院', '4137013324', 1);
INSERT INTO `xy_school` VALUES (1374, '山东工程职业技术大学', '4137013356', 1);
INSERT INTO `xy_school` VALUES (1375, '烟台大学文经学院', '4137013359', 1);
INSERT INTO `xy_school` VALUES (1376, '聊城大学东昌学院', '4137013373', 1);
INSERT INTO `xy_school` VALUES (1377, '青岛理工大学琴岛学院', '4137013378', 1);
INSERT INTO `xy_school` VALUES (1378, '潍坊理工学院', '4137013379', 1);
INSERT INTO `xy_school` VALUES (1379, '山东财经大学燕山学院', '4137013383', 1);
INSERT INTO `xy_school` VALUES (1380, '中国石油大学胜利学院', '4137013386', 1);
INSERT INTO `xy_school` VALUES (1381, '山东外国语职业技术大学', '4137013387', 1);
INSERT INTO `xy_school` VALUES (1382, '山东科技大学泰山科技学院', '4137013624', 1);
INSERT INTO `xy_school` VALUES (1383, '山东华宇工学院', '4137013857', 1);
INSERT INTO `xy_school` VALUES (1384, '山东外事职业大学', '4137013874', 1);
INSERT INTO `xy_school` VALUES (1385, '青岛工学院', '4137013995', 1);
INSERT INTO `xy_school` VALUES (1386, '青岛农业大学海都学院', '4137013997', 1);
INSERT INTO `xy_school` VALUES (1387, '齐鲁理工学院', '4137013998', 1);
INSERT INTO `xy_school` VALUES (1388, '山东财经大学东方学院', '4137013999', 1);
INSERT INTO `xy_school` VALUES (1389, '济南大学泉城学院', '4137014002', 1);
INSERT INTO `xy_school` VALUES (1390, '山东政法学院', '4137014100', 1);
INSERT INTO `xy_school` VALUES (1391, '齐鲁师范学院', '4137014276', 1);
INSERT INTO `xy_school` VALUES (1392, '山东青年政治学院', '4137014277', 1);
INSERT INTO `xy_school` VALUES (1393, '北京电影学院现代创意媒体学院', '4137014327', 1);
INSERT INTO `xy_school` VALUES (1394, '山东管理学院', '4137014438', 1);
INSERT INTO `xy_school` VALUES (1395, '山东农业工程学院', '4137014439', 1);
INSERT INTO `xy_school` VALUES (1396, '山东医学高等专科学校', '4137010442', 1);
INSERT INTO `xy_school` VALUES (1397, '菏泽医学专科学校', '4137010444', 1);
INSERT INTO `xy_school` VALUES (1398, '山东商业职业技术学院', '4137010832', 1);
INSERT INTO `xy_school` VALUES (1399, '山东电力高等专科学校', '4137011827', 1);
INSERT INTO `xy_school` VALUES (1400, '日照职业技术学院', '4137012062', 1);
INSERT INTO `xy_school` VALUES (1401, '曲阜远东职业技术学院', '4137012070', 1);
INSERT INTO `xy_school` VALUES (1402, '青岛职业技术学院', '4137012324', 1);
INSERT INTO `xy_school` VALUES (1403, '威海职业学院', '4137012326', 1);
INSERT INTO `xy_school` VALUES (1404, '山东职业学院', '4137012328', 1);
INSERT INTO `xy_school` VALUES (1405, '山东劳动职业技术学院', '4137012329', 1);
INSERT INTO `xy_school` VALUES (1406, '莱芜职业技术学院', '4137012330', 1);
INSERT INTO `xy_school` VALUES (1407, '济宁职业技术学院', '4137012335', 1);
INSERT INTO `xy_school` VALUES (1408, '潍坊职业学院', '4137012391', 1);
INSERT INTO `xy_school` VALUES (1409, '烟台职业学院', '4137012396', 1);
INSERT INTO `xy_school` VALUES (1410, '东营职业学院', '4137012440', 1);
INSERT INTO `xy_school` VALUES (1411, '聊城职业技术学院', '4137012441', 1);
INSERT INTO `xy_school` VALUES (1412, '滨州职业学院', '4137012818', 1);
INSERT INTO `xy_school` VALUES (1413, '山东科技职业学院', '4137012819', 1);
INSERT INTO `xy_school` VALUES (1414, '山东服装职业学院', '4137012841', 1);
INSERT INTO `xy_school` VALUES (1415, '德州科技职业学院', '4137012842', 1);
INSERT INTO `xy_school` VALUES (1416, '山东力明科技职业学院', '4137012844', 1);
INSERT INTO `xy_school` VALUES (1417, '山东圣翰财贸职业学院', '4137012945', 1);
INSERT INTO `xy_school` VALUES (1418, '山东水利职业学院', '4137012946', 1);
INSERT INTO `xy_school` VALUES (1419, '山东畜牧兽医职业学院', '4137012947', 1);
INSERT INTO `xy_school` VALUES (1420, '青岛飞洋职业技术学院', '4137013005', 1);
INSERT INTO `xy_school` VALUES (1421, '东营科技职业学院', '4137013007', 1);
INSERT INTO `xy_school` VALUES (1422, '山东交通职业学院', '4137013008', 1);
INSERT INTO `xy_school` VALUES (1423, '淄博职业学院', '4137013009', 1);
INSERT INTO `xy_school` VALUES (1424, '山东外贸职业学院', '4137013010', 1);
INSERT INTO `xy_school` VALUES (1425, '青岛酒店管理职业技术学院', '4137013011', 1);
INSERT INTO `xy_school` VALUES (1426, '山东信息职业技术学院', '4137013012', 1);
INSERT INTO `xy_school` VALUES (1427, '青岛港湾职业技术学院', '4137013014', 1);
INSERT INTO `xy_school` VALUES (1428, '山东胜利职业学院', '4137013316', 1);
INSERT INTO `xy_school` VALUES (1429, '山东经贸职业学院', '4137013317', 1);
INSERT INTO `xy_school` VALUES (1430, '山东工业职业学院', '4137013318', 1);
INSERT INTO `xy_school` VALUES (1431, '山东化工职业学院', '4137013319', 1);
INSERT INTO `xy_school` VALUES (1432, '青岛求实职业技术学院', '4137013321', 1);
INSERT INTO `xy_school` VALUES (1433, '济南职业学院', '4137013323', 1);
INSERT INTO `xy_school` VALUES (1434, '烟台工程职业技术学院', '4137013355', 1);
INSERT INTO `xy_school` VALUES (1435, '潍坊工商职业学院', '4137013388', 1);
INSERT INTO `xy_school` VALUES (1436, '德州职业技术学院', '4137013389', 1);
INSERT INTO `xy_school` VALUES (1437, '枣庄科技职业学院', '4137013390', 1);
INSERT INTO `xy_school` VALUES (1438, '淄博师范高等专科学校', '4137013777', 1);
INSERT INTO `xy_school` VALUES (1439, '山东中医药高等专科学校', '4137013778', 1);
INSERT INTO `xy_school` VALUES (1440, '济南工程职业技术学院', '4137013855', 1);
INSERT INTO `xy_school` VALUES (1441, '山东电子职业技术学院', '4137013856', 1);
INSERT INTO `xy_school` VALUES (1442, '山东旅游职业学院', '4137013858', 1);
INSERT INTO `xy_school` VALUES (1443, '山东铝业职业学院', '4137013859', 1);
INSERT INTO `xy_school` VALUES (1444, '山东杏林科技职业学院', '4137013860', 1);
INSERT INTO `xy_school` VALUES (1445, '泰山职业技术学院', '4137013861', 1);
INSERT INTO `xy_school` VALUES (1446, '山东药品食品职业学院', '4137013966', 1);
INSERT INTO `xy_school` VALUES (1447, '山东商务职业学院', '4137014078', 1);
INSERT INTO `xy_school` VALUES (1448, '山东轻工职业学院', '4137014079', 1);
INSERT INTO `xy_school` VALUES (1449, '山东城市建设职业学院', '4137014080', 1);
INSERT INTO `xy_school` VALUES (1450, '烟台汽车工程职业学院', '4137014081', 1);
INSERT INTO `xy_school` VALUES (1451, '山东司法警官职业学院', '4137014082', 1);
INSERT INTO `xy_school` VALUES (1452, '菏泽家政职业学院', '4137014118', 1);
INSERT INTO `xy_school` VALUES (1453, '山东传媒职业学院', '4137014193', 1);
INSERT INTO `xy_school` VALUES (1454, '临沂职业学院', '4137014195', 1);
INSERT INTO `xy_school` VALUES (1455, '枣庄职业学院', '4137014196', 1);
INSERT INTO `xy_school` VALUES (1456, '山东理工职业学院', '4137014242', 1);
INSERT INTO `xy_school` VALUES (1457, '山东文化产业职业学院', '4137014261', 1);
INSERT INTO `xy_school` VALUES (1458, '青岛远洋船员职业学院', '4137014320', 1);
INSERT INTO `xy_school` VALUES (1459, '济南幼儿师范高等专科学校', '4137014332', 1);
INSERT INTO `xy_school` VALUES (1460, '济南护理职业学院', '4137014343', 1);
INSERT INTO `xy_school` VALUES (1461, '泰山护理职业学院', '4137014345', 1);
INSERT INTO `xy_school` VALUES (1462, '山东海事职业学院', '4137014346', 1);
INSERT INTO `xy_school` VALUES (1463, '潍坊护理职业学院', '4137014347', 1);
INSERT INTO `xy_school` VALUES (1464, '潍坊工程职业学院', '4137014379', 1);
INSERT INTO `xy_school` VALUES (1465, '菏泽职业学院', '4137014477', 1);
INSERT INTO `xy_school` VALUES (1466, '山东艺术设计职业学院', '4137014506', 1);
INSERT INTO `xy_school` VALUES (1467, '威海海洋职业学院', '4137014507', 1);
INSERT INTO `xy_school` VALUES (1468, '山东特殊教育职业学院', '4137014545', 1);
INSERT INTO `xy_school` VALUES (1469, '烟台黄金职业学院', '4137014570', 1);
INSERT INTO `xy_school` VALUES (1470, '日照航海工程职业学院', '4137014605', 1);
INSERT INTO `xy_school` VALUES (1471, '青岛工程职业学院', '4137014666', 1);
INSERT INTO `xy_school` VALUES (1472, '青岛幼儿师范高等专科学校', '4137014688', 1);
INSERT INTO `xy_school` VALUES (1473, '烟台幼儿师范高等专科学校', '4137014689', 1);
INSERT INTO `xy_school` VALUES (1474, '烟台文化旅游职业学院', '4137014707', 1);
INSERT INTO `xy_school` VALUES (1475, '临沂科技职业学院', '4137014708', 1);
INSERT INTO `xy_school` VALUES (1476, '青岛航空科技职业学院', '4137014709', 1);
INSERT INTO `xy_school` VALUES (1477, '潍坊环境工程职业学院', '4137014710', 1);
INSERT INTO `xy_school` VALUES (1478, '华北水利水电大学', '4141010078', 1);
INSERT INTO `xy_school` VALUES (1479, '郑州大学', '4141010459', 1);
INSERT INTO `xy_school` VALUES (1480, '河南理工大学', '4141010460', 1);
INSERT INTO `xy_school` VALUES (1481, '郑州轻工业大学', '4141010462', 1);
INSERT INTO `xy_school` VALUES (1482, '河南工业大学', '4141010463', 1);
INSERT INTO `xy_school` VALUES (1483, '河南科技大学', '4141010464', 1);
INSERT INTO `xy_school` VALUES (1484, '中原工学院', '4141010465', 1);
INSERT INTO `xy_school` VALUES (1485, '河南农业大学', '4141010466', 1);
INSERT INTO `xy_school` VALUES (1486, '河南科技学院', '4141010467', 1);
INSERT INTO `xy_school` VALUES (1487, '河南牧业经济学院', '4141010469', 1);
INSERT INTO `xy_school` VALUES (1488, '河南中医药大学', '4141010471', 1);
INSERT INTO `xy_school` VALUES (1489, '新乡医学院', '4141010472', 1);
INSERT INTO `xy_school` VALUES (1490, '河南大学', '4141010475', 1);
INSERT INTO `xy_school` VALUES (1491, '河南师范大学', '4141010476', 1);
INSERT INTO `xy_school` VALUES (1492, '信阳师范学院', '4141010477', 1);
INSERT INTO `xy_school` VALUES (1493, '周口师范学院', '4141010478', 1);
INSERT INTO `xy_school` VALUES (1494, '安阳师范学院', '4141010479', 1);
INSERT INTO `xy_school` VALUES (1495, '许昌学院', '4141010480', 1);
INSERT INTO `xy_school` VALUES (1496, '南阳师范学院', '4141010481', 1);
INSERT INTO `xy_school` VALUES (1497, '洛阳师范学院', '4141010482', 1);
INSERT INTO `xy_school` VALUES (1498, '商丘师范学院', '4141010483', 1);
INSERT INTO `xy_school` VALUES (1499, '河南财经政法大学', '4141010484', 1);
INSERT INTO `xy_school` VALUES (1500, '郑州航空工业管理学院', '4141010485', 1);
INSERT INTO `xy_school` VALUES (1501, '黄淮学院', '4141010918', 1);
INSERT INTO `xy_school` VALUES (1502, '平顶山学院', '4141010919', 1);
INSERT INTO `xy_school` VALUES (1503, '郑州工程技术学院', '4141011068', 1);
INSERT INTO `xy_school` VALUES (1504, '洛阳理工学院', '4141011070', 1);
INSERT INTO `xy_school` VALUES (1505, '新乡学院', '4141011071', 1);
INSERT INTO `xy_school` VALUES (1506, '信阳农林学院', '4141011326', 1);
INSERT INTO `xy_school` VALUES (1507, '河南工学院', '4141011329', 1);
INSERT INTO `xy_school` VALUES (1508, '安阳工学院', '4141011330', 1);
INSERT INTO `xy_school` VALUES (1509, '河南工程学院', '4141011517', 1);
INSERT INTO `xy_school` VALUES (1510, '河南财政金融学院', '4141011652', 1);
INSERT INTO `xy_school` VALUES (1511, '南阳理工学院', '4141011653', 1);
INSERT INTO `xy_school` VALUES (1512, '河南城建学院', '4141011765', 1);
INSERT INTO `xy_school` VALUES (1513, '河南警察学院', '4141011788', 1);
INSERT INTO `xy_school` VALUES (1514, '黄河科技学院', '4141011834', 1);
INSERT INTO `xy_school` VALUES (1515, '铁道警察学院', '4141012735', 1);
INSERT INTO `xy_school` VALUES (1516, '郑州科技学院', '4141012746', 1);
INSERT INTO `xy_school` VALUES (1517, '郑州工业应用技术学院', '4141012747', 1);
INSERT INTO `xy_school` VALUES (1518, '郑州师范学院', '4141012949', 1);
INSERT INTO `xy_school` VALUES (1519, '郑州财经学院', '4141013497', 1);
INSERT INTO `xy_school` VALUES (1520, '黄河交通学院', '4141013498', 1);
INSERT INTO `xy_school` VALUES (1521, '商丘工学院', '4141013500', 1);
INSERT INTO `xy_school` VALUES (1522, '河南大学民生学院', '4141013501', 1);
INSERT INTO `xy_school` VALUES (1523, '河南师范大学新联学院', '4141013502', 1);
INSERT INTO `xy_school` VALUES (1524, '信阳学院', '4141013503', 1);
INSERT INTO `xy_school` VALUES (1525, '安阳学院', '4141013504', 1);
INSERT INTO `xy_school` VALUES (1526, '新乡医学院三全学院', '4141013505', 1);
INSERT INTO `xy_school` VALUES (1527, '河南科技学院新科学院', '4141013506', 1);
INSERT INTO `xy_school` VALUES (1528, '郑州工商学院', '4141013507', 1);
INSERT INTO `xy_school` VALUES (1529, '郑州经贸学院', '4141013508', 1);
INSERT INTO `xy_school` VALUES (1530, '商丘学院', '4141014003', 1);
INSERT INTO `xy_school` VALUES (1531, '郑州商学院', '4141014040', 1);
INSERT INTO `xy_school` VALUES (1532, '河南科技职业大学', '4141014169', 1);
INSERT INTO `xy_school` VALUES (1533, '郑州升达经贸管理学院', '4141014333', 1);
INSERT INTO `xy_school` VALUES (1534, '郑州西亚斯学院', '4141014654', 1);
INSERT INTO `xy_school` VALUES (1535, '河南职业技术学院', '4141010824', 1);
INSERT INTO `xy_school` VALUES (1536, '漯河职业技术学院', '4141010835', 1);
INSERT INTO `xy_school` VALUES (1537, '三门峡职业技术学院', '4141010842', 1);
INSERT INTO `xy_school` VALUES (1538, '郑州铁路职业技术学院', '4141010843', 1);
INSERT INTO `xy_school` VALUES (1539, '开封大学', '4141011069', 1);
INSERT INTO `xy_school` VALUES (1540, '焦作大学', '4141011522', 1);
INSERT INTO `xy_school` VALUES (1541, '濮阳职业技术学院', '4141011787', 1);
INSERT INTO `xy_school` VALUES (1542, '郑州电力高等专科学校', '4141011828', 1);
INSERT INTO `xy_school` VALUES (1543, '黄河水利职业技术学院', '4141012058', 1);
INSERT INTO `xy_school` VALUES (1544, '许昌职业技术学院', '4141012067', 1);
INSERT INTO `xy_school` VALUES (1545, '河南工业和信息化职业学院', '4141012581', 1);
INSERT INTO `xy_school` VALUES (1546, '河南水利与环境职业学院', '4141012582', 1);
INSERT INTO `xy_school` VALUES (1547, '商丘职业技术学院', '4141012745', 1);
INSERT INTO `xy_school` VALUES (1548, '平顶山工业职业技术学院', '4141012748', 1);
INSERT INTO `xy_school` VALUES (1549, '周口职业技术学院', '4141012750', 1);
INSERT INTO `xy_school` VALUES (1550, '济源职业技术学院', '4141012768', 1);
INSERT INTO `xy_school` VALUES (1551, '河南司法警官职业学院', '4141012781', 1);
INSERT INTO `xy_school` VALUES (1552, '鹤壁职业技术学院', '4141012793', 1);
INSERT INTO `xy_school` VALUES (1553, '河南工业职业技术学院', '4141012794', 1);
INSERT INTO `xy_school` VALUES (1554, '郑州澍青医学高等专科学校', '4141012948', 1);
INSERT INTO `xy_school` VALUES (1555, '焦作师范高等专科学校', '4141012950', 1);
INSERT INTO `xy_school` VALUES (1556, '河南检察职业学院', '4141013499', 1);
INSERT INTO `xy_school` VALUES (1557, '河南质量工程职业学院', '4141013564', 1);
INSERT INTO `xy_school` VALUES (1558, '郑州信息科技职业学院', '4141013565', 1);
INSERT INTO `xy_school` VALUES (1559, '漯河医学高等专科学校', '4141013780', 1);
INSERT INTO `xy_school` VALUES (1560, '南阳医学高等专科学校', '4141013781', 1);
INSERT INTO `xy_school` VALUES (1561, '商丘医学高等专科学校', '4141013782', 1);
INSERT INTO `xy_school` VALUES (1562, '郑州电子信息职业技术学院', '4141013783', 1);
INSERT INTO `xy_school` VALUES (1563, '信阳职业技术学院', '4141013784', 1);
INSERT INTO `xy_school` VALUES (1564, '嵩山少林武术职业学院', '4141013785', 1);
INSERT INTO `xy_school` VALUES (1565, '郑州工业安全职业学院', '4141013786', 1);
INSERT INTO `xy_school` VALUES (1566, '永城职业学院', '4141013787', 1);
INSERT INTO `xy_school` VALUES (1567, '河南经贸职业学院', '4141013788', 1);
INSERT INTO `xy_school` VALUES (1568, '河南交通职业技术学院', '4141013789', 1);
INSERT INTO `xy_school` VALUES (1569, '河南农业职业学院', '4141013790', 1);
INSERT INTO `xy_school` VALUES (1570, '郑州旅游职业学院', '4141013791', 1);
INSERT INTO `xy_school` VALUES (1571, '郑州职业技术学院', '4141013792', 1);
INSERT INTO `xy_school` VALUES (1572, '河南信息统计职业学院', '4141013885', 1);
INSERT INTO `xy_school` VALUES (1573, '河南林业职业学院', '4141013889', 1);
INSERT INTO `xy_school` VALUES (1574, '河南工业贸易职业学院', '4141013936', 1);
INSERT INTO `xy_school` VALUES (1575, '郑州电力职业技术学院', '4141014062', 1);
INSERT INTO `xy_school` VALUES (1576, '河南建筑职业技术学院', '4141014181', 1);
INSERT INTO `xy_school` VALUES (1577, '漯河食品职业学院', '4141014233', 1);
INSERT INTO `xy_school` VALUES (1578, '郑州城市职业学院', '4141014235', 1);
INSERT INTO `xy_school` VALUES (1579, '安阳职业技术学院', '4141014243', 1);
INSERT INTO `xy_school` VALUES (1580, '新乡职业技术学院', '4141014245', 1);
INSERT INTO `xy_school` VALUES (1581, '驻马店职业技术学院', '4141014251', 1);
INSERT INTO `xy_school` VALUES (1582, '焦作工贸职业学院', '4141014300', 1);
INSERT INTO `xy_school` VALUES (1583, '许昌陶瓷职业学院', '4141014301', 1);
INSERT INTO `xy_school` VALUES (1584, '郑州理工职业学院', '4141014302', 1);
INSERT INTO `xy_school` VALUES (1585, '郑州信息工程职业学院', '4141014303', 1);
INSERT INTO `xy_school` VALUES (1586, '长垣烹饪职业技术学院', '4141014305', 1);
INSERT INTO `xy_school` VALUES (1587, '开封文化艺术职业学院', '4141014306', 1);
INSERT INTO `xy_school` VALUES (1588, '河南应用技术职业学院', '4141014307', 1);
INSERT INTO `xy_school` VALUES (1589, '河南艺术职业学院', '4141014308', 1);
INSERT INTO `xy_school` VALUES (1590, '河南机电职业学院', '4141014348', 1);
INSERT INTO `xy_school` VALUES (1591, '河南护理职业学院', '4141014349', 1);
INSERT INTO `xy_school` VALUES (1592, '许昌电气职业学院', '4141014350', 1);
INSERT INTO `xy_school` VALUES (1593, '信阳涉外职业技术学院', '4141014351', 1);
INSERT INTO `xy_school` VALUES (1594, '鹤壁汽车工程职业学院', '4141014352', 1);
INSERT INTO `xy_school` VALUES (1595, '南阳职业学院', '4141014353', 1);
INSERT INTO `xy_school` VALUES (1596, '郑州商贸旅游职业学院', '4141014380', 1);
INSERT INTO `xy_school` VALUES (1597, '河南推拿职业学院', '4141014382', 1);
INSERT INTO `xy_school` VALUES (1598, '洛阳职业技术学院', '4141014383', 1);
INSERT INTO `xy_school` VALUES (1599, '郑州幼儿师范高等专科学校', '4141014391', 1);
INSERT INTO `xy_school` VALUES (1600, '安阳幼儿师范高等专科学校', '4141014392', 1);
INSERT INTO `xy_school` VALUES (1601, '郑州黄河护理职业学院', '4141014405', 1);
INSERT INTO `xy_school` VALUES (1602, '河南医学高等专科学校', '4141014466', 1);
INSERT INTO `xy_school` VALUES (1603, '郑州财税金融职业学院', '4141014478', 1);
INSERT INTO `xy_school` VALUES (1604, '南阳农业职业学院', '4141014479', 1);
INSERT INTO `xy_school` VALUES (1605, '洛阳科技职业学院', '4141014480', 1);
INSERT INTO `xy_school` VALUES (1606, '鹤壁能源化工职业学院', '4141014529', 1);
INSERT INTO `xy_school` VALUES (1607, '平顶山文化艺术职业学院', '4141014530', 1);
INSERT INTO `xy_school` VALUES (1608, '濮阳医学高等专科学校', '4141014597', 1);
INSERT INTO `xy_school` VALUES (1609, '驻马店幼儿师范高等专科学校', '4141014598', 1);
INSERT INTO `xy_school` VALUES (1610, '三门峡社会管理职业学院', '4141014606', 1);
INSERT INTO `xy_school` VALUES (1611, '河南轻工职业学院', '4141014607', 1);
INSERT INTO `xy_school` VALUES (1612, '河南测绘职业学院', '4141014608', 1);
INSERT INTO `xy_school` VALUES (1613, '信阳航空职业学院', '4141014634', 1);
INSERT INTO `xy_school` VALUES (1614, '郑州卫生健康职业学院', '4141014635', 1);
INSERT INTO `xy_school` VALUES (1615, '河南物流职业学院', '4141014636', 1);
INSERT INTO `xy_school` VALUES (1616, '河南地矿职业学院', '4141014637', 1);
INSERT INTO `xy_school` VALUES (1617, '郑州亚欧交通职业学院', '4141014685', 1);
INSERT INTO `xy_school` VALUES (1618, '河南女子职业学院', '4141014711', 1);
INSERT INTO `xy_school` VALUES (1619, '河南对外经济贸易职业学院', '4141014712', 1);
INSERT INTO `xy_school` VALUES (1620, '濮阳石油化工职业技术学院', '4141014713', 1);
INSERT INTO `xy_school` VALUES (1621, '南阳科技职业学院', '4141014714', 1);
INSERT INTO `xy_school` VALUES (1622, '兰考三农职业学院', '4141014715', 1);
INSERT INTO `xy_school` VALUES (1623, '汝州职业技术学院', '4141014716', 1);
INSERT INTO `xy_school` VALUES (1624, '林州建筑职业技术学院', '4141014717', 1);
INSERT INTO `xy_school` VALUES (1625, '郑州电子商务职业学院', '4141014718', 1);
INSERT INTO `xy_school` VALUES (1626, '郑州轨道工程职业学院', '4141014719', 1);
INSERT INTO `xy_school` VALUES (1627, '郑州体育职业学院', '4141014720', 1);
INSERT INTO `xy_school` VALUES (1628, '平顶山职业技术学院', '4241050709', 1);
INSERT INTO `xy_school` VALUES (1629, '武汉大学', '4142010486', 1);
INSERT INTO `xy_school` VALUES (1630, '华中科技大学', '4142010487', 1);
INSERT INTO `xy_school` VALUES (1631, '武汉科技大学', '4142010488', 1);
INSERT INTO `xy_school` VALUES (1632, '长江大学', '4142010489', 1);
INSERT INTO `xy_school` VALUES (1633, '武汉工程大学', '4142010490', 1);
INSERT INTO `xy_school` VALUES (1634, '中国地质大学（武汉）', '4142010491', 1);
INSERT INTO `xy_school` VALUES (1635, '武汉纺织大学', '4142010495', 1);
INSERT INTO `xy_school` VALUES (1636, '武汉轻工大学', '4142010496', 1);
INSERT INTO `xy_school` VALUES (1637, '武汉理工大学', '4142010497', 1);
INSERT INTO `xy_school` VALUES (1638, '湖北工业大学', '4142010500', 1);
INSERT INTO `xy_school` VALUES (1639, '华中农业大学', '4142010504', 1);
INSERT INTO `xy_school` VALUES (1640, '湖北中医药大学', '4142010507', 1);
INSERT INTO `xy_school` VALUES (1641, '华中师范大学', '4142010511', 1);
INSERT INTO `xy_school` VALUES (1642, '湖北大学', '4142010512', 1);
INSERT INTO `xy_school` VALUES (1643, '湖北师范大学', '4142010513', 1);
INSERT INTO `xy_school` VALUES (1644, '黄冈师范学院', '4142010514', 1);
INSERT INTO `xy_school` VALUES (1645, '湖北民族大学', '4142010517', 1);
INSERT INTO `xy_school` VALUES (1646, '汉江师范学院', '4142010518', 1);
INSERT INTO `xy_school` VALUES (1647, '湖北文理学院', '4142010519', 1);
INSERT INTO `xy_school` VALUES (1648, '中南财经政法大学', '4142010520', 1);
INSERT INTO `xy_school` VALUES (1649, '武汉体育学院', '4142010522', 1);
INSERT INTO `xy_school` VALUES (1650, '湖北美术学院', '4142010523', 1);
INSERT INTO `xy_school` VALUES (1651, '中南民族大学', '4142010524', 1);
INSERT INTO `xy_school` VALUES (1652, '湖北汽车工业学院', '4142010525', 1);
INSERT INTO `xy_school` VALUES (1653, '湖北工程学院', '4142010528', 1);
INSERT INTO `xy_school` VALUES (1654, '湖北理工学院', '4142010920', 1);
INSERT INTO `xy_school` VALUES (1655, '湖北科技学院', '4142010927', 1);
INSERT INTO `xy_school` VALUES (1656, '湖北医药学院', '4142010929', 1);
INSERT INTO `xy_school` VALUES (1657, '江汉大学', '4142011072', 1);
INSERT INTO `xy_school` VALUES (1658, '三峡大学', '4142011075', 1);
INSERT INTO `xy_school` VALUES (1659, '湖北警官学院', '4142011332', 1);
INSERT INTO `xy_school` VALUES (1660, '荆楚理工学院', '4142011336', 1);
INSERT INTO `xy_school` VALUES (1661, '武汉音乐学院', '4142011524', 1);
INSERT INTO `xy_school` VALUES (1662, '湖北经济学院', '4142011600', 1);
INSERT INTO `xy_school` VALUES (1663, '武汉商学院', '4142011654', 1);
INSERT INTO `xy_school` VALUES (1664, '武汉东湖学院', '4142011798', 1);
INSERT INTO `xy_school` VALUES (1665, '汉口学院', '4142011800', 1);
INSERT INTO `xy_school` VALUES (1666, '武昌首义学院', '4142012309', 1);
INSERT INTO `xy_school` VALUES (1667, '武昌理工学院', '4142012310', 1);
INSERT INTO `xy_school` VALUES (1668, '武汉生物工程学院', '4142012362', 1);
INSERT INTO `xy_school` VALUES (1669, '武汉晴川学院', '4142013188', 1);
INSERT INTO `xy_school` VALUES (1670, '湖北大学知行学院', '4142013234', 1);
INSERT INTO `xy_school` VALUES (1671, '武汉科技大学城市学院', '4142013235', 1);
INSERT INTO `xy_school` VALUES (1672, '三峡大学科技学院', '4142013236', 1);
INSERT INTO `xy_school` VALUES (1673, '武汉文理学院', '4142013237', 1);
INSERT INTO `xy_school` VALUES (1674, '湖北工业大学工程技术学院', '4142013238', 1);
INSERT INTO `xy_school` VALUES (1675, '武汉工程大学邮电与信息工程学院', '4142013239', 1);
INSERT INTO `xy_school` VALUES (1676, '武汉纺织大学外经贸学院', '4142013240', 1);
INSERT INTO `xy_school` VALUES (1677, '武昌工学院', '4142013241', 1);
INSERT INTO `xy_school` VALUES (1678, '武汉工商学院', '4142013242', 1);
INSERT INTO `xy_school` VALUES (1679, '长江大学工程技术学院', '4142013245', 1);
INSERT INTO `xy_school` VALUES (1680, '长江大学文理学院', '4142013246', 1);
INSERT INTO `xy_school` VALUES (1681, '湖北商贸学院', '4142013247', 1);
INSERT INTO `xy_school` VALUES (1682, '湖北汽车工业学院科技学院', '4142013248', 1);
INSERT INTO `xy_school` VALUES (1683, '湖北医药学院药护学院', '4142013249', 1);
INSERT INTO `xy_school` VALUES (1684, '湖北民族大学科技学院', '4142013250', 1);
INSERT INTO `xy_school` VALUES (1685, '湖北经济学院法商学院', '4142013251', 1);
INSERT INTO `xy_school` VALUES (1686, '武汉体育学院体育科技学院', '4142013253', 1);
INSERT INTO `xy_school` VALUES (1687, '湖北师范大学文理学院', '4142013256', 1);
INSERT INTO `xy_school` VALUES (1688, '湖北文理学院理工学院', '4142013257', 1);
INSERT INTO `xy_school` VALUES (1689, '湖北工程学院新技术学院', '4142013258', 1);
INSERT INTO `xy_school` VALUES (1690, '文华学院', '4142013262', 1);
INSERT INTO `xy_school` VALUES (1691, '武汉学院', '4142013634', 1);
INSERT INTO `xy_school` VALUES (1692, '武汉工程科技学院', '4142013664', 1);
INSERT INTO `xy_school` VALUES (1693, '武汉华夏理工学院', '4142013666', 1);
INSERT INTO `xy_school` VALUES (1694, '武汉传媒学院', '4142013686', 1);
INSERT INTO `xy_school` VALUES (1695, '武汉设计工程学院', '4142014035', 1);
INSERT INTO `xy_school` VALUES (1696, '湖北第二师范学院', '4142014099', 1);
INSERT INTO `xy_school` VALUES (1697, '武汉职业技术学院', '4142010834', 1);
INSERT INTO `xy_school` VALUES (1698, '黄冈职业技术学院', '4142010955', 1);
INSERT INTO `xy_school` VALUES (1699, '长江职业学院', '4142010956', 1);
INSERT INTO `xy_school` VALUES (1700, '荆州理工职业学院', '4142011074', 1);
INSERT INTO `xy_school` VALUES (1701, '湖北工业职业技术学院', '4142011334', 1);
INSERT INTO `xy_school` VALUES (1702, '鄂州职业大学', '4142011335', 1);
INSERT INTO `xy_school` VALUES (1703, '武汉城市职业学院', '4142011796', 1);
INSERT INTO `xy_school` VALUES (1704, '湖北职业技术学院', '4142012051', 1);
INSERT INTO `xy_school` VALUES (1705, '武汉船舶职业技术学院', '4142012052', 1);
INSERT INTO `xy_school` VALUES (1706, '恩施职业技术学院', '4142012347', 1);
INSERT INTO `xy_school` VALUES (1707, '襄阳职业技术学院', '4142012354', 1);
INSERT INTO `xy_school` VALUES (1708, '武汉工贸职业学院', '4142012369', 1);
INSERT INTO `xy_school` VALUES (1709, '荆州职业技术学院', '4142012737', 1);
INSERT INTO `xy_school` VALUES (1710, '武汉工程职业技术学院', '4142012738', 1);
INSERT INTO `xy_school` VALUES (1711, '仙桃职业学院', '4142012740', 1);
INSERT INTO `xy_school` VALUES (1712, '湖北轻工职业技术学院', '4142012744', 1);
INSERT INTO `xy_school` VALUES (1713, '湖北交通职业技术学院', '4142012752', 1);
INSERT INTO `xy_school` VALUES (1714, '湖北中医药高等专科学校', '4142012951', 1);
INSERT INTO `xy_school` VALUES (1715, '武汉航海职业技术学院', '4142012952', 1);
INSERT INTO `xy_school` VALUES (1716, '武汉铁路职业技术学院', '4142012977', 1);
INSERT INTO `xy_school` VALUES (1717, '武汉软件工程职业学院', '4142012978', 1);
INSERT INTO `xy_school` VALUES (1718, '湖北三峡职业技术学院', '4142012979', 1);
INSERT INTO `xy_school` VALUES (1719, '随州职业技术学院', '4142012980', 1);
INSERT INTO `xy_school` VALUES (1720, '武汉电力职业技术学院', '4142012981', 1);
INSERT INTO `xy_school` VALUES (1721, '湖北水利水电职业技术学院', '4142012982', 1);
INSERT INTO `xy_school` VALUES (1722, '湖北城市建设职业技术学院', '4142012983', 1);
INSERT INTO `xy_school` VALUES (1723, '武汉警官职业学院', '4142012984', 1);
INSERT INTO `xy_school` VALUES (1724, '湖北生物科技职业学院', '4142012985', 1);
INSERT INTO `xy_school` VALUES (1725, '湖北开放职业学院', '4142012986', 1);
INSERT INTO `xy_school` VALUES (1726, '武汉科技职业学院', '4142012987', 1);
INSERT INTO `xy_school` VALUES (1727, '武汉外语外事职业学院', '4142012988', 1);
INSERT INTO `xy_school` VALUES (1728, '武汉信息传播职业技术学院', '4142012989', 1);
INSERT INTO `xy_school` VALUES (1729, '武昌职业学院', '4142012990', 1);
INSERT INTO `xy_school` VALUES (1730, '武汉商贸职业学院', '4142012991', 1);
INSERT INTO `xy_school` VALUES (1731, '湖北艺术职业学院', '4142013263', 1);
INSERT INTO `xy_school` VALUES (1732, '武汉交通职业学院', '4142013264', 1);
INSERT INTO `xy_school` VALUES (1733, '咸宁职业技术学院', '4142013265', 1);
INSERT INTO `xy_school` VALUES (1734, '长江工程职业技术学院', '4142013266', 1);
INSERT INTO `xy_school` VALUES (1735, '江汉艺术职业学院', '4142013793', 1);
INSERT INTO `xy_school` VALUES (1736, '武汉民政职业学院', '4142013796', 1);
INSERT INTO `xy_school` VALUES (1737, '鄂东职业技术学院', '4142013797', 1);
INSERT INTO `xy_school` VALUES (1738, '湖北财税职业学院', '4142013798', 1);
INSERT INTO `xy_school` VALUES (1739, '黄冈科技职业学院', '4142013799', 1);
INSERT INTO `xy_school` VALUES (1740, '湖北国土资源职业学院', '4142013800', 1);
INSERT INTO `xy_school` VALUES (1741, '湖北生态工程职业技术学院', '4142013801', 1);
INSERT INTO `xy_school` VALUES (1742, '三峡电力职业学院', '4142014061', 1);
INSERT INTO `xy_school` VALUES (1743, '湖北科技职业学院', '4142014119', 1);
INSERT INTO `xy_school` VALUES (1744, '湖北青年职业学院', '4142014120', 1);
INSERT INTO `xy_school` VALUES (1745, '湖北工程职业学院', '4142014197', 1);
INSERT INTO `xy_school` VALUES (1746, '三峡旅游职业技术学院', '4142014258', 1);
INSERT INTO `xy_school` VALUES (1747, '天门职业学院', '4142014355', 1);
INSERT INTO `xy_school` VALUES (1748, '湖北体育职业学院', '4142014356', 1);
INSERT INTO `xy_school` VALUES (1749, '襄阳汽车职业技术学院', '4142014357', 1);
INSERT INTO `xy_school` VALUES (1750, '湖北幼儿师范高等专科学校', '4142014467', 1);
INSERT INTO `xy_school` VALUES (1751, '湖北铁道运输职业学院', '4142014553', 1);
INSERT INTO `xy_school` VALUES (1752, '武汉海事职业学院', '4142014554', 1);
INSERT INTO `xy_school` VALUES (1753, '长江艺术工程职业学院', '4142014555', 1);
INSERT INTO `xy_school` VALUES (1754, '荆门职业学院', '4142014571', 1);
INSERT INTO `xy_school` VALUES (1755, '武汉铁路桥梁职业学院', '4142014590', 1);
INSERT INTO `xy_school` VALUES (1756, '武汉光谷职业学院', '4142014591', 1);
INSERT INTO `xy_school` VALUES (1757, '湖北健康职业学院', '4142014721', 1);
INSERT INTO `xy_school` VALUES (1758, '湘潭大学', '4143010530', 1);
INSERT INTO `xy_school` VALUES (1759, '吉首大学', '4143010531', 1);
INSERT INTO `xy_school` VALUES (1760, '湖南大学', '4143010532', 1);
INSERT INTO `xy_school` VALUES (1761, '中南大学', '4143010533', 1);
INSERT INTO `xy_school` VALUES (1762, '湖南科技大学', '4143010534', 1);
INSERT INTO `xy_school` VALUES (1763, '长沙理工大学', '4143010536', 1);
INSERT INTO `xy_school` VALUES (1764, '湖南农业大学', '4143010537', 1);
INSERT INTO `xy_school` VALUES (1765, '中南林业科技大学', '4143010538', 1);
INSERT INTO `xy_school` VALUES (1766, '湖南中医药大学', '4143010541', 1);
INSERT INTO `xy_school` VALUES (1767, '湖南师范大学', '4143010542', 1);
INSERT INTO `xy_school` VALUES (1768, '湖南理工学院', '4143010543', 1);
INSERT INTO `xy_school` VALUES (1769, '湘南学院', '4143010545', 1);
INSERT INTO `xy_school` VALUES (1770, '衡阳师范学院', '4143010546', 1);
INSERT INTO `xy_school` VALUES (1771, '邵阳学院', '4143010547', 1);
INSERT INTO `xy_school` VALUES (1772, '怀化学院', '4143010548', 1);
INSERT INTO `xy_school` VALUES (1773, '湖南文理学院', '4143010549', 1);
INSERT INTO `xy_school` VALUES (1774, '湖南科技学院', '4143010551', 1);
INSERT INTO `xy_school` VALUES (1775, '湖南人文科技学院', '4143010553', 1);
INSERT INTO `xy_school` VALUES (1776, '湖南工商大学', '4143010554', 1);
INSERT INTO `xy_school` VALUES (1777, '南华大学', '4143010555', 1);
INSERT INTO `xy_school` VALUES (1778, '长沙医学院', '4143010823', 1);
INSERT INTO `xy_school` VALUES (1779, '长沙学院', '4143011077', 1);
INSERT INTO `xy_school` VALUES (1780, '湖南工程学院', '4143011342', 1);
INSERT INTO `xy_school` VALUES (1781, '湖南城市学院', '4143011527', 1);
INSERT INTO `xy_school` VALUES (1782, '湖南工学院', '4143011528', 1);
INSERT INTO `xy_school` VALUES (1783, '湖南财政经济学院', '4143011532', 1);
INSERT INTO `xy_school` VALUES (1784, '湖南警察学院', '4143011534', 1);
INSERT INTO `xy_school` VALUES (1785, '湖南工业大学', '4143011535', 1);
INSERT INTO `xy_school` VALUES (1786, '湖南女子学院', '4143011538', 1);
INSERT INTO `xy_school` VALUES (1787, '湖南第一师范学院', '4143012034', 1);
INSERT INTO `xy_school` VALUES (1788, '湖南医药学院', '4143012214', 1);
INSERT INTO `xy_school` VALUES (1789, '湖南涉外经济学院', '4143012303', 1);
INSERT INTO `xy_school` VALUES (1790, '湘潭大学兴湘学院', '4143012599', 1);
INSERT INTO `xy_school` VALUES (1791, '湖南工业大学科技学院', '4143012604', 1);
INSERT INTO `xy_school` VALUES (1792, '湖南科技大学潇湘学院', '4143012649', 1);
INSERT INTO `xy_school` VALUES (1793, '南华大学船山学院', '4143012650', 1);
INSERT INTO `xy_school` VALUES (1794, '湘潭理工学院', '4143012651', 1);
INSERT INTO `xy_school` VALUES (1795, '湖南师范大学树达学院', '4143012652', 1);
INSERT INTO `xy_school` VALUES (1796, '湖南农业大学东方科技学院', '4143012653', 1);
INSERT INTO `xy_school` VALUES (1797, '中南林业科技大学涉外学院', '4143012656', 1);
INSERT INTO `xy_school` VALUES (1798, '湖南文理学院芙蓉学院', '4143012657', 1);
INSERT INTO `xy_school` VALUES (1799, '湖南理工学院南湖学院', '4143012658', 1);
INSERT INTO `xy_school` VALUES (1800, '衡阳师范学院南岳学院', '4143012659', 1);
INSERT INTO `xy_school` VALUES (1801, '湖南工程学院应用技术学院', '4143012660', 1);
INSERT INTO `xy_school` VALUES (1802, '湖南中医药大学湘杏学院', '4143012661', 1);
INSERT INTO `xy_school` VALUES (1803, '吉首大学张家界学院', '4143012662', 1);
INSERT INTO `xy_school` VALUES (1804, '长沙理工大学城南学院', '4143013635', 1);
INSERT INTO `xy_school` VALUES (1805, '长沙师范学院', '4143013806', 1);
INSERT INTO `xy_school` VALUES (1806, '湖南应用技术学院', '4143013809', 1);
INSERT INTO `xy_school` VALUES (1807, '湖南信息学院', '4143013836', 1);
INSERT INTO `xy_school` VALUES (1808, '湖南交通工程学院', '4143013924', 1);
INSERT INTO `xy_school` VALUES (1809, '湖南软件职业学院（本科）', '4143013925', 1);
INSERT INTO `xy_school` VALUES (1810, '湘中幼儿师范高等专科学校', '3643000496', 1);
INSERT INTO `xy_school` VALUES (1811, '长沙民政职业技术学院', '4143010827', 1);
INSERT INTO `xy_school` VALUES (1812, '湖南工业职业技术学院', '4143010830', 1);
INSERT INTO `xy_school` VALUES (1813, '株洲师范高等专科学校', '4143010836', 1);
INSERT INTO `xy_school` VALUES (1814, '湖南信息职业技术学院', '4143010865', 1);
INSERT INTO `xy_school` VALUES (1815, '湖南税务高等专科学校', '4143011601', 1);
INSERT INTO `xy_school` VALUES (1816, '湖南冶金职业技术学院', '4143011604', 1);
INSERT INTO `xy_school` VALUES (1817, '长沙航空职业技术学院', '4143012055', 1);
INSERT INTO `xy_school` VALUES (1818, '湖南大众传媒职业技术学院', '4143012300', 1);
INSERT INTO `xy_school` VALUES (1819, '永州职业技术学院', '4143012301', 1);
INSERT INTO `xy_school` VALUES (1820, '湖南铁道职业技术学院', '4143012302', 1);
INSERT INTO `xy_school` VALUES (1821, '湖南科技职业学院', '4143012304', 1);
INSERT INTO `xy_school` VALUES (1822, '湖南生物机电职业技术学院', '4143012343', 1);
INSERT INTO `xy_school` VALUES (1823, '湖南交通职业技术学院', '4143012397', 1);
INSERT INTO `xy_school` VALUES (1824, '湖南商务职业技术学院', '4143012401', 1);
INSERT INTO `xy_school` VALUES (1825, '湖南体育职业学院', '4143012423', 1);
INSERT INTO `xy_school` VALUES (1826, '湖南工程职业技术学院', '4143012425', 1);
INSERT INTO `xy_school` VALUES (1827, '保险职业学院', '4143012596', 1);
INSERT INTO `xy_school` VALUES (1828, '湖南外贸职业学院', '4143012597', 1);
INSERT INTO `xy_school` VALUES (1829, '湖南网络工程职业学院', '4143012598', 1);
INSERT INTO `xy_school` VALUES (1830, '邵阳职业技术学院', '4143012600', 1);
INSERT INTO `xy_school` VALUES (1831, '湖南司法警官职业学院', '4143012601', 1);
INSERT INTO `xy_school` VALUES (1832, '长沙商贸旅游职业技术学院', '4143012603', 1);
INSERT INTO `xy_school` VALUES (1833, '湖南环境生物职业技术学院', '4143012739', 1);
INSERT INTO `xy_school` VALUES (1834, '湖南邮电职业技术学院', '4143012845', 1);
INSERT INTO `xy_school` VALUES (1835, '湘潭医卫职业技术学院', '4143012846', 1);
INSERT INTO `xy_school` VALUES (1836, '郴州职业技术学院', '4143012847', 1);
INSERT INTO `xy_school` VALUES (1837, '娄底职业技术学院', '4143012848', 1);
INSERT INTO `xy_school` VALUES (1838, '张家界航空工业职业技术学院', '4143012849', 1);
INSERT INTO `xy_school` VALUES (1839, '长沙环境保护职业技术学院', '4143013031', 1);
INSERT INTO `xy_school` VALUES (1840, '湖南艺术职业学院', '4143013032', 1);
INSERT INTO `xy_school` VALUES (1841, '湖南机电职业技术学院', '4143013033', 1);
INSERT INTO `xy_school` VALUES (1842, '长沙职业技术学院', '4143013036', 1);
INSERT INTO `xy_school` VALUES (1843, '怀化职业技术学院', '4143013037', 1);
INSERT INTO `xy_school` VALUES (1844, '岳阳职业技术学院', '4143013038', 1);
INSERT INTO `xy_school` VALUES (1845, '常德职业技术学院', '4143013039', 1);
INSERT INTO `xy_school` VALUES (1846, '长沙南方职业学院', '4143013041', 1);
INSERT INTO `xy_school` VALUES (1847, '潇湘职业学院', '4143013042', 1);
INSERT INTO `xy_school` VALUES (1848, '湖南化工职业技术学院', '4143013043', 1);
INSERT INTO `xy_school` VALUES (1849, '湖南城建职业技术学院', '4143013044', 1);
INSERT INTO `xy_school` VALUES (1850, '湖南石油化工职业技术学院', '4143013045', 1);
INSERT INTO `xy_school` VALUES (1851, '湖南中医药高等专科学校', '4143013802', 1);
INSERT INTO `xy_school` VALUES (1852, '湖南民族职业学院', '4143013804', 1);
INSERT INTO `xy_school` VALUES (1853, '湘西民族职业技术学院', '4143013805', 1);
INSERT INTO `xy_school` VALUES (1854, '湖南财经工业职业技术学院', '4143013807', 1);
INSERT INTO `xy_school` VALUES (1855, '益阳职业技术学院', '4143013808', 1);
INSERT INTO `xy_school` VALUES (1856, '湖南工艺美术职业学院', '4143013921', 1);
INSERT INTO `xy_school` VALUES (1857, '湖南九嶷职业技术学院', '4143013922', 1);
INSERT INTO `xy_school` VALUES (1858, '湖南理工职业技术学院', '4143013923', 1);
INSERT INTO `xy_school` VALUES (1859, '湖南汽车工程职业学院', '4143013937', 1);
INSERT INTO `xy_school` VALUES (1860, '长沙电力职业技术学院', '4143013938', 1);
INSERT INTO `xy_school` VALUES (1861, '湖南水利水电职业技术学院', '4143013939', 1);
INSERT INTO `xy_school` VALUES (1862, '湖南现代物流职业技术学院', '4143013940', 1);
INSERT INTO `xy_school` VALUES (1863, '湖南高速铁路职业技术学院', '4143013941', 1);
INSERT INTO `xy_school` VALUES (1864, '湖南铁路科技职业技术学院', '4143013942', 1);
INSERT INTO `xy_school` VALUES (1865, '湖南安全技术职业学院', '4143014025', 1);
INSERT INTO `xy_school` VALUES (1866, '湖南电气职业技术学院', '4143014071', 1);
INSERT INTO `xy_school` VALUES (1867, '湖南外国语职业学院', '4143014072', 1);
INSERT INTO `xy_school` VALUES (1868, '益阳医学高等专科学校', '4143014097', 1);
INSERT INTO `xy_school` VALUES (1869, '湖南都市职业学院', '4143014121', 1);
INSERT INTO `xy_school` VALUES (1870, '湖南电子科技职业学院', '4143014122', 1);
INSERT INTO `xy_school` VALUES (1871, '湖南国防工业职业技术学院', '4143014182', 1);
INSERT INTO `xy_school` VALUES (1872, '湖南高尔夫旅游职业学院', '4143014309', 1);
INSERT INTO `xy_school` VALUES (1873, '湖南工商职业学院', '4143014310', 1);
INSERT INTO `xy_school` VALUES (1874, '湖南三一工业职业技术学院', '4143014322', 1);
INSERT INTO `xy_school` VALUES (1875, '长沙卫生职业学院', '4143014358', 1);
INSERT INTO `xy_school` VALUES (1876, '湖南食品药品职业学院', '4143014359', 1);
INSERT INTO `xy_school` VALUES (1877, '湖南有色金属职业技术学院', '4143014360', 1);
INSERT INTO `xy_school` VALUES (1878, '湖南吉利汽车职业技术学院', '4143014406', 1);
INSERT INTO `xy_school` VALUES (1879, '湖南幼儿师范高等专科学校', '4143014468', 1);
INSERT INTO `xy_school` VALUES (1880, '湘南幼儿师范高等专科学校', '4143014495', 1);
INSERT INTO `xy_school` VALUES (1881, '湖南劳动人事职业学院', '4143014508', 1);
INSERT INTO `xy_school` VALUES (1882, '怀化师范高等专科学校', '4143014663', 1);
INSERT INTO `xy_school` VALUES (1883, '永州师范高等专科学校', '4143014690', 1);
INSERT INTO `xy_school` VALUES (1884, '衡阳幼儿师范高等专科学校', '4143014691', 1);
INSERT INTO `xy_school` VALUES (1885, '长沙幼儿师范高等专科学校', '4143014692', 1);
INSERT INTO `xy_school` VALUES (1886, '中山大学', '4144010558', 1);
INSERT INTO `xy_school` VALUES (1887, '暨南大学', '4144010559', 1);
INSERT INTO `xy_school` VALUES (1888, '汕头大学', '4144010560', 1);
INSERT INTO `xy_school` VALUES (1889, '华南理工大学', '4144010561', 1);
INSERT INTO `xy_school` VALUES (1890, '华南农业大学', '4144010564', 1);
INSERT INTO `xy_school` VALUES (1891, '广东海洋大学', '4144010566', 1);
INSERT INTO `xy_school` VALUES (1892, '广州医科大学', '4144010570', 1);
INSERT INTO `xy_school` VALUES (1893, '广东医科大学', '4144010571', 1);
INSERT INTO `xy_school` VALUES (1894, '广州中医药大学', '4144010572', 1);
INSERT INTO `xy_school` VALUES (1895, '广东药科大学', '4144010573', 1);
INSERT INTO `xy_school` VALUES (1896, '华南师范大学', '4144010574', 1);
INSERT INTO `xy_school` VALUES (1897, '韶关学院', '4144010576', 1);
INSERT INTO `xy_school` VALUES (1898, '惠州学院', '4144010577', 1);
INSERT INTO `xy_school` VALUES (1899, '韩山师范学院', '4144010578', 1);
INSERT INTO `xy_school` VALUES (1900, '岭南师范学院', '4144010579', 1);
INSERT INTO `xy_school` VALUES (1901, '肇庆学院', '4144010580', 1);
INSERT INTO `xy_school` VALUES (1902, '嘉应学院', '4144010582', 1);
INSERT INTO `xy_school` VALUES (1903, '广州体育学院', '4144010585', 1);
INSERT INTO `xy_school` VALUES (1904, '广州美术学院', '4144010586', 1);
INSERT INTO `xy_school` VALUES (1905, '星海音乐学院', '4144010587', 1);
INSERT INTO `xy_school` VALUES (1906, '广东技术师范大学', '4144010588', 1);
INSERT INTO `xy_school` VALUES (1907, '深圳大学', '4144010590', 1);
INSERT INTO `xy_school` VALUES (1908, '广东财经大学', '4144010592', 1);
INSERT INTO `xy_school` VALUES (1909, '广东白云学院', '4144010822', 1);
INSERT INTO `xy_school` VALUES (1910, '广州大学', '4144011078', 1);
INSERT INTO `xy_school` VALUES (1911, '广州航海学院', '4144011106', 1);
INSERT INTO `xy_school` VALUES (1912, '广东警官学院', '4144011110', 1);
INSERT INTO `xy_school` VALUES (1913, '仲恺农业工程学院', '4144011347', 1);
INSERT INTO `xy_school` VALUES (1914, '五邑大学', '4144011349', 1);
INSERT INTO `xy_school` VALUES (1915, '广东金融学院', '4144011540', 1);
INSERT INTO `xy_school` VALUES (1916, '电子科技大学中山学院', '4144011545', 1);
INSERT INTO `xy_school` VALUES (1917, '广东石油化工学院', '4144011656', 1);
INSERT INTO `xy_school` VALUES (1918, '东莞理工学院', '4144011819', 1);
INSERT INTO `xy_school` VALUES (1919, '广东工业大学', '4144011845', 1);
INSERT INTO `xy_school` VALUES (1920, '广东外语外贸大学', '4144011846', 1);
INSERT INTO `xy_school` VALUES (1921, '佛山科学技术学院', '4144011847', 1);
INSERT INTO `xy_school` VALUES (1922, '广东培正学院', '4144012059', 1);
INSERT INTO `xy_school` VALUES (1923, '南方医科大学', '4144012121', 1);
INSERT INTO `xy_school` VALUES (1924, '广东东软学院', '4144012574', 1);
INSERT INTO `xy_school` VALUES (1925, '华南理工大学广州学院', '4144012617', 1);
INSERT INTO `xy_school` VALUES (1926, '广州大学华软软件学院', '4144012618', 1);
INSERT INTO `xy_school` VALUES (1927, '中山大学南方学院', '4144012619', 1);
INSERT INTO `xy_school` VALUES (1928, '广东外语外贸大学南国商学院', '4144012620', 1);
INSERT INTO `xy_school` VALUES (1929, '广东财经大学华商学院', '4144012621', 1);
INSERT INTO `xy_school` VALUES (1930, '广东海洋大学寸金学院', '4144012622', 1);
INSERT INTO `xy_school` VALUES (1931, '华南农业大学珠江学院', '4144012623', 1);
INSERT INTO `xy_school` VALUES (1932, '广州理工学院', '4144012668', 1);
INSERT INTO `xy_school` VALUES (1933, '北京师范大学珠海分校', '4144013177', 1);
INSERT INTO `xy_school` VALUES (1934, '广东工业大学华立学院', '4144013656', 1);
INSERT INTO `xy_school` VALUES (1935, '广州大学松田学院', '4144013657', 1);
INSERT INTO `xy_school` VALUES (1936, '广州商学院', '4144013667', 1);
INSERT INTO `xy_school` VALUES (1937, '北京理工大学珠海学院', '4144013675', 1);
INSERT INTO `xy_school` VALUES (1938, '吉林大学珠海学院', '4144013684', 1);
INSERT INTO `xy_school` VALUES (1939, '广州工商学院', '4144013714', 1);
INSERT INTO `xy_school` VALUES (1940, '广州科技职业技术大学', '4144013717', 1);
INSERT INTO `xy_school` VALUES (1941, '广东科技学院', '4144013719', 1);
INSERT INTO `xy_school` VALUES (1942, '广东理工学院', '4144013720', 1);
INSERT INTO `xy_school` VALUES (1943, '广东工商职业技术大学', '4144013721', 1);
INSERT INTO `xy_school` VALUES (1944, '东莞理工学院城市学院', '4144013844', 1);
INSERT INTO `xy_school` VALUES (1945, '中山大学新华学院', '4144013902', 1);
INSERT INTO `xy_school` VALUES (1946, '广东第二师范学院', '4144014278', 1);
INSERT INTO `xy_school` VALUES (1947, '南方科技大学', '4144014325', 1);
INSERT INTO `xy_school` VALUES (1948, '深圳技术大学', '4144014655', 1);
INSERT INTO `xy_school` VALUES (1949, '北京师范大学-香港浸会大学联合国际学院', '4144016401', 1);
INSERT INTO `xy_school` VALUES (1950, '香港中文大学（深圳）', '4144016407', 1);
INSERT INTO `xy_school` VALUES (1951, '深圳北理莫斯科大学', '4144016409', 1);
INSERT INTO `xy_school` VALUES (1952, '广东以色列理工学院', '4144016410', 1);
INSERT INTO `xy_school` VALUES (1953, '顺德职业技术学院', '4144010831', 1);
INSERT INTO `xy_school` VALUES (1954, '广东轻工职业技术学院', '4144010833', 1);
INSERT INTO `xy_school` VALUES (1955, '广东交通职业技术学院', '4144010861', 1);
INSERT INTO `xy_school` VALUES (1956, '广东水利电力职业技术学院', '4144010862', 1);
INSERT INTO `xy_school` VALUES (1957, '潮汕职业技术学院', '4144010965', 1);
INSERT INTO `xy_school` VALUES (1958, '深圳职业技术学院', '4144011113', 1);
INSERT INTO `xy_school` VALUES (1959, '广东南华工商职业学院', '4144011114', 1);
INSERT INTO `xy_school` VALUES (1960, '私立华联学院', '4144011121', 1);
INSERT INTO `xy_school` VALUES (1961, '广州民航职业技术学院', '4144012040', 1);
INSERT INTO `xy_school` VALUES (1962, '广州番禺职业技术学院', '4144012046', 1);
INSERT INTO `xy_school` VALUES (1963, '广东松山职业技术学院', '4144012060', 1);
INSERT INTO `xy_school` VALUES (1964, '广东农工商职业技术学院', '4144012322', 1);
INSERT INTO `xy_school` VALUES (1965, '广东新安职业技术学院', '4144012325', 1);
INSERT INTO `xy_school` VALUES (1966, '佛山职业技术学院', '4144012327', 1);
INSERT INTO `xy_school` VALUES (1967, '广东科学技术职业学院', '4144012572', 1);
INSERT INTO `xy_school` VALUES (1968, '广东食品药品职业学院', '4144012573', 1);
INSERT INTO `xy_school` VALUES (1969, '广州康大职业技术学院', '4144012575', 1);
INSERT INTO `xy_school` VALUES (1970, '珠海艺术职业学院', '4144012576', 1);
INSERT INTO `xy_school` VALUES (1971, '广东行政职业学院', '4144012577', 1);
INSERT INTO `xy_school` VALUES (1972, '广东体育职业技术学院', '4144012578', 1);
INSERT INTO `xy_school` VALUES (1973, '广东职业技术学院', '4144012736', 1);
INSERT INTO `xy_school` VALUES (1974, '广东建设职业技术学院', '4144012741', 1);
INSERT INTO `xy_school` VALUES (1975, '广东女子职业技术学院', '4144012742', 1);
INSERT INTO `xy_school` VALUES (1976, '广东机电职业技术学院', '4144012743', 1);
INSERT INTO `xy_school` VALUES (1977, '广东岭南职业技术学院', '4144012749', 1);
INSERT INTO `xy_school` VALUES (1978, '汕尾职业技术学院', '4144012765', 1);
INSERT INTO `xy_school` VALUES (1979, '罗定职业技术学院', '4144012770', 1);
INSERT INTO `xy_school` VALUES (1980, '阳江职业技术学院', '4144012771', 1);
INSERT INTO `xy_school` VALUES (1981, '河源职业技术学院', '4144012772', 1);
INSERT INTO `xy_school` VALUES (1982, '广东邮电职业技术学院', '4144012953', 1);
INSERT INTO `xy_school` VALUES (1983, '汕头职业技术学院', '4144012954', 1);
INSERT INTO `xy_school` VALUES (1984, '揭阳职业技术学院', '4144012956', 1);
INSERT INTO `xy_school` VALUES (1985, '深圳信息职业技术学院', '4144012957', 1);
INSERT INTO `xy_school` VALUES (1986, '清远职业技术学院', '4144012958', 1);
INSERT INTO `xy_school` VALUES (1987, '广东工贸职业技术学院', '4144012959', 1);
INSERT INTO `xy_school` VALUES (1988, '广东司法警官职业学院', '4144012960', 1);
INSERT INTO `xy_school` VALUES (1989, '广东亚视演艺职业学院', '4144012961', 1);
INSERT INTO `xy_school` VALUES (1990, '广东省外语艺术职业学院', '4144012962', 1);
INSERT INTO `xy_school` VALUES (1991, '广东文艺职业学院', '4144013707', 1);
INSERT INTO `xy_school` VALUES (1992, '广州体育职业技术学院', '4144013708', 1);
INSERT INTO `xy_school` VALUES (1993, '广州工程技术职业学院', '4144013709', 1);
INSERT INTO `xy_school` VALUES (1994, '中山火炬职业技术学院', '4144013710', 1);
INSERT INTO `xy_school` VALUES (1995, '江门职业技术学院', '4144013711', 1);
INSERT INTO `xy_school` VALUES (1996, '茂名职业技术学院', '4144013712', 1);
INSERT INTO `xy_school` VALUES (1997, '珠海城市职业技术学院', '4144013713', 1);
INSERT INTO `xy_school` VALUES (1998, '广州涉外经济职业技术学院', '4144013715', 1);
INSERT INTO `xy_school` VALUES (1999, '广州南洋理工职业学院', '4144013716', 1);
INSERT INTO `xy_school` VALUES (2000, '惠州经济职业技术学院', '4144013718', 1);
INSERT INTO `xy_school` VALUES (2001, '肇庆医学高等专科学校', '4144013810', 1);
INSERT INTO `xy_school` VALUES (2002, '广州现代信息工程职业技术学院', '4144013912', 1);
INSERT INTO `xy_school` VALUES (2003, '广东理工职业学院', '4144013919', 1);
INSERT INTO `xy_school` VALUES (2004, '广州华南商贸职业学院', '4144013927', 1);
INSERT INTO `xy_school` VALUES (2005, '广州华立科技职业学院', '4144013928', 1);
INSERT INTO `xy_school` VALUES (2006, '广州城市职业学院', '4144013929', 1);
INSERT INTO `xy_school` VALUES (2007, '广东工程职业技术学院', '4144013930', 1);
INSERT INTO `xy_school` VALUES (2008, '广州铁路职业技术学院', '4144013943', 1);
INSERT INTO `xy_school` VALUES (2009, '广东科贸职业学院', '4144014063', 1);
INSERT INTO `xy_school` VALUES (2010, '广州科技贸易职业学院', '4144014065', 1);
INSERT INTO `xy_school` VALUES (2011, '中山职业技术学院', '4144014066', 1);
INSERT INTO `xy_school` VALUES (2012, '广州珠江职业技术学院', '4144014123', 1);
INSERT INTO `xy_school` VALUES (2013, '广州松田职业学院', '4144014125', 1);
INSERT INTO `xy_school` VALUES (2014, '广东文理职业学院', '4144014126', 1);
INSERT INTO `xy_school` VALUES (2015, '广州城建职业学院', '4144014136', 1);
INSERT INTO `xy_school` VALUES (2016, '东莞职业技术学院', '4144014263', 1);
INSERT INTO `xy_school` VALUES (2017, '广东南方职业学院', '4144014265', 1);
INSERT INTO `xy_school` VALUES (2018, '广州华商职业学院', '4144014266', 1);
INSERT INTO `xy_school` VALUES (2019, '广州华夏职业学院', '4144014268', 1);
INSERT INTO `xy_school` VALUES (2020, '广东环境保护工程职业学院', '4144014311', 1);
INSERT INTO `xy_school` VALUES (2021, '广东青年职业学院', '4144014361', 1);
INSERT INTO `xy_school` VALUES (2022, '广州东华职业学院', '4144014362', 1);
INSERT INTO `xy_school` VALUES (2023, '广东创新科技职业学院', '4144014363', 1);
INSERT INTO `xy_school` VALUES (2024, '广东舞蹈戏剧职业学院', '4144014407', 1);
INSERT INTO `xy_school` VALUES (2025, '惠州卫生职业技术学院', '4144014408', 1);
INSERT INTO `xy_school` VALUES (2026, '广东信息工程职业学院', '4144014427', 1);
INSERT INTO `xy_school` VALUES (2027, '广东生态工程职业学院', '4144014509', 1);
INSERT INTO `xy_school` VALUES (2028, '惠州城市职业学院', '4144014510', 1);
INSERT INTO `xy_school` VALUES (2029, '广东碧桂园职业学院', '4144014511', 1);
INSERT INTO `xy_school` VALUES (2030, '广东茂名健康职业学院', '4144014556', 1);
INSERT INTO `xy_school` VALUES (2031, '广东酒店管理职业技术学院', '4144014572', 1);
INSERT INTO `xy_school` VALUES (2032, '广东茂名幼儿师范专科学校', '4144014587', 1);
INSERT INTO `xy_school` VALUES (2033, '广州卫生职业技术学院', '4144014592', 1);
INSERT INTO `xy_school` VALUES (2034, '惠州工程职业学院', '4144014609', 1);
INSERT INTO `xy_school` VALUES (2035, '广东江门中医药职业学院', '4144014610', 1);
INSERT INTO `xy_school` VALUES (2036, '广东茂名农林科技职业学院', '4144014638', 1);
INSERT INTO `xy_school` VALUES (2037, '广东江门幼儿师范高等专科学校', '4144014664', 1);
INSERT INTO `xy_school` VALUES (2038, '广东财贸职业学院', '4144014667', 1);
INSERT INTO `xy_school` VALUES (2039, '湛江幼儿师范专科学校', '4244050853', 1);
INSERT INTO `xy_school` VALUES (2040, '广西大学', '4145010593', 1);
INSERT INTO `xy_school` VALUES (2041, '广西科技大学', '4145010594', 1);
INSERT INTO `xy_school` VALUES (2042, '桂林电子科技大学', '4145010595', 1);
INSERT INTO `xy_school` VALUES (2043, '桂林理工大学', '4145010596', 1);
INSERT INTO `xy_school` VALUES (2044, '广西医科大学', '4145010598', 1);
INSERT INTO `xy_school` VALUES (2045, '右江民族医学院', '4145010599', 1);
INSERT INTO `xy_school` VALUES (2046, '广西中医药大学', '4145010600', 1);
INSERT INTO `xy_school` VALUES (2047, '桂林医学院', '4145010601', 1);
INSERT INTO `xy_school` VALUES (2048, '广西师范大学', '4145010602', 1);
INSERT INTO `xy_school` VALUES (2049, '南宁师范大学', '4145010603', 1);
INSERT INTO `xy_school` VALUES (2050, '广西民族师范学院', '4145010604', 1);
INSERT INTO `xy_school` VALUES (2051, '河池学院', '4145010605', 1);
INSERT INTO `xy_school` VALUES (2052, '玉林师范学院', '4145010606', 1);
INSERT INTO `xy_school` VALUES (2053, '广西艺术学院', '4145010607', 1);
INSERT INTO `xy_school` VALUES (2054, '广西民族大学', '4145010608', 1);
INSERT INTO `xy_school` VALUES (2055, '百色学院', '4145010609', 1);
INSERT INTO `xy_school` VALUES (2056, '梧州学院', '4145011354', 1);
INSERT INTO `xy_school` VALUES (2057, '广西科技师范学院', '4145011546', 1);
INSERT INTO `xy_school` VALUES (2058, '广西财经学院', '4145011548', 1);
INSERT INTO `xy_school` VALUES (2059, '南宁学院', '4145011549', 1);
INSERT INTO `xy_school` VALUES (2060, '北部湾大学', '4145011607', 1);
INSERT INTO `xy_school` VALUES (2061, '桂林航天工业学院', '4145011825', 1);
INSERT INTO `xy_school` VALUES (2062, '桂林旅游学院', '4145011837', 1);
INSERT INTO `xy_school` VALUES (2063, '贺州学院', '4145011838', 1);
INSERT INTO `xy_school` VALUES (2064, '广西警察学院', '4145013520', 1);
INSERT INTO `xy_school` VALUES (2065, '北海艺术设计学院', '4145013524', 1);
INSERT INTO `xy_school` VALUES (2066, '广西大学行健文理学院', '4145013638', 1);
INSERT INTO `xy_school` VALUES (2067, '柳州工学院', '4145013639', 1);
INSERT INTO `xy_school` VALUES (2068, '广西民族大学相思湖学院', '4145013640', 1);
INSERT INTO `xy_school` VALUES (2069, '广西师范大学漓江学院', '4145013641', 1);
INSERT INTO `xy_school` VALUES (2070, '南宁师范大学师园学院', '4145013642', 1);
INSERT INTO `xy_school` VALUES (2071, '广西中医药大学赛恩斯新医药学院', '4145013643', 1);
INSERT INTO `xy_school` VALUES (2072, '桂林电子科技大学信息科技学院', '4145013644', 1);
INSERT INTO `xy_school` VALUES (2073, '桂林理工大学博文管理学院', '4145013645', 1);
INSERT INTO `xy_school` VALUES (2074, '广西外国语学院', '4145013830', 1);
INSERT INTO `xy_school` VALUES (2075, '北京航空航天大学北海学院', '4145013890', 1);
INSERT INTO `xy_school` VALUES (2076, '广西城市职业大学', '4145013920', 1);
INSERT INTO `xy_school` VALUES (2077, '广西职业师范学院', '4145014684', 1);
INSERT INTO `xy_school` VALUES (2078, '桂林生命与健康职业技术学院', '4145010035', 1);
INSERT INTO `xy_school` VALUES (2079, '广西机电职业技术学院', '4145010867', 1);
INSERT INTO `xy_school` VALUES (2080, '广西体育高等专科学校', '4145011350', 1);
INSERT INTO `xy_school` VALUES (2081, '南宁职业技术学院', '4145011355', 1);
INSERT INTO `xy_school` VALUES (2082, '广西水利电力职业技术学院', '4145011608', 1);
INSERT INTO `xy_school` VALUES (2083, '桂林师范高等专科学校', '4145011671', 1);
INSERT INTO `xy_school` VALUES (2084, '广西职业技术学院', '4145011773', 1);
INSERT INTO `xy_school` VALUES (2085, '柳州职业技术学院', '4145012104', 1);
INSERT INTO `xy_school` VALUES (2086, '广西生态工程职业技术学院', '4145012344', 1);
INSERT INTO `xy_school` VALUES (2087, '广西交通职业技术学院', '4145012356', 1);
INSERT INTO `xy_school` VALUES (2088, '广西工业职业技术学院', '4145012364', 1);
INSERT INTO `xy_school` VALUES (2089, '广西国际商务职业技术学院', '4145012379', 1);
INSERT INTO `xy_school` VALUES (2090, '广西农业职业技术学院', '4145012382', 1);
INSERT INTO `xy_school` VALUES (2091, '柳州铁道职业技术学院', '4145012392', 1);
INSERT INTO `xy_school` VALUES (2092, '广西建设职业技术学院', '4145013138', 1);
INSERT INTO `xy_school` VALUES (2093, '广西现代职业技术学院', '4145013522', 1);
INSERT INTO `xy_school` VALUES (2094, '北海职业学院', '4145013523', 1);
INSERT INTO `xy_school` VALUES (2095, '桂林山水职业学院', '4145013526', 1);
INSERT INTO `xy_school` VALUES (2096, '广西经贸职业技术学院', '4145013827', 1);
INSERT INTO `xy_school` VALUES (2097, '广西工商职业技术学院', '4145013828', 1);
INSERT INTO `xy_school` VALUES (2098, '广西演艺职业学院', '4145013829', 1);
INSERT INTO `xy_school` VALUES (2099, '广西电力职业技术学院', '4145013831', 1);
INSERT INTO `xy_school` VALUES (2100, '广西英华国际职业学院', '4145014026', 1);
INSERT INTO `xy_school` VALUES (2101, '柳州城市职业学院', '4145014067', 1);
INSERT INTO `xy_school` VALUES (2102, '百色职业学院', '4145014068', 1);
INSERT INTO `xy_school` VALUES (2103, '广西工程职业学院', '4145014127', 1);
INSERT INTO `xy_school` VALUES (2104, '广西理工职业技术学院', '4145014170', 1);
INSERT INTO `xy_school` VALUES (2105, '梧州职业学院', '4145014171', 1);
INSERT INTO `xy_school` VALUES (2106, '广西经济职业学院', '4145014211', 1);
INSERT INTO `xy_school` VALUES (2107, '广西幼儿师范高等专科学校', '4145014220', 1);
INSERT INTO `xy_school` VALUES (2108, '广西科技职业学院', '4145014312', 1);
INSERT INTO `xy_school` VALUES (2109, '广西卫生职业技术学院', '4145014313', 1);
INSERT INTO `xy_school` VALUES (2110, '广西培贤国际职业学院', '4145014481', 1);
INSERT INTO `xy_school` VALUES (2111, '广西金融职业技术学院', '4145014512', 1);
INSERT INTO `xy_school` VALUES (2112, '广西中远职业学院', '4145014546', 1);
INSERT INTO `xy_school` VALUES (2113, '玉柴职业技术学院', '4145014573', 1);
INSERT INTO `xy_school` VALUES (2114, '广西蓝天航空职业学院', '4145014574', 1);
INSERT INTO `xy_school` VALUES (2115, '广西安全工程职业技术学院', '4145014611', 1);
INSERT INTO `xy_school` VALUES (2116, '广西自然资源职业技术学院', '4145014668', 1);
INSERT INTO `xy_school` VALUES (2117, '钦州幼儿师范高等专科学校', '4145014693', 1);
INSERT INTO `xy_school` VALUES (2118, '梧州医学高等专科学校', '4145014694', 1);
INSERT INTO `xy_school` VALUES (2119, '广西制造工程职业技术学院', '4145014722', 1);
INSERT INTO `xy_school` VALUES (2120, '广西物流职业技术学院', '4145014723', 1);
INSERT INTO `xy_school` VALUES (2121, '崇左幼儿师范高等专科学校', '4245051675', 1);
INSERT INTO `xy_school` VALUES (2122, '海南大学', '4146010589', 1);
INSERT INTO `xy_school` VALUES (2123, '海南热带海洋学院', '4146011100', 1);
INSERT INTO `xy_school` VALUES (2124, '海南师范大学', '4146011658', 1);
INSERT INTO `xy_school` VALUES (2125, '海南医学院', '4146011810', 1);
INSERT INTO `xy_school` VALUES (2126, '海口经济学院', '4146012308', 1);
INSERT INTO `xy_school` VALUES (2127, '琼台师范学院', '4146013811', 1);
INSERT INTO `xy_school` VALUES (2128, '三亚学院', '4146013892', 1);
INSERT INTO `xy_school` VALUES (2129, '海南科技职业大学', '4146014172', 1);
INSERT INTO `xy_school` VALUES (2130, '海南职业技术学院', '4146011999', 1);
INSERT INTO `xy_school` VALUES (2131, '三亚城市职业学院', '4146012717', 1);
INSERT INTO `xy_school` VALUES (2132, '海南软件职业技术学院', '4146013575', 1);
INSERT INTO `xy_school` VALUES (2133, '海南政法职业学院', '4146013576', 1);
INSERT INTO `xy_school` VALUES (2134, '海南外国语职业学院', '4146013577', 1);
INSERT INTO `xy_school` VALUES (2135, '海南经贸职业技术学院', '4146013875', 1);
INSERT INTO `xy_school` VALUES (2136, '海南工商职业学院', '4146013876', 1);
INSERT INTO `xy_school` VALUES (2137, '三亚航空旅游职业学院', '4146013931', 1);
INSERT INTO `xy_school` VALUES (2138, '三亚理工职业学院', '4146014236', 1);
INSERT INTO `xy_school` VALUES (2139, '海南体育职业技术学院', '4146014575', 1);
INSERT INTO `xy_school` VALUES (2140, '三亚中瑞酒店管理职业学院', '4146014612', 1);
INSERT INTO `xy_school` VALUES (2141, '海南健康管理职业技术学院', '4146014639', 1);
INSERT INTO `xy_school` VALUES (2142, '海南卫生健康职业学院', '4146014724', 1);
INSERT INTO `xy_school` VALUES (2143, '重庆大学', '4150010611', 1);
INSERT INTO `xy_school` VALUES (2144, '重庆邮电大学', '4150010617', 1);
INSERT INTO `xy_school` VALUES (2145, '重庆交通大学', '4150010618', 1);
INSERT INTO `xy_school` VALUES (2146, '重庆医科大学', '4150010631', 1);
INSERT INTO `xy_school` VALUES (2147, '西南大学', '4150010635', 1);
INSERT INTO `xy_school` VALUES (2148, '重庆师范大学', '4150010637', 1);
INSERT INTO `xy_school` VALUES (2149, '重庆文理学院', '4150010642', 1);
INSERT INTO `xy_school` VALUES (2150, '重庆三峡学院', '4150010643', 1);
INSERT INTO `xy_school` VALUES (2151, '长江师范学院', '4150010647', 1);
INSERT INTO `xy_school` VALUES (2152, '四川外国语大学', '4150010650', 1);
INSERT INTO `xy_school` VALUES (2153, '西南政法大学', '4150010652', 1);
INSERT INTO `xy_school` VALUES (2154, '四川美术学院', '4150010655', 1);
INSERT INTO `xy_school` VALUES (2155, '重庆科技学院', '4150011551', 1);
INSERT INTO `xy_school` VALUES (2156, '重庆理工大学', '4150011660', 1);
INSERT INTO `xy_school` VALUES (2157, '重庆工商大学', '4150011799', 1);
INSERT INTO `xy_school` VALUES (2158, '重庆机电职业技术大学', '4150012607', 1);
INSERT INTO `xy_school` VALUES (2159, '重庆工程学院', '4150012608', 1);
INSERT INTO `xy_school` VALUES (2160, '重庆大学城市科技学院', '4150012616', 1);
INSERT INTO `xy_school` VALUES (2161, '重庆警察学院', '4150012757', 1);
INSERT INTO `xy_school` VALUES (2162, '重庆人文科技学院', '4150013548', 1);
INSERT INTO `xy_school` VALUES (2163, '四川外国语大学重庆南方翻译学院', '4150013588', 1);
INSERT INTO `xy_school` VALUES (2164, '重庆师范大学涉外商贸学院', '4150013589', 1);
INSERT INTO `xy_school` VALUES (2165, '重庆工商大学融智学院', '4150013590', 1);
INSERT INTO `xy_school` VALUES (2166, '重庆工商大学派斯学院', '4150013591', 1);
INSERT INTO `xy_school` VALUES (2167, '重庆邮电大学移通学院', '4150013627', 1);
INSERT INTO `xy_school` VALUES (2168, '重庆第二师范学院', '4150014388', 1);
INSERT INTO `xy_school` VALUES (2169, '重庆航天职业技术学院', '4150010870', 1);
INSERT INTO `xy_school` VALUES (2170, '重庆电力高等专科学校', '4150011848', 1);
INSERT INTO `xy_school` VALUES (2171, '重庆工业职业技术学院', '4150012215', 1);
INSERT INTO `xy_school` VALUES (2172, '重庆三峡职业学院', '4150012605', 1);
INSERT INTO `xy_school` VALUES (2173, '重庆工贸职业技术学院', '4150012606', 1);
INSERT INTO `xy_school` VALUES (2174, '重庆电子工程职业学院', '4150012609', 1);
INSERT INTO `xy_school` VALUES (2175, '重庆海联职业技术学院', '4150012754', 1);
INSERT INTO `xy_school` VALUES (2176, '重庆信息技术职业学院', '4150012755', 1);
INSERT INTO `xy_school` VALUES (2177, '重庆传媒职业学院', '4150012756', 1);
INSERT INTO `xy_school` VALUES (2178, '重庆城市管理职业学院', '4150012758', 1);
INSERT INTO `xy_school` VALUES (2179, '重庆工程职业技术学院', '4150012759', 1);
INSERT INTO `xy_school` VALUES (2180, '重庆建筑科技职业学院', '4150012820', 1);
INSERT INTO `xy_school` VALUES (2181, '重庆城市职业学院', '4150013734', 1);
INSERT INTO `xy_school` VALUES (2182, '重庆水利电力职业技术学院', '4150013735', 1);
INSERT INTO `xy_school` VALUES (2183, '重庆工商职业学院', '4150013967', 1);
INSERT INTO `xy_school` VALUES (2184, '重庆应用技术职业学院', '4150013968', 1);
INSERT INTO `xy_school` VALUES (2185, '重庆三峡医药高等专科学校', '4150014008', 1);
INSERT INTO `xy_school` VALUES (2186, '重庆医药高等专科学校', '4150014009', 1);
INSERT INTO `xy_school` VALUES (2187, '重庆青年职业技术学院', '4150014069', 1);
INSERT INTO `xy_school` VALUES (2188, '重庆财经职业学院', '4150014128', 1);
INSERT INTO `xy_school` VALUES (2189, '重庆科创职业学院', '4150014173', 1);
INSERT INTO `xy_school` VALUES (2190, '重庆建筑工程职业学院', '4150014183', 1);
INSERT INTO `xy_school` VALUES (2191, '重庆电讯职业学院', '4150014237', 1);
INSERT INTO `xy_school` VALUES (2192, '重庆能源职业学院', '4150014238', 1);
INSERT INTO `xy_school` VALUES (2193, '重庆商务职业学院', '4150014246', 1);
INSERT INTO `xy_school` VALUES (2194, '重庆交通职业学院', '4150014267', 1);
INSERT INTO `xy_school` VALUES (2195, '重庆化工职业学院', '4150014315', 1);
INSERT INTO `xy_school` VALUES (2196, '重庆旅游职业学院', '4150014316', 1);
INSERT INTO `xy_school` VALUES (2197, '重庆安全技术职业学院', '4150014365', 1);
INSERT INTO `xy_school` VALUES (2198, '重庆公共运输职业学院', '4150014366', 1);
INSERT INTO `xy_school` VALUES (2199, '重庆艺术工程职业学院', '4150014367', 1);
INSERT INTO `xy_school` VALUES (2200, '重庆轻工职业学院', '4150014368', 1);
INSERT INTO `xy_school` VALUES (2201, '重庆电信职业学院', '4150014369', 1);
INSERT INTO `xy_school` VALUES (2202, '重庆经贸职业学院', '4150014370', 1);
INSERT INTO `xy_school` VALUES (2203, '重庆幼儿师范高等专科学校', '4150014428', 1);
INSERT INTO `xy_school` VALUES (2204, '重庆文化艺术职业学院', '4150014482', 1);
INSERT INTO `xy_school` VALUES (2205, '重庆科技职业学院', '4150014491', 1);
INSERT INTO `xy_school` VALUES (2206, '重庆资源与环境保护职业学院', '4150014557', 1);
INSERT INTO `xy_school` VALUES (2207, '重庆护理职业学院', '4150014576', 1);
INSERT INTO `xy_school` VALUES (2208, '重庆理工职业学院', '4150014725', 1);
INSERT INTO `xy_school` VALUES (2209, '重庆智能工程职业学院', '4150014726', 1);
INSERT INTO `xy_school` VALUES (2210, '重庆健康职业学院', '4150014727', 1);
INSERT INTO `xy_school` VALUES (2211, '四川大学', '4151010610', 1);
INSERT INTO `xy_school` VALUES (2212, '西南交通大学', '4151010613', 1);
INSERT INTO `xy_school` VALUES (2213, '电子科技大学', '4151010614', 1);
INSERT INTO `xy_school` VALUES (2214, '西南石油大学', '4151010615', 1);
INSERT INTO `xy_school` VALUES (2215, '成都理工大学', '4151010616', 1);
INSERT INTO `xy_school` VALUES (2216, '西南科技大学', '4151010619', 1);
INSERT INTO `xy_school` VALUES (2217, '成都信息工程大学', '4151010621', 1);
INSERT INTO `xy_school` VALUES (2218, '四川轻化工大学', '4151010622', 1);
INSERT INTO `xy_school` VALUES (2219, '西华大学', '4151010623', 1);
INSERT INTO `xy_school` VALUES (2220, '中国民用航空飞行学院', '4151010624', 1);
INSERT INTO `xy_school` VALUES (2221, '四川农业大学', '4151010626', 1);
INSERT INTO `xy_school` VALUES (2222, '西昌学院', '4151010628', 1);
INSERT INTO `xy_school` VALUES (2223, '西南医科大学', '4151010632', 1);
INSERT INTO `xy_school` VALUES (2224, '成都中医药大学', '4151010633', 1);
INSERT INTO `xy_school` VALUES (2225, '川北医学院', '4151010634', 1);
INSERT INTO `xy_school` VALUES (2226, '四川师范大学', '4151010636', 1);
INSERT INTO `xy_school` VALUES (2227, '西华师范大学', '4151010638', 1);
INSERT INTO `xy_school` VALUES (2228, '绵阳师范学院', '4151010639', 1);
INSERT INTO `xy_school` VALUES (2229, '内江师范学院', '4151010640', 1);
INSERT INTO `xy_school` VALUES (2230, '宜宾学院', '4151010641', 1);
INSERT INTO `xy_school` VALUES (2231, '四川文理学院', '4151010644', 1);
INSERT INTO `xy_school` VALUES (2232, '阿坝师范学院', '4151010646', 1);
INSERT INTO `xy_school` VALUES (2233, '乐山师范学院', '4151010649', 1);
INSERT INTO `xy_school` VALUES (2234, '西南财经大学', '4151010651', 1);
INSERT INTO `xy_school` VALUES (2235, '成都体育学院', '4151010653', 1);
INSERT INTO `xy_school` VALUES (2236, '四川音乐学院', '4151010654', 1);
INSERT INTO `xy_school` VALUES (2237, '西南民族大学', '4151010656', 1);
INSERT INTO `xy_school` VALUES (2238, '成都大学', '4151011079', 1);
INSERT INTO `xy_school` VALUES (2239, '成都工业学院', '4151011116', 1);
INSERT INTO `xy_school` VALUES (2240, '攀枝花学院', '4151011360', 1);
INSERT INTO `xy_school` VALUES (2241, '四川旅游学院', '4151011552', 1);
INSERT INTO `xy_school` VALUES (2242, '四川民族学院', '4151011661', 1);
INSERT INTO `xy_school` VALUES (2243, '四川警察学院', '4151012212', 1);
INSERT INTO `xy_school` VALUES (2244, '成都东软学院', '4151012636', 1);
INSERT INTO `xy_school` VALUES (2245, '成都艺术职业大学', '4151012969', 1);
INSERT INTO `xy_school` VALUES (2246, '电子科技大学成都学院', '4151013665', 1);
INSERT INTO `xy_school` VALUES (2247, '成都理工大学工程技术学院', '4151013668', 1);
INSERT INTO `xy_school` VALUES (2248, '四川传媒学院', '4151013669', 1);
INSERT INTO `xy_school` VALUES (2249, '成都银杏酒店管理学院', '4151013670', 1);
INSERT INTO `xy_school` VALUES (2250, '成都文理学院', '4151013671', 1);
INSERT INTO `xy_school` VALUES (2251, '四川工商学院', '4151013672', 1);
INSERT INTO `xy_school` VALUES (2252, '四川外国语大学成都学院', '4151013673', 1);
INSERT INTO `xy_school` VALUES (2253, '成都医学院', '4151013705', 1);
INSERT INTO `xy_school` VALUES (2254, '四川工业科技学院', '4151013816', 1);
INSERT INTO `xy_school` VALUES (2255, '四川大学锦城学院', '4151013903', 1);
INSERT INTO `xy_school` VALUES (2256, '西南财经大学天府学院', '4151014037', 1);
INSERT INTO `xy_school` VALUES (2257, '四川大学锦江学院', '4151014039', 1);
INSERT INTO `xy_school` VALUES (2258, '四川文化艺术学院', '4151014043', 1);
INSERT INTO `xy_school` VALUES (2259, '西南科技大学城市学院', '4151014045', 1);
INSERT INTO `xy_school` VALUES (2260, '西南交通大学希望学院', '4151014262', 1);
INSERT INTO `xy_school` VALUES (2261, '成都师范学院', '4151014389', 1);
INSERT INTO `xy_school` VALUES (2262, '四川电影电视学院', '4151014410', 1);
INSERT INTO `xy_school` VALUES (2263, '吉利学院', '4111012802', 1);
INSERT INTO `xy_school` VALUES (2264, '成都纺织高等专科学校', '4151011553', 1);
INSERT INTO `xy_school` VALUES (2265, '民办四川天一学院', '4151011841', 1);
INSERT INTO `xy_school` VALUES (2266, '成都航空职业技术学院', '4151012064', 1);
INSERT INTO `xy_school` VALUES (2267, '四川电力职业技术学院', '4151012065', 1);
INSERT INTO `xy_school` VALUES (2268, '成都职业技术学院', '4151012635', 1);
INSERT INTO `xy_school` VALUES (2269, '四川化工职业技术学院', '4151012637', 1);
INSERT INTO `xy_school` VALUES (2270, '四川水利职业技术学院', '4151012638', 1);
INSERT INTO `xy_school` VALUES (2271, '南充职业技术学院', '4151012639', 1);
INSERT INTO `xy_school` VALUES (2272, '内江职业技术学院', '4151012640', 1);
INSERT INTO `xy_school` VALUES (2273, '四川航天职业技术学院', '4151012641', 1);
INSERT INTO `xy_school` VALUES (2274, '四川邮电职业技术学院', '4151012642', 1);
INSERT INTO `xy_school` VALUES (2275, '四川机电职业技术学院', '4151012751', 1);
INSERT INTO `xy_school` VALUES (2276, '绵阳职业技术学院', '4151012753', 1);
INSERT INTO `xy_school` VALUES (2277, '四川交通职业技术学院', '4151012761', 1);
INSERT INTO `xy_school` VALUES (2278, '四川工商职业技术学院', '4151012762', 1);
INSERT INTO `xy_school` VALUES (2279, '四川工程职业技术学院', '4151012763', 1);
INSERT INTO `xy_school` VALUES (2280, '四川建筑职业技术学院', '4151012764', 1);
INSERT INTO `xy_school` VALUES (2281, '达州职业技术学院', '4151012767', 1);
INSERT INTO `xy_school` VALUES (2282, '四川托普信息技术职业学院', '4151012963', 1);
INSERT INTO `xy_school` VALUES (2283, '四川国际标榜职业学院', '4151012964', 1);
INSERT INTO `xy_school` VALUES (2284, '成都农业科技职业学院', '4151012965', 1);
INSERT INTO `xy_school` VALUES (2285, '宜宾职业技术学院', '4151012966', 1);
INSERT INTO `xy_school` VALUES (2286, '泸州职业技术学院', '4151012967', 1);
INSERT INTO `xy_school` VALUES (2287, '眉山职业技术学院', '4151012968', 1);
INSERT INTO `xy_school` VALUES (2288, '四川职业技术学院', '4151012970', 1);
INSERT INTO `xy_school` VALUES (2289, '乐山职业技术学院', '4151013048', 1);
INSERT INTO `xy_school` VALUES (2290, '雅安职业技术学院', '4151013049', 1);
INSERT INTO `xy_school` VALUES (2291, '四川商务职业学院', '4151013812', 1);
INSERT INTO `xy_school` VALUES (2292, '四川司法警官职业学院', '4151013813', 1);
INSERT INTO `xy_school` VALUES (2293, '广安职业技术学院', '4151013814', 1);
INSERT INTO `xy_school` VALUES (2294, '四川信息职业技术学院', '4151013815', 1);
INSERT INTO `xy_school` VALUES (2295, '四川文化传媒职业学院', '4151014004', 1);
INSERT INTO `xy_school` VALUES (2296, '四川华新现代职业学院', '4151014005', 1);
INSERT INTO `xy_school` VALUES (2297, '四川铁道职业学院', '4151014006', 1);
INSERT INTO `xy_school` VALUES (2298, '四川艺术职业学院', '4151014007', 1);
INSERT INTO `xy_school` VALUES (2299, '四川中医药高等专科学校', '4151014010', 1);
INSERT INTO `xy_school` VALUES (2300, '四川科技职业学院', '4151014070', 1);
INSERT INTO `xy_school` VALUES (2301, '四川文化产业职业学院', '4151014086', 1);
INSERT INTO `xy_school` VALUES (2302, '四川财经职业学院', '4151014091', 1);
INSERT INTO `xy_school` VALUES (2303, '四川城市职业学院', '4151014175', 1);
INSERT INTO `xy_school` VALUES (2304, '四川现代职业学院', '4151014176', 1);
INSERT INTO `xy_school` VALUES (2305, '四川幼儿师范高等专科学校', '4151014221', 1);
INSERT INTO `xy_school` VALUES (2306, '四川长江职业学院', '4151014323', 1);
INSERT INTO `xy_school` VALUES (2307, '四川三河职业学院', '4151014386', 1);
INSERT INTO `xy_school` VALUES (2308, '川北幼儿师范高等专科学校', '4151014393', 1);
INSERT INTO `xy_school` VALUES (2309, '四川卫生康复职业学院', '4151014409', 1);
INSERT INTO `xy_school` VALUES (2310, '四川汽车职业技术学院', '4151014411', 1);
INSERT INTO `xy_school` VALUES (2311, '巴中职业技术学院', '4151014483', 1);
INSERT INTO `xy_school` VALUES (2312, '四川希望汽车职业学院', '4151014484', 1);
INSERT INTO `xy_school` VALUES (2313, '四川电子机械职业技术学院', '4151014485', 1);
INSERT INTO `xy_school` VALUES (2314, '四川文轩职业学院', '4151014486', 1);
INSERT INTO `xy_school` VALUES (2315, '川南幼儿师范高等专科学校', '4151014496', 1);
INSERT INTO `xy_school` VALUES (2316, '四川护理职业学院', '4151014513', 1);
INSERT INTO `xy_school` VALUES (2317, '成都工业职业技术学院', '4151014514', 1);
INSERT INTO `xy_school` VALUES (2318, '四川西南航空职业学院', '4151014515', 1);
INSERT INTO `xy_school` VALUES (2319, '成都工贸职业技术学院', '4151014547', 1);
INSERT INTO `xy_school` VALUES (2320, '四川应用技术职业学院', '4151014548', 1);
INSERT INTO `xy_school` VALUES (2321, '西昌民族幼儿师范高等专科学校', '4151014629', 1);
INSERT INTO `xy_school` VALUES (2322, '眉山药科职业学院', '4151014640', 1);
INSERT INTO `xy_school` VALUES (2323, '天府新区信息职业学院', '4151014641', 1);
INSERT INTO `xy_school` VALUES (2324, '德阳城市轨道交通职业学院', '4151014642', 1);
INSERT INTO `xy_school` VALUES (2325, '德阳科贸职业学院', '4151014643', 1);
INSERT INTO `xy_school` VALUES (2326, '江阳城建职业学院', '4151014644', 1);
INSERT INTO `xy_school` VALUES (2327, '天府新区航空旅游职业学院', '4151014645', 1);
INSERT INTO `xy_school` VALUES (2328, '天府新区通用航空职业学院', '4151014646', 1);
INSERT INTO `xy_school` VALUES (2329, '阿坝职业学院', '4151014647', 1);
INSERT INTO `xy_school` VALUES (2330, '达州中医药职业学院', '4151014669', 1);
INSERT INTO `xy_school` VALUES (2331, '内江卫生与健康职业学院', '4151014670', 1);
INSERT INTO `xy_school` VALUES (2332, '南充科技职业学院', '4151014671', 1);
INSERT INTO `xy_school` VALUES (2333, '攀枝花攀西职业学院', '4151014672', 1);
INSERT INTO `xy_school` VALUES (2334, '资阳口腔职业学院', '4151014673', 1);
INSERT INTO `xy_school` VALUES (2335, '资阳环境科技职业学院', '4151014674', 1);
INSERT INTO `xy_school` VALUES (2336, '南充文化旅游职业学院', '4151014728', 1);
INSERT INTO `xy_school` VALUES (2337, '南充电影工业职业学院', '4151014729', 1);
INSERT INTO `xy_school` VALUES (2338, '绵阳飞行职业学院', '4151014730', 1);
INSERT INTO `xy_school` VALUES (2339, '德阳农业科技职业学院', '4151014731', 1);
INSERT INTO `xy_school` VALUES (2340, '泸州医疗器械职业学院', '4151014732', 1);
INSERT INTO `xy_school` VALUES (2341, '广元中核职业技术学院', '4251050881', 1);
INSERT INTO `xy_school` VALUES (2342, '四川体育职业学院', '4251051351', 1);
INSERT INTO `xy_school` VALUES (2343, '贵州大学', '4152010657', 1);
INSERT INTO `xy_school` VALUES (2344, '贵州医科大学', '4152010660', 1);
INSERT INTO `xy_school` VALUES (2345, '遵义医科大学', '4152010661', 1);
INSERT INTO `xy_school` VALUES (2346, '贵州中医药大学', '4152010662', 1);
INSERT INTO `xy_school` VALUES (2347, '贵州师范大学', '4152010663', 1);
INSERT INTO `xy_school` VALUES (2348, '遵义师范学院', '4152010664', 1);
INSERT INTO `xy_school` VALUES (2349, '铜仁学院', '4152010665', 1);
INSERT INTO `xy_school` VALUES (2350, '兴义民族师范学院', '4152010666', 1);
INSERT INTO `xy_school` VALUES (2351, '安顺学院', '4152010667', 1);
INSERT INTO `xy_school` VALUES (2352, '贵州工程应用技术学院', '4152010668', 1);
INSERT INTO `xy_school` VALUES (2353, '凯里学院', '4152010669', 1);
INSERT INTO `xy_school` VALUES (2354, '黔南民族师范学院', '4152010670', 1);
INSERT INTO `xy_school` VALUES (2355, '贵州财经大学', '4152010671', 1);
INSERT INTO `xy_school` VALUES (2356, '贵州民族大学', '4152010672', 1);
INSERT INTO `xy_school` VALUES (2357, '贵阳学院', '4152010976', 1);
INSERT INTO `xy_school` VALUES (2358, '六盘水师范学院', '4152010977', 1);
INSERT INTO `xy_school` VALUES (2359, '贵州商学院', '4152011731', 1);
INSERT INTO `xy_school` VALUES (2360, '贵州警察学院', '4152012107', 1);
INSERT INTO `xy_school` VALUES (2361, '贵州中医药大学时珍学院', '4152013647', 1);
INSERT INTO `xy_school` VALUES (2362, '贵州财经大学商务学院', '4152013648', 1);
INSERT INTO `xy_school` VALUES (2363, '贵州大学科技学院', '4152013649', 1);
INSERT INTO `xy_school` VALUES (2364, '贵州大学明德学院', '4152013650', 1);
INSERT INTO `xy_school` VALUES (2365, '贵州民族大学人文科技学院', '4152013651', 1);
INSERT INTO `xy_school` VALUES (2366, '贵州师范大学求是学院', '4152013652', 1);
INSERT INTO `xy_school` VALUES (2367, '遵义医科大学医学与科技学院', '4152013653', 1);
INSERT INTO `xy_school` VALUES (2368, '贵州医科大学神奇民族医药学院', '4152013676', 1);
INSERT INTO `xy_school` VALUES (2369, '贵州师范学院', '4152014223', 1);
INSERT INTO `xy_school` VALUES (2370, '贵州理工学院', '4152014440', 1);
INSERT INTO `xy_school` VALUES (2371, '茅台学院', '4152014625', 1);
INSERT INTO `xy_school` VALUES (2372, '黔南民族医学高等专科学校', '4152011663', 1);
INSERT INTO `xy_school` VALUES (2373, '贵州交通职业技术学院', '4152012222', 1);
INSERT INTO `xy_school` VALUES (2374, '贵州航天职业技术学院', '4152012223', 1);
INSERT INTO `xy_school` VALUES (2375, '贵州电子信息职业技术学院', '4152012336', 1);
INSERT INTO `xy_school` VALUES (2376, '安顺职业技术学院', '4152012821', 1);
INSERT INTO `xy_school` VALUES (2377, '黔东南民族职业技术学院', '4152012822', 1);
INSERT INTO `xy_school` VALUES (2378, '黔南民族职业技术学院', '4152012823', 1);
INSERT INTO `xy_school` VALUES (2379, '遵义职业技术学院', '4152012824', 1);
INSERT INTO `xy_school` VALUES (2380, '贵州城市职业学院', '4152012850', 1);
INSERT INTO `xy_school` VALUES (2381, '贵州工业职业技术学院', '4152013052', 1);
INSERT INTO `xy_school` VALUES (2382, '贵州电力职业技术学院', '4152013053', 1);
INSERT INTO `xy_school` VALUES (2383, '六盘水职业技术学院', '4152013054', 1);
INSERT INTO `xy_school` VALUES (2384, '铜仁职业技术学院', '4152013055', 1);
INSERT INTO `xy_school` VALUES (2385, '黔西南民族职业技术学院', '4152013817', 1);
INSERT INTO `xy_school` VALUES (2386, '贵州轻工职业技术学院', '4152013818', 1);
INSERT INTO `xy_school` VALUES (2387, '遵义医药高等专科学校', '4152014011', 1);
INSERT INTO `xy_school` VALUES (2388, '贵阳护理职业学院', '4152014083', 1);
INSERT INTO `xy_school` VALUES (2389, '贵阳职业技术学院', '4152014129', 1);
INSERT INTO `xy_school` VALUES (2390, '毕节职业技术学院', '4152014198', 1);
INSERT INTO `xy_school` VALUES (2391, '贵州职业技术学院', '4152014252', 1);
INSERT INTO `xy_school` VALUES (2392, '贵州盛华职业学院', '4152014371', 1);
INSERT INTO `xy_school` VALUES (2393, '贵州工商职业学院', '4152014412', 1);
INSERT INTO `xy_school` VALUES (2394, '贵阳幼儿师范高等专科学校', '4152014469', 1);
INSERT INTO `xy_school` VALUES (2395, '铜仁幼儿师范高等专科学校', '4152014470', 1);
INSERT INTO `xy_school` VALUES (2396, '黔南民族幼儿师范高等专科学校', '4152014497', 1);
INSERT INTO `xy_school` VALUES (2397, '毕节医学高等专科学校', '4152014499', 1);
INSERT INTO `xy_school` VALUES (2398, '贵州建设职业技术学院', '4152014516', 1);
INSERT INTO `xy_school` VALUES (2399, '毕节幼儿师范高等专科学校', '4152014538', 1);
INSERT INTO `xy_school` VALUES (2400, '贵州农业职业学院', '4152014549', 1);
INSERT INTO `xy_school` VALUES (2401, '贵州工程职业学院', '4152014558', 1);
INSERT INTO `xy_school` VALUES (2402, '贵州工贸职业学院', '4152014559', 1);
INSERT INTO `xy_school` VALUES (2403, '贵州水利水电职业技术学院', '4152014577', 1);
INSERT INTO `xy_school` VALUES (2404, '贵州电子商务职业技术学院', '4152014578', 1);
INSERT INTO `xy_school` VALUES (2405, '贵州应用技术职业学院', '4152014579', 1);
INSERT INTO `xy_school` VALUES (2406, '贵州电子科技职业学院', '4152014580', 1);
INSERT INTO `xy_school` VALUES (2407, '贵州装备制造职业学院', '4152014613', 1);
INSERT INTO `xy_school` VALUES (2408, '贵州健康职业学院', '4152014614', 1);
INSERT INTO `xy_school` VALUES (2409, '贵州食品工程职业学院', '4152014615', 1);
INSERT INTO `xy_school` VALUES (2410, '贵州经贸职业技术学院', '4152014616', 1);
INSERT INTO `xy_school` VALUES (2411, '贵州护理职业技术学院', '4152014617', 1);
INSERT INTO `xy_school` VALUES (2412, '六盘水幼儿师范高等专科学校', '4152014630', 1);
INSERT INTO `xy_school` VALUES (2413, '毕节工业职业技术学院', '4152014648', 1);
INSERT INTO `xy_school` VALUES (2414, '贵州机电职业技术学院', '4152014733', 1);
INSERT INTO `xy_school` VALUES (2415, '贵州财经职业学院', '4152014734', 1);
INSERT INTO `xy_school` VALUES (2416, '贵州民用航空职业学院', '4152014735', 1);
INSERT INTO `xy_school` VALUES (2417, '贵州航空职业技术学院', '4252050963', 1);
INSERT INTO `xy_school` VALUES (2418, '云南大学', '4153010673', 1);
INSERT INTO `xy_school` VALUES (2419, '昆明理工大学', '4153010674', 1);
INSERT INTO `xy_school` VALUES (2420, '云南农业大学', '4153010676', 1);
INSERT INTO `xy_school` VALUES (2421, '西南林业大学', '4153010677', 1);
INSERT INTO `xy_school` VALUES (2422, '昆明医科大学', '4153010678', 1);
INSERT INTO `xy_school` VALUES (2423, '大理大学', '4153010679', 1);
INSERT INTO `xy_school` VALUES (2424, '云南中医药大学', '4153010680', 1);
INSERT INTO `xy_school` VALUES (2425, '云南师范大学', '4153010681', 1);
INSERT INTO `xy_school` VALUES (2426, '昭通学院', '4153010683', 1);
INSERT INTO `xy_school` VALUES (2427, '曲靖师范学院', '4153010684', 1);
INSERT INTO `xy_school` VALUES (2428, '普洱学院', '4153010685', 1);
INSERT INTO `xy_school` VALUES (2429, '保山学院', '4153010686', 1);
INSERT INTO `xy_school` VALUES (2430, '红河学院', '4153010687', 1);
INSERT INTO `xy_school` VALUES (2431, '云南财经大学', '4153010689', 1);
INSERT INTO `xy_school` VALUES (2432, '云南艺术学院', '4153010690', 1);
INSERT INTO `xy_school` VALUES (2433, '云南民族大学', '4153010691', 1);
INSERT INTO `xy_school` VALUES (2434, '玉溪师范学院', '4153011390', 1);
INSERT INTO `xy_school` VALUES (2435, '楚雄师范学院', '4153011391', 1);
INSERT INTO `xy_school` VALUES (2436, '云南警官学院', '4153011392', 1);
INSERT INTO `xy_school` VALUES (2437, '昆明学院', '4153011393', 1);
INSERT INTO `xy_school` VALUES (2438, '文山学院', '4153011556', 1);
INSERT INTO `xy_school` VALUES (2439, '云南经济管理学院', '4153012560', 1);
INSERT INTO `xy_school` VALUES (2440, '云南大学滇池学院', '4153013326', 1);
INSERT INTO `xy_school` VALUES (2441, '云南大学旅游文化学院', '4153013328', 1);
INSERT INTO `xy_school` VALUES (2442, '昆明理工大学津桥学院', '4153013329', 1);
INSERT INTO `xy_school` VALUES (2443, '云南师范大学商学院', '4153013330', 1);
INSERT INTO `xy_school` VALUES (2444, '云南师范大学文理学院', '4153013331', 1);
INSERT INTO `xy_school` VALUES (2445, '昆明医科大学海源学院', '4153013332', 1);
INSERT INTO `xy_school` VALUES (2446, '云南艺术学院文华学院', '4153013333', 1);
INSERT INTO `xy_school` VALUES (2447, '云南工商学院', '4153013909', 1);
INSERT INTO `xy_school` VALUES (2448, '滇西科技师范学院', '4153014092', 1);
INSERT INTO `xy_school` VALUES (2449, '滇西应用技术大学', '4153014623', 1);
INSERT INTO `xy_school` VALUES (2450, '昆明冶金高等专科学校', '4153011557', 1);
INSERT INTO `xy_school` VALUES (2451, '云南国土资源职业学院', '4153012349', 1);
INSERT INTO `xy_school` VALUES (2452, '云南交通职业技术学院', '4153012357', 1);
INSERT INTO `xy_school` VALUES (2453, '昆明工业职业技术学院', '4153012393', 1);
INSERT INTO `xy_school` VALUES (2454, '云南农业职业技术学院', '4153012555', 1);
INSERT INTO `xy_school` VALUES (2455, '云南司法警官职业学院', '4153012556', 1);
INSERT INTO `xy_school` VALUES (2456, '云南文化艺术职业学院', '4153012558', 1);
INSERT INTO `xy_school` VALUES (2457, '云南体育运动职业技术学院', '4153012559', 1);
INSERT INTO `xy_school` VALUES (2458, '云南科技信息职业学院', '4153012825', 1);
INSERT INTO `xy_school` VALUES (2459, '西双版纳职业技术学院', '4153012826', 1);
INSERT INTO `xy_school` VALUES (2460, '昆明艺术职业学院', '4153012851', 1);
INSERT INTO `xy_school` VALUES (2461, '玉溪农业职业技术学院', '4153012971', 1);
INSERT INTO `xy_school` VALUES (2462, '云南能源职业技术学院', '4153013136', 1);
INSERT INTO `xy_school` VALUES (2463, '云南国防工业职业技术学院', '4153013756', 1);
INSERT INTO `xy_school` VALUES (2464, '云南机电职业技术学院', '4153013757', 1);
INSERT INTO `xy_school` VALUES (2465, '云南林业职业技术学院', '4153013758', 1);
INSERT INTO `xy_school` VALUES (2466, '云南城市建设职业学院', '4153013759', 1);
INSERT INTO `xy_school` VALUES (2467, '云南工程职业学院', '4153013761', 1);
INSERT INTO `xy_school` VALUES (2468, '曲靖医学高等专科学校', '4153014012', 1);
INSERT INTO `xy_school` VALUES (2469, '楚雄医药高等专科学校', '4153014013', 1);
INSERT INTO `xy_school` VALUES (2470, '保山中医药高等专科学校', '4153014014', 1);
INSERT INTO `xy_school` VALUES (2471, '丽江师范高等专科学校', '4153014015', 1);
INSERT INTO `xy_school` VALUES (2472, '德宏师范高等专科学校', '4153014016', 1);
INSERT INTO `xy_school` VALUES (2473, '云南新兴职业学院', '4153014032', 1);
INSERT INTO `xy_school` VALUES (2474, '云南锡业职业技术学院', '4153014130', 1);
INSERT INTO `xy_school` VALUES (2475, '云南经贸外事职业学院', '4153014212', 1);
INSERT INTO `xy_school` VALUES (2476, '云南三鑫职业技术学院', '4153014239', 1);
INSERT INTO `xy_school` VALUES (2477, '德宏职业学院', '4153014253', 1);
INSERT INTO `xy_school` VALUES (2478, '云南商务职业学院', '4153014317', 1);
INSERT INTO `xy_school` VALUES (2479, '昆明卫生职业学院', '4153014372', 1);
INSERT INTO `xy_school` VALUES (2480, '云南现代职业技术学院', '4153014373', 1);
INSERT INTO `xy_school` VALUES (2481, '云南旅游职业学院', '4153014381', 1);
INSERT INTO `xy_school` VALUES (2482, '红河卫生职业学院', '4153014413', 1);
INSERT INTO `xy_school` VALUES (2483, '云南外事外语职业学院', '4153014415', 1);
INSERT INTO `xy_school` VALUES (2484, '大理农林职业技术学院', '4153014487', 1);
INSERT INTO `xy_school` VALUES (2485, '公安消防部队高等专科学校', '4153014534', 1);
INSERT INTO `xy_school` VALUES (2486, '云南财经职业学院', '4153014550', 1);
INSERT INTO `xy_school` VALUES (2487, '昆明铁道职业技术学院', '4153014581', 1);
INSERT INTO `xy_school` VALUES (2488, '昭通卫生职业学院', '4153014582', 1);
INSERT INTO `xy_school` VALUES (2489, '大理护理职业学院', '4153014583', 1);
INSERT INTO `xy_school` VALUES (2490, '云南水利水电职业学院', '4153014584', 1);
INSERT INTO `xy_school` VALUES (2491, '云南轻纺职业学院', '4153014618', 1);
INSERT INTO `xy_school` VALUES (2492, '云南特殊教育职业学院', '4153014619', 1);
INSERT INTO `xy_school` VALUES (2493, '云南工贸职业技术学院', '4153014620', 1);
INSERT INTO `xy_school` VALUES (2494, '云南交通运输职业学院', '4153014621', 1);
INSERT INTO `xy_school` VALUES (2495, '昆明幼儿师范高等专科学校', '4153014631', 1);
INSERT INTO `xy_school` VALUES (2496, '云南医药健康职业学院', '4153014649', 1);
INSERT INTO `xy_school` VALUES (2497, '云南理工职业学院', '4153014675', 1);
INSERT INTO `xy_school` VALUES (2498, '曲靖职业技术学院', '4153014676', 1);
INSERT INTO `xy_school` VALUES (2499, '红河职业技术学院', '4153014736', 1);
INSERT INTO `xy_school` VALUES (2500, '西藏农牧学院', '4154010693', 1);
INSERT INTO `xy_school` VALUES (2501, '西藏大学', '4154010694', 1);
INSERT INTO `xy_school` VALUES (2502, '西藏民族大学', '4154010695', 1);
INSERT INTO `xy_school` VALUES (2503, '西藏藏医药大学', '4154010696', 1);
INSERT INTO `xy_school` VALUES (2504, '西藏警官高等专科学校', '4154010692', 1);
INSERT INTO `xy_school` VALUES (2505, '拉萨师范高等专科学校', '4154012481', 1);
INSERT INTO `xy_school` VALUES (2506, '西藏职业技术学院', '4154014085', 1);
INSERT INTO `xy_school` VALUES (2507, '西北大学', '4161010697', 1);
INSERT INTO `xy_school` VALUES (2508, '西安交通大学', '4161010698', 1);
INSERT INTO `xy_school` VALUES (2509, '西北工业大学', '4161010699', 1);
INSERT INTO `xy_school` VALUES (2510, '西安理工大学', '4161010700', 1);
INSERT INTO `xy_school` VALUES (2511, '西安电子科技大学', '4161010701', 1);
INSERT INTO `xy_school` VALUES (2512, '西安工业大学', '4161010702', 1);
INSERT INTO `xy_school` VALUES (2513, '西安建筑科技大学', '4161010703', 1);
INSERT INTO `xy_school` VALUES (2514, '西安科技大学', '4161010704', 1);
INSERT INTO `xy_school` VALUES (2515, '西安石油大学', '4161010705', 1);
INSERT INTO `xy_school` VALUES (2516, '陕西科技大学', '4161010708', 1);
INSERT INTO `xy_school` VALUES (2517, '西安工程大学', '4161010709', 1);
INSERT INTO `xy_school` VALUES (2518, '长安大学', '4161010710', 1);
INSERT INTO `xy_school` VALUES (2519, '西北农林科技大学', '4161010712', 1);
INSERT INTO `xy_school` VALUES (2520, '陕西中医药大学', '4161010716', 1);
INSERT INTO `xy_school` VALUES (2521, '陕西师范大学', '4161010718', 1);
INSERT INTO `xy_school` VALUES (2522, '延安大学', '4161010719', 1);
INSERT INTO `xy_school` VALUES (2523, '陕西理工大学', '4161010720', 1);
INSERT INTO `xy_school` VALUES (2524, '宝鸡文理学院', '4161010721', 1);
INSERT INTO `xy_school` VALUES (2525, '咸阳师范学院', '4161010722', 1);
INSERT INTO `xy_school` VALUES (2526, '渭南师范学院', '4161010723', 1);
INSERT INTO `xy_school` VALUES (2527, '西安外国语大学', '4161010724', 1);
INSERT INTO `xy_school` VALUES (2528, '西北政法大学', '4161010726', 1);
INSERT INTO `xy_school` VALUES (2529, '西安体育学院', '4161010727', 1);
INSERT INTO `xy_school` VALUES (2530, '西安音乐学院', '4161010728', 1);
INSERT INTO `xy_school` VALUES (2531, '西安美术学院', '4161010729', 1);
INSERT INTO `xy_school` VALUES (2532, '西安文理学院', '4161011080', 1);
INSERT INTO `xy_school` VALUES (2533, '榆林学院', '4161011395', 1);
INSERT INTO `xy_school` VALUES (2534, '商洛学院', '4161011396', 1);
INSERT INTO `xy_school` VALUES (2535, '安康学院', '4161011397', 1);
INSERT INTO `xy_school` VALUES (2536, '西安培华学院', '4161011400', 1);
INSERT INTO `xy_school` VALUES (2537, '西安财经大学', '4161011560', 1);
INSERT INTO `xy_school` VALUES (2538, '西安邮电大学', '4161011664', 1);
INSERT INTO `xy_school` VALUES (2539, '西安航空学院', '4161011736', 1);
INSERT INTO `xy_school` VALUES (2540, '西安医学院', '4161011840', 1);
INSERT INTO `xy_school` VALUES (2541, '西安欧亚学院', '4161012712', 1);
INSERT INTO `xy_school` VALUES (2542, '西安外事学院', '4161012713', 1);
INSERT INTO `xy_school` VALUES (2543, '西安翻译学院', '4161012714', 1);
INSERT INTO `xy_school` VALUES (2544, '西京学院', '4161012715', 1);
INSERT INTO `xy_school` VALUES (2545, '西安思源学院', '4161013121', 1);
INSERT INTO `xy_school` VALUES (2546, '陕西国际商贸学院', '4161013123', 1);
INSERT INTO `xy_school` VALUES (2547, '陕西服装工程学院', '4161013125', 1);
INSERT INTO `xy_school` VALUES (2548, '西安交通工程学院', '4161013569', 1);
INSERT INTO `xy_school` VALUES (2549, '西安交通大学城市学院', '4161013677', 1);
INSERT INTO `xy_school` VALUES (2550, '西北大学现代学院', '4161013678', 1);
INSERT INTO `xy_school` VALUES (2551, '西安建筑科技大学华清学院', '4161013679', 1);
INSERT INTO `xy_school` VALUES (2552, '西安财经大学行知学院', '4161013680', 1);
INSERT INTO `xy_school` VALUES (2553, '陕西科技大学镐京学院', '4161013681', 1);
INSERT INTO `xy_school` VALUES (2554, '西安工商学院', '4161013682', 1);
INSERT INTO `xy_school` VALUES (2555, '延安大学西安创新学院', '4161013683', 1);
INSERT INTO `xy_school` VALUES (2556, '西安电子科技大学长安学院', '4161013685', 1);
INSERT INTO `xy_school` VALUES (2557, '西安汽车职业大学', '4161013738', 1);
INSERT INTO `xy_school` VALUES (2558, '西安明德理工学院', '4161013894', 1);
INSERT INTO `xy_school` VALUES (2559, '西安信息职业大学', '4161014030', 1);
INSERT INTO `xy_school` VALUES (2560, '长安大学兴华学院', '4161014034', 1);
INSERT INTO `xy_school` VALUES (2561, '西安理工大学高科学院', '4161014041', 1);
INSERT INTO `xy_school` VALUES (2562, '西安科技大学高新学院', '4161014042', 1);
INSERT INTO `xy_school` VALUES (2563, '陕西学前师范学院', '4161014390', 1);
INSERT INTO `xy_school` VALUES (2564, '陕西工业职业技术学院', '4161010828', 1);
INSERT INTO `xy_school` VALUES (2565, '杨凌职业技术学院', '4161010966', 1);
INSERT INTO `xy_school` VALUES (2566, '西安电力高等专科学校', '4161011826', 1);
INSERT INTO `xy_school` VALUES (2567, '陕西能源职业技术学院', '4161012510', 1);
INSERT INTO `xy_school` VALUES (2568, '陕西国防工业职业技术学院', '4161012827', 1);
INSERT INTO `xy_school` VALUES (2569, '西安航空职业技术学院', '4161012828', 1);
INSERT INTO `xy_school` VALUES (2570, '陕西财经职业技术学院', '4161012829', 1);
INSERT INTO `xy_school` VALUES (2571, '陕西交通职业技术学院', '4161012830', 1);
INSERT INTO `xy_school` VALUES (2572, '陕西职业技术学院', '4161012831', 1);
INSERT INTO `xy_school` VALUES (2573, '西安高新科技职业学院', '4161013122', 1);
INSERT INTO `xy_school` VALUES (2574, '西安城市建设职业学院', '4161013124', 1);
INSERT INTO `xy_school` VALUES (2575, '陕西铁路工程职业技术学院', '4161013566', 1);
INSERT INTO `xy_school` VALUES (2576, '宝鸡职业技术学院', '4161013567', 1);
INSERT INTO `xy_school` VALUES (2577, '陕西航空职业技术学院', '4161013568', 1);
INSERT INTO `xy_school` VALUES (2578, '陕西电子信息职业技术学院', '4161013570', 1);
INSERT INTO `xy_school` VALUES (2579, '陕西邮电职业技术学院', '4161013736', 1);
INSERT INTO `xy_school` VALUES (2580, '西安海棠职业学院', '4161013737', 1);
INSERT INTO `xy_school` VALUES (2581, '西安健康工程职业学院', '4161013739', 1);
INSERT INTO `xy_school` VALUES (2582, '陕西警官职业学院', '4161013819', 1);
INSERT INTO `xy_school` VALUES (2583, '陕西经济管理职业技术学院', '4161013932', 1);
INSERT INTO `xy_school` VALUES (2584, '西安铁路职业技术学院', '4161013945', 1);
INSERT INTO `xy_school` VALUES (2585, '咸阳职业技术学院', '4161013946', 1);
INSERT INTO `xy_school` VALUES (2586, '西安职业技术学院', '4161013947', 1);
INSERT INTO `xy_school` VALUES (2587, '商洛职业技术学院', '4161013948', 1);
INSERT INTO `xy_school` VALUES (2588, '汉中职业技术学院', '4161013949', 1);
INSERT INTO `xy_school` VALUES (2589, '延安职业技术学院', '4161013950', 1);
INSERT INTO `xy_school` VALUES (2590, '渭南职业技术学院', '4161013951', 1);
INSERT INTO `xy_school` VALUES (2591, '安康职业技术学院', '4161013952', 1);
INSERT INTO `xy_school` VALUES (2592, '铜川职业技术学院', '4161013953', 1);
INSERT INTO `xy_school` VALUES (2593, '陕西青年职业学院', '4161014028', 1);
INSERT INTO `xy_school` VALUES (2594, '陕西工商职业学院', '4161014029', 1);
INSERT INTO `xy_school` VALUES (2595, '陕西旅游烹饪职业学院', '4161014031', 1);
INSERT INTO `xy_school` VALUES (2596, '西安医学高等专科学校', '4161014222', 1);
INSERT INTO `xy_school` VALUES (2597, '榆林职业技术学院', '4161014318', 1);
INSERT INTO `xy_school` VALUES (2598, '陕西艺术职业学院', '4161014488', 1);
INSERT INTO `xy_school` VALUES (2599, '神木职业技术学院', '4161014650', 1);
INSERT INTO `xy_school` VALUES (2600, '宝鸡三和职业学院', '4161014651', 1);
INSERT INTO `xy_school` VALUES (2601, '榆林能源科技职业学院', '4161014737', 1);
INSERT INTO `xy_school` VALUES (2602, '陕西机电职业技术学院', '4261050084', 1);
INSERT INTO `xy_school` VALUES (2603, '兰州大学', '4162010730', 1);
INSERT INTO `xy_school` VALUES (2604, '兰州理工大学', '4162010731', 1);
INSERT INTO `xy_school` VALUES (2605, '兰州交通大学', '4162010732', 1);
INSERT INTO `xy_school` VALUES (2606, '甘肃农业大学', '4162010733', 1);
INSERT INTO `xy_school` VALUES (2607, '甘肃中医药大学', '4162010735', 1);
INSERT INTO `xy_school` VALUES (2608, '西北师范大学', '4162010736', 1);
INSERT INTO `xy_school` VALUES (2609, '兰州城市学院', '4162010737', 1);
INSERT INTO `xy_school` VALUES (2610, '陇东学院', '4162010738', 1);
INSERT INTO `xy_school` VALUES (2611, '天水师范学院', '4162010739', 1);
INSERT INTO `xy_school` VALUES (2612, '河西学院', '4162010740', 1);
INSERT INTO `xy_school` VALUES (2613, '兰州财经大学', '4162010741', 1);
INSERT INTO `xy_school` VALUES (2614, '西北民族大学', '4162010742', 1);
INSERT INTO `xy_school` VALUES (2615, '甘肃政法大学', '4162011406', 1);
INSERT INTO `xy_school` VALUES (2616, '甘肃民族师范学院', '4162011561', 1);
INSERT INTO `xy_school` VALUES (2617, '兰州文理学院', '4162011562', 1);
INSERT INTO `xy_school` VALUES (2618, '甘肃医学院', '4162011805', 1);
INSERT INTO `xy_school` VALUES (2619, '兰州工业学院', '4162011807', 1);
INSERT INTO `xy_school` VALUES (2620, '西北师范大学知行学院', '4162013510', 1);
INSERT INTO `xy_school` VALUES (2621, '兰州财经大学陇桥学院', '4162013511', 1);
INSERT INTO `xy_school` VALUES (2622, '兰州财经大学长青学院', '4162013512', 1);
INSERT INTO `xy_school` VALUES (2623, '兰州交通大学博文学院', '4162013514', 1);
INSERT INTO `xy_school` VALUES (2624, '兰州理工大学技术工程学院', '4162013515', 1);
INSERT INTO `xy_school` VALUES (2625, '兰州石化职业技术学院', '4162010838', 1);
INSERT INTO `xy_school` VALUES (2626, '陇南师范高等专科学校', '4162011806', 1);
INSERT INTO `xy_school` VALUES (2627, '定西师范高等专科学校', '4162011808', 1);
INSERT INTO `xy_school` VALUES (2628, '甘肃建筑职业技术学院', '4162012511', 1);
INSERT INTO `xy_school` VALUES (2629, '酒泉职业技术学院', '4162012539', 1);
INSERT INTO `xy_school` VALUES (2630, '兰州外语职业学院', '4162012832', 1);
INSERT INTO `xy_school` VALUES (2631, '兰州职业技术学院', '4162012833', 1);
INSERT INTO `xy_school` VALUES (2632, '甘肃警察职业学院', '4162012834', 1);
INSERT INTO `xy_school` VALUES (2633, '甘肃林业职业技术学院', '4162012835', 1);
INSERT INTO `xy_school` VALUES (2634, '甘肃工业职业技术学院', '4162012836', 1);
INSERT INTO `xy_school` VALUES (2635, '武威职业学院', '4162013518', 1);
INSERT INTO `xy_school` VALUES (2636, '甘肃交通职业技术学院', '4162013519', 1);
INSERT INTO `xy_school` VALUES (2637, '兰州资源环境职业技术学院', '4162013933', 1);
INSERT INTO `xy_school` VALUES (2638, '甘肃农业职业技术学院', '4162013954', 1);
INSERT INTO `xy_school` VALUES (2639, '甘肃畜牧工程职业技术学院', '4162013955', 1);
INSERT INTO `xy_school` VALUES (2640, '甘肃钢铁职业技术学院', '4162014131', 1);
INSERT INTO `xy_school` VALUES (2641, '甘肃机电职业技术学院', '4162014319', 1);
INSERT INTO `xy_school` VALUES (2642, '甘肃有色冶金职业技术学院', '4162014375', 1);
INSERT INTO `xy_school` VALUES (2643, '白银矿冶职业技术学院', '4162014376', 1);
INSERT INTO `xy_school` VALUES (2644, '甘肃卫生职业学院', '4162014517', 1);
INSERT INTO `xy_school` VALUES (2645, '兰州科技职业学院', '4162014518', 1);
INSERT INTO `xy_school` VALUES (2646, '庆阳职业技术学院', '4162014551', 1);
INSERT INTO `xy_school` VALUES (2647, '临夏现代职业学院', '4162014552', 1);
INSERT INTO `xy_school` VALUES (2648, '甘肃能源化工职业学院', '4162014593', 1);
INSERT INTO `xy_school` VALUES (2649, '兰州现代职业学院', '4162014594', 1);
INSERT INTO `xy_school` VALUES (2650, '平凉职业技术学院', '4162014595', 1);
INSERT INTO `xy_school` VALUES (2651, '培黎职业学院', '4162014738', 1);
INSERT INTO `xy_school` VALUES (2652, '甘肃财贸职业学院', '4262051378', 1);
INSERT INTO `xy_school` VALUES (2653, '青海大学', '4163010743', 1);
INSERT INTO `xy_school` VALUES (2654, '青海师范大学', '4163010746', 1);
INSERT INTO `xy_school` VALUES (2655, '青海民族大学', '4163010748', 1);
INSERT INTO `xy_school` VALUES (2656, '青海大学昆仑学院', '4163013674', 1);
INSERT INTO `xy_school` VALUES (2657, '青海卫生职业技术学院', '4163012562', 1);
INSERT INTO `xy_school` VALUES (2658, '青海警官职业学院', '4163012852', 1);
INSERT INTO `xy_school` VALUES (2659, '青海畜牧兽医职业技术学院', '4163012972', 1);
INSERT INTO `xy_school` VALUES (2660, '青海交通职业技术学院', '4163012973', 1);
INSERT INTO `xy_school` VALUES (2661, '青海建筑职业技术学院', '4163012974', 1);
INSERT INTO `xy_school` VALUES (2662, '西宁城市职业技术学院', '4163014519', 1);
INSERT INTO `xy_school` VALUES (2663, '青海高等职业技术学院', '4163014520', 1);
INSERT INTO `xy_school` VALUES (2664, '青海柴达木职业技术学院', '4163014521', 1);
INSERT INTO `xy_school` VALUES (2665, '宁夏大学', '4164010749', 1);
INSERT INTO `xy_school` VALUES (2666, '宁夏医科大学', '4164010752', 1);
INSERT INTO `xy_school` VALUES (2667, '宁夏师范学院', '4164010753', 1);
INSERT INTO `xy_school` VALUES (2668, '北方民族大学', '4164011407', 1);
INSERT INTO `xy_school` VALUES (2669, '宁夏理工学院', '4164012544', 1);
INSERT INTO `xy_school` VALUES (2670, '宁夏大学新华学院', '4164013325', 1);
INSERT INTO `xy_school` VALUES (2671, '银川能源学院', '4164013820', 1);
INSERT INTO `xy_school` VALUES (2672, '中国矿业大学银川学院', '4164014200', 1);
INSERT INTO `xy_school` VALUES (2673, '宁夏民族职业技术学院', '4164012716', 1);
INSERT INTO `xy_school` VALUES (2674, '宁夏工业职业学院', '4164012837', 1);
INSERT INTO `xy_school` VALUES (2675, '宁夏职业技术学院', '4164013086', 1);
INSERT INTO `xy_school` VALUES (2676, '宁夏工商职业技术学院', '4164013087', 1);
INSERT INTO `xy_school` VALUES (2677, '宁夏财经职业技术学院', '4164013088', 1);
INSERT INTO `xy_school` VALUES (2678, '宁夏警官职业学院', '4164013089', 1);
INSERT INTO `xy_school` VALUES (2679, '宁夏建设职业技术学院', '4164013151', 1);
INSERT INTO `xy_school` VALUES (2680, '宁夏葡萄酒与防沙治沙职业技术学院', '4164014377', 1);
INSERT INTO `xy_school` VALUES (2681, '宁夏幼儿师范高等专科学校', '4164014498', 1);
INSERT INTO `xy_school` VALUES (2682, '宁夏艺术职业学院', '4164014522', 1);
INSERT INTO `xy_school` VALUES (2683, '宁夏体育职业学院', '4164014624', 1);
INSERT INTO `xy_school` VALUES (2684, '石嘴山工贸职业技术学院', '4164014739', 1);
INSERT INTO `xy_school` VALUES (2685, '新疆大学', '4165010755', 1);
INSERT INTO `xy_school` VALUES (2686, '塔里木大学', '4165010757', 1);
INSERT INTO `xy_school` VALUES (2687, '新疆农业大学', '4165010758', 1);
INSERT INTO `xy_school` VALUES (2688, '石河子大学', '4165010759', 1);
INSERT INTO `xy_school` VALUES (2689, '新疆医科大学', '4165010760', 1);
INSERT INTO `xy_school` VALUES (2690, '新疆师范大学', '4165010762', 1);
INSERT INTO `xy_school` VALUES (2691, '喀什大学', '4165010763', 1);
INSERT INTO `xy_school` VALUES (2692, '伊犁师范大学', '4165010764', 1);
INSERT INTO `xy_school` VALUES (2693, '新疆财经大学', '4165010766', 1);
INSERT INTO `xy_school` VALUES (2694, '新疆艺术学院', '4165010768', 1);
INSERT INTO `xy_school` VALUES (2695, '新疆工程学院', '4165010994', 1);
INSERT INTO `xy_school` VALUES (2696, '昌吉学院', '4165010997', 1);
INSERT INTO `xy_school` VALUES (2697, '新疆警察学院', '4165012734', 1);
INSERT INTO `xy_school` VALUES (2698, '新疆理工学院', '4165013558', 1);
INSERT INTO `xy_school` VALUES (2699, '新疆农业大学科学技术学院', '4165013559', 1);
INSERT INTO `xy_school` VALUES (2700, '新疆医科大学厚博学院', '4165013560', 1);
INSERT INTO `xy_school` VALUES (2701, '新疆科技学院', '4165013561', 1);
INSERT INTO `xy_school` VALUES (2702, '石河子大学科技学院', '4165013628', 1);
INSERT INTO `xy_school` VALUES (2703, '新疆天山职业技术大学', '4165013727', 1);
INSERT INTO `xy_school` VALUES (2704, '和田师范专科学校', '4165010765', 1);
INSERT INTO `xy_school` VALUES (2705, '新疆农业职业技术学院', '4165010995', 1);
INSERT INTO `xy_school` VALUES (2706, '乌鲁木齐职业大学', '4165011565', 1);
INSERT INTO `xy_school` VALUES (2707, '新疆维吾尔医学专科学校', '4165011818', 1);
INSERT INTO `xy_school` VALUES (2708, '克拉玛依职业技术学院', '4165012482', 1);
INSERT INTO `xy_school` VALUES (2709, '新疆机电职业技术学院', '4165012513', 1);
INSERT INTO `xy_school` VALUES (2710, '新疆轻工职业技术学院', '4165012514', 1);
INSERT INTO `xy_school` VALUES (2711, '新疆能源职业技术学院', '4165012570', 1);
INSERT INTO `xy_school` VALUES (2712, '昌吉职业技术学院', '4165012838', 1);
INSERT INTO `xy_school` VALUES (2713, '伊犁职业技术学院', '4165012975', 1);
INSERT INTO `xy_school` VALUES (2714, '阿克苏职业技术学院', '4165013093', 1);
INSERT INTO `xy_school` VALUES (2715, '巴音郭楞职业技术学院', '4165013094', 1);
INSERT INTO `xy_school` VALUES (2716, '新疆建设职业技术学院', '4165013562', 1);
INSERT INTO `xy_school` VALUES (2717, '新疆兵团警官高等专科学校', '4165013563', 1);
INSERT INTO `xy_school` VALUES (2718, '新疆现代职业技术学院', '4165013726', 1);
INSERT INTO `xy_school` VALUES (2719, '新疆交通职业技术学院', '4165013926', 1);
INSERT INTO `xy_school` VALUES (2720, '新疆石河子职业技术学院', '4165013956', 1);
INSERT INTO `xy_school` VALUES (2721, '新疆职业大学', '4165014138', 1);
INSERT INTO `xy_school` VALUES (2722, '新疆体育职业技术学院', '4165014416', 1);
INSERT INTO `xy_school` VALUES (2723, '新疆应用职业技术学院', '4165014417', 1);
INSERT INTO `xy_school` VALUES (2724, '新疆师范高等专科学校', '4165014421', 1);
INSERT INTO `xy_school` VALUES (2725, '新疆铁道职业技术学院', '4165014489', 1);
INSERT INTO `xy_school` VALUES (2726, '新疆生产建设兵团兴新职业技术学院', '4165014523', 1);
INSERT INTO `xy_school` VALUES (2727, '哈密职业技术学院', '4165014524', 1);
INSERT INTO `xy_school` VALUES (2728, '新疆科技职业技术学院', '4165014525', 1);
INSERT INTO `xy_school` VALUES (2729, '吐鲁番职业技术学院', '4165014585', 1);
INSERT INTO `xy_school` VALUES (2730, '博尔塔拉职业技术学院', '4165014622', 1);
INSERT INTO `xy_school` VALUES (2731, '和田职业技术学院', '4165014652', 1);
INSERT INTO `xy_school` VALUES (2732, '石河子工程职业技术学院', '4165014661', 1);
INSERT INTO `xy_school` VALUES (2733, '喀什职业技术学院', '4165014677', 1);
INSERT INTO `xy_school` VALUES (2734, '克孜勒苏职业技术学院', '4165014678', 1);
INSERT INTO `xy_school` VALUES (2735, '新疆科信职业技术学院', '4165014679', 1);
INSERT INTO `xy_school` VALUES (2736, '阿勒泰职业技术学院', '4165014680', 1);
INSERT INTO `xy_school` VALUES (2737, '塔城职业技术学院', '4165014740', 1);
INSERT INTO `xy_school` VALUES (2738, '塔里木职业技术学院', '4165014741', 1);
INSERT INTO `xy_school` VALUES (2739, '新疆工业职业技术学院', '4265051060', 1);
INSERT INTO `xy_school` VALUES (2740, '铁门关职业技术学院', '4165014660', 1);
INSERT INTO `xy_school` VALUES (2741, '北京市海淀区职工大学', '4211050001', 0);
INSERT INTO `xy_school` VALUES (2742, '北京市东城区职工业余大学', '4211050002', 0);
INSERT INTO `xy_school` VALUES (2743, '北京市崇文区职工大学', '4211050004', 0);
INSERT INTO `xy_school` VALUES (2744, '北京宣武红旗业余大学', '4211050005', 0);
INSERT INTO `xy_school` VALUES (2745, '北京市石景山区业余大学', '4211050006', 0);
INSERT INTO `xy_school` VALUES (2746, '北京市朝阳区职工大学', '4211050007', 0);
INSERT INTO `xy_school` VALUES (2747, '北京医药集团职工大学', '4211050018', 0);
INSERT INTO `xy_school` VALUES (2748, '北京市总工会职工大学', '4211050025', 0);
INSERT INTO `xy_school` VALUES (2749, '中央党校继续教育学院', '4211050038', 0);
INSERT INTO `xy_school` VALUES (2750, '中国记协职工新闻学院', '4211050043', 0);
INSERT INTO `xy_school` VALUES (2751, '中南海业余大学', '4211050044', 0);
INSERT INTO `xy_school` VALUES (2752, '北京教育学院', '4211050061', 0);
INSERT INTO `xy_school` VALUES (2753, '北京开放大学', '4211051160', 0);
INSERT INTO `xy_school` VALUES (2754, '国家开放大学（中央广播电视大学）', '4211051161', 0);
INSERT INTO `xy_school` VALUES (2755, '民航管理干部学院', '4211051167', 0);
INSERT INTO `xy_school` VALUES (2756, '北京市丰台区职工大学', '4211051624', 0);
INSERT INTO `xy_school` VALUES (2757, '北京市西城经济科学大学', '4211051626', 0);
INSERT INTO `xy_school` VALUES (2758, '北京市农工商联合总公司职工大学', '4211051630', 0);
INSERT INTO `xy_school` VALUES (2759, '公安部管理干部学院', '4211051643', 0);
INSERT INTO `xy_school` VALUES (2760, '国家法官学院', '4211051651', 0);
INSERT INTO `xy_school` VALUES (2761, '华北电业联合职工大学', '4211051800', 0);
INSERT INTO `xy_school` VALUES (2762, '首都联合职工大学', '4211051837', 0);
INSERT INTO `xy_school` VALUES (2763, '国家检察官学院', '4211051898', 0);
INSERT INTO `xy_school` VALUES (2764, '天津市和平区新华职工大学', '4212050063', 0);
INSERT INTO `xy_school` VALUES (2765, '天津市河西区职工大学', '4212050064', 0);
INSERT INTO `xy_school` VALUES (2766, '天津市河东区职工大学', '4212050065', 0);
INSERT INTO `xy_school` VALUES (2767, '天津市红桥区职工大学', '4212050066', 0);
INSERT INTO `xy_school` VALUES (2768, '天津市南开区职工大学', '4212050068', 0);
INSERT INTO `xy_school` VALUES (2769, '天津市建筑工程职工大学', '4212050070', 0);
INSERT INTO `xy_school` VALUES (2770, '天津市职工经济技术大学', '4212050073', 0);
INSERT INTO `xy_school` VALUES (2771, '天津市渤海化工职工学院', '4212050095', 0);
INSERT INTO `xy_school` VALUES (2772, '天津市管理干部学院', '4212050121', 0);
INSERT INTO `xy_school` VALUES (2773, '天津市广播电视大学', '4212051171', 0);
INSERT INTO `xy_school` VALUES (2774, '天津市政法管理干部学院', '4212051175', 0);
INSERT INTO `xy_school` VALUES (2775, '天津市工会管理干部学院', '4212051176', 0);
INSERT INTO `xy_school` VALUES (2776, '天津市房地产局职工大学', '4212051659', 0);
INSERT INTO `xy_school` VALUES (2777, '河北地质职工大学', '4213050139', 0);
INSERT INTO `xy_school` VALUES (2778, '河北省广播电视大学', '4213051177', 0);
INSERT INTO `xy_school` VALUES (2779, '石家庄职工大学', '4213051180', 0);
INSERT INTO `xy_school` VALUES (2780, '海关管理干部学院', '4231051332', 0);
INSERT INTO `xy_school` VALUES (2781, '河北管理干部学院', '4213051723', 0);
INSERT INTO `xy_school` VALUES (2782, '河北青年管理干部学院', '4213051802', 0);
INSERT INTO `xy_school` VALUES (2783, '太原化学工业集团有限公司\n职工大学', '4214050162', 0);
INSERT INTO `xy_school` VALUES (2784, '山西机电职工学院', '4214050163', 0);
INSERT INTO `xy_school` VALUES (2785, '太原钢铁(集团)有限公司\n职工钢铁学院', '4214050164', 0);
INSERT INTO `xy_school` VALUES (2786, '山西煤炭职工联合大学', '4214050167', 0);
INSERT INTO `xy_school` VALUES (2787, '山西兵器工业职工大学', '4214050169', 0);
INSERT INTO `xy_school` VALUES (2788, '山西省职工工艺美术学院', '4214050175', 0);
INSERT INTO `xy_school` VALUES (2789, '山西省吕梁市教育学院', '4214050197', 0);
INSERT INTO `xy_school` VALUES (2790, '山西省广播电视大学', '4214051187', 0);
INSERT INTO `xy_school` VALUES (2791, '山西省政法管理干部学院', '4214051787', 0);
INSERT INTO `xy_school` VALUES (2792, '包头市职工大学', '4215050204', 0);
INSERT INTO `xy_school` VALUES (2793, '内蒙古自治区广播电视大学', '4215051192', 0);
INSERT INTO `xy_school` VALUES (2794, '辽宁兵器工业职工大学', '4221051087', 0);
INSERT INTO `xy_school` VALUES (2795, '大连工人大学', '4221051110', 0);
INSERT INTO `xy_school` VALUES (2796, '空军第四职工大学', '4221051117', 0);
INSERT INTO `xy_school` VALUES (2797, '海军职工大学', '4221051118', 0);
INSERT INTO `xy_school` VALUES (2798, '大连职工大学', '4221051120', 0);
INSERT INTO `xy_school` VALUES (2799, '抚顺矿务局职工工学院', '4221051125', 0);
INSERT INTO `xy_school` VALUES (2800, '抚顺石油化工公司职工大学', '4221051126', 0);
INSERT INTO `xy_school` VALUES (2801, '阜新矿务局职工大学', '4221051138', 0);
INSERT INTO `xy_school` VALUES (2802, '朝阳职工工学院', '4221051143', 0);
INSERT INTO `xy_school` VALUES (2803, '大连市教育学院', '4221051149', 0);
INSERT INTO `xy_school` VALUES (2804, '辽宁广播电视大学', '4221051196', 0);
INSERT INTO `xy_school` VALUES (2805, '阜新煤炭职工医学专科学校', '4221051227', 0);
INSERT INTO `xy_school` VALUES (2806, '辽宁冶金职工大学', '4221051695', 0);
INSERT INTO `xy_school` VALUES (2807, '辽宁公安司法管理干部学院', '4221051842', 0);
INSERT INTO `xy_school` VALUES (2808, '沈阳机械工业职工大学', '4221051843', 0);
INSERT INTO `xy_school` VALUES (2809, '鞍山钢铁集团公司职工大学', '4221051845', 0);
INSERT INTO `xy_school` VALUES (2810, '沈阳市广播电视大学', '4221051848', 0);
INSERT INTO `xy_school` VALUES (2811, '大连市广播电视大学', '4221051849', 0);
INSERT INTO `xy_school` VALUES (2812, '长春职工大学', '4222050226', 0);
INSERT INTO `xy_school` VALUES (2813, '长春市建筑职工业余大学', '4222050229', 0);
INSERT INTO `xy_school` VALUES (2814, '长春职工医科大学', '4222050232', 0);
INSERT INTO `xy_school` VALUES (2815, '吉林市职工大学', '4222050234', 0);
INSERT INTO `xy_school` VALUES (2816, '吉林化学工业公司职工大学', '4222050236', 0);
INSERT INTO `xy_school` VALUES (2817, '通化市职工大学', '4222050242', 0);
INSERT INTO `xy_school` VALUES (2818, '通化钢铁公司职工大学', '4222050243', 0);
INSERT INTO `xy_school` VALUES (2819, '四平农村成人高等专科学校', '4222050249', 0);
INSERT INTO `xy_school` VALUES (2820, '吉林省教育学院', '4222050252', 0);
INSERT INTO `xy_school` VALUES (2821, '长春教育学院', '4222050253', 0);
INSERT INTO `xy_school` VALUES (2822, '吉林广播电视大学', '4222051230', 0);
INSERT INTO `xy_school` VALUES (2823, '吉林省经济管理干部学院', '4222051243', 0);
INSERT INTO `xy_school` VALUES (2824, '吉林职工医科大学', '4222051704', 0);
INSERT INTO `xy_school` VALUES (2825, '长春广播电视大学', '4222051887', 0);
INSERT INTO `xy_school` VALUES (2826, '黑龙江兵器工业职工大学', '4223050264', 0);
INSERT INTO `xy_school` VALUES (2827, '哈尔滨航空职工大学', '4223050266', 0);
INSERT INTO `xy_school` VALUES (2828, '哈尔滨市职工大学', '4223050269', 0);
INSERT INTO `xy_school` VALUES (2829, '齐齐哈尔市建设职工大学', '4223050306', 0);
INSERT INTO `xy_school` VALUES (2830, '齐齐哈尔市职工大学', '4223050311', 0);
INSERT INTO `xy_school` VALUES (2831, '鹤岗矿务局职工大学', '4223050327', 0);
INSERT INTO `xy_school` VALUES (2832, '大庆石油化工总厂职工大学', '4223050330', 0);
INSERT INTO `xy_school` VALUES (2833, '黑龙江农垦管理干部学院', '4223050337', 0);
INSERT INTO `xy_school` VALUES (2834, '黑龙江省经济管理干部学院', '4223050335', 0);
INSERT INTO `xy_school` VALUES (2835, '黑龙江省政法管理干部学院', '4223050343', 0);
INSERT INTO `xy_school` VALUES (2836, '黑龙江省教育学院', '4223050344', 0);
INSERT INTO `xy_school` VALUES (2837, '绥化市教育学院', '4223050349', 0);
INSERT INTO `xy_school` VALUES (2838, '黑龙江省广播电视大学', '4223051244', 0);
INSERT INTO `xy_school` VALUES (2839, '黑龙江省商业职工大学', '4223051744', 0);
INSERT INTO `xy_school` VALUES (2840, '黑龙江省社会科学院职工大学', '4223051745', 0);
INSERT INTO `xy_school` VALUES (2841, '哈尔滨市广播电视大学', '4223051876', 0);
INSERT INTO `xy_school` VALUES (2842, '上海科技管理干部学院', '4231050033', 0);
INSERT INTO `xy_school` VALUES (2843, '上海市黄浦区业余大学', '4231050363', 0);
INSERT INTO `xy_school` VALUES (2844, '上海市徐汇区业余大学', '4231050366', 0);
INSERT INTO `xy_school` VALUES (2845, '上海市长宁区业余大学', '4231050367', 0);
INSERT INTO `xy_school` VALUES (2846, '上海市静安区业余大学', '4231050368', 0);
INSERT INTO `xy_school` VALUES (2847, '上海市普陀区业余大学', '4231050369', 0);
INSERT INTO `xy_school` VALUES (2848, '上海市虹口区业余大学', '4231050371', 0);
INSERT INTO `xy_school` VALUES (2849, '上海市杨浦区业余大学', '4231050372', 0);
INSERT INTO `xy_school` VALUES (2850, '上海纺织工业职工大学', '4231050393', 0);
INSERT INTO `xy_school` VALUES (2851, '上海医药职工大学', '4231050424', 0);
INSERT INTO `xy_school` VALUES (2852, '上海开放大学', '4231051252', 0);
INSERT INTO `xy_school` VALUES (2853, '上海市经济管理干部学院', '4231051613', 0);
INSERT INTO `xy_school` VALUES (2854, '上海青年管理干部学院', '4231051615', 0);
INSERT INTO `xy_school` VALUES (2855, '上海市宝山区业余大学', '4231051852', 0);
INSERT INTO `xy_school` VALUES (2856, '南京市职工大学', '4232050460', 0);
INSERT INTO `xy_school` VALUES (2857, '空军第一职工大学', '4232050461', 0);
INSERT INTO `xy_school` VALUES (2858, '南通市工人业余大学', '4232050504', 0);
INSERT INTO `xy_school` VALUES (2859, '扬州教育学院', '4232050526', 0);
INSERT INTO `xy_school` VALUES (2860, '江苏开放大学', '4232051255', 0);
INSERT INTO `xy_school` VALUES (2861, '江苏省省级机关管理干部学院', '4232051257', 0);
INSERT INTO `xy_school` VALUES (2862, '南京市广播电视大学', '4232051396', 0);
INSERT INTO `xy_school` VALUES (2863, '江苏省青年管理干部学院', '4232051828', 0);
INSERT INTO `xy_school` VALUES (2864, '浙江省省级机关职工业余大学', '4233050550', 0);
INSERT INTO `xy_school` VALUES (2865, '杭州市工人业余大学', '4233050551', 0);
INSERT INTO `xy_school` VALUES (2866, '温州市工人业余大学', '4233050554', 0);
INSERT INTO `xy_school` VALUES (2867, '金华教育学院', '4233050561', 0);
INSERT INTO `xy_school` VALUES (2868, '浙江省广播电视大学', '4233051258', 0);
INSERT INTO `xy_school` VALUES (2869, '浙江经济管理职工大学', '4233051259', 0);
INSERT INTO `xy_school` VALUES (2870, '浙江嘉兴教育学院', '4233051814', 0);
INSERT INTO `xy_school` VALUES (2871, '宁波市广播电视大学', '4233051885', 0);
INSERT INTO `xy_school` VALUES (2872, '淮南市职工大学', '4234050565', 0);
INSERT INTO `xy_school` VALUES (2873, '合肥职工科技大学', '4234050569', 0);
INSERT INTO `xy_school` VALUES (2874, '合肥市职工大学', '4234050570', 0);
INSERT INTO `xy_school` VALUES (2875, '安徽经济管理干部学院', '4234050581', 0);
INSERT INTO `xy_school` VALUES (2876, '宿州教育学院', '4234051265', 0);
INSERT INTO `xy_school` VALUES (2877, '安徽广播电视大学', '4234051388', 0);
INSERT INTO `xy_school` VALUES (2878, '福建教育学院', '4235050591', 0);
INSERT INTO `xy_school` VALUES (2879, '福建省广播电视大学', '4235051270', 0);
INSERT INTO `xy_school` VALUES (2880, '厦门市广播电视大学', '4235051833', 0);
INSERT INTO `xy_school` VALUES (2881, '江西行政管理干部学院', '4236050151', 0);
INSERT INTO `xy_school` VALUES (2882, '昌河职工工学院', '4236050603', 0);
INSERT INTO `xy_school` VALUES (2883, '南昌钢铁有限责任公司职工大学', '4236050607', 0);
INSERT INTO `xy_school` VALUES (2884, '南昌市业余大学', '4236050616', 0);
INSERT INTO `xy_school` VALUES (2885, '南昌市职工科技大学', '4236050617', 0);
INSERT INTO `xy_school` VALUES (2886, '江西广播电视大学', '4236051281', 0);
INSERT INTO `xy_school` VALUES (2887, '南昌教育学院', '4236051283', 0);
INSERT INTO `xy_school` VALUES (2888, '江西经济管理干部学院', '4236051285', 0);
INSERT INTO `xy_school` VALUES (2889, '山东省水利职工大学', '4237050626', 0);
INSERT INTO `xy_school` VALUES (2890, '山东兵器工业职工大学', '4237050638', 0);
INSERT INTO `xy_school` VALUES (2891, '新汶矿务局职工大学', '4237050641', 0);
INSERT INTO `xy_school` VALUES (2892, '济南市职工大学', '4237050644', 0);
INSERT INTO `xy_school` VALUES (2893, '山东省经济管理干部学院', '4237050649', 0);
INSERT INTO `xy_school` VALUES (2894, '山东省聊城教育学院', '4237050661', 0);
INSERT INTO `xy_school` VALUES (2895, '山东省济宁教育学院', '4237050663', 0);
INSERT INTO `xy_school` VALUES (2896, '山东省广播电视大学', '4237051286', 0);
INSERT INTO `xy_school` VALUES (2897, '兖州矿区职工大学', '4237051777', 0);
INSERT INTO `xy_school` VALUES (2898, '山东财政职工大学', '4237051779', 0);
INSERT INTO `xy_school` VALUES (2899, '青岛市广播电视大学', '4237051858', 0);
INSERT INTO `xy_school` VALUES (2900, '长城铝业公司职工工学院', '4241050673', 0);
INSERT INTO `xy_school` VALUES (2901, '郑州市职工大学', '4241050674', 0);
INSERT INTO `xy_school` VALUES (2902, '第一拖拉机制造厂拖拉机学院', '4241050680', 0);
INSERT INTO `xy_school` VALUES (2903, '洛阳轴承职工大学', '4241050682', 0);
INSERT INTO `xy_school` VALUES (2904, '洛阳有色金属职工大学', '4241050686', 0);
INSERT INTO `xy_school` VALUES (2905, '开封空分设备厂职工大学', '4241050688', 0);
INSERT INTO `xy_school` VALUES (2906, '河南省广播电视大学', '4241051287', 0);
INSERT INTO `xy_school` VALUES (2907, '焦作职工医学院', '4241051408', 0);
INSERT INTO `xy_school` VALUES (2908, '磨料磨具工业职工大学', '4241051411', 0);
INSERT INTO `xy_school` VALUES (2909, '驻马店教育学院', '4241051413', 0);
INSERT INTO `xy_school` VALUES (2910, '武汉市广播电视大学', '4242050046', 0);
INSERT INTO `xy_school` VALUES (2911, '湖北兵器工业职工大学', '4242050717', 0);
INSERT INTO `xy_school` VALUES (2912, '湖北省纺织职工大学', '4242050733', 0);
INSERT INTO `xy_school` VALUES (2913, '鄂城钢铁厂职工大学', '4242050738', 0);
INSERT INTO `xy_school` VALUES (2914, '丹江口工程管理局职工大学', '4242050740', 0);
INSERT INTO `xy_school` VALUES (2915, '湖北省直属机关业余大学', '4242050742', 0);
INSERT INTO `xy_school` VALUES (2916, '湖北省经济管理干部学院', '4242050756', 0);
INSERT INTO `xy_school` VALUES (2917, '十堰教育学院', '4242050762', 0);
INSERT INTO `xy_school` VALUES (2918, '荆州教育学院', '4242050763', 0);
INSERT INTO `xy_school` VALUES (2919, '大冶钢厂职工大学', '4242051297', 0);
INSERT INTO `xy_school` VALUES (2920, '湖北广播电视大学', '4242051305', 0);
INSERT INTO `xy_school` VALUES (2921, '武汉冶金管理干部学院', '4242051773', 0);
INSERT INTO `xy_school` VALUES (2922, '湖北武汉公安管理干部学院', '4242051774', 0);
INSERT INTO `xy_school` VALUES (2923, '华中电业联合职工大学', '4242051862', 0);
INSERT INTO `xy_school` VALUES (2924, '涟源钢铁总厂职工大学', '4243050774', 0);
INSERT INTO `xy_school` VALUES (2925, '株洲市职工大学', '4243050788', 0);
INSERT INTO `xy_school` VALUES (2926, '湖南航空工业职工工学院', '4243050793', 0);
INSERT INTO `xy_school` VALUES (2927, '中钢集团衡阳重机职工大学', '4243050794', 0);
INSERT INTO `xy_school` VALUES (2928, '衡阳工业职工大学', '4243050798', 0);
INSERT INTO `xy_school` VALUES (2929, '长沙教育学院', '4243050810', 0);
INSERT INTO `xy_school` VALUES (2930, '湘潭教育学院', '4243050812', 0);
INSERT INTO `xy_school` VALUES (2931, '湖南省广播电视大学', '4243051306', 0);
INSERT INTO `xy_school` VALUES (2932, '益阳教育学院', '4243051310', 0);
INSERT INTO `xy_school` VALUES (2933, '湖南金融技术职工大学', '4243051766', 0);
INSERT INTO `xy_school` VALUES (2934, '湖南纺织职工大学', '4243051767', 0);
INSERT INTO `xy_school` VALUES (2935, '长沙工业职工大学', '4243050784', 0);
INSERT INTO `xy_school` VALUES (2936, '广州金桥管理干部学院', '4244050075', 0);
INSERT INTO `xy_school` VALUES (2937, '南海成人学院', '4244050079', 0);
INSERT INTO `xy_school` VALUES (2938, '湛江市业余大学', '4244050821', 0);
INSERT INTO `xy_school` VALUES (2939, '广东省国防工业职工大学', '4244050826', 0);
INSERT INTO `xy_school` VALUES (2940, '汕头市业余大学', '4244050835', 0);
INSERT INTO `xy_school` VALUES (2941, '韶关市职工大学', '4244050837', 0);
INSERT INTO `xy_school` VALUES (2942, '广州市公安管理干部学院', '4244050855', 0);
INSERT INTO `xy_school` VALUES (2943, '广东省公安司法管理干部学院', '4244050859', 0);
INSERT INTO `xy_school` VALUES (2944, '广东开放大学', '4244051315', 0);
INSERT INTO `xy_school` VALUES (2945, '广东新华教育学院', '4244051317', 0);
INSERT INTO `xy_school` VALUES (2946, '广东省职工体育运动技术学院', '4244051319', 0);
INSERT INTO `xy_school` VALUES (2947, '广东社会科学大学', '4244051320', 0);
INSERT INTO `xy_school` VALUES (2948, '广州市广播电视大学', '4244051393', 0);
INSERT INTO `xy_school` VALUES (2949, '深圳广播电视大学', '4244051888', 0);
INSERT INTO `xy_school` VALUES (2950, '桂林市职工大学', '4245050867', 0);
INSERT INTO `xy_school` VALUES (2951, '广西教育学院', '4245050870', 0);
INSERT INTO `xy_school` VALUES (2952, '广西壮族自治区广播电视大学', '4245051338', 0);
INSERT INTO `xy_school` VALUES (2953, '广西政法管理干部学院', '4245051340', 0);
INSERT INTO `xy_school` VALUES (2954, '海南广播电视大学', '4246051865', 0);
INSERT INTO `xy_school` VALUES (2955, '重庆电力职工大学', '4250050901', 0);
INSERT INTO `xy_school` VALUES (2956, '重庆冶金成人学院', '4250050905', 0);
INSERT INTO `xy_school` VALUES (2957, '重庆职工会计专科学校', '4250051759', 0);
INSERT INTO `xy_school` VALUES (2958, '重庆市广播电视大学', '4250051866', 0);
INSERT INTO `xy_school` VALUES (2959, '四川科技职工大学', '4251050081', 0);
INSERT INTO `xy_school` VALUES (2960, '四川省东方动力职工大学', '4251050875', 0);
INSERT INTO `xy_school` VALUES (2961, '中国工程物理研究院职工工学院', '4251050879', 0);
INSERT INTO `xy_school` VALUES (2962, '成都飞机工业公司职工工学院', '4251050883', 0);
INSERT INTO `xy_school` VALUES (2963, '国营涪江机器厂职工大学', '4251050885', 0);
INSERT INTO `xy_school` VALUES (2964, '成都冶金职工大学', '4251050907', 0);
INSERT INTO `xy_school` VALUES (2965, '第五冶金建设公司职工大学', '4251050908', 0);
INSERT INTO `xy_school` VALUES (2966, '成都工业职工大学', '4251050913', 0);
INSERT INTO `xy_school` VALUES (2967, '四川省化工职工大学', '4251050919', 0);
INSERT INTO `xy_school` VALUES (2968, '中国科学院成都分院职工大学', '4251050928', 0);
INSERT INTO `xy_school` VALUES (2969, '广元职工医学院', '4251050930', 0);
INSERT INTO `xy_school` VALUES (2970, '南充市职工大学', '4251050932', 0);
INSERT INTO `xy_school` VALUES (2971, '四川广播电视大学', '4251051341', 0);
INSERT INTO `xy_school` VALUES (2972, '成都市职工大学', '4251051758', 0);
INSERT INTO `xy_school` VALUES (2973, '成都广播电视大学', '4251051886', 0);
INSERT INTO `xy_school` VALUES (2974, '贵州铝厂职工大学', '4252050962', 0);
INSERT INTO `xy_school` VALUES (2975, '贵州机械工业职工大学', '4252050965', 0);
INSERT INTO `xy_school` VALUES (2976, '贵州广播电视大学', '4252051352', 0);
INSERT INTO `xy_school` VALUES (2977, '云南开放大学', '4253051357', 0);
INSERT INTO `xy_school` VALUES (2978, '陕西航天职工大学', '4261050083', 0);
INSERT INTO `xy_school` VALUES (2979, '西安航空职工大学', '4261050989', 0);
INSERT INTO `xy_school` VALUES (2980, '西安飞机工业公司职工工学院', '4261050990', 0);
INSERT INTO `xy_school` VALUES (2981, '陕西兵器工业职工大学', '4261051001', 0);
INSERT INTO `xy_school` VALUES (2982, '西北电业职工大学', '4261051002', 0);
INSERT INTO `xy_school` VALUES (2983, '西安铁路工程职工大学', '4261051006', 0);
INSERT INTO `xy_school` VALUES (2984, '西安电力机械制造公司机电学院', '4261051009', 0);
INSERT INTO `xy_school` VALUES (2985, '陕西省建筑工程总公司职工大学', '4261051010', 0);
INSERT INTO `xy_school` VALUES (2986, '西安市职工大学', '4261051017', 0);
INSERT INTO `xy_school` VALUES (2987, '宝鸡市职工大学', '4261051018', 0);
INSERT INTO `xy_school` VALUES (2988, '陕西省宝鸡教育学院', '4261051027', 0);
INSERT INTO `xy_school` VALUES (2989, '陕西省广播电视大学', '4261051370', 0);
INSERT INTO `xy_school` VALUES (2990, '陕西工运学院', '4261051373', 0);
INSERT INTO `xy_school` VALUES (2991, '西安市广播电视大学', '4261051871', 0);
INSERT INTO `xy_school` VALUES (2992, '兰州航空工业职工大学', '4262051038', 0);
INSERT INTO `xy_school` VALUES (2993, '兰州铁路工程职工大学', '4262051039', 0);
INSERT INTO `xy_school` VALUES (2994, '甘肃核工业职工大学', '4262051040', 0);
INSERT INTO `xy_school` VALUES (2995, '银光化学材料厂职工大学', '4262051042', 0);
INSERT INTO `xy_school` VALUES (2996, '甘肃广播电视大学', '4262051374', 0);
INSERT INTO `xy_school` VALUES (2997, '青海省联合职工大学', '4263051049', 0);
INSERT INTO `xy_school` VALUES (2998, '青海省广播电视大学', '4263051382', 0);
INSERT INTO `xy_school` VALUES (2999, '宁夏回族自治区广播电视大学', '4264051383', 0);
INSERT INTO `xy_school` VALUES (3000, '新疆生产建设兵团广播电视大学', '4265051210', 0);
INSERT INTO `xy_school` VALUES (3001, '新疆维吾尔自治区广播电视大学', '4265051387', 0);
INSERT INTO `xy_school` VALUES (3002, '喀什教育学院', '4265051594', 0);
INSERT INTO `xy_school` VALUES (3003, '新疆生产建设兵团教育学院', '4265051595', 0);
INSERT INTO `xy_school` VALUES (3004, '和田地区教育学院', '4265051599', 0);
INSERT INTO `xy_school` VALUES (3005, '阿克苏教育学院', '4265051717', 0);
