
-- ----------------------------
-- Table structure for xy_jobs_cate
-- ----------------------------
DROP TABLE IF EXISTS `xy_jobs_cate`;
CREATE TABLE `xy_jobs_cate`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pid` int(10) UNSIGNED NULL DEFAULT NULL,
  `title` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `icon` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `alias` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `sort` tinyint(2) NULL DEFAULT 99,
  `status` tinyint(1) NULL DEFAULT 1,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `pid`(`pid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1042 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '职位分类' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of xy_jobs_cate
-- ----------------------------
INSERT INTO `xy_jobs_cate` VALUES (1, 0, '销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (2, 0, '人事/财务/行政', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (3, 0, '高级管理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (4, 0, '生产制造', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (5, 0, '技术', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (6, 0, '房地产/建筑', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (7, 0, '金融', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (8, 0, '教育培训', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (9, 0, '传媒', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (10, 0, '供应链/物流', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (11, 0, '医疗健康', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (12, 0, '运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (13, 0, '市场', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (14, 0, '采购/贸易', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (15, 0, '服务业', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (16, 0, '设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (17, 0, '咨询/翻译/法律', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (18, 0, '旅游', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (19, 0, '产品', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (20, 0, '其他', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (21, 1, '销售行政/商务', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (22, 1, '房地产销售/招商', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (23, 1, '服务业销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (24, 1, '汽车销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (25, 1, '广告/会展销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (26, 1, '金融销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (27, 1, '外贸销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (28, 1, '销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (29, 1, '课程销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (30, 1, '医疗销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (31, 1, '销售管理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (32, 1, '其他销售职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (33, 21, '商务专员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (34, 21, '商务经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (35, 21, '销售助理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (36, 21, '商务总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (37, 21, '销售运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (38, 22, '房地产销售/招商', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (39, 22, '置业顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (40, 22, '地产中介', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (41, 22, '物业招商管理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (42, 22, '房地产销售总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (43, 23, '彩妆顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (44, 23, '美容顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (45, 23, '会籍顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (46, 23, '珠宝销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (47, 23, '旅游顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (48, 23, '瘦身顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (49, 24, '汽车销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (50, 24, '汽车配件销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (51, 25, '广告销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (52, 25, '会议活动销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (53, 25, '会展活动销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (54, 25, '媒介顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (55, 26, '证券经纪人', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (56, 26, '信用卡销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (57, 26, '保险顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (58, 26, '理财顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (59, 27, '外贸经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (60, 27, '外贸业务员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (61, 28, '销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (62, 28, '销售专员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (63, 28, '客户代表', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (64, 28, '大客户代表', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (65, 28, 'BD经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (66, 28, '渠道销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (67, 28, '代理商销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (68, 28, '电话销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (69, 28, '销售顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (70, 28, '网络销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (71, 28, '销售工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (72, 28, '客户经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (73, 29, '课程顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (74, 29, '招生顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (75, 29, '留学顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (76, 30, '医疗销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (77, 30, '医疗器械销售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (78, 30, '医药代表', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (79, 30, '健康顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (80, 30, '医美咨询', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (81, 31, '销售管理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (82, 31, '销售经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (83, 31, '销售总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (84, 31, '区域总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (85, 31, '城市经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (86, 31, '销售VP', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (87, 31, '团队经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (88, 32, '其他销售职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (89, 2, '人力资源', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (90, 2, '行政', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (91, 2, '财务', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (92, 2, '法务', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (93, 2, '其他职能职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (94, 89, '人力资源主管', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (95, 89, '招聘', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (96, 89, 'HRBP', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (97, 89, '人力资源专员/助理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (98, 89, '培训', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (99, 89, '薪资福利', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (100, 89, '绩效考核', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (101, 89, '人力资源经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (102, 89, '人力资源VP/CHO', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (103, 89, '人力资源总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (104, 89, '员工关系', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (105, 89, '组织发展', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (106, 90, '行政专员/助理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (107, 90, '前台', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (108, 90, '行政主管', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (109, 90, '经理助理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (110, 90, '后勤', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (111, 90, '行政经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (112, 90, '行政总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (113, 91, '财务', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (114, 91, '会计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (115, 91, '出纳', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (116, 91, '财务顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (117, 91, '结算', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (118, 91, '税务', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (119, 91, '审计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (120, 91, '风控', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (121, 91, '成本', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (122, 91, '总账会计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (123, 91, '财务经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (124, 91, 'CFO', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (125, 91, '财务总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (126, 91, '财务主管', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (127, 92, '法务专员/助理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (128, 92, '律师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (129, 92, '法律顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (130, 92, '法务主管', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (131, 92, '法务经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (132, 92, '法务总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (133, 93, '其他职能职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (134, 3, '高级管理职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (135, 134, '总裁/总经理/CEO', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (136, 134, '副总裁/副总经理/VP', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (137, 134, '分公司/代表处负责人', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (138, 134, '区域负责人(辖多个分公司)', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (139, 134, '总助/CEO助理/董事长助理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (140, 134, '合伙人', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (141, 134, '联合创始人', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (142, 134, '董事长秘书', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (143, 4, '生产营运', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (144, 4, '质量安全', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (145, 4, '新能源', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (146, 4, '汽车制造', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (147, 4, '汽车服务', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (148, 4, '机械设计/制造', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (149, 4, '化工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (150, 4, '服装/纺织/皮革', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (151, 4, '技工/普工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (152, 4, '其他生产制造职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (153, 143, '生产营运', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (154, 143, '厂长', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (155, 143, '生产总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (156, 143, '车间主任', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (157, 143, '生产组长/拉长', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (158, 143, '生产员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (159, 143, '生产设备管理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (160, 143, '生产计划管理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (161, 143, '生产跟单', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (162, 144, '质检员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (163, 144, '质量管理/测试', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (164, 144, '可靠度工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (165, 144, '故障分析师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (166, 144, '认证工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (167, 144, '体系工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (168, 144, '审核员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (169, 144, '生产安全员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (170, 144, '汽车质量工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (171, 145, '电池工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (172, 145, '电机工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (173, 145, '线束设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (174, 145, '充电桩设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (175, 146, '汽车设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (176, 146, '车身/造型设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (177, 146, '底盘工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (178, 146, '动力系统工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (179, 146, '汽车电子工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (180, 146, '汽车零部件设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (181, 146, '汽车项目管理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (182, 146, '内外饰设计工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (183, 146, '总装工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (184, 147, '汽车服务顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (185, 147, '汽车维修', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (186, 147, '汽车美容', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (187, 147, '汽车定损理赔', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (188, 147, '二手车评估师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (189, 147, '4S店店长/维修站长', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (190, 147, '汽车改装工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (191, 148, '机械设计/制造', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (192, 148, '热设计工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (193, 148, '精益工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (194, 148, '机械工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (195, 148, '机械设计师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (196, 148, '机械设备工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (197, 148, '机械维修/保养', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (198, 148, '机械制图', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (199, 148, '机械结构工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (200, 148, '工业设计师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (201, 148, '工艺/制程工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (202, 148, '材料工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (203, 148, '机电工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (204, 148, 'CNC/数控', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (205, 148, '冲压工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (206, 148, '夹具工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (207, 148, '模具工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (208, 148, '焊接工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (209, 148, '注塑工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (210, 148, '铸造/锻造工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (211, 149, '化工项目经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (212, 149, '化工工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (213, 149, '实验室技术员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (214, 149, '化学分析', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (215, 149, '涂料研发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (216, 149, '化妆品研发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (217, 149, '食品/饮料研发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (218, 150, '服装/纺织设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (219, 150, '面料辅料开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (220, 150, '打样/制板', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (221, 151, '普工/操作工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (222, 151, '叉车工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (223, 151, '铲车司机', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (224, 151, '焊工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (225, 151, '氩弧焊工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (226, 151, '电工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (227, 151, '木工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (228, 151, '油漆工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (229, 151, '车工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (230, 151, '磨工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (231, 151, '铣工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (232, 151, '钳工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (233, 151, '钻工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (234, 151, '铆工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (235, 151, '钣金工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (236, 151, '抛光工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (237, 151, '机修工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (238, 151, '折弯工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (239, 151, '电镀工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (240, 151, '喷塑工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (241, 151, '注塑工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (242, 151, '组装工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (243, 151, '包装工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (244, 151, '空调工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (245, 151, '电梯工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (246, 151, '锅炉工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (247, 151, '学徒工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (248, 151, '缝纫工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (249, 151, '搬运工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (250, 151, '切割工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (251, 151, '样衣工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (252, 151, '模具工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (253, 152, '其他生产制造职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (254, 5, '后端开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (255, 5, '移动开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (256, 5, '测试', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (257, 5, '运维/技术支持', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (258, 5, '数据', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (259, 5, '项目管理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (260, 5, '硬件开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (261, 5, '前端开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (262, 5, '通信', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (263, 5, '电子/半导体', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (264, 5, '高端技术职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (265, 5, '人工智能', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (266, 5, '销售技术支持', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (267, 5, '其他技术职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (268, 254, '后端开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (269, 254, 'Java', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (270, 254, 'C++', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (271, 254, 'PHP', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (272, 254, 'C', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (273, 254, 'C#', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (274, 254, '.NET', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (275, 254, 'Hadoop', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (276, 254, 'Python', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (277, 254, 'Delphi', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (278, 254, 'VB', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (279, 254, 'Perl', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (280, 254, 'Ruby', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (281, 254, 'Node.js', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (282, 254, 'Golang', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (283, 254, 'Erlang', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (284, 254, '语音/视频/图形开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (285, 254, '数据采集', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (286, 254, '全栈工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (287, 254, 'GIS工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (288, 255, '移动开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (289, 255, 'HTML5', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (290, 255, 'Android', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (291, 255, 'iOS', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (292, 255, '移动web前端', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (293, 255, 'Flash开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (294, 255, 'JavaScript', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (295, 255, 'U3D', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (296, 255, 'COCOS2DX', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (297, 255, 'UE4', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (298, 256, '测试工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (299, 256, '自动化测试', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (300, 256, '功能测试', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (301, 256, '性能测试', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (302, 256, '测试开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (303, 256, '移动端测试', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (304, 256, '游戏测试', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (305, 256, '硬件测试', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (306, 256, '软件测试', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (307, 256, '渗透测试', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (308, 257, '运维工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (309, 257, '运维开发工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (310, 257, '网络工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (311, 257, '系统工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (312, 257, 'IT技术支持', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (313, 257, '系统管理员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (314, 257, '网络安全', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (315, 257, '系统安全', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (316, 257, 'DBA', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (317, 258, '数据', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (318, 258, 'ETL工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (319, 258, '数据仓库', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (320, 258, '数据开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (321, 258, '数据挖掘', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (322, 258, '数据分析师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (323, 258, '数据架构师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (324, 259, '项目经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (325, 259, '项目主管', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (326, 259, '项目助理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (327, 259, '项目专员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (328, 259, '实施顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (329, 259, '实施工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (330, 259, '需求分析工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (331, 259, '硬件项目经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (332, 260, '硬件工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (333, 260, '嵌入式', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (334, 260, '自动化', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (335, 260, '单片机', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (336, 260, '电路设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (337, 260, '驱动开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (338, 260, '系统集成', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (339, 260, 'FPGA开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (340, 260, 'DSP开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (341, 260, 'ARM开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (342, 260, 'PCB工艺', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (343, 260, '射频工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (344, 261, '前端开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (345, 261, 'web前端', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (346, 261, 'JavaScript', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (347, 261, 'Flash开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (348, 261, 'HTML5', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (349, 262, '通信技术工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (350, 262, '通信研发工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (351, 262, '数据通信工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (352, 262, '移动通信工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (353, 262, '电信网络工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (354, 262, '电信交换工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (355, 262, '有线传输工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (356, 262, '无线/射频通信工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (357, 262, '通信电源工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (358, 262, '通信标准化工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (359, 262, '通信项目专员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (360, 262, '通信项目经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (361, 262, '核心网工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (362, 262, '通信测试工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (363, 262, '通信设备工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (364, 262, '光通信工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (365, 262, '光传输工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (366, 262, '光网络工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (367, 263, '电气工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (368, 263, '电气设计工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (369, 263, '电子工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (370, 263, '集成电路IC设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (371, 263, 'FAE', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (372, 263, 'IC验证工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (373, 264, '高端技术职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (374, 264, '技术经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (375, 264, '技术总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (376, 264, '测试经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (377, 264, '架构师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (378, 264, 'CTO', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (379, 264, '运维总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (380, 264, '技术合伙人', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (381, 265, '人工智能', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (382, 265, '数据挖掘', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (383, 265, '搜索算法', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (384, 265, '自然语言处理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (385, 265, '推荐算法', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (386, 265, '算法工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (387, 265, '智能驾驶系统工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (388, 265, '反欺诈/风控算法', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (389, 265, '机器学习', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (390, 265, '深度学习', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (391, 265, '语音学习', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (392, 265, '图像识别', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (393, 265, '算法研究员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (394, 266, '销售技术支持', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (395, 266, '售前技术支持', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (396, 266, '售后技术支持', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (397, 267, '其他技术岗位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (398, 6, '房地产规划开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (399, 6, '设计装修与市政建设', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (400, 6, '物业管理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (401, 6, '高端房地产职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (402, 6, '其他房地产职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (403, 398, '房地产规划开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (404, 398, '房地产策划', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (405, 398, '地产项目管理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (406, 398, '地产招投标', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (407, 398, '房产评估师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (408, 399, '设计装修与市政建设', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (409, 399, '建筑工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (410, 399, '建筑设计师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (411, 399, '土木/土建/结构工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (412, 399, '室内设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (413, 399, '园林/景观设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (414, 399, '城市规划设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (415, 399, '工程监理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (416, 399, '工程造价', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (417, 399, '工程预算', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (418, 399, '资料员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (419, 399, '建筑施工现场管理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (420, 399, '弱电工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (421, 399, '给排水工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (422, 399, '暖通工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (423, 399, '幕墙工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (424, 399, '软装设计师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (425, 399, '施工员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (426, 399, '测绘/测量', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (427, 399, '材料员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (428, 399, 'BIM工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (429, 399, '装修项目经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (430, 399, '建筑机电工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (431, 399, '消防工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (432, 399, '施工安全员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (433, 400, '物业经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (434, 400, '物业维修', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (435, 400, '绿化工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (436, 400, '物业管理员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (437, 401, '高端房地产职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (438, 401, '地产项目总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (439, 401, '地产策划总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (440, 401, '地产招投标总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (441, 402, '其他房地产职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (442, 7, '投融资', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (443, 7, '风控', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (444, 7, '税务审计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (445, 7, '银行', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (446, 7, '互联网金融', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (447, 7, '保险', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (448, 7, '证券', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (449, 7, '其他金融职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (450, 442, '投融资', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (451, 442, '投资经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (452, 442, '行业研究', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (453, 442, '资产管理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (454, 442, '投资总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (455, 442, '投资VP', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (456, 442, '投资合伙人', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (457, 442, '融资', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (458, 442, '并购', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (459, 442, '投后管理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (460, 442, '投资助理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (461, 442, '投资顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (462, 442, '其他投融资职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (463, 443, '风控', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (464, 443, '律师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (465, 443, '资信评估', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (466, 443, '合规稽查', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (467, 444, '审计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (468, 444, '法务', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (469, 444, '会计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (470, 444, '清算', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (471, 445, '银行', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (472, 445, '分析师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (473, 445, '柜员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (474, 445, '商务渠道', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (475, 445, '大堂经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (476, 445, '客户经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (477, 445, '信贷经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (478, 445, '风控', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (479, 446, '互联网金融', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (480, 446, '金融产品经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (481, 446, '风控', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (482, 446, '催收员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (483, 446, '分析师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (484, 446, '投资经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (485, 446, '审计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (486, 446, '清算', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (487, 447, '保险精算师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (488, 447, '保险理赔', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (489, 448, '证券', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (490, 448, '证券分析师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (491, 448, '交易员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (492, 449, '其他金融职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (493, 8, '教育产品研发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (494, 8, '教育行政', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (495, 8, '教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (496, 8, 'IT培训', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (497, 8, '职业培训', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (498, 8, '特长培训', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (499, 8, '其他教育培训职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (500, 493, '教育产品研发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (501, 493, '课程设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (502, 493, '课程编辑', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (503, 493, '培训研究', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (504, 493, '培训师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (505, 446, '培训策划', '', '', 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (506, 493, '其他教育产品研发职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (507, 494, '教育行政', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (508, 494, '园长/副园长', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (509, 494, '校长/副校长', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (510, 494, '教务管理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (511, 494, '教学管理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (512, 494, '班主任/辅导员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (513, 495, '教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (514, 495, '语文教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (515, 495, '数学教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (516, 495, '物理教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (517, 495, '化学教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (518, 495, '生物教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (519, 495, '家教', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (520, 495, '托管老师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (521, 495, '早教老师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (522, 495, '助教', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (523, 495, '高中教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (524, 495, '初中教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (525, 495, '小学教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (526, 495, '幼教', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (527, 495, '理科教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (528, 495, '文科教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (529, 495, '英语教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (530, 495, '日语教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (531, 495, '音乐教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (532, 495, '美术教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (533, 495, '体育教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (534, 495, '就业教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (535, 495, '其他外语教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (536, 496, 'IT培训', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (537, 496, 'JAVA培训讲师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (538, 496, 'Android培训讲师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (539, 496, 'iOS培训讲师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (540, 496, 'PHP培训讲师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (541, 496, '.NET培训讲师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (542, 496, 'C++培训讲师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (543, 496, 'Unity 3D培训讲师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (544, 496, 'Web前端培训讲师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (545, 496, '软件测试培训讲师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (546, 496, '动漫培训讲师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (547, 496, 'UI设计培训讲师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (548, 497, '财会培训讲师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (549, 497, 'HR培训讲师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (550, 497, '培训师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (551, 497, '拓展培训', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (552, 498, '教练', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (553, 498, '武术教练', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (554, 498, '轮滑教练', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (555, 498, '表演教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (556, 498, '机器人教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (557, 498, '书法教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (558, 498, '钢琴教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (559, 498, '吉他教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (560, 498, '古筝教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (561, 498, '播音主持教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (562, 498, '乐高教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (563, 498, '舞蹈教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (564, 498, '瑜伽教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (565, 498, '游泳教师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (566, 498, '健身教练', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (567, 498, '篮球/羽毛球教练', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (568, 498, '跆拳道教练', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (569, 499, '其他教育培训职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (570, 9, '采编/写作/出版', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (571, 9, '公关媒介', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (572, 9, '广告', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (573, 9, '影视媒体', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (574, 9, '其他传媒职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (575, 570, '采编/写作/出版', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (576, 570, '排版设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (577, 570, '记者', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (578, 570, '编辑', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (579, 570, '采编', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (580, 570, '撰稿人', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (581, 570, '出版发行', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (582, 570, '校对录入', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (583, 570, '总编', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (584, 570, '自媒体', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (585, 571, '公关媒介', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (586, 571, '媒介经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (587, 571, '媒介专员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (588, 571, '广告协调', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (589, 571, '品牌公关', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (590, 571, '活动策划执行', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (591, 571, '媒介策划', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (592, 572, '广告', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (593, 572, '广告/会展项目经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (594, 572, '广告创意设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (595, 572, '美术指导', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (596, 572, '广告设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (597, 572, '策划经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (598, 572, '广告文案', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (599, 572, '广告制作', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (600, 572, '媒介投放', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (601, 572, '媒介合作', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (602, 572, '广告合作', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (603, 573, '影视媒体', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (604, 573, '艺人助理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (605, 573, '主持人/DJ', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (606, 573, '主播助理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (607, 573, '灯光师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (608, 573, '剪辑师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (609, 573, '影视特效', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (610, 573, '导演/编导', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (611, 573, '摄像/摄影', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (612, 573, '视频编辑', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (613, 573, '音频编辑', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (614, 573, '经纪人', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (615, 573, '后期制作', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (616, 573, '影视发行', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (617, 573, '影视策划', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (618, 573, '主播', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (619, 573, '演员/配音/模特', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (620, 573, '化妆/造型/服装', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (621, 573, '放映员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (622, 573, ' 录音/音效', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (623, 573, '制片人', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (624, 573, '编剧', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (625, 574, '其他传媒职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (626, 10, '物流', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (627, 10, '仓储', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (628, 10, '交通/运输', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (629, 10, '高端供应链职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (630, 10, '其他供应链职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (631, 626, '物流', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (632, 626, '供应链专员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (633, 626, '供应链经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (634, 626, '集装箱管理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (635, 626, '物流专员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (636, 626, '物流经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (637, 626, '物流运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (638, 626, '物流跟单', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (639, 626, '调度员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (640, 626, '物流/仓储项目经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (641, 626, '货运代理专员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (642, 626, '货运代理经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (643, 626, '水/空/陆运操作', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (644, 626, '核销员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (645, 627, '仓储', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (646, 627, '仓库经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (647, 627, '仓库管理员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (648, 627, '仓库文员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (649, 627, '配/理/拣/发货', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (650, 628, '交通/运输', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (651, 628, '商务司机', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (652, 628, '网约车司机', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (653, 628, '代价司机', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (654, 628, '驾校教练', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (655, 628, '货运司机', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (656, 628, '配送员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (657, 628, '快递员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (658, 628, '运输经理/主管', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (659, 629, '高端供应链职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (660, 629, '供应链总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (661, 629, '物流总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (662, 630, '其他供应链职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (663, 11, '临床试验', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (664, 11, '医生/医技', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (665, 11, '护士/护理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (666, 11, '健康整形', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (667, 11, '生物制药', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (668, 11, '医疗器械', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (669, 11, '药店', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (670, 11, '其他医疗健康职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (671, 663, '临床研究', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (672, 663, '临床协调', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (673, 663, '临床数据分析', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (674, 663, '临床项目经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (675, 663, '医学总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (676, 664, '医生', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (677, 664, '医生助理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (678, 664, '医学影像/放射科医师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (679, 664, 'B超医生', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (680, 664, '内科医生', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (681, 664, '全科医生', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (682, 664, '中医', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (683, 664, '心理医生', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (684, 664, '药剂师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (685, 664, '牙科医生', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (686, 664, '康复治疗师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (687, 664, '验光师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (688, 664, '检验科医师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (689, 664, '其他医生职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (690, 665, '护士长', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (691, 665, '护士', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (692, 665, '导医', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (693, 666, '健康整形', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (694, 666, '营养师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (695, 666, '整形术', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (696, 666, '理疗师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (697, 666, '针灸推拿', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (698, 667, '生物制药', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (699, 667, '药品注册', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (700, 667, '药品生产', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (701, 667, '医药项目经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (702, 667, '医药研发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (703, 668, '医疗器械注册', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (704, 668, '医疗器械生产/质量管理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (705, 668, '医疗器械研发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (706, 669, '药店店长', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (707, 669, '执业药师/驻店药师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (708, 669, '药店店员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (709, 670, '其他医疗健康职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (710, 12, '运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (711, 12, '编辑', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (712, 12, '客服', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (713, 12, '高端运营职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (714, 12, '其他运营职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (715, 710, '运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (716, 710, '用户运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (717, 710, '产品运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (718, 710, '数据运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (719, 710, '内容运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (720, 710, '活动运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (721, 710, '商家运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (722, 710, '品类运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (723, 710, '游戏运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (724, 710, '网站运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (725, 710, '新媒体运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (726, 710, '社区运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (727, 710, '微信运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (728, 710, '微博运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (729, 710, '策略运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (730, 710, '线下拓展运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (731, 710, '电商运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (732, 710, '运营助理/专员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (733, 710, '内容审核', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (734, 710, '数据标注', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (735, 710, '直播运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (736, 710, '车辆运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (737, 710, '跨境电商运营', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (738, 710, '网店店长', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (739, 711, '编辑', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (740, 711, '副主编', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (741, 711, '内容编辑', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (742, 711, '文案编辑', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (743, 711, '网站编辑', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (744, 711, '采编', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (745, 711, '医学编辑', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (746, 712, '售前客服', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (747, 712, '售后客服', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (748, 712, '网络客服', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (749, 712, '客服经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (750, 712, '客服专员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (751, 712, '客服主管', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (752, 712, '电话客服', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (753, 712, '咨询热线/呼叫中心客服', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (754, 713, '高端运营职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (755, 713, '主编', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (756, 713, '运营总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (757, 713, 'COO', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (758, 713, '客服总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (759, 713, '运营经理/主管', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (760, 714, '其他运营职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (761, 13, '政府事务', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (762, 13, '市场/营销', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (763, 13, '公关媒介', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (764, 13, '会务会展', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (765, 13, '广告', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (766, 13, '高端市场职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (767, 13, '其他市场职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (768, 761, '政府关系', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (769, 761, '政策研究', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (770, 761, '企业党建', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (771, 762, '网络推广', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (772, 762, '市场营销', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (773, 762, '市场策划', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (774, 762, '市场顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (775, 762, '市场推广', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (776, 762, 'SEO', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (777, 762, 'SEM', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (778, 762, '商务渠道', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (779, 762, '商业数据分析', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (780, 762, '活动策划', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (781, 762, '网络营销', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (782, 762, '海外市场', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (783, 762, 'APP推广', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (784, 762, '选址开发', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (785, 762, '游戏推广', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (786, 762, '营销主管', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (787, 763, '公关媒介', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (788, 763, '媒介经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (789, 763, '广告协调', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (790, 763, '品牌公关', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (791, 763, '媒介专员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (792, 763, '活动策划执行', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (793, 763, '媒介策划', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (794, 764, '会展服务', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (795, 764, '会议活动策划', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (796, 764, '会议活动执行', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (797, 764, '会展活动策划', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (798, 764, '会展活动执行', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (799, 765, '广告', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (800, 765, '广告/会展项目经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (801, 765, '广告创意设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (802, 765, '美术指导', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (803, 765, '广告设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (804, 765, '策划经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (805, 765, '广告文案', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (806, 765, '广告制作', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (807, 765, '媒介投放', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (808, 765, '媒介合作', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (809, 765, '广告审核', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (810, 766, '高端市场职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (811, 766, '市场总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (812, 766, 'CMO', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (813, 766, '公关总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (814, 766, '媒介总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (815, 766, '创意总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (816, 767, '其他市场职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (817, 14, '采购', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (818, 14, '进出口贸易', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (819, 14, '其他采购/贸易职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (820, 817, '采购', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (821, 817, '商品经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (822, 817, '供应商质量工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (823, 817, '采购总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (824, 817, '采购经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (825, 817, '采购专员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (826, 817, '买手', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (827, 817, '采购工程师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (828, 817, '采购主管', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (829, 817, '采购助理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (830, 818, '进出口贸易', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (831, 818, '贸易跟单', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (832, 818, '报关/报检员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (833, 818, '单证员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (834, 819, '其他采购/贸易职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (835, 15, '餐饮', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (836, 15, '酒店', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (837, 15, '零售', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (838, 15, '美容保健', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (839, 15, '运动健身', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (840, 15, '婚礼/花艺', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (841, 15, '宠物服务', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (842, 15, '安保/家政/维修', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (843, 15, '其他服务业职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (844, 835, '餐饮', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (845, 835, '后厨', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (846, 835, '配菜打荷', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (847, 835, '茶艺师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (848, 835, '西点师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (849, 835, '餐饮学徒', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (850, 835, '面点师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (851, 835, '行政总厨', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (852, 835, '厨师长', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (853, 835, '传菜员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (854, 835, '洗碗工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (855, 835, '凉菜厨师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (856, 835, '中餐厨师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (857, 835, '西餐厨师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (858, 835, '日料厨师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (859, 835, '烧烤师傅', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (860, 835, '收银', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (861, 835, '服务员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (862, 835, '厨师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (863, 835, '咖啡师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (864, 835, '送餐员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (865, 835, '餐饮店长', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (866, 835, '领班', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (867, 836, '礼仪/迎宾/接待', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (868, 836, '前厅经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (869, 836, '客房经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (870, 836, '收银', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (871, 836, '酒店前台', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (872, 836, '客房服务员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (873, 836, '酒店经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (874, 837, '督导巡店', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (875, 837, '陈列员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (876, 837, '理货员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (877, 837, '防损员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (878, 837, '卖场经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (879, 837, '促销员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (880, 837, '收银', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (881, 837, '导购', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (882, 837, '店员/营业员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (883, 837, '门店店长', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (884, 838, '纹绣师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (885, 838, '美体师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (886, 838, '美发学徒', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (887, 838, '美容店长', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (888, 838, '足疗师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (889, 838, '按摩师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (890, 838, '美瞳师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (891, 838, '发型师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (892, 838, '美甲师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (893, 838, '化妆师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (894, 838, '养发师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (895, 838, '美容师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (896, 839, '健身', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (897, 839, '救生员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (898, 839, '瑜伽老师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (899, 839, '游泳教练', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (900, 839, '美体教练', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (901, 839, '舞蹈老师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (902, 839, '健身教练', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (903, 840, '花艺师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (904, 840, '婚礼策划', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (905, 841, '宠物美容', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (906, 841, '宠物医生', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (907, 842, '保安', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (908, 842, '保洁', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (909, 842, '保姆', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (910, 842, '月嫂', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (911, 842, '育婴师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (912, 842, '护工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (913, 842, '地铁安检', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (914, 842, '手机维修', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (915, 842, '家电维修', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (916, 842, '保安经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (917, 842, '产后康复师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (918, 842, '钟点工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (919, 842, '押运员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (920, 842, '消防中控员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (921, 842, '保洁经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (922, 843, '其他服务业职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (923, 16, '视觉/交互设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (924, 16, '游戏设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (925, 16, '用户研究', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (926, 16, '高端设计职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (927, 16, '非视觉设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (928, 16, '其他设计职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (929, 923, '视觉设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (930, 923, '视觉设计师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (931, 923, '网页设计师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (932, 923, 'Flash设计师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (933, 923, 'APP设计师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (934, 923, 'UI设计师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (935, 923, '平面设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (936, 923, '3D设计师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (937, 923, '广告设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (938, 923, '多媒体设计师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (939, 923, '原画师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (940, 923, 'CAD设计/制图', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (941, 923, '美工', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (942, 923, '包装设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (943, 923, '设计师助理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (944, 923, '动画设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (945, 923, '插画师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (946, 923, '漫画师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (947, 923, '人像修图师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (948, 923, '交互设计师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (949, 924, '游戏特效', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (950, 924, '游戏界面设计师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (951, 924, '游戏场景', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (952, 924, '游戏角色', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (953, 924, '游戏动作', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (954, 924, '游戏数值策划', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (955, 925, '数据分析师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (956, 925, '用户研究员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (957, 925, 'UX设计师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (958, 925, '用户研究经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (959, 925, '用户研究总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (960, 926, '高端设计职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (961, 926, '设计经理/主管', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (962, 926, '设计总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (963, 926, '视觉设计总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (964, 927, '非视觉设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (965, 927, '展览/展示设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (966, 927, '照明设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (967, 927, '服装/纺织设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (968, 927, '工业设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (969, 927, '橱柜设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (970, 927, '家具设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (971, 927, '家居设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (972, 927, '珠宝设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (973, 927, '室内设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (974, 927, '陈列设计', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (975, 928, '其他设计职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (976, 17, '咨询/调研', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (977, 17, '律师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (978, 17, '翻译', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (979, 17, '其他咨询类职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (980, 976, '咨询调研', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (981, 976, '知识产权/专利/商标代理人', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (982, 976, '心理咨询师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (983, 976, '婚恋咨询师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (984, 976, '企业管理咨询', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (985, 976, '咨询总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (986, 976, '数据分析师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (987, 976, '咨询经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (988, 976, '财务咨询顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (989, 976, 'IT咨询顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (990, 976, '人力资源咨询顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (991, 976, '咨询项目管理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (992, 976, '战略咨询', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (993, 976, '猎头顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (994, 976, '市场调研', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (995, 976, '其他咨询顾问', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (996, 977, '专利律师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (997, 977, '知识产权律师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (998, 977, '律师助理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (999, 977, '事务所律师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1000, 977, '法务', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1001, 978, '英语翻译', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1002, 978, '日语翻译', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1003, 978, '韩语/朝鲜语翻译', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1004, 978, '法语翻译', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1005, 978, '德语翻译', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1006, 978, '俄语翻译', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1007, 978, '西班牙语翻译', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1008, 978, '其他语种翻译', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1009, 979, '其他咨询/翻译类职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1010, 18, '旅游服务', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1011, 18, '旅游产品开发/策划', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1012, 18, '其他旅游职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1013, 1010, '旅游服务', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1014, 1010, '计调', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1015, 1010, '签证专员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1016, 1010, '导游', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1017, 1010, '预定票务', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1018, 1010, '讲解员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1019, 1011, '旅游产品开发/策划', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1020, 1011, '旅游产品经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1021, 1011, '旅游策划师', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1022, 1012, '其他旅游职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1023, 19, '产品经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1024, 19, '高端产品职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1025, 19, '其他产品职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1026, 1023, '产品经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1027, 1023, '网页产品经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1028, 1023, '移动产品经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1029, 1023, '产品助理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1030, 1023, '数据产品经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1031, 1023, '电商产品经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1032, 1023, '游戏策划', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1033, 1023, '产品专员', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1034, 1023, '硬件产品经理', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1035, 1024, '高端产品职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1036, 1024, '产品总监', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1037, 1024, '游戏制作人', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1038, 1024, '产品VP', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1039, 1025, '其他产品职位', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1040, 20, '其他职位类别', NULL, NULL, 99, 1);
INSERT INTO `xy_jobs_cate` VALUES (1041, 1040, '其他职位', NULL, NULL, 99, 1);
