
-- ----------------------------
-- Table structure for xy_config
-- ----------------------------
DROP TABLE IF EXISTS `xy_config`;
CREATE TABLE `xy_config`  (
  `id` int(0) UNSIGNED NOT NULL AUTO_INCREMENT,
  `ctype` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配置分类',
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标题',
  `key` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '键',
  `value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '值',
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '输入类型',
  `tips` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '提示',
  `options` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '候选项',
  `update_time` int(0) NULL DEFAULT NULL,
  `create_time` int(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `ctype`(`ctype`) USING BTREE,
  INDEX `find`(`ctype`, `key`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 202 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '配置项' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of xy_config
-- ----------------------------
INSERT INTO `xy_config` VALUES (1, 'web', '网站名称', 'name', 'XYCMS', 'input', '网站的名字', NULL, 1618205624, 1587092693);
INSERT INTO `xy_config` VALUES (3, 'web', '网站域名', 'url', 'http://{$index_domain}.{$domain}', 'input', '网站首页域名', NULL, 1616036931, 1587108927);
INSERT INTO `xy_config` VALUES (4, 'web', '顶级域名', 'domain', '{$domain}', 'input', '网站域名的顶级域名', NULL, 1618205617, 1587109092);
INSERT INTO `xy_config` VALUES (5, 'web', '图片域名', 'imgurl', 'http://{$index_domain}.{$domain}', 'input', '上传图片对外访问的域名，如若开启了对象储存该域名需要绑定到对象储存自定义访问域名中', NULL, 1605347134, 1587109164);
INSERT INTO `xy_config` VALUES (6, 'web', 'H5域名', 'h5', 'http://{$mobile_domain}.{$domain}', 'input', '移动版域名', NULL, 1618205620, 1587109268);
INSERT INTO `xy_config` VALUES (7, 'web', '服务器IP', 'ip', '', 'input', '服务器的外网IP', NULL, 1587109324, 1587109324);
INSERT INTO `xy_config` VALUES (8, 'web', '统计代码', 'countcode', '', 'textarea', '页面第三方统计代码', NULL, 1603709431, 1587109377);
INSERT INTO `xy_config` VALUES (9, 'web', '网站ICON', 'icon', NULL, 'upload', '网站图标，建议是正方形，大小为32KB', NULL, 1615631554, 1587109596);
INSERT INTO `xy_config` VALUES (10, 'web', '网站LOGO', 'logo', '/uploads/web/img/20210412/d39d4f01e8985be18cb5c64261e6ccd9.png', 'upload', '网站首页logo', NULL, 1618195245, 1587109761);
INSERT INTO `xy_config` VALUES (12, 'web', '联系地址', 'address', '柳州市柳南区柳邕路124号', 'input', '网站的联系地址', NULL, 1618195221, 1588057993);
INSERT INTO `xy_config` VALUES (13, 'sms', 'IP获取上限', 'sms_ip_sum', '15', 'input', '每天单个IP获取短信验证码的次数', NULL, 1589014351, 1589014351);
INSERT INTO `xy_config` VALUES (14, 'sms', '用户获取上限', 'sms_user_sum', '15', 'input', '每天单个用户获取短信验证码的次数', NULL, 1589014386, 1589014386);
INSERT INTO `xy_config` VALUES (15, 'sms', '间隔时间', 'sms_time', '60', 'input', '两次获取短信的间隔时间（单位：s）', NULL, 1589014441, 1589014441);
INSERT INTO `xy_config` VALUES (16, 'sms', '验证码长度', 'sms_length', '6', 'input', '验证码位数，范围：4~6', NULL, 1589015602, 1589015602);
INSERT INTO `xy_config` VALUES (17, 'sms', '验证码有效期', 'sms_expire', '600', 'input', '验证码发送后有效时间（单位：s）', NULL, 1589015797, 1589015797);
INSERT INTO `xy_config` VALUES (18, 'xy_seo', '网站描述', 'description', '新云XYCMS开源PHP人才招聘系统，专业的人才招聘网站系统开源程序，采用 PHP 和 MySQL 数据库构建的高效的人才与企业求职招聘系统源码。\n', 'textarea', '网站SEO描述', NULL, 1618204174, 1593679226);
INSERT INTO `xy_config` VALUES (19, 'xy_seo', '网站关键词', 'keywords', 'xycms招聘系统,新云人才招聘系统,php人才招聘系统,新云cms,人才系统,人才招聘系统,人才网招聘程序,人才网源码,xycms,招聘系统,招聘网站源码,开源PHP人才招聘系统\n', 'textarea', '网站SEO关键词', NULL, 1618204178, 1593679275);
INSERT INTO `xy_config` VALUES (20, 'alipay', '运行状态', 'status', '0', 'switch', '是否开启支付宝支付', NULL, 1596098612, 1596096468);
INSERT INTO `xy_config` VALUES (21, 'alipay', '应用ID', 'appid', '', 'input', '支付宝分配的appid', NULL, 1596097939, 1596096505);
INSERT INTO `xy_config` VALUES (22, 'alipay', '回调地址', 'notify_url', '', 'input', '支付信息回调通知地址，http://open.{$domain}/pay/ali/notify', NULL, 1596101223, 1596096534);
INSERT INTO `xy_config` VALUES (23, 'alipay', '字符集', 'charset', 'UTF-8', 'input', '发送支付信息所使用的字符集', NULL, 1596098019, 1596096609);
INSERT INTO `xy_config` VALUES (24, 'alipay', '验签方式', 'sign_type', 'RSA2', 'input', '验签方式', NULL, 1596098018, 1596097482);
INSERT INTO `xy_config` VALUES (25, 'alipay', '数据格式', 'format', 'json', 'input', '发送的数据格式', NULL, 1596098027, 1596097509);
INSERT INTO `xy_config` VALUES (38, 'alipay', '应用公钥', 'rsaPublicKey', '', 'textarea', '支付宝应用公钥', NULL, 1596102914, 1596097590);
INSERT INTO `xy_config` VALUES (39, 'alipay', '支付宝公钥', 'alipayPublicKey', '', 'textarea', '支付宝公钥', NULL, 1596097999, 1596097641);
INSERT INTO `xy_config` VALUES (40, 'alipay', '销售产品码', 'product_code_pc', 'FACE_TO_FACE_PAYMENT', 'input', 'PC端销售产品码', NULL, 1596098041, 1596097674);
INSERT INTO `xy_config` VALUES (41, 'alipay', 'AES密钥', 'encryptKey', '', 'input', '支付宝的AES密钥', NULL, 1596100476, 1596097509);
INSERT INTO `xy_config` VALUES (42, 'alipay', '应用私钥', 'rsaPrivateKey', '', 'textarea', '支付宝应用私钥', NULL, 1596102933, 1596097509);
INSERT INTO `xy_config` VALUES (43, 'wxpay', '运行状态', 'status', '0', 'switch', '是否开启微信支付', NULL, 1596161809, 1596161809);
INSERT INTO `xy_config` VALUES (44, 'wxpay', '应用ID', 'appid', '', 'input', '微信支付分配的appid', NULL, 1608373928, 1596161850);
INSERT INTO `xy_config` VALUES (45, 'wxpay', '商户ID', 'mchid', '', 'input', '微信支付分配的mchid', NULL, 1596163813, 1596161886);
INSERT INTO `xy_config` VALUES (46, 'wxpay', 'Key', 'key', '', 'input', '微信支付的密钥', NULL, 1596163802, 1596161941);
INSERT INTO `xy_config` VALUES (47, 'wxpay', '回调地址', 'notify_url', '', 'input', '支付信息回调通知地址，http://open.{$domain}/pay/wx/notify', NULL, 1596164169, 1596161964);
INSERT INTO `xy_config` VALUES (48, 'wxlogin', '运行状态', 'status', '0', 'switch', '是否开启微信登录', NULL, 1596272096, 1596272096);
INSERT INTO `xy_config` VALUES (49, 'wxlogin', '应用ID', 'appid', '', 'input', '微信开放平台分配的appid', NULL, 1596272586, 1596272123);
INSERT INTO `xy_config` VALUES (50, 'wxlogin', 'AppSecret', 'appsecret', '', 'input', '微信开放平台分配的AppSecret', NULL, 1596272596, 1596272150);
INSERT INTO `xy_config` VALUES (51, 'wxlogin', '回调地址', 'redirect_uri', '', 'input', '登录信息返回通知地址，http://{$url}/third-party/login/wx', NULL, 1596272332, 1596272332);
INSERT INTO `xy_config` VALUES (52, 'qqlogin', '运行状态', 'status', '0', 'switch', '是否开启QQ登录', NULL, 1596272621, 1596272621);
INSERT INTO `xy_config` VALUES (53, 'qqlogin', '应用ID', 'appid', '', 'input', 'QQ开放平台分配的appid', NULL, 1596272647, 1596272647);
INSERT INTO `xy_config` VALUES (54, 'qqlogin', 'AppKey', 'appkey', '', 'input', 'QQ开放平台分配的AppKey', NULL, 1596272678, 1596272678);
INSERT INTO `xy_config` VALUES (55, 'qqlogin', '回调地址', 'redirect_uri', '', 'input', '登录信息返回通知地址，http://{$url}/third-party/login/qq', NULL, 1596275358, 1596272858);
INSERT INTO `xy_config` VALUES (56, 'xycms_message', '站内及时通知运行状态', 'status_im', '1', 'switch', '是否开启站内即时通知，开启后发送通知可立即向PC,APP,等客户端发送消息', NULL, 1596448253, 1596448253);
INSERT INTO `xy_config` VALUES (57, 'xycms_message', 'APP推送运行状态', 'status_app', '0', 'switch', '是否开启APP推送通知，开启后发送通知可向APP客户端发送消息', NULL, 1596448606, 1596448606);
INSERT INTO `xy_config` VALUES (58, 'xycms_message', '公众号推送', 'status_mp', '0', 'switch', '是否开启公众号推送通知，开启后发送通知可向已关注公众号用户发送消息', NULL, 1596448781, 1596448781);
INSERT INTO `xy_config` VALUES (59, 'xycms_message', '短信通知', 'status_sms', '0', 'switch', '是否开启短信通知，开启后发送通知可向绑定手机号用户发送消息', NULL, 1596448853, 1596448853);
INSERT INTO `xy_config` VALUES (60, 'xycms_message', '及时通知服务地址', 'im_address', '', 'input', '请先确保已开启了及时通知服务，wss://{$wssurl}/wss，使用命令行：php think worker:gateway -d，开启守护进程', NULL, 1608691589, 1596449036);
INSERT INTO `xy_config` VALUES (61, 'xy_score', '企业充值积分', 'recharge_status', '1', 'switch', '是否允许企业充值积分', NULL, 1596876467, 1596705583);
INSERT INTO `xy_config` VALUES (62, 'xy_score', '充值比例（1元等于）', 'recharge_rate', '10', 'input', '充值人民币与积分兑换比例，在购买服务时积分抵扣现金也是此比例', NULL, 1617961556, 1596705655);
INSERT INTO `xy_config` VALUES (64, 'xy_score', '最低充值', 'min_score', '10', 'input', '单次充值最低数额', NULL, 1596708608, 1596708608);
INSERT INTO `xy_config` VALUES (65, 'xy_score', '积分整数抵扣', 'is_integer', '1', 'switch', '开启整数抵扣后，原订单金额为10.5，则只可抵扣10元，需要支付0.5元', NULL, 1597227674, 1597218935);
INSERT INTO `xy_config` VALUES (66, 'xy_score', '抵扣比例', 'proportion', '10', 'input', '最高可抵扣比例订单金额的百分之几', NULL, 1617961540, 1597219060);
INSERT INTO `xy_config` VALUES (67, 'xy_company', '上传营业执照', 'update_business_license_size', '2048', 'input', '上传营业执照文件大小限制，单位：KB,1MB=1024KB', NULL, 1597310347, 1597310347);
INSERT INTO `xy_config` VALUES (68, 'xy_company', '上传企业LOGO', 'update_logo_size', '2048', 'input', '上传企业LOGO文件大小限制，单位：KB,1MB=1024KB', NULL, 1602833747, 1597310397);
INSERT INTO `xy_config` VALUES (69, 'xy_invoice', '索要发票', 'invoice_status', '1', 'switch', '是否开启索要订单发票', NULL, 1597992587, 1597310494);
INSERT INTO `xy_config` VALUES (70, 'xy_invoice', '发票最小金额', 'invoice_min_price', '100', 'input', '索要发票最小金额，当累计到最小金额时才可以索要发票', NULL, 1618133825, 1597310553);
INSERT INTO `xy_config` VALUES (71, 'xy_company', '职位审核', 'jobs_view_status', '1', 'switch', '开启后发布职位需要先审核才能显示', NULL, 1617779086, 1597310644);
INSERT INTO `xy_config` VALUES (72, 'xy_company', '企业风采审核', 'demeanor_view_status', '1', 'switch', '开启后企业风采上传后需要先审核才能显示', NULL, 1609233178, 1597310697);
INSERT INTO `xy_config` VALUES (73, 'xy_company', '职位列表默认显示方式', 'jobs_list_view_type', '1', 'radio', '搜索职位结果列表默认显示方式', '[{\"title\":\"简洁\",\"value\":\"0\"},{\"title\":\"详细\",\"value\":\"1\"}]', 1616493499, 1597310841);
INSERT INTO `xy_config` VALUES (74, 'xy_company', '查看联系方式', 'view_jobs_type', '2', 'radio', '用户查看职位联系方式前置条件', '[{\"title\":\"所有人\",\"value\":\"0\"},{\"title\":\"已登录\",\"value\":\"1\"},{\"title\":\"已登录有简历\",\"value\":\"2\"},{\"title\":\"投递后显示\",\"value\":\"3\"}]', 1610445123, 1597311953);
INSERT INTO `xy_config` VALUES (75, 'xy_company', '职位刷新间隔', 'jobs_refresh_interval', '0', 'input', '职位刷新时间间隔，单位：分钟', NULL, 1617692386, 1597312067);
INSERT INTO `xy_config` VALUES (76, 'xy_company', '申请同一职位间隔', 'jobs_delivery_interval', '0', 'input', '申请同一职位时间间隔，单位：天，0不允许重复投递', NULL, 1597312146, 1597312146);
INSERT INTO `xy_config` VALUES (77, 'xy_company', '30分钟内下载简历数', 'download_resume_sum_30m', '0', 'input', '30分钟内下载简历数，0代表不限制', NULL, 1597312236, 1597312236);
INSERT INTO `xy_config` VALUES (78, 'xy_company', '短信费用承担方', 'sms_bear', '0', 'radio', '如设置为企业承担，则企业需要在增值服务区购买短信包才能发送各种短信提醒', '[{\"title\":\"运营者承担\",\"value\":\"0\"},{\"title\":\"企业承担\",\"value\":\"1\"}]', 1597312322, 1597312322);
INSERT INTO `xy_config` VALUES (79, 'xy_company', '编辑职位后审核状态', 'edit_jobs_status', '0', 'radio', '编辑职位后审核状态是否需要变更', '[{\"title\":\"保持不变\",\"value\":\"0\"},{\"title\":\"重新审核\",\"value\":\"1\"}]', 1618126656, 1597312508);
INSERT INTO `xy_config` VALUES (80, 'xy_company', '强制企业认证', 'is_forceattestation', '1', 'switch', '是否强制企业认证后才能发布职位或其他操作', NULL, 1617265945, 1597312568);
INSERT INTO `xy_config` VALUES (81, 'xy_resume', '每天申请职位限制', 'delivery_resume_today_sum', '15', 'input', '每天可申请多少个职位，0为不限制', NULL, 1618133781, 1597649031);
INSERT INTO `xy_config` VALUES (82, 'xy_resume', '投递简历完整度', 'delivery_resume_progress', '50', 'input', '申请职位要求简历完整度，单位：%，0为不限制', NULL, 1597649115, 1597649115);
INSERT INTO `xy_config` VALUES (83, 'xy_resume', '上传作品照片', 'update_resume_works_size', '5120', 'input', '上传作品照片文件大小限制，单位：KB,1MB=1024KB', NULL, 1618133766, 1597649189);
INSERT INTO `xy_config` VALUES (84, 'xy_resume', '刷新简历间隔', 'resume_refresh_interval', '1', 'input', '简历刷新时间间隔，单位：分钟', NULL, 1597649247, 1597649247);
INSERT INTO `xy_config` VALUES (85, 'xy_resume', '刷新简历免费次数', 'resume_free_refresh_sum', '3', 'input', '每日刷新简历免费次数', NULL, 1597649345, 1597649345);
INSERT INTO `xy_config` VALUES (86, 'xy_resume', '投递简历次数限制', 'delivery_resume_sum_30m', '15', 'input', '30分钟内投递简历次数限制，0为不限制', NULL, 1618133787, 1597649410);
INSERT INTO `xy_config` VALUES (87, 'xy_resume', '简历姓名显示方式', 'resume_name_view', '1', 'radio', '简历姓名默认显示方式', '[{\"title\":\"用户自定义\",\"value\":\"0\"},{\"title\":\"公开\",\"value\":\"2\"},{\"title\":\"先生\\/女士\",\"value\":\"1\"}]', 1615975232, 1597649529);
INSERT INTO `xy_config` VALUES (88, 'xy_resume', '登录后刷新简历', 'login_auto_refresh_resume', '1', 'switch', '登录后自动刷新简历', NULL, 1597649557, 1597649557);
INSERT INTO `xy_config` VALUES (89, 'xy_resume', '简历审核', 'resume_view_status', '0', 'switch', '开启后简历需要先审核才能对外显示', NULL, 1618133946, 1597649633);
INSERT INTO `xy_config` VALUES (90, 'xy_resume', '作品照片审核', 'resume_works_view_status', '1', 'switch', '开启后作品照片上传后需要先审核才能显示', NULL, 1609232031, 1597649681);
INSERT INTO `xy_config` VALUES (91, 'xy_resume', '查看联系方式', 'view_resume_type', '2', 'radio', '用户查看简历方式前置条件', '[{\"title\":\"所有人\",\"value\":\"0\"},{\"title\":\"已登录\",\"value\":\"1\"},{\"title\":\"下载后可见\",\"value\":\"2\"}]', 1616841064, 1597649781);
INSERT INTO `xy_config` VALUES (92, 'xy_resume', '简历下载要求', 'company_download_resume', '2', 'radio', '企业下载简历需要达到的要求', '[{\"title\":\"完善企业资料\",\"value\":\"0\"},{\"title\":\"认证企业\",\"value\":\"1\"},{\"title\":\"有发布职位的企业\",\"value\":\"2\"}]', 1597650025, 1597649951);
INSERT INTO `xy_config` VALUES (93, 'xy_resume', '编辑简历后审核', 'edit_resume_view_status', '1', 'switch', '编辑简历后是否重新审核', NULL, 1597650004, 1597650004);
INSERT INTO `xy_config` VALUES (94, 'xy_resume', '简历模板文件', 'download_resume_tpl', '', 'input', '当用户下载简历时使用的模板', NULL, 1617266579, 1598085494);
INSERT INTO `xy_config` VALUES (95, 'xy_resume', '单份下载简历', 'one_resume_download_price', '10', 'input', '单份下载时需要支付的金额，单位：元', NULL, 1617967114, 1598256218);
INSERT INTO `xy_config` VALUES (96, 'xy_resume', '积分单份下载简历', 'one_resume_download_score_status', '1', 'switch', '是否开启可使用积分抵扣，开启后可使用积分下载简历', NULL, 1598261242, 1598256293);
INSERT INTO `xy_config` VALUES (97, 'xy_resume', '单份简历下载', 'one_resume_download_status', '1', 'switch', '是否开启单份简历直接下载，未开启则只能使用会员权益，增值服务套餐抵扣', NULL, 1598261244, 1598256569);
INSERT INTO `xy_config` VALUES (98, 'xy_resume', '下载简历点', 'download_resume_rule_value', '10', 'input', '下载简历使用下载简历点抵扣数量', NULL, 1617460867, 1598261795);
INSERT INTO `xy_config` VALUES (99, 'xy_email', '运行状态', 'status', '0', 'switch', '是否开启邮件', NULL, 1598324586, 1598324586);
INSERT INTO `xy_config` VALUES (100, 'xy_map', '运行状态', 'status', '0', 'switch', '是否开启地图', NULL, 1598324612, 1598324612);
INSERT INTO `xy_config` VALUES (101, 'xy_oss', '运行状态', 'status', '0', 'switch', '是否开启云储存', NULL, 1598324641, 1598324641);
INSERT INTO `xy_config` VALUES (102, 'xy_email', 'SMTP服务器', 'host', '', 'input', 'SMTP服务器地址', NULL, 1615961983, 1598410413);
INSERT INTO `xy_config` VALUES (103, 'xy_email', '用户名', 'username', '', 'input', '邮箱用户名', NULL, 1615961925, 1598410428);
INSERT INTO `xy_config` VALUES (104, 'xy_email', '邮箱密码', 'password', '', 'input', '“授权密码”或“邮箱的登录密码”', NULL, 1615962162, 1598410508);
INSERT INTO `xy_config` VALUES (105, 'xy_email', '发件人', 'fromname', '', 'input', '发件人名称', NULL, 1598429178, 1598410721);
INSERT INTO `xy_config` VALUES (106, 'xy_oss', '服务商', 'service_provider', 'qcloud', 'radio', '对象储存的提供方', '[{\"title\":\"阿里云\",\"value\":\"aliyun\"},{\"title\":\"腾讯云\",\"value\":\"qcloud\"},{\"title\":\"七牛云\",\"value\":\"qiniu\"}]', 1615191422, 1598410899);
INSERT INTO `xy_config` VALUES (107, 'xy_oss', 'Secret', 'secret', '', 'input', 'Secret', NULL, 1613803267, 1598411283);
INSERT INTO `xy_config` VALUES (108, 'xy_oss', 'Key', 'key', '', 'input', 'Key', NULL, 1613803270, 1598411292);
INSERT INTO `xy_config` VALUES (109, 'xy_oss', '地域', 'region', '', 'input', '储存地域，Region字段', NULL, 1613802698, 1598411563);
INSERT INTO `xy_config` VALUES (110, 'xy_oss', '存储空间', 'bucket', '', 'input', '存储空间或存储桶名称', NULL, 1613802680, 1598411594);
INSERT INTO `xy_config` VALUES (111, 'xy_map', 'WEB服务', 'server_status', '0', 'switch', '是否开启位置搜索，IP定位等功能', NULL, 1598429733, 1598429733);
INSERT INTO `xy_config` VALUES (112, 'xy_map', 'WEB服务Key', 'server_key', '', 'input', '搜索位置，ip定位等功能', NULL, 1598429822, 1598429822);
INSERT INTO `xy_config` VALUES (113, 'xy_map', 'WEB端', 'js_status', '0', 'switch', '是否开启PC，手机端等前端地图控件', NULL, 1598431573, 1598429966);
INSERT INTO `xy_config` VALUES (114, 'xy_map', 'WEB端Key', 'js_key', '', 'input', '点击标记公司位置', NULL, 1598430337, 1598430040);
INSERT INTO `xy_config` VALUES (115, 'xy_map', '微信小程序', 'wechat_status', '0', 'switch', '是否开启微信小程序地图功能', NULL, 1598430106, 1598430106);
INSERT INTO `xy_config` VALUES (116, 'xy_map', '微信小程序Key', 'wechat_key', '', 'input', '这里填写的是地图的KEY', NULL, 1598430353, 1598430146);
INSERT INTO `xy_config` VALUES (117, 'xy_map', 'Android', 'android_status', '0', 'switch', '是否开启AndroidAPP地图功能', NULL, 1598430212, 1598430212);
INSERT INTO `xy_config` VALUES (118, 'xy_map', 'AndroidKey', 'android_key', '', 'input', '这里填写的是地图KEY', NULL, 1598430343, 1598430236);
INSERT INTO `xy_config` VALUES (119, 'xy_map', 'Ios', 'ios_status', '0', 'switch', '是否开启IosAPP地图功能', NULL, 1598430277, 1598430277);
INSERT INTO `xy_config` VALUES (120, 'xy_map', 'IosKey', 'ios_key', '', 'input', '这里填写的是地图KEY', NULL, 1598430348, 1598430293);
INSERT INTO `xy_config` VALUES (121, 'xy_email', '端口', 'port', '', 'input', 'SMTP服务器端口', NULL, 1598433904, 1598433904);
INSERT INTO `xy_config` VALUES (122, 'xy_wechat_mp', '运行状态', 'status', '0', 'switch', '是否开启微信公众号', NULL, 1598514692, 1598514692);
INSERT INTO `xy_config` VALUES (123, 'xy_wechat_mp', 'AppID', 'appid', '', 'input', '微信公众平台分配的appid', NULL, 1613807470, 1598514757);
INSERT INTO `xy_config` VALUES (124, 'xy_wechat_mp', 'AppSecret', 'secret', '', 'input', '微信公众平台分配的AppSecret', NULL, 1613807406, 1598514794);
INSERT INTO `xy_config` VALUES (125, 'xy_wechat_mp', 'TOKEN令牌', 'token', '', 'input', '回调服务器URL地址作为令牌认证', NULL, 1608536144, 1598514817);
INSERT INTO `xy_config` VALUES (126, 'xy_wechat_mp', '通知地址', 'redirect_uri', '', 'input', '接收用户直接向公众号发送消息，https://wechat-mp.{$domain}/wechat', NULL, 1608536318, 1598514900);
INSERT INTO `xy_config` VALUES (127, 'xy_wechat_mp', '消息加解密密钥', 'aeskey', '', 'input', '微信公众平台生成的EncodingAESKey', NULL, 1608536148, 1598514953);
INSERT INTO `xy_config` VALUES (129, 'xy_resume', '简历生成目录', 'resume_docx_path', './xy_docx/', 'input', '简历DOCX文件存放目录，请使用./开头，存放于public目录下', NULL, 1598693558, 1598693426);
INSERT INTO `xy_config` VALUES (130, 'xy_xycms', '应用KEY', 'key', '', 'input', '从新云控制台添加应用后生成的KEY', NULL, 1610004271, 1600760361);
INSERT INTO `xy_config` VALUES (131, 'xy_xycms', '应用Secret', 'secret', '', 'input', '从新云控制台添加应用后生成的Secret', NULL, 1600760404, 1600760404);
INSERT INTO `xy_config` VALUES (132, 'basic', '接口时区验证', 'api_xycms_timestamp', '60', 'input', '是否验证接口请求消耗时间，当超过n秒截断请求，0为不验证', NULL, 1602933509, 1602933509);
INSERT INTO `xy_config` VALUES (133, 'applepay', 'ProductId前缀', 'product_id', '', 'input', '示例:com.xycms.www', NULL, 1608545682, 1608545682);
INSERT INTO `xy_config` VALUES (134, 'xy_wechatminiprogram', '运行状态', 'status', '0', 'switch', '是否开启微信小程序', NULL, 1608882911, 1608882911);
INSERT INTO `xy_config` VALUES (135, 'xy_wechatminiprogram', '应用ID', 'appid', '', 'input', '微信小程序的appId', NULL, 1608882959, 1608882959);
INSERT INTO `xy_config` VALUES (136, 'xy_wechatminiprogram', 'SK', 'secret', '', 'input', '微信小程序的AppSecret', NULL, 1608883178, 1608883003);
INSERT INTO `xy_config` VALUES (137, 'xy_upconfig', '上传路径', 'save_path', 'uploads', 'input', '文件保存目录，位于“public/”下', NULL, 1609226740, 1609226740);
INSERT INTO `xy_config` VALUES (138, 'xy_upconfig', '通用上传大小', 'filesize', '30720', 'input', '上传大小限制，单位：KB,1MB=1024KB', NULL, 1609746315, 1609227029);
INSERT INTO `xy_config` VALUES (139, 'xy_upconfig', '文件类型', 'fileExt', 'png,jpg,jpeg,gif,zip,doc,docx,txt,apk', 'input', '允许上传的文件类型，多个请用“,”英文逗号分隔', NULL, 1614768221, 1609227193);
INSERT INTO `xy_config` VALUES (140, 'xy_upconfig', '图片类型', 'imgExt', 'png,jpg,jpeg,gif', 'input', '允许上传的图片类型，多个请用“,”英文逗号分隔', NULL, 1609746374, 1609227298);
INSERT INTO `xy_config` VALUES (141, 'xy_upconfig', '视频类型', 'videoExt', 'mp4', 'input', '允许上传的视频类型，多个请用“,”英文逗号分隔', NULL, 1609227333, 1609227333);
INSERT INTO `xy_config` VALUES (142, 'xy_company', '上传企业风采照片', 'company_demeanor_size', '3072', 'input', '上传企业风采照片文件大小限制，单位：KB,1MB=1024KB', NULL, 1609227785, 1609227785);
INSERT INTO `xy_config` VALUES (143, 'xy_app_config', '应用名称', 'app_name', 'XYCMS', 'input', '此配置只会展现在应用内', NULL, 1609816676, 1609816676);
INSERT INTO `xy_config` VALUES (144, 'xy_app_config', '错误提示语', 'system_network_error', '服务器繁忙，请稍后再试', 'input', '网络连接错误提示语', NULL, 1609816753, 1609816753);
INSERT INTO `xy_config` VALUES (146, 'xy_im_setting', 'IM接口', 'im_url', 'wss://im.xycms.com/im', 'input', 'IM即时通讯接口', NULL, 1609817317, 1609817006);
INSERT INTO `xy_config` VALUES (147, 'xy_im_setting', 'IM上传接口', 'im_upload_file_url', 'https://im.xycms.com/', 'input', 'IM发送图片，文件上传接口', NULL, 1609817006, 1609817006);
INSERT INTO `xy_config` VALUES (148, 'xy_app_config', 'AppStore链接', 'app_store_url', '', 'input', '上架苹果的应用链接', NULL, 1609829428, 1609829428);
INSERT INTO `xy_config` VALUES (149, 'xy_im_setting', '企业模式', 'company_mode', '3', 'radio', '免费开放：注册即可聊天，完善企业信息，下载对方简历，套餐模式', '[{\"title\":\"免费开放\",\"value\":\"0\"},{\"title\":\"完善企业信息\",\"value\":\"1\"},{\"title\":\"下载对方简历\",\"value\":\"2\"},{\"title\":\"套餐模式\",\"value\":\"3\"}]', 1616654119, 1610012045);
INSERT INTO `xy_config` VALUES (150, 'xy_im_setting', '个人模式', 'personal_mode', '2', 'radio', '免费开放：注册即可聊天，完善简历信息，投递简历，套餐模式', '[{\"title\":\"免费模式\",\"value\":\"0\"},{\"title\":\"完善简历信息\",\"value\":\"1\"},{\"title\":\"投递简历\",\"value\":\"2\"},{\"title\":\"套餐模式\",\"value\":\"3\"}]', 1618133800, 1610012196);
INSERT INTO `xy_config` VALUES (151, 'xy_im_setting', '简历信息完整度', 'personal_mode_resume_progress', '50', 'input', '个人模式为完善简历信息时生效,单位：%', NULL, 1610012874, 1610012291);
INSERT INTO `xy_config` VALUES (152, 'web', 'APP下载域名', 'downUrl', 'http://{$app_domain}.{$domain}', 'input', '用户扫码后显示的下载APP页面，{$domain}', NULL, 1610439603, 1610439603);
INSERT INTO `xy_config` VALUES (153, 'captcha', '验证方式', 'type', '0', 'radio', '使用所选方式进行验证', '[{\"title\":\"内置\",\"value\":\"0\"},{\"title\":\"极验GeeTest\",\"value\":\"1\"},{\"title\":\"VAPTCHA手势验证\",\"value\":\"2\"},{\"title\":\"腾讯云-T-Sec 天御\",\"value\":\"4\"}]', 1618133462, 1610963939);
INSERT INTO `xy_config` VALUES (154, 'captcha', '验证码位数', 'length', '4', 'input', '内置验证码位数', NULL, 1611130121, 1610964000);
INSERT INTO `xy_config` VALUES (155, 'captcha', '字符集合', 'codeSet', '2345678abcdefhijkmnpqrstuvwxyzABCDEFGHJKLMNPQRTUVWXY', 'input', '内置验证码字符集合', NULL, 1610964014, 1610964014);
INSERT INTO `xy_config` VALUES (156, 'captcha', '过期时间', 'expire', '1800', 'input', '内置验证码过期时间', NULL, 1610964028, 1610964028);
INSERT INTO `xy_config` VALUES (157, 'captcha', '中文验证码', 'useZh', '0', 'switch', '内置是否使用中文验证码', NULL, 1610964051, 1610964051);
INSERT INTO `xy_config` VALUES (158, 'captcha', '算术验证码', 'math', '0', 'switch', '内置是否使用算术验证码', NULL, 1615190138, 1610964064);
INSERT INTO `xy_config` VALUES (159, 'captcha', '背景图', 'useImgBg', '0', 'switch', '内置是否使用背景图', NULL, 1615190137, 1610964076);
INSERT INTO `xy_config` VALUES (160, 'captcha', '字符大小', 'fontSize', '14', 'input', '内置验证码字符大小', NULL, 1610964089, 1610964089);
INSERT INTO `xy_config` VALUES (161, 'captcha', '混淆曲线', 'useCurve', '1', 'switch', '内置验证码是否使用混淆曲线', NULL, 1610964109, 1610964109);
INSERT INTO `xy_config` VALUES (162, 'captcha', '添加杂点', 'useNoise', '0', 'switch', '内置验证码是否添加杂点', NULL, 1610964127, 1610964127);
INSERT INTO `xy_config` VALUES (163, 'captcha', '验证码字体', 'fontttf', '', 'input', '验证码字体 不设置则随机，public目录下', NULL, 1610964369, 1610964215);
INSERT INTO `xy_config` VALUES (164, 'captcha', '背景颜色', 'bg', '[255,255,255]', 'array', '内置验证码背景颜色', NULL, 1610966837, 1610964275);
INSERT INTO `xy_config` VALUES (165, 'captcha', '图片高度', 'imageH', '0', 'input', '内置验证码图片高度', NULL, 1611129629, 1610964294);
INSERT INTO `xy_config` VALUES (166, 'captcha', '图片宽度', 'imageW', '0', 'input', '内置验证码图片宽度', NULL, 1611129627, 1610964307);
INSERT INTO `xy_config` VALUES (167, 'xy_geetest', '极验ID', 'id', '', 'input', '极验后台获取的ID', NULL, 1611044685, 1611044685);
INSERT INTO `xy_config` VALUES (168, 'xy_geetest', '极验KEY', 'key', '', 'input', '极验后台获取的KEY', NULL, 1611044716, 1611044716);
INSERT INTO `xy_config` VALUES (169, 'xy_vaptcha', 'VID', 'vid', '', 'input', 'VAPTCHA手势验证后台获取的VID', NULL, 1611049593, 1611049593);
INSERT INTO `xy_config` VALUES (170, 'xy_vaptcha', 'KEY', 'key', '', 'input', 'VAPTCHA手势验证后台获取的KEY', NULL, 1611049613, 1611049613);
INSERT INTO `xy_config` VALUES (171, 'xy_tencent_tsec', 'APPID', 'appid', '', 'input', '腾讯云控制台-天御获取的APPID', NULL, 1611053654, 1611053654);
INSERT INTO `xy_config` VALUES (172, 'xy_tencent_tsec', 'APP SK', 'sk', '', 'input', '腾讯云控制台-天御获取的APP SK', NULL, 1611053687, 1611053687);
INSERT INTO `xy_config` VALUES (173, 'xy_tencent_tsec', 'SecretId', 'SecretId', '', 'input', '腾讯云控制台-API密钥管理获取SecretId', NULL, 1611055348, 1611055348);
INSERT INTO `xy_config` VALUES (174, 'xy_tencent_tsec', 'SecretKey', 'SecretKey', '', 'input', '腾讯云控制台-API密钥管理获取SecretKey', NULL, 1611055385, 1611055385);
INSERT INTO `xy_config` VALUES (175, 'captcha', '错误次数', 'error_sum', '3', 'input', '当输入密码错误达N次强制验证码验证', NULL, 1611126212, 1611126212);
INSERT INTO `xy_config` VALUES (176, 'xy_default_avatar', '用户头像', 'user', '/uploads/web/img/20210412/c44ff1671080cbd399e885d03a5b66d8.png', 'upload', '用户默认头像', NULL, 1618201454, 1611223267);
INSERT INTO `xy_config` VALUES (177, 'xy_default_avatar', '企业LOGO', 'company_logo', '/uploads/web/img/20210412/37490be79494232e8ef352fb83bc8fe9.png', 'upload', '企业默认LOGO', NULL, 1618201457, 1611223345);
INSERT INTO `xy_config` VALUES (178, 'xy_default_avatar', '企业高管', 'executives_headimg', '/uploads/web/img/20210412/0d9a71dd1bfcbd9721c2c87d71416c77.png', 'upload', '企业高管默认头像', NULL, 1618201463, 1611223670);
INSERT INTO `xy_config` VALUES (179, 'web', '小程序二维码', 'wxacode', '/uploads/web/img/20210412/91af4e7a199a7be7222ae66e0646db90.jpg', 'upload', '扫一扫直接打开小程序', NULL, 1618204661, 1611225055);
INSERT INTO `xy_config` VALUES (180, 'basic', '接口并发最大值', 'api_xycms_concurrent_sum', '50', 'input', '同一IP在5秒内允许最大访问次数，超过将截断请求，0为不限制', NULL, 1618037047, 1611913427);
INSERT INTO `xy_config` VALUES (181, 'web', '版权信息', 'copyright', '本网站之所有招聘信息、作品、版权均归XYCMS所有，未经书面授权不得转载。', 'textarea', '网站版权信息', NULL, 1618195104, 1614839562);
INSERT INTO `xy_config` VALUES (182, 'web', '备案信息', 'icp', '桂ICP备1000000号', 'input', 'ICP备案信息', NULL, 1618195145, 1614839595);
INSERT INTO `xy_config` VALUES (183, 'web', '公安备案号', 'ps_icp', '桂公网安备 45000000000号 ', 'input', '公安备案信息', NULL, 1618195144, 1614840043);
INSERT INTO `xy_config` VALUES (184, 'web', 'ICP经营许可证编号', 'icp_management', '桂B-2000000', 'input', '互联网信息服务业务经营许可证', NULL, 1618195165, 1614840104);
INSERT INTO `xy_config` VALUES (185, 'web', '人力资源许可证', 'hr_license', '450000000000号', 'input', '人力资源服务许可证', NULL, 1618195157, 1614840200);
INSERT INTO `xy_config` VALUES (186, 'web', '联系电话', 'tel', '0772-100000', 'input', '网站的联系电话', NULL, 1618195172, 1614840239);
INSERT INTO `xy_config` VALUES (187, 'web', '联系邮箱', 'email', '', 'input', '网站的联系邮箱', NULL, 1614840256, 1614840256);
INSERT INTO `xy_config` VALUES (188, 'xy_seo', '百度自动推送', 'baidu_auto_include', '', 'textarea', '百度站长平台获取的自动收录代码', NULL, 1614913292, 1614850145);
INSERT INTO `xy_config` VALUES (189, 'xy_seo', '360自动推送', '360_auto_include', '', 'textarea', '360站长平台获取的自动收录代码', NULL, 1614850741, 1614850180);
INSERT INTO `xy_config` VALUES (190, 'xycms_message', '邮件推送', 'status_email', '1', 'switch', '是否开启邮件推送通知，开启后通知可向绑定邮件用户发送消息', NULL, 1615630502, 1615630502);
INSERT INTO `xy_config` VALUES (191, 'xy_getui', 'AppID', 'appid', '', 'input', 'DCloud开发者后台获取的AppID', NULL, 1615799313, 1615799245);
INSERT INTO `xy_config` VALUES (192, 'xy_getui', 'AppKey', 'key', '', 'input', 'DCloud开发者后台获取的AppKey', NULL, 1615799315, 1615799265);
INSERT INTO `xy_config` VALUES (193, 'xy_getui', 'AppSecret', 'app_secret', '', 'input', 'DCloud开发者后台获取的AppSecret', NULL, 1615799320, 1615799283);
INSERT INTO `xy_config` VALUES (194, 'xy_getui', 'MasterSecret', 'ms', '', 'input', 'DCloud开发者后台获取的MasterSecret', NULL, 1615799341, 1615799302);
INSERT INTO `xy_config` VALUES (195, 'web', '公众号域名', 'wechatmp', 'http://{$wechatmp_domain}.{$domain}', 'input', '微信公众号域名，https://wechat-mp.{$domain}', NULL, 1615969897, 1615969897);
INSERT INTO `xy_config` VALUES (196, 'xy_company', '企业认证材料', 'attestation_ms', 'loc,license,id_card_e,id_card_f,supplement', 'checkbox', '企业认证材料需要上传的材料', '[{\"title\":\"法人身份证人像面\",\"value\":\"id_card_f\"},{\"title\":\"法人身份证国徽面\",\"value\":\"id_card_e\"},{\"title\":\"营业执照\",\"value\":\"license\"},{\"title\":\"承诺函\",\"value\":\"loc\"},{\"title\":\"补充材料\",\"value\":\"supplement\"}]', 1618046475, 1616399498);
INSERT INTO `xy_config` VALUES (198, 'web', '微信公众号二维码', 'wxmpcode', '/uploads/web/img/20210412/44b591a59f0ea05c7fac2346a4d1a744.jpg', 'upload', '扫码关注公众号', NULL, 1618204645, 1616669268);
INSERT INTO `xy_config` VALUES (199, 'xy_resume', '简历模糊化', 'resume_vague', '2', 'radio', '提示：若选择“开放”，任何人都可以查看具体的工作经历等内容', '[{\"title\":\"开放\",\"value\":\"0\"},{\"title\":\"企业登录\",\"value\":\"1\"},{\"title\":\"发布职位\",\"value\":\"2\"}]', 1617967121, 1617012316);
INSERT INTO `xy_config` VALUES (200, 'xy_company', '职位匹配', 'search_resume_jobcate', '1', 'radio', '根据求职意向职位分类匹配精准度', '[{\"title\":\"模糊匹配\",\"value\":\"0\"},{\"title\":\"一般匹配\",\"value\":\"1\"},{\"title\":\"精准匹配\",\"value\":\"2\"}]', 1617091907, 1617091426);
INSERT INTO `xy_config` VALUES (201, 'xy_resume', '简历身份', 'resume_role_type', '0', 'switch', '强制简历用户身份为个人，否则不在对外列表中显示简历', NULL, 1617966098, 1617952496);
INSERT INTO `xy_config` VALUES (202, 'xy_company', '二维码类型', 'jobs_qr_type', 'qrcode', 'radio', '职位海报二维码类型', '[{\"title\":\"二维码\",\"value\":\"qrcode\"},{\"title\":\"场景码\",\"value\":\"mpqrcode\"},{\"title\":\"小程序码\",\"value\":\"miniprogramqrcode\"}]', 1618987246, 1618987239);
INSERT INTO `xy_config` VALUES (203, 'xy_seo', '网站首页标题', 'title', 'XYCMS', 'input', '', NULL, 1619424040, 1619423978);
INSERT INTO `xy_config` VALUES (210, 'xy_resume', '简历字段', 'required_field', 'info', 'checkbox', '设置简历必填字段', '[{\"title\":\"自我描述\",\"value\":\"self_description\"},{\"title\":\"教育经历\",\"value\":\"educational_experience\"},{\"title\":\"工作经历\",\"value\":\"work_experience\"},{\"title\":\"培训经历\",\"value\":\"training_experience\"},{\"title\":\"项目经历\",\"value\":\"project_experience\"},{\"title\":\"证书\",\"value\":\"certificate\"},{\"title\":\"语言能力\",\"value\":\"language_ability\"},{\"title\":\"特长\",\"value\":\"specialty_label\"}]', 1621837542, 1621825267);
INSERT INTO `xy_config` VALUES (211, 'xy_resume', '基本信息', 'progress_info', '10', 'input', '基本信息完善度占比，单位：%', NULL, 1621825580, 1621825580);
INSERT INTO `xy_config` VALUES (212, 'xy_resume', '求职意向', 'progress_employment_intention', '10', 'input', '求职意向完善度占比，单位：%', NULL, 1621825644, 1621825644);
INSERT INTO `xy_config` VALUES (213, 'xy_resume', '自我描述', 'progress_self_description', '5', 'input', '自我描述完善度占比，单位：%', NULL, 1621825676, 1621825676);
INSERT INTO `xy_config` VALUES (214, 'xy_resume', '教育经历', 'progress_educational_experience', '15', 'input', '教育经历完善度占比，单位：%', NULL, 1621825802, 1621825711);
INSERT INTO `xy_config` VALUES (215, 'xy_resume', '工作经历', 'progress_work_experience', '15', 'input', '工作经历完善度占比，单位：%', NULL, 1621825809, 1621825732);
INSERT INTO `xy_config` VALUES (216, 'xy_resume', '项目经历', 'progress_project_experience', '15', 'input', '项目经历完善度占比，单位：%', NULL, 1621825786, 1621825786);
INSERT INTO `xy_config` VALUES (217, 'xy_resume', '培训经历', 'progress_training_experience', '5', 'input', '培训经历完善度占比，单位：%', NULL, 1622083933, 1621825862);
INSERT INTO `xy_config` VALUES (218, 'xy_resume', '证书', 'progress_certificate', '5', 'input', '证书完善度占比，单位：%', NULL, 1622083932, 1621825888);
INSERT INTO `xy_config` VALUES (219, 'xy_resume', '语言能力', 'progress_language_ability', '5', 'input', '语言能力度占比，单位：%', NULL, 1621825908, 1621825908);
INSERT INTO `xy_config` VALUES (220, 'xy_resume', '特长', 'progress_specialty_label', '5', 'input', '特长度占比，单位：%', NULL, 1621825929, 1621825929);
INSERT INTO `xy_config` VALUES (246, 'xy_sub_website', '运行状态', 'status', '0', 'switch', '是否开启分站', NULL, 1623428721, 1623308055);
INSERT INTO `xy_config` VALUES (247, 'xy_sub_website', '分站目录', 'path_url', 'subsite', 'input', '更改目录请到API->PC应用中找到“分站”接口更改接口URL', NULL, 1623308527, 1623308527);
INSERT INTO `xy_config` VALUES (248, 'xy_sub_website', '地区关联', 'data_is_all', '0', 'switch', '是否关联总站的数据', NULL, 1623318069, 1623315541);
INSERT INTO `xy_config` VALUES (249, 'xy_seo', '头条自动收录', 'toutiao_auto_include', '', 'textarea', '头条站长平台获取的自动收录代码，https://zhanzhang.toutiao.com', NULL, 1623837484, 1623837484);
INSERT INTO `xy_config` VALUES (250, 'xy_company', '承诺函模板', 'attestation_loc', '/uploads/publics/files/20210630/0adbf60ec6824b561961b0ca7013d4cb.doc', 'upload_file', '企业认证承诺函模板', NULL, 1625017830, 1624503196);
INSERT INTO `xy_config` VALUES (251, 'xy_company', '职位薪资', 'jobs_salary_show_type', '1', 'radio', '职位薪资显示方式，元：1000~2000元，k：1-2k', '[{\"title\":\"k\",\"value\":\"0\"},{\"title\":\"元\",\"value\":\"1\"}]', 1627283810, 1627282906);
INSERT INTO `xy_config` VALUES (252, 'basic', '浏览量随机数', 'view_rand', '1', 'input', '每次访问职位，企业，文章时随机增加1+n，小于等于1则不开启', NULL, 1627545420, 1627437295);
INSERT INTO `xy_config` VALUES (253, 'xy_company', '高薪职位', 'high_salary', '10', 'input', '高薪职位薪资要求，单位：k', NULL, 1627462027, 1627462027);
INSERT INTO `xy_config` VALUES (254, 'xy_company', '热门职位', 'jobs_hot', '10', 'input', '热门职位投递量要求，单位：份', NULL, 1627462663, 1627462248);
INSERT INTO `xy_config` VALUES (255, 'basic', '接口日志有效期', 'api_log_day', '30', 'input', '接口访问日志有效期，0为永久保存，单位：天', NULL, 1628154178, 1627540942);
INSERT INTO `xy_config` VALUES (256, 'basic', '底部引导条', 'pc_footer_guide', '1', 'switch', '是否开启PC首页底部引导条', NULL, 1628072019, 1628070415);
INSERT INTO `xy_config` VALUES (257, 'basic', '底部引导文案', 'pc_footer_guide_text', '海量职位，让求职招聘更简单！', 'input', 'PC底部引导条文案', NULL, 1628151558, 1628070513);
