
-- ----------------------------
-- Table structure for xy_auth
-- ----------------------------
DROP TABLE IF EXISTS `xy_auth`;
CREATE TABLE `xy_auth`  (
  `aid` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pid` int(10) NULL DEFAULT 0,
  `alias` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `title` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '权限名称',
  `controller` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '控制器',
  `fun` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '方法',
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '路由url',
  `param` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `status` tinyint(1) NULL DEFAULT 1 COMMENT '状态',
  `method` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '请求方法',
  `is_nav` tinyint(1) NULL DEFAULT 0,
  `show` tinyint(1) NULL DEFAULT 1 COMMENT '1，显示 0，隐藏',
  `icon` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `sort` int(4) NULL DEFAULT 99,
  `code` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `update_time` int(10) NULL DEFAULT NULL,
  `create_time` int(10) NULL DEFAULT NULL,
  PRIMARY KEY (`aid`) USING BTREE,
  INDEX `auth`(`controller`, `fun`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 389 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '权限规则' ROW_FORMAT = Compact;

-- ----------------------------
-- Records of xy_auth
-- ----------------------------
INSERT INTO `xy_auth` VALUES (1, 0, NULL, '首页', '', '', '', '', 1, '', 1, 1, '', 1, '', 1587350336, 1586834930);
INSERT INTO `xy_auth` VALUES (2, 1, NULL, '欢迎', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-lollipop\"></i>', 99, '', 1586835528, 1586835528);
INSERT INTO `xy_auth` VALUES (3, 2, NULL, '数据概览', 'Index', 'index', '/', '', 1, 'get', 0, 1, '', 99, 'Route::get(\'/\',\'bsadmin/Index/index\');', 1586852312, 1586835637);
INSERT INTO `xy_auth` VALUES (4, 0, NULL, '系统', '', '', '', '', 1, '', 1, 1, '', 9, '', 1620788780, 1586835915);
INSERT INTO `xy_auth` VALUES (5, 4, NULL, '权限', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-lock\"></i>', 99, '', 1586835945, 1586835945);
INSERT INTO `xy_auth` VALUES (6, 4, NULL, '角色', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-view\"></i>', 99, '', 1586835975, 1586835975);
INSERT INTO `xy_auth` VALUES (7, 4, NULL, '管理员', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-user\"></i>', 99, '', 1586836000, 1586836000);
INSERT INTO `xy_auth` VALUES (8, 5, NULL, '权限列表', 'Auth', 'index', 'auth', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'auth\',\'bsadmin/Auth/index\');', 1586836040, 1586836040);
INSERT INTO `xy_auth` VALUES (9, 5, NULL, '添加权限', 'Auth', 'addAuth', 'addAuth', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'addAuth\',\'bsadmin/Auth/addAuth\');', 1586836064, 1586836064);
INSERT INTO `xy_auth` VALUES (10, 5, NULL, '更改权限状态', 'Auth', 'setAuthStatus', 'setAuthStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'setAuthStatus/:id/:status\',\'bsadmin/Auth/setAuthStatus\');', 1586921033, 1586836546);
INSERT INTO `xy_auth` VALUES (11, 5, NULL, '更改权限是否显示', 'Auth', 'setAuthShow', 'setAuthShow', '/:id/:show', 1, 'get', 0, 0, '', 99, 'Route::get(\'setAuthShow/:id/:show\',\'bsadmin/Auth/setAuthShow\');', 1586922071, 1586836599);
INSERT INTO `xy_auth` VALUES (12, 6, '', '角色列表', 'Role', 'index', 'role', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'role\',\'bsadmin/Role/index\');', 1610962876, 1586836681);
INSERT INTO `xy_auth` VALUES (13, 6, NULL, '添加角色', 'Role', 'addRole', 'addRole', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'addRole\',\'bsadmin/Role/addRole\');', 1586836762, 1586836762);
INSERT INTO `xy_auth` VALUES (14, 6, NULL, '编辑角色', 'Role', 'editRole', 'editRole', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'editRole/:id\',\'bsadmin/Role/editRole\');', 1586848094, 1586836800);
INSERT INTO `xy_auth` VALUES (15, 6, NULL, '删除角色', 'Role', 'delRole', 'delRole', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'delRole/:id\',\'bsadmin/Role/delRole\');', 1586848108, 1586836834);
INSERT INTO `xy_auth` VALUES (16, 7, NULL, '管理员列表', 'Admin', 'index', 'admin', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'admin\',\'bsadmin/Admin/index\');', 1586836977, 1586836977);
INSERT INTO `xy_auth` VALUES (17, 7, NULL, '添加管理员', 'Admin', 'addAdmin', 'addAdmin', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'addAdmin\',\'bsadmin/Admin/addAdmin\');', 1586837016, 1586837016);
INSERT INTO `xy_auth` VALUES (18, 7, NULL, '编辑管理员', 'Admin', 'editAdmin', 'editAdmin', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'editAdmin/:id\',\'bsadmin/Admin/editAdmin\');', 1586848127, 1586837072);
INSERT INTO `xy_auth` VALUES (19, 7, NULL, '设置管理员状态', 'Admin', 'setAdminStatus', 'setAdminStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'setAdminStatus/:id/:status\',\'bsadmin/Admin/setAdminStatus\');', 1586848146, 1586837117);
INSERT INTO `xy_auth` VALUES (20, 5, NULL, '编辑权限', 'Auth', 'editAuth', 'editAuth', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'editAuth/:id\',\'bsadmin/Auth/editAuth\');', 1586848057, 1586848057);
INSERT INTO `xy_auth` VALUES (21, 5, NULL, '异步更新权限', 'Auth', 'updateRouteFileAjax', 'updateRouteFileAjax', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'updateRouteFileAjax\',\'bsadmin/Auth/updateRouteFileAjax\');', 1586855421, 1586855421);
INSERT INTO `xy_auth` VALUES (22, 0, NULL, '公共权限', '', '', '', '', 1, '', 1, 0, '', 99, NULL, 1587538341, 1586859400);
INSERT INTO `xy_auth` VALUES (23, 22, NULL, '退出登录', 'Base', 'outLogin', 'outLogin', '', 1, 'get', 0, 0, '', 99, 'Route::get(\'outLogin\',\'bsadmin/Base/outLogin\');', 1586859436, 1586859436);
INSERT INTO `xy_auth` VALUES (24, 7, NULL, '获取管理员日志', 'Admin', 'getAdminLog', 'getAdminLog', '', 1, 'get', 0, 0, '', 99, 'Route::get(\'getAdminLog\',\'bsadmin/Admin/getAdminLog\');', 1586945653, 1586944659);
INSERT INTO `xy_auth` VALUES (25, 6, '', '异步更新角色缓存', 'Role', 'updateRoleFileAjax', 'updateRoleFileAjax', '/[:id]', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'updateRoleFileAjax/[:id]\',\'bsadmin/Role/updateRoleFileAjax\');', 1598857687, 1586947859);
INSERT INTO `xy_auth` VALUES (26, 4, NULL, '配置', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-setting\"></i>', 99, NULL, 1587018725, 1587018725);
INSERT INTO `xy_auth` VALUES (27, 26, NULL, '基础配置', 'Setting', 'basic', 'setting/basic', '', 1, 'rule', 0, 1, '', 1, 'Route::rule(\'setting/basic\',\'bsadmin/Setting/basic\');', 1617707012, 1587019581);
INSERT INTO `xy_auth` VALUES (28, 26, NULL, '站点配置', 'Setting', 'web', 'setting/web', '', 1, 'rule', 0, 1, '', 2, 'Route::rule(\'setting/web\',\'bsadmin/Setting/web\');', 1617707013, 1587019762);
INSERT INTO `xy_auth` VALUES (29, 26, NULL, '添加配置', 'Setting', 'add', 'setting/add', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'setting/add\',\'bsadmin/Setting/add\');', 1587020452, 1587020452);
INSERT INTO `xy_auth` VALUES (30, 4, NULL, '文件管理', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-folder\"></i>', 99, NULL, 1587026515, 1587026515);
INSERT INTO `xy_auth` VALUES (31, 22, NULL, '上传文件', 'Publics', 'uploads', 'uploadFiles', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'uploadFiles\',\'bsadmin/Publics/uploads\');', 1587026600, 1587026600);
INSERT INTO `xy_auth` VALUES (32, 26, NULL, '编辑配置', 'Setting', 'editConfig', 'setting/edit', '', 1, 'post', 0, 0, '', 99, 'Route::post(\'setting/edit\',\'bsadmin/Setting/editConfig\');', 1588754594, 1587108224);
INSERT INTO `xy_auth` VALUES (33, 30, NULL, '文件列表', 'Files', 'index', 'files', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'files\',\'bsadmin/Files/index\');', 1587189906, 1587189906);
INSERT INTO `xy_auth` VALUES (34, 30, NULL, '上传文件', 'Files', 'uploads', 'files/uploads', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'files/uploads\',\'bsadmin/Files/uploads\');', 1587189993, 1587189976);
INSERT INTO `xy_auth` VALUES (35, 0, NULL, '内容', '', '', '', '', 1, '', 1, 1, '', 5, NULL, 1587350924, 1587350297);
INSERT INTO `xy_auth` VALUES (36, 0, NULL, '企业', '', '', '', '', 1, '', 1, 1, '', 3, NULL, 1617703679, 1587350902);
INSERT INTO `xy_auth` VALUES (37, 0, '', '个人', '', '', '', '', 1, '', 1, 1, '', 4, '', 1617703680, 1587350913);
INSERT INTO `xy_auth` VALUES (38, 0, NULL, '运营', '', '', '', '', 1, '', 1, 1, '', 5, NULL, 1617703683, 1587350934);
INSERT INTO `xy_auth` VALUES (39, 35, NULL, '文章分类', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-c-scale-to-original\"></i>', 99, NULL, 1587364867, 1587364867);
INSERT INTO `xy_auth` VALUES (40, 35, NULL, '文章管理', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-document\"></i>', 99, NULL, 1587364915, 1587364915);
INSERT INTO `xy_auth` VALUES (41, 39, NULL, '分类列表', 'Article', 'cate', 'article/cate', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'article/cate\',\'bsadmin/Article/cate\');', 1587365021, 1587365021);
INSERT INTO `xy_auth` VALUES (42, 39, NULL, '添加分类', 'Article', 'addCate', 'article/addCate', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'article/addCate\',\'bsadmin/Article/addCate\');', 1587365070, 1587365070);
INSERT INTO `xy_auth` VALUES (43, 40, NULL, '文章列表', 'Article', 'index', 'article', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'article\',\'bsadmin/Article/index\');', 1587365100, 1587365100);
INSERT INTO `xy_auth` VALUES (44, 40, NULL, '发布文章', 'Article', 'addArticle', 'addArticle', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'addArticle\',\'bsadmin/Article/addArticle\');', 1587365138, 1587365138);
INSERT INTO `xy_auth` VALUES (45, 40, NULL, '设置文章状态', 'Article', 'setArticleStatus', 'setArticleStatus', '/:id/:status', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'setArticleStatus/:id/:status\',\'bsadmin/Article/setArticleStatus\');', 1587365346, 1587365346);
INSERT INTO `xy_auth` VALUES (46, 39, NULL, '编辑分类', 'Article', 'editCate', 'article/editCate', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'article/editCate/:id\',\'bsadmin/Article/editCate\');', 1587367822, 1587367822);
INSERT INTO `xy_auth` VALUES (47, 40, NULL, '编辑文章', 'Article', 'editArticle', 'editArticle', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'editArticle/:id\',\'bsadmin/Article/editArticle\');', 1587367852, 1587367852);
INSERT INTO `xy_auth` VALUES (48, 22, NULL, '获取编辑器配置', 'Ueditor', 'getConfig', 'ueditor/getConfig', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'ueditor/getConfig\',\'bsadmin/Ueditor/getConfig\');', 1587375966, 1587375966);
INSERT INTO `xy_auth` VALUES (49, 36, NULL, '主体', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-office-building\"></i>', 1, NULL, 1597990570, 1587456736);
INSERT INTO `xy_auth` VALUES (50, 49, NULL, '企业列表', 'Company', 'index', 'company', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'company\',\'bsadmin/Company/index\');', 1587456924, 1587456924);
INSERT INTO `xy_auth` VALUES (51, 36, NULL, '职位管理', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-suitcase\"></i>', 99, NULL, 1587457036, 1587457036);
INSERT INTO `xy_auth` VALUES (52, 51, NULL, '职位列表', 'Jobs', 'index', 'jobs', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'jobs\',\'bsadmin/Jobs/index\');', 1587796999, 1587457120);
INSERT INTO `xy_auth` VALUES (53, 49, '', '企业相册', 'Company', 'demeanor', 'company/demeanor', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'company/demeanor\',\'bsadmin/Company/demeanor\');', 1615378253, 1587457246);
INSERT INTO `xy_auth` VALUES (54, 171, '', '企业设置', 'Company', 'setting', 'company/setting', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'company/setting\',\'bsadmin/Company/setting\');', 1597990582, 1587457473);
INSERT INTO `xy_auth` VALUES (55, 0, NULL, '用户', '', '', '', '', 1, '', 1, 1, '', 2, NULL, 1617703679, 1587457942);
INSERT INTO `xy_auth` VALUES (56, 55, NULL, '用户管理', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-user\"></i>', 1, NULL, 1615016356, 1587457992);
INSERT INTO `xy_auth` VALUES (57, 56, NULL, '用户列表', 'User', 'index', 'user', '', 1, 'rule', 0, 1, '', 1, 'Route::rule(\'user\',\'bsadmin/User/index\');', 1610179581, 1587458042);
INSERT INTO `xy_auth` VALUES (58, 5, NULL, '设置权限排序', 'Auth', 'setAuthSort', 'setAuthSort', '/:id/:sort', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'setAuthSort/:id/:sort\',\'bsadmin/Auth/setAuthSort\');', 1587464692, 1587464692);
INSERT INTO `xy_auth` VALUES (59, 56, NULL, '获取用户信息', 'User', 'getUserInfo', 'getUserInfo', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'getUserInfo/:id\',\'bsadmin/User/getUserInfo\');', 1587541370, 1587541370);
INSERT INTO `xy_auth` VALUES (60, 56, NULL, '微信用户', 'User', 'wxUser', 'wxUser', '', 1, 'rule', 0, 1, '', 2, 'Route::rule(\'wxUser\',\'bsadmin/User/wxUser\');', 1610179593, 1587545294);
INSERT INTO `xy_auth` VALUES (61, 49, NULL, '手动添加企业', 'Company', 'addCompany', 'company/addCompany', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'company/addCompany\',\'bsadmin/Company/addCompany\');', 1587629534, 1587629534);
INSERT INTO `xy_auth` VALUES (62, 56, NULL, '判断用户是否存在', 'User', 'hasUser', 'hasUser', '', 1, 'post', 0, 0, '', 99, 'Route::post(\'hasUser\',\'bsadmin/User/hasUser\');', 1587712650, 1587712650);
INSERT INTO `xy_auth` VALUES (63, 49, NULL, '编辑企业', 'Company', 'editCompany', 'company/editCompany', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'company/editCompany/:id\',\'bsadmin/Company/editCompany\');', 1587719595, 1587719595);
INSERT INTO `xy_auth` VALUES (64, 49, NULL, '获取企业信息', 'Company', 'getCompanyInfo', 'getCompanyInfo', '/:id', 1, 'get', 0, 0, '', 99, 'Route::get(\'getCompanyInfo/:id\',\'bsadmin/Company/getCompanyInfo\');', 1587797388, 1587797388);
INSERT INTO `xy_auth` VALUES (65, 36, '', '分类/行业', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-c-scale-to-original\"></i>', 99, '', 1615368576, 1587804300);
INSERT INTO `xy_auth` VALUES (66, 65, NULL, '添加职位分类', 'Jobs', 'addJobsCate', 'jobs/addCate', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'jobs/addCate\',\'bsadmin/Jobs/addJobsCate\');', 1587804773, 1587804409);
INSERT INTO `xy_auth` VALUES (67, 65, NULL, '职位分类列表', 'Jobs', 'cate', 'jobs/cate', '', 1, 'rule', 0, 1, '', 1, 'Route::rule(\'jobs/cate\',\'bsadmin/Jobs/cate\');', 1587804759, 1587804759);
INSERT INTO `xy_auth` VALUES (68, 65, NULL, '编辑职位分类', 'Jobs', 'editJobsCate', 'jobs/editCate', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'jobs/editCate/:id\',\'bsadmin/Jobs/editJobsCate\');', 1587972016, 1587972016);
INSERT INTO `xy_auth` VALUES (69, 37, NULL, '简历', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-tickets\"></i>', 99, NULL, 1587975912, 1587975912);
INSERT INTO `xy_auth` VALUES (70, 69, NULL, '简历列表', 'Resume', 'index', 'resume', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'resume\',\'bsadmin/Resume/index\');', 1587975962, 1587975962);
INSERT INTO `xy_auth` VALUES (71, 39, NULL, '删除分类', 'Article', 'delCate', 'article/delCate', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'article/delCate/:id\',\'bsadmin/Article/delCate\');', 1588151627, 1588151349);
INSERT INTO `xy_auth` VALUES (72, 4, NULL, 'API', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-cpu\"></i>', 99, NULL, 1588753335, 1588753335);
INSERT INTO `xy_auth` VALUES (73, 72, NULL, '应用', 'Client', 'index', 'client/app', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'client/app\',\'bsadmin/Client/index\');', 1588753527, 1588753527);
INSERT INTO `xy_auth` VALUES (74, 72, NULL, '添加应用', 'Client', 'addApp', 'client/addApp', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'client/addApp\',\'bsadmin/Client/addApp\');', 1588753572, 1588753572);
INSERT INTO `xy_auth` VALUES (75, 72, NULL, '编辑应用', 'Client', 'editApp', 'client/editApp', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'client/editApp/:id\',\'bsadmin/Client/editApp\');', 1588761200, 1588761200);
INSERT INTO `xy_auth` VALUES (76, 72, NULL, '设置应用状态', 'Client', 'setAppStatus', 'client/setAppStatus', '/:id/:status/[:msg]', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'client/setAppStatus/:id/:status/[:msg]\',\'bsadmin/Client/setAppStatus\');', 1588761617, 1588761617);
INSERT INTO `xy_auth` VALUES (77, 72, NULL, '添加API', 'Client', 'addApi', 'client/addApi', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'client/addApi/:id\',\'bsadmin/Client/addApi\');', 1588833038, 1588833038);
INSERT INTO `xy_auth` VALUES (78, 72, NULL, '编辑API', 'Client', 'editApi', 'client/editApi', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'client/editApi/:id\',\'bsadmin/Client/editApi\');', 1588833160, 1588833160);
INSERT INTO `xy_auth` VALUES (79, 72, NULL, '设置Api状态', 'Client', 'setApiStatus', 'client/setApiStatus', '/:id/:status/[:msg]', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'client/setApiStatus/:id/:status/[:msg]\',\'bsadmin/Client/setApiStatus\');', 1588833237, 1588833237);
INSERT INTO `xy_auth` VALUES (80, 72, NULL, '设置API跨域', 'Client', 'setApiAllow', 'client/setApiAllow', '/:id/:status', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'client/setApiAllow/:id/:status\',\'bsadmin/Client/setApiAllow\');', 1588838328, 1588838328);
INSERT INTO `xy_auth` VALUES (81, 72, '', '异步更新缓存', 'Client', 'updateApiCacheAjax', 'client/updateApiCacheAjax', '/[:id]', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'client/updateApiCacheAjax/[:id]\',\'bsadmin/Client/updateApiCacheAjax\');', 1600328594, 1588841024);
INSERT INTO `xy_auth` VALUES (82, 72, NULL, '更新应用KEY', 'Client', 'updateAppKeyAjax', 'client/updateAppKeyAjax', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'client/updateAppKeyAjax/:id\',\'bsadmin/Client/updateAppKeyAjax\');', 1588841351, 1588841351);
INSERT INTO `xy_auth` VALUES (83, 72, NULL, '设置Api是否需要登录', 'Client', 'setApiIsLogin', 'client/setApiIsLogin', '/:id/:status', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'client/setApiIsLogin/:id/:status\',\'bsadmin/Client/setApiIsLogin\');', 1588844118, 1588843968);
INSERT INTO `xy_auth` VALUES (84, 26, '', '短信限制', 'Setting', 'sms', 'setting/sms', '', 1, 'rule', 0, 1, '', 4, 'Route::rule(\'setting/sms\',\'bsadmin/Setting/sms\');', 1617707027, 1589014259);
INSERT INTO `xy_auth` VALUES (85, 38, NULL, '广告', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-data-board\"></i>', 99, NULL, 1593398193, 1593398193);
INSERT INTO `xy_auth` VALUES (86, 85, NULL, '广告位', 'Ads', 'adsPosition', 'ads/position', '', 1, 'get', 0, 1, '', 99, 'Route::get(\'ads/position\',\'bsadmin/Ads/adsPosition\');', 1593398906, 1593398258);
INSERT INTO `xy_auth` VALUES (87, 38, NULL, '友情链接', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-link\"></i>', 99, '', 1593510080, 1593398551);
INSERT INTO `xy_auth` VALUES (88, 85, NULL, '创建广告位', 'Ads', 'addAdsPosition', 'ads/addPosition', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'ads/addPosition\',\'bsadmin/Ads/addAdsPosition\');', 1593399503, 1593398611);
INSERT INTO `xy_auth` VALUES (89, 85, NULL, '编辑广告位', 'Ads', 'editAdsPosition', 'ads/editPosition', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'ads/editPosition/:id\',\'bsadmin/Ads/editAdsPosition\');', 1593398648, 1593398648);
INSERT INTO `xy_auth` VALUES (90, 85, NULL, '编辑广告位状态', 'Ads', 'setAdsPositionStatus', 'ads/setAdsPositionStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'ads/setAdsPositionStatus/:id/:status\',\'bsadmin/Ads/setAdsPositionStatus\');', 1593417837, 1593398705);
INSERT INTO `xy_auth` VALUES (91, 85, NULL, '删除广告位', 'Ads', 'delAdsPosition', 'ads/delPosition', '/:id', 1, 'get', 0, 0, '', 99, 'Route::get(\'ads/delPosition/:id\',\'bsadmin/Ads/delAdsPosition\');', 1593398929, 1593398743);
INSERT INTO `xy_auth` VALUES (92, 85, NULL, '添加广告图片', 'Ads', 'add', 'ads/add', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'ads/add/:id\',\'bsadmin/Ads/add\');', 1593480748, 1593398780);
INSERT INTO `xy_auth` VALUES (93, 85, NULL, '编辑广告图片', 'Ads', 'edit', 'ads/edit', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'ads/edit/:id\',\'bsadmin/Ads/edit\');', 1593398950, 1593398807);
INSERT INTO `xy_auth` VALUES (94, 85, NULL, '编辑广告图片状态', 'Ads', 'setAdsStatus', 'ads/setAdsStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'ads/setAdsStatus/:id/:status\',\'bsadmin/Ads/setAdsStatus\');', 1593417851, 1593398858);
INSERT INTO `xy_auth` VALUES (95, 85, NULL, '删除广告图片', 'Ads', 'del', 'ads/del', '/:id', 1, 'get', 0, 0, '', 99, 'Route::get(\'ads/del/:id\',\'bsadmin/Ads/del\');', 1593398941, 1593398880);
INSERT INTO `xy_auth` VALUES (96, 87, NULL, '链接列表', 'Links', 'index', 'links', '', 1, 'get', 0, 1, '', 99, 'Route::get(\'links\',\'bsadmin/Links/index\');', 1593510175, 1593510175);
INSERT INTO `xy_auth` VALUES (97, 87, NULL, '创建链接', 'Links', 'add', 'links/add', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'links/add\',\'bsadmin/Links/add\');', 1593510223, 1593510201);
INSERT INTO `xy_auth` VALUES (98, 87, NULL, '编辑链接', 'Links', 'edit', 'links/edit', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'links/edit/:id\',\'bsadmin/Links/edit\');', 1593510250, 1593510250);
INSERT INTO `xy_auth` VALUES (99, 87, NULL, '设置链接状态', 'Links', 'setStatus', 'links/setStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'links/setStatus/:id/:status\',\'bsadmin/Links/setStatus\');', 1593510289, 1593510289);
INSERT INTO `xy_auth` VALUES (100, 87, NULL, '删除链接', 'Links', 'del', 'links/del', '/:id', 1, 'get', 0, 0, '', 99, 'Route::get(\'links/del/:id\',\'bsadmin/Links/del\');', 1593510350, 1593510321);
INSERT INTO `xy_auth` VALUES (103, 332, '', '地区表', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-map-location\"></i>', 99, '', 1617706390, 1594026738);
INSERT INTO `xy_auth` VALUES (104, 103, NULL, '地区列表', 'Area', 'index', 'area', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'area\',\'bsadmin/Area/index\');', 1594026822, 1594026775);
INSERT INTO `xy_auth` VALUES (105, 103, NULL, '添加地区', 'Area', 'add', 'area/add', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'area/add\',\'bsadmin/Area/add\');', 1594026805, 1594026805);
INSERT INTO `xy_auth` VALUES (106, 103, NULL, '编辑地区', 'Area', 'edit', 'area/edit', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'area/edit/:id\',\'bsadmin/Area/edit\');', 1594030775, 1594030775);
INSERT INTO `xy_auth` VALUES (107, 103, NULL, '设置地区状态', 'Area', 'setAreaStatus', 'area/setAreaStatus', '/:id/:status', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'area/setAreaStatus/:id/:status\',\'bsadmin/Area/setAreaStatus\');', 1594030808, 1594030808);
INSERT INTO `xy_auth` VALUES (108, 103, NULL, '缓存地区', 'Area', 'updateFileAjax', 'area/updateFileAjax', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'area/updateFileAjax\',\'bsadmin/Area/updateFileAjax\');', 1594030846, 1594030846);
INSERT INTO `xy_auth` VALUES (109, 103, NULL, '设置地区为热门', 'Area', 'setAreaHot', 'area/setAreaHot', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'area/setAreaHot/:id/:status\',\'bsadmin/Area/setAreaHot\');', 1594114322, 1594114322);
INSERT INTO `xy_auth` VALUES (110, 49, '', '审核企业风采', 'Company', 'setCompanyDemeanor', 'company/demeanor/setStatus', '/:id/:status', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'company/demeanor/setStatus/:id/:status\',\'bsadmin/Company/setCompanyDemeanor\');', 1594881434, 1594881434);
INSERT INTO `xy_auth` VALUES (111, 49, '', '企业认证', 'Company', 'companyAttestation', 'company/attestation', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'company/attestation\',\'bsadmin/Company/companyAttestation\');', 1615445575, 1594883356);
INSERT INTO `xy_auth` VALUES (112, 49, '', '企业认证申请', 'Company', 'setCompanyAttestationStatus', 'company/attestation/setStatus', '/:id/:status/[:msg]', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'company/attestation/setStatus/:id/:status/[:msg]\',\'bsadmin/Company/setCompanyAttestationStatus\');', 1615378395, 1594883440);
INSERT INTO `xy_auth` VALUES (113, 332, '', '导航', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-menu\"></i>', 99, '', 1617706531, 1595399864);
INSERT INTO `xy_auth` VALUES (114, 113, '', '导航栏', 'Menu', 'index', 'menu', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'menu\',\'bsadmin/Menu/index\');', 1595399997, 1595399997);
INSERT INTO `xy_auth` VALUES (115, 113, '', '添加导航栏', 'Menu', 'add', 'menu/add', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'menu/add\',\'bsadmin/Menu/add\');', 1595400049, 1595400049);
INSERT INTO `xy_auth` VALUES (116, 113, '', '编辑导航栏', 'Menu', 'edit', 'menu/edit', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'menu/edit/:id\',\'bsadmin/Menu/edit\');', 1595404207, 1595400073);
INSERT INTO `xy_auth` VALUES (117, 113, '', '设置导航栏状态', 'Menu', 'setStatus', 'menu/setStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'menu/setStatus/:id/:status\',\'bsadmin/Menu/setStatus\');', 1595400163, 1595400109);
INSERT INTO `xy_auth` VALUES (118, 113, '', '删除导航栏', 'Menu', 'del', 'menu/del', '/:id', 1, 'get', 0, 0, '', 99, 'Route::get(\'menu/del/:id\',\'bsadmin/Menu/del\');', 1595400170, 1595400141);
INSERT INTO `xy_auth` VALUES (119, 113, '', '更新导航缓存', 'Menu', 'updateFileAjax', 'menu/updateFileAjax', '', 1, 'get', 0, 0, '', 99, 'Route::get(\'menu/updateFileAjax\',\'bsadmin/Menu/updateFileAjax\');', 1595405613, 1595405613);
INSERT INTO `xy_auth` VALUES (120, 38, '', '套餐', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-goods\"></i>', 99, NULL, 1595832452, 1595832452);
INSERT INTO `xy_auth` VALUES (121, 120, '', '主套餐', 'Vip', 'index', 'vip', '', 1, 'rule', 0, 1, '', 1, 'Route::rule(\'vip\',\'bsadmin/Vip/index\');', 1595843640, 1595832480);
INSERT INTO `xy_auth` VALUES (122, 120, '', '增值套餐', 'Vip', 'valueAdded', 'vip/value-added', '', 1, 'rule', 0, 1, '', 3, 'Route::rule(\'vip/value-added\',\'bsadmin/Vip/valueAdded\');', 1595843644, 1595832552);
INSERT INTO `xy_auth` VALUES (123, 120, '', '添加套餐', 'Vip', 'add', 'vip/add', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'vip/add\',\'bsadmin/Vip/add\');', 1595832577, 1595832577);
INSERT INTO `xy_auth` VALUES (124, 120, '', '编辑套餐', 'Vip', 'edit', 'vip/edit', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'vip/edit/:id\',\'bsadmin/Vip/edit\');', 1595832597, 1595832597);
INSERT INTO `xy_auth` VALUES (125, 120, '', '设置套餐状态', 'Vip', 'setStatus', 'vip/setStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'vip/setStatus/:id/:status\',\'bsadmin/Vip/setStatus\');', 1595832838, 1595832655);
INSERT INTO `xy_auth` VALUES (126, 120, '', '添加增值服务', 'Vip', 'addValueAdded', 'vip/addValueAdded', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'vip/addValueAdded\',\'bsadmin/Vip/addValueAdded\');', 1595832799, 1595832706);
INSERT INTO `xy_auth` VALUES (127, 120, '', '编辑增值服务', 'Vip', 'editValueAdded', 'vip/editValueAdded', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'vip/editValueAdded/:id\',\'bsadmin/Vip/editValueAdded\');', 1595832744, 1595832744);
INSERT INTO `xy_auth` VALUES (128, 120, '', '设置增值服务状态', 'Vip', 'setValueAddedStatus', 'vip/setValueAddedStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'vip/setValueAddedStatus/:id/:status\',\'bsadmin/Vip/setValueAddedStatus\');', 1595832787, 1595832787);
INSERT INTO `xy_auth` VALUES (129, 120, '', '套餐规则', 'Vip', 'vipRule', 'vip/rule', '', 1, 'rule', 0, 1, '', 2, 'Route::rule(\'vip/rule\',\'bsadmin/Vip/vipRule\');', 1595843697, 1595843697);
INSERT INTO `xy_auth` VALUES (130, 120, '', '添加套餐规则', 'Vip', 'addVipRule', 'vip/addVipRule', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'vip/addVipRule\',\'bsadmin/Vip/addVipRule\');', 1595843730, 1595843730);
INSERT INTO `xy_auth` VALUES (131, 120, '', '编辑套餐规则', 'Vip', 'editVipRule', 'vip/editVipRule', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'vip/editVipRule/:id\',\'bsadmin/Vip/editVipRule\');', 1595843771, 1595843771);
INSERT INTO `xy_auth` VALUES (132, 120, '', '设置套餐规则状态', 'Vip', 'setVipRuleStatus', 'vip/setVipRuleStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'vip/setVipRuleStatus/:id/:status\',\'bsadmin/Vip/setVipRuleStatus\');', 1595843851, 1595843851);
INSERT INTO `xy_auth` VALUES (133, 329, '', '支付宝支付', 'Setting', 'alipay', 'setting/alipay', '', 1, 'rule', 0, 1, '', 2, 'Route::rule(\'setting/alipay\',\'bsadmin/Setting/alipay\');', 1617704702, 1596096049);
INSERT INTO `xy_auth` VALUES (134, 329, '', '微信支付', 'Setting', 'wxpay', 'setting/wxpay', '', 1, 'rule', 0, 1, '', 3, 'Route::rule(\'setting/wxpay\',\'bsadmin/Setting/wxpay\');', 1617704711, 1596096074);
INSERT INTO `xy_auth` VALUES (135, 38, '', '订单', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-s-order\"></i>', 99, '', 1597141514, 1596179677);
INSERT INTO `xy_auth` VALUES (136, 135, '', '全部订单', 'Orders', 'index', 'orders', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'orders\',\'bsadmin/Orders/index\');', 1596179728, 1596179728);
INSERT INTO `xy_auth` VALUES (137, 135, '', '查看支付信息', 'Orders', 'getPayInfo', 'orders/getPayInfo', '/:pay_type/:otrade', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'orders/getPayInfo/:pay_type/:otrade\',\'bsadmin/Orders/getPayInfo\');', 1596186079, 1596186079);
INSERT INTO `xy_auth` VALUES (138, 4, '', '第三方', '', '', '', '', 1, '', 1, 0, '<i class=\"el-icon-connection\"></i>', 99, '', 1617705346, 1596271836);
INSERT INTO `xy_auth` VALUES (139, 328, '', 'QQ登录', 'Setting', 'qqlogin', 'setting/qqlogin', '', 1, 'rule', 0, 1, '', 5, 'Route::rule(\'setting/qqlogin\',\'bsadmin/Setting/qqlogin\');', 1617704679, 1596271889);
INSERT INTO `xy_auth` VALUES (140, 328, '', '微信登录', 'Setting', 'wxlogin', 'setting/wxlogin', '', 1, 'rule', 0, 1, '', 6, 'Route::rule(\'setting/wxlogin\',\'bsadmin/Setting/wxlogin\');', 1617704666, 1596271914);
INSERT INTO `xy_auth` VALUES (141, 327, '', '推送队列', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-chat-line-square\"></i>', 99, '', 1617706573, 1596447785);
INSERT INTO `xy_auth` VALUES (142, 141, '', '推送配置', 'Message', 'setMessage', 'message/setConfig', '', 1, 'rule', 0, 1, '', 1, 'Route::rule(\'message/setConfig\',\'bsadmin/Message/setMessage\');', 1615799144, 1596447871);
INSERT INTO `xy_auth` VALUES (143, 38, '', '积分', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-coin\"></i>', 99, NULL, 1596704987, 1596704987);
INSERT INTO `xy_auth` VALUES (144, 143, '', '积分配置', 'Score', 'set', 'score/set', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'score/set\',\'bsadmin/Score/set\');', 1596705022, 1596705022);
INSERT INTO `xy_auth` VALUES (145, 143, '', '积分任务', 'Score', 'task', 'score/task', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'score/task\',\'bsadmin/Score/task\');', 1596705054, 1596705054);
INSERT INTO `xy_auth` VALUES (146, 143, '', '创建积分任务', 'Score', 'add', 'score/add', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'score/add\',\'bsadmin/Score/add\');', 1596705100, 1596705100);
INSERT INTO `xy_auth` VALUES (147, 143, '', '编辑积分任务', 'Score', 'edit', 'score/edit', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'score/edit/:id\',\'bsadmin/Score/edit\');', 1596705138, 1596705138);
INSERT INTO `xy_auth` VALUES (148, 143, '', '设置积分任务状态', 'Score', 'setStatus', 'score/setStatus', '/:id/:status', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'score/setStatus/:id/:status\',\'bsadmin/Score/setStatus\');', 1596705173, 1596705173);
INSERT INTO `xy_auth` VALUES (149, 36, '', '投递管理', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-eleme\"></i>', 99, NULL, 1597391478, 1597391478);
INSERT INTO `xy_auth` VALUES (150, 149, '', '面试邀请记录', 'Jobs', 'inviteAnInterview', 'jobs/inviteAnInterview', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'jobs/inviteAnInterview\',\'bsadmin/Jobs/inviteAnInterview\');', 1618054025, 1597391562);
INSERT INTO `xy_auth` VALUES (151, 149, '', '简历下载记录', 'Resume', 'downloadResumeLog', 'resume/resume-downloaded', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'resume/resume-downloaded\',\'bsadmin/Resume/downloadResumeLog\');', 1597391632, 1597391632);
INSERT INTO `xy_auth` VALUES (152, 241, '', '行为日志', 'User', 'userApiLog', 'user/apiLog', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'user/apiLog\',\'bsadmin/User/userApiLog\');', 1611282664, 1597394112);
INSERT INTO `xy_auth` VALUES (153, 241, '', '登录日志', 'User', 'userLoginLog', 'user/loginLog', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'user/loginLog\',\'bsadmin/User/userLoginLog\');', 1611282671, 1597394141);
INSERT INTO `xy_auth` VALUES (154, 69, '', '作品附件', 'Resume', 'works', 'resume/works', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'resume/works\',\'bsadmin/Resume/works\');', 1597396705, 1597396705);
INSERT INTO `xy_auth` VALUES (155, 69, '', '审核作品附件', 'Resume', 'setResumeWorksStatus', 'resume/works/setStatus', '/:id/:status', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'resume/works/setStatus/:id/:status\',\'bsadmin/Resume/setResumeWorksStatus\');', 1597397150, 1597396784);
INSERT INTO `xy_auth` VALUES (156, 37, '', '设置', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-setting\"></i>', 99, NULL, 1597648672, 1597648672);
INSERT INTO `xy_auth` VALUES (157, 156, '', '个人设置', 'Resume', 'setting', 'resume/setting', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'resume/setting\',\'bsadmin/Resume/setting\');', 1597648748, 1597648748);
INSERT INTO `xy_auth` VALUES (158, 141, '', '站内信', 'Message', 'index', 'message', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'message\',\'bsadmin/Message/index\');', 1597650304, 1597650259);
INSERT INTO `xy_auth` VALUES (159, 141, '', '新建队列', 'Message', 'sendMessage', 'message/send', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'message/send\',\'bsadmin/Message/sendMessage\');', 1597656516, 1597650358);
INSERT INTO `xy_auth` VALUES (160, 141, '', '获取消息内容', 'Message', 'getMessageContent', 'message/getMessageContent', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'message/getMessageContent/:id\',\'bsadmin/Message/getMessageContent\');', 1597651523, 1597651523);
INSERT INTO `xy_auth` VALUES (161, 141, '', '设置消息状态', 'Message', 'setStatus', 'message/setStatus', '/:id/:status', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'message/setStatus/:id/:status\',\'bsadmin/Message/setStatus\');', 1597651853, 1597651853);
INSERT INTO `xy_auth` VALUES (162, 141, '', '设置消息已读', 'Message', 'setIsRead', 'message/setIsRead', '/:id/:is_read', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'message/setIsRead/:id/:is_read\',\'bsadmin/Message/setIsRead\');', 1597651888, 1597651888);
INSERT INTO `xy_auth` VALUES (163, 141, '', '队列列表', 'Message', 'queueList', 'message/queueList', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'message/queueList\',\'bsadmin/Message/queueList\');', 1597656582, 1597656582);
INSERT INTO `xy_auth` VALUES (164, 141, '', '推送列表', 'Message', 'pushList', 'message/pushList', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'message/pushList\',\'bsadmin/Message/pushList\');', 1597656657, 1597656657);
INSERT INTO `xy_auth` VALUES (165, 56, '', '搜索用户', 'User', 'searchUser', 'user/searchUser', '', 1, 'get', 0, 0, '', 99, 'Route::get(\'user/searchUser\',\'bsadmin/User/searchUser\');', 1597738416, 1597738416);
INSERT INTO `xy_auth` VALUES (166, 37, '', '委托投递', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-guide\"></i>', 99, NULL, 1597820773, 1597820773);
INSERT INTO `xy_auth` VALUES (167, 166, '', '委托列表', 'Resume', 'consignment', 'resume/consignment', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'resume/consignment\',\'bsadmin/Resume/consignment\');', 1597820865, 1597820865);
INSERT INTO `xy_auth` VALUES (168, 166, '', '委托匹配', 'Resume', 'matching', 'resume/matching', '/:resume_id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'resume/matching/:resume_id\',\'bsadmin/Resume/matching\');', 1597820916, 1597820916);
INSERT INTO `xy_auth` VALUES (169, 166, '', '投递简历', 'Resume', 'deliveryResume', 'resume/deliveryResume', '/:resume_id/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'resume/deliveryResume/:resume_id/:id\',\'bsadmin/Resume/deliveryResume\');', 1597828562, 1597820989);
INSERT INTO `xy_auth` VALUES (170, 166, '', '取消委托', 'Resume', 'cancelConsignment', 'resume/cancelConsignment', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'resume/cancelConsignment/:id\',\'bsadmin/Resume/cancelConsignment\');', 1597821048, 1597821048);
INSERT INTO `xy_auth` VALUES (171, 36, '', '设置', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-setting\"></i>', 2, NULL, 1597990572, 1597990561);
INSERT INTO `xy_auth` VALUES (172, 38, '', '发票管理', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-c-scale-to-original\"></i>', 99, NULL, 1597990794, 1597990794);
INSERT INTO `xy_auth` VALUES (173, 172, '', '发票列表', 'Invoice', 'index', 'invoice', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'invoice\',\'bsadmin/Invoice/index\');', 1597990844, 1597990844);
INSERT INTO `xy_auth` VALUES (174, 172, '', '发票设置', 'Invoice', 'setting', 'invoice/setting', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'invoice/setting\',\'bsadmin/Invoice/setting\');', 1597990894, 1597990894);
INSERT INTO `xy_auth` VALUES (175, 172, '', '处理发票', 'Invoice', 'setStatus', 'invoice/setStatus', '', 1, 'post', 0, 0, '', 99, 'Route::post(\'invoice/setStatus\',\'bsadmin/Invoice/setStatus\');', 1598003790, 1598003790);
INSERT INTO `xy_auth` VALUES (176, 330, '', 'SMTP邮件', 'Setting', 'email', 'setting/email', '', 1, 'rule', 0, 1, '', 7, 'Route::rule(\'setting/email\',\'bsadmin/Setting/email\');', 1617705361, 1598324125);
INSERT INTO `xy_auth` VALUES (177, 26, '', '地图设置', 'Setting', 'map', 'setting/map', '', 1, 'rule', 0, 1, '', 3, 'Route::rule(\'setting/map\',\'bsadmin/Setting/map\');', 1617707020, 1598324170);
INSERT INTO `xy_auth` VALUES (178, 26, '', '对象存储', 'Setting', 'oss', 'setting/oss', '', 1, 'rule', 0, 1, '', 9, 'Route::rule(\'setting/oss\',\'bsadmin/Setting/oss\');', 1623057613, 1598324260);
INSERT INTO `xy_auth` VALUES (179, 38, '', '反馈', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-chat-line-square\"></i>', 99, NULL, 1598344749, 1598344749);
INSERT INTO `xy_auth` VALUES (180, 179, '', '反馈列表', 'Feedback', 'index', 'feedback', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'feedback\',\'bsadmin/Feedback/index\');', 1598345136, 1598345136);
INSERT INTO `xy_auth` VALUES (181, 179, '', '处理用户反馈', 'Feedback', 'setStatus', 'feedback/setStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'feedback/setStatus/:id/:status\',\'bsadmin/Feedback/setStatus\');', 1598345543, 1598345455);
INSERT INTO `xy_auth` VALUES (182, 179, '', '反馈回复', 'Feedback', 'reply', 'feedback/reply', '', 1, 'post', 0, 0, '', 99, 'Route::post(\'feedback/reply\',\'bsadmin/Feedback/reply\');', 1598345525, 1598345525);
INSERT INTO `xy_auth` VALUES (183, 327, '', '微信公众号', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-house\"></i>', 99, '', 1617703642, 1598499333);
INSERT INTO `xy_auth` VALUES (184, 183, '', '菜单栏', 'Wechat', 'menu', 'wechat/menu', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'wechat/menu\',\'bsadmin/Wechat/menu\');', 1598499417, 1598499417);
INSERT INTO `xy_auth` VALUES (185, 183, '', '菜单栏保存', 'Wechat', 'saveMenu', 'wechat/saveMenu', '', 1, 'post', 0, 0, '', 99, 'Route::post(\'wechat/saveMenu\',\'bsadmin/Wechat/saveMenu\');', 1598499796, 1598499473);
INSERT INTO `xy_auth` VALUES (186, 183, '', '发布菜单栏', 'Wechat', 'releaseMenu', 'wechat/releaseMenu', '', 1, 'get', 0, 0, '', 99, 'Route::get(\'wechat/releaseMenu\',\'bsadmin/Wechat/releaseMenu\');', 1598499784, 1598499513);
INSERT INTO `xy_auth` VALUES (187, 183, '', '关键词回复', 'Wechat', 'keywords', 'wechat/keywords', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'wechat/keywords\',\'bsadmin/Wechat/keywords\');', 1598499611, 1598499611);
INSERT INTO `xy_auth` VALUES (188, 183, '', '设置关键词状态', 'Wechat', 'setKeywordsStatus', 'wechat/setKeywordsStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'wechat/setKeywordsStatus/:id/:status\',\'bsadmin/Wechat/setKeywordsStatus\');', 1598499778, 1598499669);
INSERT INTO `xy_auth` VALUES (189, 183, '', '添加关键词', 'Wechat', 'addKeywords', 'wechat/addKeywords', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'wechat/addKeywords\',\'bsadmin/Wechat/addKeywords\');', 1598499720, 1598499720);
INSERT INTO `xy_auth` VALUES (190, 183, '', '删除关键词', 'Wechat', 'delKeywords', 'wechat/delKeywords', '/:id', 1, 'get', 0, 0, '', 99, 'Route::get(\'wechat/delKeywords/:id\',\'bsadmin/Wechat/delKeywords\');', 1598499750, 1598499750);
INSERT INTO `xy_auth` VALUES (191, 276, '', '公众号模板', 'Wechat', 'pushTpl', 'wechat/pushTpl', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'wechat/pushTpl\',\'bsadmin/Wechat/pushTpl\');', 1615630042, 1598499838);
INSERT INTO `xy_auth` VALUES (192, 276, '', '添加公众号模板', 'Wechat', 'addPushTpl', 'wechat/addPushTpl', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'wechat/addPushTpl\',\'bsadmin/Wechat/addPushTpl\');', 1615630060, 1598499870);
INSERT INTO `xy_auth` VALUES (193, 276, '', '编辑公众号模板', 'Wechat', 'editPushTpl', 'wechat/editPushTpl', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'wechat/editPushTpl/:id\',\'bsadmin/Wechat/editPushTpl\');', 1615630072, 1598499903);
INSERT INTO `xy_auth` VALUES (194, 276, '', '设置公众号模板状态', 'Wechat', 'setPushTplStatus', 'wechat/setPushTplStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'wechat/setPushTplStatus/:id/:status\',\'bsadmin/Wechat/setPushTplStatus\');', 1615630087, 1598499942);
INSERT INTO `xy_auth` VALUES (195, 183, '', '公众号配置', 'Setting', 'wechatMp', 'setting/wechatMp', '', 1, 'rule', 0, 1, '', 9, 'Route::rule(\'setting/wechatMp\',\'bsadmin/Setting/wechatMp\');', 1608545135, 1598514589);
INSERT INTO `xy_auth` VALUES (196, 183, '', '编辑关键词', 'Wechat', 'editKeywords', 'wechat/editKeywords', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'wechat/editKeywords/:id\',\'bsadmin/Wechat/editKeywords\');', 1598600118, 1598600118);
INSERT INTO `xy_auth` VALUES (197, 183, '', '设置默认关键词', 'Wechat', 'setKeywordsDefault', 'wechat/setKeywordsDefault', '/:id/:default', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'wechat/setKeywordsDefault/:id/:default\',\'bsadmin/Wechat/setKeywordsDefault\');', 1598601722, 1598601722);
INSERT INTO `xy_auth` VALUES (198, 65, '', '异步缓存职位分类', 'Jobs', 'setCacheJobsCate', 'jobs/cate/setCacheJobsCate', '', 1, 'get', 0, 0, '', 99, 'Route::get(\'jobs/cate/setCacheJobsCate\',\'bsadmin/Jobs/setCacheJobsCate\');', 1600329966, 1600329966);
INSERT INTO `xy_auth` VALUES (199, 87, '', '异步缓存友情链接', 'Links', 'cacheLink', 'links/cacheLink', '', 1, 'get', 0, 0, '', 99, 'Route::get(\'links/cacheLink\',\'bsadmin/Links/cacheLink\');', 1600330209, 1600330209);
INSERT INTO `xy_auth` VALUES (200, 26, '', '新云Cloud', 'Setting', 'xycms', 'setting/xycms', '', 1, 'rule', 0, 1, '', 1, 'Route::rule(\'setting/xycms\',\'bsadmin/Setting/xycms\');', 1622283363, 1600760217);
INSERT INTO `xy_auth` VALUES (201, 329, '', '苹果支付', 'Setting', 'applepay', 'setting/applepay', '', 1, 'rule', 0, 0, '', 4, 'Route::rule(\'setting/applepay\',\'bsadmin/Setting/applepay\');', 1617704726, 1608545280);
INSERT INTO `xy_auth` VALUES (202, 329, '', '获取苹果支付项目', 'Setting', 'getApplePayProductList', 'getApplePayProductList', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'getApplePayProductList\',\'bsadmin/Setting/getApplePayProductList\');', 1623057703, 1608546174);
INSERT INTO `xy_auth` VALUES (203, 205, '', '微信小程序', 'Setting', 'wechatminiprogram', 'setting/wechatminiprogram', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'setting/wechatminiprogram\',\'bsadmin/Setting/wechatminiprogram\');', 1622282982, 1608882821);
INSERT INTO `xy_auth` VALUES (204, 30, '', '上传配置', 'Setting', 'upconfig', 'setting/upconfig', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'setting/upconfig\',\'bsadmin/Setting/upconfig\');', 1611390981, 1609225692);
INSERT INTO `xy_auth` VALUES (205, 327, '', '客户端', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-s-platform\"></i>', 99, '', 1622282903, 1609396985);
INSERT INTO `xy_auth` VALUES (206, 205, '', 'APP配置', 'Client', 'appConfig', 'setting/appConfig', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'setting/appConfig\',\'bsadmin/Client/appConfig\');', 1609399241, 1609399241);
INSERT INTO `xy_auth` VALUES (207, 205, '', 'APP版本', 'Client', 'appVersion', 'client/app/version', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'client/app/version\',\'bsadmin/Client/appVersion\');', 1609399278, 1609399278);
INSERT INTO `xy_auth` VALUES (208, 205, '', 'H5配置', 'Client', 'h5Config', 'setting/h5Config', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'setting/h5Config\',\'bsadmin/Client/h5Config\');', 1609399336, 1609399336);
INSERT INTO `xy_auth` VALUES (209, 205, '', '头条小程序', 'Setting', 'toutiao', 'setting/toutiao', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'setting/toutiao\',\'bsadmin/Setting/toutiao\');', 1622445470, 1609399401);
INSERT INTO `xy_auth` VALUES (210, 205, '', '更新APP版本', 'Client', 'addAppVersion', 'client/app/add_version', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'client/app/add_version\',\'bsadmin/Client/addAppVersion\');', 1609742445, 1609742375);
INSERT INTO `xy_auth` VALUES (211, 205, '', '删除更新', 'Client', 'delAppVersion', 'client/app/del_version', '/:id', 1, 'get', 0, 0, '', 99, 'Route::get(\'client/app/del_version/:id\',\'bsadmin/Client/delAppVersion\');', 1609742478, 1609742478);
INSERT INTO `xy_auth` VALUES (212, 205, '', '设置APP更新状态', 'Client', 'setAppVersionStatus', 'client/app/setVersionStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'client/app/setVersionStatus/:id/:status\',\'bsadmin/Client/setAppVersionStatus\');', 1609742542, 1609742542);
INSERT INTO `xy_auth` VALUES (213, 205, '', '设置APP强制更新状态', 'Client', 'setAppVersionForce', 'client/app/setVersionForce', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'client/app/setVersionForce/:id/:status\',\'bsadmin/Client/setAppVersionForce\');', 1609750137, 1609750108);
INSERT INTO `xy_auth` VALUES (214, 327, '', '即时通讯', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-chat-line-round\"></i>', 99, '', 1617704067, 1610011328);
INSERT INTO `xy_auth` VALUES (215, 214, '', '聊天设置', 'Setting', 'im_setting', 'setting/im_setting', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'setting/im_setting\',\'bsadmin/Setting/im_setting\');', 1610011425, 1610011425);
INSERT INTO `xy_auth` VALUES (216, 56, '', 'QQ用户', 'User', 'qqUser', 'qqUser', '', 1, 'rule', 0, 1, '', 3, 'Route::rule(\'qqUser\',\'bsadmin/User/qqUser\');', 1610179594, 1610179385);
INSERT INTO `xy_auth` VALUES (225, 35, '', '单页', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-eleme\"></i>', 99, NULL, 1610180837, 1610180837);
INSERT INTO `xy_auth` VALUES (226, 225, '', '协议', 'Article', 'agreement', 'article/agreement', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'article/agreement\',\'bsadmin/Article/agreement\');', 1610180912, 1610180912);
INSERT INTO `xy_auth` VALUES (227, 225, '', '单页', 'Article', 'publicsArticle', 'article/publics', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'article/publics\',\'bsadmin/Article/publicsArticle\');', 1616667887, 1610180962);
INSERT INTO `xy_auth` VALUES (228, 225, '', '公告', 'Article', 'notice', 'article/notice', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'article/notice\',\'bsadmin/Article/notice\');', 1610190911, 1610190911);
INSERT INTO `xy_auth` VALUES (229, 51, '', '职位投诉', 'Jobs', 'job_complaints', 'jobs/complaints', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'jobs/complaints\',\'bsadmin/Jobs/job_complaints\');', 1610952498, 1610952498);
INSERT INTO `xy_auth` VALUES (230, 69, '', '简历投诉', 'Resume', 'resume_complaints', 'resume/complaints', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'resume/complaints\',\'bsadmin/Resume/resume_complaints\');', 1610952541, 1610952541);
INSERT INTO `xy_auth` VALUES (231, 85, '', '设置广告标识符', 'Ads', 'setAdsIcon', 'ads/setAdsIcon', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'ads/setAdsIcon/:id/:status\',\'bsadmin/Ads/setAdsIcon\');', 1610954498, 1610954498);
INSERT INTO `xy_auth` VALUES (232, 56, '', '免登录跳转', 'User', 'exemptLoginRedirect', 'user/exemptLoginRedirect', '/:uid', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'user/exemptLoginRedirect/:uid\',\'bsadmin/User/exemptLoginRedirect\');', 1610957465, 1610957465);
INSERT INTO `xy_auth` VALUES (233, 237, '', '极验', 'Setting', 'geetest', 'setting/geetest', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'setting/geetest\',\'bsadmin/Setting/geetest\');', 1611056796, 1610962737);
INSERT INTO `xy_auth` VALUES (234, 237, '', '验证码', 'Setting', 'captcha', 'setting/captcha', '', 1, 'rule', 0, 1, '', 98, 'Route::rule(\'setting/captcha\',\'bsadmin/Setting/captcha\');', 1611056837, 1610962844);
INSERT INTO `xy_auth` VALUES (235, 237, '', 'VAPTCHA手势验证', 'Setting', 'vaptcha', 'setting/vaptcha', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'setting/vaptcha\',\'bsadmin/Setting/vaptcha\');', 1611056806, 1611049480);
INSERT INTO `xy_auth` VALUES (236, 237, '', 'T-Sec 天御', 'Setting', 'tencentTSec', 'setting/tencent_tsec', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'setting/tencent_tsec\',\'bsadmin/Setting/tencentTSec\');', 1611056816, 1611053561);
INSERT INTO `xy_auth` VALUES (237, 4, '', '验证码', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-thumb\"></i>', 99, '', 1617705085, 1611056771);
INSERT INTO `xy_auth` VALUES (238, 55, '', '设置', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-setting\"></i>', 99, '', 1611223105, 1611223007);
INSERT INTO `xy_auth` VALUES (239, 238, '', '用户设置', 'Setting', 'setting', 'setting/user', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'setting/user\',\'bsadmin/Setting/setting\');', 1617848271, 1611223056);
INSERT INTO `xy_auth` VALUES (240, 238, '', '默认头像', 'Setting', 'default_avatar', 'setting/default_avatar', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'setting/default_avatar\',\'bsadmin/Setting/default_avatar\');', 1611223095, 1611223095);
INSERT INTO `xy_auth` VALUES (241, 55, '', '日志', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-document\"></i>', 99, NULL, 1611282651, 1611282651);
INSERT INTO `xy_auth` VALUES (242, 35, '', '招聘会', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-umbrella\"></i>', 99, NULL, 1611395477, 1611395477);
INSERT INTO `xy_auth` VALUES (243, 242, '', '招聘会列表', 'JobFair', 'index', 'job-fair', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'job-fair\',\'bsadmin/JobFair/index\');', 1611395525, 1611395525);
INSERT INTO `xy_auth` VALUES (244, 242, '', '发布招聘会', 'JobFair', 'add', 'job-fair/add', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'job-fair/add\',\'bsadmin/JobFair/add\');', 1611395559, 1611395559);
INSERT INTO `xy_auth` VALUES (245, 242, '', '编辑招聘会', 'JobFair', 'edit', 'job-fair/edit', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'job-fair/edit/:id\',\'bsadmin/JobFair/edit\');', 1611395618, 1611395618);
INSERT INTO `xy_auth` VALUES (246, 242, '', '设置招聘会状态', 'JobFair', 'setJobFairStatus', 'job-fair/setStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'job-fair/setStatus/:id/:status\',\'bsadmin/JobFair/setJobFairStatus\');', 1611395712, 1611395699);
INSERT INTO `xy_auth` VALUES (247, 242, '', '删除招聘会展位', 'JobFair', 'delJobFairBooth', 'job-fair/delJobFairBooth', '/:id/:is_cate', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'job-fair/delJobFairBooth/:id/:is_cate\',\'bsadmin/JobFair/delJobFairBooth\');', 1611815409, 1611804307);
INSERT INTO `xy_auth` VALUES (248, 242, '', '删除招聘会联系人', 'JobFair', 'delJobFairContacts', 'job-fair/delJobFairContacts', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'job-fair/delJobFairContacts/:id\',\'bsadmin/JobFair/delJobFairContacts\');', 1611804397, 1611804373);
INSERT INTO `xy_auth` VALUES (249, 242, '', '展位管理', 'JobFair', 'boothManage', 'job-fair/boothManage', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'job-fair/boothManage\',\'bsadmin/JobFair/boothManage\');', 1611910333, 1611910333);
INSERT INTO `xy_auth` VALUES (250, 242, '', '获取展位修改记录', 'JobFair', 'getBoothStatusLog', 'job-fair/getBoothStatusLog', '', 1, 'get', 0, 0, '', 99, 'Route::get(\'job-fair/getBoothStatusLog\',\'bsadmin/JobFair/getBoothStatusLog\');', 1611999279, 1611999279);
INSERT INTO `xy_auth` VALUES (251, 242, '', '人才管理', 'JobFair', 'resumeManage', 'job-fair/resumeManage', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'job-fair/resumeManage\',\'bsadmin/JobFair/resumeManage\');', 1612003825, 1612003825);
INSERT INTO `xy_auth` VALUES (252, 242, '', '删除已参加招聘会的人才', 'JobFair', 'delResume', 'job-fair/delResume', '/:id', 1, 'get', 0, 0, '', 99, 'Route::get(\'job-fair/delResume/:id\',\'bsadmin/JobFair/delResume\');', 1612161076, 1612161076);
INSERT INTO `xy_auth` VALUES (253, 4, '', '版本控制', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-folder\"></i>', 99, '', 1617707131, 1613717685);
INSERT INTO `xy_auth` VALUES (254, 253, '', '检查系统更新', 'Packages', 'inspectSystemVersion', 'system/version/inspect', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'system/version/inspect\',\'bsadmin/Packages/inspectSystemVersion\');', 1613717733, 1613717733);
INSERT INTO `xy_auth` VALUES (255, 253, '', '系统更新', 'Packages', 'updateSystemVersion', 'system/version/update', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'system/version/update\',\'bsadmin/Packages/updateSystemVersion\');', 1613717789, 1613717789);
INSERT INTO `xy_auth` VALUES (256, 253, '', '系统版本', 'Packages', 'index', 'packages', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'packages\',\'bsadmin/Packages/index\');', 1613811779, 1613811779);
INSERT INTO `xy_auth` VALUES (257, 253, '', '回滚版本', 'Packages', 'rollBackup', 'packages/rollBackup', '/:filename', 1, 'get', 0, 0, '', 99, 'Route::get(\'packages/rollBackup/:filename\',\'bsadmin/Packages/rollBackup\');', 1613814608, 1613811924);
INSERT INTO `xy_auth` VALUES (258, 253, '', '删除安装文件', 'Packages', 'delInstallPackage', 'packages/delInstallPackage', '/:filename', 1, 'get', 0, 0, '', 99, 'Route::get(\'packages/delInstallPackage/:filename\',\'bsadmin/Packages/delInstallPackage\');', 1613814125, 1613814125);
INSERT INTO `xy_auth` VALUES (259, 253, '', '安装版本', 'Packages', 'installPackageAjax', 'packages/installPackage', '/:filename', 1, 'get', 0, 0, '', 99, 'Route::get(\'packages/installPackage/:filename\',\'bsadmin/Packages/installPackageAjax\');', 1613814801, 1613814801);
INSERT INTO `xy_auth` VALUES (260, 26, '', '主题', 'Theme', 'index', 'theme', '', 1, 'rule', 0, 1, '', 5, 'Route::rule(\'theme\',\'bsadmin/Theme/index\');', 1617707028, 1614321307);
INSERT INTO `xy_auth` VALUES (261, 22, '', '获取图片', 'Publics', 'getImgByPath', 'getImgByPath', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'getImgByPath\',\'bsadmin/Publics/getImgByPath\');', 1614323876, 1614323876);
INSERT INTO `xy_auth` VALUES (262, 26, '', 'SEO设置', 'Setting', 'seo', 'setting/seo', '', 1, 'rule', 0, 1, '', 6, 'Route::rule(\'setting/seo\',\'bsadmin/Setting/seo\');', 1617707030, 1614849956);
INSERT INTO `xy_auth` VALUES (263, 49, '', '设置顾问', 'Company', 'setAdviser', 'company/setAdviser', '/:id/:adviser_id', 1, 'get', 0, 0, '', 99, 'Route::get(\'company/setAdviser/:id/:adviser_id\',\'bsadmin/Company/setAdviser\');', 1614931392, 1614931392);
INSERT INTO `xy_auth` VALUES (264, 69, '', '设置顾问', 'Resume', 'setAdviser', 'resume/setAdviser', '/:id/:adviser_id', 1, 'get', 0, 0, '', 99, 'Route::get(\'resume/setAdviser/:id/:adviser_id\',\'bsadmin/Resume/setAdviser\');', 1614931440, 1614931440);
INSERT INTO `xy_auth` VALUES (265, 69, '', '获取简历信息', 'Resume', 'getResumeInfo', 'getResumeInfo', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'getResumeInfo/:id\',\'bsadmin/Resume/getResumeInfo\');', 1614933888, 1614933888);
INSERT INTO `xy_auth` VALUES (266, 55, '', '实名认证', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-thumb\"></i>', 2, '', 1615277916, 1615016277);
INSERT INTO `xy_auth` VALUES (267, 266, '', '实名申请', 'User', 'RealName', 'user/real_name', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'user/real_name\',\'bsadmin/User/RealName\');', 1615016317, 1615016317);
INSERT INTO `xy_auth` VALUES (268, 266, '', '实名审核', 'User', 'setRealNameStatus', 'user/real_name/setStatus', '/:id/:status/[:msg]', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'user/real_name/setStatus/:id/:status/[:msg]\',\'bsadmin/User/setRealNameStatus\');', 1615016347, 1615016347);
INSERT INTO `xy_auth` VALUES (269, 69, '', '编辑简历', 'Resume', 'editResume', 'resume/editResume', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'resume/editResume/:id\',\'bsadmin/Resume/editResume\');', 1615364227, 1615364227);
INSERT INTO `xy_auth` VALUES (270, 56, '', '编辑用户', 'User', 'editUser', 'user/editUser', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'user/editUser/:id\',\'bsadmin/User/editUser\');', 1615364265, 1615364265);
INSERT INTO `xy_auth` VALUES (271, 65, '', '行业列表', 'Company', 'industry', 'industry', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'industry\',\'bsadmin/Company/industry\');', 1615368645, 1615368645);
INSERT INTO `xy_auth` VALUES (272, 65, '', '添加行业', 'Company', 'addIndustry', 'industry/add', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'industry/add\',\'bsadmin/Company/addIndustry\');', 1615368680, 1615368680);
INSERT INTO `xy_auth` VALUES (273, 65, '', '编辑行业', 'Company', 'editIndustry', 'industry/edit', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'industry/edit/:id\',\'bsadmin/Company/editIndustry\');', 1615368704, 1615368704);
INSERT INTO `xy_auth` VALUES (274, 65, '', '异步缓存行业', 'Company', 'setCacheIndustry', 'industry/setCacheIndustry', '', 1, 'get', 0, 0, '', 99, 'Route::get(\'industry/setCacheIndustry\',\'bsadmin/Company/setCacheIndustry\');', 1615368771, 1615368771);
INSERT INTO `xy_auth` VALUES (275, 65, '', '删除行业', 'Company', 'delIndustry', 'industry/del', '/:id', 1, 'get', 0, 0, '', 99, 'Route::get(\'industry/del/:id\',\'bsadmin/Company/delIndustry\');', 1615369587, 1615369587);
INSERT INTO `xy_auth` VALUES (276, 327, '', '推送模板', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-tickets\"></i>', 99, '', 1617706478, 1615630010);
INSERT INTO `xy_auth` VALUES (277, 276, '', '短信模板', 'Template', 'sms', 'template/sms', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'template/sms\',\'bsadmin/Template/sms\');', 1615630612, 1615630612);
INSERT INTO `xy_auth` VALUES (278, 276, '', '邮件模板', 'Template', 'email', 'template/email', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'template/email\',\'bsadmin/Template/email\');', 1615630642, 1615630642);
INSERT INTO `xy_auth` VALUES (279, 276, '', '创建短信模板', 'Template', 'addSms', 'template/sms/add', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'template/sms/add\',\'bsadmin/Template/addSms\');', 1615631463, 1615631463);
INSERT INTO `xy_auth` VALUES (280, 276, '', '编辑短信模板', 'Template', 'editSms', 'template/sms/edit', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'template/sms/edit/:id\',\'bsadmin/Template/editSms\');', 1615631491, 1615631491);
INSERT INTO `xy_auth` VALUES (281, 276, '', '设置短信模板状态', 'Template', 'setSmsStatus', 'template/sms/setStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'template/sms/setStatus/:id/:status\',\'bsadmin/Template/setSmsStatus\');', 1615631733, 1615631540);
INSERT INTO `xy_auth` VALUES (282, 276, '', '创建邮件模板', 'Template', 'addEmail', 'template/email/add', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'template/email/add\',\'bsadmin/Template/addEmail\');', 1615631575, 1615631575);
INSERT INTO `xy_auth` VALUES (283, 276, '', '编辑邮件模板', 'Template', 'editEmail', 'template/email/edit', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'template/email/edit/:id\',\'bsadmin/Template/editEmail\');', 1615631647, 1615631647);
INSERT INTO `xy_auth` VALUES (284, 276, '', '设置邮件模板状态', 'Template', 'setEmailStatus', 'template/email/setStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'template/email/setStatus/:id/:status\',\'bsadmin/Template/setEmailStatus\');', 1615631728, 1615631690);
INSERT INTO `xy_auth` VALUES (285, 141, '', '个推设置', 'Setting', 'getui', 'setting/getui', '', 1, 'rule', 0, 0, '', 2, 'Route::rule(\'setting/getui\',\'bsadmin/Setting/getui\');', 1615799112, 1615799112);
INSERT INTO `xy_auth` VALUES (286, 2, '', '测试页面', 'Test', 'index', 'test', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'test\',\'bsadmin/Test/index\');', 1615875248, 1615875248);
INSERT INTO `xy_auth` VALUES (287, 276, '', '站内信模板', 'Template', 'website', 'template/website', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'template/website\',\'bsadmin/Template/website\');', 1615972498, 1615972498);
INSERT INTO `xy_auth` VALUES (288, 276, '', '创建站内信模板', 'Template', 'addWebsite', 'template/website/add', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'template/website/add\',\'bsadmin/Template/addWebsite\');', 1615972538, 1615972538);
INSERT INTO `xy_auth` VALUES (289, 276, '', '编辑站内信模板', 'Template', 'editWebsite', 'template/website/edit', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'template/website/edit/:id\',\'bsadmin/Template/editWebsite\');', 1615972575, 1615972575);
INSERT INTO `xy_auth` VALUES (290, 276, '', '设置站内信模板状态', 'Template', 'setWebsiteStatus', 'template/website/setStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'template/website/setStatus/:id/:status\',\'bsadmin/Template/setWebsiteStatus\');', 1615972621, 1615972621);
INSERT INTO `xy_auth` VALUES (291, 276, '', '删除公众号模板', 'Wechat', 'delPushTpl', 'wechat/delPushTpl', '/:id', 1, 'get', 0, 0, '', 99, 'Route::get(\'wechat/delPushTpl/:id\',\'bsadmin/Wechat/delPushTpl\');', 1615977175, 1615977175);
INSERT INTO `xy_auth` VALUES (292, 276, '', '删除短信模板', 'Template', 'delSms', 'template/sms/delSms', '/:id', 1, 'get', 0, 0, '', 99, 'Route::get(\'template/sms/delSms/:id\',\'bsadmin/Template/delSms\');', 1615977222, 1615977222);
INSERT INTO `xy_auth` VALUES (293, 276, '', '删除邮件模板', 'Template', 'delEmail', 'template/email/delEmail', '/:id', 1, 'get', 0, 0, '', 99, 'Route::get(\'template/email/delEmail/:id\',\'bsadmin/Template/delEmail\');', 1615977261, 1615977261);
INSERT INTO `xy_auth` VALUES (294, 276, '', '删除站内信模板', 'Template', 'delWebsite', 'template/website/delWebsite', '/:id', 1, 'get', 0, 0, '', 99, 'Route::get(\'template/website/delWebsite/:id\',\'bsadmin/Template/delWebsite\');', 1615977296, 1615977296);
INSERT INTO `xy_auth` VALUES (295, 51, '', '编辑职位状态', 'Jobs', 'setJobsStatus', 'jobs/setJobsStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'jobs/setJobsStatus/:id/:status\',\'bsadmin/Jobs/setJobsStatus\');', 1616057761, 1616057761);
INSERT INTO `xy_auth` VALUES (296, 56, '', '业务管理', 'Business', 'index', 'business', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'business\',\'bsadmin/Business/index\');', 1616062026, 1616062026);
INSERT INTO `xy_auth` VALUES (297, 55, '', '积分', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-coin\"></i>', 99, NULL, 1616134619, 1616134619);
INSERT INTO `xy_auth` VALUES (298, 297, '', '积分明细', 'User', 'score', 'user/score', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'user/score\',\'bsadmin/User/score\');', 1616134646, 1616134646);
INSERT INTO `xy_auth` VALUES (299, 51, '', '自动刷新', 'Jobs', 'jobsRefresh', 'jobs/getJobsRefresh', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'jobs/getJobsRefresh\',\'bsadmin/Jobs/jobsRefresh\');', 1619313357, 1616138983);
INSERT INTO `xy_auth` VALUES (300, 56, '', '用户推广记录', 'Business', 'getExtension', 'business/getExtension', '', 1, 'get', 0, 0, '', 99, 'Route::get(\'business/getExtension\',\'bsadmin/Business/getExtension\');', 1616140703, 1616140703);
INSERT INTO `xy_auth` VALUES (301, 149, '', '简历投递记录', 'Jobs', 'delivery_resume', 'jobs/delivery_resume', '', 1, 'rule', 0, 1, '', 1, 'Route::rule(\'jobs/delivery_resume\',\'bsadmin/Jobs/delivery_resume\');', 1618054020, 1616142882);
INSERT INTO `xy_auth` VALUES (302, 51, '', '审核职位', 'Jobs', 'setJobsExamine', 'jobs/setJobsExamine', '/:id/:status/[:msg]', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'jobs/setJobsExamine/:id/:status/[:msg]\',\'bsadmin/Jobs/setJobsExamine\');', 1616228672, 1616228672);
INSERT INTO `xy_auth` VALUES (303, 69, '', '审核简历', 'Resume', 'setResumeExamine', 'resume/setResumeExamine', '/:id/:status/[:msg]', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'resume/setResumeExamine/:id/:status/[:msg]\',\'bsadmin/Resume/setResumeExamine\');', 1616230956, 1616230956);
INSERT INTO `xy_auth` VALUES (304, 332, '', '学校专业', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-school\"></i>', 99, '', 1617706399, 1616236099);
INSERT INTO `xy_auth` VALUES (305, 304, '', '学校', 'School', 'index', 'school', '', 1, 'rule', 0, 1, '', 1, 'Route::rule(\'school\',\'bsadmin/School/index\');', 1616237869, 1616236125);
INSERT INTO `xy_auth` VALUES (306, 304, '', '专业', 'School', 'specialities', 'school/specialities', '', 1, 'rule', 0, 1, '', 3, 'Route::rule(\'school/specialities\',\'bsadmin/School/specialities\');', 1616237875, 1616236151);
INSERT INTO `xy_auth` VALUES (307, 304, '', '添加学校', 'School', 'add', 'school/add', '', 1, 'rule', 0, 1, '', 2, 'Route::rule(\'school/add\',\'bsadmin/School/add\');', 1616237871, 1616236194);
INSERT INTO `xy_auth` VALUES (308, 304, '', '编辑学校', 'School', 'edit', 'school/edit', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'school/edit/:id\',\'bsadmin/School/edit\');', 1616236219, 1616236219);
INSERT INTO `xy_auth` VALUES (309, 304, '', '删除学校', 'School', 'del', 'school/del', '/:id', 1, 'get', 0, 0, '', 99, 'Route::get(\'school/del/:id\',\'bsadmin/School/del\');', 1616236247, 1616236247);
INSERT INTO `xy_auth` VALUES (310, 304, '', '添加专业', 'School', 'addSpecialities', 'school/addSpecialities', '', 1, 'rule', 0, 1, '', 4, 'Route::rule(\'school/addSpecialities\',\'bsadmin/School/addSpecialities\');', 1616237880, 1616236275);
INSERT INTO `xy_auth` VALUES (311, 304, '', '编辑专业', 'School', 'editSpecialities', 'school/editSpecialities', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'school/editSpecialities/:id\',\'bsadmin/School/editSpecialities\');', 1616236313, 1616236313);
INSERT INTO `xy_auth` VALUES (312, 304, '', '删除专业', 'School', 'delSpecialities', 'school/delSpecialities', '/:id', 1, 'get', 0, 0, '', 99, 'Route::get(\'school/delSpecialities/:id\',\'bsadmin/School/delSpecialities\');', 1616236347, 1616236347);
INSERT INTO `xy_auth` VALUES (313, 51, '', '设置职位置顶', 'Jobs', 'setJobsTop', 'jobs/setJobsTop', '', 1, 'post', 0, 0, '', 99, 'Route::post(\'jobs/setJobsTop\',\'bsadmin/Jobs/setJobsTop\');', 1616482116, 1616482116);
INSERT INTO `xy_auth` VALUES (314, 51, '', '设置职位推荐', 'Jobs', 'setJobsRecommend', 'jobs/setJobsRecommend', '', 1, 'post', 0, 0, '', 99, 'Route::post(\'jobs/setJobsRecommend\',\'bsadmin/Jobs/setJobsRecommend\');', 1616482140, 1616482140);
INSERT INTO `xy_auth` VALUES (315, 2, '', '获取统计信息', 'Index', 'statistics', 'ajax/statistics', '', 1, 'get', 0, 0, '', 99, 'Route::get(\'ajax/statistics\',\'bsadmin/Index/statistics\');', 1616485284, 1616485284);
INSERT INTO `xy_auth` VALUES (316, 2, '', '统计今日待办', 'Index', 'todoStatistics', 'ajax/todo_statistics', '', 1, 'get', 0, 0, '', 99, 'Route::get(\'ajax/todo_statistics\',\'bsadmin/Index/todoStatistics\');', 1616487083, 1616487063);
INSERT INTO `xy_auth` VALUES (317, 2, '', '图表统计', 'Index', 'chartsStatistics', 'ajax/charts_statistics', '', 1, 'get', 0, 0, '', 99, 'Route::get(\'ajax/charts_statistics\',\'bsadmin/Index/chartsStatistics\');', 1618889043, 1616488059);
INSERT INTO `xy_auth` VALUES (318, 51, '', '设置职位紧急招聘', 'Jobs', 'setJobsUrgent', 'jobs/setJobsUrgent', '', 1, 'post', 0, 0, '', 99, 'Route::post(\'jobs/setJobsUrgent\',\'bsadmin/Jobs/setJobsUrgent\');', 1616740189, 1616740189);
INSERT INTO `xy_auth` VALUES (319, 51, '', '发布职位', 'Jobs', 'addJobs', 'jobs/addJobs', '/:company_id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'jobs/addJobs/:company_id\',\'bsadmin/Jobs/addJobs\');', 1617095584, 1617095242);
INSERT INTO `xy_auth` VALUES (320, 51, '', '编辑职位', 'Jobs', 'editJobs', 'jobs/editJobs', '/:company_id/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'jobs/editJobs/:company_id/:id\',\'bsadmin/Jobs/editJobs\');', 1617095593, 1617095246);
INSERT INTO `xy_auth` VALUES (321, 49, '', '设置企业名企', 'Company', 'setIsFamous', 'company/setIsFamous', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'company/setIsFamous/:id/:status\',\'bsadmin/Company/setIsFamous\');', 1617096793, 1617096793);
INSERT INTO `xy_auth` VALUES (322, 332, '', '状态别名', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-finished\"></i>', 99, '', 1617706406, 1617098517);
INSERT INTO `xy_auth` VALUES (323, 322, '', '状态别名', 'StatusAlias', 'index', 'status_alias', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'status_alias\',\'bsadmin/StatusAlias/index\');', 1617098569, 1617098569);
INSERT INTO `xy_auth` VALUES (324, 322, '', '添加别名', 'StatusAlias', 'add', 'status_alias/add', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'status_alias/add\',\'bsadmin/StatusAlias/add\');', 1617098598, 1617098598);
INSERT INTO `xy_auth` VALUES (325, 322, '', '编辑别名', 'StatusAlias', 'edit', 'status_alias/edit', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'status_alias/edit/:id\',\'bsadmin/StatusAlias/edit\');', 1617098628, 1617098628);
INSERT INTO `xy_auth` VALUES (326, 120, '', '设置默认套餐', 'Vip', 'setDefault', 'vip/setDefault', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'vip/setDefault/:id\',\'bsadmin/Vip/setDefault\');', 1617347987, 1617347682);
INSERT INTO `xy_auth` VALUES (327, 0, '', '工具', '', '', '', '', 1, '', 1, 1, '', 6, NULL, 1617703686, 1617703324);
INSERT INTO `xy_auth` VALUES (328, 327, '', '登陆', '', '', '', '', 1, '', 1, 1, '<u class=\"el-icon-user\"></i>', 99, '', 1617704787, 1617704578);
INSERT INTO `xy_auth` VALUES (329, 327, '', '支付', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-money\"></i>', 99, '', 1617704910, 1617704598);
INSERT INTO `xy_auth` VALUES (330, 327, '', '邮件', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-message\"></i>', 99, NULL, 1617705269, 1617705183);
INSERT INTO `xy_auth` VALUES (331, 4, '', '类别设置', '', '', '', '', 1, '', 1, 0, '<i class=\"el-icon-help\"></i>', 99, NULL, 1617706119, 1617705706);
INSERT INTO `xy_auth` VALUES (332, 0, '', '其他', '', '', '', '', 1, '', 1, 1, '', 7, NULL, 1617706378, 1617706364);
INSERT INTO `xy_auth` VALUES (333, 327, '', '计划任务', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-notebook-2\"></i>', 99, NULL, 1617871546, 1617871546);
INSERT INTO `xy_auth` VALUES (334, 333, '', '任务列表', 'Timing', 'index', 'timing', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'timing\',\'bsadmin/Timing/index\');', 1617871573, 1617871573);
INSERT INTO `xy_auth` VALUES (335, 333, '', '创建计划任务', 'Timing', 'add', 'timing/add', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'timing/add\',\'bsadmin/Timing/add\');', 1617872054, 1617871617);
INSERT INTO `xy_auth` VALUES (336, 333, '', '编辑计划任务', 'Timing', 'edit', 'timing/edit', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'timing/edit/:id\',\'bsadmin/Timing/edit\');', 1617871641, 1617871641);
INSERT INTO `xy_auth` VALUES (337, 333, '', '删除计划任务', 'Timing', 'del', 'timing/del', '/:id', 1, 'get', 0, 0, '', 99, 'Route::get(\'timing/del/:id\',\'bsadmin/Timing/del\');', 1617871668, 1617871668);
INSERT INTO `xy_auth` VALUES (338, 333, '', '设置计划任务状态', 'Timing', 'setStatus', 'timing/setStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'timing/setStatus/:id/:status\',\'bsadmin/Timing/setStatus\');', 1617871714, 1617871714);
INSERT INTO `xy_auth` VALUES (339, 85, '', '设置广告列', 'Ads', 'setAdsCol', 'ads/setAdsCol', '/:id/:col', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'ads/setAdsCol/:id/:col\',\'bsadmin/Ads/setAdsCol\');', 1617965437, 1617965437);
INSERT INTO `xy_auth` VALUES (340, 171, '', '海报设置', 'Posters', 'index', 'vip/poster', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'vip/poster\',\'bsadmin/Posters/index\');', 1622689698, 1618822695);
INSERT INTO `xy_auth` VALUES (341, 171, '', '添加海报', 'Posters', 'add', 'vip/poster/add', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'vip/poster/add\',\'bsadmin/Posters/add\');', 1618822870, 1618822784);
INSERT INTO `xy_auth` VALUES (342, 171, '', '编辑海报', 'Posters', 'edit', 'vip/poster/edit', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'vip/poster/edit/:id\',\'bsadmin/Posters/edit\');', 1618822877, 1618822815);
INSERT INTO `xy_auth` VALUES (343, 171, '', '设置海报状态', 'Posters', 'setStatus', 'vip/poster/setStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'vip/poster/setStatus/:id/:status\',\'bsadmin/Posters/setStatus\');', 1618822895, 1618822856);
INSERT INTO `xy_auth` VALUES (344, 171, '', '删除海报', 'Posters', 'del', 'vip/poster/del', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'vip/poster/del/:id\',\'bsadmin/Posters/del\');', 1618822960, 1618822960);
INSERT INTO `xy_auth` VALUES (345, 7, '', '管理员信息', 'Admin', 'editMy', 'admin/editMy', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'admin/editMy\',\'bsadmin/Admin/editMy\');', 1619169616, 1619169616);
INSERT INTO `xy_auth` VALUES (346, 7, '', '管理员通知', 'Admin', 'adminNotice', 'admin/notice', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'admin/notice\',\'bsadmin/Admin/adminNotice\');', 1619341298, 1619341298);
INSERT INTO `xy_auth` VALUES (347, 183, '', '公众号推文助手', 'Wechat', 'tweets', 'wechat/tweets', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'wechat/tweets\',\'bsadmin/Wechat/tweets\');', 1620617926, 1620286361);
INSERT INTO `xy_auth` VALUES (348, 183, '', '社群推文助手', 'Wechat', 'community_tweets', 'wechat/community_tweets', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'wechat/community_tweets\',\'bsadmin/Wechat/community_tweets\');', 1620614296, 1620614296);
INSERT INTO `xy_auth` VALUES (349, 5, '', '删除权限', 'Auth', 'delAuth', 'auth/del', '/:aid', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'auth/del/:aid\',\'bsadmin/Auth/delAuth\');', 1620635451, 1620635451);
INSERT INTO `xy_auth` VALUES (350, 26, '', '删除配置', 'Setting', 'del', 'setting/del', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'setting/del/:id\',\'bsadmin/Setting/del\');', 1620635499, 1620635499);
INSERT INTO `xy_auth` VALUES (352, 26, '', '编辑配置', 'Setting', 'edit', 'setting/edit', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'setting/edit/:id\',\'bsadmin/Setting/edit\');', 1620638828, 1620638828);
INSERT INTO `xy_auth` VALUES (387, 26, '', 'SEO页面设置', 'Client', 'seo_index', 'client/seo/index', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'client/seo/index\',\'bsadmin/Client/seo_index\');', 1623035554, 1623035554);
INSERT INTO `xy_auth` VALUES (388, 72, '', '编辑SEO页面', 'Client', 'editSeoApi', 'client/editSeo', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'client/editSeo/:id\',\'bsadmin/Client/editSeoApi\');', 1623036424, 1623036424);
INSERT INTO `xy_auth` VALUES (389, 327, '', '分站', '', '', '', '', 1, '', 1, 0, '<i class=\"el-icon-cloudy-and-sunny\"></i>', 99, NULL, 1623208271, 1623208271);
INSERT INTO `xy_auth` VALUES (390, 389, '', '分站列表', 'CityWebsite', 'index', 'city/website', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'city/website\',\'bsadmin/CityWebsite/index\');', 1623307440, 1623208561);
INSERT INTO `xy_auth` VALUES (391, 389, '', '创建分站', 'CityWebsite', 'addCityWebsite', 'city/website/add', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'city/website/add\',\'bsadmin/CityWebsite/addCityWebsite\');', 1623294588, 1623294588);
INSERT INTO `xy_auth` VALUES (392, 389, '', '编辑分站', 'CityWebsite', 'editCityWebsite', 'city/website/edit', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'city/website/edit/:id\',\'bsadmin/CityWebsite/editCityWebsite\');', 1623294628, 1623294628);
INSERT INTO `xy_auth` VALUES (393, 389, '', '设置分站状态', 'CityWebsite', 'setCityWebsiteStatus', 'city/website/setStatus', '/:id/:status', 1, 'get', 0, 0, '', 99, 'Route::get(\'city/website/setStatus/:id/:status\',\'bsadmin/CityWebsite/setCityWebsiteStatus\');', 1623294680, 1623294680);
INSERT INTO `xy_auth` VALUES (394, 389, '', '删除分站', 'CityWebsite', 'delCityWebsite', 'city/website/del', '/:id', 1, 'get', 0, 0, '', 99, 'Route::get(\'city/website/del/:id\',\'bsadmin/CityWebsite/delCityWebsite\');', 1623294710, 1623294710);
INSERT INTO `xy_auth` VALUES (395, 389, '', '分站配置', 'Setting', 'sub_website', 'setting/sub_website', '', 1, 'rule', 0, 1, '', 1, 'Route::rule(\'setting/sub_website\',\'bsadmin/Setting/sub_website\');', 1623307401, 1623307401);
INSERT INTO `xy_auth` VALUES (396, 69, '', '浏览简历', 'Resume', 'getFind', 'resume/find', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'resume/find/:id\',\'bsadmin/Resume/getFind\');', 1623896753, 1623896753);
INSERT INTO `xy_auth` VALUES (397, 38, '', '优惠券', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-eleme\"></i>', 99, NULL, 1623997217, 1623997217);
INSERT INTO `xy_auth` VALUES (398, 397, '', '优惠券列表', 'Coupon', 'index', 'coupon/list', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'coupon/list\',\'bsadmin/Coupon/index\');', 1624241853, 1623997413);
INSERT INTO `xy_auth` VALUES (399, 397, '', '优惠券', 'Coupon', 'coupon', 'coupon', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'coupon\',\'bsadmin/Coupon/coupon\');', 1623997468, 1623997468);
INSERT INTO `xy_auth` VALUES (400, 397, '', '创建优惠券', 'Coupon', 'add', 'coupon/add', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'coupon/add\',\'bsadmin/Coupon/add\');', 1623997489, 1623997489);
INSERT INTO `xy_auth` VALUES (401, 397, '', '编辑优惠券', 'Coupon', 'edit', 'coupon/edit', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'coupon/edit/:id\',\'bsadmin/Coupon/edit\');', 1623997525, 1623997525);
INSERT INTO `xy_auth` VALUES (402, 397, '', '设置优惠券状态', 'Coupon', 'setStatus', 'coupon/setStatus', '/:id/:status', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'coupon/setStatus/:id/:status\',\'bsadmin/Coupon/setStatus\');', 1623997567, 1623997567);
INSERT INTO `xy_auth` VALUES (403, 397, '', '删除优惠券', 'Coupon', 'del', 'coupon/del', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'coupon/del/:id\',\'bsadmin/Coupon/del\');', 1624263186, 1624263186);
INSERT INTO `xy_auth` VALUES (404, 397, '', '增发优惠券', 'Coupon', 'raise', 'coupon/raise', '', 1, 'post', 0, 0, '', 99, 'Route::post(\'coupon/raise\',\'bsadmin/Coupon/raise\');', 1624265417, 1624263753);
INSERT INTO `xy_auth` VALUES (405, 397, '', '赠送优惠券', 'Coupon', 'giveUserCoupon', 'coupon/giveUserCoupon', '', 1, 'post', 0, 0, '', 99, 'Route::post(\'coupon/giveUserCoupon\',\'bsadmin/Coupon/giveUserCoupon\');', 1624334220, 1624334220);
INSERT INTO `xy_auth` VALUES (406, 397, '', '发放优惠券', 'Coupon', 'giveCoupon', 'coupon/give', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'coupon/give\',\'bsadmin/Coupon/giveCoupon\');', 1624520079, 1624520079);
INSERT INTO `xy_auth` VALUES (407, 55, '', '权益', '', '', '', '', 1, '', 1, 1, '<i class=\"el-icon-eleme\"></i>', 99, NULL, 1626081228, 1626081228);
INSERT INTO `xy_auth` VALUES (408, 407, '', '用户权益', 'User', 'getRights', 'user/vip/getRights', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'user/vip/getRights\',\'bsadmin/User/getRights\');', 1626081259, 1626081259);
INSERT INTO `xy_auth` VALUES (409, 407, '', '赠送权益', 'User', 'giveRights', 'user/vip/giveRights', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'user/vip/giveRights\',\'bsadmin/User/giveRights\');', 1626081350, 1626081350);
INSERT INTO `xy_auth` VALUES (410, 407, '', '编辑用户权益', 'User', 'editRights', 'user/vip/editRights', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'user/vip/editRights/:id\',\'bsadmin/User/editRights\');', 1626081381, 1626081381);
INSERT INTO `xy_auth` VALUES (411, 407, '', '设置用户权益状态', 'User', 'invalidRights', 'user/vip/invalidRights', '/:id', 1, 'get', 0, 0, '', 99, 'Route::get(\'user/vip/invalidRights/:id\',\'bsadmin/User/invalidRights\');', 1626231738, 1626081423);
INSERT INTO `xy_auth` VALUES (412, 69, '', '添加简历', 'Resume', 'addResume', 'resume/addResume', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'resume/addResume\',\'bsadmin/Resume/addResume\');', 1626248584, 1626248548);
INSERT INTO `xy_auth` VALUES (413, 69, '', '删除简历经历', 'Resume', 'delExperience', 'resume/delExperience', '/:type/:id/:uid/:resume_id', 1, 'get', 0, 0, '', 99, 'Route::get(\'resume/delExperience/:type/:id/:uid/:resume_id\',\'bsadmin/Resume/delExperience\');', 1626250216, 1626249998);
INSERT INTO `xy_auth` VALUES (414, 141, '', '发送短信', 'Message', 'sendSmsMessage', 'sendSmsMessage', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'sendSmsMessage\',\'bsadmin/Message/sendSmsMessage\');', 1626766202, 1626766119);
INSERT INTO `xy_auth` VALUES (415, 141, '', '发送邮件', 'Message', 'sendEmail', 'sendEmail', '', 1, 'rule', 0, 1, '', 99, 'Route::rule(\'sendEmail\',\'bsadmin/Message/sendEmail\');', 1626766211, 1626766158);
INSERT INTO `xy_auth` VALUES (416, 56, '', '设置用户状态', 'User', 'setStatus', 'user/setStatus', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'user/setStatus/:id\',\'bsadmin/User/setStatus\');', 1626945308, 1626945308);
INSERT INTO `xy_auth` VALUES (417, 56, '', '添加用户', 'User', 'addUser', 'user/addUser', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'user/addUser\',\'bsadmin/User/addUser\');', 1627525760, 1627525760);
INSERT INTO `xy_auth` VALUES (418, 49, '', '刷新企业', 'Company', 'refreshCompany', 'company/refreshCompany', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'company/refreshCompany/:id\',\'bsadmin/Company/refreshCompany\');', 1627528403, 1627528403);
INSERT INTO `xy_auth` VALUES (419, 51, '', '刷新职位', 'Jobs', 'refreshJobs', 'jobs/refreshJobs', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'jobs/refreshJobs/:id\',\'bsadmin/Jobs/refreshJobs\');', 1627528430, 1627528430);
INSERT INTO `xy_auth` VALUES (420, 69, '', '刷新简历', 'Resume', 'refreshResume', 'resume/refreshResume', '/:id', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'resume/refreshResume/:id\',\'bsadmin/Resume/refreshResume\');', 1627528466, 1627528466);
INSERT INTO `xy_auth` VALUES (421, 49, '', '导出企业', 'Company', 'exportCompany', 'company/exportCompany', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'company/exportCompany\',\'bsadmin/Company/exportCompany\');', 1627546695, 1627546695);
INSERT INTO `xy_auth` VALUES (422, 51, '', '导出职位', 'Jobs', 'exportJobs', 'jobs/exportJobs', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'jobs/exportJobs\',\'bsadmin/Jobs/exportJobs\');', 1627551341, 1627551341);
INSERT INTO `xy_auth` VALUES (423, 69, '', '导出简历', 'Resume', 'exportResume', 'resume/exportResume', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'resume/exportResume\',\'bsadmin/Resume/exportResume\');', 1627551366, 1627551366);
INSERT INTO `xy_auth` VALUES (424, 49, '', '导入企业', 'Company', 'importCompany', 'company/importCompany', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'company/importCompany\',\'bsadmin/Company/importCompany\');', 1627613847, 1627613675);
INSERT INTO `xy_auth` VALUES (425, 51, '', '导入职位', 'Jobs', 'importJobs', 'jobs/importJobs', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'jobs/importJobs\',\'bsadmin/Jobs/importJobs\');', 1627613699, 1627613699);
INSERT INTO `xy_auth` VALUES (426, 69, '', '导入简历', 'Resume', 'importResume', 'resume/importResume', '', 1, 'rule', 0, 0, '', 99, 'Route::rule(\'resume/importResume\',\'bsadmin/Resume/importResume\');', 1627613721, 1627613721);
INSERT INTO `xy_auth` VALUES (427, 241, '', '导出访问日志', 'User', 'exportApiLog', 'user/exportApiLog', '', 1, 'get', 0, 0, '', 99, 'Route::get(\'user/exportApiLog\',\'bsadmin/User/exportApiLog\');', 1628130255, 1628130255);
INSERT INTO `xy_auth` VALUES (428, 241, '', '导出登录日志', 'User', 'exportLoginLog', 'user/exportLoginLog', '', 1, 'get', 0, 0, '', 99, 'Route::get(\'user/exportLoginLog\',\'bsadmin/User/exportLoginLog\');', 1628130281, 1628130281);
