
-- ----------------------------
-- Table structure for xy_article_cate
-- ----------------------------
DROP TABLE IF EXISTS `xy_article_cate`;
CREATE TABLE `xy_article_cate`  (
  `id` int(0) UNSIGNED NOT NULL AUTO_INCREMENT,
  `create_time` int(0) NULL DEFAULT NULL COMMENT '分类创建时间',
  `update_time` int(0) NULL DEFAULT NULL,
  `title` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分类名称',
  `alias` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '别名',
  `pid` int(0) NULL DEFAULT 0 COMMENT '父级ID',
  `sort` int(0) NULL DEFAULT 99 COMMENT '排序',
  `pc_show` tinyint(1) NULL DEFAULT 1,
  `app_show` tinyint(1) NULL DEFAULT 1,
  `h5_show` tinyint(1) NULL DEFAULT 1,
  `mp_show` tinyint(1) NULL DEFAULT 1,
  `alipay_show` tinyint(1) NULL DEFAULT 1,
  `baidu_show` tinyint(1) NULL DEFAULT 1,
  `toutiao_show` tinyint(1) NULL DEFAULT 1,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `alias`(`alias`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 36 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '文章分类数据' ROW_FORMAT = Compact;

-- ----------------------------
-- Records of xy_article_cate
-- ----------------------------
INSERT INTO `xy_article_cate` VALUES (1, 1587367761, 1587367896, '单页', '', 0, 99, 1, 1, 1, 1, 1, 1, 1);
INSERT INTO `xy_article_cate` VALUES (2, 1587368842, 1610184070, '协议', 'agreement', 1, 99, 1, 1, 1, 1, 1, 1, 1);
INSERT INTO `xy_article_cate` VALUES (3, 1587368964, 1616667867, '单页', 'publics', 1, 99, 1, 1, 1, 1, 1, 1, 1);
INSERT INTO `xy_article_cate` VALUES (4, 1587971912, 1610185703, '发现', 'find', 0, 1, 1, 1, 1, 1, 1, 1, 1);
INSERT INTO `xy_article_cate` VALUES (11, 1588153092, 1610185822, '热门资讯', 'hot', 4, 2, 1, 1, 1, 1, 1, 1, 1);
INSERT INTO `xy_article_cate` VALUES (12, 1588153102, 1615288316, '事业单位招聘', 'government_institutions', 4, 1, 1, 1, 1, 1, 1, 1, 1);
INSERT INTO `xy_article_cate` VALUES (13, 1588153109, 1610185828, '面试宝典', 'interview_guide', 4, 3, 1, 1, 1, 1, 1, 1, 1);
INSERT INTO `xy_article_cate` VALUES (14, 1595822104, 1610185833, '职场新闻', 'workplace', 4, 4, 1, 1, 1, 1, 1, 1, 1);
INSERT INTO `xy_article_cate` VALUES (22, 1606460734, 1616666001, '公告', 'article_notice', 1, 99, 1, 1, 1, 1, 1, 1, 1);
INSERT INTO `xy_article_cate` VALUES (29, 1609234714, 1610185876, '新手指南', 'novice', 1, 99, 1, 1, 1, 1, 1, 1, 1);
INSERT INTO `xy_article_cate` VALUES (35, 1616667935, 1616667935, '帮助中心', 'common-problem', 1, 99, 1, 1, 1, 1, 1, 1, 1);
