
-- ----------------------------
-- Table structure for xy_article
-- ----------------------------
DROP TABLE IF EXISTS `xy_article`;
CREATE TABLE `xy_article`  (
  `id` int(0) UNSIGNED NOT NULL AUTO_INCREMENT,
  `create_time` int(0) NULL DEFAULT NULL,
  `update_time` int(0) NULL DEFAULT NULL,
  `start_time` int(0) NULL DEFAULT NULL,
  `end_time` int(0) NULL DEFAULT NULL,
  `alias` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文章别名',
  `title` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文章标题',
  `status` tinyint(1) NULL DEFAULT 1,
  `status_alias` tinyint(1) NULL DEFAULT 0,
  `view` int(0) NULL DEFAULT 0,
  `thumb` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '文章封面',
  `cla` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `source` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `cid` int(0) NULL DEFAULT NULL,
  `qrcode` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `province` int(10) NULL DEFAULT NULL,
  `city` int(10) NULL DEFAULT NULL,
  `area` int(10) NULL DEFAULT NULL,
  `industry` int(10) NULL DEFAULT NULL,
  `force_alert` tinyint(1) NULL DEFAULT 0,
  `sort` tinyint(2) NULL DEFAULT 99,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `cid`(`cid`) USING BTREE,
  INDEX `alias`(`alias`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 7 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '文章' ROW_FORMAT = Compact;

-- ----------------------------
-- Records of xy_article
-- ----------------------------
INSERT INTO `xy_article` VALUES (1, 1618203917, 1618203917, NULL, NULL, 'about', '关于我们', 1, 0, 39, '', '', '', '', 2,NULL,NULL,NULL,NULL,NULL,0,99);
INSERT INTO `xy_article` VALUES (2, 1618204053, 1618204089, NULL, NULL, 'user_agreement', '用户协议', 1, 0, 8, '', '', '', '', 2,NULL,NULL,NULL,NULL,NULL,0,99);
INSERT INTO `xy_article` VALUES (3, 1618204082, 1618204102, NULL, NULL, 'privacy', '隐私保护', 1, 0, 11, '', '', '', '', 2,NULL,NULL,NULL,NULL,NULL,0,99);
INSERT INTO `xy_article` VALUES (4, 1618204245, 1618204312, NULL, NULL, 'user_agreement_web', '网页版服务协议', 1, 0, 8, '', '', '', '', 2,NULL,NULL,NULL,NULL,NULL,0,99);
INSERT INTO `xy_article` VALUES (5, 1618204426, 1618204426, NULL, NULL, 'contact_us', '联系我们', 1, 0, 5, '', '', '', '', 35,NULL,NULL,NULL,NULL,NULL,0,99);
INSERT INTO `xy_article` VALUES (6, 1618204560, 1618204560, NULL, NULL, 'price_publicity', '收费标准', 1, 0, 3, '', '', '', '', 35,NULL,NULL,NULL,NULL,NULL,0,99);


