-- ----------------------------
-- Table structure for xy_area
-- ----------------------------
DROP TABLE IF EXISTS `xy_area`;
CREATE TABLE `xy_area`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增主键',
  `pid` int(12) UNSIGNED NULL DEFAULT NULL COMMENT '上级地区id',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '地区名',
  `letter` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地区首字母',
  `hot` tinyint(1) NULL DEFAULT 0 COMMENT '热门城市',
  `alias` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '别名',
  `level` tinyint(1) UNSIGNED NULL DEFAULT NULL COMMENT '地区级别 1 省 2 市 3 区',
  `status` tinyint(1) UNSIGNED NULL DEFAULT 1 COMMENT '状态',
  `sort` tinyint(2) NULL DEFAULT 99,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `pid`(`pid`) USING BTREE,
  INDEX `ps`(`pid`, `status`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5045 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '地区表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of xy_area
-- ----------------------------
INSERT INTO `xy_area` VALUES (1, 0, '北京', 'b', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (2, 0, '天津', 't', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (3, 0, '河北省', 'h', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (4, 0, '山西省', 's', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (5, 0, '内蒙古自治区', 'n', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (6, 0, '辽宁省', 'l', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (7, 0, '吉林省', 'j', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (8, 0, '黑龙江省', 'h', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (9, 0, '上海', 's', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (10, 0, '江苏省', 'j', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (11, 0, '浙江省', 'z', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (12, 0, '安徽省', 'a', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (13, 0, '福建省', 'f', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (14, 0, '江西省', 'j', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (15, 0, '山东省', 's', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (16, 0, '河南省', 'h', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (17, 0, '湖北省', 'h', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (18, 0, '湖南省', 'h', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (19, 0, '广东省', 'g', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (20, 0, '广西壮族自治区', 'g', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (21, 0, '海南省', 'h', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (22, 0, '重庆', 'z', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (23, 0, '四川省', 's', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (24, 0, '贵州省', 'g', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (25, 0, '云南省', 'y', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (26, 0, '西藏自治区', 'x', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (27, 0, '陕西省', 's', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (28, 0, '甘肃省', 'g', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (29, 0, '青海省', 'q', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (30, 0, '宁夏回族自治区', 'n', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (31, 0, '新疆维吾尔自治区', 'x', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (32, 1, '北京市', 'b', 1, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (33, 2, '天津市', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (34, 3, '石家庄市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (35, 3, '唐山市', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (36, 3, '秦皇岛市', 'q', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (37, 3, '邯郸市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (38, 3, '邢台市', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (39, 3, '保定市', 'b', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (40, 3, '张家口市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (41, 3, '承德市', 'c', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (42, 3, '沧州市', 'c', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (43, 3, '廊坊市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (44, 3, '衡水市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (45, 4, '太原市', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (46, 4, '大同市', 'd', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (47, 4, '阳泉市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (48, 4, '长治市', 'c', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (49, 4, '晋城市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (50, 4, '朔州市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (51, 4, '晋中市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (52, 4, '运城市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (53, 4, '忻州市', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (54, 4, '临汾市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (55, 4, '吕梁市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (56, 5, '呼和浩特市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (57, 5, '包头市', 'b', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (58, 5, '乌海市', 'w', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (59, 5, '赤峰市', 'c', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (60, 5, '通辽市', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (61, 5, '鄂尔多斯市', 'e', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (62, 5, '呼伦贝尔市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (63, 5, '巴彦淖尔市', 'b', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (64, 5, '乌兰察布市', 'w', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (65, 5, '兴安盟', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (66, 5, '锡林郭勒盟', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (67, 5, '阿拉善盟', 'a', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (68, 6, '沈阳市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (69, 6, '大连市', 'd', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (70, 6, '鞍山市', 'a', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (71, 6, '抚顺市', 'f', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (72, 6, '本溪市', 'b', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (73, 6, '丹东市', 'd', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (74, 6, '锦州市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (75, 6, '营口市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (76, 6, '阜新市', 'f', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (77, 6, '辽阳市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (78, 6, '盘锦市', 'p', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (79, 6, '铁岭市', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (80, 6, '朝阳市', 'c', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (81, 6, '葫芦岛市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (82, 7, '长春市', 'c', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (83, 7, '吉林市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (84, 7, '四平市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (85, 7, '辽源市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (86, 7, '通化市', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (87, 7, '白山市', 'b', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (88, 7, '松原市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (89, 7, '白城市', 'b', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (90, 7, '延边朝鲜族自治州', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (91, 8, '哈尔滨市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (92, 8, '齐齐哈尔市', 'q', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (93, 8, '鸡西市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (94, 8, '鹤岗市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (95, 8, '双鸭山市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (96, 8, '大庆市', 'd', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (97, 8, '伊春市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (98, 8, '佳木斯市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (99, 8, '七台河市', 'q', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (100, 8, '牡丹江市', 'm', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (101, 8, '黑河市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (102, 8, '绥化市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (103, 8, '大兴安岭地区', 'd', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (104, 9, '上海市', 's', 1, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (105, 10, '南京市', 'n', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (106, 10, '无锡市', 'w', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (107, 10, '徐州市', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (108, 10, '常州市', 'c', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (109, 10, '苏州市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (110, 10, '南通市', 'n', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (111, 10, '连云港市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (112, 10, '淮安市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (113, 10, '盐城市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (114, 10, '扬州市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (115, 10, '镇江市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (116, 10, '泰州市', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (117, 10, '宿迁市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (118, 11, '杭州市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (119, 11, '宁波市', 'n', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (120, 11, '温州市', 'w', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (121, 11, '嘉兴市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (122, 11, '湖州市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (123, 11, '绍兴市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (124, 11, '金华市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (125, 11, '衢州市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (126, 11, '舟山市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (127, 11, '台州市', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (128, 11, '丽水市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (129, 12, '合肥市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (130, 12, '芜湖市', 'w', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (131, 12, '蚌埠市', 'b', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (132, 12, '淮南市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (133, 12, '马鞍山市', 'm', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (134, 12, '淮北市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (135, 12, '铜陵市', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (136, 12, '安庆市', 'a', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (137, 12, '黄山市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (138, 12, '滁州市', 'c', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (139, 12, '阜阳市', 'f', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (140, 12, '宿州市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (141, 12, '六安市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (142, 12, '亳州市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (143, 12, '池州市', 'c', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (144, 12, '宣城市', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (145, 13, '福州市', 'f', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (146, 13, '厦门市', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (147, 13, '莆田市', 'p', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (148, 13, '三明市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (149, 13, '泉州市', 'q', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (150, 13, '漳州市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (151, 13, '南平市', 'n', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (152, 13, '龙岩市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (153, 13, '宁德市', 'n', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (154, 14, '南昌市', 'n', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (155, 14, '景德镇市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (156, 14, '萍乡市', 'p', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (157, 14, '九江市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (158, 14, '新余市', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (159, 14, '鹰潭市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (160, 14, '赣州市', 'g', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (161, 14, '吉安市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (162, 14, '宜春市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (163, 14, '抚州市', 'f', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (164, 14, '上饶市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (165, 15, '济南市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (166, 15, '青岛市', 'q', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (167, 15, '淄博市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (168, 15, '枣庄市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (169, 15, '东营市', 'd', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (170, 15, '烟台市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (171, 15, '潍坊市', 'w', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (172, 15, '济宁市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (173, 15, '泰安市', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (174, 15, '威海市', 'w', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (175, 15, '日照市', 'r', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (176, 15, '莱芜市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (177, 15, '临沂市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (178, 15, '德州市', 'd', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (179, 15, '聊城市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (180, 15, '滨州市', 'b', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (181, 15, '菏泽市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (182, 16, '郑州市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (183, 16, '开封市', 'k', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (184, 16, '洛阳市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (185, 16, '平顶山市', 'p', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (186, 16, '安阳市', 'a', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (187, 16, '鹤壁市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (188, 16, '新乡市', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (189, 16, '焦作市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (190, 16, '濮阳市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (191, 16, '许昌市', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (192, 16, '漯河市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (193, 16, '三门峡市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (194, 16, '南阳市', 'n', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (195, 16, '商丘市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (196, 16, '信阳市', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (197, 16, '周口市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (198, 16, '驻马店市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (199, 16, '济源市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (200, 17, '武汉市', 'w', 1, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (201, 17, '黄石市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (202, 17, '十堰市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (203, 17, '宜昌市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (204, 17, '襄阳市', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (205, 17, '鄂州市', 'e', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (206, 17, '荆门市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (207, 17, '孝感市', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (208, 17, '荆州市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (209, 17, '黄冈市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (210, 17, '咸宁市', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (211, 17, '随州市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (212, 17, '恩施土家族苗族自治州', 'e', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (213, 17, '湖北省直辖县级行政区划', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (214, 18, '长沙市', 'c', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (215, 18, '株洲市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (216, 18, '湘潭市', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (217, 18, '衡阳市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (218, 18, '邵阳市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (219, 18, '岳阳市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (220, 18, '常德市', 'c', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (221, 18, '张家界市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (222, 18, '益阳市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (223, 18, '郴州市', 'c', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (224, 18, '永州市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (225, 18, '怀化市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (226, 18, '娄底市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (227, 18, '湘西土家族苗族自治州', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (228, 19, '广州市', 'g', 1, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (229, 19, '韶关市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (230, 19, '深圳市', 's', 1, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (231, 19, '珠海市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (232, 19, '汕头市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (233, 19, '佛山市', 'f', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (234, 19, '江门市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (235, 19, '湛江市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (236, 19, '茂名市', 'm', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (237, 19, '肇庆市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (238, 19, '惠州市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (239, 19, '梅州市', 'm', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (240, 19, '汕尾市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (241, 19, '河源市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (242, 19, '阳江市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (243, 19, '清远市', 'q', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (244, 19, '东莞市', 'd', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (245, 19, '中山市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (246, 19, '潮州市', 'c', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (247, 19, '揭阳市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (248, 19, '云浮市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (249, 20, '南宁市', 'n', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (250, 20, '柳州市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (251, 20, '桂林市', 'g', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (252, 20, '梧州市', 'w', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (253, 20, '北海市', 'b', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (254, 20, '防城港市', 'f', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (255, 20, '钦州市', 'q', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (256, 20, '贵港市', 'g', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (257, 20, '玉林市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (258, 20, '百色市', 'b', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (259, 20, '贺州市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (260, 20, '河池市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (261, 20, '来宾市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (262, 20, '崇左市', 'c', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (263, 21, '海口市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (264, 21, '三亚市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (265, 21, '三沙市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (266, 21, '儋州市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (267, 21, '海南省直辖县级行政区划', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (268, 22, '重庆市', 'z', 1, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (269, 22, '重庆县级', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (270, 23, '成都市', 'c', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (271, 23, '自贡市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (272, 23, '攀枝花市', 'p', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (273, 23, '泸州市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (274, 23, '德阳市', 'd', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (275, 23, '绵阳市', 'm', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (276, 23, '广元市', 'g', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (277, 23, '遂宁市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (278, 23, '内江市', 'n', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (279, 23, '乐山市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (280, 23, '南充市', 'n', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (281, 23, '眉山市', 'm', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (282, 23, '宜宾市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (283, 23, '广安市', 'g', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (284, 23, '达州市', 'd', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (285, 23, '雅安市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (286, 23, '巴中市', 'b', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (287, 23, '资阳市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (288, 23, '阿坝藏族羌族自治州', 'a', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (289, 23, '甘孜藏族自治州', 'g', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (290, 23, '凉山彝族自治州', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (291, 24, '贵阳市', 'g', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (292, 24, '六盘水市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (293, 24, '遵义市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (294, 24, '安顺市', 'a', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (295, 24, '毕节市', 'b', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (296, 24, '铜仁市', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (297, 24, '黔西南布依族苗族自治州', 'q', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (298, 24, '黔东南苗族侗族自治州', 'q', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (299, 24, '黔南布依族苗族自治州', 'q', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (300, 25, '昆明市', 'k', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (301, 25, '曲靖市', 'q', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (302, 25, '玉溪市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (303, 25, '保山市', 'b', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (304, 25, '昭通市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (305, 25, '丽江市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (306, 25, '普洱市', 'p', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (307, 25, '临沧市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (308, 25, '楚雄彝族自治州', 'c', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (309, 25, '红河哈尼族彝族自治州', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (310, 25, '文山壮族苗族自治州', 'w', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (311, 25, '西双版纳傣族自治州', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (312, 25, '大理白族自治州', 'd', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (313, 25, '德宏傣族景颇族自治州', 'd', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (314, 25, '怒江傈僳族自治州', 'n', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (315, 25, '迪庆藏族自治州', 'd', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (316, 26, '拉萨市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (317, 26, '日喀则市', 'r', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (318, 26, '昌都市', 'c', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (319, 26, '林芝市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (320, 26, '山南市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (321, 26, '那曲市', 'n', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (322, 26, '阿里地区', 'a', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (323, 27, '西安市', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (324, 27, '铜川市', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (325, 27, '宝鸡市', 'b', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (326, 27, '咸阳市', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (327, 27, '渭南市', 'w', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (328, 27, '延安市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (329, 27, '汉中市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (330, 27, '榆林市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (331, 27, '安康市', 'a', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (332, 27, '商洛市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (333, 28, '兰州市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (334, 28, '嘉峪关市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (335, 28, '金昌市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (336, 28, '白银市', 'b', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (337, 28, '天水市', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (338, 28, '武威市', 'w', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (339, 28, '张掖市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (340, 28, '平凉市', 'p', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (341, 28, '酒泉市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (342, 28, '庆阳市', 'q', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (343, 28, '定西市', 'd', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (344, 28, '陇南市', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (345, 28, '临夏回族自治州', 'l', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (346, 28, '甘南藏族自治州', 'g', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (347, 29, '西宁市', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (348, 29, '海东市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (349, 29, '海北藏族自治州', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (350, 29, '黄南藏族自治州', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (351, 29, '海南藏族自治州', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (352, 29, '果洛藏族自治州', 'g', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (353, 29, '玉树藏族自治州', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (354, 29, '海西蒙古族藏族自治州', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (355, 30, '银川市', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (356, 30, '石嘴山市', 's', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (357, 30, '吴忠市', 'w', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (358, 30, '固原市', 'g', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (359, 30, '中卫市', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (360, 31, '乌鲁木齐市', 'w', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (361, 31, '克拉玛依市', 'k', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (362, 31, '吐鲁番市', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (363, 31, '哈密市', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (364, 31, '昌吉回族自治州', 'c', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (365, 31, '博尔塔拉蒙古自治州', 'b', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (366, 31, '巴音郭楞蒙古自治州', 'b', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (367, 31, '阿克苏地区', 'a', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (368, 31, '克孜勒苏柯尔克孜自治州', 'k', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (369, 31, '喀什地区', 'k', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (370, 31, '和田地区', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (371, 31, '伊犁哈萨克自治州', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (372, 31, '塔城地区', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (373, 31, '阿勒泰地区', 'a', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (374, 31, '新疆直辖县级行政区划', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (543, 32, '东城区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (544, 32, '西城区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (545, 32, '朝阳区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (546, 32, '丰台区', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (547, 32, '石景山区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (548, 32, '海淀区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (549, 32, '门头沟区', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (550, 32, '房山区', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (551, 32, '通州区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (552, 32, '顺义区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (553, 32, '昌平区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (554, 32, '大兴区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (555, 32, '怀柔区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (556, 32, '平谷区', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (557, 32, '密云区', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (558, 32, '延庆区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (559, 33, '和平区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (560, 33, '河东区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (561, 33, '河西区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (562, 33, '南开区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (563, 33, '河北区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (564, 33, '红桥区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (565, 33, '东丽区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (566, 33, '西青区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (567, 33, '津南区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (568, 33, '北辰区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (569, 33, '武清区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (570, 33, '宝坻区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (571, 33, '滨海新区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (572, 33, '宁河区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (573, 33, '静海区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (574, 33, '蓟州区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (575, 34, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (576, 34, '长安区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (577, 34, '桥西区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (578, 34, '新华区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (579, 34, '井陉矿区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (580, 34, '裕华区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (581, 34, '藁城区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (582, 34, '鹿泉区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (583, 34, '栾城区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (584, 34, '井陉县', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (585, 34, '正定县', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (586, 34, '行唐县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (587, 34, '灵寿县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (588, 34, '高邑县', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (589, 34, '深泽县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (590, 34, '赞皇县', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (591, 34, '无极县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (592, 34, '平山县', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (593, 34, '元氏县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (594, 34, '赵县', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (595, 34, '石家庄高新技术产业开发区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (596, 34, '石家庄循环化工园区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (597, 34, '辛集市', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (598, 34, '晋州市', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (599, 34, '新乐市', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (600, 35, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (601, 35, '路南区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (602, 35, '路北区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (603, 35, '古冶区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (604, 35, '开平区', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (605, 35, '丰南区', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (606, 35, '丰润区', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (607, 35, '曹妃甸区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (608, 35, '滦南县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (609, 35, '乐亭县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (610, 35, '迁西县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (611, 35, '玉田县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (612, 35, '唐山市芦台经济技术开发区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (613, 35, '唐山市汉沽管理区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (614, 35, '唐山高新技术产业开发区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (615, 35, '河北唐山海港经济开发区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (616, 35, '遵化市', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (617, 35, '迁安市', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (618, 35, '滦州市', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (619, 36, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (620, 36, '海港区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (621, 36, '山海关区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (622, 36, '北戴河区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (623, 36, '抚宁区', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (624, 36, '青龙满族自治县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (625, 36, '昌黎县', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (626, 36, '卢龙县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (627, 36, '秦皇岛市经济技术开发区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (628, 36, '北戴河新区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (629, 37, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (630, 37, '邯山区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (631, 37, '丛台区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (632, 37, '复兴区', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (633, 37, '峰峰矿区', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (634, 37, '肥乡区', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (635, 37, '永年区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (636, 37, '临漳县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (637, 37, '成安县', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (638, 37, '大名县', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (639, 37, '涉县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (640, 37, '磁县', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (641, 37, '邱县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (642, 37, '鸡泽县', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (643, 37, '广平县', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (644, 37, '馆陶县', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (645, 37, '魏县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (646, 37, '曲周县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (647, 37, '邯郸经济技术开发区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (648, 37, '邯郸冀南新区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (649, 37, '武安市', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (650, 38, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (651, 38, '桥东区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (652, 38, '桥西区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (653, 38, '邢台县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (654, 38, '临城县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (655, 38, '内丘县', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (656, 38, '柏乡县', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (657, 38, '隆尧县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (658, 38, '任县', 'r', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (659, 38, '南和县', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (660, 38, '宁晋县', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (661, 38, '巨鹿县', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (662, 38, '新河县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (663, 38, '广宗县', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (664, 38, '平乡县', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (665, 38, '威县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (666, 38, '清河县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (667, 38, '临西县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (668, 38, '河北邢台经济开发区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (669, 38, '南宫市', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (670, 38, '沙河市', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (671, 39, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (672, 39, '竞秀区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (673, 39, '莲池区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (674, 39, '满城区', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (675, 39, '清苑区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (676, 39, '徐水区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (677, 39, '涞水县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (678, 39, '阜平县', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (679, 39, '定兴县', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (680, 39, '唐县', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (681, 39, '高阳县', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (682, 39, '容城县', 'r', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (683, 39, '涞源县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (684, 39, '望都县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (685, 39, '安新县', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (686, 39, '易县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (687, 39, '曲阳县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (688, 39, '蠡县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (689, 39, '顺平县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (690, 39, '博野县', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (691, 39, '雄县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (692, 39, '保定高新技术产业开发区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (693, 39, '保定白沟新城', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (694, 39, '涿州市', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (695, 39, '定州市', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (696, 39, '安国市', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (697, 39, '高碑店市', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (698, 40, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (699, 40, '桥东区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (700, 40, '桥西区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (701, 40, '宣化区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (702, 40, '下花园区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (703, 40, '万全区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (704, 40, '崇礼区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (705, 40, '张北县', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (706, 40, '康保县', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (707, 40, '沽源县', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (708, 40, '尚义县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (709, 40, '蔚县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (710, 40, '阳原县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (711, 40, '怀安县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (712, 40, '怀来县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (713, 40, '涿鹿县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (714, 40, '赤城县', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (715, 40, '张家口市高新技术产业开发区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (716, 40, '张家口市察北管理区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (717, 40, '张家口市塞北管理区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (718, 41, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (719, 41, '双桥区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (720, 41, '双滦区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (721, 41, '鹰手营子矿区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (722, 41, '承德县', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (723, 41, '兴隆县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (724, 41, '滦平县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (725, 41, '隆化县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (726, 41, '丰宁满族自治县', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (727, 41, '宽城满族自治县', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (728, 41, '围场满族蒙古族自治县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (729, 41, '承德高新技术产业开发区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (730, 41, '平泉市', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (731, 42, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (732, 42, '新华区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (733, 42, '运河区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (734, 42, '沧县', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (735, 42, '青县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (736, 42, '东光县', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (737, 42, '海兴县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (738, 42, '盐山县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (739, 42, '肃宁县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (740, 42, '南皮县', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (741, 42, '吴桥县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (742, 42, '献县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (743, 42, '孟村回族自治县', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (744, 42, '河北沧州经济开发区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (745, 42, '沧州高新技术产业开发区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (746, 42, '沧州渤海新区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (747, 42, '泊头市', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (748, 42, '任丘市', 'r', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (749, 42, '黄骅市', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (750, 42, '河间市', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (751, 43, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (752, 43, '安次区', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (753, 43, '广阳区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (754, 43, '固安县', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (755, 43, '永清县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (756, 43, '香河县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (757, 43, '大城县', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (758, 43, '文安县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (759, 43, '大厂回族自治县', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (760, 43, '廊坊经济技术开发区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (761, 43, '霸州市', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (762, 43, '三河市', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (763, 44, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (764, 44, '桃城区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (765, 44, '冀州区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (766, 44, '枣强县', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (767, 44, '武邑县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (768, 44, '武强县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (769, 44, '饶阳县', 'r', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (770, 44, '安平县', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (771, 44, '故城县', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (772, 44, '景县', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (773, 44, '阜城县', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (774, 44, '河北衡水高新技术产业开发区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (775, 44, '衡水滨湖新区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (776, 44, '深州市', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (777, 45, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (778, 45, '小店区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (779, 45, '迎泽区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (780, 45, '杏花岭区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (781, 45, '尖草坪区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (782, 45, '万柏林区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (783, 45, '晋源区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (784, 45, '清徐县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (785, 45, '阳曲县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (786, 45, '娄烦县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (787, 45, '山西转型综合改革示范区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (788, 45, '古交市', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (789, 46, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (790, 46, '新荣区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (791, 46, '平城区', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (792, 46, '云冈区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (793, 46, '云州区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (794, 46, '阳高县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (795, 46, '天镇县', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (796, 46, '广灵县', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (797, 46, '灵丘县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (798, 46, '浑源县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (799, 46, '左云县', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (800, 46, '山西大同经济开发区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (801, 47, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (802, 47, '城区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (803, 47, '矿区', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (804, 47, '郊区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (805, 47, '平定县', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (806, 47, '盂县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (807, 48, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (808, 48, '潞州区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (809, 48, '上党区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (810, 48, '屯留区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (811, 48, '潞城区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (812, 48, '襄垣县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (813, 48, '平顺县', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (814, 48, '黎城县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (815, 48, '壶关县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (816, 48, '长子县', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (817, 48, '武乡县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (818, 48, '沁县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (819, 48, '沁源县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (820, 48, '山西长治高新技术产业园区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (821, 49, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (822, 49, '城区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (823, 49, '沁水县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (824, 49, '阳城县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (825, 49, '陵川县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (826, 49, '泽州县', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (827, 49, '高平市', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (828, 50, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (829, 50, '朔城区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (830, 50, '平鲁区', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (831, 50, '山阴县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (832, 50, '应县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (833, 50, '右玉县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (834, 50, '山西朔州经济开发区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (835, 50, '怀仁市', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (836, 51, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (837, 51, '榆次区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (838, 51, '榆社县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (839, 51, '左权县', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (840, 51, '和顺县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (841, 51, '昔阳县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (842, 51, '寿阳县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (843, 51, '太谷县', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (844, 51, '祁县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (845, 51, '平遥县', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (846, 51, '灵石县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (847, 51, '介休市', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (848, 52, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (849, 52, '盐湖区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (850, 52, '临猗县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (851, 52, '万荣县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (852, 52, '闻喜县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (853, 52, '稷山县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (854, 52, '新绛县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (855, 52, '绛县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (856, 52, '垣曲县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (857, 52, '夏县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (858, 52, '平陆县', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (859, 52, '芮城县', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (860, 52, '永济市', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (861, 52, '河津市', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (862, 53, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (863, 53, '忻府区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (864, 53, '定襄县', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (865, 53, '五台县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (866, 53, '代县', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (867, 53, '繁峙县', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (868, 53, '宁武县', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (869, 53, '静乐县', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (870, 53, '神池县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (871, 53, '五寨县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (872, 53, '岢岚县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (873, 53, '河曲县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (874, 53, '保德县', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (875, 53, '偏关县', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (876, 53, '五台山风景名胜区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (877, 53, '原平市', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (878, 54, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (879, 54, '尧都区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (880, 54, '曲沃县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (881, 54, '翼城县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (882, 54, '襄汾县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (883, 54, '洪洞县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (884, 54, '古县', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (885, 54, '安泽县', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (886, 54, '浮山县', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (887, 54, '吉县', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (888, 54, '乡宁县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (889, 54, '大宁县', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (890, 54, '隰县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (891, 54, '永和县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (892, 54, '蒲县', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (893, 54, '汾西县', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (894, 54, '侯马市', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (895, 54, '霍州市', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (896, 55, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (897, 55, '离石区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (898, 55, '文水县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (899, 55, '交城县', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (900, 55, '兴县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (901, 55, '临县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (902, 55, '柳林县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (903, 55, '石楼县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (904, 55, '岚县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (905, 55, '方山县', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (906, 55, '中阳县', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (907, 55, '交口县', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (908, 55, '孝义市', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (909, 55, '汾阳市', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (910, 56, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (911, 56, '新城区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (912, 56, '回民区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (913, 56, '玉泉区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (914, 56, '赛罕区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (915, 56, '土默特左旗', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (916, 56, '托克托县', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (917, 56, '和林格尔县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (918, 56, '清水河县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (919, 56, '武川县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (920, 56, '呼和浩特金海工业园区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (921, 56, '呼和浩特经济技术开发区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (922, 57, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (923, 57, '东河区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (924, 57, '昆都仑区', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (925, 57, '青山区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (926, 57, '石拐区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (927, 57, '白云鄂博矿区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (928, 57, '九原区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (929, 57, '土默特右旗', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (930, 57, '固阳县', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (931, 57, '达尔罕茂明安联合旗', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (932, 57, '包头稀土高新技术产业开发区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (933, 58, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (934, 58, '海勃湾区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (935, 58, '海南区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (936, 58, '乌达区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (937, 59, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (938, 59, '红山区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (939, 59, '元宝山区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (940, 59, '松山区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (941, 59, '阿鲁科尔沁旗', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (942, 59, '巴林左旗', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (943, 59, '巴林右旗', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (944, 59, '林西县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (945, 59, '克什克腾旗', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (946, 59, '翁牛特旗', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (947, 59, '喀喇沁旗', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (948, 59, '宁城县', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (949, 59, '敖汉旗', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (950, 60, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (951, 60, '科尔沁区', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (952, 60, '科尔沁左翼中旗', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (953, 60, '科尔沁左翼后旗', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (954, 60, '开鲁县', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (955, 60, '库伦旗', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (956, 60, '奈曼旗', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (957, 60, '扎鲁特旗', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (958, 60, '通辽经济技术开发区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (959, 60, '霍林郭勒市', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (960, 61, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (961, 61, '东胜区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (962, 61, '康巴什区', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (963, 61, '达拉特旗', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (964, 61, '准格尔旗', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (965, 61, '鄂托克前旗', 'e', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (966, 61, '鄂托克旗', 'e', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (967, 61, '杭锦旗', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (968, 61, '乌审旗', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (969, 61, '伊金霍洛旗', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (970, 62, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (971, 62, '海拉尔区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (972, 62, '扎赉诺尔区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (973, 62, '阿荣旗', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (974, 62, '莫力达瓦达斡尔族自治旗', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (975, 62, '鄂伦春自治旗', 'e', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (976, 62, '鄂温克族自治旗', 'e', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (977, 62, '陈巴尔虎旗', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (978, 62, '新巴尔虎左旗', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (979, 62, '新巴尔虎右旗', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (980, 62, '满洲里市', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (981, 62, '牙克石市', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (982, 62, '扎兰屯市', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (983, 62, '额尔古纳市', 'e', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (984, 62, '根河市', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (985, 63, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (986, 63, '临河区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (987, 63, '五原县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (988, 63, '磴口县', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (989, 63, '乌拉特前旗', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (990, 63, '乌拉特中旗', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (991, 63, '乌拉特后旗', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (992, 63, '杭锦后旗', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (993, 64, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (994, 64, '集宁区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (995, 64, '卓资县', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (996, 64, '化德县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (997, 64, '商都县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (998, 64, '兴和县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (999, 64, '凉城县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1000, 64, '察哈尔右翼前旗', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1001, 64, '察哈尔右翼中旗', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1002, 64, '察哈尔右翼后旗', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1003, 64, '四子王旗', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1004, 64, '丰镇市', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1005, 65, '乌兰浩特市', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1006, 65, '阿尔山市', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1007, 65, '科尔沁右翼前旗', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1008, 65, '科尔沁右翼中旗', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1009, 65, '扎赉特旗', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1010, 65, '突泉县', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1011, 66, '二连浩特市', 'e', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1012, 66, '锡林浩特市', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1013, 66, '阿巴嘎旗', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1014, 66, '苏尼特左旗', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1015, 66, '苏尼特右旗', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1016, 66, '东乌珠穆沁旗', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1017, 66, '西乌珠穆沁旗', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1018, 66, '太仆寺旗', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1019, 66, '镶黄旗', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1020, 66, '正镶白旗', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1021, 66, '正蓝旗', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1022, 66, '多伦县', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1023, 66, '乌拉盖管委会', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1024, 67, '阿拉善左旗', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1025, 67, '阿拉善右旗', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1026, 67, '额济纳旗', 'e', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1027, 67, '内蒙古阿拉善经济开发区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1028, 68, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1029, 68, '和平区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1030, 68, '沈河区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1031, 68, '大东区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1032, 68, '皇姑区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1033, 68, '铁西区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1034, 68, '苏家屯区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1035, 68, '浑南区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1036, 68, '沈北新区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1037, 68, '于洪区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1038, 68, '辽中区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1039, 68, '康平县', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1040, 68, '法库县', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1041, 68, '新民市', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1042, 69, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1043, 69, '中山区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1044, 69, '西岗区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1045, 69, '沙河口区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1046, 69, '甘井子区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1047, 69, '旅顺口区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1048, 69, '金州区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1049, 69, '普兰店区', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1050, 69, '长海县', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1051, 69, '瓦房店市', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1052, 69, '庄河市', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1053, 70, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1054, 70, '铁东区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1055, 70, '铁西区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1056, 70, '立山区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1057, 70, '千山区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1058, 70, '台安县', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1059, 70, '岫岩满族自治县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1060, 70, '海城市', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1061, 71, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1062, 71, '新抚区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1063, 71, '东洲区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1064, 71, '望花区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1065, 71, '顺城区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1066, 71, '抚顺县', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1067, 71, '新宾满族自治县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1068, 71, '清原满族自治县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1069, 72, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1070, 72, '平山区', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1071, 72, '溪湖区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1072, 72, '明山区', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1073, 72, '南芬区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1074, 72, '本溪满族自治县', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1075, 72, '桓仁满族自治县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1076, 73, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1077, 73, '元宝区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1078, 73, '振兴区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1079, 73, '振安区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1080, 73, '宽甸满族自治县', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1081, 73, '东港市', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1082, 73, '凤城市', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1083, 74, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1084, 74, '古塔区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1085, 74, '凌河区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1086, 74, '太和区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1087, 74, '黑山县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1088, 74, '义县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1089, 74, '凌海市', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1090, 74, '北镇市', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1091, 75, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1092, 75, '站前区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1093, 75, '西市区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1094, 75, '鲅鱼圈区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1095, 75, '老边区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1096, 75, '盖州市', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1097, 75, '大石桥市', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1098, 76, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1099, 76, '海州区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1100, 76, '新邱区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1101, 76, '太平区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1102, 76, '清河门区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1103, 76, '细河区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1104, 76, '阜新蒙古族自治县', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1105, 76, '彰武县', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1106, 77, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1107, 77, '白塔区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1108, 77, '文圣区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1109, 77, '宏伟区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1110, 77, '弓长岭区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1111, 77, '太子河区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1112, 77, '辽阳县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1113, 77, '灯塔市', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1114, 78, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1115, 78, '双台子区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1116, 78, '兴隆台区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1117, 78, '大洼区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1118, 78, '盘山县', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1119, 79, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1120, 79, '银州区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1121, 79, '清河区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1122, 79, '铁岭县', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1123, 79, '西丰县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1124, 79, '昌图县', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1125, 79, '调兵山市', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1126, 79, '开原市', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1127, 80, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1128, 80, '双塔区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1129, 80, '龙城区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1130, 80, '朝阳县', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1131, 80, '建平县', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1132, 80, '喀喇沁左翼蒙古族自治县', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1133, 80, '北票市', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1134, 80, '凌源市', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1135, 81, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1136, 81, '连山区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1137, 81, '龙港区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1138, 81, '南票区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1139, 81, '绥中县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1140, 81, '建昌县', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1141, 81, '兴城市', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1142, 82, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1143, 82, '南关区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1144, 82, '宽城区', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1145, 82, '朝阳区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1146, 82, '二道区', 'e', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1147, 82, '绿园区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1148, 82, '双阳区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1149, 82, '九台区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1150, 82, '农安县', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1151, 82, '长春经济技术开发区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1152, 82, '长春净月高新技术产业开发区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1153, 82, '长春高新技术产业开发区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1154, 82, '长春汽车经济技术开发区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1155, 82, '榆树市', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1156, 82, '德惠市', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1157, 83, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1158, 83, '昌邑区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1159, 83, '龙潭区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1160, 83, '船营区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1161, 83, '丰满区', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1162, 83, '永吉县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1163, 83, '吉林经济开发区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1164, 83, '吉林高新技术产业开发区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1165, 83, '吉林中国新加坡食品区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1166, 83, '蛟河市', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1167, 83, '桦甸市', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1168, 83, '舒兰市', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1169, 83, '磐石市', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1170, 84, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1171, 84, '铁西区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1172, 84, '铁东区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1173, 84, '梨树县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1174, 84, '伊通满族自治县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1175, 84, '公主岭市', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1176, 84, '双辽市', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1177, 85, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1178, 85, '龙山区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1179, 85, '西安区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1180, 85, '东丰县', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1181, 85, '东辽县', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1182, 86, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1183, 86, '东昌区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1184, 86, '二道江区', 'e', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1185, 86, '通化县', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1186, 86, '辉南县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1187, 86, '柳河县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1188, 86, '梅河口市', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1189, 86, '集安市', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1190, 87, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1191, 87, '浑江区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1192, 87, '江源区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1193, 87, '抚松县', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1194, 87, '靖宇县', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1195, 87, '长白朝鲜族自治县', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1196, 87, '临江市', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1197, 88, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1198, 88, '宁江区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1199, 88, '前郭尔罗斯蒙古族自治县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1200, 88, '长岭县', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1201, 88, '乾安县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1202, 88, '吉林松原经济开发区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1203, 88, '扶余市', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1204, 89, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1205, 89, '洮北区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1206, 89, '镇赉县', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1207, 89, '通榆县', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1208, 89, '吉林白城经济开发区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1209, 89, '洮南市', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1210, 89, '大安市', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1211, 90, '延吉市', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1212, 90, '图们市', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1213, 90, '敦化市', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1214, 90, '珲春市', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1215, 90, '龙井市', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1216, 90, '和龙市', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1217, 90, '汪清县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1218, 90, '安图县', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1219, 91, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1220, 91, '道里区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1221, 91, '南岗区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1222, 91, '道外区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1223, 91, '平房区', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1224, 91, '松北区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1225, 91, '香坊区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1226, 91, '呼兰区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1227, 91, '阿城区', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1228, 91, '双城区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1229, 91, '依兰县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1230, 91, '方正县', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1231, 91, '宾县', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1232, 91, '巴彦县', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1233, 91, '木兰县', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1234, 91, '通河县', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1235, 91, '延寿县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1236, 91, '尚志市', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1237, 91, '五常市', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1238, 92, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1239, 92, '龙沙区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1240, 92, '建华区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1241, 92, '铁锋区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1242, 92, '昂昂溪区', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1243, 92, '富拉尔基区', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1244, 92, '碾子山区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1245, 92, '梅里斯达斡尔族区', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1246, 92, '龙江县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1247, 92, '依安县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1248, 92, '泰来县', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1249, 92, '甘南县', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1250, 92, '富裕县', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1251, 92, '克山县', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1252, 92, '克东县', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1253, 92, '拜泉县', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1254, 92, '讷河市', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1255, 93, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1256, 93, '鸡冠区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1257, 93, '恒山区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1258, 93, '滴道区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1259, 93, '梨树区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1260, 93, '城子河区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1261, 93, '麻山区', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1262, 93, '鸡东县', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1263, 93, '虎林市', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1264, 93, '密山市', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1265, 94, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1266, 94, '向阳区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1267, 94, '工农区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1268, 94, '南山区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1269, 94, '兴安区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1270, 94, '东山区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1271, 94, '兴山区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1272, 94, '萝北县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1273, 94, '绥滨县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1274, 95, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1275, 95, '尖山区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1276, 95, '岭东区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1277, 95, '四方台区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1278, 95, '宝山区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1279, 95, '集贤县', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1280, 95, '友谊县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1281, 95, '宝清县', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1282, 95, '饶河县', 'r', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1283, 96, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1284, 96, '萨尔图区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1285, 96, '龙凤区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1286, 96, '让胡路区', 'r', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1287, 96, '红岗区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1288, 96, '大同区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1289, 96, '肇州县', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1290, 96, '肇源县', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1291, 96, '林甸县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1292, 96, '杜尔伯特蒙古族自治县', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1293, 96, '大庆高新技术产业开发区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1294, 97, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1295, 97, '伊春区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1296, 97, '南岔区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1297, 97, '友好区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1298, 97, '西林区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1299, 97, '翠峦区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1300, 97, '新青区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1301, 97, '美溪区', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1302, 97, '金山屯区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1303, 97, '五营区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1304, 97, '乌马河区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1305, 97, '汤旺河区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1306, 97, '带岭区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1307, 97, '乌伊岭区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1308, 97, '红星区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1309, 97, '上甘岭区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1310, 97, '嘉荫县', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1311, 97, '铁力市', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1312, 98, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1313, 98, '向阳区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1314, 98, '前进区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1315, 98, '东风区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1316, 98, '郊区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1317, 98, '桦南县', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1318, 98, '桦川县', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1319, 98, '汤原县', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1320, 98, '同江市', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1321, 98, '富锦市', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1322, 98, '抚远市', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1323, 99, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1324, 99, '新兴区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1325, 99, '桃山区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1326, 99, '茄子河区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1327, 99, '勃利县', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1328, 100, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1329, 100, '东安区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1330, 100, '阳明区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1331, 100, '爱民区', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1332, 100, '西安区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1333, 100, '林口县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1334, 100, '牡丹江经济技术开发区', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1335, 100, '绥芬河市', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1336, 100, '海林市', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1337, 100, '宁安市', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1338, 100, '穆棱市', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1339, 100, '东宁市', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1340, 101, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1341, 101, '爱辉区', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1342, 101, '嫩江县', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1343, 101, '逊克县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1344, 101, '孙吴县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1345, 101, '北安市', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1346, 101, '五大连池市', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1347, 102, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1348, 102, '北林区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1349, 102, '望奎县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1350, 102, '兰西县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1351, 102, '青冈县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1352, 102, '庆安县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1353, 102, '明水县', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1354, 102, '绥棱县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1355, 102, '安达市', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1356, 102, '肇东市', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1357, 102, '海伦市', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1358, 103, '漠河市', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1359, 103, '呼玛县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1360, 103, '塔河县', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1361, 103, '加格达奇区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1362, 103, '松岭区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1363, 103, '新林区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1364, 103, '呼中区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1365, 104, '黄浦区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1366, 104, '徐汇区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1367, 104, '长宁区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1368, 104, '静安区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1369, 104, '普陀区', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1370, 104, '虹口区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1371, 104, '杨浦区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1372, 104, '闵行区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1373, 104, '宝山区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1374, 104, '嘉定区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1375, 104, '浦东新区', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1376, 104, '金山区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1377, 104, '松江区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1378, 104, '青浦区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1379, 104, '奉贤区', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1380, 104, '崇明区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1381, 105, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1382, 105, '玄武区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1383, 105, '秦淮区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1384, 105, '建邺区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1385, 105, '鼓楼区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1386, 105, '浦口区', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1387, 105, '栖霞区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1388, 105, '雨花台区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1389, 105, '江宁区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1390, 105, '六合区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1391, 105, '溧水区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1392, 105, '高淳区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1393, 106, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1394, 106, '锡山区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1395, 106, '惠山区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1396, 106, '滨湖区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1397, 106, '梁溪区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1398, 106, '新吴区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1399, 106, '江阴市', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1400, 106, '宜兴市', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1401, 107, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1402, 107, '鼓楼区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1403, 107, '云龙区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1404, 107, '贾汪区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1405, 107, '泉山区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1406, 107, '铜山区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1407, 107, '丰县', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1408, 107, '沛县', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1409, 107, '睢宁县', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1410, 107, '徐州经济技术开发区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1411, 107, '新沂市', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1412, 107, '邳州市', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1413, 108, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1414, 108, '天宁区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1415, 108, '钟楼区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1416, 108, '新北区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1417, 108, '武进区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1418, 108, '金坛区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1419, 108, '溧阳市', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1420, 109, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1421, 109, '虎丘区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1422, 109, '吴中区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1423, 109, '相城区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1424, 109, '姑苏区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1425, 109, '吴江区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1426, 109, '苏州工业园区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1427, 109, '常熟市', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1428, 109, '张家港市', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1429, 109, '昆山市', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1430, 109, '太仓市', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1431, 110, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1432, 110, '崇川区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1433, 110, '港闸区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1434, 110, '通州区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1435, 110, '如东县', 'r', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1436, 110, '南通经济技术开发区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1437, 110, '启东市', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1438, 110, '如皋市', 'r', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1439, 110, '海门市', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1440, 110, '海安市', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1441, 111, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1442, 111, '连云区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1443, 111, '海州区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1444, 111, '赣榆区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1445, 111, '东海县', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1446, 111, '灌云县', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1447, 111, '灌南县', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1448, 111, '连云港经济技术开发区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1449, 111, '连云港高新技术产业开发区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1450, 112, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1451, 112, '淮安区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1452, 112, '淮阴区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1453, 112, '清江浦区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1454, 112, '洪泽区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1455, 112, '涟水县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1456, 112, '盱眙县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1457, 112, '金湖县', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1458, 112, '淮安经济技术开发区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1459, 113, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1460, 113, '亭湖区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1461, 113, '盐都区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1462, 113, '大丰区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1463, 113, '响水县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1464, 113, '滨海县', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1465, 113, '阜宁县', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1466, 113, '射阳县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1467, 113, '建湖县', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1468, 113, '盐城经济技术开发区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1469, 113, '东台市', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1470, 114, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1471, 114, '广陵区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1472, 114, '邗江区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1473, 114, '江都区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1474, 114, '宝应县', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1475, 114, '扬州经济技术开发区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1476, 114, '仪征市', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1477, 114, '高邮市', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1478, 115, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1479, 115, '京口区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1480, 115, '润州区', 'r', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1481, 115, '丹徒区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1482, 115, '镇江新区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1483, 115, '丹阳市', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1484, 115, '扬中市', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1485, 115, '句容市', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1486, 116, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1487, 116, '海陵区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1488, 116, '高港区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1489, 116, '姜堰区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1490, 116, '泰州医药高新技术产业开发区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1491, 116, '兴化市', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1492, 116, '靖江市', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1493, 116, '泰兴市', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1494, 117, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1495, 117, '宿城区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1496, 117, '宿豫区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1497, 117, '沭阳县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1498, 117, '泗阳县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1499, 117, '泗洪县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1500, 117, '宿迁经济技术开发区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1501, 118, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1502, 118, '上城区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1503, 118, '下城区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1504, 118, '江干区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1505, 118, '拱墅区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1506, 118, '西湖区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1507, 118, '滨江区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1508, 118, '萧山区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1509, 118, '余杭区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1510, 118, '富阳区', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1511, 118, '临安区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1512, 118, '桐庐县', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1513, 118, '淳安县', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1514, 118, '建德市', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1515, 119, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1516, 119, '海曙区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1517, 119, '江北区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1518, 119, '北仑区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1519, 119, '镇海区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1520, 119, '鄞州区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1521, 119, '奉化区', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1522, 119, '象山县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1523, 119, '宁海县', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1524, 119, '余姚市', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1525, 119, '慈溪市', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1526, 120, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1527, 120, '鹿城区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1528, 120, '龙湾区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1529, 120, '瓯海区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1530, 120, '洞头区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1531, 120, '永嘉县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1532, 120, '平阳县', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1533, 120, '苍南县', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1534, 120, '文成县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1535, 120, '泰顺县', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1536, 120, '温州经济技术开发区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1537, 120, '瑞安市', 'r', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1538, 120, '乐清市', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1539, 121, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1540, 121, '南湖区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1541, 121, '秀洲区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1542, 121, '嘉善县', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1543, 121, '海盐县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1544, 121, '海宁市', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1545, 121, '平湖市', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1546, 121, '桐乡市', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1547, 122, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1548, 122, '吴兴区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1549, 122, '南浔区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1550, 122, '德清县', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1551, 122, '长兴县', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1552, 122, '安吉县', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1553, 123, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1554, 123, '越城区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1555, 123, '柯桥区', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1556, 123, '上虞区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1557, 123, '新昌县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1558, 123, '诸暨市', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1559, 123, '嵊州市', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1560, 124, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1561, 124, '婺城区', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1562, 124, '金东区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1563, 124, '武义县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1564, 124, '浦江县', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1565, 124, '磐安县', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1566, 124, '兰溪市', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1567, 124, '义乌市', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1568, 124, '东阳市', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1569, 124, '永康市', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1570, 125, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1571, 125, '柯城区', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1572, 125, '衢江区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1573, 125, '常山县', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1574, 125, '开化县', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1575, 125, '龙游县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1576, 125, '江山市', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1577, 126, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1578, 126, '定海区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1579, 126, '普陀区', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1580, 126, '岱山县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1581, 126, '嵊泗县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1582, 127, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1583, 127, '椒江区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1584, 127, '黄岩区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1585, 127, '路桥区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1586, 127, '三门县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1587, 127, '天台县', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1588, 127, '仙居县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1589, 127, '温岭市', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1590, 127, '临海市', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1591, 127, '玉环市', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1592, 128, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1593, 128, '莲都区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1594, 128, '青田县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1595, 128, '缙云县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1596, 128, '遂昌县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1597, 128, '松阳县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1598, 128, '云和县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1599, 128, '庆元县', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1600, 128, '景宁畲族自治县', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1601, 128, '龙泉市', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1602, 129, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1603, 129, '瑶海区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1604, 129, '庐阳区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1605, 129, '蜀山区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1606, 129, '包河区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1607, 129, '长丰县', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1608, 129, '肥东县', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1609, 129, '肥西县', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1610, 129, '庐江县', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1611, 129, '合肥高新技术产业开发区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1612, 129, '合肥经济技术开发区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1613, 129, '合肥新站高新技术产业开发区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1614, 129, '巢湖市', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1615, 130, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1616, 130, '镜湖区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1617, 130, '弋江区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1618, 130, '鸠江区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1619, 130, '三山区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1620, 130, '芜湖县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1621, 130, '繁昌县', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1622, 130, '南陵县', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1623, 130, '无为县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1624, 130, '芜湖经济技术开发区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1625, 130, '安徽芜湖长江大桥经济开发区', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1626, 131, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1627, 131, '龙子湖区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1628, 131, '蚌山区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1629, 131, '禹会区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1630, 131, '淮上区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1631, 131, '怀远县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1632, 131, '五河县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1633, 131, '固镇县', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1634, 131, '蚌埠市高新技术开发区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1635, 131, '蚌埠市经济开发区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1636, 132, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1637, 132, '大通区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1638, 132, '田家庵区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1639, 132, '谢家集区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1640, 132, '八公山区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1641, 132, '潘集区', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1642, 132, '凤台县', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1643, 132, '寿县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1644, 133, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1645, 133, '花山区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1646, 133, '雨山区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1647, 133, '博望区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1648, 133, '当涂县', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1649, 133, '含山县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1650, 133, '和县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1651, 134, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1652, 134, '杜集区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1653, 134, '相山区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1654, 134, '烈山区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1655, 134, '濉溪县', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1656, 135, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1657, 135, '铜官区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1658, 135, '义安区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1659, 135, '郊区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1660, 135, '枞阳县', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1661, 136, '市辖区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1662, 136, '迎江区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1663, 136, '大观区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1664, 136, '宜秀区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1665, 136, '怀宁县', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1666, 136, '太湖县', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1667, 136, '宿松县', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1668, 136, '望江县', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1669, 136, '岳西县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1670, 136, '安徽安庆经济开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1671, 136, '桐城市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1672, 136, '潜山市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1673, 137, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1674, 137, '屯溪区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1675, 137, '黄山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1676, 137, '徽州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1677, 137, '歙县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1678, 137, '休宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1679, 137, '黟县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1680, 137, '祁门县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1681, 138, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1682, 138, '琅琊区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1683, 138, '南谯区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1684, 138, '来安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1685, 138, '全椒县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1686, 138, '定远县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1687, 138, '凤阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1688, 138, '苏滁现代产业园', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1689, 138, '滁州经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1690, 138, '天长市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1691, 138, '明光市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1692, 139, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1693, 139, '颍州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1694, 139, '颍东区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1695, 139, '颍泉区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1696, 139, '临泉县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1697, 139, '太和县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1698, 139, '阜南县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1699, 139, '颍上县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1700, 139, '阜阳合肥现代产业园区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1701, 139, '阜阳经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1702, 139, '界首市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1703, 140, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1704, 140, '埇桥区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1705, 140, '砀山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1706, 140, '萧县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1707, 140, '灵璧县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1708, 140, '泗县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1709, 140, '宿州马鞍山现代产业园区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1710, 140, '宿州经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1711, 141, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1712, 141, '金安区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1713, 141, '裕安区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1714, 141, '叶集区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1715, 141, '霍邱县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1716, 141, '舒城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1717, 141, '金寨县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1718, 141, '霍山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1719, 142, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1720, 142, '谯城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1721, 142, '涡阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1722, 142, '蒙城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1723, 142, '利辛县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1724, 143, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1725, 143, '贵池区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1726, 143, '东至县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1727, 143, '石台县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1728, 143, '青阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1729, 144, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1730, 144, '宣州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1731, 144, '郎溪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1732, 144, '广德县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1733, 144, '泾县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1734, 144, '绩溪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1735, 144, '旌德县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1736, 144, '宣城市经济开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1737, 144, '宁国市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1738, 145, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1739, 145, '鼓楼区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1740, 145, '台江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1741, 145, '仓山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1742, 145, '马尾区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1743, 145, '晋安区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1744, 145, '长乐区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1745, 145, '闽侯县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1746, 145, '连江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1747, 145, '罗源县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1748, 145, '闽清县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1749, 145, '永泰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1750, 145, '平潭县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1751, 145, '福清市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1752, 146, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1753, 146, '思明区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1754, 146, '海沧区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1755, 146, '湖里区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1756, 146, '集美区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1757, 146, '同安区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1758, 146, '翔安区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1759, 147, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1760, 147, '城厢区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1761, 147, '涵江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1762, 147, '荔城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1763, 147, '秀屿区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1764, 147, '仙游县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1765, 148, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1766, 148, '梅列区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1767, 148, '三元区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1768, 148, '明溪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1769, 148, '清流县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1770, 148, '宁化县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1771, 148, '大田县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1772, 148, '尤溪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1773, 148, '沙县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1774, 148, '将乐县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1775, 148, '泰宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1776, 148, '建宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1777, 148, '永安市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1778, 149, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1779, 149, '鲤城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1780, 149, '丰泽区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1781, 149, '洛江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1782, 149, '泉港区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1783, 149, '惠安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1784, 149, '安溪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1785, 149, '永春县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1786, 149, '德化县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1787, 149, '金门县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1788, 149, '石狮市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1789, 149, '晋江市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1790, 149, '南安市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1791, 150, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1792, 150, '芗城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1793, 150, '龙文区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1794, 150, '云霄县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1795, 150, '漳浦县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1796, 150, '诏安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1797, 150, '长泰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1798, 150, '东山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1799, 150, '南靖县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1800, 150, '平和县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1801, 150, '华安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1802, 150, '龙海市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1803, 151, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1804, 151, '延平区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1805, 151, '建阳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1806, 151, '顺昌县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1807, 151, '浦城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1808, 151, '光泽县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1809, 151, '松溪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1810, 151, '政和县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1811, 151, '邵武市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1812, 151, '武夷山市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1813, 151, '建瓯市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1814, 152, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1815, 152, '新罗区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1816, 152, '永定区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1817, 152, '长汀县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1818, 152, '上杭县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1819, 152, '武平县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1820, 152, '连城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1821, 152, '漳平市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1822, 153, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1823, 153, '蕉城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1824, 153, '霞浦县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1825, 153, '古田县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1826, 153, '屏南县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1827, 153, '寿宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1828, 153, '周宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1829, 153, '柘荣县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1830, 153, '福安市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1831, 153, '福鼎市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1832, 154, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1833, 154, '东湖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1834, 154, '西湖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1835, 154, '青云谱区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1836, 154, '湾里区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1837, 154, '青山湖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1838, 154, '新建区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1839, 154, '南昌县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1840, 154, '安义县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1841, 154, '进贤县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1842, 155, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1843, 155, '昌江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1844, 155, '珠山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1845, 155, '浮梁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1846, 155, '乐平市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1847, 156, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1848, 156, '安源区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1849, 156, '湘东区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1850, 156, '莲花县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1851, 156, '上栗县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1852, 156, '芦溪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1853, 157, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1854, 157, '濂溪区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1855, 157, '浔阳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1856, 157, '柴桑区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1857, 157, '武宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1858, 157, '修水县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1859, 157, '永修县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1860, 157, '德安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1861, 157, '都昌县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1862, 157, '湖口县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1863, 157, '彭泽县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1864, 157, '瑞昌市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1865, 157, '共青城市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1866, 157, '庐山市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1867, 158, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1868, 158, '渝水区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1869, 158, '分宜县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1870, 159, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1871, 159, '月湖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1872, 159, '余江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1873, 159, '贵溪市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1874, 160, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1875, 160, '章贡区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1876, 160, '南康区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1877, 160, '赣县区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1878, 160, '信丰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1879, 160, '大余县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1880, 160, '上犹县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1881, 160, '崇义县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1882, 160, '安远县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1883, 160, '龙南县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1884, 160, '定南县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1885, 160, '全南县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1886, 160, '宁都县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1887, 160, '于都县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1888, 160, '兴国县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1889, 160, '会昌县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1890, 160, '寻乌县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1891, 160, '石城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1892, 160, '瑞金市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1893, 161, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1894, 161, '吉州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1895, 161, '青原区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1896, 161, '吉安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1897, 161, '吉水县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1898, 161, '峡江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1899, 161, '新干县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1900, 161, '永丰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1901, 161, '泰和县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1902, 161, '遂川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1903, 161, '万安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1904, 161, '安福县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1905, 161, '永新县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1906, 161, '井冈山市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1907, 162, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1908, 162, '袁州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1909, 162, '奉新县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1910, 162, '万载县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1911, 162, '上高县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1912, 162, '宜丰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1913, 162, '靖安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1914, 162, '铜鼓县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1915, 162, '丰城市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1916, 162, '樟树市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1917, 162, '高安市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1918, 163, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1919, 163, '临川区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1920, 163, '东乡区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1921, 163, '南城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1922, 163, '黎川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1923, 163, '南丰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1924, 163, '崇仁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1925, 163, '乐安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1926, 163, '宜黄县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1927, 163, '金溪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1928, 163, '资溪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1929, 163, '广昌县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1930, 164, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1931, 164, '信州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1932, 164, '广丰区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1933, 164, '上饶县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1934, 164, '玉山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1935, 164, '铅山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1936, 164, '横峰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1937, 164, '弋阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1938, 164, '余干县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1939, 164, '鄱阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1940, 164, '万年县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1941, 164, '婺源县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1942, 164, '德兴市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1943, 165, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1944, 165, '历下区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1945, 165, '市中区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1946, 165, '槐荫区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1947, 165, '天桥区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1948, 165, '历城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1949, 165, '长清区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1950, 165, '章丘区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1951, 165, '济阳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1952, 165, '平阴县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1953, 165, '商河县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1954, 165, '济南高新技术产业开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1955, 166, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1956, 166, '市南区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1957, 166, '市北区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1958, 166, '黄岛区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1959, 166, '崂山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1960, 166, '李沧区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1961, 166, '城阳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1962, 166, '即墨区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1963, 166, '青岛高新技术产业开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1964, 166, '胶州市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1965, 166, '平度市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1966, 166, '莱西市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1967, 167, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1968, 167, '淄川区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1969, 167, '张店区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1970, 167, '博山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1971, 167, '临淄区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1972, 167, '周村区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1973, 167, '桓台县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1974, 167, '高青县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1975, 167, '沂源县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1976, 168, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1977, 168, '市中区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1978, 168, '薛城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1979, 168, '峄城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1980, 168, '台儿庄区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1981, 168, '山亭区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1982, 168, '滕州市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1983, 169, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1984, 169, '东营区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1985, 169, '河口区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1986, 169, '垦利区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1987, 169, '利津县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1988, 169, '广饶县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1989, 169, '东营经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1990, 169, '东营港经济开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1991, 170, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1992, 170, '芝罘区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1993, 170, '福山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1994, 170, '牟平区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1995, 170, '莱山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1996, 170, '长岛县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1997, 170, '烟台高新技术产业开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1998, 170, '烟台经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (1999, 170, '龙口市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2000, 170, '莱阳市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2001, 170, '莱州市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2002, 170, '蓬莱市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2003, 170, '招远市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2004, 170, '栖霞市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2005, 170, '海阳市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2006, 171, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2007, 171, '潍城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2008, 171, '寒亭区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2009, 171, '坊子区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2010, 171, '奎文区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2011, 171, '临朐县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2012, 171, '昌乐县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2013, 171, '潍坊滨海经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2014, 171, '青州市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2015, 171, '诸城市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2016, 171, '寿光市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2017, 171, '安丘市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2018, 171, '高密市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2019, 171, '昌邑市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2020, 172, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2021, 172, '任城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2022, 172, '兖州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2023, 172, '微山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2024, 172, '鱼台县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2025, 172, '金乡县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2026, 172, '嘉祥县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2027, 172, '汶上县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2028, 172, '泗水县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2029, 172, '梁山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2030, 172, '济宁高新技术产业开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2031, 172, '曲阜市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2032, 172, '邹城市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2033, 173, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2034, 173, '泰山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2035, 173, '岱岳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2036, 173, '宁阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2037, 173, '东平县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2038, 173, '新泰市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2039, 173, '肥城市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2040, 174, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2041, 174, '环翠区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2042, 174, '文登区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2043, 174, '威海火炬高技术产业开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2044, 174, '威海经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2045, 174, '威海临港经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2046, 174, '荣成市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2047, 174, '乳山市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2048, 175, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2049, 175, '东港区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2050, 175, '岚山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2051, 175, '五莲县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2052, 175, '莒县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2053, 175, '日照经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2054, 176, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2055, 176, '莱城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2056, 176, '钢城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2057, 177, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2058, 177, '兰山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2059, 177, '罗庄区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2060, 177, '河东区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2061, 177, '沂南县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2062, 177, '郯城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2063, 177, '沂水县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2064, 177, '兰陵县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2065, 177, '费县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2066, 177, '平邑县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2067, 177, '莒南县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2068, 177, '蒙阴县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2069, 177, '临沭县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2070, 177, '临沂高新技术产业开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2071, 177, '临沂经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2072, 177, '临沂临港经济开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2073, 178, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2074, 178, '德城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2075, 178, '陵城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2076, 178, '宁津县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2077, 178, '庆云县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2078, 178, '临邑县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2079, 178, '齐河县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2080, 178, '平原县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2081, 178, '夏津县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2082, 178, '武城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2083, 178, '德州经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2084, 178, '德州运河经济开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2085, 178, '乐陵市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2086, 178, '禹城市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2087, 179, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2088, 179, '东昌府区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2089, 179, '阳谷县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2090, 179, '莘县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2091, 179, '茌平县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2092, 179, '东阿县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2093, 179, '冠县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2094, 179, '高唐县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2095, 179, '临清市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2096, 180, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2097, 180, '滨城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2098, 180, '沾化区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2099, 180, '惠民县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2100, 180, '阳信县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2101, 180, '无棣县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2102, 180, '博兴县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2103, 180, '邹平市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2104, 181, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2105, 181, '牡丹区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2106, 181, '定陶区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2107, 181, '曹县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2108, 181, '单县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2109, 181, '成武县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2110, 181, '巨野县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2111, 181, '郓城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2112, 181, '鄄城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2113, 181, '东明县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2114, 181, '菏泽经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2115, 181, '菏泽高新技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2116, 182, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2117, 182, '中原区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2118, 182, '二七区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2119, 182, '管城回族区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2120, 182, '金水区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2121, 182, '上街区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2122, 182, '惠济区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2123, 182, '中牟县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2124, 182, '郑州经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2125, 182, '郑州高新技术产业开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2126, 182, '郑州航空港经济综合实验区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2127, 182, '巩义市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2128, 182, '荥阳市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2129, 182, '新密市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2130, 182, '新郑市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2131, 182, '登封市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2132, 183, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2133, 183, '龙亭区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2134, 183, '顺河回族区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2135, 183, '鼓楼区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2136, 183, '禹王台区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2137, 183, '祥符区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2138, 183, '杞县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2139, 183, '通许县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2140, 183, '尉氏县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2141, 183, '兰考县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2142, 184, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2143, 184, '老城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2144, 184, '西工区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2145, 184, '瀍河回族区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2146, 184, '涧西区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2147, 184, '吉利区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2148, 184, '洛龙区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2149, 184, '孟津县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2150, 184, '新安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2151, 184, '栾川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2152, 184, '嵩县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2153, 184, '汝阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2154, 184, '宜阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2155, 184, '洛宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2156, 184, '伊川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2157, 184, '洛阳高新技术产业开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2158, 184, '偃师市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2159, 185, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2160, 185, '新华区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2161, 185, '卫东区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2162, 185, '石龙区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2163, 185, '湛河区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2164, 185, '宝丰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2165, 185, '叶县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2166, 185, '鲁山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2167, 185, '郏县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2168, 185, '平顶山高新技术产业开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2169, 185, '平顶山市新城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2170, 185, '舞钢市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2171, 185, '汝州市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2172, 186, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2173, 186, '文峰区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2174, 186, '北关区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2175, 186, '殷都区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2176, 186, '龙安区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2177, 186, '安阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2178, 186, '汤阴县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2179, 186, '滑县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2180, 186, '内黄县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2181, 186, '安阳高新技术产业开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2182, 186, '林州市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2183, 187, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2184, 187, '鹤山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2185, 187, '山城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2186, 187, '淇滨区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2187, 187, '浚县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2188, 187, '淇县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2189, 187, '鹤壁经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2190, 188, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2191, 188, '红旗区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2192, 188, '卫滨区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2193, 188, '凤泉区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2194, 188, '牧野区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2195, 188, '新乡县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2196, 188, '获嘉县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2197, 188, '原阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2198, 188, '延津县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2199, 188, '封丘县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2200, 188, '长垣县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2201, 188, '新乡高新技术产业开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2202, 188, '新乡经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2203, 188, '新乡市平原城乡一体化示范区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2204, 188, '卫辉市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2205, 188, '辉县市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2206, 189, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2207, 189, '解放区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2208, 189, '中站区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2209, 189, '马村区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2210, 189, '山阳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2211, 189, '修武县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2212, 189, '博爱县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2213, 189, '武陟县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2214, 189, '温县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2215, 189, '焦作城乡一体化示范区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2216, 189, '沁阳市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2217, 189, '孟州市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2218, 190, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2219, 190, '华龙区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2220, 190, '清丰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2221, 190, '南乐县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2222, 190, '范县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2223, 190, '台前县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2224, 190, '濮阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2225, 190, '河南濮阳工业园区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2226, 190, '濮阳经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2227, 191, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2228, 191, '魏都区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2229, 191, '建安区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2230, 191, '鄢陵县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2231, 191, '襄城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2232, 191, '许昌经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2233, 191, '禹州市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2234, 191, '长葛市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2235, 192, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2236, 192, '源汇区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2237, 192, '郾城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2238, 192, '召陵区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2239, 192, '舞阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2240, 192, '临颍县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2241, 192, '漯河经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2242, 193, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2243, 193, '湖滨区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2244, 193, '陕州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2245, 193, '渑池县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2246, 193, '卢氏县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2247, 193, '河南三门峡经济开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2248, 193, '义马市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2249, 193, '灵宝市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2250, 194, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2251, 194, '宛城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2252, 194, '卧龙区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2253, 194, '南召县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2254, 194, '方城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2255, 194, '西峡县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2256, 194, '镇平县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2257, 194, '内乡县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2258, 194, '淅川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2259, 194, '社旗县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2260, 194, '唐河县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2261, 194, '新野县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2262, 194, '桐柏县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2263, 194, '南阳高新技术产业开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2264, 194, '南阳市城乡一体化示范区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2265, 194, '邓州市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2266, 195, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2267, 195, '梁园区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2268, 195, '睢阳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2269, 195, '民权县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2270, 195, '睢县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2271, 195, '宁陵县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2272, 195, '柘城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2273, 195, '虞城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2274, 195, '夏邑县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2275, 195, '豫东综合物流产业聚集区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2276, 195, '河南商丘经济开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2277, 195, '永城市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2278, 196, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2279, 196, '411502', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2280, 196, '平桥区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2281, 196, '罗山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2282, 196, '光山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2283, 196, '新县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2284, 196, '商城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2285, 196, '固始县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2286, 196, '潢川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2287, 196, '淮滨县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2288, 196, '息县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2289, 196, '信阳高新技术产业开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2290, 197, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2291, 197, '川汇区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2292, 197, '扶沟县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2293, 197, '西华县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2294, 197, '商水县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2295, 197, '沈丘县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2296, 197, '郸城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2297, 197, '淮阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2298, 197, '太康县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2299, 197, '鹿邑县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2300, 197, '河南周口经济开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2301, 197, '项城市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2302, 198, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2303, 198, '驿城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2304, 198, '西平县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2305, 198, '上蔡县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2306, 198, '平舆县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2307, 198, '正阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2308, 198, '确山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2309, 198, '泌阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2310, 198, '汝南县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2311, 198, '遂平县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2312, 198, '新蔡县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2313, 198, '河南驻马店经济开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2314, 199, '济源市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2315, 200, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2316, 200, '江岸区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2317, 200, '江汉区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2318, 200, '硚口区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2319, 200, '汉阳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2320, 200, '武昌区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2321, 200, '青山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2322, 200, '洪山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2323, 200, '东西湖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2324, 200, '汉南区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2325, 200, '蔡甸区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2326, 200, '江夏区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2327, 200, '黄陂区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2328, 200, '新洲区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2329, 201, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2330, 201, '黄石港区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2331, 201, '西塞山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2332, 201, '下陆区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2333, 201, '铁山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2334, 201, '阳新县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2335, 201, '大冶市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2336, 202, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2337, 202, '茅箭区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2338, 202, '张湾区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2339, 202, '郧阳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2340, 202, '郧西县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2341, 202, '竹山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2342, 202, '竹溪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2343, 202, '房县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2344, 202, '丹江口市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2345, 203, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2346, 203, '西陵区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2347, 203, '伍家岗区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2348, 203, '点军区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2349, 203, '猇亭区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2350, 203, '夷陵区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2351, 203, '远安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2352, 203, '兴山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2353, 203, '秭归县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2354, 203, '长阳土家族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2355, 203, '五峰土家族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2356, 203, '宜都市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2357, 203, '当阳市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2358, 203, '枝江市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2359, 204, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2360, 204, '襄城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2361, 204, '樊城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2362, 204, '襄州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2363, 204, '南漳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2364, 204, '谷城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2365, 204, '保康县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2366, 204, '老河口市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2367, 204, '枣阳市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2368, 204, '宜城市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2369, 205, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2370, 205, '梁子湖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2371, 205, '华容区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2372, 205, '鄂城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2373, 206, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2374, 206, '东宝区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2375, 206, '掇刀区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2376, 206, '沙洋县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2377, 206, '钟祥市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2378, 206, '京山市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2379, 207, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2380, 207, '孝南区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2381, 207, '孝昌县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2382, 207, '大悟县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2383, 207, '云梦县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2384, 207, '应城市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2385, 207, '安陆市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2386, 207, '汉川市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2387, 208, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2388, 208, '沙市区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2389, 208, '荆州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2390, 208, '公安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2391, 208, '监利县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2392, 208, '江陵县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2393, 208, '荆州经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2394, 208, '石首市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2395, 208, '洪湖市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2396, 208, '松滋市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2397, 209, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2398, 209, '黄州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2399, 209, '团风县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2400, 209, '红安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2401, 209, '罗田县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2402, 209, '英山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2403, 209, '浠水县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2404, 209, '蕲春县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2405, 209, '黄梅县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2406, 209, '龙感湖管理区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2407, 209, '麻城市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2408, 209, '武穴市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2409, 210, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2410, 210, '咸安区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2411, 210, '嘉鱼县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2412, 210, '通城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2413, 210, '崇阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2414, 210, '通山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2415, 210, '赤壁市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2416, 211, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2417, 211, '曾都区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2418, 211, '随县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2419, 211, '广水市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2420, 212, '恩施市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2421, 212, '利川市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2422, 212, '建始县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2423, 212, '巴东县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2424, 212, '宣恩县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2425, 212, '咸丰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2426, 212, '来凤县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2427, 212, '鹤峰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2428, 213, '仙桃市', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2429, 213, '潜江市', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2430, 213, '天门市', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2431, 213, '神农架林区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2432, 214, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2433, 214, '芙蓉区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2434, 214, '天心区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2435, 214, '岳麓区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2436, 214, '开福区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2437, 214, '雨花区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2438, 214, '望城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2439, 214, '长沙县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2440, 214, '浏阳市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2441, 214, '宁乡市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2442, 215, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2443, 215, '荷塘区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2444, 215, '芦淞区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2445, 215, '石峰区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2446, 215, '天元区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2447, 215, '渌口区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2448, 215, '攸县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2449, 215, '茶陵县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2450, 215, '炎陵县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2451, 215, '云龙示范区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2452, 215, '醴陵市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2453, 216, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2454, 216, '雨湖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2455, 216, '岳塘区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2456, 216, '湘潭县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2457, 216, '湖南湘潭高新技术产业园区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2458, 216, '湘潭昭山示范区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2459, 216, '湘潭九华示范区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2460, 216, '湘乡市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2461, 216, '韶山市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2462, 217, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2463, 217, '珠晖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2464, 217, '雁峰区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2465, 217, '石鼓区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2466, 217, '蒸湘区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2467, 217, '南岳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2468, 217, '衡阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2469, 217, '衡南县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2470, 217, '衡山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2471, 217, '衡东县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2472, 217, '祁东县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2473, 217, '衡阳综合保税区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2474, 217, '湖南衡阳高新技术产业园区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2475, 217, '湖南衡阳松木经济开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2476, 217, '耒阳市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2477, 217, '常宁市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2478, 218, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2479, 218, '双清区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2480, 218, '大祥区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2481, 218, '北塔区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2482, 218, '邵东县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2483, 218, '新邵县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2484, 218, '邵阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2485, 218, '隆回县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2486, 218, '洞口县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2487, 218, '绥宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2488, 218, '新宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2489, 218, '城步苗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2490, 218, '武冈市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2491, 219, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2492, 219, '岳阳楼区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2493, 219, '云溪区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2494, 219, '君山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2495, 219, '岳阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2496, 219, '华容县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2497, 219, '湘阴县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2498, 219, '平江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2499, 219, '岳阳市屈原管理区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2500, 219, '汨罗市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2501, 219, '临湘市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2502, 220, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2503, 220, '武陵区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2504, 220, '鼎城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2505, 220, '安乡县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2506, 220, '汉寿县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2507, 220, '澧县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2508, 220, '临澧县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2509, 220, '桃源县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2510, 220, '石门县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2511, 220, '常德市西洞庭管理区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2512, 220, '津市市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2513, 221, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2514, 221, '永定区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2515, 221, '武陵源区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2516, 221, '慈利县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2517, 221, '桑植县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2518, 222, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2519, 222, '资阳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2520, 222, '赫山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2521, 222, '南县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2522, 222, '桃江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2523, 222, '安化县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2524, 222, '益阳市大通湖管理区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2525, 222, '湖南益阳高新技术产业园区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2526, 222, '沅江市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2527, 223, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2528, 223, '北湖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2529, 223, '苏仙区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2530, 223, '桂阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2531, 223, '宜章县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2532, 223, '永兴县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2533, 223, '嘉禾县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2534, 223, '临武县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2535, 223, '汝城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2536, 223, '桂东县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2537, 223, '安仁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2538, 223, '资兴市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2539, 224, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2540, 224, '零陵区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2541, 224, '冷水滩区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2542, 224, '祁阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2543, 224, '东安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2544, 224, '双牌县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2545, 224, '道县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2546, 224, '江永县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2547, 224, '宁远县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2548, 224, '蓝山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2549, 224, '新田县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2550, 224, '江华瑶族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2551, 224, '永州经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2552, 224, '永州市金洞管理区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2553, 224, '永州市回龙圩管理区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2554, 225, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2555, 225, '鹤城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2556, 225, '中方县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2557, 225, '沅陵县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2558, 225, '辰溪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2559, 225, '溆浦县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2560, 225, '会同县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2561, 225, '麻阳苗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2562, 225, '新晃侗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2563, 225, '芷江侗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2564, 225, '靖州苗族侗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2565, 225, '通道侗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2566, 225, '怀化市洪江管理区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2567, 225, '洪江市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2568, 226, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2569, 226, '娄星区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2570, 226, '双峰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2571, 226, '新化县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2572, 226, '冷水江市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2573, 226, '涟源市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2574, 227, '吉首市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2575, 227, '泸溪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2576, 227, '凤凰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2577, 227, '花垣县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2578, 227, '保靖县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2579, 227, '古丈县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2580, 227, '永顺县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2581, 227, '龙山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2582, 227, '湖南吉首经济开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2583, 227, '湖南永顺经济开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2584, 228, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2585, 228, '荔湾区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2586, 228, '越秀区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2587, 228, '海珠区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2588, 228, '天河区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2589, 228, '白云区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2590, 228, '黄埔区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2591, 228, '番禺区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2592, 228, '花都区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2593, 228, '南沙区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2594, 228, '从化区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2595, 228, '增城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2596, 229, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2597, 229, '武江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2598, 229, '浈江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2599, 229, '曲江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2600, 229, '始兴县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2601, 229, '仁化县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2602, 229, '翁源县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2603, 229, '乳源瑶族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2604, 229, '新丰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2605, 229, '乐昌市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2606, 229, '南雄市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2607, 230, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2608, 230, '罗湖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2609, 230, '福田区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2610, 230, '南山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2611, 230, '宝安区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2612, 230, '龙岗区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2613, 230, '盐田区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2614, 230, '龙华区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2615, 230, '坪山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2616, 230, '光明区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2617, 231, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2618, 231, '香洲区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2619, 231, '斗门区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2620, 231, '金湾区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2621, 232, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2622, 232, '龙湖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2623, 232, '金平区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2624, 232, '濠江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2625, 232, '潮阳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2626, 232, '潮南区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2627, 232, '澄海区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2628, 232, '南澳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2629, 233, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2630, 233, '禅城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2631, 233, '南海区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2632, 233, '顺德区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2633, 233, '三水区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2634, 233, '高明区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2635, 234, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2636, 234, '蓬江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2637, 234, '江海区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2638, 234, '新会区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2639, 234, '台山市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2640, 234, '开平市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2641, 234, '鹤山市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2642, 234, '恩平市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2643, 235, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2644, 235, '赤坎区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2645, 235, '霞山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2646, 235, '坡头区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2647, 235, '麻章区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2648, 235, '遂溪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2649, 235, '徐闻县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2650, 235, '廉江市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2651, 235, '雷州市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2652, 235, '吴川市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2653, 236, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2654, 236, '茂南区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2655, 236, '电白区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2656, 236, '高州市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2657, 236, '化州市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2658, 236, '信宜市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2659, 237, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2660, 237, '端州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2661, 237, '鼎湖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2662, 237, '高要区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2663, 237, '广宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2664, 237, '怀集县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2665, 237, '封开县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2666, 237, '德庆县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2667, 237, '四会市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2668, 238, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2669, 238, '惠城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2670, 238, '惠阳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2671, 238, '博罗县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2672, 238, '惠东县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2673, 238, '龙门县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2674, 239, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2675, 239, '梅江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2676, 239, '梅县区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2677, 239, '大埔县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2678, 239, '丰顺县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2679, 239, '五华县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2680, 239, '平远县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2681, 239, '蕉岭县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2682, 239, '兴宁市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2683, 240, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2684, 240, '城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2685, 240, '海丰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2686, 240, '陆河县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2687, 240, '陆丰市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2688, 241, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2689, 241, '源城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2690, 241, '紫金县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2691, 241, '龙川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2692, 241, '连平县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2693, 241, '和平县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2694, 241, '东源县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2695, 242, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2696, 242, '江城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2697, 242, '阳东区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2698, 242, '阳西县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2699, 242, '阳春市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2700, 243, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2701, 243, '清城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2702, 243, '清新区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2703, 243, '佛冈县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2704, 243, '阳山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2705, 243, '连山壮族瑶族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2706, 243, '连南瑶族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2707, 243, '英德市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2708, 243, '连州市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2709, 244, '东城街道办事处', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2710, 244, '南城街道办事处', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2711, 244, '万江街道办事处', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2712, 244, '莞城街道办事处', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2713, 244, '石碣镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2714, 244, '石龙镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2715, 244, '茶山镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2716, 244, '石排镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2717, 244, '企石镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2718, 244, '横沥镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2719, 244, '桥头镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2720, 244, '谢岗镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2721, 244, '东坑镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2722, 244, '常平镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2723, 244, '寮步镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2724, 244, '樟木头镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2725, 244, '大朗镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2726, 244, '黄江镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2727, 244, '清溪镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2728, 244, '塘厦镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2729, 244, '凤岗镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2730, 244, '大岭山镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2731, 244, '长安镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2732, 244, '虎门镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2733, 244, '厚街镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2734, 244, '沙田镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2735, 244, '道�镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2736, 244, '洪梅镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2737, 244, '麻涌镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2738, 244, '望牛墩镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2739, 244, '中堂镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2740, 244, '高�镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2741, 244, '松山湖管委会', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2742, 244, '东莞港', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2743, 244, '东莞生态园', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2744, 245, '石岐区街道办事处', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2745, 245, '东区街道办事处', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2746, 245, '火炬开发区街道办事处', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2747, 245, '西区街道办事处', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2748, 245, '南区街道办事处', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2749, 245, '五桂山街道办事处', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2750, 245, '小榄镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2751, 245, '黄圃镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2752, 245, '民众镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2753, 245, '东凤镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2754, 245, '东升镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2755, 245, '古镇镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2756, 245, '沙溪镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2757, 245, '坦洲镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2758, 245, '港口镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2759, 245, '三角镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2760, 245, '横栏镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2761, 245, '南头镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2762, 245, '阜沙镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2763, 245, '南朗镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2764, 245, '三乡镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2765, 245, '板芙镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2766, 245, '大涌镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2767, 245, '神湾镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2768, 246, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2769, 246, '湘桥区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2770, 246, '潮安区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2771, 246, '饶平县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2772, 247, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2773, 247, '榕城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2774, 247, '揭东区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2775, 247, '揭西县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2776, 247, '惠来县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2777, 247, '普宁市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2778, 248, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2779, 248, '云城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2780, 248, '云安区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2781, 248, '新兴县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2782, 248, '郁南县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2783, 248, '罗定市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2784, 249, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2785, 249, '兴宁区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2786, 249, '青秀区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2787, 249, '江南区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2788, 249, '西乡塘区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2789, 249, '良庆区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2790, 249, '邕宁区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2791, 249, '武鸣区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2792, 249, '隆安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2793, 249, '马山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2794, 249, '上林县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2795, 249, '宾阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2796, 249, '横县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2797, 250, '市辖区', NULL, 1, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2798, 250, '城中区', NULL, 1, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2799, 250, '鱼峰区', NULL, 1, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2800, 250, '柳南区', NULL, 1, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2801, 250, '柳北区', NULL, 1, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2802, 250, '柳江区', NULL, 1, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2803, 250, '柳城县', NULL, 1, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2804, 250, '鹿寨县', NULL, 1, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2805, 250, '融安县', NULL, 1, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2806, 250, '融水苗族自治县', NULL, 1, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2807, 250, '三江侗族自治县', NULL, 1, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2808, 251, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2809, 251, '秀峰区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2810, 251, '叠彩区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2811, 251, '象山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2812, 251, '七星区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2813, 251, '雁山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2814, 251, '临桂区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2815, 251, '阳朔县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2816, 251, '灵川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2817, 251, '全州县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2818, 251, '兴安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2819, 251, '永福县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2820, 251, '灌阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2821, 251, '龙胜各族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2822, 251, '资源县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2823, 251, '平乐县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2824, 251, '恭城瑶族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2825, 251, '荔浦市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2826, 252, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2827, 252, '万秀区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2828, 252, '长洲区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2829, 252, '龙圩区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2830, 252, '苍梧县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2831, 252, '藤县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2832, 252, '蒙山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2833, 252, '岑溪市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2834, 253, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2835, 253, '海城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2836, 253, '银海区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2837, 253, '铁山港区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2838, 253, '合浦县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2839, 254, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2840, 254, '港口区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2841, 254, '防城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2842, 254, '上思县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2843, 254, '东兴市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2844, 255, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2845, 255, '钦南区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2846, 255, '钦北区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2847, 255, '灵山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2848, 255, '浦北县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2849, 256, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2850, 256, '港北区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2851, 256, '港南区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2852, 256, '覃塘区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2853, 256, '平南县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2854, 256, '桂平市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2855, 257, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2856, 257, '玉州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2857, 257, '福绵区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2858, 257, '容县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2859, 257, '陆川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2860, 257, '博白县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2861, 257, '兴业县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2862, 257, '北流市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2863, 258, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2864, 258, '右江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2865, 258, '田阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2866, 258, '田东县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2867, 258, '平果县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2868, 258, '德保县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2869, 258, '那坡县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2870, 258, '凌云县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2871, 258, '乐业县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2872, 258, '田林县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2873, 258, '西林县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2874, 258, '隆林各族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2875, 258, '靖西市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2876, 259, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2877, 259, '八步区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2878, 259, '平桂区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2879, 259, '昭平县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2880, 259, '钟山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2881, 259, '富川瑶族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2882, 260, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2883, 260, '金城江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2884, 260, '宜州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2885, 260, '南丹县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2886, 260, '天峨县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2887, 260, '凤山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2888, 260, '东兰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2889, 260, '罗城仫佬族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2890, 260, '环江毛南族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2891, 260, '巴马瑶族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2892, 260, '都安瑶族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2893, 260, '大化瑶族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2894, 261, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2895, 261, '兴宾区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2896, 261, '忻城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2897, 261, '象州县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2898, 261, '武宣县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2899, 261, '金秀瑶族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2900, 261, '合山市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2901, 262, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2902, 262, '江州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2903, 262, '扶绥县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2904, 262, '宁明县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2905, 262, '龙州县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2906, 262, '大新县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2907, 262, '天等县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2908, 262, '凭祥市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2909, 263, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2910, 263, '秀英区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2911, 263, '龙华区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2912, 263, '琼山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2913, 263, '美兰区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2914, 264, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2915, 264, '海棠区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2916, 264, '吉阳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2917, 264, '天涯区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2918, 264, '崖州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2919, 265, '西沙群岛', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2920, 265, '南沙群岛', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2921, 265, '中沙群岛的岛礁及其海域', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2922, 266, '那大镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2923, 266, '和庆镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2924, 266, '南丰镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2925, 266, '大成镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2926, 266, '雅星镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2927, 266, '兰洋镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2928, 266, '光村镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2929, 266, '木棠镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2930, 266, '海头镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2931, 266, '峨蔓镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2932, 266, '王五镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2933, 266, '白马井镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2934, 266, '中和镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2935, 266, '排浦镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2936, 266, '东成镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2937, 266, '新州镇', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2938, 266, '洋浦经济开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2939, 266, '华南热作学院', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2940, 267, '五指山市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2941, 267, '琼海市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2942, 267, '文昌市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2943, 267, '万宁市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2944, 267, '东方市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2945, 267, '定安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2946, 267, '屯昌县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2947, 267, '澄迈县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2948, 267, '临高县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2949, 267, '白沙黎族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2950, 267, '昌江黎族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2951, 267, '乐东黎族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2952, 267, '陵水黎族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2953, 267, '保亭黎族苗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2954, 267, '琼中黎族苗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2955, 268, '万州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2956, 268, '涪陵区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2957, 268, '渝中区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2958, 268, '大渡口区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2959, 268, '江北区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2960, 268, '沙坪坝区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2961, 268, '九龙坡区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2962, 268, '南岸区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2963, 268, '北碚区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2964, 268, '綦江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2965, 268, '大足区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2966, 268, '渝北区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2967, 268, '巴南区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2968, 268, '黔江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2969, 268, '长寿区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2970, 268, '江津区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2971, 268, '合川区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2972, 268, '永川区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2973, 268, '南川区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2974, 268, '璧山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2975, 268, '铜梁区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2976, 268, '潼南区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2977, 268, '荣昌区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2978, 268, '开州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2979, 268, '梁平区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2980, 268, '武隆区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2981, 269, '城口县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2982, 269, '丰都县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2983, 269, '垫江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2984, 269, '忠县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2985, 269, '云阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2986, 269, '奉节县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2987, 269, '巫山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2988, 269, '巫溪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2989, 269, '石柱土家族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2990, 269, '秀山土家族苗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2991, 269, '酉阳土家族苗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2992, 269, '彭水苗族土家族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2993, 270, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2994, 270, '锦江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2995, 270, '青羊区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2996, 270, '金牛区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2997, 270, '武侯区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2998, 270, '成华区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (2999, 270, '龙泉驿区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3000, 270, '青白江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3001, 270, '新都区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3002, 270, '温江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3003, 270, '双流区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3004, 270, '郫都区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3005, 270, '金堂县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3006, 270, '大邑县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3007, 270, '蒲江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3008, 270, '新津县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3009, 270, '都江堰市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3010, 270, '彭州市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3011, 270, '邛崃市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3012, 270, '崇州市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3013, 270, '简阳市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3014, 271, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3015, 271, '自流井区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3016, 271, '贡井区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3017, 271, '大安区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3018, 271, '沿滩区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3019, 271, '荣县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3020, 271, '富顺县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3021, 272, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3022, 272, '东区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3023, 272, '西区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3024, 272, '仁和区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3025, 272, '米易县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3026, 272, '盐边县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3027, 273, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3028, 273, '江阳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3029, 273, '纳溪区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3030, 273, '龙马潭区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3031, 273, '泸县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3032, 273, '合江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3033, 273, '叙永县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3034, 273, '古蔺县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3035, 274, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3036, 274, '旌阳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3037, 274, '罗江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3038, 274, '中江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3039, 274, '广汉市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3040, 274, '什邡市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3041, 274, '绵竹市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3042, 275, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3043, 275, '涪城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3044, 275, '游仙区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3045, 275, '安州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3046, 275, '三台县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3047, 275, '盐亭县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3048, 275, '梓潼县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3049, 275, '北川羌族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3050, 275, '平武县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3051, 275, '江油市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3052, 276, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3053, 276, '利州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3054, 276, '昭化区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3055, 276, '朝天区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3056, 276, '旺苍县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3057, 276, '青川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3058, 276, '剑阁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3059, 276, '苍溪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3060, 277, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3061, 277, '船山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3062, 277, '安居区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3063, 277, '蓬溪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3064, 277, '射洪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3065, 277, '大英县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3066, 278, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3067, 278, '市中区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3068, 278, '东兴区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3069, 278, '威远县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3070, 278, '资中县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3071, 278, '内江经济开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3072, 278, '隆昌市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3073, 279, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3074, 279, '市中区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3075, 279, '沙湾区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3076, 279, '五通桥区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3077, 279, '金口河区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3078, 279, '犍为县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3079, 279, '井研县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3080, 279, '夹江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3081, 279, '沐川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3082, 279, '峨边彝族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3083, 279, '马边彝族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3084, 279, '峨眉山市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3085, 280, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3086, 280, '顺庆区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3087, 280, '高坪区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3088, 280, '嘉陵区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3089, 280, '南部县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3090, 280, '营山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3091, 280, '蓬安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3092, 280, '仪陇县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3093, 280, '西充县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3094, 280, '阆中市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3095, 281, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3096, 281, '东坡区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3097, 281, '彭山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3098, 281, '仁寿县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3099, 281, '洪雅县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3100, 281, '丹棱县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3101, 281, '青神县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3102, 282, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3103, 282, '翠屏区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3104, 282, '南溪区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3105, 282, '叙州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3106, 282, '江安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3107, 282, '长宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3108, 282, '高县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3109, 282, '珙县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3110, 282, '筠连县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3111, 282, '兴文县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3112, 282, '屏山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3113, 283, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3114, 283, '广安区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3115, 283, '前锋区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3116, 283, '岳池县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3117, 283, '武胜县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3118, 283, '邻水县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3119, 283, '华蓥市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3120, 284, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3121, 284, '通川区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3122, 284, '达川区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3123, 284, '宣汉县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3124, 284, '开江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3125, 284, '大竹县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3126, 284, '渠县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3127, 284, '达州经济开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3128, 284, '万源市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3129, 285, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3130, 285, '雨城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3131, 285, '名山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3132, 285, '荥经县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3133, 285, '汉源县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3134, 285, '石棉县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3135, 285, '天全县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3136, 285, '芦山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3137, 285, '宝兴县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3138, 286, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3139, 286, '巴州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3140, 286, '恩阳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3141, 286, '通江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3142, 286, '南江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3143, 286, '平昌县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3144, 286, '巴中经济开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3145, 287, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3146, 287, '雁江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3147, 287, '安岳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3148, 287, '乐至县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3149, 288, '马尔康市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3150, 288, '汶川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3151, 288, '理县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3152, 288, '茂县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3153, 288, '松潘县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3154, 288, '九寨沟县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3155, 288, '金川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3156, 288, '小金县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3157, 288, '黑水县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3158, 288, '壤塘县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3159, 288, '阿坝县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3160, 288, '若尔盖县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3161, 288, '红原县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3162, 289, '康定市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3163, 289, '泸定县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3164, 289, '丹巴县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3165, 289, '九龙县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3166, 289, '雅江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3167, 289, '道孚县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3168, 289, '炉霍县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3169, 289, '甘孜县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3170, 289, '新龙县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3171, 289, '德格县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3172, 289, '白玉县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3173, 289, '石渠县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3174, 289, '色达县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3175, 289, '理塘县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3176, 289, '巴塘县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3177, 289, '乡城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3178, 289, '稻城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3179, 289, '得荣县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3180, 290, '西昌市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3181, 290, '木里藏族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3182, 290, '盐源县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3183, 290, '德昌县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3184, 290, '会理县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3185, 290, '会东县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3186, 290, '宁南县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3187, 290, '普格县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3188, 290, '布拖县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3189, 290, '金阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3190, 290, '昭觉县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3191, 290, '喜德县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3192, 290, '冕宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3193, 290, '越西县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3194, 290, '甘洛县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3195, 290, '美姑县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3196, 290, '雷波县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3197, 291, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3198, 291, '南明区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3199, 291, '云岩区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3200, 291, '花溪区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3201, 291, '乌当区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3202, 291, '白云区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3203, 291, '观山湖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3204, 291, '开阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3205, 291, '息烽县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3206, 291, '修文县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3207, 291, '清镇市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3208, 292, '钟山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3209, 292, '六枝特区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3210, 292, '水城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3211, 292, '盘州市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3212, 293, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3213, 293, '红花岗区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3214, 293, '汇川区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3215, 293, '播州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3216, 293, '桐梓县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3217, 293, '绥阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3218, 293, '正安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3219, 293, '道真仡佬族苗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3220, 293, '务川仡佬族苗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3221, 293, '凤冈县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3222, 293, '湄潭县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3223, 293, '余庆县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3224, 293, '习水县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3225, 293, '赤水市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3226, 293, '仁怀市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3227, 294, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3228, 294, '西秀区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3229, 294, '平坝区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3230, 294, '普定县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3231, 294, '镇宁布依族苗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3232, 294, '关岭布依族苗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3233, 294, '紫云苗族布依族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3234, 295, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3235, 295, '七星关区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3236, 295, '大方县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3237, 295, '黔西县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3238, 295, '金沙县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3239, 295, '织金县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3240, 295, '纳雍县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3241, 295, '威宁彝族回族苗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3242, 295, '赫章县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3243, 296, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3244, 296, '碧江区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3245, 296, '万山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3246, 296, '江口县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3247, 296, '玉屏侗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3248, 296, '石阡县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3249, 296, '思南县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3250, 296, '印江土家族苗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3251, 296, '德江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3252, 296, '沿河土家族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3253, 296, '松桃苗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3254, 297, '兴义市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3255, 297, '兴仁市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3256, 297, '普安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3257, 297, '晴隆县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3258, 297, '贞丰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3259, 297, '望谟县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3260, 297, '册亨县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3261, 297, '安龙县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3262, 298, '凯里市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3263, 298, '黄平县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3264, 298, '施秉县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3265, 298, '三穗县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3266, 298, '镇远县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3267, 298, '岑巩县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3268, 298, '天柱县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3269, 298, '锦屏县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3270, 298, '剑河县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3271, 298, '台江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3272, 298, '黎平县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3273, 298, '榕江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3274, 298, '从江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3275, 298, '雷山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3276, 298, '麻江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3277, 298, '丹寨县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3278, 299, '都匀市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3279, 299, '福泉市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3280, 299, '荔波县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3281, 299, '贵定县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3282, 299, '瓮安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3283, 299, '独山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3284, 299, '平塘县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3285, 299, '罗甸县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3286, 299, '长顺县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3287, 299, '龙里县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3288, 299, '惠水县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3289, 299, '三都水族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3290, 300, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3291, 300, '五华区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3292, 300, '盘龙区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3293, 300, '官渡区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3294, 300, '西山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3295, 300, '东川区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3296, 300, '呈贡区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3297, 300, '晋宁区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3298, 300, '富民县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3299, 300, '宜良县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3300, 300, '石林彝族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3301, 300, '嵩明县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3302, 300, '禄劝彝族苗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3303, 300, '寻甸回族彝族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3304, 300, '安宁市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3305, 301, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3306, 301, '麒麟区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3307, 301, '沾益区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3308, 301, '马龙区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3309, 301, '陆良县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3310, 301, '师宗县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3311, 301, '罗平县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3312, 301, '富源县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3313, 301, '会泽县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3314, 301, '宣威市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3315, 302, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3316, 302, '红塔区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3317, 302, '江川区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3318, 302, '澄江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3319, 302, '通海县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3320, 302, '华宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3321, 302, '易门县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3322, 302, '峨山彝族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3323, 302, '新平彝族傣族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3324, 302, '元江哈尼族彝族傣族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3325, 303, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3326, 303, '隆阳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3327, 303, '施甸县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3328, 303, '龙陵县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3329, 303, '昌宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3330, 303, '腾冲市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3331, 304, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3332, 304, '昭阳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3333, 304, '鲁甸县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3334, 304, '巧家县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3335, 304, '盐津县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3336, 304, '大关县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3337, 304, '永善县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3338, 304, '绥江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3339, 304, '镇雄县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3340, 304, '彝良县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3341, 304, '威信县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3342, 304, '水富市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3343, 305, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3344, 305, '古城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3345, 305, '玉龙纳西族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3346, 305, '永胜县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3347, 305, '华坪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3348, 305, '宁蒗彝族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3349, 306, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3350, 306, '思茅区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3351, 306, '宁洱哈尼族彝族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3352, 306, '墨江哈尼族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3353, 306, '景东彝族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3354, 306, '景谷傣族彝族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3355, 306, '镇沅彝族哈尼族拉祜族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3356, 306, '江城哈尼族彝族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3357, 306, '孟连傣族拉祜族佤族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3358, 306, '澜沧拉祜族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3359, 306, '西盟佤族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3360, 307, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3361, 307, '临翔区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3362, 307, '凤庆县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3363, 307, '云县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3364, 307, '永德县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3365, 307, '镇康县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3366, 307, '双江拉祜族佤族布朗族傣族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3367, 307, '耿马傣族佤族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3368, 307, '沧源佤族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3369, 308, '楚雄市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3370, 308, '双柏县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3371, 308, '牟定县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3372, 308, '南华县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3373, 308, '姚安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3374, 308, '大姚县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3375, 308, '永仁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3376, 308, '元谋县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3377, 308, '武定县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3378, 308, '禄丰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3379, 309, '个旧市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3380, 309, '开远市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3381, 309, '蒙自市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3382, 309, '弥勒市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3383, 309, '屏边苗族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3384, 309, '建水县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3385, 309, '石屏县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3386, 309, '泸西县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3387, 309, '元阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3388, 309, '红河县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3389, 309, '金平苗族瑶族傣族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3390, 309, '绿春县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3391, 309, '河口瑶族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3392, 310, '文山市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3393, 310, '砚山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3394, 310, '西畴县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3395, 310, '麻栗坡县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3396, 310, '马关县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3397, 310, '丘北县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3398, 310, '广南县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3399, 310, '富宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3400, 311, '景洪市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3401, 311, '勐海县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3402, 311, '勐腊县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3403, 312, '大理市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3404, 312, '漾濞彝族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3405, 312, '祥云县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3406, 312, '宾川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3407, 312, '弥渡县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3408, 312, '南涧彝族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3409, 312, '巍山彝族回族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3410, 312, '永平县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3411, 312, '云龙县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3412, 312, '洱源县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3413, 312, '剑川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3414, 312, '鹤庆县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3415, 313, '瑞丽市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3416, 313, '芒市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3417, 313, '梁河县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3418, 313, '盈江县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3419, 313, '陇川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3420, 314, '泸水市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3421, 314, '福贡县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3422, 314, '贡山独龙族怒族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3423, 314, '兰坪白族普米族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3424, 315, '香格里拉市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3425, 315, '德钦县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3426, 315, '维西傈僳族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3427, 316, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3428, 316, '城关区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3429, 316, '堆龙德庆区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3430, 316, '达孜区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3431, 316, '林周县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3432, 316, '当雄县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3433, 316, '尼木县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3434, 316, '曲水县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3435, 316, '墨竹工卡县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3436, 316, '格尔木藏青工业园区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3437, 316, '拉萨经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3438, 316, '西藏文化旅游创意园区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3439, 316, '达孜工业园区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3440, 317, '桑珠孜区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3441, 317, '南木林县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3442, 317, '江孜县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3443, 317, '定日县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3444, 317, '萨迦县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3445, 317, '拉孜县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3446, 317, '昂仁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3447, 317, '谢通门县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3448, 317, '白朗县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3449, 317, '仁布县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3450, 317, '康马县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3451, 317, '定结县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3452, 317, '仲巴县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3453, 317, '亚东县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3454, 317, '吉隆县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3455, 317, '聂拉木县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3456, 317, '萨嘎县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3457, 317, '岗巴县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3458, 318, '卡若区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3459, 318, '江达县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3460, 318, '贡觉县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3461, 318, '类乌齐县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3462, 318, '丁青县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3463, 318, '察雅县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3464, 318, '八宿县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3465, 318, '左贡县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3466, 318, '芒康县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3467, 318, '洛隆县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3468, 318, '边坝县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3469, 319, '巴宜区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3470, 319, '工布江达县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3471, 319, '米林县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3472, 319, '墨脱县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3473, 319, '波密县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3474, 319, '察隅县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3475, 319, '朗县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3476, 320, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3477, 320, '乃东区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3478, 320, '扎囊县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3479, 320, '贡嘎县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3480, 320, '桑日县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3481, 320, '琼结县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3482, 320, '曲松县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3483, 320, '措美县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3484, 320, '洛扎县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3485, 320, '加查县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3486, 320, '隆子县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3487, 320, '错那县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3488, 320, '浪卡子县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3489, 321, '色尼区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3490, 321, '嘉黎县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3491, 321, '比如县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3492, 321, '聂荣县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3493, 321, '安多县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3494, 321, '申扎县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3495, 321, '索县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3496, 321, '班戈县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3497, 321, '巴青县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3498, 321, '尼玛县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3499, 321, '双湖县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3500, 322, '普兰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3501, 322, '札达县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3502, 322, '噶尔县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3503, 322, '日土县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3504, 322, '革吉县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3505, 322, '改则县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3506, 322, '措勤县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3507, 323, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3508, 323, '新城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3509, 323, '碑林区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3510, 323, '莲湖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3511, 323, '灞桥区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3512, 323, '未央区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3513, 323, '雁塔区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3514, 323, '阎良区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3515, 323, '临潼区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3516, 323, '长安区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3517, 323, '高陵区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3518, 323, '鄠邑区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3519, 323, '蓝田县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3520, 323, '周至县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3521, 324, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3522, 324, '王益区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3523, 324, '印台区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3524, 324, '耀州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3525, 324, '宜君县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3526, 325, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3527, 325, '渭滨区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3528, 325, '金台区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3529, 325, '陈仓区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3530, 325, '凤翔县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3531, 325, '岐山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3532, 325, '扶风县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3533, 325, '眉县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3534, 325, '陇县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3535, 325, '千阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3536, 325, '麟游县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3537, 325, '凤县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3538, 325, '太白县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3539, 326, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3540, 326, '秦都区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3541, 326, '杨陵区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3542, 326, '渭城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3543, 326, '三原县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3544, 326, '泾阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3545, 326, '乾县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3546, 326, '礼泉县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3547, 326, '永寿县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3548, 326, '长武县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3549, 326, '旬邑县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3550, 326, '淳化县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3551, 326, '武功县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3552, 326, '兴平市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3553, 326, '彬州市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3554, 327, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3555, 327, '临渭区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3556, 327, '华州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3557, 327, '潼关县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3558, 327, '大荔县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3559, 327, '合阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3560, 327, '澄城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3561, 327, '蒲城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3562, 327, '白水县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3563, 327, '富平县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3564, 327, '韩城市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3565, 327, '华阴市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3566, 328, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3567, 328, '宝塔区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3568, 328, '安塞区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3569, 328, '延长县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3570, 328, '延川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3571, 328, '子长县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3572, 328, '志丹县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3573, 328, '吴起县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3574, 328, '甘泉县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3575, 328, '富县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3576, 328, '洛川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3577, 328, '宜川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3578, 328, '黄龙县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3579, 328, '黄陵县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3580, 329, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3581, 329, '汉台区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3582, 329, '南郑区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3583, 329, '城固县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3584, 329, '洋县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3585, 329, '西乡县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3586, 329, '勉县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3587, 329, '宁强县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3588, 329, '略阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3589, 329, '镇巴县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3590, 329, '留坝县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3591, 329, '佛坪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3592, 330, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3593, 330, '榆阳区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3594, 330, '横山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3595, 330, '府谷县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3596, 330, '靖边县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3597, 330, '定边县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3598, 330, '绥德县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3599, 330, '米脂县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3600, 330, '佳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3601, 330, '吴堡县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3602, 330, '清涧县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3603, 330, '子洲县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3604, 330, '神木市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3605, 331, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3606, 331, '汉滨区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3607, 331, '汉阴县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3608, 331, '石泉县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3609, 331, '宁陕县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3610, 331, '紫阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3611, 331, '岚皋县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3612, 331, '平利县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3613, 331, '镇坪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3614, 331, '旬阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3615, 331, '白河县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3616, 332, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3617, 332, '商州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3618, 332, '洛南县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3619, 332, '丹凤县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3620, 332, '商南县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3621, 332, '山阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3622, 332, '镇安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3623, 332, '柞水县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3624, 333, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3625, 333, '城关区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3626, 333, '七里河区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3627, 333, '西固区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3628, 333, '安宁区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3629, 333, '红古区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3630, 333, '永登县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3631, 333, '皋兰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3632, 333, '榆中县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3633, 333, '兰州新区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3634, 334, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3635, 335, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3636, 335, '金川区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3637, 335, '永昌县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3638, 336, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3639, 336, '白银区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3640, 336, '平川区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3641, 336, '靖远县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3642, 336, '会宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3643, 336, '景泰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3644, 337, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3645, 337, '秦州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3646, 337, '麦积区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3647, 337, '清水县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3648, 337, '秦安县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3649, 337, '甘谷县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3650, 337, '武山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3651, 337, '张家川回族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3652, 338, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3653, 338, '凉州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3654, 338, '民勤县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3655, 338, '古浪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3656, 338, '天祝藏族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3657, 339, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3658, 339, '甘州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3659, 339, '肃南裕固族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3660, 339, '民乐县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3661, 339, '临泽县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3662, 339, '高台县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3663, 339, '山丹县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3664, 340, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3665, 340, '崆峒区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3666, 340, '泾川县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3667, 340, '灵台县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3668, 340, '崇信县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3669, 340, '庄浪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3670, 340, '静宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3671, 340, '华亭市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3672, 341, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3673, 341, '肃州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3674, 341, '金塔县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3675, 341, '瓜州县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3676, 341, '肃北蒙古族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3677, 341, '阿克塞哈萨克族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3678, 341, '玉门市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3679, 341, '敦煌市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3680, 342, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3681, 342, '西峰区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3682, 342, '庆城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3683, 342, '环县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3684, 342, '华池县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3685, 342, '合水县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3686, 342, '正宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3687, 342, '宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3688, 342, '镇原县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3689, 343, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3690, 343, '安定区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3691, 343, '通渭县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3692, 343, '陇西县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3693, 343, '渭源县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3694, 343, '临洮县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3695, 343, '漳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3696, 343, '岷县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3697, 344, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3698, 344, '武都区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3699, 344, '成县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3700, 344, '文县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3701, 344, '宕昌县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3702, 344, '康县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3703, 344, '西和县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3704, 344, '礼县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3705, 344, '徽县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3706, 344, '两当县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3707, 345, '临夏市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3708, 345, '临夏县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3709, 345, '康乐县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3710, 345, '永靖县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3711, 345, '广河县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3712, 345, '和政县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3713, 345, '东乡族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3714, 345, '积石山保安族东乡族撒拉族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3715, 346, '合作市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3716, 346, '临潭县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3717, 346, '卓尼县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3718, 346, '舟曲县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3719, 346, '迭部县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3720, 346, '玛曲县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3721, 346, '碌曲县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3722, 346, '夏河县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3723, 347, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3724, 347, '城东区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3725, 347, '城中区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3726, 347, '城西区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3727, 347, '城北区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3728, 347, '大通回族土族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3729, 347, '湟中县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3730, 347, '湟源县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3731, 348, '乐都区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3732, 348, '平安区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3733, 348, '民和回族土族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3734, 348, '互助土族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3735, 348, '化隆回族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3736, 348, '循化撒拉族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3737, 349, '门源回族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3738, 349, '祁连县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3739, 349, '海晏县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3740, 349, '刚察县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3741, 350, '同仁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3742, 350, '尖扎县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3743, 350, '泽库县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3744, 350, '河南蒙古族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3745, 351, '共和县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3746, 351, '同德县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3747, 351, '贵德县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3748, 351, '兴海县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3749, 351, '贵南县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3750, 352, '玛沁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3751, 352, '班玛县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3752, 352, '甘德县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3753, 352, '达日县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3754, 352, '久治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3755, 352, '玛多县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3756, 353, '玉树市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3757, 353, '杂多县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3758, 353, '称多县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3759, 353, '治多县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3760, 353, '囊谦县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3761, 353, '曲麻莱县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3762, 354, '格尔木市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3763, 354, '德令哈市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3764, 354, '茫崖市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3765, 354, '乌兰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3766, 354, '都兰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3767, 354, '天峻县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3768, 354, '大柴旦行政委员会', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3769, 355, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3770, 355, '兴庆区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3771, 355, '西夏区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3772, 355, '金凤区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3773, 355, '永宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3774, 355, '贺兰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3775, 355, '灵武市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3776, 356, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3777, 356, '大武口区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3778, 356, '惠农区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3779, 356, '平罗县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3780, 357, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3781, 357, '利通区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3782, 357, '红寺堡区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3783, 357, '盐池县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3784, 357, '同心县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3785, 357, '青铜峡市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3786, 358, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3787, 358, '原州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3788, 358, '西吉县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3789, 358, '隆德县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3790, 358, '泾源县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3791, 358, '彭阳县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3792, 359, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3793, 359, '沙坡头区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3794, 359, '中宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3795, 359, '海原县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3796, 360, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3797, 360, '天山区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3798, 360, '沙依巴克区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3799, 360, '新市区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3800, 360, '水磨沟区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3801, 360, '头屯河区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3802, 360, '达坂城区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3803, 360, '米东区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3804, 360, '乌鲁木齐县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3805, 360, '乌鲁木齐经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3806, 360, '乌鲁木齐高新技术产业开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3807, 361, '市辖区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3808, 361, '独山子区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3809, 361, '克拉玛依区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3810, 361, '白碱滩区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3811, 361, '乌尔禾区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3812, 362, '高昌区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3813, 362, '鄯善县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3814, 362, '托克逊县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3815, 363, '伊州区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3816, 363, '巴里坤哈萨克自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3817, 363, '伊吾县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3818, 364, '昌吉市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3819, 364, '阜康市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3820, 364, '呼图壁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3821, 364, '玛纳斯县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3822, 364, '奇台县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3823, 364, '吉木萨尔县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3824, 364, '木垒哈萨克自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3825, 365, '博乐市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3826, 365, '阿拉山口市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3827, 365, '精河县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3828, 365, '温泉县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3829, 366, '库尔勒市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3830, 366, '轮台县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3831, 366, '尉犁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3832, 366, '若羌县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3833, 366, '且末县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3834, 366, '焉耆回族自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3835, 366, '和静县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3836, 366, '和硕县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3837, 366, '博湖县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3838, 366, '库尔勒经济技术开发区', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3839, 367, '阿克苏市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3840, 367, '温宿县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3841, 367, '库车县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3842, 367, '沙雅县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3843, 367, '新和县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3844, 367, '拜城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3845, 367, '乌什县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3846, 367, '阿瓦提县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3847, 367, '柯坪县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3848, 368, '阿图什市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3849, 368, '阿克陶县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3850, 368, '阿合奇县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3851, 368, '乌恰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3852, 369, '喀什市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3853, 369, '疏附县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3854, 369, '疏勒县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3855, 369, '英吉沙县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3856, 369, '泽普县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3857, 369, '莎车县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3858, 369, '叶城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3859, 369, '麦盖提县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3860, 369, '岳普湖县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3861, 369, '伽师县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3862, 369, '巴楚县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3863, 369, '塔什库尔干塔吉克自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3864, 370, '和田市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3865, 370, '和田县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3866, 370, '墨玉县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3867, 370, '皮山县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3868, 370, '洛浦县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3869, 370, '策勒县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3870, 370, '于田县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3871, 370, '民丰县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3872, 371, '伊宁市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3873, 371, '奎屯市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3874, 371, '霍尔果斯市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3875, 371, '伊宁县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3876, 371, '察布查尔锡伯自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3877, 371, '霍城县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3878, 371, '巩留县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3879, 371, '新源县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3880, 371, '昭苏县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3881, 371, '特克斯县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3882, 371, '尼勒克县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3883, 372, '塔城市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3884, 372, '乌苏市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3885, 372, '额敏县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3886, 372, '沙湾县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3887, 372, '托里县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3888, 372, '裕民县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3889, 372, '和布克赛尔蒙古自治县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3890, 373, '阿勒泰市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3891, 373, '布尔津县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3892, 373, '富蕴县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3893, 373, '福海县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3894, 373, '哈巴河县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3895, 373, '青河县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3896, 373, '吉木乃县', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3897, 374, '石河子市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3898, 374, '阿拉尔市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3899, 374, '图木舒克市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3900, 374, '五家渠市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (3901, 374, '铁门关市', NULL, 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4638, 0, '台湾省', 't', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (4639, 0, '香港特别行政区', 'x', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (4640, 0, '澳门特别行政区', 'a', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (4641, 4639, '香港特别行政区', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4642, 4640, '澳门特别行政区', 'a', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4643, 4638, '台北市', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4644, 4638, '高雄市', 'g', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4645, 4638, '台南市', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4646, 4638, '台中市', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4647, 4638, '南投县', 'n', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4648, 4638, '基隆市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4649, 4638, '新竹市', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4650, 4638, '嘉义市', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4651, 4638, '新北市', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4652, 4638, '宜兰县', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4653, 4638, '新竹县', 'x', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4654, 4638, '桃园市', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4655, 4638, '苗栗县', 'm', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4656, 4638, '彰化县', 'z', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4657, 4638, '嘉义县', 'j', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4658, 4638, '云林县', 'y', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4659, 4638, '屏东县', 'p', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4660, 4638, '台东县', 't', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4661, 4638, '花莲县', 'h', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4662, 4638, '澎湖县', 'p', 0, '', 2, 1, 99);
INSERT INTO `xy_area` VALUES (4663, 4643, '中正区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4664, 4643, '大同区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4665, 4643, '中山区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4666, 4643, '中山区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4667, 4643, '松山区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4668, 4643, '大安区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4669, 4643, '万华区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4670, 4643, '信义区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4671, 4643, '士林区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4672, 4643, '北投区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4673, 4643, '内湖区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4674, 4643, '南岗区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4675, 4643, '文山区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4676, 4644, '新兴区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4677, 4644, '前金区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4678, 4644, '苓雅区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4679, 4644, '盐埕区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4680, 4644, '鼓山区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4681, 4644, '骑津区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4682, 4644, '前镇区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4683, 4644, '三民区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4684, 4644, '左营区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4685, 4644, '楠梓区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4686, 4644, '小港区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4687, 4644, '仁武区', 'r', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4688, 4644, '大社区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4689, 4644, '冈山区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4690, 4644, '路竹区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4691, 4644, '阿莲区', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4692, 4644, '田寮区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4693, 4644, '燕巢区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4694, 4644, '桥头区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4695, 4644, '梓官区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4696, 4644, '弥陀区', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4697, 4644, '永安区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4698, 4644, '湖内区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4699, 4644, '凤山区', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4700, 4644, '大寮区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4701, 4644, '林园区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4702, 4644, '鸟松区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4703, 4644, '大树区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4704, 4644, '旗山区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4705, 4644, '美浓区', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4706, 4644, '六龟区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4707, 4644, '内门区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4708, 4644, '杉林区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4709, 4644, '甲仙区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4710, 4644, '桃源区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4711, 4644, '那玛夏区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4712, 4644, '茂林区', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4713, 4644, '茄萣区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4714, 4645, '中西区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4715, 4645, '东区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4716, 4645, '南区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4717, 4645, '北区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4718, 4645, '安平区', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4719, 4645, '安南区', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4720, 4645, '永康区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4721, 4645, '归仁区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4722, 4645, '新化区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4723, 4645, '左镇区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4724, 4645, '玉井区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4725, 4645, '楠西区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4726, 4645, '南化区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4727, 4645, '仁德区', 'r', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4728, 4645, '关庙区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4729, 4645, '龙崎区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4730, 4645, '官田区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4731, 4645, '麻豆区', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4732, 4645, '佳里区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4733, 4645, '西港区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4734, 4645, '七股区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4735, 4645, '将军区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4736, 4645, '学甲区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4737, 4645, '北门区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4738, 4645, '新营区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4739, 4645, '后壁区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4740, 4645, '白河区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4741, 4645, '东山区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4742, 4645, '六甲区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4743, 4645, '下营区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4744, 4645, '柳营区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4745, 4645, '盐水区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4746, 4645, '善化区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4747, 4645, '大内区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4748, 4645, '山上区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4749, 4645, '新市区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4750, 4645, '安定区', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4751, 4646, '中区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4752, 4646, '东区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4753, 4646, '南区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4754, 4646, '西区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4755, 4646, '北区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4756, 4646, '北屯区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4757, 4646, '西屯区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4758, 4646, '南屯区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4759, 4646, '太平区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4760, 4646, '大里区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4761, 4646, '雾峰区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4762, 4646, '乌日区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4763, 4646, '丰原区', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4764, 4646, '后里区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4765, 4646, '石冈区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4766, 4646, '东势区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4767, 4646, '和平区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4769, 4646, '新社区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4770, 4646, '潭子区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4771, 4646, '大雅区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4772, 4646, '神冈区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4773, 4646, '大肚区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4774, 4646, '沙鹿区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4775, 4646, '龙井区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4776, 4646, '梧栖区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4777, 4646, '清水区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4778, 4646, '大甲区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4779, 4646, '外埔区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4780, 4646, '大安区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4781, 4647, '南投市', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4782, 4647, '中寮乡', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4783, 4647, '草屯镇', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4784, 4647, '国姓乡', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4785, 4647, '铺里镇', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4786, 4647, '仁爱乡', 'r', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4787, 4647, '名间乡', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4788, 4647, '集集镇', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4789, 4647, '水里乡', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4790, 4647, '鱼池乡', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4791, 4647, '信义乡', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4792, 4647, '竹山镇', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4793, 4647, '鹿谷乡', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4794, 4648, '仁爱区', 'r', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4795, 4648, '信义区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4796, 4648, '中正区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4797, 4648, '中山区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4798, 4648, '安乐区', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4799, 4648, '暖暖区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4800, 4648, '七堵区', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4801, 4649, '东区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4802, 4649, '北区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4803, 4649, '香山区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4804, 4650, '东区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4805, 4650, '西区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4806, 4651, '万里区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4807, 4651, '金山区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4808, 4651, '板桥区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4809, 4651, '汐止区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4810, 4651, '深坑区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4811, 4651, '石碇区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4812, 4651, '瑞芳区', 'r', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4813, 4651, '平溪区', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4814, 4651, '双溪区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4815, 4651, '贡寮区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4816, 4651, '新店区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4817, 4651, '坪林区', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4818, 4651, '乌来区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4819, 4651, '永和区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4820, 4651, '中和区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4821, 4651, '土城区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4822, 4651, '三峡区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4823, 4651, '树林区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4824, 4651, '莺歌区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4825, 4651, '三重区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4826, 4651, '新庄区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4827, 4651, '泰山区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4828, 4651, '林口区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4829, 4651, '芦洲区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4830, 4651, '五股区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4831, 4651, '八里区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4832, 4651, '淡水区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4833, 4649, '三芝区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4834, 4652, '宜兰市', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4835, 4651, '石门区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4836, 4652, '头城镇', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4837, 4652, '礁溪乡', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4838, 4652, '壮围乡', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4839, 4652, '员山乡', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4840, 4652, '罗东镇', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4841, 4652, '三星乡', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4842, 4652, '大同乡', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4843, 4652, '五结乡', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4844, 4652, '冬山乡', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4845, 4652, '苏澳镇', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4846, 4652, '南澳乡', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4847, 4653, '竹北市', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4848, 4653, '湖口乡', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4849, 4653, '新丰乡', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4850, 4653, '新埔镇', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4851, 4653, '关西镇', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4852, 4653, '芎林乡', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4853, 4653, '宝山乡', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4854, 4653, '竹东镇', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4855, 4653, '五峰乡', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4856, 4653, '横山乡', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4857, 4653, '尖石乡', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4858, 4653, '北埔乡', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4859, 4653, '峨眉乡', 'e', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4860, 4654, '中坜区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4861, 4654, '平镇区', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4862, 4654, '龙潭区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4863, 4654, '杨梅区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4864, 4654, '新屋区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4865, 4654, '观音区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4866, 4654, '桃园区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4867, 4654, '龟山区', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4868, 4654, '八德区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4869, 4654, '大溪区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4870, 4654, '复兴区', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4871, 4654, '大园区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4872, 4654, '芦竹区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4873, 4655, '竹南镇', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4874, 4655, '头份市', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4875, 4655, '三湾乡', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4876, 4655, '南庄乡', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4877, 4655, '狮潭乡', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4878, 4655, '后龙镇', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4879, 4655, '通宵镇', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4880, 4655, '苑里镇', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4881, 4655, '苗栗市', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4882, 4655, '造桥乡', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4883, 4655, '头屋乡', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4884, 4655, '公馆乡', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4885, 4655, '大湖乡', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4886, 4655, '泰安乡', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4887, 4655, '铜锣乡', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4888, 4655, '三义乡', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4889, 4655, '西湖乡', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4890, 4655, '卓兰镇', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4891, 4656, '彰化市', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4892, 4656, '芬园乡', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4893, 4656, '花坛乡', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4894, 4656, '秀水乡', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4895, 4656, '鹿港镇', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4896, 4656, '福兴乡', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4897, 4656, '线西乡', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4898, 4656, '和美镇', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4899, 4656, '伸港乡', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4900, 4656, '员林市', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4901, 4656, '社头乡', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4902, 4656, '永靖乡', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4903, 4656, '埔心乡', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4904, 4656, '溪湖镇', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4905, 4656, '大村乡', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4906, 4656, '埔盐乡', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4907, 4656, '田中镇', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4908, 4656, '北斗镇', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4909, 4656, '田尾乡', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4910, 4656, '埤头乡', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4911, 4656, '溪州乡', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4912, 4656, '竹塘乡', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4913, 4656, '二林镇', 'e', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4914, 4656, '大城乡', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4915, 4656, '芳苑乡', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4916, 4656, '二水乡', 'e', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4917, 4657, '番路乡', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4918, 4657, '梅山乡', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4919, 4657, '竹崎乡', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4920, 4657, '阿里山乡', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4921, 4657, '中埔乡', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4922, 4657, '大埔乡', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4923, 4657, '水上乡', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4924, 4657, '鹿草乡', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4925, 4657, '太保市', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4926, 4657, '朴子市', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4927, 4657, '东石乡', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4928, 4657, '六脚乡', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4929, 4657, '新港乡', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4930, 4657, '民雄乡', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4931, 4657, '大林镇', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4932, 4657, '溪口乡', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4933, 4657, '义竹乡', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4934, 4657, '布袋镇', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4935, 4658, '斗南镇', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4936, 4658, '大埤乡', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4937, 4658, '虎尾镇', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4938, 4658, '土库镇', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4939, 4658, '褒忠乡', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4940, 4658, '东势乡', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4941, 4658, '台西乡', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4942, 4658, '仑背乡', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4943, 4658, '麦寮乡', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4944, 4658, '斗六市', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4945, 4658, '林内乡', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4946, 4658, '古坑乡', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4947, 4658, '莿桐乡', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4948, 4658, '西螺镇', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4949, 4658, '二仑乡', 'e', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4950, 4658, '北港镇', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4951, 4658, '水林乡', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4952, 4658, '口湖乡', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4953, 4658, '四湖乡', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4954, 4658, '元长乡', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4955, 4641, '中西区', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4956, 4641, '东区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4957, 4641, '九龙城区', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4958, 4641, '观塘区', 'g', 0, '', 1, 1, 99);
INSERT INTO `xy_area` VALUES (4959, 4641, '南区', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4960, 4659, '屏东市', 'p', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4961, 4659, '三地门乡', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4962, 4659, '雾台乡', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4963, 4659, '玛家乡', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4964, 4659, '九如乡', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4965, 4642, '澳门半岛', 'a', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4966, 4659, '里港乡', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4967, 4641, '深水埗区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4968, 4659, '高树乡', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4969, 4659, '盐埔乡', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4970, 4641, '湾仔区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4971, 4659, '长治乡', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4972, 4659, '麟洛乡', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4973, 4641, '黄大仙区', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4974, 4659, '竹田乡', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4975, 4641, '油尖旺区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4976, 4659, '内埔乡', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4977, 4659, '万丹乡', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4978, 4659, '潮州镇', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4979, 4641, '离岛区', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4980, 4659, '泰武乡', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4981, 4659, '来义乡', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4982, 4641, '葵青区', 'k', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4983, 4659, '万峦乡', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4984, 4641, '北区', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4985, 4659, '莰顶乡', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4986, 4641, '西贡区', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4987, 4659, '新埤乡', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4988, 4641, '沙田区', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4989, 4641, '屯门区', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4990, 4659, '南州乡', 'n', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4991, 4659, '林边乡', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4992, 4659, '琉球乡', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4993, 4641, '大埔区', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4994, 4659, '佳冬乡', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4995, 4641, '荃湾区', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4996, 4659, '新园乡', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4997, 4659, '枋寮乡', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4998, 4641, '元朗区', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (4999, 4659, '枋山乡', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5000, 4659, '春日乡', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5001, 4659, '狮子乡', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5002, 4659, '车城乡', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5003, 4659, '牡丹乡', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5004, 4659, '恒春镇', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5005, 4659, '满州乡', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5006, 4659, '东港镇', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5007, 4660, '台东市', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5008, 4660, '绿岛乡', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5009, 4660, '兰屿乡', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5010, 4660, '延平乡', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5011, 4660, '卑南乡', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5012, 4660, '鹿野乡', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5013, 4660, '关山镇', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5014, 4660, '海端乡', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5015, 4660, '池上乡', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5016, 4660, '东河乡', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5017, 4660, '成功镇', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5018, 4660, '长滨乡', 'c', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5019, 4660, '金峰乡', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5020, 4660, '大武乡', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5021, 4660, '达仁乡', 'd', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5022, 4660, '太麻里乡', 't', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5023, 4661, '花莲市', 'h', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5024, 4642, '凼仔', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5025, 4661, '新城乡', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5026, 4661, '秀林乡', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5027, 4642, '路凼城', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5028, 4661, '吉安乡', 'j', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5029, 4661, '寿丰乡', 's', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5030, 4661, '凤林镇', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5031, 4661, '光复乡', 'g', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5032, 4661, '丰滨乡', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5033, 4642, '路环', 'l', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5034, 4661, '瑞穗乡', 'r', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5035, 4661, '万荣乡', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5036, 4661, '玉里镇', 'y', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5037, 4661, '卓溪乡', 'z', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5038, 4661, '富里乡', 'f', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5039, 4662, '马公市', 'm', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5040, 4662, '西屿乡', 'x', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5041, 4662, '望安乡', 'w', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5042, 4662, '七美乡', 'q', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5043, 4662, '白沙乡', 'b', 0, '', 3, 1, 99);
INSERT INTO `xy_area` VALUES (5044, 4662, '湖西乡', 'h', 0, '', 3, 1, 99);
