
-- ----------------------------
-- Table structure for xy_app_version
-- ----------------------------
DROP TABLE IF EXISTS `xy_app_version`;
CREATE TABLE `xy_app_version`  (
  `id` int(0) UNSIGNED NOT NULL AUTO_INCREMENT,
  `version_code` int(0) NULL DEFAULT NULL,
  `version_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `ios_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(1) NULL DEFAULT 1,
  `force` tinyint(1) NULL DEFAULT 0,
  `wgt` tinyint(1) NULL DEFAULT 0,
  `is_android` tinyint(1) NULL DEFAULT 0,
  `is_ios` tinyint(1) NULL DEFAULT 0,
  `create_time` int(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `version`(`version_code`) USING BTREE,
  INDEX `android`(`version_code`, `is_android`) USING BTREE,
  INDEX `ios`(`version_code`, `is_ios`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '客户端-版本' ROW_FORMAT = Dynamic;
