
-- ----------------------------
-- Table structure for xy_api_route
-- ----------------------------
DROP TABLE IF EXISTS `xy_api_route`;
CREATE TABLE `xy_api_route`  (
  `api_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `app_id` int(10) NULL DEFAULT NULL COMMENT 'Appid',
  `api_method` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口请求方式',
  `api_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口名称',
  `api_controller` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '控制器',
  `api_action` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作',
  `api_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'Url',
  `api_param` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数',
  `api_status` tinyint(1) NULL DEFAULT 1 COMMENT '状态',
  `api_status_msg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '禁用消息',
  `api_ext` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `api_allow` tinyint(1) NULL DEFAULT 0,
  `api_is_login` tinyint(1) NULL DEFAULT 0,
  `api_is_web_name` tinyint(1) NULL DEFAULT 1,
  `seo_keywords` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `seo_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `seo_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `is_copy` tinyint(1) NULL DEFAULT 0,
  `update_time` int(11) NULL DEFAULT NULL,
  `create_time` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`api_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 825 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'api接口' ROW_FORMAT = Compact;

-- ----------------------------
-- Records of xy_api_route
-- ----------------------------
INSERT INTO `xy_api_route` VALUES (1, 1, 'rule', '首页', 'Index', 'index', '/', '', 1, '', '', 0, 0, 0, '', 'XYCMS演示站', '', 0, 1623231929, 1588837406);
INSERT INTO `xy_api_route` VALUES (2, 1, 'rule', '登录', 'Login', 'index', 'login', '', 1, '', '', 0, 0, 1, '', NULL, NULL, 0, 1623036824, 1588839859);
INSERT INTO `xy_api_route` VALUES (3, 1, 'rule', '注册', 'Login', 'register', 'register', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1623057203, 1588994815);
INSERT INTO `xy_api_route` VALUES (4, 1, 'rule', '注销登录', 'Base', 'outLogin', 'outLogin', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1589008899, 1589008899);
INSERT INTO `xy_api_route` VALUES (5, 1, 'post', '获取验证码', 'Login', 'getVcode', 'getVcode', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1589012061, 1589012061);
INSERT INTO `xy_api_route` VALUES (6, 1, 'rule', '验证码登录', 'Login', 'vcode', 'login/vcode', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1589017300, 1589017300);
INSERT INTO `xy_api_route` VALUES (7, 1, 'post', '验证短信验证码', 'Login', 'verificationVcode', 'verificationVcode', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1589276795, 1589276795);
INSERT INTO `xy_api_route` VALUES (8, 1, 'rule', '个人中心', 'User', 'index', 'user', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1589352937, 1589337364);
INSERT INTO `xy_api_route` VALUES (9, 1, 'rule', '系统维护', 'Index', 'maintenance', 'system/maintenance', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1589352437, 1589352437);
INSERT INTO `xy_api_route` VALUES (10, 1, 'rule', '账户管理', 'User', 'account', 'user/account', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1589426186, 1589426186);
INSERT INTO `xy_api_route` VALUES (11, 1, 'rule', '企业风采', 'User', 'demeanor', 'user/company/demeanor', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1589440427, 1589440427);
INSERT INTO `xy_api_route` VALUES (12, 1, 'rule', '用户认证', 'User', 'attestation', 'user/attestation', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1615015629, 1589444629);
INSERT INTO `xy_api_route` VALUES (13, 1, 'rule', '账户安全', 'User', 'security', 'user/security', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1589532257, 1589447106);
INSERT INTO `xy_api_route` VALUES (14, 1, 'get', '获取登录日志', 'Log', 'getLoginLog', 'user/getLoginLog', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1589530775, 1589530775);
INSERT INTO `xy_api_route` VALUES (15, 1, 'rule', '我的消息', 'Message', 'myMessage', 'user/myMessage', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1589533340, 1589533340);
INSERT INTO `xy_api_route` VALUES (16, 1, 'rule', '发布职位', 'Jobs', 'release', 'user/jobs/release', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1589854933, 1589854933);
INSERT INTO `xy_api_route` VALUES (17, 1, 'rule', '找工作', 'Search', 'jobHunting', 'jobs', '', 1, '', '', 0, 0, 1, '', '', '', 0, 1623055707, 1590026205);
INSERT INTO `xy_api_route` VALUES (18, 1, 'rule', '招人才', 'Search', 'recruitTalents', 'resume', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1610447386, 1590050739);
INSERT INTO `xy_api_route` VALUES (19, 1, 'rule', '找公司', 'Search', 'seekCompany', 'company', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1610447389, 1590051372);
INSERT INTO `xy_api_route` VALUES (20, 1, 'get', '资讯', 'Article', 'getAlias', 'article/type', '/[:alias]', 1, '', 'html', 0, 0, 1, NULL, NULL, NULL, 0, 1614838941, 1590052282);
INSERT INTO `xy_api_route` VALUES (21, 1, 'rule', '我们的服务', 'Search', 'moreServer', 'more-server', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1590052426, 1590052426);
INSERT INTO `xy_api_route` VALUES (22, 1, 'rule', '求职管理', 'Jobs', 'management', 'user/jobs/management', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1590131651, 1590130656);
INSERT INTO `xy_api_route` VALUES (23, 1, 'rule', '收藏和关注', 'User', 'follow', 'user/follow', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1614159210, 1590130794);
INSERT INTO `xy_api_route` VALUES (24, 1, 'rule', '会员服务', 'Vip', 'server', 'user/vip/server', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1590397296, 1590130983);
INSERT INTO `xy_api_route` VALUES (25, 1, 'rule', '招聘效果统计', 'Jobs', 'recruitEffectCount', 'user/jobs/recruitEffectCount', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1590392564, 1590392564);
INSERT INTO `xy_api_route` VALUES (26, 1, 'rule', '我的打赏', 'Jobs', 'expenditureGratuity', 'user/jobs/expenditureGratuity', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1590397339, 1590397339);
INSERT INTO `xy_api_route` VALUES (27, 1, 'rule', '简历管理', 'Resume', 'management', 'user/resume/management', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1590398507, 1590398507);
INSERT INTO `xy_api_route` VALUES (28, 1, 'rule', '面试邀请', 'Resume', 'interviewInvitation', 'user/resume/interview-invitation', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1590565164, 1590565164);
INSERT INTO `xy_api_route` VALUES (29, 1, 'rule', '视频面试', 'Resume', 'videoInterview', 'user/resume/video-interview', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1590565193, 1590565193);
INSERT INTO `xy_api_route` VALUES (30, 1, 'rule', '已下载的简历', 'Resume', 'resumeDownloaded', 'user/resume/resume-downloaded', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1590565228, 1590565228);
INSERT INTO `xy_api_route` VALUES (31, 1, 'rule', '收藏的简历', 'Resume', 'collectedResume', 'user/resume/collected-resume', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1590565254, 1590565254);
INSERT INTO `xy_api_route` VALUES (32, 1, 'rule', '浏览过的简历', 'Resume', 'reviewedResume', 'user/resume/reviewed-resume', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1590565275, 1590565275);
INSERT INTO `xy_api_route` VALUES (33, 1, 'rule', '谁看过我', 'User', 'whoSawMe', 'user/who-saw-me', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1590565312, 1590565312);
INSERT INTO `xy_api_route` VALUES (34, 1, 'rule', '公司详情', 'Company', 'index', 'company', '/:id', 1, '', 'html', 0, 0, 1, NULL, NULL, NULL, 0, 1590569620, 1590569620);
INSERT INTO `xy_api_route` VALUES (35, 1, 'rule', '职位详情', 'Jobs', 'index', 'jobs', '/:id', 1, '', 'html', 0, 0, 1, NULL, NULL, NULL, 0, 1590648644, 1590648644);
INSERT INTO `xy_api_route` VALUES (36, 1, 'rule', '文章详情', 'Article', 'content', 'article/content', '/:id', 1, '', 'html', 0, 0, 1, NULL, NULL, NULL, 0, 1590733403, 1590733403);
INSERT INTO `xy_api_route` VALUES (37, 1, 'rule', '文章分类列表', 'Article', 'classifyList', 'article/classify', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1590733511, 1590733511);
INSERT INTO `xy_api_route` VALUES (38, 1, 'rule', '查看简历', 'Resume', 'index', 'resume', '/:id', 1, '', 'html', 0, 1, 1, NULL, NULL, NULL, 0, 1618021744, 1590736510);
INSERT INTO `xy_api_route` VALUES (39, 1, 'rule', '保存简历', 'Resume', 'saveResume', 'user/saveResume', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1591257191, 1591257191);
INSERT INTO `xy_api_route` VALUES (40, 1, 'get', '删除简历经历', 'Resume', 'delExperience', 'user/resume/delExperience', '/:type/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1591844017, 1591843980);
INSERT INTO `xy_api_route` VALUES (41, 1, 'rule', '保存企业信息', 'Company', 'saveCompany', 'user/company/saveCompany', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1591944634, 1591944634);
INSERT INTO `xy_api_route` VALUES (42, 1, 'rule', '发布职位', 'Jobs', 'release', 'user/jobs/release', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1591945459, 1591945459);
INSERT INTO `xy_api_route` VALUES (43, 1, 'rule', '编辑职位', 'Jobs', 'saveJobs', 'user/jobs/saveJobs', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1591954729, 1591954389);
INSERT INTO `xy_api_route` VALUES (44, 1, 'get', '投递简历', 'Resume', 'deliveryResume', 'deliveryResume', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1592276947, 1592276761);
INSERT INTO `xy_api_route` VALUES (45, 1, 'get', '搜索工作', 'Search', 'searchJobs', 'search/jobs', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1592298020, 1592297805);
INSERT INTO `xy_api_route` VALUES (46, 1, 'get', '设置投递简历状态-不合适', 'Resume', 'setResumeInappropriate', 'user/resume/setResumeInappropriate', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1592449640, 1592449640);
INSERT INTO `xy_api_route` VALUES (47, 1, 'post', '投递简历-面试邀请', 'Resume', 'inviteAnInterview', 'user/resume/inviteAnInterview', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1592471954, 1592450762);
INSERT INTO `xy_api_route` VALUES (48, 1, 'rule', '接受面试邀请', 'Interview', 'handleInterviewInvitation', 'user/interview/handleInterviewInvitation', '/:status/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1618046389, 1592990637);
INSERT INTO `xy_api_route` VALUES (49, 1, 'get', '切换到企业用户', 'User', 'goToCompany', 'user/goToCompany', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1593333772, 1593333772);
INSERT INTO `xy_api_route` VALUES (50, 1, 'get', '切换到个人用户', 'User', 'goToPersonal', 'user/goToPersonal', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1593333797, 1593333797);
INSERT INTO `xy_api_route` VALUES (51, 1, 'get', '搜索企业', 'Search', 'searchCompany', 'search/company', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1594201252, 1594201238);
INSERT INTO `xy_api_route` VALUES (52, 1, 'get', '搜索简历', 'Search', 'searchResume', 'search/resume', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1594278964, 1594278964);
INSERT INTO `xy_api_route` VALUES (53, 1, 'rule', '职位分类', 'Jobs', 'allJobsCate', 'jobs/all-jobs-cate', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1594284859, 1594284859);
INSERT INTO `xy_api_route` VALUES (54, 1, 'post', '通用上传接口', 'Uploads', 'uploadFiles', 'uploadFiles', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1594366737, 1594366737);
INSERT INTO `xy_api_route` VALUES (55, 1, 'rule', '下载简历', 'Resume', 'downloads', 'downloads/resume', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1617350993, 1594458119);
INSERT INTO `xy_api_route` VALUES (56, 1, 'post', '统一下单', 'Pay', 'generateOrderInfo', 'pay/generateOrderInfo', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1596166788, 1594460478);
INSERT INTO `xy_api_route` VALUES (57, 1, 'get', '删除企业发展历程', 'Company', 'delDevelopmentHistory', 'user/company/delDevelopmentHistory', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1594715628, 1594715628);
INSERT INTO `xy_api_route` VALUES (58, 1, 'post', '保存企业风采', 'Company', 'saveDemeanor', 'user/company/saveDemeanor', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1594720797, 1594720797);
INSERT INTO `xy_api_route` VALUES (59, 1, 'get', '保存企业风采备注', 'Company', 'saveDemeanorTitle', 'user/company/saveDemeanorTitle', '/:id/:title', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1594720838, 1594720838);
INSERT INTO `xy_api_route` VALUES (60, 1, 'get', '删除企业风采', 'Company', 'delCompanyDemeanor', 'user/company/delCompanyDemeanor', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1594720859, 1594720859);
INSERT INTO `xy_api_route` VALUES (61, 1, 'get', '设置职位状态', 'Jobs', 'setJobsStatus', 'user/jobs/setStatus', '/:id/:status', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1595229931, 1595229931);
INSERT INTO `xy_api_route` VALUES (62, 1, 'get', '职位刷新', 'Jobs', 'setJobsRefreshTime', 'user/jobs/setRefreshTime', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1595231446, 1595231446);
INSERT INTO `xy_api_route` VALUES (63, 1, 'get', '删除投递简历', 'Resume', 'delDeliveryResume', 'user/resume/delDeliveryResume', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1595232299, 1595232299);
INSERT INTO `xy_api_route` VALUES (64, 1, 'get', '删除简历下载记录', 'Resume', 'delDownloadResume', 'user/resume/delDownloadResume', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1595233355, 1595233355);
INSERT INTO `xy_api_route` VALUES (65, 1, 'get', '删除收藏的简历', 'Resume', 'delCollectedResume', 'user/resume/delCollectedResume', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1609668296, 1595233880);
INSERT INTO `xy_api_route` VALUES (66, 1, 'get', '删除简历浏览记录', 'Resume', 'delBrowseResume', 'user/resume/delBrowseResume', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1595234292, 1595234292);
INSERT INTO `xy_api_route` VALUES (67, 1, 'get', '获取简历管理统计', 'Resume', 'statistics', 'user/resume/statistics', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1595234844, 1595234844);
INSERT INTO `xy_api_route` VALUES (68, 1, 'get', '用户中心统计', 'User', 'statistics', 'user/statistics', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1595236038, 1595236038);
INSERT INTO `xy_api_route` VALUES (69, 1, 'get', '获取个人中心人才推荐', 'User', 'getRecommendResume', 'user/getRecommendResume', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1595236750, 1595236750);
INSERT INTO `xy_api_route` VALUES (70, 1, 'get', '设置简历头像是否公开', 'Resume', 'setResumeHeadimgStatus', 'user/resume/setResumeHeadimgStatus', '/:status', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1595301993, 1595301816);
INSERT INTO `xy_api_route` VALUES (71, 1, 'get', '设置简历隐私状态', 'Resume', 'setResumePrivacy', 'user/resume/setResumePrivacy', '/:status', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1595301889, 1595301841);
INSERT INTO `xy_api_route` VALUES (72, 1, 'get', '职位关注', 'Jobs', 'toggleJobsCollection', 'jobs/toggleJobsCollection', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1595323091, 1595323091);
INSERT INTO `xy_api_route` VALUES (73, 1, 'get', '企业关注', 'Company', 'toggleCompanyCollection', 'company/toggleCompanyCollection', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1595323681, 1595323121);
INSERT INTO `xy_api_route` VALUES (74, 3, 'rule', '微信支付回调通知', 'Results', 'wxPayNotify', 'pay/wx/notify', '', 1, '', '', 1, 0, 1, NULL, NULL, NULL, 0, 1595411444, 1595411444);
INSERT INTO `xy_api_route` VALUES (75, 3, 'rule', '支付宝支付回调通知', 'Results', 'aliPayNotify', 'pay/ali/notify', '', 1, '', '', 1, 0, 1, NULL, NULL, NULL, 0, 1617163658, 1595411513);
INSERT INTO `xy_api_route` VALUES (76, 1, 'rule', 'QQ登录回调', 'Results', 'qqLoginCallback', 'login/qq/callback', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1595475634, 1595412071);
INSERT INTO `xy_api_route` VALUES (77, 1, 'rule', '微信登录回调', 'Results', 'wxLoginCallback', 'login/wx/callback', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1595475634, 1595412102);
INSERT INTO `xy_api_route` VALUES (78, 1, 'rule', '我的积分', 'Vip', 'myPoints', 'user/vip/my-points', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1595475198, 1595475198);
INSERT INTO `xy_api_route` VALUES (79, 1, 'rule', '我的订单', 'Vip', 'orders', 'user/vip/orders', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1595475233, 1595475233);
INSERT INTO `xy_api_route` VALUES (80, 1, 'rule', '模板切换', 'Vip', 'templateToggle', 'user/vip/template-toggle', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1595475280, 1595475280);
INSERT INTO `xy_api_route` VALUES (81, 1, 'rule', '招聘外包', 'Vip', 'outsource', 'user/vip/outsource', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1595475316, 1595475316);
INSERT INTO `xy_api_route` VALUES (82, 1, 'rule', '优惠券', 'Vip', 'coupon', 'user/vip/coupon', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1595475354, 1595475354);
INSERT INTO `xy_api_route` VALUES (83, 1, 'rule', '招聘会', 'JobFair', 'apply', 'user/job-fair/apply', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1611908739, 1595475392);
INSERT INTO `xy_api_route` VALUES (84, 1, 'rule', '增值服务', 'Vip', 'valueAdded', 'user/vip/value-added', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1595496197, 1595496197);
INSERT INTO `xy_api_route` VALUES (85, 1, 'rule', '定展记录', 'JobFair', 'record', 'user/job-fair/record', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1595575063, 1595575063);
INSERT INTO `xy_api_route` VALUES (86, 1, 'get', '字符串转二维码', 'Uploads', 'displayQrcode', 'displayQrcode', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1610436888, 1596103444);
INSERT INTO `xy_api_route` VALUES (87, 1, 'rule', '第三方登录', 'ThirdPartyLogin', 'thirdParty', 'login', '/[:type]', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1596278242, 1596273548);
INSERT INTO `xy_api_route` VALUES (88, 1, 'rule', 'QQ登录回调', 'ThirdPartyLogin', 'qqCallback', 'third-party/login/qq', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1596278250, 1596275403);
INSERT INTO `xy_api_route` VALUES (89, 1, 'rule', '微信登录回调', 'ThirdPartyLogin', 'wxCallback', 'third-party/login/wx', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1596278254, 1596275423);
INSERT INTO `xy_api_route` VALUES (90, 1, 'get', '加入消息长链接ID组', 'Message', 'joinGroup', 'joinMessageGroup', '/:client_id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1596443633, 1596443633);
INSERT INTO `xy_api_route` VALUES (91, 1, 'post', '通过订单号获取支付信息', 'Pay', 'getOrderInfoByOtrade', 'pay/getOrderInfoByOtrade', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1596701021, 1596701021);
INSERT INTO `xy_api_route` VALUES (92, 1, 'post', '取消订单', 'Pay', 'cancelOrder', 'pay/cancelOrder', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1596701847, 1596701847);
INSERT INTO `xy_api_route` VALUES (93, 1, 'post', '删除订单', 'Pay', 'delOrder', 'pay/delOrder', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1596701863, 1596701863);
INSERT INTO `xy_api_route` VALUES (94, 1, 'rule', '我的积分', 'User', 'score', 'user/score', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1596787495, 1596787495);
INSERT INTO `xy_api_route` VALUES (95, 1, 'get', '领取积分任务奖励', 'Score', 'receiveScore', 'user/receiveScore', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1596796159, 1596796159);
INSERT INTO `xy_api_route` VALUES (96, 1, 'get', '积分统计', 'Score', 'statistics', 'user/score/statistics', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1596866744, 1596866744);
INSERT INTO `xy_api_route` VALUES (97, 1, 'get', '获取消息内容', 'Message', 'getMessageFind', 'user/message/getContent', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1596872432, 1596872432);
INSERT INTO `xy_api_route` VALUES (98, 1, 'get', '设置消息为已读', 'Message', 'setMessageRead', 'user/message/setRead', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1596872467, 1596872467);
INSERT INTO `xy_api_route` VALUES (99, 1, 'get', '删除消息', 'Message', 'delMessage', 'user/message/del', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1596873113, 1596873113);
INSERT INTO `xy_api_route` VALUES (100, 1, 'get', '每日签到', 'Score', 'signInToday', 'user/score/signInToday', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1597040244, 1597040244);
INSERT INTO `xy_api_route` VALUES (101, 1, 'get', '我的权益', 'Vip', 'getMyRights', 'user/vip/getMyRights', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1597139236, 1597139203);
INSERT INTO `xy_api_route` VALUES (102, 1, 'rule', '用户上传简历作品', 'Resume', 'resumeWorks', 'user/resume/works', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1597397304, 1597397293);
INSERT INTO `xy_api_route` VALUES (103, 1, 'post', '保存简历作品', 'Resume', 'saveResumeWorks', 'user/resume/saveResumeWorks', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1597398552, 1597397710);
INSERT INTO `xy_api_route` VALUES (104, 1, 'get', '保存简历作品备注', 'Resume', 'saveResumeWorksTitle', 'user/resume/saveResumeWorksTitle', '/:id/:title', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1607067842, 1597397771);
INSERT INTO `xy_api_route` VALUES (105, 1, 'get', '删除简历作品', 'Resume', 'delResumeWorks', 'user/resume/delResumeWorks', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1597397816, 1597397816);
INSERT INTO `xy_api_route` VALUES (106, 1, 'rule', '发票管理', 'Vip', 'invoice', 'user/vip/invoice', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1597830995, 1597830946);
INSERT INTO `xy_api_route` VALUES (107, 1, 'post', '保存发票抬头', 'Invoice', 'saveInvoiceTitle', 'user/invoice/saveInvoiceTitle', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1597917318, 1597916840);
INSERT INTO `xy_api_route` VALUES (108, 1, 'get', '删除发票抬头邮寄地址', 'Invoice', 'delInvoiceTitleMailAddress', 'user/invoice/delInvoiceTitleMailAddress', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1597917324, 1597916866);
INSERT INTO `xy_api_route` VALUES (109, 1, 'post', '索取发票', 'Invoice', 'applyInvoice', 'user/invoice/applyInvoice', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1597916961, 1597916961);
INSERT INTO `xy_api_route` VALUES (110, 1, 'get', '关注简历', 'Resume', 'toggleResumeCollection', 'resume/toggleResumeCollection', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1598080711, 1598080711);
INSERT INTO `xy_api_route` VALUES (111, 1, 'rule', '反馈', 'Feedback', 'feedback', 'feedback', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1610091331, 1598343692);
INSERT INTO `xy_api_route` VALUES (112, 1, 'get', '聊天拉取信息', 'Message', 'getIMDataInfo', 'im/getIMDataInfo', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1602048872, 1602048872);
INSERT INTO `xy_api_route` VALUES (114, 4, 'rule', '首页', 'Index', 'index', '/', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1602659373, 1602659373);
INSERT INTO `xy_api_route` VALUES (115, 4, 'post', '登录', 'Login', 'index', 'login', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1602832842, 1602750100);
INSERT INTO `xy_api_route` VALUES (118, 4, 'get', '获取用户已登录信息', 'Login', 'getDefaultUserInfo', 'getDefaultUserInfo', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1602841813, 1602841813);
INSERT INTO `xy_api_route` VALUES (119, 4, 'post', '获取登录验证码', 'Login', 'getVcode', 'getVcode', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1602841832, 1602841832);
INSERT INTO `xy_api_route` VALUES (120, 4, 'post', '验证码登录', 'Login', 'vcode', 'login/vcode', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1602841857, 1602841857);
INSERT INTO `xy_api_route` VALUES (121, 4, 'get', '退出登录', 'Login', 'outLogin', 'outLogin', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1602842280, 1602842280);
INSERT INTO `xy_api_route` VALUES (122, 5, 'post', '登录', 'Login', 'index', 'login', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1603101039, 1603100970);
INSERT INTO `xy_api_route` VALUES (192, 1, 'get', '获取登录二维码', 'Login', 'loginQrcode', 'loginQrcode', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1608260768, 1608260768);
INSERT INTO `xy_api_route` VALUES (193, 1, 'get', '扫码登陆后获取用户信息', 'Login', 'qrlogin', 'qrlogin', '/:client_id/:to_client_id', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1608278281, 1608278281);
INSERT INTO `xy_api_route` VALUES (196, 5, 'rule', '微信关键词回复', 'Wechat', 'wechat', 'wechat', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1608536179, 1608536179);
INSERT INTO `xy_api_route` VALUES (203, 1, 'get', '职位刷新-所有', 'Jobs', 'setCompanyJobsRefreshTime', 'user/jobs/setCompanyJobsRefreshTime', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1608631820, 1608631820);
INSERT INTO `xy_api_route` VALUES (204, 4, 'get', '获取个人信息', 'User', 'index', 'user', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (205, 4, 'post', '获取状态别名', 'StatusAlias', 'getCate', 'status/alias/getCate', '', 1, NULL, '', 0, 0, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (206, 4, 'get', '获取企业信息', 'Company', 'getCompanyInfo', 'getCompanyInfo', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (207, 4, 'get', '用户中心统计', 'User', 'statistics', 'user/statistics', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (208, 4, 'get', '积分统计', 'Score', 'statistics', 'user/score/statistics', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (209, 4, 'get', '我的积分', 'User', 'score', 'user/score', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (210, 4, 'get', '领取积分任务奖励', 'Score', 'receiveScore', 'user/receiveScore', '/:id', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (211, 4, 'get', '每日签到', 'Score', 'signInToday', 'user/score/signInToday', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (212, 4, 'get', '获取文章分类', 'Article', 'getCateAliasSelect', 'article/cate/getCateAliasSelect', '/:alias', 1, NULL, '', 0, 0, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (213, 4, 'get', '获取文章列表', 'Article', 'getAliasSelect', 'article/list/getAliasSelect', '/:alias', 1, NULL, '', 0, 0, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (214, 4, 'get', '获取文章详情', 'Article', 'contentId', 'article/content/id', '/:id', 1, NULL, '', 0, 0, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (215, 4, 'get', '获取文章详情', 'Article', 'contentAlias', 'article/content/alias', '/:alias', 1, NULL, '', 0, 0, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (216, 4, 'get', '获取广告', 'Ads', 'getAds', 'ads/getAds', '/:alias', 1, NULL, '', 0, 0, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (217, 4, 'get', '获取求职意向', 'Resume', 'getJobHuntingIntention', 'job/status/getJobHuntingIntention', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (218, 4, 'get', '搜索工作', 'Search', 'searchJobs', 'search/jobs', '', 1, NULL, '', 0, 0, 1, NULL, NULL, NULL, 1, 1617008145, 1608634459);
INSERT INTO `xy_api_route` VALUES (219, 4, 'get', '职位详情', 'Jobs', 'index', 'jobs', '/:id', 1, NULL, '', 0, 0, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (220, 4, 'get', '公司详情', 'Company', 'index', 'company', '/:id', 1, NULL, '', 0, 0, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (221, 4, 'post', '发布职位', 'Jobs', 'release', 'user/jobs/release', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (222, 4, 'get', '获取对我感兴趣的人才', 'Jobs', 'getCompanyJobsBrowse', 'user/jobs/getCompanyJobsBrowse', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (223, 4, 'get', '搜索人才', 'Search', 'searchResume', 'search/resume', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (224, 4, 'rule', '第三方登录', 'ThirdPartyLogin', 'thirdParty', 'login', '/[:type]', 1, NULL, '', 0, 0, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (225, 4, 'get', '切换到个人', 'User', 'goToPersonal', 'user/goToPersonal', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (226, 4, 'get', '切换到企业', 'User', 'goToCompany', 'user/goToCompany', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (227, 4, 'get', '获取简历信息', 'Resume', 'getResumeInfo', 'getResumeInfo', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (228, 4, 'post', '更新求职状态', 'Resume', 'updateResumeJobStatus', 'user/resume/updateJobStatus', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (229, 4, 'post', '获取缓存数据', 'CacheData', 'getKey', 'cache/get', '', 1, NULL, '', 0, 0, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (230, 4, 'post', '添加求职期望', 'Resume', 'addJobHuntingIntention', 'job/status/addJobHuntingIntention', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (231, 4, 'post', '编辑求职期望', 'Resume', 'editJobHuntingIntention', 'job/status/editJobHuntingIntention', '/:id', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (232, 4, 'get', '求职期望', 'Resume', 'getJobHuntingIntentionFind', 'job/status/getJobHuntingIntentionFind', '/:id', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (233, 4, 'get', '删除求职期望', 'Resume', 'delJobHuntingIntention', 'job/status/delJobHuntingIntention', '/:id', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (234, 4, 'get', '简历-照片作品', 'Resume', 'getResumeWorks', 'getResumeWorks', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (235, 4, 'post', '保存简历作品', 'Resume', 'saveResumeWorks', 'user/resume/saveResumeWorks', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (236, 4, 'get', '保存简历作品备注', 'Resume', 'saveResumeWorksTitle', 'user/resume/saveResumeWorksTitle', '/:id', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (237, 4, 'get', '删除简历作品', 'Resume', 'delResumeWorks', 'user/resume/delResumeWorks', '/:id', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (238, 4, 'post', '通用上传接口', 'Uploads', 'uploadFiles', 'uploadFiles', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (239, 4, 'post', '保存简历', 'Resume', 'saveResume', 'user/saveResume', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (240, 4, 'get', '求职管理', 'Jobs', 'management', 'user/jobs/management', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (241, 4, 'get', '收藏和关注', 'User', 'follow', 'user/follow', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 1, 1614159229, 1608634459);
INSERT INTO `xy_api_route` VALUES (242, 4, 'get', '职位关注', 'Jobs', 'toggleJobsCollection', 'jobs/toggleJobsCollection', '/:id', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (243, 4, 'get', '企业关注', 'Company', 'toggleCompanyCollection', 'company/toggleCompanyCollection', '/:id', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (244, 4, 'get', '获取简历', 'Resume', 'index', 'resume', '/:id', 1, NULL, '', 0, 0, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (245, 4, 'get', '关注简历', 'Resume', 'toggleResumeCollection', 'resume/toggleResumeCollection', '/:id', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (246, 4, 'post', '保存企业信息', 'Company', 'saveCompany', 'user/company/saveCompany', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (247, 4, 'get', '获取企业信息', 'Company', 'getCompanyInfo', 'getCompanyInfo', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (248, 4, 'rule', '用户认证', 'User', 'attestation', 'user/company/attestation', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (249, 4, 'post', '保存用户信息', 'User', 'saveUser', 'user/saveUser', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (250, 4, 'post', '保存企业风采', 'Company', 'saveDemeanor', 'user/company/saveDemeanor', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (251, 4, 'get', '保存企业风采备注', 'Company', 'saveDemeanorTitle', 'user/company/saveDemeanorTitle', '/:id', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (252, 4, 'get', '删除企业风采', 'Company', 'delCompanyDemeanor', 'user/company/delCompanyDemeanor', '/:id', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (253, 4, 'get', '企业风采', 'Company', 'demeanor', 'getDemeanor', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (254, 4, 'get', '投递简历', 'Resume', 'deliveryResume', 'deliveryResume', '/:id', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (255, 4, 'get', '简历管理', 'Resume', 'management', 'user/resume/management', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (256, 4, 'get', '收藏的简历', 'Resume', 'collectedResume', 'user/resume/collected-resume', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (257, 4, 'get', '谁看过我', 'User', 'whoSawMe', 'user/who-saw-me', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (258, 4, 'get', '面试邀请', 'Resume', 'interviewInvitation', 'user/resume/interview-invitation', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (259, 4, 'get', '设置投递简历状态-不合适', 'Resume', 'setResumeInappropriate', 'user/resume/setResumeInappropriate', '/:id', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (260, 4, 'get', '删除投递简历', 'Resume', 'delDeliveryResume', 'user/resume/delDeliveryResume', '/:id', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (261, 4, 'post', '投递简历-面试邀请', 'Resume', 'inviteAnInterview', 'user/resume/inviteAnInterview', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (262, 4, 'get', '职位刷新', 'Jobs', 'setJobsRefreshTime', 'user/jobs/setRefreshTime', '/:id', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (263, 4, 'get', '设置职位状态', 'Jobs', 'setJobsStatus', 'user/jobs/setStatus', '/:id/:status', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (264, 4, 'get', '职位信息', 'Jobs', 'getJobsInfo', 'getJobsInfo', '/:id', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (265, 4, 'post', '保存职位', 'Jobs', 'saveJobs', 'user/jobs/saveJobs', '/:id', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (266, 4, 'get', '加入消息长链接ID组', 'Message', 'joinGroup', 'joinMessageGroup', '/:client_id', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (267, 4, 'get', '获取IMToken', 'Message', 'getImtoken', 'getImtoken', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (268, 4, 'get', '获取MessageToken', 'Message', 'getMessagetoken', 'getMessagetoken', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (269, 4, 'get', '聊天拉取信息', 'Message', 'getIMDataInfo', 'im/getIMDataInfo', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (270, 4, 'get', '设置投递简历状态-已查看', 'Resume', 'setDeliveryResumeViewed', 'user/resume/setDeliveryResumeViewed', '/:id', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (271, 4, 'get', '获取套餐', 'Vip', 'getVip', 'vip', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (272, 4, 'post', '统一下单', 'Pay', 'generateOrderInfo', 'pay/generateOrderInfo', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (273, 4, 'get', '我的订单', 'Vip', 'orders', 'user/orders', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (274, 4, 'post', '通过订单号获取支付信息', 'Pay', 'getOrderInfoByOtrade', 'pay/getOrderInfoByOtrade', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (275, 4, 'post', '取消订单', 'Pay', 'cancelOrder', 'pay/cancelOrder', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (276, 4, 'post', '删除订单', 'Pay', 'delOrder', 'pay/delOrder', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (277, 4, 'get', '获取增值服务', 'Vip', 'valueAdded', 'vip/valueAdded', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (278, 4, 'get', '职位刷新-所有', 'Jobs', 'setCompanyJobsRefreshTime', 'user/jobs/setCompanyJobsRefreshTime', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1608634459, 1608634459);
INSERT INTO `xy_api_route` VALUES (279, 4, 'post', '查询订单状态', 'Pay', 'getOrderInfoStatus', 'pay/getOrderInfoStatus', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1608792335, 1608792335);
INSERT INTO `xy_api_route` VALUES (280, 4, 'get', '获取支付宝表单', 'Index', 'getH5AlipayForm', 'pay/getH5AlipayForm', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1618026800, 1608799440);
INSERT INTO `xy_api_route` VALUES (361, 4, 'post', '设置简历隐私', 'Resume', 'setResumePrivacyStatus', 'user/resume/setResumePrivacyStatus', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1609324316, 1609324316);
INSERT INTO `xy_api_route` VALUES (362, 4, 'get', '解绑第三方账号', 'ThirdPartyLogin', 'unbind', 'unbind', '/[:type]', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1609324316, 1609324316);
INSERT INTO `xy_api_route` VALUES (370, 1, 'post', '创建聊天联系人', 'Message', 'createContacts', 'im/createContacts', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1610006767, 1610006767);
INSERT INTO `xy_api_route` VALUES (371, 4, 'post', '创建聊天联系人', 'Message', 'createContacts', 'im/createContacts', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1616836197, 1610006793);
INSERT INTO `xy_api_route` VALUES (374, 4, 'post', '反馈', 'Feedback', 'feedback', 'feedback', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1610091381, 1610090792);
INSERT INTO `xy_api_route` VALUES (377, 1, 'get', '获取简历联系方式', 'Resume', 'getContactsData', 'resume/getContactsData', '/:id', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1610444249, 1610442954);
INSERT INTO `xy_api_route` VALUES (378, 1, 'get', '获取职位联系方式', 'Jobs', 'getContactsData', 'jobs/getContactsData', '/:id', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1610444248, 1610443072);
INSERT INTO `xy_api_route` VALUES (379, 1, 'get', '验证码', 'Login', 'captcha', 'captcha', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1611127619, 1611127619);
INSERT INTO `xy_api_route` VALUES (380, 1, 'get', 'APP下载二维码', 'Uploads', 'getAppdown', 'qrcode/appdown', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1611299994, 1611224463);
INSERT INTO `xy_api_route` VALUES (381, 1, 'rule', '招聘会', 'JobFair', 'index', 'job-fair', '', 1, '', 'html', 0, 0, 1, NULL, NULL, NULL, 0, 1611300922, 1611300866);
INSERT INTO `xy_api_route` VALUES (382, 1, 'get', '事业单位招聘', 'Article', 'governmentInstitutions', 'article/government_institutions', '', 1, '', 'html', 0, 0, 1, NULL, NULL, NULL, 0, 1611302202, 1611302202);
INSERT INTO `xy_api_route` VALUES (383, 1, 'rule', '招聘会详情', 'JobFair', 'detail', 'job-fair/detail', '/:id', 1, '', 'html', 0, 0, 1, NULL, NULL, NULL, 0, 1611731247, 1611394620);
INSERT INTO `xy_api_route` VALUES (384, 1, 'get', '获取招聘会企业', 'JobFair', 'getCompanyList', 'job-fair/getCompanyList', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1611818955, 1611818955);
INSERT INTO `xy_api_route` VALUES (385, 1, 'get', '获取招聘会职位', 'JobFair', 'getJobsList', 'job-fair/getJobsList', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1611818957, 1611818957);
INSERT INTO `xy_api_route` VALUES (386, 1, 'get', '获取招聘会人才', 'JobFair', 'getResumeList', 'job-fair/getResumeList', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1611825367, 1611825367);
INSERT INTO `xy_api_route` VALUES (387, 1, 'get', '下载网站快捷方式', 'Index', 'downInternetShortcut', 'down/InternetShortcut', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1614157630, 1614157630);
INSERT INTO `xy_api_route` VALUES (388, 1, 'get', '获取未读消息条数', 'Message', 'getUnreadMessage', 'getUnreadMessage', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1614677526, 1614677526);
INSERT INTO `xy_api_route` VALUES (389, 1, 'get', '获取黑名单', 'User', 'getBlacklist', 'user/getBlacklist', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1615186167, 1615186167);
INSERT INTO `xy_api_route` VALUES (390, 1, 'post', '设置黑名单', 'User', 'setBlacklist', 'user/setBlacklist', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1615186401, 1615186401);
INSERT INTO `xy_api_route` VALUES (391, 1, 'get', '搜索公司', 'Company', 'getSearchCompany', 'user/getSearchCompany', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1624442929, 1615190560);
INSERT INTO `xy_api_route` VALUES (392, 1, 'get', '搜索简历', 'Resume', 'getSearchResume', 'user/getSearchResume', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1615190673, 1615190673);
INSERT INTO `xy_api_route` VALUES (393, 1, 'get', '取消黑名单', 'User', 'cancelBlacklist', 'user/cancelBlacklist', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1615194026, 1615194026);
INSERT INTO `xy_api_route` VALUES (405, 4, 'get', '招聘会', 'JobFair', 'index', 'job-fair', '', 1, NULL, '', 0, 0, 1, NULL, NULL, NULL, 1, 1615358785, 1615358785);
INSERT INTO `xy_api_route` VALUES (406, 4, 'get', '招聘会详情', 'JobFair', 'detail', 'job-fair/detail', '/:id', 1, NULL, '', 0, 0, 1, NULL, NULL, NULL, 1, 1615358785, 1615358785);
INSERT INTO `xy_api_route` VALUES (407, 4, 'get', '获取招聘会企业', 'JobFair', 'getCompanyList', 'job-fair/getCompanyList', '', 1, NULL, '', 0, 0, 1, NULL, NULL, NULL, 1, 1615358785, 1615358785);
INSERT INTO `xy_api_route` VALUES (408, 4, 'get', '获取招聘会职位', 'JobFair', 'getJobsList', 'job-fair/getJobsList', '', 1, NULL, '', 0, 0, 1, NULL, NULL, NULL, 1, 1615358785, 1615358785);
INSERT INTO `xy_api_route` VALUES (409, 4, 'get', '获取招聘会人才', 'JobFair', 'getResumeList', 'job-fair/getResumeList', '', 1, NULL, '', 0, 0, 1, NULL, NULL, NULL, 1, 1615358785, 1615358785);
INSERT INTO `xy_api_route` VALUES (410, 4, 'get', '获取未读消息条数', 'Message', 'getUnreadMessage', 'getUnreadMessage', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1615358785, 1615358785);
INSERT INTO `xy_api_route` VALUES (411, 4, 'get', '获取黑名单', 'User', 'getBlacklist', 'user/getBlacklist', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1615358785, 1615358785);
INSERT INTO `xy_api_route` VALUES (412, 4, 'post', '设置黑名单', 'User', 'setBlacklist', 'user/setBlacklist', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1615358785, 1615358785);
INSERT INTO `xy_api_route` VALUES (413, 4, 'get', '搜索公司', 'Company', 'getSearchCompany', 'user/getSearchCompany', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1615358785, 1615358785);
INSERT INTO `xy_api_route` VALUES (414, 4, 'get', '搜索简历', 'Resume', 'getSearchResume', 'user/getSearchResume', '', 1, NULL, '', 0, 1, 1, NULL, NULL, NULL, 1, 1615358785, 1615358785);
INSERT INTO `xy_api_route` VALUES (415, 4, 'rule', '取消黑名单', 'User', 'cancelBlacklist', 'user/cancelBlacklist', '/[:id]', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 1, 1618130794, 1615358785);
INSERT INTO `xy_api_route` VALUES (427, 1, 'rule', '更换绑定手机', 'User', 'editMobile', 'user/editMobile', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1615360790, 1615360790);
INSERT INTO `xy_api_route` VALUES (428, 1, 'rule', '更换绑定邮箱', 'User', 'editEmail', 'user/editEmail', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1615360818, 1615360818);
INSERT INTO `xy_api_route` VALUES (430, 4, 'get', '搜索企业', 'Search', 'searchCompany', 'search/company', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1623835550, 1615457554);
INSERT INTO `xy_api_route` VALUES (434, 5, 'rule', '微信登录', 'Index', 'login', 'login', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1615969922, 1615968524);
INSERT INTO `xy_api_route` VALUES (435, 1, 'get', '异步获取数据', 'Ajax', 'index', 'ajax', '/:type', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1616394479, 1616394479);
INSERT INTO `xy_api_route` VALUES (437, 4, 'get', '异步获取数据', 'Ajax', 'index', 'ajax', '/:type', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1616493737, 1616493737);
INSERT INTO `xy_api_route` VALUES (439, 1, 'rule', '帮助中心', 'Article', 'commonProblem', 'common-problem', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1616668042, 1616668042);
INSERT INTO `xy_api_route` VALUES (441, 4, 'get', '刷新简历', 'Resume', 'setResumeRefreshTime', 'user/resume/setResumeRefreshTime', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1616833405, 1616833405);
INSERT INTO `xy_api_route` VALUES (443, 1, 'get', '刷新简历', 'Resume', 'setResumeRefreshTime', 'user/resume/setResumeRefreshTime', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1616833455, 1616833455);
INSERT INTO `xy_api_route` VALUES (445, 4, 'get', '获取简历联系方式', 'Resume', 'getContactsData', 'resume/getContactsData', '/:id', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1616836848, 1616836848);
INSERT INTO `xy_api_route` VALUES (451, 4, 'get', '我的消息', 'Message', 'myMessage', 'user/myMessage', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1617007286, 1617007286);
INSERT INTO `xy_api_route` VALUES (452, 4, 'get', '获取消息内容', 'Message', 'getMessageFind', 'user/message/getContent', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1617007317, 1617007317);
INSERT INTO `xy_api_route` VALUES (453, 4, 'get', '获取未读消息条数', 'Message', 'getUnreadMessage', 'getUnreadMessage', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1617007342, 1617007342);
INSERT INTO `xy_api_route` VALUES (454, 4, 'get', '设置消息为已读', 'Message', 'setMessageRead', 'user/message/setRead', '/[:id]', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1617007364, 1617007364);
INSERT INTO `xy_api_route` VALUES (462, 4, 'post', '修改手机号', 'User', 'editMobile', 'user/editMobile', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1617345426, 1617345426);
INSERT INTO `xy_api_route` VALUES (463, 4, 'post', '修改邮箱', 'User', 'editEmail', 'user/editEmail', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1617345454, 1617345454);
INSERT INTO `xy_api_route` VALUES (465, 4, 'rule', '下载简历', 'Resume', 'downloads', 'downloads/resume', '/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1617351000, 1617350139);
INSERT INTO `xy_api_route` VALUES (467, 3, 'get', '每日后台统计', 'Statistics', 'bsadmin_charts_statistics', 'statistics/bsadmin/charts_statistics', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1617949450, 1617949450);
INSERT INTO `xy_api_route` VALUES (469, 4, 'rule', '接受面试邀请', 'Interview', 'handleInterviewInvitation', 'user/interview/handleInterviewInvitation', '/:status/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1618046397, 1618039703);
INSERT INTO `xy_api_route` VALUES (472, 4, 'get', '删除简历经历', 'Resume', 'delExperience', 'user/resume/delExperience', '/:type/:id', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1618128359, 1618128359);
INSERT INTO `xy_api_route` VALUES (474, 1, 'get', '海报列表', 'Posters', 'getList', 'user/poster', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1618903073, 1618903073);
INSERT INTO `xy_api_route` VALUES (475, 1, 'post', '生成海报', 'Posters', 'getPoster', 'user/getPoster', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1618911268, 1618911268);
INSERT INTO `xy_api_route` VALUES (478, 4, 'get', '海报列表', 'Posters', 'getList', 'user/poster', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1619078842, 1619078842);
INSERT INTO `xy_api_route` VALUES (479, 4, 'post', '生成海报', 'Posters', 'getPoster', 'user/getPoster', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1619078858, 1619078858);
INSERT INTO `xy_api_route` VALUES (485, 3, 'get', '后台CRM每日统计', 'Statistics', 'bsadmin_crm_charts_statistics', 'statistics/bsadmin/crm_charts_statistics', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1621409035, 1621408943);
INSERT INTO `xy_api_route` VALUES (595, 3, 'rule', '字节担保交易回调通知', 'Results', 'toutiaoPayNotify', 'pay/toutiao/notify', '', 1, '', '', 1, 0, 1, '', NULL, NULL, 0, 1622535889, 1622535889);
INSERT INTO `xy_api_route` VALUES (814, 3, 'rule', '百度支付回调', 'Results', 'baiduPayNotify', 'pay/baidu/notify', '', 1, '', '', 1, 0, 1, '', NULL, NULL, 0, 1622619458, 1622619458);
INSERT INTO `xy_api_route` VALUES (815, 1, 'rule', '分站', 'Index', 'sub_website', 'subsite', '/[:alias]', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1623376875, 1623228521);
INSERT INTO `xy_api_route` VALUES (817, 1, 'rule', '地图找工作', 'Index', 'map_jobs', 'map', '', 1, '', '', 0, 0, 1, NULL, NULL, NULL, 0, 1623400739, 1623400739);
INSERT INTO `xy_api_route` VALUES (820, 4, 'rule', '优惠券', 'Vip', 'coupon', 'user/vip/coupon', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1624615741, 1624615741);
INSERT INTO `xy_api_route` VALUES (826, 1, 'get', '委托投递', 'Resume', 'setAutoConsignment', 'user/resume/setAutoConsignment', '', 1, '', '', 0, 1, 1, NULL, NULL, NULL, 0, 1626775745, 1626775745);
