
-- ----------------------------
-- Table structure for xy_api_log
-- ----------------------------
DROP TABLE IF EXISTS `xy_api_log`;
CREATE TABLE `xy_api_log`  (
  `id` int(0) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `uid` int(0) NULL DEFAULT NULL,
  `app` int(0) NULL DEFAULT NULL,
  `api` int(0) NULL DEFAULT NULL,
  `route` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `mca` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `param` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `ip` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `systype` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '系统类型',
  `create_time` int(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `uid`(`uid`) USING BTREE,
  INDEX `ulog`(`uid`, `create_time`) USING BTREE,
  INDEX `ip`(`ip`, `create_time`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = 'api接口访问记录' ROW_FORMAT = Compact;

-- ----------------------------
-- Records of xy_api_log
-- ----------------------------
INSERT INTO `xy_api_log` VALUES (1, 'PC首页', 0, 1, 1, '/', 'index/Index/index', '[]', '116.253.138.245', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4324.190 Safari/537.36', 1618205800);
INSERT INTO `xy_api_log` VALUES (2, '字符串转二维码', 0, 1, 86, '/displayQrcode?icon=1&scheme=', 'index/Uploads/displayQrcode', '{\"icon\":\"1\",\"scheme\":\"\"}', '116.253.138.245', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4324.190 Safari/537.36', 1618205801);
INSERT INTO `xy_api_log` VALUES (3, 'APP下载二维码', 0, 1, 380, '/qrcode/appdown', 'index/Uploads/getAppdown', '[]', '116.253.138.245', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4324.190 Safari/537.36', 1618205801);
