
-- ----------------------------
-- Table structure for xy_api_app
-- ----------------------------
DROP TABLE IF EXISTS `xy_api_app`;
CREATE TABLE `xy_api_app`  (
  `app_id` int(0) UNSIGNED NOT NULL AUTO_INCREMENT,
  `app_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用名称',
  `app_icon` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `app_domain` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用域名',
  `app_modul` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '引用模块',
  `app_key` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '应用Key',
  `app_key_secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `app_status` tinyint(1) NULL DEFAULT 1 COMMENT '应用状态',
  `app_status_msg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '禁用提示',
  `update_time` int(0) NULL DEFAULT NULL,
  `create_time` int(0) NOT NULL,
  PRIMARY KEY (`app_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 8 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = 'Api接口应用' ROW_FORMAT = Compact;

-- ----------------------------
-- Records of xy_api_app
-- ----------------------------
INSERT INTO `xy_api_app` VALUES (1, 'PC', 'el-icon-monitor', 'www', 'index', NULL, NULL, 1, '', 1618135176, 1588757769);
INSERT INTO `xy_api_app` VALUES (3, '开放接口', 'el-icon-guide', 'open', 'open', NULL, NULL, 1, '', 1618135182, 1588757977);
INSERT INTO `xy_api_app` VALUES (4, 'Mobile', 'el-icon-mobile', 'm', 'mobile', '', '', 1, '', 1618197433, 1588758034);
INSERT INTO `xy_api_app` VALUES (5, '微信公众号', 'el-icon-warning-outline', 'wechat-mp', 'wechatmp', NULL, NULL, 1, '', 1618135189, 1588758147);
