-- ----------------------------
-- Table structure for xy_admin
-- ----------------------------
DROP TABLE IF EXISTS `xy_admin`;
CREATE TABLE `xy_admin`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `headimg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `nickname` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '管理员昵称',
  `username` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '管理员账号',
  `password` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '管理员密码',
  `password_hash` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '密码HASH',
  `status` tinyint(1) NULL DEFAULT 1 COMMENT '管理员状态',
  `role_id` int(10) NULL DEFAULT NULL COMMENT '权限id',
  `allow_time_start` int(2) NULL DEFAULT 8 COMMENT '允许登录开始时间',
  `allow_time_end` int(2) NULL DEFAULT 19 COMMENT '允许登录结束时间',
  `allow_week` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '1,2,3,4,5,6' COMMENT '允许登录周几',
  `login_time` int(11) NULL DEFAULT NULL COMMENT '最后登陆时间',
  `mobile` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `other_contact` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `other_img` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `adviser_default` tinyint(1) NULL DEFAULT 0,
  `openid` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `update_time` int(10) NULL DEFAULT NULL,
  `create_time` int(10) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `username`(`username`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '管理员' ROW_FORMAT = Compact;

-- ----------------------------
-- Records of xy_admin
-- ----------------------------
INSERT INTO `xy_admin` VALUES (1, '', 'Unknown', 'admins', '9b7dd689dfdd5b6252a7f5b2b1b2b4dd', 'nW48', 1, 1, 0, 23, '1,2,3,4,5,6,0', 1619684164, '', '', '', '', 1, '', 1619684164, 1528956711);
