<?php

// +----------------------------------------------------------------------
// | 缓存设置
// +----------------------------------------------------------------------

return [
    // 默认缓存驱动
    'default' => env('cache.driver', 'redis'),

    // 缓存连接方式配置
    'stores'  => [
        // redis缓存
        'redis'   =>  [
            // 驱动方式
            'type'          => 'redis',
            // 缓存前缀
            'prefix'     => '{$redis_prefix}',
            // 缓存有效期 0表示永久缓存
            'expire'     => 0,
            // 服务器地址
            'host'          => '{$redis_host}',
        ],
        // 更多的缓存连接
    ],
];
