<?php
// +----------------------------------------------------------------------
// | 应用设置
// +----------------------------------------------------------------------
$debug=env('APP_DEBUG', false);

return [
    'app_debug'        => $debug,
    // 应用地址
    'app_host'         => env('APP.HOST', ''),
    // 应用的命名空间
    'app_namespace'    => '',
    // 是否启用路由
    'with_route'       => true,
    // 是否启用事件
    'with_event'       => true,
    // 默认应用
    'app_express'      => true,
    'default_app'      => 'index',
    // 默认时区
    'default_timezone' => 'Asia/Shanghai',

    // 应用映射（自动多应用模式有效）
    'app_map'          => [],
    // 域名绑定（自动多应用模式有效）
    'domain_bind'      => [
        '{$admin_domain}'               =>  'bsadmin',
        '{$index_domain}'                   =>  'index',
        '{$open_domain}'                  =>  'open',
        '{$appapiv1_domain}'            =>  'appapiv1',
        '{$mobile_domain}'                     =>  'mobile',
        '{$wechatminiprogram_domain}'    =>  'wechatminiprogram',
        '{$wechatmp_domain}'             =>  'wechatmp',
        '{$app_domain}'                   =>  'app',
    ],
    // 禁止URL访问的应用列表（自动多应用模式有效）
    'deny_app_list'    => ['common'],

    // 异常页面的模板文件
    'exception_tmpl'   => $debug
    ?app()->getThinkPath() . 'tpl/think_exception.tpl'
    :app()->getRootPath().'html/default/exception.html',

    // 错误显示信息,非调试模式有效
    'error_message'    => '页面错误！请稍后再试～',
    // 显示错误信息
    'show_error_msg'   => false,
];
