<?php
use think\facade\Route;
//首页
Route::rule('/','mobile/Index/index');
//登录
Route::post('login','mobile/Login/index');
//获取用户已登录信息
Route::get('getDefaultUserInfo','mobile/Login/getDefaultUserInfo');
//获取登录验证码
Route::post('getVcode','mobile/Login/getVcode');
//验证码登录
Route::post('login/vcode','mobile/Login/vcode');
//退出登录
Route::get('outLogin','mobile/Login/outLogin');
//获取个人信息
Route::get('user','mobile/User/index');
//获取状态别名
Route::post('status/alias/getCate','mobile/StatusAlias/getCate');
//获取企业信息
Route::get('getCompanyInfo','mobile/Company/getCompanyInfo');
//用户中心统计
Route::get('user/statistics','mobile/User/statistics');
//积分统计
Route::get('user/score/statistics','mobile/Score/statistics');
//我的积分
Route::get('user/score','mobile/User/score');
//领取积分任务奖励
Route::get('user/receiveScore/:id','mobile/Score/receiveScore');
//每日签到
Route::get('user/score/signInToday','mobile/Score/signInToday');
//获取文章分类
Route::get('article/cate/getCateAliasSelect/:alias','mobile/Article/getCateAliasSelect');
//获取文章列表
Route::get('article/list/getAliasSelect/:alias','mobile/Article/getAliasSelect');
//获取文章详情
Route::get('article/content/id/:id','mobile/Article/contentId');
//获取文章详情
Route::get('article/content/alias/:alias','mobile/Article/contentAlias');
//获取广告
Route::get('ads/getAds/:alias','mobile/Ads/getAds');
//获取求职意向
Route::get('job/status/getJobHuntingIntention','mobile/Resume/getJobHuntingIntention');
//搜索工作
Route::get('search/jobs','mobile/Search/searchJobs');
//职位详情
Route::get('jobs/:id','mobile/Jobs/index');
//公司详情
Route::get('company/:id','mobile/Company/index');
//发布职位
Route::post('user/jobs/release','mobile/Jobs/release');
//获取对我感兴趣的人才
Route::get('user/jobs/getCompanyJobsBrowse','mobile/Jobs/getCompanyJobsBrowse');
//搜索人才
Route::get('search/resume','mobile/Search/searchResume');
//第三方登录
Route::rule('login/[:type]','mobile/ThirdPartyLogin/thirdParty');
//切换到个人
Route::get('user/goToPersonal','mobile/User/goToPersonal');
//切换到企业
Route::get('user/goToCompany','mobile/User/goToCompany');
//获取简历信息
Route::get('getResumeInfo','mobile/Resume/getResumeInfo');
//更新求职状态
Route::post('user/resume/updateJobStatus','mobile/Resume/updateResumeJobStatus');
//获取缓存数据
Route::post('cache/get','mobile/CacheData/getKey');
//添加求职期望
Route::post('job/status/addJobHuntingIntention','mobile/Resume/addJobHuntingIntention');
//编辑求职期望
Route::post('job/status/editJobHuntingIntention/:id','mobile/Resume/editJobHuntingIntention');
//求职期望
Route::get('job/status/getJobHuntingIntentionFind/:id','mobile/Resume/getJobHuntingIntentionFind');
//删除求职期望
Route::get('job/status/delJobHuntingIntention/:id','mobile/Resume/delJobHuntingIntention');
//简历-照片作品
Route::get('getResumeWorks','mobile/Resume/getResumeWorks');
//保存简历作品
Route::post('user/resume/saveResumeWorks','mobile/Resume/saveResumeWorks');
//保存简历作品备注
Route::get('user/resume/saveResumeWorksTitle/:id','mobile/Resume/saveResumeWorksTitle');
//删除简历作品
Route::get('user/resume/delResumeWorks/:id','mobile/Resume/delResumeWorks');
//通用上传接口
Route::post('uploadFiles','mobile/Uploads/uploadFiles');
//保存简历
Route::post('user/saveResume','mobile/Resume/saveResume');
//求职管理
Route::get('user/jobs/management','mobile/Jobs/management');
//收藏和关注
Route::get('user/follow','mobile/User/follow');
//职位关注
Route::get('jobs/toggleJobsCollection/:id','mobile/Jobs/toggleJobsCollection');
//企业关注
Route::get('company/toggleCompanyCollection/:id','mobile/Company/toggleCompanyCollection');
//获取简历
Route::get('resume/:id','mobile/Resume/index');
//关注简历
Route::get('resume/toggleResumeCollection/:id','mobile/Resume/toggleResumeCollection');
//保存企业信息
Route::post('user/company/saveCompany','mobile/Company/saveCompany');
//获取企业信息
Route::get('getCompanyInfo','mobile/Company/getCompanyInfo');
//用户认证
Route::rule('user/company/attestation','mobile/User/attestation');
//保存用户信息
Route::post('user/saveUser','mobile/User/saveUser');
//保存企业风采
Route::post('user/company/saveDemeanor','mobile/Company/saveDemeanor');
//保存企业风采备注
Route::get('user/company/saveDemeanorTitle/:id','mobile/Company/saveDemeanorTitle');
//删除企业风采
Route::get('user/company/delCompanyDemeanor/:id','mobile/Company/delCompanyDemeanor');
//企业风采
Route::get('getDemeanor','mobile/Company/demeanor');
//投递简历
Route::get('deliveryResume/:id','mobile/Resume/deliveryResume');
//简历管理
Route::get('user/resume/management','mobile/Resume/management');
//收藏的简历
Route::get('user/resume/collected-resume','mobile/Resume/collectedResume');
//谁看过我
Route::get('user/who-saw-me','mobile/User/whoSawMe');
//面试邀请
Route::get('user/resume/interview-invitation','mobile/Resume/interviewInvitation');
//设置投递简历状态-不合适
Route::get('user/resume/setResumeInappropriate/:id','mobile/Resume/setResumeInappropriate');
//删除投递简历
Route::get('user/resume/delDeliveryResume/:id','mobile/Resume/delDeliveryResume');
//投递简历-面试邀请
Route::post('user/resume/inviteAnInterview','mobile/Resume/inviteAnInterview');
//职位刷新
Route::get('user/jobs/setRefreshTime/:id','mobile/Jobs/setJobsRefreshTime');
//设置职位状态
Route::get('user/jobs/setStatus/:id/:status','mobile/Jobs/setJobsStatus');
//职位信息
Route::get('getJobsInfo/:id','mobile/Jobs/getJobsInfo');
//保存职位
Route::post('user/jobs/saveJobs/:id','mobile/Jobs/saveJobs');
//加入消息长链接ID组
Route::get('joinMessageGroup/:client_id','mobile/Message/joinGroup');
//获取IMToken
Route::get('getImtoken','mobile/Message/getImtoken');
//获取MessageToken
Route::get('getMessagetoken','mobile/Message/getMessagetoken');
//聊天拉取信息
Route::get('im/getIMDataInfo','mobile/Message/getIMDataInfo');
//设置投递简历状态-已查看
Route::get('user/resume/setDeliveryResumeViewed/:id','mobile/Resume/setDeliveryResumeViewed');
//获取套餐
Route::get('vip','mobile/Vip/getVip');
//统一下单
Route::post('pay/generateOrderInfo','mobile/Pay/generateOrderInfo');
//我的订单
Route::get('user/orders','mobile/Vip/orders');
//通过订单号获取支付信息
Route::post('pay/getOrderInfoByOtrade','mobile/Pay/getOrderInfoByOtrade');
//取消订单
Route::post('pay/cancelOrder','mobile/Pay/cancelOrder');
//删除订单
Route::post('pay/delOrder','mobile/Pay/delOrder');
//获取增值服务
Route::get('vip/valueAdded','mobile/Vip/valueAdded');
//职位刷新-所有
Route::get('user/jobs/setCompanyJobsRefreshTime','mobile/Jobs/setCompanyJobsRefreshTime');
//查询订单状态
Route::post('pay/getOrderInfoStatus','mobile/Pay/getOrderInfoStatus');
//获取支付宝表单
Route::get('pay/getH5AlipayForm','mobile/Index/getH5AlipayForm');
//设置简历隐私
Route::post('user/resume/setResumePrivacyStatus','mobile/Resume/setResumePrivacyStatus');
//解绑第三方账号
Route::get('unbind/[:type]','mobile/ThirdPartyLogin/unbind');
//创建聊天联系人
Route::post('im/createContacts','mobile/Message/createContacts');
//反馈
Route::post('feedback','mobile/Feedback/feedback');
//招聘会
Route::get('job-fair','mobile/JobFair/index');
//招聘会详情
Route::get('job-fair/detail/:id','mobile/JobFair/detail');
//获取招聘会企业
Route::get('job-fair/getCompanyList','mobile/JobFair/getCompanyList');
//获取招聘会职位
Route::get('job-fair/getJobsList','mobile/JobFair/getJobsList');
//获取招聘会人才
Route::get('job-fair/getResumeList','mobile/JobFair/getResumeList');
//获取未读消息条数
Route::get('getUnreadMessage','mobile/Message/getUnreadMessage');
//获取黑名单
Route::get('user/getBlacklist','mobile/User/getBlacklist');
//设置黑名单
Route::post('user/setBlacklist','mobile/User/setBlacklist');
//搜索公司
Route::get('user/getSearchCompany','mobile/Company/getSearchCompany');
//搜索简历
Route::get('user/getSearchResume','mobile/Resume/getSearchResume');
//取消黑名单
Route::rule('user/cancelBlacklist/[:id]','mobile/User/cancelBlacklist');
//搜索企业
Route::get('search/company','mobile/Search/searchCompany');
//异步获取数据
Route::get('ajax/:type','mobile/Ajax/index');
//刷新简历
Route::get('user/resume/setResumeRefreshTime','mobile/Resume/setResumeRefreshTime');
//获取简历联系方式
Route::get('resume/getContactsData/:id','mobile/Resume/getContactsData');
//我的消息
Route::get('user/myMessage','mobile/Message/myMessage');
//获取消息内容
Route::get('user/message/getContent/:id','mobile/Message/getMessageFind');
//获取未读消息条数
Route::get('getUnreadMessage','mobile/Message/getUnreadMessage');
//设置消息为已读
Route::get('user/message/setRead/[:id]','mobile/Message/setMessageRead');
//修改手机号
Route::post('user/editMobile','mobile/User/editMobile');
//修改邮箱
Route::post('user/editEmail','mobile/User/editEmail');
//下载简历
Route::rule('downloads/resume/:id','mobile/Resume/downloads');
//接受面试邀请
Route::rule('user/interview/handleInterviewInvitation/:status/:id','mobile/Interview/handleInterviewInvitation');
//删除简历经历
Route::get('user/resume/delExperience/:type/:id','mobile/Resume/delExperience');
