<?php
namespace app\mobile\controller;
use think\facade\Cache;
use think\facade\Cookie;
use think\facade\Session;
use app\common\variable\MsgCode;
use app\common\controller\Orders as OrdersController;
use app\common\controller\UserScore as UserScoreController;
use app\common\controller\Score as ScoreController;
use app\common\controller\Vip as VipController;
use app\common\controller\Invoice as InvoiceController;
use app\common\controller\Coupon as CouponController;
class Vip extends Base
{
    public function getVip()
    {
        $User=Session::get('User');
        $where=[
            ['vip.is_company','=',$User['role_type']]
        ];
        $Data=VipController::getSelect($where);
        return $this->ajaxReturn('',MsgCode::$success,$Data);
    }
    public function orders()
    {
        $User=Session::get('User');
        $G=request()->get();
        $G['uid']=$User['id'];
        return OrdersController::getSelect($G);
    }
    public function valueAdded()
    {
        $User=Session::get('User');
        $where=[
            'is_company'    =>  $User['role_type'],
            'uid'           =>  $User['id'],
            'company_id'    =>  $User['company_id'],
            'resume_id'     =>  $User['resume_id']
        ];
        $valueAdded=VipController::getValueAdded($where);
        return $this->ajaxReturn('',MsgCode::$success,$valueAdded);
    }
    public function coupon()
    {
        $User=Session::get('User');
        $D=request()->get();
        $D['uid']=$User['id'];
        return CouponController::getList($D);
    }

    public function server()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
        	return View::fetch('company_server');
    	}else{
	        return View::fetch('personal_server');
    	}
    }
    public function myPoints()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
            if (request()->isAjax()) {
                $G=request()->get();
                $G['uid']=$User['id'];
                if ($G['type']=='score') {
                    return UserScoreController::getList($G);
                }elseif ($G['type']=='score_task') {
                    return ScoreController::getScoreTaskList($User['id'],$User['role_type']);
                }
            }
        	return View::fetch('company_my_points');
    	}else{
            return redirect('/user/score');
    	}
    }
    public function invoice()
    {
        $User=Session::get('User');
        if ($User['role_type']){
            if (request()->isAjax()) {
                return OrdersController::getInvoiceSelect($User['id'],request()->get('all_selected'));
            }
            View::assign('Find',InvoiceController::getInvoice($User['id']));
            return View::fetch('company_invoice');
        }else{
            return View::fetch('personal_invoice');
        }
    }
    public function templateToggle()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
        	return View::fetch('company_template_toggle');
    	}else{
	        return View::fetch('personal_template_toggle');
    	}
    }
    public function outsource()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
        	return View::fetch('company_outsource');
    	}else{
            return redirect('/user/vip/server');
    	}
    }
    public function jobFair()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
        	return View::fetch('company_job_fair');
    	}else{
	        return View::fetch('personal_job_fair');
    	}
    }
    public function getMyRights()
    {
        if (request()->isAjax()) {
            $User=Session::get('User');
            $G=request()->get();
            $G['uid']=$User['id'];
            $G['company_id']=$User['company_id'];
            if ($G['type']=='rights') {
                return VipController::getMyRights($G);
            }else if ($G['type']=='detailed') {
                return VipController::getMyRightsDetailed($G);
            }
        }
    }
}
