<?php
namespace app\mobile\controller;
use think\facade\Cache;
use think\facade\Db;
use think\facade\Session;
use app\common\variable\MsgCode;
use app\common\model\UserWx as UserWxModel;
use app\common\model\UserQq as UserQqModel;
use app\common\model\UserApple as UserAppleModel;
use think\helper\Str;
use think\Response;
use think\exception\HttpResponseException;
use app\common\model\User as UserModel;
use app\common\model\UserTimer as UserTimerModel;
use app\common\model\UserLoginLog as UserLoginLogModel;
use app\common\model\UserDevices as UserDevicesModel;
use helper\URL;
use helper\Wechat;
class ThirdPartyLogin
{
    public $H5Url='';
    public $H5UrlFial='';
    public $H5UrlSuccess='';
    /**
     * [__construct 构造函数]
     * @return [type] [description]
     */
    public function __construct(){
        $this->H5Url=config('web.h5');
        $this->H5UrlSuccess=config('web.h5').'/#/pages/common/home/home';
        $this->H5UrlFial=config('web.h5').'/#/pages/common/login/login';
    }
    public function thirdParty($type='')
    {
        switch ($type) {
            case 'wx':
                return $this->wxLogin();
            default:
                return $this->ajaxReturn('登录方式错误',MsgCode::$error);
        }
    }
    public function unbind($type='')
    {
        switch ($type) {
            case 'unbindApple':
                return $this->unbindApple();
            case 'unbindWx':
                return $this->unbindWx();
            case 'unbindQq':
                return $this->unbindQq();
            default:
                return $this->ajaxReturn('登录方式错误',MsgCode::$error);
        }
    }
    public function unbindApple()
    {
        $UserAppleModel=UserAppleModel::where(['uid'=>Session::get('User.id')])->field('id,uid')->find();
        if($UserAppleModel&&$UserAppleModel->uid){
            $UserAppleModel->uid=null;
            if($UserAppleModel->save()){
                return $this->ajaxReturn('解绑成功',MsgCode::$success);
            }
        }
        return $this->ajaxReturn('解绑失败',MsgCode::$error);

    }
    public function unbindWx()
    {
        $UserWxModel=UserWxModel::where(['uid'=>Session::get('User.id')])->field('id,uid')->find();
        if($UserWxModel&&$UserWxModel->uid){
            $UserWxModel->uid=null;
            if($UserWxModel->save()){
                return $this->ajaxReturn('解绑成功',MsgCode::$success);
            }else{
            }
        }
        return $this->ajaxReturn('解绑失败',MsgCode::$error);
    }
    public function unbindQq()
    {
        $UserQqModel=UserQqModel::where(['uid'=>Session::get('User.id')])->field('id,uid')->find();
        if($UserQqModel&&$UserQqModel->uid){
            $UserQqModel->uid=null;
            if($UserQqModel->save()){
                return $this->ajaxReturn('解绑成功',MsgCode::$success);
            }else{
            }
        }
        return $this->ajaxReturn('解绑失败',MsgCode::$error);
    }
    public function wxLogin()
    {
        $appid=config('xy_wechat_mp.appid');
        $redirect_uri = urlencode(config('web.wechatmp').'/login');
        $url ="https://open.weixin.qq.com/connect/oauth2/authorize?appid=$appid&redirect_uri=$redirect_uri&response_type=code&scope=snsapi_userinfo&state=hasUserSns#wechat_redirect";
        throw new HttpResponseException(Response::create($url,'redirect',302));
    }
}
