<?php
namespace app\mobile\controller;
use think\facade\Session;
use think\facade\Cache;
use think\facade\Cookie;
use app\common\variable\MsgCode;
use app\common\controller\Resume as ResumeController;
use app\common\controller\JobsDeliveryResume as JobsDeliveryResumeController;
use app\common\controller\InviteAninterview as InviteAninterviewController;
use app\common\model\Jobs as JobsModel;
use app\common\model\Resume as ResumeModel;
use app\common\model\ResumeBrowse as ResumeBrowseModel;
use app\common\model\JobsDeliveryResume as JobsDeliveryResumeModel;
use app\common\model\StatusAlias as StatusAliasModel;
use app\common\model\JobsContacts as JobsContactsModel;
use app\common\model\CompanyContent as CompanyContentModel;
use app\common\model\ResumeWorks as ResumeWorksModel;
class Resume extends Base
{
    public function index($id)
    {
        $D=[
            'company_id'    =>  Session::get('User.company_id')
        ];
        $Find=ResumeController::getResumeInfo($id,$D);
        /*记录访客*/
        if ($Find){
            ResumeBrowseModel::saveBrowse($D['company_id'],$id);
            return $this->ajaxReturn('',MsgCode::$success,$Find);
        }else{
            return $this->ajaxReturn('简历不存在',MsgCode::$error,$Find);
        }
    }
    /**
     * [getJobHuntingIntention 获取求职意向]
     * @return [type] [description]
     */
    public function getJobHuntingIntention()
    {
        $User=Session::get('User');
        $D=[
            'resume_id' =>  $User['resume_id'],
            'uid'       =>  $User['id']
        ];
        return ResumeController::getJobHuntingIntention($D);
    }
    public function getJobHuntingIntentionFind($id)
    {
        $User=Session::get('User');
        $D=[
            'id'        =>  $id,
            'resume_id' =>  $User['resume_id']
        ];
        return ResumeController::getJobHuntingIntentionFind($D);
    }
    public function addJobHuntingIntention()
    {
        $User=Session::get('User');
        $D=request()->post();
        $D['resume_id']=$User['resume_id'];
        return ResumeController::saveJobHuntingIntention($D);
    }
    public function editJobHuntingIntention($id)
    {
        $User=Session::get('User');
        $D=request()->post();
        $D['resume_id']=$User['resume_id'];
        $D['id']=$id;
        return ResumeController::saveJobHuntingIntention($D);
    }
    public function delJobHuntingIntention($id)
    {
        $User=Session::get('User');
        $D=[
            'resume_id' =>  $User['resume_id'],
            'id'        =>  $id,
        ];
        return ResumeController::delJobHuntingIntention($D);
    }
    public function getResumeInfo()
    {
        $User=Session::get('User');
        $G=request()->get();
        if(!empty($G['find']) && $G['find']){
            $ResumeInfo=ResumeController::getResumeInfo($User['resume_id'],['is_admin'=>1]);
        }else{
            $ResumeInfo=ResumeController::getResumeInfoAll($User['id']);
        }
        if($ResumeInfo){
            return $this->ajaxReturn('',MsgCode::$success,$ResumeInfo);
        }else{
            return $this->ajaxReturn('',MsgCode::$error);
        }
    }
    public function updateResumeJobStatus()
    {
        $User=Session::get('User');
        $D=request()->post();
        $D['uid']=$User['id'];
        $D['resume_id']=$User['resume_id'];
        return ResumeController::updateResumeJobStatus($D);
    }
    public function getResumeWorks()
    {
        $User=Session::get('User');
        $ResumeWorksModel=ResumeWorksModel::getResumeWorks($User['resume_id']);
        if($ResumeWorksModel){
            return $this->ajaxReturn('',MsgCode::$success,$ResumeWorksModel);
        }else{
            return $this->ajaxReturn('',MsgCode::$error);
        }
    }
    /**
     * 保存作品照片
     */
    public function saveResumeWorks()
    {
        $User=Session::get('User');
        $D=request()->post();
        $D['uid']=$User['id'];
        $D['resume_id']=$User['resume_id'];
        if (!$D['resume_id'])
            return $this->ajaxReturn('请先创建简历',MsgCode::$error);
        /*
        *  调用公共保存作品照片方法
        *  app\common\controller\Resume
        */
        return ResumeController::saveResumeWorks($D);
    }
    /**
     * 保存作品照片备注
     */
    public function saveResumeWorksTitle($id)
    {
    	$User=Session::get('User');
    	$G=request()->get();
        $D=[
            'id'        =>  $id,
            'title'     =>  $G['title'],
            'resume_id'	=>  $User['resume_id'],
        ];
        if (!$D['resume_id'])
            return $this->ajaxReturn('请先创建简历',MsgCode::$error);
        /*
        *  调用公共保存作品照片备注方法
        *  app\common\controller\Resume
        */
        return ResumeController::saveResumeWorksTitle($D);
    }
    /**
     * 删除作品照片
     */
    public function delResumeWorks($id)
    {
    	$User=Session::get('User');
        $D=[
            'id'            =>  $id,
            'resume_id'		=>  $User['resume_id'],
        ];
        if (!$D['resume_id'])
            return $this->ajaxReturn('请先创建简历',MsgCode::$error);
        /*
        *  调用公共删除作品照片方法
        *  app\common\controller\Resume
        */
        return ResumeController::delResumeWorks($D);
    }
    /**
     * 保存简历
     */
    public function saveResume()
    {
        $User=Session::get('User');
        $D=request()->post();
        $D['uid']=$User['id'];
        $D['app_id']=request()->ApiInfo['app_id'];
        /*
        *  调用公共保存简历方法
        *  app\common\controller\Resume
        */
        return ResumeController::saveResume($D);
    }
    public function toggleResumeCollection($id)
    {
        $User=Session::get('User');
        $D=[
            'id'            =>  $id,
            'uid'           =>  $User['id'],
            'company_id'    =>  $User['company_id']
        ];
        if (!$D['company_id'])
            return $this->ajaxReturn('请先完善企业信息',MsgCode::$error);
        /*
        *  调用公共关注简历方法
        *  app\common\controller\Resume
        */
        return ResumeController::toggleResumeCollection($D);
    }
    /**
     * 删除简历经历
     */
    public function delExperience($type,$id)
    {
        $User=Session::get('User');
        $D=[
            'id'            =>  $id,
            'type'          =>  $type,
            'uid'    		=>  $User['id']
        ];
        /*
        *  调用公共删除简历经历方法
        *  app\common\controller\Resume
        */
        return ResumeController::delExperience($D);
    }
    /**
     * 投递简历
     */
    public function deliveryResume($id)
    {
        $User=Session::get('User');
        $G=request()->get();
        $D=[
            'id'            =>  $id,
            'confirm'       =>  empty($G['confirm'])?0:$G['confirm'],
            'uid'           =>  $User['id'],
            'html'			=>	false
        ];
        /*
        *  调用公共投递简历方法
        *  app\common\controller\Resume
        */
        return ResumeController::deliveryResume($D);
    }
    public function management()
    {
        $User=Session::get('User');
        $G=request()->get();
        $G['company_id']=$User['company_id'];
        $JobsDeliveryResumeController=JobsDeliveryResumeController::getCompanyJobsDeliveryResume($G);
        return $this->ajaxReturn('',MsgCode::$success,$JobsDeliveryResumeController);
    }
    public function collectedResume()
    {
        $User=Session::get('User');
        $ResumeController=ResumeController::getResumeCollectionList($User['company_id']);
        return $this->ajaxReturn('',MsgCode::$success,$ResumeController);
    }
    public function interviewInvitation()
    {
        $User=Session::get('User');
        $D=[
            'company_id'=>$User['company_id']
        ];
        $InviteAninterviewController=InviteAninterviewController::getInviteAninterviewList($D);
        return $this->ajaxReturn('',MsgCode::$success,$InviteAninterviewController);
    }
    public function setResumeInappropriate($id)
    {
        $User=Session::get('User');
        $D=[
            'id'        =>  $id,
            'company_id'=>  $User['company_id'],
            'uid'       =>  $User['id']
        ];
        /*
        *  调用公共设置投递简历不合适方法
        *  app\common\controller\Resume
        */
        return ResumeController::setResumeInappropriate($D);
    }
    public function setDeliveryResumeViewed($id)
    {
        $User=Session::get('User');
        $D=[
            'id'        =>  $id,
            'company_id'=>  $User['company_id'],
            'uid'       =>  $User['id']
        ];
        /*
        *  调用公共设置投递简历状态
        *  app\common\controller\Resume
        */
        return ResumeController::setDeliveryResumeViewed($D);
    }
    public function delDeliveryResume($id)
    {
        $User=Session::get('User');
        $D=[
            'id'        =>  $id,
            'role_type' =>  $User['role_type'],
            'company_id'=>  $User['company_id'],
            'resume_id' =>  $User['resume_id']
        ];
        /*
        *  调用公共删除投递方法
        *  app\common\controller\JobsDeliveryResume
        */
        return JobsDeliveryResumeController::delDeliveryResume($D);
    }
    public function inviteAnInterview()
    {
        $User=Session::get('User');
        $D=request()->post();
        $D['company_id']=$User['company_id'];
        $D['uid']=$User['id'];
        /*
        *  调用公共邀请面试方法
        *  app\common\controller\Resume
        */
        return ResumeController::inviteAnInterview($D);
    }
    public function setResumePrivacyStatus()
    {
        $User=Session::get('User');
        $D=request()->post();
        if (empty($D['type']))
            return $this->ajaxReturn('请求类型不正确',MsgCode::$error);
        $Data=[
            'status'    =>  empty($D['val'])?0:1,
            'resume_id' =>  $User['resume_id']
        ];
        switch ($D['type']) {
            case 'privacy':
                /*
                *  调用公共设置简历隐私状态方法
                *  app\common\controller\Resume
                */
                return ResumeController::setResumePrivacy($Data);
            case 'headimg_status':
                /*
                *  调用公共设置头像是否公开方法
                *  app\common\controller\Resume
                */
                return ResumeController::setResumeHeadimgStatus($Data);
            default:
            return $this->ajaxReturn('请求类型不正确',MsgCode::$error);
        }
    }
    public function getSearchResume()
    {
        $D=[
            'uid'       =>  Session::get('User.id'),
            'company_id'=>  Session::get('User.company_id'),
            'key'       =>  request()->get('key')
        ];
        return ResumeController::getSearchResume($D);
    }
    public function setResumeRefreshTime()
    {
        $User=Session::get('User');
        $D=[
            'uid'       =>  Session::get('User.id'),
            'resume_id' =>  Session::get('User.resume_id')
        ];
        /*
        *  调用公共刷新简历方法
        *  app\common\controller\Resume
        */
        return ResumeController::setResumeRefreshTime($D);
    }
    public function getContactsData($id)
    {
        $D=[
            'id'        =>  $id,
            'uid'       =>  Session::get('User.id'),
            'role_type' =>  Session::get('User.role_type'),
            'company_id'=>  Session::get('User.company_id')
        ];
        return ResumeController::getContactsData($D);
    }
    public function downloads($id)
    {
        if (request()->isPost()) {
            $D['uid']=Session::get('User.id');
            $D['company_id']=Session::get('User.company_id');
            $D['resume_id']=$id;
            /*
            *  调用公共获取下载信息方法
            *  app\common\controller\Resume
            */
            return ResumeController::getDownloadsInfo($D);
        }else{
            $D['uid']=Session::get('User.id');
            $D['company_id']=Session::get('User.company_id');
            $D['id']=$id;
            return ResumeController::getDownloadsFile($D);
        }
    }
}
