<?php
namespace app\mobile\controller;
use think\facade\Session;
use think\facade\View;
use think\facade\Cache;
use think\helper\Str;
use GatewayClient\Gateway;
use app\common\variable\MsgCode;
use app\common\controller\Message as MessageController;
use app\common\controller\User as UserController;
use app\common\controller\Resume as ResumeController;
use app\common\model\Resume as ResumeModel;
use app\common\controller\JobsDeliveryResume as JobsDeliveryResumeController;

class Message extends Base
{
    public function myMessage()
    {
        $User=Session::get('User');
        $G=request()->get();
        $G['uid']=$User['id'];
        return MessageController::getList($G);
    }
    public function setMessageRead($id=0)
    {
        $User=Session::get('User');
        $G['id']=$id;
        $G['uid']=$User['id'];
        return MessageController::setMessageRead($G);
    }
    public function getMessageFind($id)
    {
        $User=Session::get('User');
        $G['id']=$id;
        $G['uid']=$User['id'];
        return MessageController::getFind($G);
    }
    public function delMessage($id)
    {
        $User=Session::get('User');
        $G['id']=$id;
        $G['uid']=$User['id'];
        return MessageController::delMessage($G);
    }
    public function joinGroup($client_id)
    {
        $User=Session::get('User');
        if(!$User)
            return $this->ajaxReturn('',MsgCode::$error);
        $MessageClientId=Cache::pull('MessageClientId::'.$client_id);
        if ($MessageClientId==$User['id']) {
            Cache::set('App:uid-'.$User['id'],$client_id);
            Gateway::$registerAddress = config('gateway_worker.registerAddress');
            Gateway::joinGroup($client_id, 'App:uid-'.$User['id']);
            if ($User['role_type']){
                Gateway::joinGroup($client_id, 'App:role-company');
            }else{
                Gateway::joinGroup($client_id, 'App:role-personal');
            }
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('',MsgCode::$error);
        }
    }
    public function getImtoken()
    {
        $time=time();
        $User=Session::get('User');
        if(!$User)
            return $this->ajaxReturn('',MsgCode::$error);
        $ImTokenData=[
            'time'  =>  $time,
            'uid'   =>  $User['id'],
            'token' =>  md5(config('xy_xycms.key').$time.$User['id'].config('xy_xycms.secret').config('xy_xycms.key'))
        ];
        if(config('xy_xycms.key')&&config('xy_xycms.secret')){
            return $this->ajaxReturn('',MsgCode::$success,$ImTokenData);
        }else{
            return $this->ajaxReturn('',MsgCode::$error);
        }
    }
    public function getMessagetoken()
    {
        $User=Session::get('User');
        if(!$User)
            return $this->ajaxReturn('',MsgCode::$error);
        $key=md5('Message:&'.request()->ip().'&'.$User['id'].'&'.time().'&'.Str::random(8));
        Cache::set('Message::'.$key,$User['id']);
        if(config('xy_xycms.key')&&config('xy_xycms.secret')){
            return $this->ajaxReturn('',MsgCode::$success,$key);
        }else{
            return $this->ajaxReturn('',MsgCode::$error);
        }
    }
    public function createContacts()
    {
        $User=Session::get('User');
        $D=request()->post();
        $D['uid']=$User['id'];
        $D['role_type']=$User['role_type'];
        $D['company_id']=$User['company_id'];
        $D['resume_id']=$User['resume_id'];
        return MessageController::createContacts($D);
    }
    public function getIMDataInfo()
    {
        $G=request()->get();
        if (empty($G['type']))
            return $this->ajaxReturn('',MsgCode::$error);
        $User=Session::get('User');
        $User=[
            'id'        =>  $User['id'],
            'role_type' =>  $User['role_type'],
            'company_id'=>  $User['company_id'],
            'resume_id' =>  $User['resume_id'],
        ];
        switch ($G['type']) {
            case 'mobile':
                return UserController::getMobile($User);
            case 'wechat':
                return UserController::getWechat($User);
            case 'resume':
                return $this->ajaxReturn('',MsgCode::$success,ResumeController::getResumeInfo($User['resume_id'],['is_admin'=>1]));
            case 'deliveryResume':
                $D=[
                    'id'        =>  $G['id'],
                    'confirm'   =>  1,
                    'im'        =>  1,
                    'uid'       =>  $G['uid']
                ];
                /*
                *  调用公共投递简历方法
                *  app\common\controller\Resume
                */
                return ResumeController::deliveryResume($D);
            case 'inviteAnInterview':
                break;
            case 'delivery':
                $ResumeModel=ResumeModel::where(['uid'=>$G['touid']])->field('id')->find();
                if($ResumeModel){
                    $where=[
                        ['d.company_id','=',$User['company_id']],
                        ['d.jobs_id','=',$G['jobs_id']],
                        ['d.resume_id','=',$ResumeModel->id],
                        ['d.status','in',[0,1]],
                    ];
                    $JobsDeliveryResumeController=JobsDeliveryResumeController::getCompanyJobsDeliveryResumeFind($User['company_id'],$where);
                    if($JobsDeliveryResumeController){
                        return $this->ajaxReturn('',MsgCode::$success,$JobsDeliveryResumeController);
                    }else{
                        return $this->ajaxReturn('该用户尚未投递简历或你还未将该用户的简历加入待处理',MsgCode::$error);
                    }
                }else{
                    return $this->ajaxReturn('该用户未创建简历',MsgCode::$error);
                }
                break;
            case 'uninterested':
                break;
        }
    }
    public function getUnreadMessage()
    {
        return MessageController::getUnreadMessage(Session::get('User.id'));
    }
}
