<?php
namespace app\mobile\controller;
use think\facade\Session;
use think\facade\Cache;
use think\facade\Db;
use think\helper\Str;
use app\common\variable\MsgCode;
use think\exception\ValidateException;
use app\common\validate\Login as LoginValidate;
use app\common\model\User as UserModel;
use app\common\model\UserVip as UserVipModel;
use app\common\model\UserDevices as UserDevicesModel;
use app\common\model\UserInfo as UserInfoModel;
use app\common\model\UserTimer as UserTimerModel;
use app\common\model\UserLoginLog as UserLoginLogModel;
use app\common\model\UserWx as UserWxModel;
use sendSms\SendSms;
use app\common\UploadFile;
class Login extends Base
{
	public function index()
	{
        $D=request()->post();
        /**
         * 用户验证
         */
        try {
            validate(LoginValidate::class)->scene('login')->check($D);
        } catch (ValidateException $e) {
            return $this->ajaxReturn($e->getError(),MsgCode::$error);
        }
        $where[$D['is_username_type']]=$D['username'];
        $UserPassword=UserModel::getUserPassword($where);
        /*验证密码*/
        if (!$UserPassword) 
            return $this->ajaxReturn('用户不存在',MsgCode::$error);
    	if (UserModel::getPassword($UserPassword['password_hash'],$D['password'])!=$UserPassword['password']) 
            return $this->ajaxReturn('密码不正确',MsgCode::$error);
        /*验证用户状态*/
		$UserInfo=UserModel::getWebUserInfo(['user.id'=>$UserPassword['id']]);
		if (!$UserInfo)
            return $this->ajaxReturn('用户信息不存在',MsgCode::$error);
        if (!$UserInfo['status'])
            return $this->ajaxReturn($UserInfo['disable_msg'],MsgCode::$error);
        $UserTimer = UserTimerModel::where(['uid'=>$UserInfo['id']])->find();
        $UserTimer->online_time=time();
        $UserTimer->online_ip=request()->ip();
        $UserTimer->online_devices=request()->header('xycms-deviceid');
        $UserTimer->login_time=time();
        $UserTimer->login_ip=request()->ip();
        $UserTimer->login_devices=request()->header('xycms-deviceid');
        $UserLoginLog=new UserLoginLogModel;
        $UserLoginLog->uid=$UserInfo->id;
        $UserLoginLog->appid=request()->ApiInfo['app_id'];
        $UserLoginLog->ip=request()->ip();
        $UserLoginLog->devices_id=request()->header('xycms-deviceid');
        $UserWxModel=null;
        if(!empty($D['wx_id'])){
            if($UserInfo->bind_wx)
                return $this->ajaxReturn('该手机号已绑定其他微信',MsgCode::$error);
            $UserWxModel=UserWxModel::where(['id'=>$D['wx_id']])->find();
            if ($UserWxModel->uid
                &&$UserWxModel->uid!=$UserInfo->id)
                return $this->ajaxReturn('该微信已绑定用户，请重新授权登录',MsgCode::$error);
            $UserWxModel->uid=$UserInfo->id;
        }
        $UserQqModel=null;
        if(!empty($D['qq_id'])){
            if($UserInfo->bind_qq)
                return $this->ajaxReturn('该手机号已绑定其他QQ',MsgCode::$error);
            $UserQqModel=UserQqModel::where(['id'=>$D['qq_id']])->find();
            if ($UserQqModel->uid
                &&$UserQqModel->uid!=$UserInfo->id)
                return $this->ajaxReturn('该QQ已绑定用户，请重新授权登录',MsgCode::$error);
            $UserQqModel->uid=$UserInfo->id;
        }
        Db::startTrans();
        try {
            $UserTimer->save();
            $UserLoginLog->save();
            if($UserWxModel)$UserWxModel->save();
            if($UserQqModel)$UserQqModel->save();
            Db::commit();
        	$this->setSuccessLogin($UserInfo);
            return $this->ajaxReturn('登录成功',MsgCode::$success,$UserInfo);
        } catch (Exception $e) {
            Db::rollback();
            return $this->ajaxReturn('登录失败，请重试',MsgCode::$error);
        }
	}
	public function vcode()
	{
        $D=request()->post();
        /**
         * 用户验证
         */
        try {
            validate(LoginValidate::class)->scene('vcode')->check($D);
        } catch (ValidateException $e) {
            return $this->ajaxReturn($e->getError(),MsgCode::$error);
        }
        $SendSms = new SendSms;
        $SendSms->sendType=$D['is_username_type'];
        $SendSms->username=$D['username'];
        $SendSms->vcode=$D['vcode'];
        $SendSms->action=$D['type'];
        if (!$SendSms->verification()) 
            return $this->ajaxReturn($SendSms->getError(),MsgCode::$error);

        $where['user.'.$D['is_username_type']]=$D['username'];
        /*验证用户状态*/
        $UserInfo=UserModel::getWebUserInfo($where);
        if (!$UserInfo)
        	return $this->register($D);
        if (!$UserInfo['status'])
            return $this->ajaxReturn($UserInfo['disable_msg'],MsgCode::$error);
        $UserTimer = UserTimerModel::where(['uid'=>$UserInfo['id']])->find();
        $UserTimer->online_time=time();
        $UserTimer->online_ip=request()->ip();
        $UserTimer->online_devices=request()->header('xycms-deviceid');
        $UserTimer->login_time=time();
        $UserTimer->login_ip=request()->ip();
        $UserTimer->login_devices=request()->header('xycms-deviceid');
        $UserLoginLog=new UserLoginLogModel;
        $UserLoginLog->uid=$UserInfo->id;
        $UserLoginLog->appid=request()->ApiInfo['app_id'];
        $UserLoginLog->ip=request()->ip();
        $UserLoginLog->devices_id=request()->header('xycms-deviceid');
        if (!empty($D['cache']) && $D['cache'])
            $this->cacheUserInfo($UserInfo);
        $UserWxModel=null;
        if(!empty($D['wx_id'])){
            if($UserInfo->bind_wx)
                return $this->ajaxReturn('该手机号已绑定其他微信',MsgCode::$error);
            $UserWxModel=UserWxModel::where(['id'=>$D['wx_id']])->find();
            if ($UserWxModel->uid
                &&$UserWxModel->uid!=$UserInfo->id)
                return $this->ajaxReturn('该微信已绑定用户，请重新授权登录',MsgCode::$error);
            $UserWxModel->uid=$UserInfo->id;
        }
        $UserQqModel=null;
        if(!empty($D['qq_id'])){
            if($UserInfo->bind_qq)
                return $this->ajaxReturn('该手机号已绑定其他QQ',MsgCode::$error);
            $UserQqModel=UserQqModel::where(['id'=>$D['qq_id']])->find();
            if ($UserQqModel->uid
                &&$UserQqModel->uid!=$UserInfo->id)
                return $this->ajaxReturn('该QQ已绑定用户，请重新授权登录',MsgCode::$error);
            $UserQqModel->uid=$UserInfo->id;
        }
        Db::startTrans();
        try {
            $UserTimer->save();
            $UserLoginLog->save();
            if($UserWxModel)$UserWxModel->save();
            if($UserQqModel)$UserQqModel->save();
            Db::commit();
            $SendSms->delVcode();
        	$this->setSuccessLogin($UserInfo);
            return $this->ajaxReturn('登录成功',MsgCode::$success,$UserInfo);
        } catch (Exception $e) {
            Db::rollback();
            return $this->ajaxReturn('登录失败，请重试',MsgCode::$error);
        }
	}
    public function register($D)
    {
        $passHash=Str::random(4);
        /*用户信息*/
        $User=new UserModel;
        $User->mobile=$D['username'];
        $User->password=UserModel::getPassword($passHash,$D['username']);
        $User->password_hash=$passHash;
        /*用户详细信息*/
        $UserInfo=new UserInfoModel;
        $UserWxModel=null;
        if(Session::has('WechatId'))
            $UserWxModel=UserWxModel::where(['id'=>Session::get('WechatId')])->find();
        $UserInfo->headimg=config('xy_default_avatar.user');
        if ($UserWxModel) {
            $UserInfo->nickname=$UserWxModel->nickname;
            $headimg=UploadFile::downWxAvatar($UserWxModel->headimgurl);
            if($headimg['code']===0)
                $UserInfo->headimg=$headimg['data']['path'];
        }else{
            $UserInfo->nickname=base64_encode('XY_'.substr_replace($D['username'],'****',3,4));
        }
        $UserInfo->role_type=0;
        $UserInfo->app_id=request()->ApiInfo['app_id'];
        /*用户时间线*/
        $UserTimer=new UserTimerModel;
        $UserTimer->online_time=time();
        $UserTimer->online_ip=request()->ip();
        $UserTimer->online_devices=request()->header('xycms-deviceid');
        $UserTimer->login_time=time();
        $UserTimer->login_ip=request()->ip();
        $UserTimer->login_devices=request()->header('xycms-deviceid');
        $UserTimer->register_time=time();
        $UserTimer->register_ip=request()->ip();
        $UserTimer->register_devices=request()->header('xycms-deviceid');
        $UserVipModel=new UserVipModel;
        // 启动事务
        Db::startTrans();
        try {
            $User->save();
            $UserInfo->uid=$User->id;
            $UserTimer->uid=$User->id;
            $UserVipModel->uid=$User->id;
            if($UserWxModel){
                $UserWxModel->uid=$User->id;
                $UserWxModel->save();
            }
            $UserVipModel->save();
            $UserInfo->save();
            $UserTimer->save();
            // 提交事务
            Db::commit();
        } catch (\Exception $e) {
            // 回滚事务
            Db::rollback();
            return $this->ajaxReturn('注册失败，请重试',MsgCode::$error);
        }
        $where['user.id']=$User->id;
        $UserInfo=UserModel::getWebUserInfo($where);
        $this->setSuccessLogin($UserInfo);
        return $this->ajaxReturn('注册成功',MsgCode::$success,$UserInfo);
    }
    public function getVcode()
    {
        $D=request()->post();
        /**
         * 用户验证
         */
        try {
            validate(LoginValidate::class)->scene('getCode')->check($D);
        } catch (ValidateException $e) {
            return $this->ajaxReturn($e->getError(),MsgCode::$error);
        }
        switch ($D['is_username_type']) {
            case 'email':
                $msg=LoginValidate::VerificationEmailSendSum($D['username']);
                if($msg) return $this->ajaxReturn($msg,MsgCode::$error);
                break;
            case 'mobile':
                $msg=LoginValidate::VerificationMobileSendSum($D['username']);
                if($msg) return $this->ajaxReturn($msg,MsgCode::$error);
                break;
            default:
                return $this->ajaxReturn('未知的验证方式',MsgCode::$error);
                break;
        }
        $SendSms = new SendSms;
        $SendSms->sendType=$D['is_username_type'];
        $SendSms->username=$D['username'];
        $SendSms->action=$D['type'];
        if($SendSms->sendVcode()){
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn($SendSms->getError(),MsgCode::$error);
        }
    }
    public function verificationVcode()
    {
        $D=request()->post();
        /**
         * 用户验证
         */
        try {
            validate(LoginValidate::class)->scene('verificationVcode')->check($D);
        } catch (ValidateException $e) {
            return $this->ajaxReturn($e->getError(),MsgCode::$error);
        }
        $SendSms = new SendSms;
        $SendSms->sendType=$D['is_username_type'];
        $SendSms->username=$D['username'];
        $SendSms->vcode=$D['vcode'];
        $SendSms->action=$D['type'];
        if ($SendSms->verification()) {
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn($SendSms->getError(),MsgCode::$error);
        }
    }
    public function setSuccessLogin($UserInfo)
    {
        $key=md5('Message:&'.request()->ip().'&'.$UserInfo->id.'&'.time().'&'.Str::random(8));
        $UserInfo->token=$key;
        $UserInfo->client_id=[];
        Session::set('User',$UserInfo->toArray());
        Cache::set('Message::'.$key,$UserInfo->id);
    }
    public function getDefaultUserInfo()
    {
    	if ($uid=Session::get('User.id')) {
	        $where['user.id']=$uid;
	        $UserInfo=UserModel::getWebUserInfo($where);
	        $this->setSuccessLogin($UserInfo);
	        return $this->ajaxReturn('成功',MsgCode::$success,$UserInfo);
    	}
        return $this->ajaxReturn('',MsgCode::$error);
    }
}