<?php
namespace app\mobile\controller;
use think\facade\Session;
use think\facade\Cache;
use think\facade\Cookie;
use app\common\variable\MsgCode;
use app\common\controller\Jobs as JobsController;
use app\common\controller\JobsDeliveryResume as JobsDeliveryResumeController;
use app\common\model\Jobs as JobsModel;
use app\common\model\JobsDeliveryResume as JobsDeliveryResumeModel;
use app\common\model\JobsBrowse as JobsBrowseModel;
class Jobs extends Base
{
    public function index($id)
    {
        $G=[
            'uid'       =>  Session::get('User.id'),
            'resume_id' =>  Session::get('User.resume_id'),
            'html'      =>  false,
        ];
        $Find=JobsController::getJobsInfo($id,$G);
        if ($Find) {
            /*记录访客*/
            JobsBrowseModel::saveBrowse($G['resume_id'],$Find->company_id,$Find->id);
            return $this->ajaxReturn('',MsgCode::$success,$Find);
        }else{
            return $this->ajaxReturn('不存在该职位',MsgCode::$error);
        }
    }
    /**
     * 发布职位
     */
    public function release()
    {
        $User=Session::get('User');
        $G=[
            'uid'       =>  $User['id'],
            'resume_id' =>  $User['resume_id'],
            'html'      =>  false,
        ];
        if (request()->isPost()) {
            $D=request()->post();
            $D['uid']=$User['id'];
            $D['app_id']=request()->ApiInfo['app_id'];
            /*
            *  调用公共保存职位方法
            *  app\common\controller\Jobs
            */
            return JobsController::releaseJobs($D);
        }
    }
    public function getCompanyJobsBrowse()
    {
        $User=Session::get('User');
        $D=request()->get();
        $D['uid']=$User['id'];
        $D['company_id']=$User['company_id'];
        $Data=JobsController::getCompanyJobsBrowse($D);
        if ($Data->items()) {
            return $this->ajaxReturn('',MsgCode::$success,$Data);
        }else{
            return $this->ajaxReturn('暂无数据~',MsgCode::$error);
        }
    }

    public function management()
    {
        $User=Session::get('User');
    	if ($User['role_type']){
            $G=request()->get();
            $where=[];
            if (!empty($G['status']) && $G['status']!='all'){
                if ($G['status']=='none') {
                    $where[]=['jobs.status','=',0];
                }elseif ($G['status']=='publishing') {
                    $where[]=['jobs.status','=',1];
                }
            }
            $Jobs=JobsController::getCompanyJobsList($User['company_id'],$where);
            return $this->ajaxReturn('',MsgCode::$success,$Jobs);
    	}else{
            $G=request()->get();
            if ($G['status']=='positions_viewed') {
                $JobsBrowse=JobsController::getPersonalJobsBrowse($User['resume_id']);
                return $this->ajaxReturn('',MsgCode::$success,$JobsBrowse);
            }else{
                $where=[];
                switch ($G['status']) {
                    case 'position_see':
                        $where[]=['d.status','=',1];
                        break;
                    case 'position_inappropriate':
                        $where[]=['d.status','=',2];
                        break;
                    case 'interview_invitation':
                        $where[]=['d.status','=',3];
                        break;
                    case 'wait_interview_invitation':
                        $where[]=['d.status','=',4];
                        break;
                    case 'offer':
                        $where[]=['d.status','=',5];
                        break;
                    case 'position_applied':
                        break;
                }
                $JobsDeliveryResume=JobsDeliveryResumeController::getPersonalJobsDeliveryResume($User['id'],$where);
                return $this->ajaxReturn('',MsgCode::$success,$JobsDeliveryResume);

            }
    	}
    }
    public function toggleJobsCollection($id)
    {
        $User=Session::get('User');
        $D=[
            'uid'       =>  $User['id'],
            'resume_id' =>  $User['resume_id'],
            'jobs_id'   =>  $id
        ];
        return JobsController::toggleJobsCollection($D);
    }
    public function setJobsStatus($id,$status)
    {
        $User=Session::get('User');
        $D=[
            'uid'       =>  $User['id'],
            'company_id'=>  $User['company_id'],
            'id'        =>  $id,
            'status'    =>  $status
        ];
        return JobsController::setJobsStatus($D);
    }
    public function setJobsRefreshTime($id)
    {
        $User=Session::get('User');
        $D=[
            'uid'       =>  $User['id'],
            'company_id'=>  $User['company_id'],
            'id'        =>  $id
        ];
        return JobsController::setJobsRefreshTime($D);
    }
    public function setCompanyJobsRefreshTime()
    {
        $User=Session::get('User');
        $D=[
            'uid'       =>  $User['id'],
            'company_id'=>  $User['company_id']
        ];
        return JobsController::setCompanyJobsRefreshTime($D);
    }
    public function saveJobs($id)
    {
        $User=Session::get('User');
        if (request()->isPost()) {
            $D=request()->post();
            $D['uid']=$User['id'];
            $D['id']=$id;
            /*
            *  调用公共保存职位方法
            *  app\common\controller\Jobs
            */
            return JobsController::saveJobs($D);
        }
    }
    public function getJobsInfo($id)
    {
        $User=Session::get('User');
        $D=[
            'id'        =>  $id,
            'company_id'=>  $User['company_id']
        ];
        $form=JobsController::getJobsInfoAll($D);
        if($form){
            $G=[
                'html'      =>  false,
                'is_admin'  =>  1
            ];
            $Find=JobsController::getJobsInfo($id,$G);
            return $this->ajaxReturn('',MsgCode::$success,['form'=>$form,'Find'=>$Find]);
        }else{
            return $this->ajaxReturn('不存在该职位',MsgCode::$error);
        }
    }
}
