<?php
namespace app\mobile\controller;
use think\facade\Cache;
use think\facade\Cookie;
use think\facade\Session;
use app\common\variable\MsgCode;
use app\common\controller\JobFair as JobFairController;
class JobFair extends Base
{
    public function index()
    {
        $G=request()->get();
        $Data=JobFairController::getList($G);
        if($Data->items()){
            return $this->ajaxReturn('',MsgCode::$success,$Data);
        }else{
            return $this->ajaxReturn('暂无招聘会',MsgCode::$error);
        }
    }
    public function detail($id)
    {
        $where=[];
        $where[]=['job.id','=',$id];
        $Find=JobFairController::getFind($where);
        if($Find){
            return $this->ajaxReturn('',MsgCode::$success,$Find);
        }else{
            return $this->ajaxReturn('暂无招聘会',MsgCode::$error);
        }
    }
    public function getJobsList()
    {
        $User=Session::get('User');
        $G=request()->get();
        $G['uid']=$User['id'];
        $G['resume_id']=$User['resume_id'];
        return JobFairController::getJobsList($G);
    }
    public function getResumeList()
    {
        $User=Session::get('User');
        $G=request()->get();
        $G['uid']=$User['id'];
        $G['company_id']=$User['company_id'];
        return JobFairController::getResumeList($G);
    }
    public function getCompanyList()
    {
        $G=request()->get();
        if(empty($G['id']))
            return $this->ajaxReturn('',-100);
        $where=[];
        $where[]=['job.jid','=',$G['id']];
        if (!empty($G['key']))
            $where[]=['c.title','like','%'.$G['key'].'%'];
        if (!empty($G['bid']))
            $where[]=['job.bid','=',$G['bid']];
        if (!empty($G['booth']))
            $where[]=['booth.identifier','=',$G['booth']];
        return JobFairController::getCompanyList($where);
    }
}
