<?php
namespace app\mobile\controller;
use think\facade\View;
use think\facade\Cache;
use think\facade\Cookie;
use think\facade\Session;
use think\Response;
use think\exception\HttpResponseException;
use app\common\controller\Pay as PayController;
use app\common\controller\Orders as OrdersController;
use app\common\model\NotifyApplepay as NotifyApplepayModel;
use app\common\model\Orders as OrdersModel;
use app\common\model\PushTask as PushTaskModel;
use app\common\model\UserWx as UserWxModel;
class Index
{
    public function index()
    {
        if(!request()->isMobile())
            throw new HttpResponseException(Response::create(config('web.url'),'redirect',302));
        View::assign('appName',config('web.name'));
        return View::fetch();
    }
    public function isWx()
    {
    	return strpos(strtolower(request()->header('user-agent')),'micromessenger');
    }
    public function getH5AlipayForm()
    {
        $User=Session::get('User');
        $D=request()->get();
        $D['uid']=$User['id'];
        $D['pay_type']='alipay';
        $D['company_id']=Session::get('User.company_id');
        $D['resume_id']=Session::get('User.resume_id');
        $D['channel_type']=request()->ApiInfo['app_id'];
        $D['app']='h5';
        return PayController::getOrderInfoByOtrade($D);
    }
}
