<?php
namespace app\mobile\controller;
use think\facade\Session;
use think\facade\Cache;
use think\facade\Cookie;
use app\common\variable\MsgCode;
use app\common\controller\Company as CompanyController;
use app\common\controller\Jobs as JobsController;
use app\common\model\Company as CompanyModel;
use app\common\model\CompanyBrowse as CompanyBrowseModel;
use app\common\model\CompanyDemeanor as CompanyDemeanorModel;
class Company extends Base
{
    public function index($id)
    {
        $G=[
            'uid'       =>  Session::get('User.id'),
            'resume_id' =>  Session::get('User.resume_id'),
            'company_id'=>  $id,
            'html'      =>  false,
        ];
        $Find=CompanyController::getCompanyInfo($id,$G);
        if ($Find) {
            /*记录访客*/
            CompanyBrowseModel::saveBrowse([
                'uid'=>Session::get('User.id'),
                'role_type'=>Session::get('User.role_type'),
                'resume_id'=>Session::get('User.resume_id'),
                'company_id'=>Session::get('User.company_id')
            ],$id);
            $Data=JobsController::getJobsList($G);
            $CompanyDemeanorModel=CompanyDemeanorModel::getCompanyDemeanorIsExamine($id);
            $Find['CompanyDemeanor']=$CompanyDemeanorModel;
            return $this->ajaxReturn('',MsgCode::$success,$Find);
        }else{
            return $this->ajaxReturn('不存在该企业',MsgCode::$error);
        }
    }
    public function getCompanyInfo()
    {
        $User=Session::get('User');
        $G=request()->get();
        if(!empty($G['find']) && $G['find']){
	        $CompanyInfo=CompanyController::getCompanyInfo($User['company_id'],['html'=>0,'is_admin'=>1]);
        }else{
            $CompanyInfo=CompanyModel::getEditFind($User['company_id']);
        }
        if($CompanyInfo){
            return $this->ajaxReturn('',MsgCode::$success,$CompanyInfo);
        }else{
            return $this->ajaxReturn('',MsgCode::$error);
        }
    }
    public function saveCompany()
    {
        if (request()->isPost()) {
        	$User=Session::get('User');
            $D=request()->post();
            $D['uid']=$User['id'];
            /*
            *  调用公共保存企业方法
            *  app\common\controller\Company
            */
            return CompanyController::saveCompany($D);
        }
    }
    public function toggleCompanyCollection($id)
    {
        $User=Session::get('User');
        $D=[
            'uid'       =>  $User['id'],
            'resume_id' =>  $User['resume_id'],
            'company_id'=>  $id
        ];
        return CompanyController::toggleCompanyCollection($D);
    }
    /**
     * demeanor 企业风采
     */
    public function demeanor()
    {
        $User=Session::get('User');
        $CompanyDemeanorModel=CompanyDemeanorModel::getCompanyDemeanor($User['company_id']);
        if($CompanyDemeanorModel){
            return $this->ajaxReturn('',MsgCode::$success,$CompanyDemeanorModel);
        }else{
            return $this->ajaxReturn('',MsgCode::$error);
        }
    }
    /**
     * 保存企业风采
     */
    public function saveDemeanor()
    {
        $User=Session::get('User');
        $D=request()->post();
        $D['company_id']=$User['company_id'];
        /*
        *  调用公共保存企业风采方法
        *  app\common\controller\Resume
        */
        return CompanyController::saveDemeanor($D);
    }
    /**
     * 保存企业风采备注
     */
    public function saveDemeanorTitle($id)
    {
        $User=Session::get('User');
        $G=request()->get();
        $G['id']=$id;
        $G['company_id']=$User['company_id'];
        /*
        *  调用公共保存企业风采备注方法
        *  app\common\controller\Resume
        */
        return CompanyController::saveDemeanorTitle($G);
    }
    /**
     * 删除企业风采
     */
    public function delCompanyDemeanor($id)
    {
        $User=Session::get('User');
        $D=[
            'id'            =>  $id,
            'company_id'    =>  $User['company_id']
        ];
        /*
        *  调用公共删除企业风采方法
        *  app\common\controller\Resume
        */
        return CompanyController::delCompanyDemeanor($D);
    }
    /**
     * 删除企业发展历程
     */
    public function delDevelopmentHistory($id)
    {
        $User=Session::get('User');
        $D=[
            'id'            =>  $id,
            'company_id'    =>  $User['company_id']
        ];
        /*
        *  调用公共删除企业发展历程方法
        *  app\common\controller\Resume
        */
        return CompanyController::delDevelopmentHistory($D);
    }
    public function getSearchCompany()
    {
        $D=[
            'uid'       =>  Session::get('User.id'),
            'resume_id' =>  Session::get('User.resume_id'),
            'key'       =>  request()->get('key')
        ];
        return CompanyController::getSearchCompany($D);
    }
}
