<?php
use think\facade\Route;
//首页
Route::rule('/','index/Index/index');
//登录
Route::rule('login','index/Login/index');
//注册
Route::rule('register','index/Login/register');
//注销登录
Route::rule('outLogin','index/Base/outLogin');
//获取验证码
Route::post('getVcode','index/Login/getVcode');
//验证码登录
Route::rule('login/vcode','index/Login/vcode');
//验证短信验证码
Route::post('verificationVcode','index/Login/verificationVcode');
//个人中心
Route::rule('user','index/User/index');
//系统维护
Route::rule('system/maintenance','index/Index/maintenance');
//账户管理
Route::rule('user/account','index/User/account');
//企业风采
Route::rule('user/company/demeanor','index/User/demeanor');
//用户认证
Route::rule('user/attestation','index/User/attestation');
//账户安全
Route::rule('user/security','index/User/security');
//获取登录日志
Route::get('user/getLoginLog','index/Log/getLoginLog');
//我的消息
Route::rule('user/myMessage','index/Message/myMessage');
//发布职位
Route::rule('user/jobs/release','index/Jobs/release');
//找工作
Route::rule('jobs','index/Search/jobHunting');
//招人才
Route::rule('resume','index/Search/recruitTalents');
//找公司
Route::rule('company','index/Search/seekCompany');
//资讯
Route::get('article/type/[:alias]','index/Article/getAlias')->ext('html');
//我们的服务
Route::rule('more-server','index/Search/moreServer');
//求职管理
Route::rule('user/jobs/management','index/Jobs/management');
//收藏和关注
Route::rule('user/follow','index/User/follow');
//会员服务
Route::rule('user/vip/server','index/Vip/server');
//招聘效果统计
Route::rule('user/jobs/recruitEffectCount','index/Jobs/recruitEffectCount');
//我的打赏
Route::rule('user/jobs/expenditureGratuity','index/Jobs/expenditureGratuity');
//简历管理
Route::rule('user/resume/management','index/Resume/management');
//面试邀请
Route::rule('user/resume/interview-invitation','index/Resume/interviewInvitation');
//视频面试
Route::rule('user/resume/video-interview','index/Resume/videoInterview');
//已下载的简历
Route::rule('user/resume/resume-downloaded','index/Resume/resumeDownloaded');
//收藏的简历
Route::rule('user/resume/collected-resume','index/Resume/collectedResume');
//浏览过的简历
Route::rule('user/resume/reviewed-resume','index/Resume/reviewedResume');
//谁看过我
Route::rule('user/who-saw-me','index/User/whoSawMe');
//公司详情
Route::rule('company/:id','index/Company/index')->ext('html');
//职位详情
Route::rule('jobs/:id','index/Jobs/index')->ext('html');
//文章详情
Route::rule('article/content/:id','index/Article/content')->ext('html');
//文章分类列表
Route::rule('article/classify','index/Article/classifyList');
//查看简历
Route::rule('resume/:id','index/Resume/index')->ext('html');
//保存简历
Route::rule('user/saveResume','index/Resume/saveResume');
//删除简历经历
Route::get('user/resume/delExperience/:type/:id','index/Resume/delExperience');
//保存企业信息
Route::rule('user/company/saveCompany','index/Company/saveCompany');
//发布职位
Route::rule('user/jobs/release','index/Jobs/release');
//编辑职位
Route::rule('user/jobs/saveJobs/:id','index/Jobs/saveJobs');
//投递简历
Route::get('deliveryResume/:id','index/Resume/deliveryResume');
//搜索工作
Route::get('search/jobs','index/Search/searchJobs');
//设置投递简历状态-不合适
Route::get('user/resume/setResumeInappropriate/:id','index/Resume/setResumeInappropriate');
//投递简历-面试邀请
Route::post('user/resume/inviteAnInterview','index/Resume/inviteAnInterview');
//接受面试邀请
Route::rule('user/interview/handleInterviewInvitation/:status/:id','index/Interview/handleInterviewInvitation');
//切换到企业用户
Route::get('user/goToCompany','index/User/goToCompany');
//切换到个人用户
Route::get('user/goToPersonal','index/User/goToPersonal');
//搜索企业
Route::get('search/company','index/Search/searchCompany');
//搜索简历
Route::get('search/resume','index/Search/searchResume');
//职位分类
Route::rule('jobs/all-jobs-cate','index/Jobs/allJobsCate');
//通用上传接口
Route::post('uploadFiles','index/Uploads/uploadFiles');
//下载简历
Route::rule('downloads/resume/:id','index/Resume/downloads');
//统一下单
Route::post('pay/generateOrderInfo','index/Pay/generateOrderInfo');
//删除企业发展历程
Route::get('user/company/delDevelopmentHistory/:id','index/Company/delDevelopmentHistory');
//保存企业风采
Route::post('user/company/saveDemeanor','index/Company/saveDemeanor');
//保存企业风采备注
Route::get('user/company/saveDemeanorTitle/:id/:title','index/Company/saveDemeanorTitle');
//删除企业风采
Route::get('user/company/delCompanyDemeanor/:id','index/Company/delCompanyDemeanor');
//设置职位状态
Route::get('user/jobs/setStatus/:id/:status','index/Jobs/setJobsStatus');
//职位刷新
Route::get('user/jobs/setRefreshTime/:id','index/Jobs/setJobsRefreshTime');
//删除投递简历
Route::get('user/resume/delDeliveryResume/:id','index/Resume/delDeliveryResume');
//删除简历下载记录
Route::get('user/resume/delDownloadResume/:id','index/Resume/delDownloadResume');
//删除收藏的简历
Route::get('user/resume/delCollectedResume/:id','index/Resume/delCollectedResume');
//删除简历浏览记录
Route::get('user/resume/delBrowseResume/:id','index/Resume/delBrowseResume');
//获取简历管理统计
Route::get('user/resume/statistics','index/Resume/statistics');
//用户中心统计
Route::get('user/statistics','index/User/statistics');
//获取个人中心人才推荐
Route::get('user/getRecommendResume','index/User/getRecommendResume');
//设置简历头像是否公开
Route::get('user/resume/setResumeHeadimgStatus/:status','index/Resume/setResumeHeadimgStatus');
//设置简历隐私状态
Route::get('user/resume/setResumePrivacy/:status','index/Resume/setResumePrivacy');
//职位关注
Route::get('jobs/toggleJobsCollection/:id','index/Jobs/toggleJobsCollection');
//企业关注
Route::get('company/toggleCompanyCollection/:id','index/Company/toggleCompanyCollection');
//QQ登录回调
Route::rule('login/qq/callback','index/Results/qqLoginCallback');
//微信登录回调
Route::rule('login/wx/callback','index/Results/wxLoginCallback');
//我的积分
Route::rule('user/vip/my-points','index/Vip/myPoints');
//我的订单
Route::rule('user/vip/orders','index/Vip/orders');
//模板切换
Route::rule('user/vip/template-toggle','index/Vip/templateToggle');
//招聘外包
Route::rule('user/vip/outsource','index/Vip/outsource');
//优惠券
Route::rule('user/vip/coupon','index/Vip/coupon');
//招聘会
Route::rule('user/job-fair/apply','index/JobFair/apply');
//增值服务
Route::rule('user/vip/value-added','index/Vip/valueAdded');
//定展记录
Route::rule('user/job-fair/record','index/JobFair/record');
//字符串转二维码
Route::get('displayQrcode','index/Uploads/displayQrcode');
//第三方登录
Route::rule('login/[:type]','index/ThirdPartyLogin/thirdParty');
//QQ登录回调
Route::rule('third-party/login/qq','index/ThirdPartyLogin/qqCallback');
//微信登录回调
Route::rule('third-party/login/wx','index/ThirdPartyLogin/wxCallback');
//加入消息长链接ID组
Route::get('joinMessageGroup/:client_id','index/Message/joinGroup');
//通过订单号获取支付信息
Route::post('pay/getOrderInfoByOtrade','index/Pay/getOrderInfoByOtrade');
//取消订单
Route::post('pay/cancelOrder','index/Pay/cancelOrder');
//删除订单
Route::post('pay/delOrder','index/Pay/delOrder');
//我的积分
Route::rule('user/score','index/User/score');
//领取积分任务奖励
Route::get('user/receiveScore/:id','index/Score/receiveScore');
//积分统计
Route::get('user/score/statistics','index/Score/statistics');
//获取消息内容
Route::get('user/message/getContent/:id','index/Message/getMessageFind');
//设置消息为已读
Route::get('user/message/setRead/:id','index/Message/setMessageRead');
//删除消息
Route::get('user/message/del/:id','index/Message/delMessage');
//每日签到
Route::get('user/score/signInToday','index/Score/signInToday');
//我的权益
Route::get('user/vip/getMyRights','index/Vip/getMyRights');
//用户上传简历作品
Route::rule('user/resume/works','index/Resume/resumeWorks');
//保存简历作品
Route::post('user/resume/saveResumeWorks','index/Resume/saveResumeWorks');
//保存简历作品备注
Route::get('user/resume/saveResumeWorksTitle/:id/:title','index/Resume/saveResumeWorksTitle');
//删除简历作品
Route::get('user/resume/delResumeWorks/:id','index/Resume/delResumeWorks');
//发票管理
Route::rule('user/vip/invoice','index/Vip/invoice');
//保存发票抬头
Route::post('user/invoice/saveInvoiceTitle','index/Invoice/saveInvoiceTitle');
//删除发票抬头邮寄地址
Route::get('user/invoice/delInvoiceTitleMailAddress/:id','index/Invoice/delInvoiceTitleMailAddress');
//索取发票
Route::post('user/invoice/applyInvoice','index/Invoice/applyInvoice');
//关注简历
Route::get('resume/toggleResumeCollection/:id','index/Resume/toggleResumeCollection');
//反馈
Route::rule('feedback','index/Feedback/feedback');
//聊天拉取信息
Route::get('im/getIMDataInfo','index/Message/getIMDataInfo');
//获取登录二维码
Route::get('loginQrcode','index/Login/loginQrcode');
//扫码登陆后获取用户信息
Route::get('qrlogin/:client_id/:to_client_id','index/Login/qrlogin');
//职位刷新-所有
Route::get('user/jobs/setCompanyJobsRefreshTime','index/Jobs/setCompanyJobsRefreshTime');
//创建聊天联系人
Route::post('im/createContacts','index/Message/createContacts');
//获取简历联系方式
Route::get('resume/getContactsData/:id','index/Resume/getContactsData');
//获取职位联系方式
Route::get('jobs/getContactsData/:id','index/Jobs/getContactsData');
//验证码
Route::get('captcha','index/Login/captcha');
//APP下载二维码
Route::get('qrcode/appdown','index/Uploads/getAppdown');
//招聘会
Route::rule('job-fair','index/JobFair/index')->ext('html');
//事业单位招聘
Route::get('article/government_institutions','index/Article/governmentInstitutions')->ext('html');
//招聘会详情
Route::rule('job-fair/detail/:id','index/JobFair/detail')->ext('html');
//获取招聘会企业
Route::get('job-fair/getCompanyList','index/JobFair/getCompanyList');
//获取招聘会职位
Route::get('job-fair/getJobsList','index/JobFair/getJobsList');
//获取招聘会人才
Route::get('job-fair/getResumeList','index/JobFair/getResumeList');
//下载网站快捷方式
Route::get('down/InternetShortcut','index/Index/downInternetShortcut');
//获取未读消息条数
Route::get('getUnreadMessage','index/Message/getUnreadMessage');
//获取黑名单
Route::get('user/getBlacklist','index/User/getBlacklist');
//设置黑名单
Route::post('user/setBlacklist','index/User/setBlacklist');
//搜索公司
Route::get('user/getSearchCompany','index/Company/getSearchCompany');
//搜索简历
Route::get('user/getSearchResume','index/Resume/getSearchResume');
//取消黑名单
Route::get('user/cancelBlacklist/:id','index/User/cancelBlacklist');
//更换绑定手机
Route::rule('user/editMobile','index/User/editMobile');
//更换绑定邮箱
Route::rule('user/editEmail','index/User/editEmail');
//异步获取数据
Route::get('ajax/:type','index/Ajax/index');
//帮助中心
Route::rule('common-problem','index/Article/commonProblem');
//刷新简历
Route::get('user/resume/setResumeRefreshTime','index/Resume/setResumeRefreshTime');
//海报列表
Route::get('user/poster','index/Posters/getList');
//生成海报
Route::post('user/getPoster','index/Posters/getPoster');
//分站
Route::rule('subsite/[:alias]','index/Index/sub_website');
//地图找工作
Route::rule('map','index/Index/map_jobs');
//委托投递
Route::get('user/resume/setAutoConsignment','index/Resume/setAutoConsignment');
//绑定账户
Route::rule('bind','index/Login/bind');
