<?php
namespace app\index\controller;
use think\facade\View;
use think\facade\Cache;
use think\facade\Cookie;
use think\facade\Session;
use app\common\controller\Orders as OrdersController;
use app\common\controller\UserScore as UserScoreController;
use app\common\controller\Score as ScoreController;
use app\common\controller\Vip as VipController;
use app\common\controller\Invoice as InvoiceController;
use app\common\controller\Coupon as CouponController;
class Vip extends Base
{
    public function server()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
        	return View::fetch('company_server');
    	}else{
	        return View::fetch('personal_server');
    	}
    }
    public function myPoints()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
            if (request()->isAjax()) {
                $G=request()->get();
                $G['uid']=$User['id'];
                if ($G['type']=='score') {
                    return UserScoreController::getList($G);
                }elseif ($G['type']=='score_task') {
                    return ScoreController::getScoreTaskList($User['id'],$User['role_type']);
                }
            }
        	return View::fetch('company_my_points');
    	}else{
            return redirect('/user/score');
    	}
    }
    public function valueAdded()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
        	return View::fetch('company_value_added');
    	}else{
            return redirect('/user');
	        return View::fetch('personal_value_added');
    	}
    }
    public function orders()
    {
        $User=Session::get('User');
        if ($User['role_type']){
            if (request()->isAjax()) {
                $G=request()->get();
                $G['uid']=$User['id'];
                return OrdersController::getSelect($G);
            }
            return View::fetch('company_orders');
        }else{
            return redirect('/user/vip/server');
        }
    }
    public function invoice()
    {
        $User=Session::get('User');
        if ($User['role_type']){
            if (request()->isAjax()) {
                $G=request()->get();
                if ($G['type']=='order') {
                    return OrdersController::getInvoiceSelect($User['id'],$G['all_selected']);
                }else{
                    return InvoiceController::getPage($User['id']);
                }
            }
            View::assign('Find',InvoiceController::getInvoice($User['id']));
            return View::fetch('company_invoice');
        }else{
            return View::fetch('personal_invoice');
        }
    }
    public function templateToggle()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
        	return View::fetch('company_template_toggle');
    	}else{
	        return View::fetch('personal_template_toggle');
    	}
    }
    public function outsource()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
        	return View::fetch('company_outsource');
    	}else{
            return redirect('/user/vip/server');
    	}
    }
    public function coupon()
    {
    	$User=Session::get('User');
        if (request()->isAjax()) {
            $D=request()->get();
            $D['uid']=$User['id'];
            return CouponController::getList($D);
        }
    	if ($User['role_type']){
        	return View::fetch('company_coupon');
    	}else{
	        return View::fetch('personal_coupon');
    	}
    }
    public function jobFair()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
        	return View::fetch('company_job_fair');
    	}else{
	        return View::fetch('personal_job_fair');
    	}
    }
    public function getMyRights()
    {
        if (request()->isAjax()) {
            $User=Session::get('User');
            $G=request()->get();
            $G['uid']=$User['id'];
            $G['company_id']=$User['company_id'];
            if ($G['type']=='rights') {
                return VipController::getMyRights($G);
            }else if ($G['type']=='detailed') {
                return VipController::getMyRightsDetailed($G);
            }
        }
    }
}
