<?php
namespace app\index\controller;
use think\facade\View;
use think\facade\Session;
use think\facade\Cache;
use think\helper\Str;
use think\facade\Db;
use app\common\variable\MsgCode;
use app\common\controller\Resume as ResumeController;
use app\common\controller\Company as CompanyController;
use app\common\controller\CompanyAttestation as CompanyAttestationController;
use app\common\controller\JobsCollection as JobsCollectionController;
use app\common\controller\CompanyCollection as CompanyCollectionController;
use app\common\controller\User as UserController;
use app\common\controller\UserScore as UserScoreController;
use app\common\controller\Score as ScoreController;
use app\common\model\User as UserModel;
use app\common\model\UserInfo as UserInfoModel;
use app\common\model\Company as CompanyModel;
use app\common\model\CompanyDemeanor as CompanyDemeanorModel;
use app\common\model\StatusAlias as StatusAliasModel;
use app\common\model\CompanyAttestation as CompanyAttestationModel;
class User extends Base
{
    /**
     * index 个人中心
     */
    public function index()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
            $CompanyInfo=CompanyController::getCompanyInfo($User['company_id'],['is_admin'=>1]);
            View::assign('Find',$CompanyInfo);
            $attestation=StatusAliasModel::getCate('company/attestation');
            View::assign('attestation',$attestation);
	        return View::fetch('company');
    	}else{
            View::assign('Find',ResumeController::getResumeInfoAll($User['id']));
            View::assign('webtitle','我的简历');
	        return View::fetch('personal');
    	}
    }
    public function statistics()
    {
        $User=Session::get('User');
        $D=[
            'role_type' =>  Session::get('User.role_type'),
            'company_id'=>  Session::get('User.company_id'),
            'resume_id' =>  Session::get('User.resume_id'),
            'uid'       =>  Session::get('User.id')
        ];
        /*
        *  调用公共用户中心统计方法
        *  app\common\controller\Resume
        */
        return UserController::statistics($D);
    }
    /**
     * account 账户管理
     */
    public function account()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
            $CompanyModel=CompanyModel::where(['uid'=>$User['id']])->find();
            if ($CompanyModel) {
                $Find=CompanyModel::getEditFind($CompanyModel->id);
                View::assign('Find',$Find);
            }
	        return View::fetch('company_account');
    	}else{
            return redirect('/user/security');
    	}
    }
    /**
     * score 我的积分
     */
    public function score()
    {
        $User=Session::get('User');
        if ($User['role_type']){
            return redirect('/user/vip/my-points');
        }else{
            if (request()->isAjax()) {
                $G=request()->get();
                $G['uid']=$User['id'];
                if ($G['type']=='score') {
                    return UserScoreController::getList($G);
                }elseif ($G['type']=='score_task') {
                    return ScoreController::getScoreTaskList($User['id'],$User['role_type']);
                }
            }
            return View::fetch('personal_score');
        }
    }
    /**
     * demeanor 企业风采
     */
    public function demeanor()
    {
        $User=Session::get('User');
        if ($User['role_type']){
            $CompanyDemeanorModel=CompanyDemeanorModel::getCompanyDemeanor($User['company_id']);
            if ($CompanyDemeanorModel) {
                View::assign('list',$CompanyDemeanorModel);
                $list_img=CompanyDemeanorModel::where(['cid'=>$User['company_id']])->field('path as url')
                    ->withAttr('url',function($v,$data){
                        return config('web.imgurl').$v;
                    })->column('path');
                View::assign('list_img',$list_img);
            }
            return View::fetch('company_demeanor');
        }else{
            return redirect('/user/resume/works');
        }
    }
    /**
     * attestation 用户认证
     */
    public function attestation()
    {
        $User=Session::get('User');
        if ($User['role_type']){
            if (request()->isPost()) {
                $D=request()->post();
                $D['uid']=$User['id'];
                $D['id_type']=1;
                return UserController::saveRealNameApply($D);
            }
            $CompanyModel=CompanyController::getCompanyInfo($User['company_id'],['is_admin'=>1]);
            View::assign('Company',$CompanyModel);
            $CompanyContacts=CompanyModel::getContacts(['company.id'=>$User['company_id']]);
            View::assign('CompanyContacts',$CompanyContacts);
            View::assign('attestation_ms',config('xy_company.attestation_ms'));
            $Find=UserController::getRealNameApply(['uid'=>$User['id'],'id_type'=>1]);
            View::assign('Find',$Find);
            return View::fetch('company_attestation');
        }else{
            if (request()->isPost()) {
                $D=request()->post();
                $D['uid']=$User['id'];
                $D['id_type']=0;
                return UserController::saveRealNameApply($D);
            }
            $Find=UserController::getRealNameApply(['uid'=>$User['id'],'id_type'=>0]);
            View::assign('Find',$Find);
            return View::fetch('personal_attestation');
        }
    }
    /**
     * security 账户安全
     */
    public function security()
    {
        $User=Session::get('User');
        if (request()->isPost()) {
            $D=request()->post();
            $D['uid']=$User['id'];
            return UserController::saveUserInfo($D);
        }
        if ($User['role_type']){
            return View::fetch('company_security');
        }else{
            return View::fetch('personal_security');
        }
    }
    public function follow()
    {
        $User=Session::get('User');
        if ($User['role_type']){
            return redirect('/user/resume/collected-resume');
        }else{
            if (request()->isAjax()) {
                $G=request()->get();
                if ($G['status']=='follow_jobs') {
                    $JobsCollection=JobsCollectionController::getPersonalJobsCollection($User['resume_id'],$User['id']);
                    return $this->ajaxReturn('',MsgCode::$success,$JobsCollection);
                }elseif($G['status']=='follow_company'){
                    $CompanyCollection=CompanyCollectionController::getPersonalCompanyCollection($User['resume_id'],$User['id']);
                    return $this->ajaxReturn('',MsgCode::$success,$CompanyCollection);

                }
            }
            return View::fetch('personal_follow');
        }
    }
    public function whoSawMe()
    {
        $User=Session::get('User');
        if ($User['role_type']){
            if (request()->isAjax()) {
                $G=request()->get();
                $CompanyController=CompanyController::getCompanyBrowseList($User['company_id']);
                return $this->ajaxReturn('',MsgCode::$success,$CompanyController);
            }
            return View::fetch('company_who_saw_me');
        }else{
            return redirect('/user/follow');
        }
    }
    public function goToPersonal()
    {
        $User=Session::get('User');
        $UserInfoModel=UserInfoModel::where(['uid'=>$User['id']])->find();
        $UserInfoModel->role_type=0;
        if ($UserInfoModel->save()) {
            Cache::set('updateUser:'.$UserInfoModel->uid,true);
            return $this->ajaxReturn('',MsgCode::$success);
        }else{
            return $this->ajaxReturn('切换失败，请刷新重试',MsgCode::$error);
        }
    }
    public function goToCompany()
    {
        $User=Session::get('User');
        $UserInfoModel=UserInfoModel::where(['uid'=>$User['id']])->find();
        $UserInfoModel->role_type=1;
        if ($UserInfoModel->save()) {
            Cache::set('updateUser:'.$UserInfoModel->uid,true);
            return $this->ajaxReturn('',MsgCode::$success);
        }else{
            return $this->ajaxReturn('切换失败，请刷新重试',MsgCode::$error);
        }
    }
    public function getRecommendResume()
    {
        $CompanyModel=CompanyModel::where(['id'=>Session::get('User.company_id')])->find();
        $D=[
            'uid'           =>  Session::get('User.id'),
            'length'        =>  6,
        ];
        if ($CompanyModel){
            $D['industry']   =   $CompanyModel->industry_id;
        }else{
            $D['recommend']  =   1;
        }
        /*
        *  调用公共获取推荐人才方法
        *  app\common\controller\Resume
        */
        return $this->ajaxReturn('',MsgCode::$success,ResumeController::getResumeList($D));
    }
    public function getBlacklist()
    {
        $User=Session::get('User');
        if($User['role_type']){
            return UserController::getCompanyBlacklist($User['id']);
        }else{
            return UserController::getResumeBlacklist($User['id']);
        }
    }
    public function setBlacklist()
    {
        $User=Session::get('User');
        $D=request()->post();
        $Data=[
            'uid'   =>  $User['id'],
            'list'  =>  $D['list']
        ];
        if($User['role_type']){
            return UserController::setCompanyBlacklist($Data);
        }else{
            return UserController::setResumeBlacklist($Data);
        }
    }
    public function cancelBlacklist($id=0)
    {
        $User=Session::get('User');
        if(request()->isPost()){
            $D=[
                'uid'       =>  $User['id'],
                'to_uid'    =>  request()->param('touid')
            ];
            if($User['role_type']){
                return UserController::cancelCompanyBlacklist($D);
            }else{
                return UserController::cancelResumeBlacklist($D);
            }
        }else{
            $D=[
                'uid'   =>  $User['id'],
                'id'    =>  $id
            ];
            if($User['role_type']){
                return UserController::cancelCompanyBlacklist($D);
            }else{
                return UserController::cancelResumeBlacklist($D);
            }
        }
    }
    public function editMobile()
    {
        $User=Session::get('User');
        if (request()->isPost()) {
            $D=request()->post();
            $D['uid']=$User['id'];
            return UserController::saveMobile($D);
        }
        if ($User['role_type']){
            return View::fetch('company_edit_mobile');
        }else{
            return View::fetch('personal_edit_mobile');
        }
    }
    public function editEmail()
    {
        $User=Session::get('User');
        if (request()->isPost()) {
            $D=request()->post();
            $D['uid']=$User['id'];
            return UserController::saveEmail($D);
        }
        if ($User['role_type']){
            return View::fetch('company_edit_email');
        }else{
            return View::fetch('personal_edit_email');
        }
    }
}
