<?php
namespace app\index\controller;
use app\common\UploadFile;
use app\common\QrcodeUtil;
use think\facade\Session;
class Uploads extends Base
{
    public function uploadFiles()
    {
    	$User=Session::get('User.id');
        $ret=UploadFile::upload($User);
        return json($ret);
    }
    public function displayQrcode()
    {
        $G=request()->get();
        $logo_url=str_replace('/public/','/',config('web.icon'));
        $logo_url=str_replace('/uploads','uploads',$logo_url);
        $qrObj=new QrcodeUtil([
            'logo'      =>  empty($G['icon'])?false:true,
            'logo_url'  =>  $logo_url
        ]);
        return response($qrObj->createServer($G['scheme']))->header([
            'Content-Type'=>$qrObj->_qr->getContentType()
        ]);
    }
    public function getAppdown()
    {
        $logo_url=str_replace('/public/','/',config('web.icon'));
        $logo_url=str_replace('/uploads','uploads',$logo_url);
		$qrObj=new QrcodeUtil([
            'logo'      =>  true,
            'logo_url'  =>  $logo_url
        ]);
		return response($qrObj->createServer(config('web.downUrl')))->header([
            'Content-Type'=>$qrObj->_qr->getContentType()
        ]);
    }
}