<?php
namespace app\index\controller;
use think\facade\View;
use think\facade\Cache;
use think\facade\Cookie;
use think\facade\Session;
use app\common\variable\MsgCode;
use app\common\model\JobsCate as JobsCateModel;
use app\common\controller\Jobs as JobsController;
use app\common\controller\Company as CompanyController;
use app\common\controller\Resume as ResumeController;
class Search extends Base
{
    public function jobHunting()
    {
        $G=request()->get();
        if(!empty($G['cid'])){
            $JobsCateModel=JobsCateModel::where(['id'=>$G['cid']])->find();
            if($JobsCateModel){
                if(request()->ApiInfo['api_is_web_name']){
                    View::assign('webtitle',$JobsCateModel->title.'最新招聘 - '.config('web.name'));
                }else{
                    View::assign('webtitle',$JobsCateModel->title.'最新招聘');
                }
            }
        }
        if (fromRobot()) {
            return View::fetch('job_hunting_robot');
        }else{
            return View::fetch();
        }
    }
    public function recruitTalents()
    {
        return View::fetch();
    }
    public function seekCompany()
    {
        if (fromRobot()) {
            return View::fetch('seek_company_robot');
        }else{
            return View::fetch();
        }
    }
    public function publicInstitutions()
    {
        return View::fetch();
    }
    public function moreServer()
    {
        return View::fetch();
    }
    public function searchJobs()
    {
        if (request()->isAjax() && request()->isGet()) {
            $G=request()->get();
            $G['uid']=Session::get('User.id');
            $G['resume_id']=Session::get('User.resume_id');
            $Data=JobsController::getJobsList($G);
            if ($Data->items()) {
                return $this->ajaxReturn('',MsgCode::$success,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',MsgCode::$error);
            }
        }
    }
    public function searchCompany()
    {
        if (request()->isAjax() && request()->isGet()) {
            $G=request()->get();
            $G['uid']=Session::get('User.id');
            $G['resume_id']=Session::get('User.resume_id');
            $Data=CompanyController::getCompanyList($G);
            if ($Data->items()) {
                return $this->ajaxReturn('',MsgCode::$success,$Data);
            }else{
                return $this->ajaxReturn('暂无数据~',MsgCode::$error);
            }
        }
    }
    public function searchResume()
    {
        if (request()->isAjax() && request()->isGet()) {
            $G=request()->get();
            $G['uid']=Session::get('User.id');
            $G['company_id']=Session::get('User.company_id');
            switch (config('xy_resume.resume_vague')) {
                case 1:
                    if (!Session::get('User.id')) {
                        $G['length']=3;
                        $Data=ResumeController::getResumeList($G);
                        $Data->total=3;
                        if ($Data->items()) {
                            return $this->ajaxReturn('resume_vague0',MsgCode::$success,$Data);
                        }else{
                            return $this->ajaxReturn('resume_vague0',MsgCode::$error);
                        }
                    }
                    if (!Session::get('User.role_type')) {
                        $G['length']=3;
                        $Data=ResumeController::getResumeList($G);
                        $Data->total=3;
                        if ($Data->items()) {
                            return $this->ajaxReturn('resume_vague1',MsgCode::$success,$Data);
                        }else{
                            return $this->ajaxReturn('resume_vague1',MsgCode::$error);
                        }
                    }
                    break;
                case 2:
                    if (!Session::get('User.jobs_sum')) {
                        $G['length']=3;
                        $Data=ResumeController::getResumeList($G);
                        $Data->total=3;
                        if ($Data->items()) {
                            return $this->ajaxReturn('resume_vague2',MsgCode::$success,$Data);
                        }else{
                            return $this->ajaxReturn('resume_vague2',MsgCode::$error);
                        }
                    }
                    break;
            }
            $Data=ResumeController::getResumeList($G);
            if ($Data->items()) {
                return $this->ajaxReturn('',MsgCode::$success,$Data);
            }else{
                return $this->ajaxReturn('',MsgCode::$error);
            }
        }
    }
}
