<?php
namespace app\index\controller;
use think\facade\View;
use think\facade\Cache;
use think\facade\Cookie;
use think\facade\Session;
use app\common\variable\MsgCode;
use app\common\controller\Resume as ResumeController;
use app\common\controller\JobsDeliveryResume as JobsDeliveryResumeController;
use app\common\controller\InviteAninterview as InviteAninterviewController;
use app\common\model\Jobs as JobsModel;
use app\common\model\Resume as ResumeModel;
use app\common\model\ResumeBrowse as ResumeBrowseModel;
use app\common\model\ResumeDownloaded as ResumeDownloadedModel;
use app\common\model\JobsDeliveryResume as JobsDeliveryResumeModel;
use app\common\model\StatusAlias as StatusAliasModel;
use app\common\model\JobsContacts as JobsContactsModel;
use app\common\model\CompanyContent as CompanyContentModel;
use app\common\model\ResumeWorks as ResumeWorksModel;
class Resume extends Base
{
    public function index($id)
    {
        $User=Session::get('User');
        $D=[
            'company_id'    =>  $User['company_id']
        ];
        $Find=ResumeController::getResumeInfo($id,$D);
        if ($Find) {
            /*记录访客*/
            ResumeBrowseModel::saveBrowse(Session::get('User.company_id'),$id);
            View::assign('Find',$Find);
            if(request()->ApiInfo['api_is_web_name']){
                View::assign('webtitle',$Find['name'].'的简历 - '.config('web.name'));
            }else{
                View::assign('webtitle',$Find['name'].'的简历');
            }
        }else{
            return redirect('/system/maintenance?msg=不存在该简历');
        }
        return View::fetch();
    }
    public function management()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
            if (request()->isAjax()) {
                $G=request()->get();
                $G['company_id']=$User['company_id'];
                $JobsDeliveryResumeController=JobsDeliveryResumeController::getCompanyJobsDeliveryResume($G);
                return $this->ajaxReturn('',MsgCode::$success,$JobsDeliveryResumeController);
            }
	        return View::fetch('company_management');
    	}else{
            return redirect('/user');
    	}
    }
    public function statistics()
    {
        $User=Session::get('User');
        if ($User['role_type']){
            $D=[
                'role_type' =>  Session::get('User.role_type'),
                'company_id'=>  Session::get('User.company_id'),
                'resume_id' =>  Session::get('User.resume_id')
            ];
            /*
            *  调用公共删除简历浏览记录方法
            *  app\common\controller\Resume
            */
            return ResumeController::statistics($D);
        }else{
        }
    }
    public function interviewInvitation()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
            if (request()->isAjax()) {
                $G=request()->get();
                $G['company_id']=$User['company_id'];
                $InviteAninterviewController=InviteAninterviewController::getInviteAninterviewList($G);
                return $this->ajaxReturn('',MsgCode::$success,$InviteAninterviewController);
            }
	        return View::fetch('company_interview_invitation');
    	}else{
            return redirect('/user/jobs/management');
    	}
    }
    public function videoInterview()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
            if (request()->isAjax()) {
                $G=request()->get();
                $G['company_id']=$User['company_id'];
                $InviteAninterviewController=InviteAninterviewController::getInviteAninterviewVideoList($G);
                return $this->ajaxReturn('',MsgCode::$success,$InviteAninterviewController);
            }
	        return View::fetch('company_video_interview');
    	}else{
            return redirect('/user/jobs/management');
    	}
    }
    public function resumeDownloaded()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
            if (request()->isAjax()) {
                $G=request()->get();
                $ResumeController=ResumeController::getCompanyDownloadList($User['company_id']);
                return $this->ajaxReturn('',MsgCode::$success,$ResumeController);
            }
	        return View::fetch('company_resume_downloaded');
    	}else{
            return redirect('/user');
    	}
    }
    public function collectedResume()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
            if (request()->isAjax()) {
                $G=request()->get();
                $ResumeController=ResumeController::getResumeCollectionList($User['company_id']);
                return $this->ajaxReturn('',MsgCode::$success,$ResumeController);
            }
	        return View::fetch('company_collected_resume');
    	}else{
            return redirect('/user/follow');
    	}
    }
    public function reviewedResume()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
            if (request()->isAjax()) {
                $G=request()->get();
                $ResumeController=ResumeController::getResumeBrowseList($User['company_id']);
                return $this->ajaxReturn('',MsgCode::$success,$ResumeController);
            }
	        return View::fetch('company_reviewed_resume');
    	}else{
            return redirect('/user');
    	}
    }
    public function resumeWorks()
    {
        $User=Session::get('User');
        if ($User['role_type']){
            return redirect('/user/company/demeanor');
        }else{
            $ResumeWorksModel=ResumeWorksModel::getResumeWorks($User['resume_id']);
            if ($ResumeWorksModel) {
                View::assign('list',$ResumeWorksModel);
                $list_img=ResumeWorksModel::where(['resume_id'=>$User['resume_id']])->field('path as url')
                    ->withAttr('url',function($v,$data){
                        return config('web.imgurl').$v;
                    })->column('path');
                View::assign('list_img',$list_img);
            }
            return View::fetch('personal_resume_works');
        }
    }
    /**
     * 保存简历
     */
    public function saveResume()
    {
        if (request()->isPost()) {
            $D=request()->post();
            $D['uid']=Session::get('User.id');
            $D['app_id']=request()->ApiInfo['app_id'];
            /*
            *  调用公共保存简历方法
            *  app\common\controller\Resume
            */
            return ResumeController::saveResume($D);
        }
    }
    /**
     * 删除简历经历
     */
    public function delExperience($type,$id)
    {
        if (request()->isAjax() && request()->isGet()) {
            $D=[
                'id'        =>  $id,
                'type'      =>  $type,
                'uid'       =>  Session::get('User.id'),
                'resume_id' =>  Session::get('User.resume_id')
            ];
            /*
            *  调用公共删除简历经历方法
            *  app\common\controller\Resume
            */
            return ResumeController::delExperience($D);
        }
    }
    /**
     * 投递简历
     */
    public function deliveryResume($id)
    {
        if (request()->isAjax() && request()->isGet()) {
            $G=request()->get();
            $D=[
                'id'            =>  $id,
                'confirm'       =>  empty($G['confirm'])?0:$G['confirm'],
                'job_fair_id'   =>  empty($G['job_fair_id'])?0:$G['job_fair_id'],
                'uid'           =>  Session::get('User.id'),
                'html'          =>  true
            ];
            /*
            *  调用公共投递简历方法
            *  app\common\controller\Resume
            */
            return ResumeController::deliveryResume($D);
        }
    }
    public function setResumeInappropriate($id)
    {
        if (request()->isAjax() && request()->isGet()) {
            $D=[
                'id'        =>  $id,
                'company_id'=>  Session::get('User.company_id'),
                'uid'       =>  Session::get('User.id')
            ];
            /*
            *  调用公共设置投递简历不合适方法
            *  app\common\controller\Resume
            */
            return ResumeController::setResumeInappropriate($D);
        }
    }
    public function inviteAnInterview()
    {
        if (request()->isAjax() && request()->isPost()) {
            $D=request()->post();
            $D['company_id']=Session::get('User.company_id');
            $D['uid']=Session::get('User.id');
            /*
            *  调用公共邀请面试方法
            *  app\common\controller\Resume
            */
            return ResumeController::inviteAnInterview($D);
        }
    }
    public function downloads($id)
    {
        if (request()->isPost()) {
            $D['uid']=Session::get('User.id');
            $D['company_id']=Session::get('User.company_id');
            $D['resume_id']=$id;
            /*
            *  调用公共获取下载信息方法
            *  app\common\controller\Resume
            */
            return ResumeController::getDownloadsInfo($D);
        }else{
            $D['uid']=Session::get('User.id');
            $D['company_id']=Session::get('User.company_id');
            $D['id']=$id;
            return ResumeController::getDownloadsFile($D);
        }
    }
    public function delDeliveryResume($id)
    {
        $D=[
            'id'        =>  $id,
            'role_type' =>  Session::get('User.role_type'),
            'company_id'=>  Session::get('User.company_id'),
            'resume_id' =>  Session::get('User.resume_id')
        ];
        /*
        *  调用公共删除投递方法
        *  app\common\controller\JobsDeliveryResume
        */
        return JobsDeliveryResumeController::delDeliveryResume($D);
    }
    public function delDownloadResume($id)
    {
        $D=[
            'id'        =>  $id,
            'role_type' =>  Session::get('User.role_type'),
            'company_id'=>  Session::get('User.company_id'),
            'resume_id' =>  Session::get('User.resume_id')
        ];
        /*
        *  调用公共删除下载简历记录方法
        *  app\common\controller\Resume
        */
        return ResumeController::delDownloadResume($D);
    }
    public function delCollectedResume($id)
    {
        $D=[
            'id'        =>  $id,
            'company_id'=>  Session::get('User.company_id'),
        ];
        /*
        *  调用公共删除收藏简历记录方法
        *  app\common\controller\Resume
        */
        return ResumeController::delCollectedResume($D);
    }
    public function delBrowseResume($id)
    {
        $D=[
            'id'        =>  $id,
            'role_type' =>  Session::get('User.role_type'),
            'company_id'=>  Session::get('User.company_id'),
            'resume_id' =>  Session::get('User.resume_id')
        ];
        /*
        *  调用公共删除简历浏览记录方法
        *  app\common\controller\Resume
        */
        return ResumeController::delBrowseResume($D);
    }
    public function setResumePrivacy($status)
    {
        $D=[
            'status'    =>  $status,
            'resume_id' =>  Session::get('User.resume_id')
        ];
        /*
        *  调用公共设置简历隐私状态方法
        *  app\common\controller\Resume
        */
        return ResumeController::setResumePrivacy($D);
    }
    public function setResumeHeadimgStatus($status)
    {
        $D=[
            'status'    =>  $status,
            'resume_id' =>  Session::get('User.resume_id')
        ];
        /*
        *  调用公共设置头像是否公开方法
        *  app\common\controller\Resume
        */
        return ResumeController::setResumeHeadimgStatus($D);
    }
    /**
     * 保存作品照片
     */
    public function saveResumeWorks()
    {
        if (request()->isPost()) {
            $D=request()->post();
            $D['resume_id']=Session::get('User.resume_id');
            if (!$D['resume_id'])
                return $this->ajaxReturn('请先创建简历',MsgCode::$error);
            /*
            *  调用公共保存作品照片方法
            *  app\common\controller\Resume
            */
            return ResumeController::saveResumeWorks($D);
        }
    }
    /**
     * 保存作品照片备注
     */
    public function saveResumeWorksTitle($id,$title)
    {
        if (request()->isAjax() && request()->isGet()) {
            $D=[
                'id'        =>  $id,
                'title'     =>  $title,
                'resume_id'=>  Session::get('User.resume_id'),
            ];
            if (!$D['resume_id'])
                return $this->ajaxReturn('请先创建简历',MsgCode::$error);
            /*
            *  调用公共保存作品照片备注方法
            *  app\common\controller\Resume
            */
            return ResumeController::saveResumeWorksTitle($D);
        }
    }
    /**
     * 删除作品照片
     */
    public function delResumeWorks($id)
    {
        if (request()->isAjax() && request()->isGet()) {
            $D=[
                'id'            =>  $id,
                'resume_id'    =>  Session::get('User.resume_id')
            ];
            if (!$D['resume_id'])
                return $this->ajaxReturn('请先创建简历',MsgCode::$error);
            /*
            *  调用公共删除作品照片方法
            *  app\common\controller\Resume
            */
            return ResumeController::delResumeWorks($D);
        }
    }
    public function toggleResumeCollection($id)
    {
        if (request()->isAjax() && request()->isGet()) {
            $D=[
                'id'            =>  $id,
                'uid'           =>  Session::get('User.id'),
                'company_id'    =>  Session::get('User.company_id')
            ];
            if (!$D['company_id'])
                return $this->ajaxReturn('请先完善企业信息',MsgCode::$error);
            /*
            *  调用公共关注简历方法
            *  app\common\controller\Resume
            */
            return ResumeController::toggleResumeCollection($D);
        }
    }
    public function getContactsData($id)
    {
        $D=[
            'id'        =>  $id,
            'uid'       =>  Session::get('User.id'),
            'role_type' =>  Session::get('User.role_type'),
            'company_id'=>  Session::get('User.company_id')
        ];
        return ResumeController::getContactsData($D);
    }
    public function getSearchResume()
    {
        $D=[
            'uid'       =>  Session::get('User.id'),
            'company_id'=>  Session::get('User.company_id'),
            'key'       =>  request()->get('key')
        ];
        return ResumeController::getSearchResume($D);
    }
    public function setResumeRefreshTime()
    {
        $User=Session::get('User');
        $D=[
            'uid'       =>  Session::get('User.id'),
            'resume_id' =>  Session::get('User.resume_id')
        ];
        /*
        *  调用公共刷新简历方法
        *  app\common\controller\Resume
        */
        return ResumeController::setResumeRefreshTime($D);
    }
    public function setAutoConsignment()
    {
        $User=Session::get('User');
        $D=[
            'uid'       =>  Session::get('User.id'),
            'resume_id' =>  Session::get('User.resume_id')
        ];
        /*
        *  调用公共刷新简历方法
        *  app\common\controller\Resume
        */
        return ResumeController::setAutoConsignment($D);
    }
}
