<?php
namespace app\index\controller;
use think\facade\View;
use think\facade\Session;
use think\facade\Cache;
use GatewayClient\Gateway;
use app\common\variable\MsgCode;
use app\common\controller\Message as MessageController;
use app\common\controller\User as UserController;
use app\common\controller\Resume as ResumeController;
class Message extends Base
{
    public function myMessage()
    {
        $User=Session::get('User');
        if (request()->isAjax()) {
            $G=request()->get();
            $G['uid']=$User['id'];
            return MessageController::getList($G);
        }
        if ($User['role_type']){
            return View::fetch('company_message');
        }else{
            return View::fetch('personal_message');
        }
    }
    public function setMessageRead($id)
    {
        $User=Session::get('User');
        $G['id']=$id;
        $G['uid']=$User['id'];
        return MessageController::setMessageRead($G);
    }
    public function getMessageFind($id)
    {
        $User=Session::get('User');
        $G['id']=$id;
        $G['uid']=$User['id'];
        return MessageController::getFind($G);
    }
    public function delMessage($id)
    {
        $User=Session::get('User');
        $G['id']=$id;
        $G['uid']=$User['id'];
        return MessageController::delMessage($G);
    }
    public function joinGroup($client_id)
    {
        $MessageClientId=Cache::pull('MessageClientId::'.$client_id);
        $User=Session::get('User');
        if ($MessageClientId==$User['id']) {
            Gateway::$registerAddress = config('gateway_worker.registerAddress');
            Gateway::joinGroup($client_id, 'Pc:uid-'.$User['id']);
            $User['client_id'][]=$client_id;
            Session::set('User',$User);
            $User=Session::get('User');
            if ($User['role_type']){
    	        Gateway::joinGroup($client_id, 'Pc:role-company');
            }else{
    	        Gateway::joinGroup($client_id, 'Pc:role-personal');
            }
            return $this->ajaxReturn();
        }else{
            return $this->ajaxReturn('',MsgCode::$error);
        }
    }
    public function createContacts()
    {
        $User=Session::get('User');
        $D=request()->post();
        $D['uid']=$User['id'];
        $D['role_type']=$User['role_type'];
        $D['company_id']=$User['company_id'];
        $D['resume_id']=$User['resume_id'];
        return MessageController::createContacts($D);
    }
    public function getIMDataInfo()
    {
    	$G=request()->get();
    	if (empty($G['type']))
            return $this->ajaxReturn('',MsgCode::$error);
        $User=Session::get('User');
        switch ($G['type']) {
        	case 'mobile':
        		return UserController::getMobile($User);
        	case 'wechat':
        		return UserController::getWechat($User);
        	case 'resume':
            	return $this->ajaxReturn('',MsgCode::$success,ResumeController::getResumeInfo($User['resume_id'],['is_admin'=>1]));
        	case 'deliveryResume':
                $D=[
                    'id'        =>  $G['id'],
                    'confirm'   =>  1,
                    'im'        =>  1,
                    'uid'       =>  $G['uid']
                ];
                /*
                *  调用公共投递简历方法
                *  app\common\controller\Resume
                */
                return ResumeController::deliveryResume($D);
            case 'inviteAnInterview':
                break;
        	case 'uninterested':
        		break;
        }
    }
    public function getUnreadMessage()
    {
        $User=Session::get('User');
        return MessageController::getUnreadMessage($User['id']);
    }
}
