<?php
namespace app\index\controller;
use think\facade\View;
use think\facade\Cache;
use think\facade\Cookie;
use think\facade\Session;
use app\common\variable\MsgCode;
use app\common\controller\Jobs as JobsController;
use app\common\controller\JobsDeliveryResume as JobsDeliveryResumeController;
use app\common\controller\Resume as ResumeController;
use app\common\model\Jobs as JobsModel;
use app\common\model\JobsDeliveryResume as JobsDeliveryResumeModel;
use app\common\model\JobsBrowse as JobsBrowseModel;
use app\common\model\Company as CompanyModel;
use app\common\model\CompanyContent as CompanyContentModel;
class Jobs extends Base
{
    public function index($id)
    {
        $G=[
            'uid'       =>  Session::get('User.id'),
            'resume_id' =>  Session::get('User.resume_id'),
            'html'      =>  true,
        ];
        $Find=JobsController::getJobsInfo($id,$G);
        if ($Find) {
            /*记录访客*/
            JobsBrowseModel::saveBrowse(Session::get('User.resume_id'),$Find->company_id,$Find->id);
            $G['company_id']=$Find->company_id;
            $Data=JobsController::getJobsList($G);
            View::assign('Jobs',$Data);
            View::assign('Find',$Find);
	        if(request()->ApiInfo['api_is_web_name']){
	            View::assign('webtitle',$Find['title'].' - '.config('web.name'));
	        }else{
	            View::assign('webtitle',$Find['title']);
	        }
            $keywords=[
                $Find['title'],
                $Find['company_name'],
                $Find['industry'],
                $Find['jobs_cate_text'],
                $Find['jobs_city'].'工作',
                $Find['education_level'],
            ];
            foreach ($Find['jobs_welfare'] as $k => $v) {
                $keywords[]=$v;
            }
            View::assign('keywords',implode(',',$keywords));
            View::assign('description',$Find['jobs_desc']);
        }else{
            return redirect('/system/maintenance?msg=不存在该职位');
        }
        return View::fetch();
    }
    /**
     * 发布职位
     */
    public function release()
    {
        $User=Session::get('User');
        if (request()->isPost()) {
            $D=request()->post();
            $D['uid']=$User['id'];
            $D['app_id']=request()->ApiInfo['app_id'];
            /*
            *  调用公共保存职位方法
            *  app\common\controller\Jobs
            */
            return JobsController::releaseJobs($D);
        }else{
            if ($User['role_type']){
                $CompanyModel=CompanyModel::where(['uid'=>$User['id']])->find();
                if(!$User['company_id'])
                    return redirect('/user/account');
                if(config('xy_company.is_forceattestation')
                    &&$CompanyModel->attestation!=3)
                    return redirect('/user/attestation');
                return View::fetch('company_release');
            }else{
                return redirect('/user');
            }
        }
    }
    public function management()
    {
    	$User=Session::get('User');
    	if ($User['role_type']){
            if (request()->isAjax()) {
                $G=request()->get();
                $where=[];
                if (!empty($G['status']) && $G['status']!='all'){
                    if ($G['status']=='none') {
                        $where[]=['jobs.status','=',0];
                    }elseif ($G['status']=='publishing') {
                        $where[]=['jobs.status','=',1];
                    }
                }
                $Jobs=JobsController::getCompanyJobsList($User['company_id'],$where);
                return $this->ajaxReturn('',MsgCode::$success,$Jobs);
            }
            return View::fetch('company_management');
    	}else{
            if (request()->isAjax()) {
                $G=request()->get();
                if ($G['status']=='positions_viewed') {
                    $JobsBrowse=JobsController::getPersonalJobsBrowse($User['resume_id']);
                    return $this->ajaxReturn('',MsgCode::$success,$JobsBrowse);
                }elseif($G['status']=='viewed_me'){
                    $ResumeBrowse=ResumeController::getComapnyBrowseList($User['resume_id']);
                    return $this->ajaxReturn('',MsgCode::$success,$ResumeBrowse);
                }else{
                    $where=[];
                    switch ($G['status']) {
                        case 'position_see':
                            $where[]=['d.status','=',1];
                            break;
                        case 'position_inappropriate':
                            $where[]=['d.status','=',2];
                            break;
                        case 'interview_invitation':
                            // $where[]=['d.status','=',3];
                            break;
                        case 'position_applied':
                            break;
                    }
                    $JobsDeliveryResume=JobsDeliveryResumeController::getPersonalJobsDeliveryResume($User['id'],$where);
                    return $this->ajaxReturn('',MsgCode::$success,$JobsDeliveryResume);

                }
            }
	        return View::fetch('personal_management');
    	}
    }
    public function recruitEffectCount()
    {
	    return View::fetch('company_recruit_effect_count');
    }
    public function expenditureGratuity()
    {
	    return View::fetch('company_expenditure_gratuity');
    }
    public function allJobsCate()
    {
        return View::fetch();
    }
    public function saveJobs($id)
    {
        if (request()->isPost()) {
            $D=request()->post();
            $D['uid']=Session::get('User.id');
            $D['id']=$id;
            /*
            *  调用公共保存职位方法
            *  app\common\controller\Jobs
            */
            return JobsController::saveJobs($D);
        }else{
            $D['company_id']=Session::get('User.company_id');
            $D['id']=$id;
            View::assign('Find',JobsController::getJobsInfoAll($D));
            return View::fetch('company_release');
        }
    }
    public function setJobsStatus($id,$status)
    {
        $D=[
            'uid'       =>  Session::get('User.id'),
            'company_id'=>  Session::get('User.company_id'),
            'id'        =>  $id,
            'status'    =>  $status
        ];
        return JobsController::setJobsStatus($D);
    }
    public function setJobsRefreshTime($id)
    {
        $D=[
            'uid'       =>  Session::get('User.id'),
            'company_id'=>  Session::get('User.company_id'),
            'id'        =>  $id
        ];
        return JobsController::setJobsRefreshTime($D);
    }
    public function setCompanyJobsRefreshTime()
    {
        $D=[
            'uid'       =>  Session::get('User.id'),
            'company_id'=>  Session::get('User.company_id')
        ];
        return JobsController::setCompanyJobsRefreshTime($D);
    }
    public function toggleJobsCollection($id)
    {
        $D=[
            'uid'       =>  Session::get('User.id'),
            'resume_id' =>  Session::get('User.resume_id'),
            'jobs_id'   =>  $id
        ];
        return JobsController::toggleJobsCollection($D);
    }
    public function getContactsData($id)
    {
        $D=[
            'id'        =>$id,
            'uid'       =>Session::get('User.id'),
            'resume_id' =>Session::get('User.resume_id')
        ];
        return JobsController::getContactsData($D);
    }
}
