<?php
namespace app\index\controller;
use think\facade\View;
use think\facade\Cache;
use think\facade\Cookie;
use think\facade\Session;
use app\common\variable\MsgCode;
use app\common\controller\JobFair as JobFairController;
class JobFair extends Base
{
    public function index()
    {
        return View::fetch();
    }
    public function detail($id)
    {
        $where=[];
        $where[]=['job.id','=',$id];
        $Find=JobFairController::getFind($where);
        View::assign('webtitle',$Find->title);
        View::assign('Find',$Find);
        return View::fetch();
    }
    public function getJobsList()
    {
        $G=request()->get();
        $G['uid']=Session::get('User.id');
        $G['resume_id']=Session::get('User.resume_id');
        return JobFairController::getJobsList($G);
    }
    public function getResumeList()
    {
        $G=request()->get();
        $G['uid']=Session::get('User.id');
        $G['company_id']=Session::get('User.company_id');
        return JobFairController::getResumeList($G);
    }
    public function getCompanyList()
    {
        $G=request()->get();
        if(empty($G['id']))
            return $this->ajaxReturn('',-100);
        $where=[];
        $where[]=['job.jid','=',$G['id']];
        if (!empty($G['key']))
            $where[]=['c.title','like','%'.$G['key'].'%'];
        if (!empty($G['bid']))
            $where[]=['job.bid','=',$G['bid']];
        if (!empty($G['booth']))
            $where[]=['booth.identifier','=',$G['booth']];
        return JobFairController::getCompanyList($where);
    }
    public function apply()
    {
    	$User=Session::get('User');
        if(request()->isAjax()){
            $Data=JobFairController::getList();
            if($Data->items()){
                return $this->ajaxReturn('',MsgCode::$success,$Data);
            }else{
                return $this->ajaxReturn('暂无数据',MsgCode::$error);
            }
        }
    	if ($User['role_type']){
        	return View::fetch('company_apply');
    	}else{
	        return View::fetch('personal_apply');
    	}
    }
    public function record()
    {
        $User=Session::get('User');
        if ($User['role_type']){
            if(request()->isAjax()){
                $Data=JobFairController::getJobFairCompanyBooth(Session::get('User.company_id'));
                if($Data->items()){
                    return $this->ajaxReturn('',MsgCode::$success,$Data);
                }else{
                    return $this->ajaxReturn('暂无数据',MsgCode::$error);
                }
            }
            return View::fetch('company_record');
        }else{
            return View::fetch('personal_record');
        }
    }
}
