<?php
namespace app\index\controller;
use think\facade\View;
use think\facade\Cache;
use think\facade\Cookie;
use think\facade\Session;
use app\common\controller\Index as IndexController;
use app\common\model\Company as CompanyModel;
use app\common\model\Jobs as JobsModel;
use app\common\model\Resume as ResumeModel;
class Index extends Base
{
    public function index()
    {
        $company=CompanyModel::count();
        $jobs=JobsModel::count();
        $resume=ResumeModel::count();
        $footer_count_sum=[
            'company'   =>  $company>100000?round($company/10000,2).'W+':$company,
            'jobs'      =>  $jobs>100000?round($jobs/10000,2).'W+':$jobs,
            'resume'    =>  $resume>100000?round($resume/10000,2).'W+':$resume,
        ];
        View::assign('footer_count_sum',$footer_count_sum);
        $subDomain=request()->subDomain();
        if($subDomain&&$subDomain!='www')
            return $this->sub_website($subDomain);
        return View::fetch();
    }
    public function sub_website($alias='')
    {
        $SubWebsiteData=Cache::get('SubWebsiteData');
        if (!empty($SubWebsiteData[$alias])) {
            $Find=$SubWebsiteData[$alias];
            View::assign('logo',$Find['logo']);
            View::assign('webtitle',$Find['seo_title']);
            View::assign('keywords',$Find['seo_keywords']);
            View::assign('description',$Find['seo_description']);
            return View::fetch('index');
        }
        return View::fetch();
    }
    public function map_jobs()
    {
        return View::fetch();
    }
    public function maintenance()
    {
    	$G=request()->get();
        $msg='';
        if (!empty($G)) {
            $msg=$G['msg'];
        }
    	View::assign('message',$msg);
    	return View::fetch();
    }
    public function downInternetShortcut()
    {
        $G=request()->get();
        $url=empty($G['url'])?config('web.url'):config('web.url').$G['url'];
        $title=empty($G['title'])?config('web.name'):$G['title'];
        $content="[{000214A0-0000-0000-C000-000000000046}]\nProp3=19,11\n[InternetShortcut]\nURL=".$url."\nIconFile=".config('web.url')."/favicon.ico";
        return download($content,$title.'.url',true)->expire(5);
    }
}
