<?php
namespace app\index\controller;
use think\facade\View;
use think\facade\Cache;
use think\facade\Cookie;
use think\facade\Session;
use app\common\controller\Company as CompanyController;
use app\common\controller\Jobs as JobsController;
use app\common\model\CompanyBrowse as CompanyBrowseModel;
use app\common\model\CompanyDemeanor as CompanyDemeanorModel;
class Company extends Base
{
    public function index($id)
    {
        $G=[
            'company_id'    =>  $id,
            'uid'           =>  Session::get('User.id'),
            'resume_id'     =>  Session::get('User.resume_id'),
            'html'          =>  true
        ];
        $Find=CompanyController::getCompanyInfo($id,$G);
        if ($Find) {
            /*记录访客*/
            CompanyBrowseModel::saveBrowse([
                'uid'=>Session::get('User.id'),
                'role_type'=>Session::get('User.role_type'),
                'resume_id'=>Session::get('User.resume_id'),
                'company_id'=>Session::get('User.company_id')
            ],$id);
            $Data=JobsController::getJobsList($G);
            View::assign('Jobs',$Data);
            View::assign('Find',$Find);
            $keywords=[];
            if(request()->ApiInfo['api_is_web_name']){
                View::assign('webtitle',$Find['title'].'招聘 - '.config('web.name'));
            }else{
                View::assign('webtitle',$Find['title'].'招聘');
            }
            $keywords=[
                $Find['title'],
                $Find['title'].'招聘',
            ];
            $description=str_replace("<br/>",'',html_entity_decode($Find['company_descript']));
            View::assign('description',$description);
            foreach ($Find['corporate_welfare'] as $k => $v) {
                $keywords[]=$v;
            }
            View::assign('keywords',implode(',',$keywords));
            $CompanyDemeanorModel=CompanyDemeanorModel::getCompanyDemeanorIsExamine($id);
            View::assign('CompanyDemeanor',$CompanyDemeanorModel);
        }else{
            return redirect('/system/maintenance?msg=不存在该企业');
        }
        return View::fetch();
    }
    public function saveCompany()
    {
        if (request()->isPost()) {
            $D=request()->post();
            $D['uid']=Session::get('User.id');
            /*
            *  调用公共保存企业方法
            *  app\common\controller\Company
            */
            return CompanyController::saveCompany($D);
        }
    }
    /**
     * 删除企业发展历程
     */
    public function delDevelopmentHistory($id)
    {
        if (request()->isAjax() && request()->isPost()) {
            $D=[
                'id'            =>  $id,
                'company_id'    =>  Session::get('User.company_id')
            ];
            /*
            *  调用公共删除企业发展历程方法
            *  app\common\controller\Resume
            */
            return CompanyController::delDevelopmentHistory($D);
        }
    }
    /**
     * 保存企业风采
     */
    public function saveDemeanor()
    {
        if (request()->isPost()) {
            $D=request()->post();
            $D['company_id']=Session::get('User.company_id');
            /*
            *  调用公共保存企业风采方法
            *  app\common\controller\Resume
            */
            return CompanyController::saveDemeanor($D);
        }
    }
    /**
     * 保存企业风采备注
     */
    public function saveDemeanorTitle($id,$title)
    {
        if (request()->isAjax() && request()->isGet()) {
            $D=[
                'id'        =>  $id,
                'title'     =>  $title,
                'company_id'=>  Session::get('User.company_id'),
            ];
            /*
            *  调用公共保存企业风采备注方法
            *  app\common\controller\Resume
            */
            return CompanyController::saveDemeanorTitle($D);
        }
    }
    /**
     * 删除企业风采
     */
    public function delCompanyDemeanor($id)
    {
        if (request()->isAjax() && request()->isGet()) {
            $D=[
                'id'            =>  $id,
                'company_id'    =>  Session::get('User.company_id')
            ];
            /*
            *  调用公共删除企业风采方法
            *  app\common\controller\Resume
            */
            return CompanyController::delCompanyDemeanor($D);
        }
    }
    public function toggleCompanyCollection($id)
    {
        $D=[
            'uid'       =>  Session::get('User.id'),
            'resume_id' =>  Session::get('User.resume_id'),
            'company_id'=>  $id
        ];
        return CompanyController::toggleCompanyCollection($D);
    }
    public function getSearchCompany()
    {
        $D=[
            'uid'       =>  Session::get('User.id'),
            'resume_id' =>  Session::get('User.resume_id'),
            'key'       =>  request()->get('key')
        ];
        return CompanyController::getSearchCompany($D);
    }
}
