<?php
namespace app\index\controller;
use app\index\BaseController;
use think\facade\Session;
use think\facade\Cache;
use think\facade\Cookie;
use think\helper\Str;
use think\Response;
use think\exception\HttpResponseException;
use app\common\model\User as UserModel;
use app\common\variable\MsgCode;
use GatewayClient\Gateway;
class Base extends BaseController
{
    protected $middleware = ['VerificationWeb'];
    /**
     * [__construct 构造函数]
     * @return [type] [description]
     */
    public function __construct(){
        if(request()->isMobile()){
            $this->autoDistinguishClientCedirect();
        }
        parent::__construct(App());
        $User=Session::get('User');
        if ($User&&!request()->isAjax())
            $this->setSuccessLogin($User);
    }
    /**
     * [outLogin 注销登录]
     * @return [type] [description]
     */
    public function outLogin()
    {
        $UserInfo=Session::get('User');
        if ($UserInfo) {
            Session::delete('User');
            $cacheUserInfo=Cookie::get('cacheUserInfo');
            if ($cacheUserInfo)
                Cache::delete($cacheUserInfo);
            $MessageKey=Cache::get('Message::'.$UserInfo['id']);
            if ($MessageKey) {
                Cache::delete('Message::'.$UserInfo['id']);
                Cache::delete('Message::'.$MessageKey);
            }
            if (!empty($UserInfo['client_id'])) {
                Gateway::$registerAddress = config('gateway_worker.registerAddress');
                Gateway::sendToGroup('Pc:uid-'.$UserInfo['id'],socketMsg('outLogin'));
                Gateway::ungroup('Pc:uid-'.$UserInfo['id']);
                foreach ($UserInfo['client_id'] as $k => $client_id) {
                    Gateway::joinGroup($client_id, 'Pc:role-company');
                    Gateway::joinGroup($client_id, 'Pc:role-personal');
                }
            }
        }
        return $this->ajaxReturn();
    }
    /**
     * [ajaxReturn 返回json]
     * @param  integer $code [description]
     * @param  [type]  $data [description]
     * @return [type]        [description]
     */
    public function ajaxReturn($msg='Success',$code=0,$data=[]){
        if (!$code)$code=MsgCode::$success;
        return json(['code'=>$code,'msg'=>$msg,'data'=>$data,'time'=>date('Y-m-d H:i:s')]);
    }
    public function setSuccessLogin($User)
    {
        $UserInfo=UserModel::getWebUserInfo(['user.id'=>$User['id']]);
        if (!empty($User['token']))
        $UserInfo->token=$User['token'];
        $UserInfo->client_id=[];
        if (!empty($User['client_id'])) 
            $UserInfo->client_id=$User['client_id'];
        Session::set('User',$UserInfo->toArray());
    }
    public function autoDistinguishClientCedirect()
    {
        $rule=request()->controller().'/'.request()->action();
        switch ($rule) {
            case 'Jobs/index':
                if (Session::get('User.role_type')) {
                throw new HttpResponseException(Response::create(config('web.h5').'/#/pageA/pages/company/jobs/jobs?id='.request()->route('id'),'redirect',302));
                }else{
                throw new HttpResponseException(Response::create(config('web.h5').'/#/pageA/pages/personal/jobs/jobs?id='.request()->route('id'),'redirect',302));
                }
            case 'Resume/index':
                throw new HttpResponseException(Response::create(config('web.h5').'/#/pageA/pages/company/resume/resume?id='.request()->route('id'),'redirect',302));
            case 'Company/index':
                throw new HttpResponseException(Response::create(config('web.h5').'/#/pageA/pages/common/company/company?id='.request()->route('id'),'redirect',302));
            case 'Article/content':
                $id=request()->route('id');
                if(is_numeric($id)){
                throw new HttpResponseException(Response::create(config('web.h5').'/#/pageA/pages/common/article/content?id='.$id,'redirect',302));
                }else{
                throw new HttpResponseException(Response::create(config('web.h5').'/#/pageA/pages/common/article/content?alias='.$id,'redirect',302));
                }
            default:
                throw new HttpResponseException(Response::create(config('web.h5'),'redirect',302));
        }
    }
}
