<?php
namespace app\index\controller;
use think\facade\View;
use think\facade\Request;
use app\common\controller\Article as ArticleController;
use app\common\model\Article as ArticleModel;
use app\common\model\ArticleCate as ArticleCateModel;
use app\common\model\StatusAlias as StatusAliasModel;
class Article extends Base
{
    public function index()
    {
        return View::fetch();
    }
    public function content($id)
    {
        if (is_numeric($id)) {
            $Find=ArticleController::getIdContent($id);
        }else{
            $Find=ArticleController::getAliasContent($id);
        }
    	if ($Find) {
            if(request()->ApiInfo['api_is_web_name']){
                View::assign('webtitle',$Find['title'].' - '.config('web.name'));
            }else{
                View::assign('webtitle',$Find['title']);
            }
            View::assign('keywords',$Find['title']);
            View::assign('description',$Find['desc']);
    	}
    	View::assign('Find',$Find);
        return View::fetch();
    }
    public function getAlias($alias='all')
    {
        View::assign('alias',$alias);
        if($alias){
        	$ArticleCateModel=ArticleCateModel::where(['alias'=>$alias])->find();
        	if($ArticleCateModel){
                if(request()->ApiInfo['api_is_web_name']){
                    View::assign('webtitle',$ArticleCateModel->title.' - '.config('web.name'));
                }else{
                    View::assign('webtitle',$ArticleCateModel->title);
                }
            }
        }
        return View::fetch();
    }
    public function governmentInstitutions()
    {
        $whereSubSiteSql='';
        if (isset(request()->sub_city)){
            $whereSubSite=[];
            if (config('xy_sub_website.data_is_all'))
                $whereSubSite[]='article.city IS NULL';
            $whereSubSite[]='article.city = '.request()->sub_city;
            $whereSubSiteSql=implode(' OR ', $whereSubSite);
        }
        $now=time();
        $whreTime='(`article`.`start_time` IS NULL AND `article`.`end_time` IS NULL)  OR (`article`.`start_time` < '.$now.' AND `article`.`end_time` IS NULL)  OR (`article`.`start_time` IS NULL AND `article`.`end_time` > '.$now.')  OR (`article`.`start_time` < '.$now.' AND `article`.`end_time` > '.$now.')';
        $ArticleCateModel=ArticleCateModel::where(['alias'=>'government_institutions'])->find();
        $Data=null;
        if ($ArticleCateModel) {
            $G=request()->get();
            $where=[];
            $where[]=['article.cid','=',$ArticleCateModel->id];
            $where[]=['article.status','=',1];
            if(!empty($G['status']))
                $where[]=['article.status_alias','=',$G['status']];
            if(!empty($G['key']))
                $where[]=['article.title','like','%'.$G['key'].'%'];

            $DataObj=ArticleModel::alias('article')->where($where);
                if ($whereSubSiteSql)
                    $DataObj->whereRaw($whereSubSiteSql);
            $Data=$DataObj->whereRaw($whreTime)->order('article.start_time desc,article.id desc')->field('article.id,article.title,article.view,article.thumb,article.start_time,article.create_time,article.desc,article.status_alias')->paginate(['list_rows'=>10,'query'=>Request::instance()->param()])->each(function($item, $key){
                    $item->start_time = $item->start_time?$item->start_time:$item->create_time;
                    $item->source = $item->source?$item->source:config('web.name');
                    $item->imgurl=config('web.imgurl');
                    if ($item->thumb)
                        $item->thumb=explode(',',$item->thumb);
                    if($item->status_alias)
                    $item->status_alias=StatusAliasModel::where(['alias'=>'article/status_alias','value'=>$item->status_alias])->field('type,title')->find();
                });
        }
        View::assign('Data',$Data);
        return View::fetch();
    }
    public function commonProblem()
    {
        $Data=ArticleController::getPage('common-problem',20);
        View::assign('Data',$Data);
        return View::fetch();
    }
}
