<?php
namespace app\common\validate;

use think\Validate;

class UserName extends Validate
{
    protected $rule =   [
        'mobile'            => 'require|mobile|unique:user',
        'email'             => 'email|unique:user',
        'password'          => 'length:6,20',
        'vpassword'         => 'confirm:password',
    ];
    
    protected $message  =   [
        'mobile.require'            => '请输入手机号', 
        'mobile.mobile'             => '手机号格式不正确', 
        'mobile.unique'             => '该用户已存在', 
        'email.email'               => '邮箱格式不正确', 
        'email.unique'              => '邮箱已存在', 
        'password.length'           => '密码长度须在6~20之间', 
        'vpassword.confirm'         => '两次输入的密码不一致', 
    ];
}