<?php
namespace app\common\validate;

use think\Validate;

class User extends Validate
{
    protected $rule =   [
        'is_username_type'  =>  'require',
        'mobile'            => 'require|mobile|unique:user',
        'email'             => 'email|unique:user',
        'user'              => 'alphaNum|length:6,20|unique:user',
        'password'          => 'length:6,20',
        'vpassword'         => 'confirm:password',
        'nickname'          => 'length:1,20',
        'vcode'             => 'require',
        'type'              =>  'require',
    ];
    
    protected $scene = [
        'admin_add_company'         =>  ['mobile','email'],
        'admin_add'                 =>  ['user','mobile','email','password','vpassword','nickname'],
        'web_security'              =>  ['user','password','vpassword','nickname'],
        'edit_mobile'               =>  ['is_username_type','mobile','vcode','type'],
        'edit_email'                =>  ['is_username_type','email','vcode','type'],
    ];  
    
    protected $message  =   [
        'is_username_type.require'  => '请选择登录方式', 
        'mobile.require'            => '请输入手机号', 
        'mobile.mobile'             => '手机号格式不正确', 
        'mobile.unique'             => '该用户已存在', 
        'email.email'               => '邮箱格式不正确', 
        'email.unique'              => '邮箱已存在', 
        'user.alphaNum'             => '用户名必须为字母加数字', 
        'user.length'               => '用户名长度须在6~20之间', 
        'user.unique'               => '用户名已被占用', 
        'password.length'           => '密码长度须在6~20之间', 
        'vpassword.confirm'         => '两次输入的密码不一致', 
        'nickname.length'           => '昵称长度须在1~20之间',
        'vcode.require'             => '请输入验证码', 
        'type.require'              => '未知的请求方式', 
    ];
}