<?php
namespace app\common\validate;

use think\Validate;

class Resume extends Validate
{
    protected $rule =   [
        'name'                      => 'require|checkTrueName',
        'sex'                       => 'require',
        'age'                       => 'require',
        'educational_background'    => 'require',
        'work_experience_time'      => 'require',
    ];
    
    protected $message  =   [
        'name.require'                      => '姓名不能为空', 
        'sex.require'                       => '请选择您的性别', 
        'age.require'                       => '请选择您的年龄', 
        'educational_background.require'    => '请选择学历', 
        'work_experience_time.require'      => '请选择参加工作时间', 
    ];
    /**
     * 验证中文姓名
     * @param $name 姓名
     * @return 
     */
    protected function checkTrueName($value,$rule,$data=[])
    {
        if (!preg_match('/^[\x{4e00}-\x{9fa5}]+[·•]?[\x{4e00}-\x{9fa5}]+$/u', $value)) {
            return '姓名不正确';
        }
        $strLen = mb_strlen($value);
        if ($strLen < 2 || $strLen > 20) {
            return '姓名不正确';
        }
     
        return true;
    }
}