<?php
namespace app\common\validate;

use think\Validate;
use think\facade\Cache;
use app\common\model\User as UserModel;
use app\common\model\SmsSendLog as SmsSendLogModel;

class Login extends Validate
{
    protected $rule =   [
        'is_username_type'  =>  'require',
        'username'          =>  'require|checkUsername',
        'password'          =>  'require',
        'vcode'             =>  'require',
        'type'              =>  'require',
    ];
    
    protected $scene = [
        'login'             =>  ['is_username_type','username','password'],
        'vcode'             =>  ['is_username_type','username','vcode','type'],
        'register'          =>  ['username','password','vpassword','vcode','type'],
        'getCode'           =>  ['is_username_type','username','type'],
        'verificationVcode' =>  ['is_username_type','username','vcode','type'],
    ];  
    
    protected $message  =   [
        'is_username_type.require'  => '请选择登录方式', 
        'username.require'          => '请输入手机号', 
        'username.mobile'           => '手机号格式不正确', 
        'username.email'            => '邮箱格式不正确', 
        'username.is_register'      => '该用户不存在',
        'password.require'          => '请输入密码', 
        'vcode.require'             => '请输入验证码', 
        'type.require'              => '未知的请求方式',
    ];
    protected function checkUsername($value,$rule,$data=[])
    {
        if (!empty($data['type'])&&in_array($data['type'],['user/editMobile','user/editEmail'])){
            if (filter_var($value,FILTER_VALIDATE_EMAIL)){
                return UserModel::where(['email'=>$value])->count()?'用户已存在':true;
            }else if ($this->regex($value,'mobile')) {
                return UserModel::where(['mobile'=>$value])->count()?'用户已存在':true;
            }else{
                return '用户名不正确';
            }
        }elseif(!empty($data['type'])&&$data['type']=='vcode'){
            if (filter_var($value,FILTER_VALIDATE_EMAIL))
                return UserModel::where(['email'=>$value])->count()?true:'用户不存在';
            return true;
        }elseif(!empty($data['type'])&&$data['type']=='register'){
            if ($this->regex($value,'mobile')) {
                return UserModel::where(['mobile'=>$value])->count()?'用户已存在':true;
            }else{
                return '用户名不正确';
            }
        }else{
            if (filter_var($value,FILTER_VALIDATE_EMAIL)){
                return UserModel::where(['email'=>$value])->count()?true:'用户不存在';
            }else if ($this->regex($value,'mobile')) {
                return UserModel::where(['mobile'=>$value])->count()?true:'用户不存在';
            }else{
                return '用户名不正确';
            }
        }
    }
    public static function VerificationEmailSendSum($email)
    {
        //验证每个IP每日发送上限
        if(SmsSendLogModel::where(['type'=>'email','ip'=>request()->ip()])->whereTime('create_time','d')->count() >= config('sms.sms_ip_sum'))
            return '今日获取验证码已达上限';
        //验证每个号码每日发送上限
        if(SmsSendLogModel::where(['username'=>$email])->whereTime('create_time','d')->count() >= config('sms.sms_user_sum'))
            return '今日获取验证码已达上限';
        //限制获取时间间隔
        if(Cache::get('email.time.'.$email) && time()-Cache::get('email.time.'.$email,time()) < config('sms.sms_time'))
            return '请'.(config('sms.sms_time')-(time()-Cache::get('email.time.'.$email,time()))).'秒后重试';
        return false;
    }
    public static function VerificationMobileSendSum($mobile)
    {
        //验证每个IP每日发送上限
        if(SmsSendLogModel::where(['type'=>'mobile','ip'=>request()->ip()])->whereTime('create_time','d')->count() >= config('sms.sms_ip_sum'))
            return '今日获取验证码已达上限';
        //验证每个号码每日发送上限
        if(SmsSendLogModel::where(['username'=>$mobile])->whereTime('create_time','d')->count() >= config('sms.sms_user_sum'))
            return '今日获取验证码已达上限';
        //限制获取时间间隔
        if(Cache::get('mobile.time.'.$mobile) && time()-Cache::get('mobile.time.'.$mobile,time()) < config('sms.sms_time'))
            return '请'.(config('sms.sms_time')-(time()-Cache::get('mobile.time.'.$mobile,time()))).'秒后重试';
        return false;
    }
}