<?php
namespace app\common\validate;

use think\Validate;

class Jobs extends Validate
{
    protected $rule =   [
        'title'                     => 'require|length:2,10',
        'jobs_type'                 => 'require',
        'jobs_area'                 => 'require|array',
        'jobs_cid'                  => 'array',
        'salary'                    => 'array',
        'jobs_desc'                 => 'require|length:2,2000',
        'jobs_welfare'              => 'array',
    ];
    
    protected $message  =   [
        'title.require'                     => '职位名称不能为空', 
        'title.length'                      => '职位名称长度为2~10', 
        'jobs_type.require'                 => '请选择职位类型',
        'jobs_area.require'                 => '请选择职位地区',
        'jobs_area.array'                   => '请选择职位地区',
        'jobs_cid.array'                    => '职位类别格式不正确',
        'salary.array'                      => '薪资格式不正确',
        'jobs_desc.require'                 => '职位详情不能为空', 
        'jobs_desc.length'                  => '职位详情长度为2~2000', 
        'jobs_welfare.array'                => '企业福利格式不正确',
    ];
}