<?php
namespace app\common\validate;

use think\Validate;

class Invoice extends Validate
{
    protected $rule =   [
        'type'                      => 'require',
        'invoice_type'              => 'requireIf:type,1',
        'invoice_title'             => 'requireIf:invoice_type,1|length:2,30',
        'invoice_uscc'              => 'requireIf:invoice_type,1',
        'bank_of_deposit'           => 'requireIf:invoice_type,1',
        'basic_deposit_account'     => 'requireIf:invoice_type,1',
        'reg_address'               => 'requireIf:invoice_type,1',
        'reg_tel'                   => 'requireIf:invoice_type,1',
    ];
    
    protected $message  =   [
        'type.require'                      => '请选择开具发票类型', 
        'invoice_type.requireIf'            => '请选择发票类型', 
        'invoice_title.requireIf'           => '请输入发票抬头', 
        'invoice_title.length'              => '发票抬头长度为2~30位',
        'invoice_uscc.requireIf'            => '请输入税务登记证号', 
        'bank_of_deposit.requireIf'         => '请输入开户银行名称', 
        'basic_deposit_account.requireIf'   => '请输入基本开户账号', 
        'reg_address.requireIf'             => '请输入注册场所地址', 
        'reg_tel.requireIf'                 => '请输入注册固定电话', 
    ];
}