<?php
namespace app\common\validate;

use think\Validate;

class InviteAninterview extends Validate
{
    protected $rule =   [
        'id'                    => 'require',
        'uid'                   => 'require',
        'company_id'            => 'require',
        'contacts'              => 'require',
        'contacts_mobile'       => 'require',
        'address'               => 'require',
        'interview_date'        => 'require',
        'interview_start_time'  => 'require',
        'interview_end_time'    => 'require',
    ];
    
    protected $message  =   [
        'id.require'                    => '数据校验失败，请刷新重试[-101]',
        'uid.require'                   => '请先登录',
        'company_id.require'            => '请先完善企业信息',
        'contacts.require'              => '请输入面试联系人',
        'contacts_mobile.require'       => '请输入联系人手机号',
        'address.require'               => '请输入面试地址',
        'interview_date.require'        => '请选择面试时间',
        'interview_start_time.require'  => '请选择面试时间',
        'interview_end_time.require'    => '请选择面试时间',
    ];
}