<?php
namespace app\common\validate;

use think\Validate;

class CreateContacts extends Validate
{
    protected $rule =   [
        'touid'     => 'require',
        'nickname'  => 'require',
        'headimg'   => 'require',
        'jobs_id'   => 'require',
        'send'      => 'require|array',
        'uid'       => 'require|different:touid'
    ];
    
    protected $message  =   [
        'touid.require'     => '参数错误', 
        'nickname.require'  => '参数错误', 
        'headimg.require'   => '参数错误', 
        'jobs_id.require'   => '未关联职位', 
        'send.require'      => '参数错误', 
        'send.array'        => '参数错误', 
        'uid.require'       => '参数错误', 
        'uid.different'     => '不可以和自己聊天哦', 
    ];
}